import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;

PShader cshader;
float bs;
int nx;
int ny;

void setup() {
  size(1920, 1080, P3D);
  noStroke();
  
  cshader = loadShader("frag.glsl", "vert.glsl");
  
  moonlander = Moonlander.initWithSoundtrack(this, "Demotausta.mp3", 150, 4);
  moonlander.start();
}

void rbox(float s, float rotx, float roty){
  pushMatrix();
  rotateX(rotx * 2 * PI);
  rotateY(roty * 2 * PI);
  box(s);
  popMatrix();
}

void draw() {
  moonlander.update();
  float t = (float) moonlander.getValue("t");
  float s = (float) moonlander.getValue("s");
  float rotx = (float) moonlander.getValue("rotx");
  float roty = (float) moonlander.getValue("roty");
  float rotz = (float) moonlander.getValue("rotz");
  cshader.set("t", t);
  cshader.set("w", width);
  cshader.set("h", width);
  shader(cshader);

  bs= 16;

  nx = int(width / bs) + 2;
  ny = int(height / bs) + 2;
  background(0);
  directionalLight(255, 255, 255, 0, 0, -1);
  
  translate(-bs, -bs/2);
  for(int i=0; i<ny; i++){
    for(int j=0; j<nx; j++){
      float d = sqrt(pow(ny/2 - i, 2) + pow(nx/2 - j, 2));
      float bsize = bs + bs * s * sin(d * t * PI);
      pushMatrix();
      rotateZ(rotz);
      rbox(bsize, rotx, roty);
      popMatrix();
      translate(bs, 0);
    }
    translate(-nx * bs, bs);
  }
  
  rectMode(CENTER);
  rotateZ(rotz);
}
