/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.opengl.PShader;

public class on_the_spectrum
extends PApplet {
    Moonlander moonlander;
    PShader cshader;
    float bs;
    int nx;
    int ny;

    public void setup() {
        this.noStroke();
        this.cshader = this.loadShader("frag.glsl", "vert.glsl");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Demotausta.mp3", (int)150, (int)4);
        this.moonlander.start();
    }

    public void rbox(float s, float rotx, float roty) {
        this.pushMatrix();
        this.rotateX(rotx * 2.0f * (float)Math.PI);
        this.rotateY(roty * 2.0f * (float)Math.PI);
        this.box(s);
        this.popMatrix();
    }

    public void draw() {
        this.moonlander.update();
        float t = (float)this.moonlander.getValue("t");
        float s = (float)this.moonlander.getValue("s");
        float rotx = (float)this.moonlander.getValue("rotx");
        float roty = (float)this.moonlander.getValue("roty");
        float rotz = (float)this.moonlander.getValue("rotz");
        this.cshader.set("t", t);
        this.cshader.set("w", this.width);
        this.cshader.set("h", this.width);
        this.shader(this.cshader);
        this.bs = 16.0f;
        this.nx = PApplet.parseInt((float)((float)this.width / this.bs)) + 2;
        this.ny = PApplet.parseInt((float)((float)this.height / this.bs)) + 2;
        this.background(0);
        this.directionalLight(255.0f, 255.0f, 255.0f, 0.0f, 0.0f, -1.0f);
        this.translate(-this.bs, -this.bs / 2.0f);
        int i = 0;
        while (i < this.ny) {
            int j = 0;
            while (j < this.nx) {
                float d = on_the_spectrum.sqrt((float)(on_the_spectrum.pow((float)(this.ny / 2 - i), (float)2.0f) + on_the_spectrum.pow((float)(this.nx / 2 - j), (float)2.0f)));
                float bsize = this.bs + this.bs * s * on_the_spectrum.sin((float)(d * t * (float)Math.PI));
                this.pushMatrix();
                this.rotateZ(rotz);
                this.rbox(bsize, rotx, roty);
                this.popMatrix();
                this.translate(this.bs, 0.0f);
                ++j;
            }
            this.translate((float)(-this.nx) * this.bs, this.bs);
            ++i;
        }
        this.rectMode(3);
        this.rotateZ(rotz);
    }

    public void settings() {
        this.size(1920, 1080, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"on_the_spectrum"};
        if (passedArgs != null) {
            PApplet.main((String[])on_the_spectrum.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

