#version 330

#include light.ss;

// Textures
uniform sampler2D uDiffuseMap;
uniform sampler2D uIlluminationMap;
uniform sampler2D uRoughnessMap;
uniform sampler2D uMetallicMap;

in vec3 wPosition;
in vec3 fPosition;
in vec3 wNormal;
in vec3 fNormal;
in vec2 fTexCoord;

out vec4 fragColor;

void main()
{	
	vec4 textureColor = texture(uDiffuseMap, fTexCoord);
	vec4 roughnessValue = texture(uRoughnessMap, fTexCoord);
	vec4 metallicValue = texture(uMetallicMap, fTexCoord);
	
	Material mat = getMaterial(metallicValue.x, roughnessValue.x);
	
	fragColor = calculateAllLighting(wPosition
	, fPosition
	, wNormal
	, fNormal
	, textureColor
	, mat);
}



