#version 330

uniform mat4 uProjectionMatrix;
uniform mat4 uWorldMatrix;

in vec3 aPosition;
in vec2 aTexCoord;

out vec2 fTexCoord;

void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	vec4 position  = uProjectionMatrix * uWorldMatrix * vec4(aPosition, 1.0);
	gl_Position =  position;
	fTexCoord = vec2(aTexCoord.x, 1 - aTexCoord.y);
}

