#version 330

// OpenGL 3.0 -> GLSL 1.30
// a projection transformation to apply to the vertex' position
uniform mat4 uProjectionMatrix;
uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;

//uniform mat4 ucNormalRotationMatrix;

// Texture coord offsets
uniform vec2 ucUVoffset1;
uniform vec2 ucUVoffset2;

uniform sampler2D uHeightMap;
//uniform sampler2D uNormalMap;

// attributes of our vertex

in vec3 aPosition;
in vec3 aNormal;
in vec2 aTexCoord;


out vec3 wPosition;
//out vec3 wNormal;

out vec3 fPosition;
//out vec3 fNormal;
out vec3 mapNormal;

out vec2 fTexCoord;

void main()
{	
	vec2 flipTexCoord = vec2(aTexCoord.x, 1 - aTexCoord.y);
	fTexCoord = flipTexCoord;
	
	// Height offset 
	vec3 terrainNormal = mat3(transpose(inverse(uViewMatrix * uWorldMatrix))) * aNormal;
	
	vec2 fTexCoordOff1 = fTexCoord + ucUVoffset1;
	vec2 fTexCoordOff2 = fTexCoord + ucUVoffset2;
	vec4 height1 = texture(uHeightMap, fTexCoordOff1);
	vec4 height2 = texture(uHeightMap, fTexCoordOff2);
	
	
	float heightVariation = 2.0f;
	float heightAdd = (height1.x * 0.8f + height2.x * 1.2f);
	float heightChange = (heightAdd - 2.0f) * heightVariation;
	vec3 modPosition = aPosition + heightChange * terrainNormal;
	
	vec4 worldPos = uWorldMatrix * vec4(modPosition, 1.0);
	vec4 viewPos = uViewMatrix * worldPos;
	
	fPosition = vec3(viewPos);
	wPosition = vec3(worldPos);
	
	// Normal map hack
	/*
	vec3 normal1 = texture(uNormalMap, fTexCoordOff1).rgb * 2.0f - 1.0f;
	vec3 normal2 = texture(uNormalMap, fTexCoordOff2).rgb * 2.0f - 1.0f;
	vec3 mapNormal = normalize(normal1 + normal2);
	
	// Hack. We know that terrain is flat
	mapNormal = mat3(ucNormalRotationMatrix) * mapNormal;
	
	wNormal = mapNormal;
	fNormal = mat3(transpose(inverse(uViewMatrix))) * mapNormal;
	*/
	
	gl_Position =  uProjectionMatrix * viewPos;
}

