/*
 * Decompiled with CFR 0.152.
 */
package org.rajatietotekniikka.dragonsofballpit.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rajatietotekniikka.dragonsofballpit.Demo;
import processing.core.PImage;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0016\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0005R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001d\u00a8\u0006/"}, d2={"Lorg/rajatietotekniikka/dragonsofballpit/utils/SampledImage;", "", "surface", "Lorg/rajatietotekniikka/dragonsofballpit/Demo;", "fileName", "", "scaleOfScreen", "", "backgroundColor", "", "(Lorg/rajatietotekniikka/dragonsofballpit/Demo;Ljava/lang/String;FI)V", "getBackgroundColor", "()I", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "image", "Lprocessing/core/PImage;", "getImage", "()Lprocessing/core/PImage;", "setImage", "(Lprocessing/core/PImage;)V", "loaded", "", "scale", "getScale", "()F", "setScale", "(F)V", "getScaleOfScreen", "getSurface", "()Lorg/rajatietotekniikka/dragonsofballpit/Demo;", "xPos", "getXPos", "setXPos", "yPos", "getYPos", "setYPos", "center", "", "load", "sample", "x", "y", "setFile", "name", "arctic"})
public final class SampledImage {
    private float xPos;
    private float yPos;
    private float scale;
    private boolean loaded;
    @NotNull
    public PImage image;
    @NotNull
    private final Demo surface;
    @NotNull
    private String fileName;
    private final float scaleOfScreen;
    private final int backgroundColor;

    public final float getXPos() {
        return this.xPos;
    }

    public final void setXPos(float f) {
        this.xPos = f;
    }

    public final float getYPos() {
        return this.yPos;
    }

    public final void setYPos(float f) {
        this.yPos = f;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    @NotNull
    public final PImage getImage() {
        PImage pImage = this.image;
        if (pImage == null) {
            Intrinsics.throwUninitializedPropertyAccessException("image");
        }
        return pImage;
    }

    public final void setImage(@NotNull PImage pImage) {
        Intrinsics.checkParameterIsNotNull(pImage, "<set-?>");
        this.image = pImage;
    }

    public final void setFile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (Intrinsics.areEqual(this.fileName, name) ^ true) {
            this.fileName = name;
            this.loaded = false;
        }
    }

    public final void load() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                PImage pImage = this.surface.loadImage(this.fileName, "png");
                Intrinsics.checkExpressionValueIsNotNull(pImage, "surface.loadImage(fileName, \"png\")");
                this.image = pImage;
            }
            catch (Exception e) {
                String string = "***************************";
                System.out.println((Object)string);
                string = "** WARNING!!  Image not found: '" + this.fileName + "': " + e.getMessage();
                System.out.println((Object)string);
                string = "***************************";
                System.out.println((Object)string);
                this.image = new PImage(1, 1, 2);
            }
            float f = (float)this.surface.height * this.scaleOfScreen;
            PImage pImage = this.image;
            if (pImage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("image");
            }
            this.scale = f / (float)pImage.height;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int sample(float x, float y) {
        int n;
        int n2;
        this.load();
        int sampleX = (int)(x / this.scale - this.xPos);
        int sampleY = (int)(y / this.scale - this.yPos);
        PImage pImage = this.image;
        if (pImage == null) {
            Intrinsics.throwUninitializedPropertyAccessException("image");
        }
        if (0 <= (n2 = sampleX) && pImage.width > n2) {
            PImage pImage2 = this.image;
            if (pImage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("image");
            }
            if (0 <= (n2 = sampleY) && pImage2.height > n2) {
                PImage pImage3 = this.image;
                if (pImage3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("image");
                }
                n = pImage3.get(sampleX, sampleY);
                return n;
            }
        }
        n = this.backgroundColor;
        return n;
    }

    public final void center() {
        this.load();
        float f = (float)this.surface.width * 0.5f;
        PImage pImage = this.image;
        if (pImage == null) {
            Intrinsics.throwUninitializedPropertyAccessException("image");
        }
        this.xPos = f - 0.6f * (float)pImage.width * this.scale;
        float f2 = (float)this.surface.height * 0.5f;
        PImage pImage2 = this.image;
        if (pImage2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("image");
        }
        this.yPos = f2 - 0.6f * (float)pImage2.height * this.scale;
    }

    @NotNull
    public final Demo getSurface() {
        return this.surface;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.fileName = string;
    }

    public final float getScaleOfScreen() {
        return this.scaleOfScreen;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public SampledImage(@NotNull Demo surface, @NotNull String fileName, float scaleOfScreen, int backgroundColor) {
        Intrinsics.checkParameterIsNotNull(surface, "surface");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        this.surface = surface;
        this.fileName = fileName;
        this.scaleOfScreen = scaleOfScreen;
        this.backgroundColor = backgroundColor;
        this.scale = 1.0f;
    }

    public /* synthetic */ SampledImage(Demo demo, String string, float f, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            f = 0.5f;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(demo, string, f, n);
    }
}

