function setGeometry(gl, shape)
{
    // Sets a shaped (static) geometry to the gl buffer

    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(shape), gl.STATIC_DRAW);
}

function createShader(gl, type, source)
{
    // Function creates and compiles a webgl shader
    // params:
    //  gl     - WebGL context
    //  type   - GL_FRAGMENT_SHADER or GL_VERTEX_SHADER
    //  source - string containing the shader code
    // return: a handle to the shader

    var shader = gl.createShader(type);
    gl.shaderSource(shader,source);
    gl.compileShader(shader);
    var success = gl.getShaderParameter(shader, gl.COMPILE_STATUS);
    if (success) {
        return shader;
    }

    console.log('createShader('+type+'): '+gl.getShaderInfoLog(shader));
    gl.deleteShader(shader);
}

function createProgram(gl, vertexShader, fragmentShader)
{
    // Function creates a WebGL program
    // params:
    //  gl - WebGL context
    //  vertexShader - handle to a vertex shader
    //  fragmentShader - handle to a fragment shader
    // return: program - handle to the program

    var program = gl.createProgram();
    gl.attachShader(program, vertexShader);
    gl.attachShader(program, fragmentShader);
    gl.linkProgram(program);
    var success = gl.getProgramParameter(program, gl.LINK_STATUS);
    if (success) {
        return program;
    }

    console.log('createProgram: '+gl.getProgramInfoLog(program));
    gl.deleteProgram(program);
}


