class analyzeAudioSource
{
    constructor(src)
    {
        this.audioSource = document.createElement("audio");
        this.audioSource.src = src;
        this.audioSource.type = "audio/wav";
        this.audioSource.loop = true;
        this.audioSource.controls = false;
        this.audioSource.autoplay = true;
        this.audioSource.id = "audioSource";
        document.body.appendChild(this.audioSource);

        this.audioCtx = new AudioContext();
        this.source = this.audioCtx.createMediaElementSource(this.audioSource);
        this.gainNode = this.audioCtx.createGain();
        this.analyserNode = this.audioCtx.createAnalyser();
        this.analyserNode.fftSize = 32;

        this.gainNode.gain.value = 1.;

        this.source.connect(this.gainNode);
        this.gainNode.connect(this.analyserNode);
        this.analyserNode.connect(this.audioCtx.destination);

        this.frequencyTable = new Uint8Array(this.analyserNode.frequencyBinCount);
    }

    updateFrequencies()
    {
        this.analyserNode.getByteFrequencyData(this.frequencyTable);
    }
}
