
USB_ID     = $de08
USB_STATUS = $de09
USB_DATA   = $de0a
EASYFLASH_CONTROL = $de02
EASYFLASH_KILL    = $04
EASYFLASH_16K     = $07
trampoline = $0100
start_addr = $fb
ptr1 = $fd
xfer_size_zp = $20
size_zp = $22
m_size_hi = $07fe
tmp1 = $07ff
p_buff_zp = $24


;this creates a basic start
  *=$0801
;SYS 2064
  .byte $0C,$08,$0A,$00,$9E,$20,$32,$30,$36,$34,$00,$00,$00,$00,$00

usbtool_prg_load_and_run:
  sei
  lda #$b
  sta $d020
  sta $d021
  lda #$c8
  sta $d016
  lda #$15
  sta $d018
; ------------------------------------------------------------------------
; faster replacement for $ff87
;init_system_constants_light:
;  ; from KERNAL @ FD50:
;  lda #$00
;  tay
;dlop:
;  sta $0002,y
;  sta $0200,y
;  sta $0300,y
;  iny
;  bne dlop
;  ldx #$3c
;  ldy #$03
;  stx $b2
;  sty $b3
;  tay
;
;  ; result from loop KERNAL @ FD6C:
;  lda #$00
;  sta $c1
;  sta $0283
;  lda #$a0
;  sta $c2
;  sta $0284
;
;  ; from KERNAL @ FD90:
;  lda #$08
;  sta $0282       ; pointer: bottom of memory for operating system
;  lda #$04
;  sta $0288       ; high byte of screen memory address
;
;
;  jsr $ff8a   ; Restore Kernal Vectors


;ef3usb_fload:
  php
  sei

;  lda #$ff    ; request 64k data
;;request bytes (from XY)
;wait_usb_tx_ok1:
;  bit USB_STATUS
;  bvc wait_usb_tx_ok1
;  sta USB_DATA
;wait_usb_tx_ok2:
;  bit USB_STATUS
;  bvc wait_usb_tx_ok2
;  sta USB_DATA

  ; get number of bytes actually there
wait_usb_rx_ok1:
  inc $d020
  bit USB_STATUS
  bpl wait_usb_rx_ok1
  lda USB_DATA      ; low byte of transfer size
  sec
  sbc #2      ; minus start address
  tax
  stx size_zp
  stx $0502
wait_usb_rx_ok2:
  bit USB_STATUS
  bpl wait_usb_rx_ok2
  ldy USB_DATA      ; high byte of transfer size
  bcs no_wrap      ; from sbc
  dey
no_wrap:
  sty size_zp + 1
  sty $0503
  bne loadCont
  cpx #0      ; check for EOF
  beq end_load    ; 0 bytes == EOF
loadCont:
  txa
  eor #$ff
  tax
  tya
  eor #$ff
  sta xfer_size_zp + 1    ; calc -size - 1

  txa
  clc
  adc #1      ; calc -size
  sta xfer_size_zp
  lda xfer_size_zp + 1
  adc #0
  sta xfer_size_zp + 1
  beq end_load    ; file too short?

;read start address
wait_usb_rx_ok3:
  bit USB_STATUS
  bpl wait_usb_rx_ok3
  lda USB_DATA
  sta p_buff_zp
  sta start_addr
  sta $0500
wait_usb_rx_ok4:
  bit USB_STATUS
  bpl wait_usb_rx_ok4
  lda USB_DATA
  sta p_buff_zp + 1
  sta start_addr + 1
  sta $0501

  lda $01
  sta tmp1

  ldy #0
get_bytes:
wait_usb_rx_ok5:
  bit USB_STATUS
  bpl wait_usb_rx_ok5
  lda USB_DATA
  ldx #$33    ; hide I/O
  stx $01
  sta (p_buff_zp), y
  ldx #$37    ; show I/O
  stx $01
  sta $0400,y
  iny
  bne inc_counter
  inc p_buff_zp + 1
inc_counter:
  inc xfer_size_zp
  bne get_bytes
  inc xfer_size_zp + 1
  bne get_bytes
end_load:
  lda tmp1
  sta $01
  plp


;set end addr + 1 to $2d and $ae
  lda start_addr
  clc
  adc ptr1
  sta $2d
  sta $ae
  sta start_addr + 1
  adc ptr1 + 1
  sta $2e
  sta $af

;  jsr ef3usb_fclose
;ef3usb_fclose:
  lda #0
wait_usb_tx_ok3:
  bit USB_STATUS
  bvc wait_usb_tx_ok3
  sta USB_DATA
wait_usb_tx_ok4:
  bit USB_STATUS
  bvc wait_usb_tx_ok4
  sta USB_DATA

  jmp $0900

;  ; start the program
;  ; looks like BASIC?
;  lda start_addr
;  ldx start_addr + 1
;  cmp #<$0801
;  bne no_basic
;  cpx #>$0801
;  bne no_basic
;  ldx #4
;  sta $d020
;
;  ; === start basic ===
;  ldx #basic_starter_end - basic_starter
;copy_tramp:
;  lda basic_starter,x
;  sta trampoline,x
;  dex
;  bpl copy_tramp
;  bmi run_it
;
;  ; === start machine code ===
;no_basic:
;  ldx #$7
;  sta $d020
;  ldx #asm_starter_end - asm_starter
;copy_tramp2:
;  lda asm_starter,x
;  sta trampoline,x
;  dex
;  bpl copy_tramp2
;
;  lda start_addr
;  sta trampoline_jmp_addr + 1
;  lda start_addr + 1
;  sta trampoline_jmp_addr + 2
;run_it:
;  lda #EASYFLASH_KILL
;  jmp trampoline
;
;; =============================================================================
;basic_starter:
;RORG trampoline
;  sta EASYFLASH_CONTROL
;  jsr $ff81   ; Initialize screen editor
;  ; for BASIC programs
;  jsr $e453     ; Initialize Vectors
;  jsr $e3bf     ; Initialize BASIC RAM
;  jsr $a659  ; Basic-Zeiger setzen und CLR
;  jmp $a7ae  ; Interpreterschleife (RUN)
;basic_starter_end:
;REND
;
;; =============================================================================
;asm_starter:
;RORG trampoline
;  sta EASYFLASH_CONTROL
;  jsr $ff81   ; Initialize screen editor
;  ; for BASIC programs (here too?)
;  jsr $E453     ; Initialize Vectors
;  jsr $E3BF     ; Initialize BASIC RAM
;trampoline_jmp_addr:
;  jmp $beef
;asm_starter_end:
;REND






; =============================================================================
;
; =============================================================================
;.macro wait_usb_tx_ok
;:
;  bit USB_STATUS
;  bvc :-
;.endmacro


; =============================================================================
;
; =============================================================================
;.macro wait_usb_rx_ok
;:
;  bit USB_STATUS
;  bpl :-
;.endmacro
;
;
;
;
;_ef3usb_send_data:
;  sta size_zp
;  stx size_zp + 1   ; Save size
;
;  ;jsr popax
;  pla
;  tax
;  pla
;
;  sta p_buff_zp
;  stx p_buff_zp + 1       ; Save buffer address
;
;  lda size_zp
;  eor #$ff
;  tax
;  lda size_zp + 1
;  eor #$ff
;  sta m_size_hi     ; calc -size - 1
;  ldy #0
;  jmp inc_counter_send   ; inc to get -size
;
;byte_loop:
;  lda (p_buff_zp), y
;
;  ; xy contains number of bytes to be xfered (x = low byte)
;wait_usb_tx_ok5:
;  bit USB_STATUS
;  bvc wait_usb_tx_ok5
;  sta USB_DATA
;  iny
;  bne inc_counter_send
;  inc p_buff_zp + 1
;inc_counter_send:
;  inx
;  bne byte_loop
;  inc m_size_hi
;  bne byte_loop
;
;  rts


