import moonlander.library.*;

// Minim must be imported when using Moonlander with soundtrack.
import ddf.minim.*;

Moonlander moonlander;

PGraphics pg;
float rainXs[];
float rainYs[];
float rainSc[];
float trailX[];
float trailY[];
int rainBottom = 1200;
int WIDTH = 1920;
int HEIGHT = 1080;
float clouds[];

void setup() {
    // Parameters: 
    // - PApplet
    // - soundtrack filename (relative to sketch's folder)
    // - beats per minute in the song
    // - how many rows in Rocket correspond to one beat
    moonlander = Moonlander.initWithSoundtrack(this, "data/returnToBasis.mp3", 140, 8);

    // Other initialization code goes here.
    //size(640, 360, P3D);
    fullScreen(P3D);
    noCursor();
    frameRate(60);

    // Last thing in setup; start Moonlander. This either
    // connects to Rocket (development mode) or loads data 
    // from 'syncdata.rocket' (player mode).
    // Also, in player mode the music playback starts immediately.
    moonlander.start();
    
    pg = createGraphics(WIDTH, HEIGHT, P3D);
    
    rainXs = new float[1000];
    rainYs = new float[1000];
    rainSc = new float[1000];
    trailX = new float[1000];
    trailY = new float[1000];
    for (int i = 0; i < 1000; i++) {
      rainXs[i] = random(0,1777);
      rainYs[i] = rainBottom;
      rainSc[i] = random(100,300);
      trailX[i] = random(1777/2 - 50, 1777/2 + 50);
      trailY[i] = 500;
    }
    
    float increment = 0.02;
    float xoff = 0.0; // Start xoff at 0
    float detail = 0.6;
    noiseDetail(8, detail);

    clouds = new float[width*height];
    // For every x,y coordinate in a 2D space, calculate a noise value and produce a brightness value
    for (int x = 0; x < width; x++) {
      xoff += increment;   // Increment xoff 
      float yoff = 0.0;   // For every xoff, start yoff at 0
      for (int y = 0; y < height; y++) {
        yoff += increment; // Increment yoff
        
        // Calculate noise and scale by 255
        float bright = noise(xoff, yoff);
  
        // Try using this line instead
        //float bright = random(0,255);
        
        // Set each pixel onscreen to a grayscale value
        clouds[x+y*width] = bright;
      }
    }

}

int num = 12;            // Number of boxes
float offset = PI/24.0;  // Angle offset between boxes
int oldRow = 0;
int copyCount = 0;
int oldRain = 0;

void draw() {
    // Handles communication with Rocket. In player mode
    // does nothing. Must be called at the beginning of draw().
    moonlander.update();
    translate(0, 0);
    int newRow = (int)moonlander.getCurrentRow();
    //oldRow = newRow;
    float screen = (float)moonlander.getValue("screen");
    background(screen, screen, min(screen+26, 255));
    scale(height/1000.0);
    float ang = (float)moonlander.getValue("ang");
    noStroke();
    
    loadPixels();
      
    //if (screen > 0) {
        for (int x = 0; x < width; x++) {
          for (int y = 0; y < height; y++) {
            float bright = clouds[x+y*width];
            pixels[x+y*width] = color(bright * screen, bright * screen, (bright * screen+26));
          }
        }
    //}
    
    updatePixels();

    
    pg.beginDraw();
    pg.clear();
    pg.scale(pg.height/1000.0);
    //float cZ = ((height/2.0) / tan(PI*60.0/360.0));
    //pg.perspective(PI/3.0, pg.width/pg.height, cZ/10.0, cZ*1000.0);
    float strokeHue = (float)moonlander.getValue("strokeHue");
    float strokeBright = (float)moonlander.getValue("strokeBright");
    pg.colorMode(HSB);
    pg.stroke(strokeHue, 255, strokeBright);
    pg.colorMode(RGB);
    float thick = (float)moonlander.getValue("thick");
    pg.strokeWeight(thick);

    float ambient = (float)moonlander.getValue("ambient");
    pg.ambientLight(ambient, ambient, ambient);
    float lightDir = (float)moonlander.getValue("lightDir");
    float lightY = -cos(lightDir);
    float lightZ = -sin(lightDir);
    pg.directionalLight(255, 255, 255, 0, lightY, lightZ);
    pg.translate(0, 0, 0); 
    
    int spinnyMode = moonlander.getIntValue("spinnyMode");
    int fillColor = moonlander.getIntValue("fillColor");
    for(int i = 0; i < num; i++) {
      float gray = map(sin(2*PI*i/num), -1, 0, 0.8, 1);
      pg.pushMatrix();
      if (ambient > 250)
        pg.noFill();
      else
        pg.fill(fillColor * gray);
      float ang1 = ang;
      float ang2 = ang/2;
      if (spinnyMode == 1 && i % 2 == 0) {
        ang1 = ang/2;
        ang2 = ang;
      }
      pg.rotateY(ang1 + offset*i);
      pg.rotateX(ang2 + offset*i);
      pg.box(map(thick, 1, 10, 300, 400));
      pg.popMatrix();
    }
    
    double cameraX = moonlander.getValue("cameraX");
    double cameraY = moonlander.getValue("cameraY");
    double cameraZ = moonlander.getValue("cameraZ");
    double targetX = moonlander.getValue("targetX");
    double targetY = moonlander.getValue("targetY");
    double targetZ = moonlander.getValue("targetZ");
    pg.camera((float)cameraX, (float)cameraY, (float)cameraZ, (float)targetX, (float)targetY, (float)targetZ, 0.0, 1.0, 0.0);
    pg.endDraw();
    
    int rain = moonlander.getIntValue("rain");
    imageMode(CENTER);
    for (int i = 0; i < rain; i++) {
      rainYs[i] -= (newRow > 1352) ? 30 : 10;
      image(pg, rainXs[i], rainYs[i], rainSc[i] * 1.77, rainSc[i]);
    }
    for (int i = rain; i < 1000; i++) {
      rainYs[i] = rainBottom;
    }

    int trail = moonlander.getIntValue("trail");
    int mainCubeX = moonlander.getIntValue("mainCubeX");
    int mainCubeY = moonlander.getIntValue("mainCubeY");
    float x = (mainCubeX == 0) ? sin(PI * trail / 16) * 300: 0;
    for (int i = 0; i < trail; i++) {
      trailY[i] += 50;
      tint(255, map(trailY[i], 500, rainBottom, 192, 0));
      image(pg, mainCubeX + x + trailX[i], mainCubeY + trailY[i], map(trailY[i], 500, rainBottom, WIDTH * 0.75, 32), map(trailY[i], 500, rainBottom, WIDTH * 0.75, 32));
    }
    for (int i = trail; i < 1000; i++) {
      trailY[i] = 500;
    }

    tint(255);
    imageMode(CORNERS);
    image(pg,mainCubeX + x,mainCubeY, mainCubeX+x+1777, mainCubeY+1000);

    int copy = moonlander.getIntValue("copy");
    for (int i = 0; i < copyCount; i++) {
      image(pg, i*88, 0, 1777, 1000 - (i*50));
    }
    if (copy > 0)
      copyCount++;
    else
      copyCount = 0;
      
    float textAlpha = (float)moonlander.getValue("textAlpha");
    fill(64, 0, 0, textAlpha);
    textSize(50);
    text("Demo by pasmpasm\nMade for Graffaton 2019\nMusic: Return to the basis\n   by Soft and Furious", 1000, 120);
    
    if (newRow > 1870)
      exit();
}
