import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class rumademo extends PApplet {



// Minim must be imported when using Moonlander with soundtrack.


Moonlander moonlander;

int c1 = 0xffA19EFF;
int c2 = 0xff94CCEB;
int c3 = 0xff8CFFD7;
int c4 = 0xffA1F598;
int c5 = 0xffFFFF80;

int[] colors = new int[]{c1, c2, c3, c4, c5};

int bg_red = 0;
int bg_green = 0;
int bg_blue = 0;

public void setup() {
    // Parameters: 
    // - PApplet
    // - soundtrack filename (relative to sketch's folder)
    // - beats per minute in the song
    // - how many rows in Rocket correspond to one beat
    moonlander = Moonlander.initWithSoundtrack(this, "data/exit_the_premises_short.mp3", 128, 8);
    // moonlander = new Moonlander(this, new TimeController(4));

    // Other initialization code goes here.
    
    //size(640, 360);
    background(0);
    noCursor();
    moonlander.start("localhost", 1338, "data/syncdata.rocket");
}

public void draw() {
    // Handles communication with Rocket. In player mode
    // does nothing. Must be called at the beginning of draw().
    moonlander.update();
    //background(0);
    
    int scene = moonlander.getIntValue("scene");

    if (scene == 0) {
      intro();
    } else if (scene == 1){
      scene1();
    } else if (scene == 2){
      scene2();
    } else if (scene == 3){
      scene3();
    } else if (scene == 4){
      scene4();
    } else if (scene == 5){
      scene5();
    } else if (scene == 6){
      scene6();
    }

}

public void scene1(){
  hexagonGrid();
}

public void scene2(){
  drawManyTriangles();
} 

public void scene3(){
    background(0);
    int size = 5;
    //int size = moonlander.getIntValue("size");
    int n = 5;
    //int n = moonlander.getIntValue("n")
    float trianglesX = 0.01f*width;
    float trianglesY = 0.01f*height;
    float widthKerroin = 1 / trianglesX;
    float heightKerroin = 1 / trianglesY;

    for(float i=0; i <= 1; i+=widthKerroin){
      for (float j=0; j <= 1; j+=heightKerroin){ 
        drawTriangles(n, i, j, size);
      }
    }
}

public void scene4(){
  int state = moonlander.getIntValue("state");
  int startRow = 872;
  int row = (int) moonlander.getCurrentRow();
  if(row < 1152){
      background(0);
  } 
  int rowDelta = row - startRow + 75;
  float insideRadius = (rowDelta/10);
  float outsideRadius = (rowDelta/10);
  for(int i=4; i <= 40; i+=2){
    pushMatrix();
    translate(width/2, height/2);
    rotate(rowDelta);
    triangleStrip(i, insideRadius, outsideRadius);
    insideRadius = 1.2f*insideRadius;
    outsideRadius = 1.2f*outsideRadius; 
    fill(colors[i % colors.length], state);    
    popMatrix();
  }
}

public void scene5() {
  expandingCircle();
}

double startRow5 = -1;
double dynStartRow = -1;
int prevState = -1;

public void scene6() {
  background(0);
  if (startRow5 == -1) {
    startRow5 = moonlander.getCurrentTime();
  }
  
  float deltaRow = (float)(startRow5 - moonlander.getCurrentTime())/2.13f;
  
  int state = moonlander.getIntValue("state");
  float div = (state + 1)*10.0f;
  float vertexRadius = width/div;
  float edgeRadius = vertexRadius/2 * tan(TWO_PI/6);
  
  float radMod = (cos(4*(float)deltaRow) + 9)/10.0f;
  float hPad = 1.5f*vertexRadius;
  float wPad = 2*edgeRadius;
  
  
 //tie speed to the width
 if (state == 8 && prevState == 7) {
   dynStartRow = moonlander.getCurrentTime();
 }
 prevState = state;
 float dynDelta = (float)(moonlander.getCurrentTime() - dynStartRow);
 
 float x = (dynDelta)*(width/2) - (width);
 float max_distance = dist(0, 0, width, height);
  
  int k = 0;
  int p = 0;
  int n = 0;
  
  for(float i = 0; i < height + hPad; i+= hPad) {
    if(k%2==0) {
      resetMatrix();
      
    } else {
     translate(edgeRadius, 0);
    }
    
    for (float d =0; d <= width + wPad; d+= wPad) {
      pushMatrix();
      translate(d, i);
      if (state >= 1) {
        rotate(-(2.0f/3)*deltaRow);
      }
      
      if(state <= 1) {
        fill(colors[4]);
      } else if (state == 2) {
        fill(colors[(k%5)]);
      } else if(state < 5) {
        fill(colors[((k*n + p)%5)]);
      } else {
        fill(colors[(k%5)], random(255));
      }
      if (state >= 8) {
        float size = dist(x, height-i, d, i);
        float maxSize = radMod*vertexRadius;
        size = min(size/max_distance * maxSize, maxSize);
        if (d > x) {
          polygon(0, 0, size, 6, PI/2);
        }
      } else {
        polygon(0, 0, radMod*vertexRadius, 6, PI/2);
      }
      
      popMatrix();
      
      p++;
    }
    k++;
    n = max(k, n);
  }
}

public void drawTriangles(int n, float widthKerroin, float heightKerroin, int size){
    int x = 0;
    int y = 0;
    float multip = 0.001f*height ;
    float rowCount = (float)moonlander.getCurrentRow() * 8;
    float rotation = (sin(rowCount/ 25.0f) + sin(rowCount/ -75.0f));

    pushMatrix();
    translate(width*widthKerroin, height*heightKerroin);
    rotate(rotation);
    for(int i=0; i <= n; i++){ 
      polygon(x, y, multip*size, 3);
      fill(colors[i % colors.length]);
      x+=20;
      y+=20;
      multip += 0.1f;
    }
    popMatrix();
    
}

public void polygon(float x, float y, float radius, int npoints, float sAngle) {
  float angle = TWO_PI / npoints;
  beginShape();
  for (float a = sAngle; a < TWO_PI + sAngle; a += angle) {
    float sx = x + cos(a) * radius;
    float sy = y + sin(a) * radius;
    vertex(sx, sy);
  }
  endShape(CLOSE);
}

public void polygon(float x, float y, float radius, int npoints) {
  polygon(x, y, radius, npoints, 0);  
}

public void triangleStrip(int sides, float outsideRadius, float insideRadius){
    int x = 0;
    int y = 0;
    float angle = 0;
    float angleStep = 180.0f / sides;
    
    beginShape(TRIANGLE_STRIP); 
    for (int i = 0; i <= sides; i++) {
      float px = x + cos(radians(angle)) * outsideRadius;
      float py = y + sin(radians(angle)) * outsideRadius;
      angle += angleStep;
      vertex(px, py);
      px = x + cos(radians(angle)) * insideRadius;
      py = y + sin(radians(angle)) * insideRadius;
      vertex(px, py); 
      angle += angleStep;
    }
    endShape();
}

public void drawManyTriangles(){
  int row = (int) moonlander.getCurrentRow();
  //check exact row
  if(row >= 384){
    drawColorfulTriangles();
  } else {
    drawBlackTriangles();
  } 
}

public void drawColorfulTriangles(){
  int startRow = 248;
  int rowDelta = (int) moonlander.getCurrentRow() - startRow;
  float randX = random(width);
  float randY = random(height);
  for(int i=0; i<=rowDelta; i++){
    polygon(randX, randY, random(width*0.1f), 3);
    fill(colors[(int)random(5)]);
    
  }
}

public void drawBlackTriangles(){
  float randX = random(width);
  float randY = random(height);
  polygon(randX, randY, random(width*0.2f), 3);
  fill(random(150), random(150));
}

public void expandingCircle(){
  int state = moonlander.getIntValue("state");
  int startRow = 1384;
  int size = ((int)moonlander.getCurrentRow() - startRow)*width/16;
  fill(255, state);
  circle(width/2, height/2, size);
}

public void hexagonGrid(){
   int startRow = 136;
   int row = (int) moonlander.getCurrentRow();
   //tie speed to the width
   int x = (row - startRow)*(width/64);
   float max_distance = dist(0, 0, width, height);
   if (row % 2 == 0){
     for(int i = 0; i <= x; i += 20) {
      for(int j = 0; j <= height; j += 20) {
        float size = dist(x, height-j, i, j);
        size = size/max_distance * 15;
        polygon(i, j, size, 6);
        fill(colors[(int)random(5)]);
      }
    }
  }
}

public void intro() {
  background(bg_red, bg_green, bg_blue);
  boolean blink = moonlander.getIntValue("beat") == 1;
  blinkScreen(blink);
}

public void blinkScreen(boolean blink) {
  int k = 10;
  if(blink) {
    bg_red =255; bg_green=255; bg_blue=255; 
  } else {
    bg_red -=k; bg_green-=k; bg_blue-=k; 
  }

}
  public void settings() {  fullScreen(); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#666666", "--hide-stop", "rumademo" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
