#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <math.h>

#include <SDL2/SDL.h>
#include <GL/gl.h>

#include "shaders.h"

#define FULLSCREEN
SDL_Window* window = NULL;
char* title = "Not Voxels";
int start = 0;
SDL_GLContext glcontext;
SDL_Event event;
GLuint program = 0;
GLuint post = 0;
GLuint framebuffer = 0;
int time = 0;
const int clipLen = 40 * 1000;
GLuint texture0 = 0;
GLuint texture1 = 1;

#include "syna.h"

GLfloat verts[] = {
	-1.0f, -1.0f, 0.0f, -1.0f, -1.0f,
	1.0f, -1.0f, 0.0f, 1.0f, -1.0f,
	-1.0f, 1.0f, 0.0f, -1.0f, 1.0f,
	1.0f, 1.0f, 0.0f, 1.0f, 1.0f
};

GLuint idx[] = {
	0, 1, 2,
	2, 1, 3
};

SDL_AudioSpec audio;

void createShader(GLint shaderType, const char* shadercode, GLuint prog)
{
	GLint success;
	GLchar info[1024];
	GLuint shader;
	static int count = 0;
	shader = glCreateShader(shaderType);
	glShaderSource(shader, 1, &shadercode, 0);
	glCompileShader(shader);
	glAttachShader(prog, shader);

	glGetShaderiv(shader, GL_COMPILE_STATUS, &success);
	if (!success) {
		glGetShaderInfoLog(shader, 1024, NULL, info);
		printf("ERROR SHADER %d compiling failed\n%s\n", count++, info);
		exit(0);
	}
}

void initShader()
{
	GLint success;
	GLchar info[1024];
	
	program = glCreateProgram();
	createShader(GL_VERTEX_SHADER, vshader, program);
	createShader(GL_FRAGMENT_SHADER, fshader, program);

	glLinkProgram(program);

	glGetProgramiv(program, GL_LINK_STATUS, &success);
	if (!success) {
		glGetProgramInfoLog(program, 1024, NULL, info);
		printf("ERROR SHADER linking failed\n%s\n",info);
	}

	glUseProgram(program);

	post = glCreateProgram();
	createShader(GL_VERTEX_SHADER, vshader, post);
	createShader(GL_FRAGMENT_SHADER, fpost, post);

	glLinkProgram(post);

	glGetProgramiv(post, GL_LINK_STATUS, &success);
	if (!success) {
		glGetProgramInfoLog(post, 1024, NULL, info);
		printf("ERROR POST SHADER linking failed\n%s\n",info);
	}

	glUseProgram(post);
}

void setBuffers()
{
	GLuint VAO, VBO, IBO;
	glGenVertexArrays(1, &VAO);
	glBindVertexArray(VAO);

	glGenBuffers(1, &VBO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, sizeof(verts), verts, GL_STATIC_DRAW);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), (GLvoid*)0);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), (GLvoid*) (3 * sizeof(GLfloat)));
	glEnableVertexAttribArray(1);

	glGenBuffers(1, &IBO);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, IBO);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(idx), idx, GL_STATIC_DRAW);

	glGenFramebuffers(1, &framebuffer);
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);

	glGenTextures(1, &texture0);
	glBindTexture(GL_TEXTURE_2D, texture0);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB16F, 1920, 1080, 0, GL_RGB, GL_FLOAT, NULL);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, texture0);
	
	glGenTextures(1, &texture1);
	glBindTexture(GL_TEXTURE_2D, texture1);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB16F, 1920, 1080, 0, GL_RGB, GL_FLOAT, NULL);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT1, GL_TEXTURE_2D, texture1);
}

void update()
{
	glUseProgram(program);
	glUniform1i(2, time);
	glUseProgram(post);
	glUniform1i(1, time);
}

void render()
{
	glUseProgram(program);
	glClearColor(0,0,0,1);
	glClear(GL_COLOR_BUFFER_BIT);
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, 0);

	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glUseProgram(post);
	glClearColor(0,0,0,1);
	glClear(GL_COLOR_BUFFER_BIT);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, texture0);
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, texture1);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, 0);
}

int main()
{
	SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_TIMER);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 4);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK, SDL_GL_CONTEXT_PROFILE_CORE);
	window = SDL_CreateWindow(title, SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 1920, 1080, SDL_WINDOW_OPENGL);
	glcontext = SDL_GL_CreateContext(window);
#ifdef FULLSCREEN
	SDL_SetWindowFullscreen(window, SDL_WINDOW_FULLSCREEN);
#else
	SDL_SetWindowFullscreen(window, 0);
#endif
	//SDL_SetWindowFullscreen(window, SDL_WINDOW_FULLSCREEN_DESKTOP);

	initShader();
	setBuffers();

	SDL_memset(&audio, 0, sizeof(audio));
	audio.freq = 44100;
	audio.format = AUDIO_U8;
	audio.channels = 2;
	audio.samples = 1024;
	audio.callback = syna;

	SDL_OpenAudio(&audio, NULL);

	SDL_ShowCursor(0);
	SDL_PauseAudio(0);
	start = SDL_GetTicks();
	while(1)
	{
		time = SDL_GetTicks() - start;
		if(time > clipLen)
			break;
		update();
		render();
		SDL_GL_SwapWindow(window);
		while(SDL_PollEvent(&event))
		{
			if(event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE)
			{
				printf("Closing!\n");
				start = -clipLen;
			}
		}
	}

	SDL_DestroyWindow(window);
	SDL_GL_DeleteContext(glcontext); 
	SDL_Quit();
	return 0;
}
