import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.effects.*; 
import ddf.minim.signals.*; 
import ddf.minim.spi.*; 
import ddf.minim.ugens.*; 
import kotlin.collections.*; 
import kotlin.jvm.internal.*; 
import kotlin.coroutines.*; 
import kotlin.coroutines.intrinsics.*; 
import kotlin.coroutines.jvm.internal.*; 
import kotlin.*; 
import kotlin.io.*; 
import kotlin.internal.*; 
import kotlin.random.*; 
import kotlin.js.*; 
import kotlin.reflect.*; 
import kotlin.jvm.*; 
import kotlin.jvm.internal.markers.*; 
import kotlin.jvm.internal.unsafe.*; 
import kotlin.jvm.functions.*; 
import kotlin.system.*; 
import kotlin.contracts.*; 
import kotlin.sequences.*; 
import kotlin.comparisons.*; 
import kotlin.text.*; 
import kotlin.experimental.*; 
import kotlin.concurrent.*; 
import kotlin.properties.*; 
import kotlin.annotation.*; 
import kotlin.ranges.*; 
import kotlin.math.*; 
import kotlin.coroutines.experimental.*; 
import kotlin.coroutines.experimental.intrinsics.*; 
import kotlin.coroutines.experimental.migration.*; 
import kotlin.coroutines.experimental.jvm.internal.*; 
import org.intellij.lang.annotations.*; 
import org.jetbrains.annotations.*; 
import tornadofx.adapters.*; 
import tornadofx.*; 
import tornadofx.osgi.*; 
import sun.net.www.protocol.css.*; 
import tornadofx.osgi.impl.*; 
import org.glassfish.json.*; 
import org.glassfish.json.api.*; 
import javax.json.*; 
import javax.json.spi.*; 
import javax.json.stream.*; 
import kotlin.internal.jdk8.*; 
import kotlin.text.jdk8.*; 
import kotlin.collections.jdk8.*; 
import kotlin.streams.jdk8.*; 
import kotlin.internal.jdk7.*; 
import kotlin.jdk7.*; 
import kotlin.reflect.full.*; 
import kotlin.reflect.jvm.*; 
import kotlin.reflect.jvm.internal.*; 
import kotlin.reflect.jvm.internal.components.*; 
import kotlin.reflect.jvm.internal.impl.builtins.*; 
import kotlin.reflect.jvm.internal.impl.builtins.functions.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.impl.*; 
import kotlin.reflect.jvm.internal.impl.incremental.*; 
import kotlin.reflect.jvm.internal.impl.incremental.components.*; 
import kotlin.reflect.jvm.internal.impl.load.java.*; 
import kotlin.reflect.jvm.internal.impl.load.java.components.*; 
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.*; 
import kotlin.reflect.jvm.internal.impl.load.java.sources.*; 
import kotlin.reflect.jvm.internal.impl.load.java.structure.*; 
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.*; 
import kotlin.reflect.jvm.internal.impl.load.kotlin.*; 
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.*; 
import kotlin.reflect.jvm.internal.impl.metadata.*; 
import kotlin.reflect.jvm.internal.impl.metadata.builtins.*; 
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.metadata.jvm.*; 
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.name.*; 
import kotlin.reflect.jvm.internal.impl.platform.*; 
import kotlin.reflect.jvm.internal.impl.protobuf.*; 
import kotlin.reflect.jvm.internal.impl.renderer.*; 
import kotlin.reflect.jvm.internal.impl.resolve.*; 
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.*; 
import kotlin.reflect.jvm.internal.impl.resolve.constants.*; 
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.*; 
import kotlin.reflect.jvm.internal.impl.resolve.jvm.*; 
import kotlin.reflect.jvm.internal.impl.resolve.scopes.*; 
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.*; 
import kotlin.reflect.jvm.internal.impl.serialization.*; 
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.storage.*; 
import kotlin.reflect.jvm.internal.impl.types.*; 
import kotlin.reflect.jvm.internal.impl.types.checker.*; 
import kotlin.reflect.jvm.internal.impl.types.error.*; 
import kotlin.reflect.jvm.internal.impl.types.typeUtil.*; 
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.*; 
import kotlin.reflect.jvm.internal.impl.util.*; 
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.*; 
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.*; 
import kotlin.reflect.jvm.internal.impl.utils.*; 
import kotlin.reflect.jvm.internal.pcollections.*; 
import kotlin.reflect.jvm.internal.structure.*; 
import com.github.thomasnield.rxkotlinfx.*; 
import io.reactivex.rxjavafx.observables.*; 
import io.reactivex.rxjavafx.sources.*; 
import io.reactivex.rxjavafx.observers.*; 
import io.reactivex.rxjavafx.schedulers.*; 
import io.reactivex.rxjavafx.subscriptions.*; 
import io.reactivex.rxjavafx.transformers.*; 
import io.reactivex.*; 
import io.reactivex.parallel.*; 
import io.reactivex.processors.*; 
import io.reactivex.exceptions.*; 
import io.reactivex.disposables.*; 
import io.reactivex.subjects.*; 
import io.reactivex.internal.fuseable.*; 
import io.reactivex.internal.disposables.*; 
import io.reactivex.internal.subscriptions.*; 
import io.reactivex.internal.observers.*; 
import io.reactivex.internal.operators.maybe.*; 
import io.reactivex.internal.operators.parallel.*; 
import io.reactivex.internal.operators.completable.*; 
import io.reactivex.internal.operators.single.*; 
import io.reactivex.internal.operators.observable.*; 
import io.reactivex.internal.operators.flowable.*; 
import io.reactivex.internal.subscribers.*; 
import io.reactivex.internal.queue.*; 
import io.reactivex.internal.functions.*; 
import io.reactivex.internal.schedulers.*; 
import io.reactivex.internal.util.*; 
import io.reactivex.observers.*; 
import io.reactivex.subscribers.*; 
import io.reactivex.annotations.*; 
import io.reactivex.plugins.*; 
import io.reactivex.functions.*; 
import io.reactivex.schedulers.*; 
import io.reactivex.flowables.*; 
import io.reactivex.observables.*; 
import org.reactivestreams.*; 
import com.beust.klaxon.*; 
import com.beust.klaxon.token.*; 
import com.beust.klaxon.internal.*; 
import org.mistutils.raster.*; 
import org.mistutils.raster.multi.*; 
import org.mistutils.random.*; 
import org.mistutils.classes.*; 
import org.mistutils.color.colorspace.*; 
import org.mistutils.color.*; 
import org.mistutils.color.colortype.*; 
import org.mistutils.geometry.int3.*; 
import org.mistutils.geometry.double2.*; 
import org.mistutils.geometry.double3.*; 
import org.mistutils.geometry.rectangle.*; 
import org.mistutils.geometry.volume.*; 
import org.mistutils.geometry.intvolume.*; 
import org.mistutils.geometry.int2.*; 
import org.mistutils.geometry.grid.*; 
import org.mistutils.collections.map2d.*; 
import org.mistutils.collections.*; 
import org.mistutils.collections.space.*; 
import org.mistutils.collections.bag.*; 
import org.mistutils.collections.ringbuffer.*; 
import org.mistutils.logic.*; 
import org.mistutils.files.*; 
import org.mistutils.strings.*; 
import org.mistutils.checking.*; 
import org.mistutils.symbol.*; 
import org.mistutils.lang.*; 
import org.mistutils.lang.serialization.*; 
import org.mistutils.lang.tweakfun.*; 
import org.mistutils.lang.tweakfun.functions.*; 
import org.mistutils.ui.*; 
import org.mistutils.updating.*; 
import org.mistutils.updating.strategies.*; 
import org.mistutils.field.*; 
import org.mistutils.field.featurefields.*; 
import org.mistutils.field.featurefields.typestrategies.*; 
import org.mistutils.field.featurefields.placementstrategies.*; 
import org.mistutils.field.valuefields.*; 
import org.mistutils.field.valuefields.sampling.*; 
import org.mistutils.field.objectfields.*; 
import org.mistutils.service.*; 
import org.mistutils.time.*; 
import org.mistutils.varying.*; 
import org.mistutils.interpolation.interpolators.*; 
import org.mistutils.interpolation.mixers.*; 
import org.mistutils.interpolation.*; 
import org.mistutils.interpolation.gradient.*; 
import org.mistutils.math.*; 
import org.mistutils.properties.*; 
import org.mistutils.noise.*; 
import impl.org.controlsfx.autocompletion.*; 
import impl.org.controlsfx.behavior.*; 
import impl.org.controlsfx.i18n.*; 
import impl.org.controlsfx.*; 
import impl.org.controlsfx.skin.*; 
import impl.org.controlsfx.spreadsheet.*; 
import impl.org.controlsfx.table.*; 
import impl.org.controlsfx.tools.*; 
import impl.org.controlsfx.tools.rectangle.change.*; 
import impl.org.controlsfx.tools.rectangle.*; 
import impl.org.controlsfx.version.*; 
import impl.org.controlsfx.worldmap.*; 
import org.controlsfx.control.action.*; 
import org.controlsfx.control.*; 
import org.controlsfx.control.cell.*; 
import org.controlsfx.control.decoration.*; 
import org.controlsfx.control.spreadsheet.*; 
import org.controlsfx.control.table.model.*; 
import org.controlsfx.control.table.*; 
import org.controlsfx.control.textfield.*; 
import org.controlsfx.dialog.*; 
import org.controlsfx.glyphfont.*; 
import org.controlsfx.property.*; 
import org.controlsfx.property.editor.*; 
import org.controlsfx.tools.*; 
import org.controlsfx.validation.decoration.*; 
import org.controlsfx.validation.*; 
import org.hsluv.*; 
import com.koloboke.collect.*; 
import com.koloboke.collect.hash.*; 
import com.koloboke.collect.map.*; 
import com.koloboke.collect.map.hash.*; 
import com.koloboke.collect.set.*; 
import com.koloboke.collect.set.hash.*; 
import com.koloboke.function.*; 
import com.koloboke.collect.impl.*; 
import com.koloboke.collect.impl.hash.*; 
import org.demotweaker.*; 
import org.demotweaker.ui.*; 
import kotlin.collections.*; 
import kotlin.jvm.internal.*; 
import kotlin.coroutines.*; 
import kotlin.coroutines.intrinsics.*; 
import kotlin.coroutines.jvm.internal.*; 
import kotlin.*; 
import kotlin.io.*; 
import kotlin.internal.*; 
import kotlin.random.*; 
import kotlin.js.*; 
import kotlin.reflect.*; 
import kotlin.jvm.*; 
import kotlin.jvm.internal.markers.*; 
import kotlin.jvm.internal.unsafe.*; 
import kotlin.jvm.functions.*; 
import kotlin.system.*; 
import kotlin.contracts.*; 
import kotlin.sequences.*; 
import kotlin.comparisons.*; 
import kotlin.text.*; 
import kotlin.experimental.*; 
import kotlin.concurrent.*; 
import kotlin.properties.*; 
import kotlin.annotation.*; 
import kotlin.ranges.*; 
import kotlin.math.*; 
import kotlin.coroutines.experimental.*; 
import kotlin.coroutines.experimental.intrinsics.*; 
import kotlin.coroutines.experimental.migration.*; 
import kotlin.coroutines.experimental.jvm.internal.*; 
import org.intellij.lang.annotations.*; 
import org.jetbrains.annotations.*; 
import tornadofx.adapters.*; 
import tornadofx.*; 
import tornadofx.osgi.*; 
import sun.net.www.protocol.css.*; 
import tornadofx.osgi.impl.*; 
import org.glassfish.json.*; 
import org.glassfish.json.api.*; 
import javax.json.*; 
import javax.json.spi.*; 
import javax.json.stream.*; 
import kotlin.internal.jdk8.*; 
import kotlin.text.jdk8.*; 
import kotlin.collections.jdk8.*; 
import kotlin.streams.jdk8.*; 
import kotlin.internal.jdk7.*; 
import kotlin.jdk7.*; 
import kotlin.reflect.full.*; 
import kotlin.reflect.jvm.*; 
import kotlin.reflect.jvm.internal.*; 
import kotlin.reflect.jvm.internal.components.*; 
import kotlin.reflect.jvm.internal.impl.builtins.*; 
import kotlin.reflect.jvm.internal.impl.builtins.functions.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.descriptors.impl.*; 
import kotlin.reflect.jvm.internal.impl.incremental.*; 
import kotlin.reflect.jvm.internal.impl.incremental.components.*; 
import kotlin.reflect.jvm.internal.impl.load.java.*; 
import kotlin.reflect.jvm.internal.impl.load.java.components.*; 
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.*; 
import kotlin.reflect.jvm.internal.impl.load.java.sources.*; 
import kotlin.reflect.jvm.internal.impl.load.java.structure.*; 
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.*; 
import kotlin.reflect.jvm.internal.impl.load.kotlin.*; 
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.*; 
import kotlin.reflect.jvm.internal.impl.metadata.*; 
import kotlin.reflect.jvm.internal.impl.metadata.builtins.*; 
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.metadata.jvm.*; 
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.name.*; 
import kotlin.reflect.jvm.internal.impl.platform.*; 
import kotlin.reflect.jvm.internal.impl.protobuf.*; 
import kotlin.reflect.jvm.internal.impl.renderer.*; 
import kotlin.reflect.jvm.internal.impl.resolve.*; 
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.*; 
import kotlin.reflect.jvm.internal.impl.resolve.constants.*; 
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.*; 
import kotlin.reflect.jvm.internal.impl.resolve.jvm.*; 
import kotlin.reflect.jvm.internal.impl.resolve.scopes.*; 
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.*; 
import kotlin.reflect.jvm.internal.impl.serialization.*; 
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.*; 
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.*; 
import kotlin.reflect.jvm.internal.impl.storage.*; 
import kotlin.reflect.jvm.internal.impl.types.*; 
import kotlin.reflect.jvm.internal.impl.types.checker.*; 
import kotlin.reflect.jvm.internal.impl.types.error.*; 
import kotlin.reflect.jvm.internal.impl.types.typeUtil.*; 
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.*; 
import kotlin.reflect.jvm.internal.impl.util.*; 
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.*; 
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.*; 
import kotlin.reflect.jvm.internal.impl.utils.*; 
import kotlin.reflect.jvm.internal.pcollections.*; 
import kotlin.reflect.jvm.internal.structure.*; 
import com.github.thomasnield.rxkotlinfx.*; 
import io.reactivex.rxjavafx.observables.*; 
import io.reactivex.rxjavafx.sources.*; 
import io.reactivex.rxjavafx.observers.*; 
import io.reactivex.rxjavafx.schedulers.*; 
import io.reactivex.rxjavafx.subscriptions.*; 
import io.reactivex.rxjavafx.transformers.*; 
import io.reactivex.*; 
import io.reactivex.parallel.*; 
import io.reactivex.processors.*; 
import io.reactivex.exceptions.*; 
import io.reactivex.disposables.*; 
import io.reactivex.subjects.*; 
import io.reactivex.internal.fuseable.*; 
import io.reactivex.internal.disposables.*; 
import io.reactivex.internal.subscriptions.*; 
import io.reactivex.internal.observers.*; 
import io.reactivex.internal.operators.maybe.*; 
import io.reactivex.internal.operators.parallel.*; 
import io.reactivex.internal.operators.completable.*; 
import io.reactivex.internal.operators.single.*; 
import io.reactivex.internal.operators.observable.*; 
import io.reactivex.internal.operators.flowable.*; 
import io.reactivex.internal.subscribers.*; 
import io.reactivex.internal.queue.*; 
import io.reactivex.internal.functions.*; 
import io.reactivex.internal.schedulers.*; 
import io.reactivex.internal.util.*; 
import io.reactivex.observers.*; 
import io.reactivex.subscribers.*; 
import io.reactivex.annotations.*; 
import io.reactivex.plugins.*; 
import io.reactivex.functions.*; 
import io.reactivex.schedulers.*; 
import io.reactivex.flowables.*; 
import io.reactivex.observables.*; 
import org.reactivestreams.*; 
import com.beust.klaxon.*; 
import com.beust.klaxon.token.*; 
import com.beust.klaxon.internal.*; 
import org.mistutils.raster.*; 
import org.mistutils.raster.multi.*; 
import org.mistutils.random.*; 
import org.mistutils.classes.*; 
import org.mistutils.color.colorspace.*; 
import org.mistutils.color.*; 
import org.mistutils.color.colortype.*; 
import org.mistutils.geometry.int3.*; 
import org.mistutils.geometry.double2.*; 
import org.mistutils.geometry.double3.*; 
import org.mistutils.geometry.rectangle.*; 
import org.mistutils.geometry.volume.*; 
import org.mistutils.geometry.intvolume.*; 
import org.mistutils.geometry.int2.*; 
import org.mistutils.geometry.grid.*; 
import org.mistutils.collections.map2d.*; 
import org.mistutils.collections.*; 
import org.mistutils.collections.space.*; 
import org.mistutils.collections.bag.*; 
import org.mistutils.collections.ringbuffer.*; 
import org.mistutils.logic.*; 
import org.mistutils.files.*; 
import org.mistutils.strings.*; 
import org.mistutils.checking.*; 
import org.mistutils.symbol.*; 
import org.mistutils.lang.*; 
import org.mistutils.lang.serialization.*; 
import org.mistutils.lang.tweakfun.*; 
import org.mistutils.lang.tweakfun.functions.*; 
import org.mistutils.ui.*; 
import org.mistutils.updating.*; 
import org.mistutils.updating.strategies.*; 
import org.mistutils.field.*; 
import org.mistutils.field.featurefields.*; 
import org.mistutils.field.featurefields.typestrategies.*; 
import org.mistutils.field.featurefields.placementstrategies.*; 
import org.mistutils.field.valuefields.*; 
import org.mistutils.field.valuefields.sampling.*; 
import org.mistutils.field.objectfields.*; 
import org.mistutils.service.*; 
import org.mistutils.time.*; 
import org.mistutils.varying.*; 
import org.mistutils.interpolation.interpolators.*; 
import org.mistutils.interpolation.mixers.*; 
import org.mistutils.interpolation.*; 
import org.mistutils.interpolation.gradient.*; 
import org.mistutils.math.*; 
import org.mistutils.properties.*; 
import org.mistutils.noise.*; 
import impl.org.controlsfx.autocompletion.*; 
import impl.org.controlsfx.behavior.*; 
import impl.org.controlsfx.i18n.*; 
import impl.org.controlsfx.*; 
import impl.org.controlsfx.skin.*; 
import impl.org.controlsfx.spreadsheet.*; 
import impl.org.controlsfx.table.*; 
import impl.org.controlsfx.tools.*; 
import impl.org.controlsfx.tools.rectangle.change.*; 
import impl.org.controlsfx.tools.rectangle.*; 
import impl.org.controlsfx.version.*; 
import impl.org.controlsfx.worldmap.*; 
import org.controlsfx.control.action.*; 
import org.controlsfx.control.*; 
import org.controlsfx.control.cell.*; 
import org.controlsfx.control.decoration.*; 
import org.controlsfx.control.spreadsheet.*; 
import org.controlsfx.control.table.model.*; 
import org.controlsfx.control.table.*; 
import org.controlsfx.control.textfield.*; 
import org.controlsfx.dialog.*; 
import org.controlsfx.glyphfont.*; 
import org.controlsfx.property.*; 
import org.controlsfx.property.editor.*; 
import org.controlsfx.tools.*; 
import org.controlsfx.validation.decoration.*; 
import org.controlsfx.validation.*; 
import org.hsluv.*; 
import com.koloboke.collect.*; 
import com.koloboke.collect.hash.*; 
import com.koloboke.collect.map.*; 
import com.koloboke.collect.map.hash.*; 
import com.koloboke.collect.set.*; 
import com.koloboke.collect.set.hash.*; 
import com.koloboke.function.*; 
import com.koloboke.collect.impl.*; 
import com.koloboke.collect.impl.hash.*; 
import org.demotweaker.*; 
import org.demotweaker.ui.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class castleIvy extends PApplet {























































































































































































































































































































































































































































































Tweaker tweaker;
Terrain castleHill;
Terrain bgHill1;
Terrain bgHill2;
Ivy ivy1;
Ivy ivy2;
Ivy ivy3;
Ivy ivy4;
Ivy ivy5;
Ivy ivy6;
//Ivy ivy7;
VoxelCastle castle;
ActionCam camera;

String MUSIC_FILE = "Majestic Hills.mp3";

float DEMO_LENGTH_SECONDS = 199;
float BEATS_PER_MINUTE = 68;

Minim minim;
AudioPlayer audioPlayer;

public void setup() {
  randomSeed(42);
  noiseSeed(5);
  background(0);

  tweaker = new Tweaker(dataPath("tweakerSettings.json"), DEMO_LENGTH_SECONDS, BEATS_PER_MINUTE / 60.0f);
  Variable cameraMode = tweaker.variable("cameraMode", 1.0f);
  cameraMode.setInterpolator(new PowInterpolator(10.0f)); // We want camera mode to flip fast

  minim = new Minim(this);
  audioPlayer = minim.loadFile(MUSIC_FILE); // Load music from data directory  


  camera = new ActionCam(tweaker);

  // Setup hue saturation brightness based colors
  colorMode(HSB, 100f, 100f, 100f, 100f);


  // size(1600, 900, P3D);
  //size(800, 450, P3D);
  //size(1067, 600, P3D);
  // size(1600, 900, P3D);
   // Uncomment for compo
  noCursor();

  castleHill = new Terrain(7, 0.005f, 0.5f, -30, 2, true);
  bgHill1 = new Terrain(13, 0.0026f, 0.000015f, -135, 5, false);
  bgHill2 = new Terrain(25, 0.0008f, 0.0005f, -150, 9, false);


  ivy1 =  new Ivy(new PVector(0, 3, 0), new PVector(0, -1, 0));
  //this is a short ivy, default maxBranchLength is 900
  ivy2 =  new Ivy(new PVector(30, 14,-32), new PVector(0,-1, 0), 400);
  ivy3 =  new Ivy(new PVector(-35, 14, 0), new PVector(0, -1, 0));
  ivy4 =  new Ivy(new PVector(-10, 14, -33), new PVector(0, -1, 0));
  ivy5 =  new Ivy(new PVector(10, 14, 35), new PVector(0, -1, 0));
  ivy6 =  new Ivy(new PVector(35, 16, 32), new PVector(0, -1, 0));
  //ivy7 =  new Ivy(new PVector(-32, 16, -35), new PVector(0, -1, 0));

  //  size(1600, 900, P3D);


  castle = new VoxelCastle(0.9f, -10, -15, 0, 653);

  setupStars();

  // Tweaking editor
//  tweaker.openEditor();
  
  initCredits();

  // No lines between polygons
  noStroke();
  fill(80);

  // Start playing music
  audioPlayer.play();
  
  // Listen to restart from editor, restart music
  tweaker.addListener(new StepListener() {
      public void onUpdate(Time time) {
      }
      public void onRestarted(Time time) {
        // Restart music
        audioPlayer.rewind();
        audioPlayer.play();
      }
      public void onPaused(Time time) {
        audioPlayer.pause();
      }
      public void onPlaying(Time time) {
        audioPlayer.play();
      }
  });
}


public void draw() {

  hint(ENABLE_DEPTH_TEST); 

  pushMatrix();

  // Center screen
  translate(width/2f, height/2f);
  scale(height/100.0f);

  tweaker.update();
  


  camera.update();

  // Daylights
  float hue = tweaker.value("hue", 0f) % 100f; 
  float sat = tweaker.value("sat", 0f); 
  float lum = tweaker.value("lum", 0f);
  
  background(hue, sat, lum);
//  background(50, 20, 70);

  drawSky();
  
  // Setup lights
  float sun = tweaker.value("sun", 0f);
  directionalLight(80, 30, 30, 0.2f, 0.2f, 0.1f);
  directionalLight(13, 20, 100, sin(sun*TAU), cos(sun*TAU), 0.2f);
  //  directionalLight(20, 20, 100, 0.2, -0.3, -0.3);
  ambientLight(70, 20, 40);


  pushMatrix();
  castleHill.draw();
  popMatrix();

  pushMatrix();
  translate(0, 90, 0);
  bgHill1.draw();
  bgHill2.draw();
  popMatrix();

  // Calibration sphere
  /*
  pushMatrix();
   noStroke();
   translate(40, 0, 0);
   //translate(0f, 0f, 100f);
   fill(0f, 20f, 40f);
   sphere(30);
   popMatrix();
   */


  pushMatrix();
  ivy1.drawIvy();
  ivy2.drawIvy();
  ivy3.drawIvy();
  ivy4.drawIvy();
  ivy5.drawIvy();
  ivy6.drawIvy();
//  ivy7.drawIvy();
  popMatrix();

  //if (secondsFromStart() > 60) castle.draw();
  castle.draw();

  // Check for end
  if (tweaker.getTime().getCurrentStepElapsedSeconds() > DEMO_LENGTH_SECONDS) {
    // Time to quit
    exit();
  }


  popMatrix();

  // Fade
  hint(DISABLE_DEPTH_TEST); 
  float fade = tweaker.value("fade", 1f);
  if (fade < 0.999f) {
    // Fade to black
    fill(0, 0, 0, (1f - fade) * 100);
    rect(0, 0, width, height);
  }
  
  drawCredits();

}

public void mouseWheel(MouseEvent event) {
  float e = event.getCount();
  camera.changeDistance(e * 10f);
}


/** Handles camera movement */
class ActionCam {
  
  Tweaker tweaker;
  
  PVector focus = new PVector();
  PVector position = new PVector();
  PVector up = new PVector(0, 1, 0);
  
  float fieldOfView = 60;
  
  float rotateCameraDistance = 100f;

  private int prevCameraMode = -1;

  private PVector prevCameraPos = new PVector(); 
  private PVector cameraVel = new PVector(); 

  private PVector hoverPos = new PVector(-20, -40, 30); 
  private PVector towerPos = new PVector(1, -40, 3); 
  private PVector distantPos = new PVector(200, -140, 100); 

  ActionCam(Tweaker tweaker) {
    this.tweaker = tweaker;
  }

  public void update() {    
    float cameraDistance = tweaker.value("cameraDistance", 10);
    float rotationAngle = tweaker.value("cameraRotation", 0);
    float pitchAngle = tweaker.value("cameraPitch", 0);
    float chaseAcceleration = tweaker.value("cameraChaseAcceleration", 0.01f);
    float sideX = tweaker.value("cameraSideX", 0);
    
    int cameraMode = (int)tweaker.value("cameraMode", 0);
    if (cameraMode <= 0) {
      // Dev camera
      mouseRotateLook();
    }
    else if (cameraMode == 1) {
      // Circle castle camera
      focus.set(0, 0, 0);
      rotoCamera(cameraDistance, rotationAngle, pitchAngle);
    }
    else if (cameraMode == 2) {
      // Circle other point
      focus.set(sideX, -1, 0);
      rotoCamera(cameraDistance, rotationAngle, pitchAngle);
    }
    else if (cameraMode == 3) {
      activateChaseCam(ivy1.branchPos, ivy1.branchPos, cameraMode, cameraDistance, chaseAcceleration);
    }
    else if (cameraMode == 4) {
      activateChaseCam(ivy3.branchPos, ivy4.branchPos, cameraMode, cameraDistance, chaseAcceleration);
    }
    else if (cameraMode == 5) {
      activateChaseCam(ivy5.branchPos, ivy5.branchPos, cameraMode, cameraDistance, chaseAcceleration);
    }
    else if (cameraMode == 6) {
      if (prevCameraMode != cameraMode) {
        position.set(distantPos);
        cameraVel.set(-10,-10, 2);
      }
      
      focus.set(towerPos);
      chaseCamera(hoverPos, chaseAcceleration);
    }
    else if (cameraMode == 7) {
      activateChaseCam(ivy5.branchPos, ivy2.branchPos, cameraMode, cameraDistance, chaseAcceleration);
    }
   
    prevCameraMode = cameraMode;
    prevCameraPos.set(position);
  }

  public void activateChaseCam(PVector target, PVector foc, int mode, float dist, float acc) {
    if (prevCameraMode != mode) {
      position.set(target).add(-0.4f, -dist*0.8f, -1);
      cameraVel.set(0,0,0);
    }
    
    // Chase ivy x
    focus.set(foc);
    chaseCamera(target, acc);
  }
  
  private PVector tempAcc = new PVector();
  public void chaseCamera(PVector target, float chaseAcceleration) {
    
    /*
    // Accelerate towards target
    float dt = (float)tweaker.getTime().getCurrentStepElapsedSeconds();
    tempAcc.set(target).sub(position).normalize().mult(chaseAcceleration * dt);
    
    // Update velocity
    addScaled(cameraVel, tempAcc, dt);

    // Update pos
    addScaled(position, cameraVel, dt);
    */
    
    // Simpler, non exploding
    position.lerp(target, chaseAcceleration);

    updateCamera();
  }
  
  public void rotoCamera(float dist, float rotationAngle, float pitchAngle) {
    position.set(dist * cos(TAU*rotationAngle/360)  * sin(TAU*pitchAngle/360),
                 dist * cos(TAU*pitchAngle/360) - dist / 2f,
                 dist * -sin(TAU*rotationAngle/360)  * sin(TAU*pitchAngle/360) );

    updateCamera();
  }
  
  
  public void mouseRotateLook() {
    focus.set(0, 0, 0);
    
    float rotationAngle = map(mouseX, 0, width, 0, TAU);
    float elevationAngle = map(mouseY, 0, height, 0, TAU/2);

    position.set(rotateCameraDistance * cos(rotationAngle)  * sin(elevationAngle),
                 rotateCameraDistance * cos(elevationAngle) - rotateCameraDistance / 2f,
                 rotateCameraDistance * -sin(rotationAngle)  * sin(elevationAngle) );


    updateCamera();
  }
  
  public void changeDistance(float amount) {
    rotateCameraDistance += amount;
  }
    
  private void updateCamera() {

    perspective();
    perspective(fieldOfView / 360 * TAU, (float)width / height, 0.1f, 10000f);
    camera(position.x, position.y, position.z,
           focus.x, focus.y, focus.z, 
           up.x, up.y, up.z);
           
           
  }
    
}




class Castle {
  HashMap<Int3, Cell> cells = new HashMap();

  float cellWidth = 3f;
  float cellHeight = 4f;
  float wallThickness = cellWidth * 0.15f;
  float wallOverlap = wallThickness * 0.5f;
  
  int col = color(random(70, 90), random(5, 30), random(20, 40));
  
  PVector pos = new PVector();
  
  XoroShiro random = new XoroShiro(422);
  
  Castle() {
    generate();
  }
  
  public Cell getOrCreateCell(Int3 location) {
    Cell c = cells.get(location);
    if (c == null) {
      c = new Cell(this, location);
      cells.put(c.location, c);
    }
    
    return c;
  }
  
  public void generate() {
    Int3 loc = new Int3();
    int numChambers = 100;
    int radius = 4;
    for (int i = 0; i < numChambers; i++) {
      loc.x = (int) random(-radius, radius);
      loc.y = (int) random(-radius, radius);
      loc.z = (int) random(-radius, radius);
      Cell cell = getOrCreateCell(loc);
      cell.westWall = random(0, 1) < 0.4f ? true : false;
      cell.northWall = random(0, 1) < 0.4f ? true : false;
      cell.roof = random(0, 1) < 0.8f ? true : false;      
    }
  }

  public void draw() {
    noStroke();
    pushMatrix();
    
    for (Cell cell: cells.values()) {
      cell.draw();
    }
    
    popMatrix();
  }
  
}


class Cell {
  Int3 location = new Int3();
  Castle castle;
  int col;  
  
  boolean westWall = true;
  boolean northWall = true;
  boolean roof = true;
  
  Cell(Castle castle, Int3 location) {
    this.castle = castle;
    this.location.set(location);
    col = castle.col;
  }
  
  public void draw() {
    
    float x = castle.pos.x + location.x * castle.cellWidth;
    float y = castle.pos.y + location.y * castle.cellHeight;
    float z = castle.pos.z + location.z * castle.cellWidth;
    
    float w = castle.cellWidth;
    float h = castle.cellHeight;
    float t = castle.wallThickness;
    float overlap = castle.wallOverlap;
    
    if (westWall) {
      drawBlock(col, 
                x, y + h * 0.5f, z + w * 0.5f,
                t, h + overlap, w + overlap);
    }
    
    if (northWall) {
      drawBlock(col, 
                x + w * 0.5f, y + h * 0.5f, z,
                w + overlap, h + overlap, t);
    }
    
    if (roof) {
      drawBlock(col, 
                x + w * 0.5f, y - h, z + w * 0.5f,
                w + overlap, t, w + overlap);
    }    
  }

  public void drawBlock(int col, float cx, float cy, float cz, float sx, float sy, float sz) {
    translate(cx, cy, cz);
    fill(col);
    box(sx, sy, sz);
    
    sphereDetail(6, 5);
    castle.random.setSeed(location.x, location.y, location.z);    
    for (int i = 0; i < 30; i++) {

      
      fill(hue(col) + castle.random.nextFloat(-5, 5), 
           saturation(col) + castle.random.nextFloat(-10, 10), 
           brightness(col) + castle.random.nextFloat(-15, 15));
      
      float dx = castle.random.nextFloat(-sx/2, sx/2);
      float dy = castle.random.nextFloat(-sy/2, sy/2);
      float dz = castle.random.nextFloat(-sz/2, sz/2);
      float r = max(sx, sy, sz) * castle.random.nextFloat(0.08f, 0.14f);
      pushMatrix();
      translate(dx, dy, dz);
      float scaling = 0.5f;
      scale(1f + castle.random.nextFloat(-scaling, scaling),
            1f + castle.random.nextFloat(-scaling, scaling),
            1f + castle.random.nextFloat(-scaling, scaling));
      rotateX(castle.random.nextFloat(0, TAU));
      rotateY(castle.random.nextFloat(0, TAU));
      rotateZ(castle.random.nextFloat(0, TAU));
      sphere(r);
      //translate(-dx, -dy, -dz);
      popMatrix();
    }
    
    translate(-cx, -cy, -cz);  
  }
}







String credits = 
  "Forest Ivy Castle\n" +
  "\n" +
  "by GeoScapers\n" +
  "\n" +
  "coded in 29 hours\n" +
  "for Graffathon 2019\n" +
  "\n" +
  "  Ivy by Shiera\n" +
  "  Castle by fractalpixel\n" +
  "  Background by SierraFox\n" +
  "\n" +
  "Music: \"Majestic Hills\"\n" + 
  "    by: Kevin MacLeod\n" +
  "    (creative commons cc-by)\n";

PFont creditFont;

String FONT_NAME = "JosefinSans-Bold.ttf";

// Setup font etc.  Call from setup.
public void initCredits() {
  creditFont = createFont(FONT_NAME, 32);
  
  int fontSize = 32 * width / 800; // Resolution independent 
  textSize(fontSize);
}

public void drawCredits() {
  
  float relPos = tweaker.value("creditsPos", -1);
  fill(0, 0, 100, 75);
  if (relPos > -0.99f) {
    lights();
    float creditPos = -relPos * height;
    fill(0, 0, 100, 75);
    text(credits, width * 0.2f, creditPos);
  }  
}

class Ivy{
  //the first piece
  PlantSegment root; 
  
  //segments currently in the ivy
  int segmentAmount = 0; 
  //maximum length of one segment
  float maxSegmentLenght = 0.2f;
  //length at wich the segmens cehecks if it branches
  float segmentBranchLenght = 0.8f*maxSegmentLenght;
  //langth at wich a segment checks if it grows a child
  float segmentChildbirtLengt = 0.5f*maxSegmentLenght;
  //the speed that the segments grow
  float growthSpeed = 0.03f; 
  //the porbability that a new branch is formed, this is the base probability, it will drop in every branch, 
  //and if it does not happen there is a lower chanse a shorter branch will form
  float branchProbability = 0.052f;
  //this is the multiplier on how the branchProbability changes for every branch
  float branchProbabilityMultiplier = 0.5f;
  
  //Temporary PVector used for the plantCenter dissipator
  PVector tempForDissat = new PVector();
  
  
  //amount of sides in the sylinder of the ivy branches 
  int segmentSideAmount = 5;
  //the direction of up for the ivy
  PVector upDirection = new PVector();
  //the time it took from start to the previous update, used in counting time between updates
  float previousSecondsFromStart;
  //seconds from previous update
  float secondFromPreviousUpdate;
  //a fudge parameter affecting on how big an angle a branch has
  float branchWildness = 1.2f;
  //a fudge parameter affecting how scuiggly the plant is
  float turnstrength = 0.6f;
  //running count on amount of branches 
  int branchamount = 1;
  //maximum segment amount in a branch (depth from root)
  int maxBranchLength = 740;
  //maximum amount of branches
  float maxBranchAmount = 25;
  //maximum width of the plant at the root
  float maxBranchWidth = 0.5f;
  //growthspeed of the branch
  float branchGrowth = 0.01f;
  //growthspead of the leaf
  float leafGrowthSpeed = growthSpeed*20;
  //a random number where you can set seed
  XoroShiro rnd = new XoroShiro();
  //pvector used to count the mean position of the branch tips
  PVector mean = new PVector();
  //pvector used to count the mean position of the branch tips
  PVector prevMean = new PVector() ;
  //seed to this ivy, initialised with random, used to get diffent plants
  float ivyseed = 0;
  //probability that there will be a leaf in a segment (if there is a branch there is no leaf, and if it is the end there is always a leaf)
  float leafprob = 0.5f;
  //the thicknessloss in the beginning
  float startticknessLoss = 0.955f;
  //parameter to multipy the thickness with for every next segment, bigger will make it thicker fr longer
  float thicknesLoss = startticknessLoss;
  //the thicknesslos will change to a bigger walue when the plant is of certain age, to make it a bit wider 
  float laterThicknessLoss = 0.975f;
  //this is the segmentamount where the thicknessfuncton will be the new one
  int segmentToChangeLoss = 800;
  //the rate on wich fresh color changes 
  float freshColorChangeRate = 0.3f;
  //the rate on wich the branch get broun
  float colorChangeRate = 0.03f;
  //the rate on wich the leafs turn dark
  float leafColorChangeRate = 0.2f;
  
  
  //color of you g sprouts and young leafs
  int sproutColor = color(30, 38, 68);
  //middlecolor of the branch, 
  int branchColor = color(33, 53, 50);
  //color of the root of the branch, and old branches
  int rootColor = color(5, 26, 30);
  //basecolor of the leafs, the leaf is randomisating this a bit
  int leafColor = color(35, 31, 40);
  //basecolor of the leafs for the autum
  int leafColorAutum = color(10, 80, 70);
  
  //bunch of pvectors used in leaf
  PVector tNormal = new PVector();
  PVector t1 = new PVector();
  PVector t2 = new PVector();
  PVector p1 = new PVector();
  PVector p2 = new PVector();
  PVector p3 = new PVector();
  //for castleAttractor
  PVector ca = new PVector();
  
  
  //autum parameters
  float atumness = 0;
  boolean leafGoBoom = false;
  float timeOfBoom = 0;
  float boomspeed = 3;
  
  //something for the camera
  PVector branchPos = new PVector();
  boolean branchPosFound = false;
  
  
  
  Ivy(PVector startpos, PVector upDirection, int maxBranchLength){
    this.upDirection.set(upDirection);
    root = new PlantSegment(startpos, this);
    previousSecondsFromStart = secondsFromStart();
    secondFromPreviousUpdate = secondsSince(previousSecondsFromStart);
    PVector prevMean = startpos;
    ivyseed = random(0, 255);
    this.maxBranchLength = maxBranchLength;
   
  } 
  
  Ivy(PVector startpos, PVector upDirection){
    this.upDirection.set(upDirection);
    root = new PlantSegment(startpos, this);
    previousSecondsFromStart = secondsFromStart();
    secondFromPreviousUpdate = secondsSince(previousSecondsFromStart);
    PVector prevMean = startpos;
    ivyseed = random(0, 255);
   
  } 
  
  public void addSegmentAmount(){
    segmentAmount++;
  }  
  
  public void addBranchAmount(){
    branchamount++;
  }  
  
  public void addToMean(PVector v){
    mean.add(v);
  }  
  

  
  private void updateIvy(){
    branchPosFound = false;
    
    //println(segmentAmount);
    if (segmentAmount < segmentToChangeLoss) thicknesLoss = map(segmentAmount, 0, segmentToChangeLoss, startticknessLoss, laterThicknessLoss);
    
    atumness = tweaker.value("atumness", 0);
    
    //testcode for autumnesss comment out when not testing without tweaker
    /*if (segmentAmount > 500) atumness += 0.01;
    println(atumness);
    */
    
    //when atum comes, nothing grows
    if (atumness > 0){
      branchGrowth = 0.0f;
    }   
    
    if (atumness > 0.5f){
      leafGrowthSpeed = 0;
    }  
    
    if (atumness >= 1) {
      atumness = 1;
      leafGoBoom = true;
    }
    
    
    
    if (leafGoBoom && timeOfBoom == 0) timeOfBoom = secondsFromStart();
    
    
    //null the mean
    mean.set(root.startpos);
    //if anything of the ivy needs to be updated do it here
    //println(branchamount);
    
    secondFromPreviousUpdate = secondsSince(previousSecondsFromStart);
    previousSecondsFromStart = secondsFromStart();
    
    root.startThickness += branchGrowth*secondFromPreviousUpdate;
    if (root.startThickness > maxBranchWidth) root.startThickness = maxBranchWidth;
    //then update the root (and all the following branches)
    root.update();
    prevMean.set(mean.div(branchamount));
    
  }
  
  public void drawIvy(){
    noStroke();
    
    updateIvy();
    
    //draw one segment at a time
    root.drawSegment();
  }  
  
}  
  

class Leaf{
  PlantSegment parentSegment;
  Ivy plant;
  
  int leafCol;
  int autumCol;
  int currentSummerColor;
  
  float leafsize = 0;
  float maxLeafsize = 1;
  float leafBirthSecondFromStart;
  PVector randomDirection;
  
  Leaf(Ivy plant, PlantSegment parentSegment){
    this.plant = plant;
    this.parentSegment = parentSegment;
    leafBirthSecondFromStart = secondsFromStart();
    leafCol = color(hue(plant.leafColor+(int)(random(-10, 10))), saturation(plant.leafColor)+(int)(random(-10, 10)), brightness(plant.leafColor)+(int)(random(-10, 10)));
    autumCol = color(hue(plant.leafColorAutum +(int)(random(-10, 10))), saturation(plant.leafColorAutum )+(int)(random(-25, 15)), brightness(plant.leafColorAutum )+(int)(random(-15, 15)));
    currentSummerColor = leafCol;
    randomDirection = new PVector(random(0, 3), random(-0.5f, 1), random(-1, 1));
}
  
  
  public void updateLeaf(){
      //do all of the updating of the leaf here
      leafsize += plant.leafGrowthSpeed*plant.secondFromPreviousUpdate;
      if (leafsize > maxLeafsize) leafsize = maxLeafsize;
  }
  
  public void drawLeaf(){
    plant.rnd.setSeed(parentSegment.segmentcount+plant.ivyseed);
     //when no autum is near all is green
    if (plant.atumness == 0){
       float colorage = secondsSince(leafBirthSecondFromStart)*plant.leafColorChangeRate;
       if (colorage > 1) colorage = 1;
       currentSummerColor = lerpColor(plant.sproutColor, leafCol, colorage);
       fill(currentSummerColor);
    }
    //when autum starts
     else {
        fill(lerpColor(currentSummerColor, autumCol, plant.atumness));
     }  
    if (!plant.leafGoBoom){
        
     //do the drawing of the leaf here
     pushMatrix();
     
     translate(parentSegment.endpos.x,parentSegment.endpos.y, parentSegment.endpos.z);
     
     rotateX(TAU*(0.25f));
     
     rotateZ(plant.rnd.nextFloat(TAU));
     rotateX(-TAU*(plant.rnd.nextFloat(0.0f, 0.1f))+(plant.atumness*TAU*0.15f));
     translate(0, -parentSegment.endThickness, 0);
     scale(leafsize);
     drawPart();
     
     popMatrix();
    } 
    //when the leaf go boom
    else{
     pushMatrix();
     
     translate(
         parentSegment.endpos.x+(randomDirection.x*secondsSince(plant.timeOfBoom)*plant.boomspeed),
         parentSegment.endpos.y+(randomDirection.y*secondsSince(plant.timeOfBoom)*plant.boomspeed), 
         parentSegment.endpos.z+(randomDirection.z*secondsSince(plant.timeOfBoom)*plant.boomspeed));
     plant.rnd.setSeed(parentSegment.segmentcount+plant.ivyseed);
     rotateX(TAU*(0.25f)+secondsSince(plant.timeOfBoom)*plant.rnd.nextFloat(0.9f, 4));
     
     rotateZ(plant.rnd.nextFloat(TAU)+secondsSince(plant.timeOfBoom)*plant.rnd.nextFloat(0.5f, 3));
     rotateY(secondsSince(plant.timeOfBoom)*plant.rnd.nextFloat(1, 2));
     
    
     scale(leafsize);
     drawPart();
     
     popMatrix();
    }  
  } 
  
  
  public void addTriangle(PVector p1, PVector p2, PVector p3) {
  faceNormal(p1, p2, p3, plant.tNormal);
  normal(plant.tNormal.x, plant.tNormal.y, plant.tNormal.z);
  vertex(p1);
  vertex(p2);
  vertex(p3);
}


  public PVector faceNormal(PVector p1, PVector p2, PVector p3, PVector normall) {
    plant.t1.set(p1);
    plant.t1.sub(p2);
    
    plant.t2.set(p1);
    plant.t2.sub(p3);
  
    plant.t1.cross(plant.t2, normall);
    return normall;
  }
  
  public void drawPart() {
    int leafSegments = 6;
    float leafLength = 0.95f;
    float leafWidth = 0.6f;
    
    float upTilt = 0.25f;

     
    noStroke();
    
    beginShape(TRIANGLES);
    
    for (int i = 0; i < leafSegments; i++) {
      float relPos = map(i, 0, leafSegments, 0f, 1f);
      float nextRelPos = map(i + 1, 0, leafSegments, 0f, 1f);
      
      leafEdgePoint(relPos, 0.5f*leafWidth, leafLength, upTilt, plant.p1);  
      leafCenterPoint(relPos, leafLength, plant.p2);
      leafCenterPoint(nextRelPos, leafLength, plant.p3);
      addTriangle(plant.p1, plant.p2, plant.p3);

      leafCenterPoint(nextRelPos, leafLength, plant.p1);
      leafEdgePoint(nextRelPos, 0.5f*leafWidth, leafLength, upTilt, plant.p2);  
      leafEdgePoint(relPos, 0.5f*leafWidth, leafLength, upTilt, plant.p3);  
      addTriangle(plant.p1, plant.p2, plant.p3);
      
      leafCenterPoint(relPos, leafLength, plant.p1);
      leafEdgePoint(relPos, -0.5f*leafWidth, leafLength, upTilt, plant.p2);  
      leafCenterPoint(nextRelPos, leafLength, plant.p3);
      addTriangle(plant.p1, plant.p2, plant.p3);

      leafEdgePoint(nextRelPos, -0.5f*leafWidth, leafLength, upTilt, plant.p1);  
      leafCenterPoint(nextRelPos, leafLength, plant.p2);
      leafEdgePoint(relPos, -0.5f*leafWidth, leafLength, upTilt, plant.p3);  
      addTriangle(plant.p1, plant.p2, plant.p3);
      
    }
    
    endShape();

  }
  
    public float mapClamp(float value, float sourceStart, float sourceEnd, float destStart, float destEnd) {
  return map(constrain(value, sourceStart, sourceEnd), sourceStart, sourceEnd, destStart, destEnd);
  
}
  
  public void leafCenterPoint(float relPos, float leafLen, PVector pos) {
      float y = mix(relPos, 0, -leafLen);
      pos.x = 0;
      pos.y = y;
      pos.z = 0;
  }
  
  public float mix(float t, float a, float b) {
  return (b - a) * t + a;
}
  
  public void leafEdgePoint(float relPos, float leafR, float leafLen, float upTilt, PVector pos) {
       float cutoverPoint = 0.8f;
      float baseW = pow(mapClamp(relPos, 0, cutoverPoint, 0, 1), 0.5f);
      float tipW = 0.5f*(1+cos(TAU*mapClamp(relPos, cutoverPoint, 1, 0, 1)*0.5f));
      float w = mix(relPos, baseW, tipW);
      
      float x = 0.5f*leafR * w;
      float z = 0 + upTilt * abs(leafR) * sin(0.5f*TAU*min(relPos, 1-relPos));
      float y = mix(relPos, 0, -leafLen);
      
      pos.x = x;
      pos.y = y;
      pos.z = z;
 }
  
}

 
class PlantSegment{
  //previous branchSegment, null if this is the root
  PlantSegment parent;
  //next plantSegment, null if not yet prodused, or this end
  PlantSegment nextSegment;
  //if it branches this is the branchSegment
  PlantSegment branchSegment;
  //the leaf from the end of this segment, might be null
  Leaf leaf;
  //the plant this segmentis a part on
  Ivy plant;
  //starting position of this segment
  PVector startpos = new PVector();
  //end position of this segment
  PVector endpos = new PVector();
  //thicknes of the start of this segment (radius?)
  float startThickness;
  //thicknes of the end of this segment (radius?)
  float endThickness;
  //direction of this segment, not changed after start
  PVector direction = new PVector();
  //current length of this segment
  float segmentLength; 
  //count from the root piece here
  int segmentcount;
  //boolean on if we have tried to branch, this is done only once
  boolean branchTried = false;
  //seed for the noice of this branch
  float noiseseed = 0;
  //probability that this branch will divide,gets lover on branches that have branched a lot
  float branchProbability = 0;
  //boolean on if this branch has ended (no next will be done if true)
  boolean branchEnding = false;
  //max amount of segments in this branch (from bottom) gets smaller when branched multiple times
  int maxBranchLength = 0;
  //boolean on if we have checked if this grows a leaf yet
  boolean triedLeaf = false;
  //when this segment was born, used to get its age, for example for the colors
  float segmentBirthSecondFromStart;
  //boolean on if the segment is fully grown, then those below it should e fully grown, and wont move anymore
  
  
 
 /*
 Construction for the root segment, when there is no parentSegment
 */
 PlantSegment(PVector startpos, Ivy plant){
   //just initialising stuff
   this.startpos.set(startpos);
   this.endpos.set(startpos); 
   this.plant = plant;
   this.startThickness = 0;
   this.endThickness = 0;
   this.direction.set(plant.upDirection);
   direction.normalize();
   this.segmentLength = 0;
   plant.addSegmentAmount();
   segmentcount = 1;
   noiseseed = 0;
   branchProbability = plant.branchProbability;
   maxBranchLength = plant.maxBranchLength;
   segmentBirthSecondFromStart = secondsFromStart();
   
   
 }
 
 /*
 Construction for a segment that is not a root (has a parent segment), and not a new branch
 */
 PlantSegment(PlantSegment parent, Ivy plant){
   //initialise stuff
   this.parent = parent;
   this.noiseseed = parent.noiseseed;
   this.startpos.set(parent.endpos);
   this.endpos.set(parent.endpos);
   this.plant = plant;
   this.startThickness = parent.endThickness;
   this.endThickness = 0;
   segmentcount = parent.segmentcount +1;
   float noisepos = segmentcount/2f;
   this.direction.set(parent.direction);
   direction.normalize();
   branchProbability = parent.branchProbability;
   segmentBirthSecondFromStart = secondsFromStart();
   this.segmentLength = 0;
   plant.addSegmentAmount();
   maxBranchLength = parent.maxBranchLength;
   //calculate new direction based on the old one and noice
   this.direction.add(
       map(noise(noiseseed+noisepos+113.13f), 0, 1, -plant.turnstrength, plant.turnstrength), 
       map(noise(noiseseed+noisepos+231.12f), 0, 1, -plant.turnstrength, plant.turnstrength), 
       map(noise(noiseseed+noisepos+21.21f), 0, 1, -plant.turnstrength, plant.turnstrength));
       
    //sun attractor, in the direction of ivys up   
   direction.add(plant.upDirection.x*0.07f, plant.upDirection.y*0.07f, plant.upDirection.z*0.07f);   
   //away from middle
   plant.tempForDissat.set(plant.prevMean).sub(startpos).normalize().mult(-0.05f);
   direction.add(plant.tempForDissat);
   boolean foundWall = castle.getCastleDistance(endpos, plant.ca);
   if (foundWall){
     float distance = plant.ca.mag();
     plant.ca.normalize();
     if (distance < 0.95f){
       direction.add(plant.ca.mult(-0.5f));
     }  
     if (distance > 0.95f){
       direction.add(plant.ca.mult(0.5f));
     }  
     
   }  
   
   
   
   direction.normalize();
   
   
   
 }  
 
  /*
 Construction for a segment that is not a root (has a parent segment)  
 and are not given its direction
 */
 PlantSegment(PlantSegment parent, Ivy plant, PVector direction, float maxLengthMul){
   //initialise stuff
   this.parent = parent;
   this.startpos.set(parent.endpos);
   this.endpos.set(parent.endpos);
   this.plant = plant;
   this.startThickness = parent.endThickness;
   this.endThickness = 0;
   this.direction.set(direction);
   direction.normalize();
   this.segmentLength = 0;
   this.noiseseed = random(0f, 100f);
   plant.addSegmentAmount();
   segmentcount = parent.segmentcount +1;
   //will branch less 
   branchProbability = plant.branchProbabilityMultiplier*parent.branchProbability;
   maxBranchLength = (int)(parent.maxBranchLength*maxLengthMul);
   segmentBirthSecondFromStart = secondsFromStart();
   
 } 
 
 public void update(){
   
   //add here code for updating this segment
   //thickness
   if (parent != null){
     startThickness = parent.endThickness;
     
     endThickness = startThickness*plant.thicknesLoss;
     //if no branch end in a tip
     if (nextSegment == null && branchSegment == null){
       endThickness = 0;
     } 
     //othervise put a minimum width
     else{
       if (endThickness < 0.01f)endThickness = 0.01f;
     }  
   }
   else{
     endThickness = startThickness*plant.thicknesLoss;
   }
   
   
   //if the previous segment have changed it's endpos then update our startpos
   boolean startposChanged = false;
   if (parent != null && !parent.endpos.equals(startpos)){
       startpos.set(parent.endpos);  
       startposChanged = false;
       
       
   }
   // if we can still grow then grow it with the growthSpeed
   boolean segmentGrown = false;
   if (segmentLength < plant.maxSegmentLenght){
     segmentGrown = true;
     //segmentLength += plant.growthSpeed*plant.secondFromPreviousUpdate;
     segmentLength += plant.growthSpeed;
     if (segmentLength > plant.maxSegmentLenght) segmentLength = plant.maxSegmentLenght;
   }  
   //if the startpos changed or the plant was grown then endpos needs to be changed as well
   if (startposChanged || segmentGrown) {     
       endpos.set(direction);
       endpos.mult(segmentLength);
       endpos.add(startpos);
   } 
   //if we do not have yet, then make next segment if we are long enough
   if (segmentLength > plant.segmentChildbirtLengt && nextSegment == null && !branchEnding){
       if (random(0,1) > segmentcount/maxBranchLength){
                nextSegment = new PlantSegment(this, plant);  
               //println("new segment");
       }
       else{
         branchEnding = true;
       }
         
   } 
   //if we are long enough to branch and have not tried to do that yet, do it
   if ( branchTried == false && segmentLength > plant.segmentBranchLenght){
     branchTried = true;
     if (plant.branchamount < plant.maxBranchAmount ){
     
       float r = random(0, 1);
       if (r < branchProbability){
         //createBranch successfull
         PVector d = direction.copy();
         
         d.add(random(-plant.branchWildness, plant.branchWildness), random(-plant.branchWildness, plant.branchWildness), random(-plant.branchWildness, plant.branchWildness));
         branchSegment = new PlantSegment(this, plant, d.normalize(), 0.75f);
         plant.addBranchAmount();
         
       }  
       //if not try to make a shorter
       r = random(0, 1);
       if (r < branchProbability*0.1f){
         //createBranch successfull
         PVector d = direction.copy();
         
         d.add(random(-plant.branchWildness, plant.branchWildness), random(-plant.branchWildness, plant.branchWildness), random(-plant.branchWildness, plant.branchWildness));
         branchSegment = new PlantSegment(this, plant, d.normalize(), 0.1f);
         plant.addBranchAmount();
         
       }  
     }
   }  
   //if this is not gonna branch check if this shouls have a leaf
   if (leaf == null && branchSegment == null && branchTried == true && triedLeaf == false){
     float r = random(0, 1);
     triedLeaf = true;
     if (r < plant.leafprob){
       leaf = new Leaf(plant, this);
     }  
   } 
   //or if this is ending then then add always a leaf
   if (branchEnding && leaf == null) leaf = new Leaf(plant, this);
   //add ends to mean
   if (branchSegment == null && nextSegment == null){
       plant.addToMean(endpos);
   } 
   if (!plant.branchPosFound && branchSegment == null && nextSegment == null && !branchEnding){
     plant.branchPosFound = true;
     plant.branchPos = endpos;
   }  
   
   
   // then update all the leaf of this branch and the next segments if they are not null
   if (leaf != null) leaf.updateLeaf();
   if (nextSegment != null) nextSegment.update();  
   if (branchSegment != null) branchSegment.update();  
 }
 
 
 public void drawSegment(){
   float since = secondsSince(segmentBirthSecondFromStart);
   float colorage = since*plant.freshColorChangeRate;
   if (colorage < 1){
     fill(lerpColor(plant.sproutColor, plant.branchColor, colorage));
   }  
   else{
     since -= 1/plant.freshColorChangeRate;
     colorage = since*plant.colorChangeRate;
     if (colorage > 1) colorage = 1;
     fill(lerpColor(plant.branchColor, plant.rootColor, colorage));
   }  
   
   //do the drawing of this segment here
   pushMatrix();
   
  
   drawCylinder(direction, startpos, endpos, startThickness, endThickness,plant.segmentSideAmount);
   
   
   popMatrix();
   //then draw the next segments
   //println("drawing with startpos " + startpos);
   if (leaf != null) leaf.drawLeaf();
   if (nextSegment != null) {
     nextSegment.drawSegment();
     //println("drawing next with startpos " +nextSegment.startpos);
   }  
   if (branchSegment != null) branchSegment.drawSegment();  
   
 }  
 
 
 
 

  
 
 
 
 
 

}

int STAR_COUNT = 1000;

float[] starX = new float[STAR_COUNT];
float[] starY = new float[STAR_COUNT];
float[] starZ =new float[STAR_COUNT];

public void setupStars() {
  
 for (int i = 0; i < STAR_COUNT; i++) {
   float skySize = 1000;
   starX[i] = random(-skySize, skySize);
   starY[i] = random(-400, -100);
   starZ[i] = random(-skySize, skySize);
 }  
}

public void drawSky() {
  drawStars();
}


public void drawStars() {
 
  float starForce = tweaker.value("stars", 1f);
  
  float starSize = max(1f, starForce);
  
  if (starForce > 0.01f) {
    stroke(55, 34, 95, starForce * 100f);
    strokeWeight(3.5f * starSize);
    beginShape(POINTS);
    for (int i = 0; i < STAR_COUNT; i++) {
      vertex(starX[i], starY[i], starZ[i]);
    }
    endShape();
  }
  
  
}

class Terrain {
  
  int size;
  float cellSize;
  float[][] heights;
  PVector start;
  PVector end;
  float kumpareDepth;
  float kumparePIsiirto;
  float kumpareKorkeus;
  float surfaceRandomization;
  boolean showGrass;
  
  PShape terrainShape;
  boolean terrainBuilt = false;
  
  Terrain(float cellSize, float kumpareDepth, float kumparePIsiirto, float kumpareKorkeus, float surfaceRandomization, boolean showGrass) {
    
    this.size = 30;
    this.cellSize = cellSize;
    this.kumpareDepth = kumpareDepth;
    this.kumparePIsiirto = kumparePIsiirto;
    this.end = new PVector();
    this.start = new PVector();
    this.heights = new float[size][size];
    this.kumpareKorkeus = kumpareKorkeus;
    this.surfaceRandomization = surfaceRandomization;
    this.showGrass = showGrass;
    
    for(int x = 0; x < size; x++) {
     for (int z = 0; z < size; z++) {
         float pikkukumpare= noise(x * 0.1f + surfaceRandomization * 234.982f, z * 0.1f + surfaceRandomization * 123.123f) * cellSize * size * 0.05f;
         float worldX = x * cellSize - size / 2 * cellSize;
         float worldZ = z * cellSize - size / 2 * cellSize;
         float distance = sqrt(worldX * worldX + worldZ * worldZ);
         float kumpare = sin(distance * kumpareDepth * PI + kumparePIsiirto * PI);
         
         heights[x][z] = kumpare * kumpareKorkeus + pikkukumpare * -4;
     }
    }
  }
  
  public void rebuild() {
    terrainBuilt = false;
  }
  
  int summerGround = color(25, 30, 26);
  int autumnGround = color(19, 40, 55);

  int grassBaseColor = color(19, 40, 55);
  int grassMidColor = color(19, 40, 55);
  int grassTopColor = color(19, 40, 55);

  int grassBaseSummerColor = color(30, 30, 25);
  int grassMidSummerColor = color(30, 40, 35);
  int grassTopSummerColor = color(24, 25, 45);
  
  int grassBaseAutumnColor = color(25, 20, 35);
  int grassMidAutumnColor = color(20, 24, 45);
  int grassTopAutumnColor = color(15, 20, 55);
  
  public void draw() {
    if (!terrainBuilt) {
      // This builds the ground and forest into terrainShape
      terrainBuilt = true;
      buildTerrain();
    }
    
    // Draw the ground and forest (they don't move)
    shape(terrainShape);
    
    
    // Draw grass, it moves from frame to frame in the wind
    pushMatrix();
    
    float autumness = tweaker.value("atumness");
    int groundColor = lerpColor(summerGround, autumnGround, autumness);
    
    grassBaseColor = lerpColor(grassBaseSummerColor, grassBaseAutumnColor, autumness);
    grassMidColor  = lerpColor(grassMidSummerColor, grassMidAutumnColor, autumness);
    grassTopColor  = lerpColor(grassTopSummerColor, grassTopAutumnColor, autumness);
    
    fill(groundColor);
    translate(-cellSize * size / 2, 58, -cellSize * size / 2);
    beginShape(LINES);
    if (showGrass) {
      for(int x = 0; x < size - 1; x++) {
       for (int z = 0; z < size - 1; z++) {
           float dX = x - size / 2;
           float dZ = z - size / 2;
           float centerDistance = sqrt(dX * dX + dZ * dZ);
           float grassAmount = max(0, map(centerDistance, 0, size / 2.8f, 20, 0));
           drawItems(x, z, (int) grassAmount, cellSize * 0.2f, true);
         }    
       }
    }

    // Trees
    if (!showGrass) {
      for(int x = 0; x < size - 1; x++) {
        for (int z = 0; z < size - 1; z++) {
        drawItems(x, z, 2, cellSize * 0.8f, false); 
       }
      }
    }

    popMatrix();
    
    
  }
  
  // Build the terrain into the terrainShape PShape 
  public void buildTerrain() {
    terrainShape = createShape();
    
    terrainShape.translate(-cellSize * size / 2, 58, -cellSize * size / 2);
    
    // Ground
    terrainShape.beginShape(TRIANGLES);
    terrainShape.noStroke();
    terrainShape.fill(summerGround);
    for(int x = 0; x < size - 1; x++) {
     for (int z = 0; z < size - 1; z++) {
         drawCell(terrainShape, x, z);
     }
    }
    terrainShape.endShape();
    
    
    
  }
  
  public void drawCell(PShape terrainShape, int cellX, int cellZ) {
    float y1 = heights[cellX][cellZ];
    float y2 = heights[cellX + 1][cellZ];
    float y3 = heights[cellX][cellZ + 1];
    float y4 = heights[cellX+1][cellZ + 1];
    
    float x1 = cellSize * cellX;
    float x2 = cellSize * (cellX + 1);
    
    float z1 = cellSize * cellZ;
    float z2 = cellSize * (cellZ + 1); 
    
    drawTriangle(terrainShape, x1, y1, z1, x2, y2, z1, x1, y3, z2, cellX, cellZ, cellX + 1, cellZ, cellX, cellZ + 1);
    drawTriangle(terrainShape, x2, y2, z1, x2, y4, z2, x1, y3, z2, cellX + 1, cellZ, cellX + 1, cellZ + 1, cellX, cellZ + 1);
   
    
  }
  
  public void drawItems(int cellX, int cellZ, int itemAmount, float shuffle, boolean drawGrass) {
    
    strokeWeight(2);

    for (int x = 0; x < itemAmount; x++) {
      
      for (int z = 0; z < itemAmount; z++) {
        
        float dX = x * 1f / itemAmount * cellSize;
        float dZ = z * 1f / itemAmount * cellSize;
        
        float gX = cellX * cellSize + dX;
        float gZ = cellZ * cellSize + dZ;
        
        float tX = map(noise(gX, gZ), 0, 1, -shuffle, shuffle);
        float tZ = map(noise(gX + 113.35f, gZ + 142.93f), 0, 1, -shuffle, shuffle);
        
        gX += tX;
        gZ += tZ;
        
        float y1 = heights[cellX][cellZ];
        float y2 = heights[cellX + 1][cellZ];
        float y3 = heights[cellX][cellZ + 1];
        float y4 = heights[cellX + 1][cellZ + 1];
        
        float yA = map(x, 0, itemAmount, y1, y2);
        float yB = map(x, 0, itemAmount, y3, y4);
        float yC = map(z, 0, itemAmount, yA, yB);
        
        float windSpeed = 0.25f;
        float windAmount = cellSize * 0.2f;
        float wX = map(noise(secondsFromStart() * windSpeed + gX * 2.437f + gZ * 2.56f), 0, 1, -windAmount, windAmount);
        float wZ = map(noise(secondsFromStart() * windSpeed + 9.4992f + gZ * 3.154f  + gX * 4.65f), 0, 1, -windAmount, windAmount);
        
        if (drawGrass == true) {
          // Draw moving gras
          beginShape(LINES);
          
          stroke(grassBaseColor);
          vertex(gX, yC, gZ);
          stroke(grassMidColor);
          vertex(gX + wX, yC - 2, gZ + wZ);

          // Tip
          vertex(gX + wX, yC - 2, gZ + wZ); // Same as the end point of the base section above
          stroke(grassTopColor);
          float tipWindIncrease = 2.0f; // Increase wind to bow it more at the tip
          vertex(gX + wX * tipWindIncrease, yC - 3, gZ + wZ * tipWindIncrease); 
          
          endShape();
        } else {
          noStroke();
          // Trees, we draw these to the terrainShape PShape
          start.set(gX, yC + 0.1f, gZ);
          end.set(gX, yC - 8, gZ);
         
          drawTree(start, end, 3, 1, 0.1f, 20);
        }
      } 
    }
  }
  
  public void calculateNormal(PShape terrainShape, int x, int z) {
    if (x <= 0 || x >= size - 1 ||
        z <= 0 || z >= size - 1) {
       terrainShape.normal(0, -1, 0);
       return;
    }
    
   float yx1 = heights[x-1][z];
   float yx2 = heights[x+1][z];
   
   float yz1 = heights[x][z-1];
   float yz2 = heights[x][z+1];
   
   tempVn.x = yx2 - yx1;
   tempVn.y = -cellSize * 2;
   tempVn.z = yz2 - yz1;
   
   tempVn.normalize();
   
   terrainShape.normal(tempVn.x, tempVn.y, tempVn.z);
  }

  
  public void drawTriangle(PShape terrainShape, float xA, float yA, float zA, float xB, float yB, float zB, float xC, float yC, float zC, 
                    int cellXA, int cellZA, int cellXB, int cellZB, int cellXC, int cellZC) {
    noStroke();
    
    tempV1.set(xB - xA, yB - yA, zB - zA);
    tempV2.set(xC - xA, yC - yA, zC - zA);
     
    calculateNormal(terrainShape, cellXA, cellZA);
    terrainShape.vertex(xA, yA, zA);
    
    calculateNormal(terrainShape, cellXB, cellZB);
    terrainShape.vertex(xB, yB, zB);
    
    calculateNormal(terrainShape, cellXC, cellZC);
    terrainShape.vertex(xC, yC, zC);
  }
}

PVector tempV1 = new PVector();
PVector tempV2 = new PVector();
PVector tempVn = new PVector();
class VoxelCastle {
  
  Voxels voxels;
  
  XoroShiro random = new XoroShiro();

  long seed;
  
  int volumeX = 100;
  int volumeY = 70;
  int volumeZ = 100;
  
  VoxelCastle(float voxelSize, float posX, float posY, float posZ, long seed) {
    voxels = new Voxels(voxelSize, volumeX, volumeY, volumeZ);
    voxels.position.x += posX;
    voxels.position.y += posY;
    voxels.position.z += posZ;
    this.seed = seed;
    random.setSeed(seed);
    
    //generateRubble(60, 50, 4, 400, seed + 1);
    //generateRubble(65, 55, 6, 700, seed + 3);
    //generateTower(50, 0, 50, 8, 4, 8, 3, 2, 0.5f, 42);
    
    generateCastle(42);
    
    //generateRoom(50, 0, 50, 8, 16, 8);
    
  }
  
  public void draw() {
    voxels.draw();
  }
  
  
  public void generateCastle(long seed) {
    random.setSeed(seed);
  
    // Lets have some rubble
    int rubblePiles = random.nextInt(5, 20);
    for (int i = 0; i < rubblePiles; i++) {
      generateRubble(random.nextInt(30, volumeX - 30), random.nextInt(30, volumeX - 30), random.nextInt(3, 7), random.nextInt(10, 700), seed + i + 11);     
    }
    
    int baseY = 20;
    
    // Default castle
    //  generateWalls(50, 0, 55, 30, 23, 5, 4, 8, 1, 4, seed + 6);

    // Generate several concentric castles
    int castleNum = 3;
    for (int i = 0; i < castleNum; i++) {
      float relCenter = map(i, 0, castleNum-1, 0, 1);
      float baseSize = map(i, 0, castleNum -1, volumeX * 0.6f, volumeX * 0.2f);
      int minLevels = (int) map(relCenter, 0, 1, 1, 3);
      generateWalls(
        (int) random.nextGaussianFloat(volumeX/2, baseSize*0.2f),
        baseY,
        (int) random.nextGaussianFloat(volumeZ/2, baseSize*0.2f),
        (int) random.nextGaussianFloat(baseSize, baseSize*0.2f),
        (int) random.nextGaussianFloat(baseSize, baseSize*0.2f),
        random.nextInt(i*2, 3 + i * 4),
        random.nextInt(4, 6),
        random.nextInt(4, 10),
        minLevels,
        random.nextInt(minLevels + i, minLevels + i * 2),
        baseY,
        seed + 17 * i);
    }
    
    // Central tower
    generateTower(volumeX/2, baseY, volumeZ/2, 12, 12, 10, 4, 3, 0.8f, baseY, seed + 71);
  }
  
  public void generateWalls(int centerX, int baseY, int centerZ, int sizeX, int sizeZ, int wallHeight, int wallWidth, int towerDiam, int towerMinLevels, int towerMaxLevels, int foundationDepth, long seed) {
    random.setSeed(seed);
    float windowProb = 0.5f;
    generateTower(centerX - sizeX/2, baseY, centerZ - sizeZ/2, towerDiam, towerDiam, 8, random.nextInt(towerMinLevels,towerMaxLevels), 2, windowProb, foundationDepth, seed+1);
    generateTower(centerX + sizeX/2, baseY, centerZ - sizeZ/2, towerDiam, towerDiam, 8, random.nextInt(towerMinLevels,towerMaxLevels), 2, windowProb, foundationDepth, seed+2);
    generateTower(centerX - sizeX/2, baseY, centerZ + sizeZ/2, towerDiam, towerDiam, 8, random.nextInt(towerMinLevels,towerMaxLevels), 2, windowProb, foundationDepth, seed+3);
    generateTower(centerX + sizeX/2, baseY, centerZ + sizeZ/2, towerDiam, towerDiam, 8, random.nextInt(towerMinLevels,towerMaxLevels), 2, windowProb, foundationDepth, seed+4);
    
    int wallsOverhang = 0;
    generateTower(centerX + sizeX/2, baseY, centerZ, wallWidth, sizeZ, wallHeight, 1, wallsOverhang, 0f, foundationDepth, seed+7);
    generateTower(centerX - sizeX/2, baseY, centerZ, wallWidth, sizeZ, wallHeight, 1, wallsOverhang, 0f, foundationDepth, seed+8);
    generateTower(centerX, baseY, centerZ - sizeZ/2, sizeX, wallWidth, wallHeight, 1, wallsOverhang, 0f, foundationDepth, seed+9);
    generateTower(centerX, baseY, centerZ + sizeZ/2, sizeX, wallWidth, wallHeight, 1, wallsOverhang, 0f, foundationDepth, seed+11);
  }
  
  public void generateTower(int centerX, int baseY, int centerZ, int sizeX, int sizeZ, int levelHeight, int levels, int overhang, float windowProb, int foundationDepth, long seed) {
    // Rooms
    for (int level = 0; level < levels; level++) {
      generateRoom(centerX, baseY + level * levelHeight, centerZ, sizeX, levelHeight, sizeZ, windowProb, seed + level * 31);
    }
    
    // Wide roof
    int roofBase = baseY + levels * levelHeight;
    int upperWidthX = sizeX + overhang * 2;
    int upperWidthZ = sizeZ + overhang * 2;
    makeWall(centerX, roofBase, centerZ, upperWidthX, 1, upperWidthZ, false);
    
    // Crenelations
    generateCrenellations(centerX, roofBase + 1, centerZ - upperWidthZ/2, upperWidthX, false, 2, 2, 0, 2);
    generateCrenellations(centerX, roofBase + 1, centerZ + upperWidthZ/2, upperWidthX, false, 2, 2, 0, 2);
    generateCrenellations(centerX - upperWidthX/2, roofBase + 1, centerZ, upperWidthZ, true, 2, 2, 0, 2);
    generateCrenellations(centerX + upperWidthX/2, roofBase + 1, centerZ, upperWidthZ, true, 2, 2, 0, 2);
    
    // Foundation
    generateRoom(centerX, baseY - foundationDepth-1, centerZ, sizeX, foundationDepth, sizeZ, 0, seed * 12);
  }
  
  public void generateRubble(int centerX, int centerZ, float radius, int count, long seed) {
    random.setSeed(seed);
    for (int i = 0; i < count; i++) {
      int x = (int) random.nextGaussianFloat(centerX, radius);
      int z = (int) random.nextGaussianFloat(centerZ, radius);
      int y = voxels.countY - 1;
      
      // Drop stone
      while(y > 0 && voxels.get(x, y - 1, z) == 0) {
        y--;
      }
      
      voxels.set(x, y, z, randomBlock(x, y, z));
    }
  }

  public void generateCrenellations(int centerX, int baseY, int centerZ, int length, boolean alongX, int baseHeight, int topHeight, int gapRadius, int topLen) {
    int sizeX = 1;
    int sizeZ = 1;
    if (alongX) sizeZ = length;
    else sizeX = length;
    
    // Fill all
    makeWall(centerX, baseY, centerZ, sizeX, baseHeight + topHeight - 1, sizeZ, false);
    
    // Cutouts
    int p = 0;
    int baseX = centerX - sizeX / 2;
    int baseZ = centerZ - sizeZ / 2;
    while (p < length) {
      int c = p + (gapRadius*2+1 + topLen) / 2;
      int x = baseX;
      int z = baseZ;
      if (alongX) z += c;
      else x += c;
      
      // Clear gap
      int gr = gapRadius;
      voxels.clearVolume(x - gr, baseY + baseHeight, z - gr, x + gr, baseY + baseHeight + topHeight - 1, z + gr);
      
      p += gapRadius*2+1 + topLen;
    }
  }
  
  public void generateRoom(int centerX, int baseY, int centerZ, int sizeX, int sizeY, int sizeZ, float windowProb, long seed) {
    random.setSeed(seed);
    int x1 = centerX - sizeX/2;
    int x2 = centerX + sizeX/2;
    int z1 = centerZ - sizeZ/2;
    int z2 = centerZ + sizeZ/2;
    makeWall(x1, baseY, centerZ, 1, sizeY, sizeZ, random.nextBoolean(windowProb));
    makeWall(x2, baseY, centerZ, 1, sizeY, sizeZ, random.nextBoolean(windowProb));
    makeWall(centerX, baseY, z1, sizeX, sizeY, 1, random.nextBoolean(windowProb));
    makeWall(centerX, baseY, z2, sizeX, sizeY, 1, random.nextBoolean(windowProb));

    // Base floor
    makeWall(centerX, baseY, centerZ, sizeX, 1, sizeZ, false);

    // Ceiling
    makeWall(centerX, baseY + sizeY, centerZ, sizeX, 1, sizeZ, false);
    
    // Darkness inside
    voxels.setVolume(x1+1, baseY+1, z1+1, x2-1, baseY+sizeY-1, z2-1, voxels.DARKNESS);
  }

  
  public void makeWall(int centerX, int baseY, int centerZ, int sizeX, int sizeY, int sizeZ, boolean cutWindow) {
    for (int x = centerX - sizeX/2; x <= centerX + sizeX/2; x++)
      for (int y = baseY; y < baseY + sizeY; y++)
        for (int z = centerZ - sizeZ/2; z <= centerZ + sizeZ/2; z++)
          voxels.set(x, y, z, randomBlock(x, y, z));    
          
    if (cutWindow) {
      int windowRad = 1;
      int windowBase = 2;
      int windowHeight = 5;
      voxels.clearVolume(centerX - windowRad, baseY + windowBase, centerZ -windowRad, 
                         centerX + windowRad, min(baseY + windowBase + windowHeight-1, baseY + sizeY-1), centerZ + windowRad);
    }
  }

  
  
  public int randomBlock(int x, int y, int z) {
    random.setSeed(x, y, z);
    
    int posBased = (int) (map(y, 0, voxels.countY, voxels.GRANITE_FIRST, voxels.GRANITE_LAST) + random.nextGaussianFloat(0f, 3f));
    if (posBased < voxels.GRANITE_FIRST) posBased = voxels.GRANITE_FIRST;
    if (posBased > voxels.GRANITE_LAST) posBased = voxels.GRANITE_LAST;
    
    return posBased;
  }



  // Returns false if no castle wall nearby.
  public boolean getCastleDistance(PVector position, PVector vectorToClosestWall) {
    return voxels.getClosestBlock(position, vectorToClosestWall);
  }
  

}


/** Actually, we need a voxelengine too!  Lets keep it simple with one chunk and limited world size.  */
class Voxels {
  
  int countX;
  int countY;
  int countZ;

  byte voxels[][][];
  
  int blockColors[];
  
  int VOID = 0;
  int DARKNESS = 1;
  int GRANITE_FIRST = 2;
  int GRANITE_LAST = 50;
  
  float voxelSize = 0.25f;
  
  PVector position = new PVector();
  
  private boolean redrawNeeded = true;
  
  private PShape shape;
  
  private PVector tempCenter = new PVector();
  
  private int byteToUnsignedMask = 0xFF;
  
  private XoroShiro random = new XoroShiro(1234);
  
  Voxels(float voxelSize, int countX, int countY, int countZ) {
    
    this.voxelSize = voxelSize;
    this.countX = countX;
    this.countY = countY;
    this.countZ = countZ;
  
    blockColors = new int[256];
    initBlockColors();
  
    // Center x and z
    position.set(-countX * voxelSize / 2f, 0, -countX * voxelSize / 2f);
    
    // Allocate the matixes!
    voxels = new byte[countX][countY][countZ];
  }

  public void set(int x, int y, int z, int type) {
    if (x >= 0 && x < countX && 
        y >= 0 && y < countY && 
        z >= 0 && z < countZ) {
      voxels[x][y][z] = (byte)type;
    }
  }
  
  public int get(int x, int y, int z) {
    if (x >= 0 && x < countX && 
        y >= 0 && y < countY && 
        z >= 0 && z < countZ) {
      return voxels[x][y][z] & byteToUnsignedMask;
    }
    else {
      return 0;
    }
  }
  
  public boolean isSolid(int x, int y, int z) {
    return get(x, y, z) != 0;
  }

  public void clearVolume(int x1, int y1, int z1, 
                   int x2, int y2, int z2) {
    setVolume(x1, y1, z1, x2, y2, z2, 0);
  }

  public void setVolume(int x1, int y1, int z1, 
                 int x2, int y2, int z2, 
                 int type) {
                        
    int x = x1;
    int y = y1;
    int z = z1;
    
    /*
    // Swap so x1 is smaller than x2, etc.
    if (x2 < x1) {
      x1 = x2;
      x2 = x;
    }
    if (y2 < y1) {
      y1 = y2;
      y2 = y;
    }
    if (z2 < z1) {
      z1 = z2;
      z2 = z;
    }
    */
    
    // Fill x1 .. x2 etc with blocks (inclusicve)
    for (x = x1; x <= x2; x++)
      for (y = y1; y <= y2; y++)
        for (z = z1; z <= z2; z++)
          set(x, y, z, type);
  }

  public void clear(int x, int y, int z) {
    set(x, y, z, 0);
  }

  public void initBlockColors() {
    // These need to multiply up to 255
    int hueCount = 8;
    int satCount = 8;
    int lumCount = 4;
    
    // Palette with hues with various saturations and brightness runs
    int colorIndex = 0;
    for (int sat = 0; sat < satCount; sat++) {
      for (int lum = 0; lum < lumCount; lum++) {
        for (int hue = 0; hue < hueCount; hue++) {
          blockColors[colorIndex++] = color((hue+1) * 100/hueCount, 
                                            map((sat+1) * 100/satCount, 0, 100, 0, 10), 
                                            map((lum+1) * 100/lumCount, 0, 100, 40, 60));
        }
      }
    }
    
    // Purposeful named colors
    blockColors[DARKNESS] = color(0, 0, 0);    
    for (int i = GRANITE_FIRST; i <= GRANITE_LAST; i++) {
      float p = map(i, GRANITE_FIRST, GRANITE_LAST, 0, 1);
      blockColors[i] = color(map(p, 0, 1, 70, 10) + random.nextGaussianFloat(0f, 5f), 
                             map(p, 0, 1, 30, 20) + random.nextGaussianFloat(0f, 5f), 
                             map(p, 0, 1, 40, 70) + random.nextGaussianFloat(0f, 5f));
    }
    
  }


  public void toWorldPos(int x, int y, int z, PVector out) {
    out.x = (x + 0.5f) * voxelSize + position.x;
    out.y = (y + 0.5f) * voxelSize + position.y;
    out.z = (z + 0.5f) * voxelSize + position.z;
  }

  private void setVectorToBlock(int x, int y, int z, PVector pos, PVector deltaOut) {
    toWorldPos(x, y, z, deltaOut);
    deltaOut.sub(pos);
  }


  private PVector tempDelta = new PVector();
  public boolean getClosestBlock(PVector pos, PVector vectorToClosestWall) {
    int voxelX = (int) ((pos.x - position.x) / voxelSize);
    int voxelY = (int) ((pos.y - position.y) / voxelSize);
    int voxelZ = (int) ((pos.z - position.z) / voxelSize);
    
    // Check if we found it.
    if (isSolid(voxelX, voxelY, voxelZ)) {
      setVectorToBlock(voxelX, voxelY, voxelZ, pos, vectorToClosestWall);
      return true;
    }
    
    int searchRadius = 8; // Look this many blocks in all directions for a solid block
    for (int i = 1; i < searchRadius; i++) {
      
      // This recalculates the insides multiple times, but it's 3 am and we got 9 hours left.
      // Should only add a constant factor of about 2 or so anyway.
      float closestDistSquared = -1;
      boolean foundClosestDist = false;
      for (int x = voxelX - i; x <= voxelX + 1; x++) 
        for (int y = voxelY - i; y <= voxelY + 1; y++) 
          for (int z = voxelZ - i; z <= voxelZ + 1; z++) {
            if (isSolid(x, y, z)) {
              // Hit wall, get dist
              setVectorToBlock(x, y, z, pos, tempDelta);
              float distSquared = tempDelta.magSq();
              if (!foundClosestDist || distSquared < closestDistSquared) {
                foundClosestDist = true;
                closestDistSquared = distSquared;
                vectorToClosestWall.set(tempDelta);
              }
            }
          }
          
      if (foundClosestDist) return true;  // We found a solid block, and wrote direction vector to it.  
    }

    // No matches within search radius, give up.
    return false;
  }
  


  public void redraw() {
    redrawNeeded = true;
  }

  public void draw() {
    if (redrawNeeded) {
      buildShape();
      redrawNeeded = false;
    }
    
    shape(shape);
  }
  
  private void buildShape() {
    shape = createShape();
    shape.beginShape(TRIANGLES);
    float xPos = 0f;
    float yPos = 0f;
    float zPos = 0f;
    
    for (int z = 0; z < countZ; z++) {
      zPos = z * voxelSize;
      for (int y = 0; y < countY; y++) {
        yPos = y * voxelSize;
        for (int x = 0; x < countX; x++) {
          xPos = x * voxelSize;
          
          int voxelType = voxels[x][y][z] & byteToUnsignedMask;
          
          if (voxelType != 0) {                          
            tempCenter.set(xPos + voxelSize * 0.5f + position.x, 
                           -(yPos + voxelSize * 0.5f + position.y), 
                           zPos + voxelSize * 0.5f + position.z);
            drawBlock(tempCenter, blockColors[voxelType]);
          }
        }
      }
    }
    shape.endShape();
  }
  
  private PVector tC = new PVector(); 
  private PVector tU = new PVector(); 
  private PVector tV = new PVector(); 
  private PVector unitX = new PVector(1, 0, 0); 
  private PVector unitY = new PVector(0, 1, 0); 
  private PVector unitZ = new PVector(0, 0, 1); 
  private void drawBlock(PVector center, int c) {
    shape.fill(c);
    
    addScaled(tC.set(center), unitX, voxelSize*0.5f);
    drawFace(tC, unitY, unitZ, false);

    addScaled(tC.set(center), unitX, -voxelSize*0.5f);
    drawFace(tC, unitZ, unitY, true);

    addScaled(tC.set(center), unitY, voxelSize*0.5f);
    drawFace(tC, unitX, unitZ, false);

    addScaled(tC.set(center), unitY, -voxelSize*0.5f);
    drawFace(tC, unitZ, unitX, true);

    addScaled(tC.set(center), unitZ, voxelSize*0.5f);
    drawFace(tC, unitY, unitX, false);

    addScaled(tC.set(center), unitZ, -voxelSize*0.5f);
    drawFace(tC, unitX, unitY, true);

  }
  
  private PVector tempA  = new PVector();
  private PVector tempB  = new PVector();
  private PVector tempC  = new PVector();
  private PVector tempD  = new PVector();
  private void drawFace(PVector center, PVector u, PVector v, boolean flip) {
    
    tempA.set(center);
    tempB.set(center);
    tempC.set(center);
    tempD.set(center);
    
    addScaled(tempA, u, -voxelSize * 0.5f);
    addScaled(tempA, v, -voxelSize * 0.5f);

    addScaled(tempB, u,  voxelSize * 0.5f);
    addScaled(tempB, v, -voxelSize * 0.5f);

    addScaled(tempC, u,  voxelSize * 0.5f);
    addScaled(tempC, v,  voxelSize * 0.5f);

    addScaled(tempD, u, -voxelSize * 0.5f);
    addScaled(tempD, v,  voxelSize * 0.5f);

    if (flip) {
      makeShapeRectangle(shape, tempA, tempB, tempC, tempD);
    }
    else {
      makeShapeRectangle(shape, tempD, tempC, tempB, tempA);
    }
  }
  
}


/**  An utility class for storing a three dimensional vector made from integers instead of floating point numbers.  */  
class Int3 {
  int x = 0;
  int y = 0;
  int z = 0;

  Int3() {
    this(0);
  }

  Int3(int value) {
    this(value, value, value);
  }

  Int3(int x, int y, int z) {
    set(x, y, z);
  }
  
  Int3(PVector v) {
    this(round(v.x), 
         round(v.y), 
         round(v.z));
  }
  










  
  Int3(Int3 i) {
    this(i.x, i.y, i.z);
  }
  

  public void set(int x, int y, int z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  public void set(Int3 i) {
    set(i.x, i.y, i.z);
  }

  public @Override int hashCode() {
    return ((((x * 31) + y) * 31) + z) * 31;     
  }
  
  public @Override boolean equals(Object other) {
    if (this == other) return true;
    
    if (other == null) return false;

    if (this.getClass() != other.getClass()) return false;
    
    Int3 otherInt3 = (Int3)other;
    return x == otherInt3.x &&
           y == otherInt3.y &&
           z == otherInt3.z; 
           
  }
   
}

private PVector tempScaled = new PVector();

public void addScaled(PVector v, PVector v2, float scale){
  tempScaled.set(v2);
  tempScaled.mult(scale);
  v.add(tempScaled);
}  

public void vertex(PVector v){
 vertex(v.x, v.y, v.z);
} 



/** Returns number of seconds since the start of the demo.  */
public float secondsFromStart() {
  return (float) tweaker.getTime().getCurrentStepElapsedSeconds();
}


/** Returns number of seconds since the specified time (as returned by secondsFromStart()).  */
public float secondsSince(float timeSeconds) {
  return secondsFromStart() - timeSeconds;
}

private PVector u = new PVector();
private PVector v = new PVector();
private PVector t = new PVector(1, 0,0);

private PVector tempR1 = new PVector();
private PVector tempR2 = new PVector();
private PVector dcTempNorm = new PVector();
private PVector tempDir = new PVector();

public void drawCylinder(PVector startpos, PVector endpos, float bottomwidth, float topwidth,int sides){
   tempDir.set(0, -1, 0);
   drawCylinder(tempDir, startpos, endpos, bottomwidth, topwidth,sides);
}

public void drawCylinder(PVector direction, PVector startpos, PVector endpos, float bottomwidth, float topwidth,int sides){
   
   if (direction.equals(t)){
       t.set(0,0,1);
   }  
   t.cross(direction, u);
   u.cross(direction, v);
   u.normalize();
   v.normalize();
   
   float angle = 0;
   float angleIncrement = TWO_PI / sides;
   beginShape(QUAD_STRIP);
   for (int i = 0; i < sides + 1; ++i) {
     
     // Normal is straight out
     dcTempNorm.set(0,0,0);     
     addScaled(dcTempNorm,u,cos(angle));
     addScaled(dcTempNorm,v,sin(angle));
     normal(dcTempNorm.x, dcTempNorm.y, dcTempNorm.z);
     
     // Bottom pos
     tempR1.set(startpos);
     addScaled(tempR1,u,cos(angle)*bottomwidth);
     addScaled(tempR1,v,sin(angle)*bottomwidth);
     vertex(tempR1);
     
     // Top pos
     tempR2.set(endpos);
     addScaled(tempR2,u,cos(angle)*topwidth);
     addScaled(tempR2,v,sin(angle)*topwidth);
     vertex(tempR2);
     
     angle += angleIncrement;
   }
   endShape();
 }  

public void drawTree(PVector startpos, PVector endpos, float bottomwidth, float bottomwidth2, float topwidth,int sides){
   tempDir.set(0, -1, 0);
   drawTree(tempDir, startpos, endpos, bottomwidth, bottomwidth2, topwidth, sides);
}

public void drawTree(PVector direction, PVector startpos, PVector endpos, float bottomwidth, float bottomwidth2, float topwidth,int sides){
   
   if (direction.equals(t)){
       t.set(0,0,1);
   }  
   t.cross(direction, u);
   u.cross(direction, v);
   u.normalize();
   v.normalize();
   
   float angle = 0;
   float angleIncrement = TWO_PI / sides;
   beginShape(QUAD_STRIP);
   fill(29, 50, 55);
   for (int i = 0; i < sides + 1; ++i) {
     
     // Normal is straight out
     dcTempNorm.set(0,0,0);     
     addScaled(dcTempNorm,u,cos(angle));
     addScaled(dcTempNorm,v,sin(angle));
     normal(dcTempNorm.x, dcTempNorm.y, dcTempNorm.z);
     
     // Bottom pos
     tempR1.set(startpos);
     if (i % 2 == 0) {
       addScaled(tempR1,u,cos(angle)*bottomwidth2);
       addScaled(tempR1,v,sin(angle)*bottomwidth2);
       vertex(tempR1.x, tempR1.y, tempR1.z);
     } else {
       addScaled(tempR1,u,cos(angle)*bottomwidth);
       addScaled(tempR1,v,sin(angle)*bottomwidth);
       vertex(tempR1.x, tempR1.y, tempR1.z);
     }
     
     // Top pos
     tempR2.set(endpos);
     addScaled(tempR2,u,cos(angle)*topwidth);
     addScaled(tempR2,v,sin(angle)*topwidth);
     vertex(tempR2.x, tempR2.y, tempR2.z);
     
     angle += angleIncrement;
   }
   endShape();
 }  

public void makeRectangle(PVector a, PVector b, PVector c, PVector d) {
  makeTriangle(a, b, d);  
  makeTriangle(b, c, d);  
}

private PVector mtTempNormal = new PVector();
private PVector mtTempAB = new PVector();
private PVector mtTempAC = new PVector();
public void makeTriangle(PVector a, PVector b, PVector c) {
  
  // Calculate normal for triangle
  mtTempAB.set(b).sub(a);
  mtTempAC.set(c).sub(a);
  mtTempAB.cross(mtTempAC, mtTempNormal);
  mtTempNormal.normalize();
  
  // Triangle corners and their normals
  normal(mtTempNormal.x, mtTempNormal.y, mtTempNormal.z);
  vertex(a.x, a.y, a.z);
  vertex(b.x, b.y, b.z);
  vertex(c.x, c.y, c.z);
}



public void makeShapeRectangle(PShape shape, PVector a, PVector b, PVector c, PVector d) {
  makeShapeTriangle(shape, a, b, d);  
  makeShapeTriangle(shape, b, c, d);  
}

public void makeShapeTriangle(PShape shape, PVector a, PVector b, PVector c) {
  
  // Calculate normal for triangle
  mtTempAB.set(b).sub(a);
  mtTempAC.set(c).sub(a);
  mtTempAB.cross(mtTempAC, mtTempNormal);
  mtTempNormal.normalize();
  
  // Triangle corners and their normals
  shape.normal(mtTempNormal.x, mtTempNormal.y, mtTempNormal.z);
  shape.vertex(a.x, a.y, a.z);
  shape.vertex(b.x, b.y, b.z);
  shape.vertex(c.x, c.y, c.z);
}
  public void settings() {  fullScreen(P3D); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "castleIvy" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
