/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.HashMap;
import org.demotweaker.StepListener;
import org.demotweaker.Tweaker;
import org.demotweaker.Variable;
import org.mistutils.interpolation.Interpolator;
import org.mistutils.interpolation.interpolators.PowInterpolator;
import org.mistutils.random.XoroShiro;
import org.mistutils.time.Time;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PShape;
import processing.core.PVector;
import processing.event.MouseEvent;

public class castleIvy
extends PApplet {
    Tweaker tweaker;
    Terrain castleHill;
    Terrain bgHill1;
    Terrain bgHill2;
    Ivy ivy1;
    Ivy ivy2;
    Ivy ivy3;
    Ivy ivy4;
    Ivy ivy5;
    Ivy ivy6;
    VoxelCastle castle;
    ActionCam camera;
    String MUSIC_FILE = "Majestic Hills.mp3";
    float DEMO_LENGTH_SECONDS = 199.0f;
    float BEATS_PER_MINUTE = 68.0f;
    Minim minim;
    AudioPlayer audioPlayer;
    String credits = "Forest Ivy Castle\n\nby GeoScapers\n\ncoded in 29 hours\nfor Graffathon 2019\n\n  Ivy by Shiera\n  Castle by fractalpixel\n  Background by SierraFox\n\nMusic: \"Majestic Hills\"\n    by: Kevin MacLeod\n    (creative commons cc-by)\n";
    PFont creditFont;
    String FONT_NAME = "JosefinSans-Bold.ttf";
    int STAR_COUNT = 1000;
    float[] starX = new float[this.STAR_COUNT];
    float[] starY = new float[this.STAR_COUNT];
    float[] starZ = new float[this.STAR_COUNT];
    PVector tempV1 = new PVector();
    PVector tempV2 = new PVector();
    PVector tempVn = new PVector();
    private PVector tempScaled = new PVector();
    private PVector u = new PVector();
    private PVector v = new PVector();
    private PVector t = new PVector(1.0f, 0.0f, 0.0f);
    private PVector tempR1 = new PVector();
    private PVector tempR2 = new PVector();
    private PVector dcTempNorm = new PVector();
    private PVector tempDir = new PVector();
    private PVector mtTempNormal = new PVector();
    private PVector mtTempAB = new PVector();
    private PVector mtTempAC = new PVector();

    public void setup() {
        this.randomSeed(42L);
        this.noiseSeed(5L);
        this.background(0);
        this.tweaker = new Tweaker(this.dataPath("tweakerSettings.json"), (double)this.DEMO_LENGTH_SECONDS, (double)(this.BEATS_PER_MINUTE / 60.0f));
        Variable cameraMode = this.tweaker.variable("cameraMode", 1.0f);
        cameraMode.setInterpolator((Interpolator)new PowInterpolator(10.0));
        this.minim = new Minim((Object)this);
        this.audioPlayer = this.minim.loadFile(this.MUSIC_FILE);
        this.camera = new ActionCam(this.tweaker);
        this.colorMode(3, 100.0f, 100.0f, 100.0f, 100.0f);
        this.noCursor();
        this.castleHill = new Terrain(7.0f, 0.005f, 0.5f, -30.0f, 2.0f, true);
        this.bgHill1 = new Terrain(13.0f, 0.0026f, 1.5E-5f, -135.0f, 5.0f, false);
        this.bgHill2 = new Terrain(25.0f, 8.0E-4f, 5.0E-4f, -150.0f, 9.0f, false);
        this.ivy1 = new Ivy(new PVector(0.0f, 3.0f, 0.0f), new PVector(0.0f, -1.0f, 0.0f));
        this.ivy2 = new Ivy(new PVector(30.0f, 14.0f, -32.0f), new PVector(0.0f, -1.0f, 0.0f), 400);
        this.ivy3 = new Ivy(new PVector(-35.0f, 14.0f, 0.0f), new PVector(0.0f, -1.0f, 0.0f));
        this.ivy4 = new Ivy(new PVector(-10.0f, 14.0f, -33.0f), new PVector(0.0f, -1.0f, 0.0f));
        this.ivy5 = new Ivy(new PVector(10.0f, 14.0f, 35.0f), new PVector(0.0f, -1.0f, 0.0f));
        this.ivy6 = new Ivy(new PVector(35.0f, 16.0f, 32.0f), new PVector(0.0f, -1.0f, 0.0f));
        this.castle = new VoxelCastle(0.9f, -10.0f, -15.0f, 0.0f, 653L);
        this.setupStars();
        this.initCredits();
        this.noStroke();
        this.fill(80);
        this.audioPlayer.play();
        this.tweaker.addListener(new StepListener(){

            public void onUpdate(Time time) {
            }

            public void onRestarted(Time time) {
                castleIvy.this.audioPlayer.rewind();
                castleIvy.this.audioPlayer.play();
            }

            public void onPaused(Time time) {
                castleIvy.this.audioPlayer.pause();
            }

            public void onPlaying(Time time) {
                castleIvy.this.audioPlayer.play();
            }
        });
    }

    public void draw() {
        this.hint(-2);
        this.pushMatrix();
        this.translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        this.scale((float)this.height / 100.0f);
        this.tweaker.update();
        this.camera.update();
        float hue = this.tweaker.value("hue", 0.0f) % 100.0f;
        float sat = this.tweaker.value("sat", 0.0f);
        float lum = this.tweaker.value("lum", 0.0f);
        this.background(hue, sat, lum);
        this.drawSky();
        float sun = this.tweaker.value("sun", 0.0f);
        this.directionalLight(80.0f, 30.0f, 30.0f, 0.2f, 0.2f, 0.1f);
        this.directionalLight(13.0f, 20.0f, 100.0f, castleIvy.sin((float)(sun * ((float)Math.PI * 2))), castleIvy.cos((float)(sun * ((float)Math.PI * 2))), 0.2f);
        this.ambientLight(70.0f, 20.0f, 40.0f);
        this.pushMatrix();
        this.castleHill.draw();
        this.popMatrix();
        this.pushMatrix();
        this.translate(0.0f, 90.0f, 0.0f);
        this.bgHill1.draw();
        this.bgHill2.draw();
        this.popMatrix();
        this.pushMatrix();
        this.ivy1.drawIvy();
        this.ivy2.drawIvy();
        this.ivy3.drawIvy();
        this.ivy4.drawIvy();
        this.ivy5.drawIvy();
        this.ivy6.drawIvy();
        this.popMatrix();
        this.castle.draw();
        if (this.tweaker.getTime().getCurrentStepElapsedSeconds() > (double)this.DEMO_LENGTH_SECONDS) {
            this.exit();
        }
        this.popMatrix();
        this.hint(2);
        float fade = this.tweaker.value("fade", 1.0f);
        if (fade < 0.999f) {
            this.fill(0.0f, 0.0f, 0.0f, (1.0f - fade) * 100.0f);
            this.rect(0.0f, 0.0f, this.width, this.height);
        }
        this.drawCredits();
    }

    public void mouseWheel(MouseEvent event) {
        float e = event.getCount();
        this.camera.changeDistance(e * 10.0f);
    }

    public void initCredits() {
        this.creditFont = this.createFont(this.FONT_NAME, 32.0f);
        int fontSize = 32 * this.width / 800;
        this.textSize(fontSize);
    }

    public void drawCredits() {
        float relPos = this.tweaker.value("creditsPos", -1.0f);
        this.fill(0.0f, 0.0f, 100.0f, 75.0f);
        if (relPos > -0.99f) {
            this.lights();
            float creditPos = -relPos * (float)this.height;
            this.fill(0.0f, 0.0f, 100.0f, 75.0f);
            this.text(this.credits, (float)this.width * 0.2f, creditPos);
        }
    }

    public void setupStars() {
        int i = 0;
        while (i < this.STAR_COUNT) {
            float skySize = 1000.0f;
            this.starX[i] = this.random(-skySize, skySize);
            this.starY[i] = this.random(-400.0f, -100.0f);
            this.starZ[i] = this.random(-skySize, skySize);
            ++i;
        }
    }

    public void drawSky() {
        this.drawStars();
    }

    public void drawStars() {
        float starForce = this.tweaker.value("stars", 1.0f);
        float starSize = castleIvy.max((float)1.0f, (float)starForce);
        if (starForce > 0.01f) {
            this.stroke(55.0f, 34.0f, 95.0f, starForce * 100.0f);
            this.strokeWeight(3.5f * starSize);
            this.beginShape(3);
            int i = 0;
            while (i < this.STAR_COUNT) {
                this.vertex(this.starX[i], this.starY[i], this.starZ[i]);
                ++i;
            }
            this.endShape();
        }
    }

    public void addScaled(PVector v, PVector v2, float scale) {
        this.tempScaled.set(v2);
        this.tempScaled.mult(scale);
        v.add(this.tempScaled);
    }

    public void vertex(PVector v) {
        this.vertex(v.x, v.y, v.z);
    }

    public float secondsFromStart() {
        return (float)this.tweaker.getTime().getCurrentStepElapsedSeconds();
    }

    public float secondsSince(float timeSeconds) {
        return this.secondsFromStart() - timeSeconds;
    }

    public void drawCylinder(PVector startpos, PVector endpos, float bottomwidth, float topwidth, int sides) {
        this.tempDir.set(0.0f, -1.0f, 0.0f);
        this.drawCylinder(this.tempDir, startpos, endpos, bottomwidth, topwidth, sides);
    }

    public void drawCylinder(PVector direction, PVector startpos, PVector endpos, float bottomwidth, float topwidth, int sides) {
        if (direction.equals((Object)this.t)) {
            this.t.set(0.0f, 0.0f, 1.0f);
        }
        this.t.cross(direction, this.u);
        this.u.cross(direction, this.v);
        this.u.normalize();
        this.v.normalize();
        float angle = 0.0f;
        float angleIncrement = (float)Math.PI * 2 / (float)sides;
        this.beginShape(18);
        int i = 0;
        while (i < sides + 1) {
            this.dcTempNorm.set(0.0f, 0.0f, 0.0f);
            this.addScaled(this.dcTempNorm, this.u, castleIvy.cos((float)angle));
            this.addScaled(this.dcTempNorm, this.v, castleIvy.sin((float)angle));
            this.normal(this.dcTempNorm.x, this.dcTempNorm.y, this.dcTempNorm.z);
            this.tempR1.set(startpos);
            this.addScaled(this.tempR1, this.u, castleIvy.cos((float)angle) * bottomwidth);
            this.addScaled(this.tempR1, this.v, castleIvy.sin((float)angle) * bottomwidth);
            this.vertex(this.tempR1);
            this.tempR2.set(endpos);
            this.addScaled(this.tempR2, this.u, castleIvy.cos((float)angle) * topwidth);
            this.addScaled(this.tempR2, this.v, castleIvy.sin((float)angle) * topwidth);
            this.vertex(this.tempR2);
            angle += angleIncrement;
            ++i;
        }
        this.endShape();
    }

    public void drawTree(PVector startpos, PVector endpos, float bottomwidth, float bottomwidth2, float topwidth, int sides) {
        this.tempDir.set(0.0f, -1.0f, 0.0f);
        this.drawTree(this.tempDir, startpos, endpos, bottomwidth, bottomwidth2, topwidth, sides);
    }

    public void drawTree(PVector direction, PVector startpos, PVector endpos, float bottomwidth, float bottomwidth2, float topwidth, int sides) {
        if (direction.equals((Object)this.t)) {
            this.t.set(0.0f, 0.0f, 1.0f);
        }
        this.t.cross(direction, this.u);
        this.u.cross(direction, this.v);
        this.u.normalize();
        this.v.normalize();
        float angle = 0.0f;
        float angleIncrement = (float)Math.PI * 2 / (float)sides;
        this.beginShape(18);
        this.fill(29.0f, 50.0f, 55.0f);
        int i = 0;
        while (i < sides + 1) {
            this.dcTempNorm.set(0.0f, 0.0f, 0.0f);
            this.addScaled(this.dcTempNorm, this.u, castleIvy.cos((float)angle));
            this.addScaled(this.dcTempNorm, this.v, castleIvy.sin((float)angle));
            this.normal(this.dcTempNorm.x, this.dcTempNorm.y, this.dcTempNorm.z);
            this.tempR1.set(startpos);
            if (i % 2 == 0) {
                this.addScaled(this.tempR1, this.u, castleIvy.cos((float)angle) * bottomwidth2);
                this.addScaled(this.tempR1, this.v, castleIvy.sin((float)angle) * bottomwidth2);
                this.vertex(this.tempR1.x, this.tempR1.y, this.tempR1.z);
            } else {
                this.addScaled(this.tempR1, this.u, castleIvy.cos((float)angle) * bottomwidth);
                this.addScaled(this.tempR1, this.v, castleIvy.sin((float)angle) * bottomwidth);
                this.vertex(this.tempR1.x, this.tempR1.y, this.tempR1.z);
            }
            this.tempR2.set(endpos);
            this.addScaled(this.tempR2, this.u, castleIvy.cos((float)angle) * topwidth);
            this.addScaled(this.tempR2, this.v, castleIvy.sin((float)angle) * topwidth);
            this.vertex(this.tempR2.x, this.tempR2.y, this.tempR2.z);
            angle += angleIncrement;
            ++i;
        }
        this.endShape();
    }

    public void makeRectangle(PVector a, PVector b, PVector c, PVector d) {
        this.makeTriangle(a, b, d);
        this.makeTriangle(b, c, d);
    }

    public void makeTriangle(PVector a, PVector b, PVector c) {
        this.mtTempAB.set(b).sub(a);
        this.mtTempAC.set(c).sub(a);
        this.mtTempAB.cross(this.mtTempAC, this.mtTempNormal);
        this.mtTempNormal.normalize();
        this.normal(this.mtTempNormal.x, this.mtTempNormal.y, this.mtTempNormal.z);
        this.vertex(a.x, a.y, a.z);
        this.vertex(b.x, b.y, b.z);
        this.vertex(c.x, c.y, c.z);
    }

    public void makeShapeRectangle(PShape shape, PVector a, PVector b, PVector c, PVector d) {
        this.makeShapeTriangle(shape, a, b, d);
        this.makeShapeTriangle(shape, b, c, d);
    }

    public void makeShapeTriangle(PShape shape, PVector a, PVector b, PVector c) {
        this.mtTempAB.set(b).sub(a);
        this.mtTempAC.set(c).sub(a);
        this.mtTempAB.cross(this.mtTempAC, this.mtTempNormal);
        this.mtTempNormal.normalize();
        shape.normal(this.mtTempNormal.x, this.mtTempNormal.y, this.mtTempNormal.z);
        shape.vertex(a.x, a.y, a.z);
        shape.vertex(b.x, b.y, b.z);
        shape.vertex(c.x, c.y, c.z);
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"castleIvy"};
        if (passedArgs != null) {
            PApplet.main((String[])castleIvy.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class ActionCam {
        Tweaker tweaker;
        PVector focus = new PVector();
        PVector position = new PVector();
        PVector up = new PVector(0.0f, 1.0f, 0.0f);
        float fieldOfView = 60.0f;
        float rotateCameraDistance = 100.0f;
        private int prevCameraMode = -1;
        private PVector prevCameraPos = new PVector();
        private PVector cameraVel = new PVector();
        private PVector hoverPos = new PVector(-20.0f, -40.0f, 30.0f);
        private PVector towerPos = new PVector(1.0f, -40.0f, 3.0f);
        private PVector distantPos = new PVector(200.0f, -140.0f, 100.0f);
        private PVector tempAcc = new PVector();

        ActionCam(Tweaker tweaker) {
            this.tweaker = tweaker;
        }

        public void update() {
            float cameraDistance = this.tweaker.value("cameraDistance", 10.0f);
            float rotationAngle = this.tweaker.value("cameraRotation", 0.0f);
            float pitchAngle = this.tweaker.value("cameraPitch", 0.0f);
            float chaseAcceleration = this.tweaker.value("cameraChaseAcceleration", 0.01f);
            float sideX = this.tweaker.value("cameraSideX", 0.0f);
            int cameraMode = (int)this.tweaker.value("cameraMode", 0.0f);
            if (cameraMode <= 0) {
                this.mouseRotateLook();
            } else if (cameraMode == 1) {
                this.focus.set(0.0f, 0.0f, 0.0f);
                this.rotoCamera(cameraDistance, rotationAngle, pitchAngle);
            } else if (cameraMode == 2) {
                this.focus.set(sideX, -1.0f, 0.0f);
                this.rotoCamera(cameraDistance, rotationAngle, pitchAngle);
            } else if (cameraMode == 3) {
                this.activateChaseCam(castleIvy.this.ivy1.branchPos, castleIvy.this.ivy1.branchPos, cameraMode, cameraDistance, chaseAcceleration);
            } else if (cameraMode == 4) {
                this.activateChaseCam(castleIvy.this.ivy3.branchPos, castleIvy.this.ivy4.branchPos, cameraMode, cameraDistance, chaseAcceleration);
            } else if (cameraMode == 5) {
                this.activateChaseCam(castleIvy.this.ivy5.branchPos, castleIvy.this.ivy5.branchPos, cameraMode, cameraDistance, chaseAcceleration);
            } else if (cameraMode == 6) {
                if (this.prevCameraMode != cameraMode) {
                    this.position.set(this.distantPos);
                    this.cameraVel.set(-10.0f, -10.0f, 2.0f);
                }
                this.focus.set(this.towerPos);
                this.chaseCamera(this.hoverPos, chaseAcceleration);
            } else if (cameraMode == 7) {
                this.activateChaseCam(castleIvy.this.ivy5.branchPos, castleIvy.this.ivy2.branchPos, cameraMode, cameraDistance, chaseAcceleration);
            }
            this.prevCameraMode = cameraMode;
            this.prevCameraPos.set(this.position);
        }

        public void activateChaseCam(PVector target, PVector foc, int mode, float dist, float acc) {
            if (this.prevCameraMode != mode) {
                this.position.set(target).add(-0.4f, -dist * 0.8f, -1.0f);
                this.cameraVel.set(0.0f, 0.0f, 0.0f);
            }
            this.focus.set(foc);
            this.chaseCamera(target, acc);
        }

        public void chaseCamera(PVector target, float chaseAcceleration) {
            this.position.lerp(target, chaseAcceleration);
            this.updateCamera();
        }

        public void rotoCamera(float dist, float rotationAngle, float pitchAngle) {
            this.position.set(dist * castleIvy.cos((float)((float)Math.PI * 2 * rotationAngle / 360.0f)) * castleIvy.sin((float)((float)Math.PI * 2 * pitchAngle / 360.0f)), dist * castleIvy.cos((float)((float)Math.PI * 2 * pitchAngle / 360.0f)) - dist / 2.0f, dist * -castleIvy.sin((float)((float)Math.PI * 2 * rotationAngle / 360.0f)) * castleIvy.sin((float)((float)Math.PI * 2 * pitchAngle / 360.0f)));
            this.updateCamera();
        }

        public void mouseRotateLook() {
            this.focus.set(0.0f, 0.0f, 0.0f);
            float rotationAngle = castleIvy.map((float)castleIvy.this.mouseX, (float)0.0f, (float)castleIvy.this.width, (float)0.0f, (float)((float)Math.PI * 2));
            float elevationAngle = castleIvy.map((float)castleIvy.this.mouseY, (float)0.0f, (float)castleIvy.this.height, (float)0.0f, (float)((float)Math.PI));
            this.position.set(this.rotateCameraDistance * castleIvy.cos((float)rotationAngle) * castleIvy.sin((float)elevationAngle), this.rotateCameraDistance * castleIvy.cos((float)elevationAngle) - this.rotateCameraDistance / 2.0f, this.rotateCameraDistance * -castleIvy.sin((float)rotationAngle) * castleIvy.sin((float)elevationAngle));
            this.updateCamera();
        }

        public void changeDistance(float amount) {
            this.rotateCameraDistance += amount;
        }

        private void updateCamera() {
            castleIvy.this.perspective();
            castleIvy.this.perspective(this.fieldOfView / 360.0f * ((float)Math.PI * 2), (float)castleIvy.this.width / (float)castleIvy.this.height, 0.1f, 10000.0f);
            castleIvy.this.camera(this.position.x, this.position.y, this.position.z, this.focus.x, this.focus.y, this.focus.z, this.up.x, this.up.y, this.up.z);
        }
    }

    class Castle {
        HashMap<Int3, Cell> cells = new HashMap();
        float cellWidth = 3.0f;
        float cellHeight = 4.0f;
        float wallThickness = this.cellWidth * 0.15f;
        float wallOverlap = this.wallThickness * 0.5f;
        int col;
        PVector pos;
        XoroShiro random;

        Castle() {
            this.col = castleIvy.this.color(castleIvy.this.random(70.0f, 90.0f), castleIvy.this.random(5.0f, 30.0f), castleIvy.this.random(20.0f, 40.0f));
            this.pos = new PVector();
            this.random = new XoroShiro(422L);
            this.generate();
        }

        public Cell getOrCreateCell(Int3 location) {
            Cell c = this.cells.get(location);
            if (c == null) {
                c = new Cell(this, location);
                this.cells.put(c.location, c);
            }
            return c;
        }

        public void generate() {
            Int3 loc = new Int3();
            int numChambers = 100;
            int radius = 4;
            int i = 0;
            while (i < numChambers) {
                loc.x = (int)castleIvy.this.random(-radius, radius);
                loc.y = (int)castleIvy.this.random(-radius, radius);
                loc.z = (int)castleIvy.this.random(-radius, radius);
                Cell cell = this.getOrCreateCell(loc);
                cell.westWall = castleIvy.this.random(0.0f, 1.0f) < 0.4f;
                cell.northWall = castleIvy.this.random(0.0f, 1.0f) < 0.4f;
                cell.roof = castleIvy.this.random(0.0f, 1.0f) < 0.8f;
                ++i;
            }
        }

        public void draw() {
            castleIvy.this.noStroke();
            castleIvy.this.pushMatrix();
            for (Cell cell : this.cells.values()) {
                cell.draw();
            }
            castleIvy.this.popMatrix();
        }
    }

    class Cell {
        Int3 location;
        Castle castle;
        int col;
        boolean westWall;
        boolean northWall;
        boolean roof;

        Cell(Castle castle, Int3 location) {
            this.location = new Int3();
            this.westWall = true;
            this.northWall = true;
            this.roof = true;
            this.castle = castle;
            this.location.set(location);
            this.col = castle.col;
        }

        public void draw() {
            float x = this.castle.pos.x + (float)this.location.x * this.castle.cellWidth;
            float y = this.castle.pos.y + (float)this.location.y * this.castle.cellHeight;
            float z = this.castle.pos.z + (float)this.location.z * this.castle.cellWidth;
            float w = this.castle.cellWidth;
            float h = this.castle.cellHeight;
            float t = this.castle.wallThickness;
            float overlap = this.castle.wallOverlap;
            if (this.westWall) {
                this.drawBlock(this.col, x, y + h * 0.5f, z + w * 0.5f, t, h + overlap, w + overlap);
            }
            if (this.northWall) {
                this.drawBlock(this.col, x + w * 0.5f, y + h * 0.5f, z, w + overlap, h + overlap, t);
            }
            if (this.roof) {
                this.drawBlock(this.col, x + w * 0.5f, y - h, z + w * 0.5f, w + overlap, t, w + overlap);
            }
        }

        public void drawBlock(int col, float cx, float cy, float cz, float sx, float sy, float sz) {
            castleIvy.this.translate(cx, cy, cz);
            castleIvy.this.fill(col);
            castleIvy.this.box(sx, sy, sz);
            castleIvy.this.sphereDetail(6, 5);
            this.castle.random.setSeed((long)this.location.x, new long[]{this.location.y, this.location.z});
            int i = 0;
            while (i < 30) {
                castleIvy.this.fill(castleIvy.this.hue(col) + this.castle.random.nextFloat(-5.0f, 5.0f), castleIvy.this.saturation(col) + this.castle.random.nextFloat(-10.0f, 10.0f), castleIvy.this.brightness(col) + this.castle.random.nextFloat(-15.0f, 15.0f));
                float dx = this.castle.random.nextFloat(-sx / 2.0f, sx / 2.0f);
                float dy = this.castle.random.nextFloat(-sy / 2.0f, sy / 2.0f);
                float dz = this.castle.random.nextFloat(-sz / 2.0f, sz / 2.0f);
                float r = castleIvy.max((float)sx, (float)sy, (float)sz) * this.castle.random.nextFloat(0.08f, 0.14f);
                castleIvy.this.pushMatrix();
                castleIvy.this.translate(dx, dy, dz);
                float scaling = 0.5f;
                castleIvy.this.scale(1.0f + this.castle.random.nextFloat(-scaling, scaling), 1.0f + this.castle.random.nextFloat(-scaling, scaling), 1.0f + this.castle.random.nextFloat(-scaling, scaling));
                castleIvy.this.rotateX(this.castle.random.nextFloat(0.0f, (float)Math.PI * 2));
                castleIvy.this.rotateY(this.castle.random.nextFloat(0.0f, (float)Math.PI * 2));
                castleIvy.this.rotateZ(this.castle.random.nextFloat(0.0f, (float)Math.PI * 2));
                castleIvy.this.sphere(r);
                castleIvy.this.popMatrix();
                ++i;
            }
            castleIvy.this.translate(-cx, -cy, -cz);
        }
    }

    class Int3 {
        int x = 0;
        int y = 0;
        int z = 0;

        Int3() {
            this(0);
        }

        Int3(int value) {
            this(value, value, value);
        }

        Int3(int x, int y, int z) {
            this.set(x, y, z);
        }

        Int3(PVector v) {
            this(castleIvy.round((float)v.x), castleIvy.round((float)v.y), castleIvy.round((float)v.z));
        }

        Int3(Int3 i) {
            this(i.x, i.y, i.z);
        }

        public void set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void set(Int3 i) {
            this.set(i.x, i.y, i.z);
        }

        public int hashCode() {
            return ((this.x * 31 + this.y) * 31 + this.z) * 31;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            Int3 otherInt3 = (Int3)other;
            return this.x == otherInt3.x && this.y == otherInt3.y && this.z == otherInt3.z;
        }
    }

    class Ivy {
        PlantSegment root;
        int segmentAmount = 0;
        float maxSegmentLenght = 0.2f;
        float segmentBranchLenght = 0.8f * this.maxSegmentLenght;
        float segmentChildbirtLengt = 0.5f * this.maxSegmentLenght;
        float growthSpeed = 0.03f;
        float branchProbability = 0.052f;
        float branchProbabilityMultiplier = 0.5f;
        PVector tempForDissat = new PVector();
        int segmentSideAmount = 5;
        PVector upDirection = new PVector();
        float previousSecondsFromStart;
        float secondFromPreviousUpdate;
        float branchWildness = 1.2f;
        float turnstrength = 0.6f;
        int branchamount = 1;
        int maxBranchLength = 740;
        float maxBranchAmount = 25.0f;
        float maxBranchWidth = 0.5f;
        float branchGrowth = 0.01f;
        float leafGrowthSpeed = this.growthSpeed * 20.0f;
        XoroShiro rnd = new XoroShiro();
        PVector mean = new PVector();
        PVector prevMean = new PVector();
        float ivyseed = 0.0f;
        float leafprob = 0.5f;
        float startticknessLoss;
        float thicknesLoss = this.startticknessLoss = 0.955f;
        float laterThicknessLoss = 0.975f;
        int segmentToChangeLoss = 800;
        float freshColorChangeRate = 0.3f;
        float colorChangeRate = 0.03f;
        float leafColorChangeRate = 0.2f;
        int sproutColor;
        int branchColor;
        int rootColor;
        int leafColor;
        int leafColorAutum;
        PVector tNormal;
        PVector t1;
        PVector t2;
        PVector p1;
        PVector p2;
        PVector p3;
        PVector ca;
        float atumness;
        boolean leafGoBoom;
        float timeOfBoom;
        float boomspeed;
        PVector branchPos;
        boolean branchPosFound;

        Ivy(PVector startpos, PVector upDirection, int maxBranchLength) {
            this.sproutColor = castleIvy.this.color(30, 38, 68);
            this.branchColor = castleIvy.this.color(33, 53, 50);
            this.rootColor = castleIvy.this.color(5, 26, 30);
            this.leafColor = castleIvy.this.color(35, 31, 40);
            this.leafColorAutum = castleIvy.this.color(10, 80, 70);
            this.tNormal = new PVector();
            this.t1 = new PVector();
            this.t2 = new PVector();
            this.p1 = new PVector();
            this.p2 = new PVector();
            this.p3 = new PVector();
            this.ca = new PVector();
            this.atumness = 0.0f;
            this.leafGoBoom = false;
            this.timeOfBoom = 0.0f;
            this.boomspeed = 3.0f;
            this.branchPos = new PVector();
            this.branchPosFound = false;
            this.upDirection.set(upDirection);
            this.root = new PlantSegment(startpos, this);
            this.previousSecondsFromStart = castleIvy.this.secondsFromStart();
            this.secondFromPreviousUpdate = castleIvy.this.secondsSince(this.previousSecondsFromStart);
            this.ivyseed = castleIvy.this.random(0.0f, 255.0f);
            this.maxBranchLength = maxBranchLength;
        }

        Ivy(PVector startpos, PVector upDirection) {
            this.sproutColor = castleIvy.this.color(30, 38, 68);
            this.branchColor = castleIvy.this.color(33, 53, 50);
            this.rootColor = castleIvy.this.color(5, 26, 30);
            this.leafColor = castleIvy.this.color(35, 31, 40);
            this.leafColorAutum = castleIvy.this.color(10, 80, 70);
            this.tNormal = new PVector();
            this.t1 = new PVector();
            this.t2 = new PVector();
            this.p1 = new PVector();
            this.p2 = new PVector();
            this.p3 = new PVector();
            this.ca = new PVector();
            this.atumness = 0.0f;
            this.leafGoBoom = false;
            this.timeOfBoom = 0.0f;
            this.boomspeed = 3.0f;
            this.branchPos = new PVector();
            this.branchPosFound = false;
            this.upDirection.set(upDirection);
            this.root = new PlantSegment(startpos, this);
            this.previousSecondsFromStart = castleIvy.this.secondsFromStart();
            this.secondFromPreviousUpdate = castleIvy.this.secondsSince(this.previousSecondsFromStart);
            this.ivyseed = castleIvy.this.random(0.0f, 255.0f);
        }

        public void addSegmentAmount() {
            ++this.segmentAmount;
        }

        public void addBranchAmount() {
            ++this.branchamount;
        }

        public void addToMean(PVector v) {
            this.mean.add(v);
        }

        private void updateIvy() {
            this.branchPosFound = false;
            if (this.segmentAmount < this.segmentToChangeLoss) {
                this.thicknesLoss = castleIvy.map((float)this.segmentAmount, (float)0.0f, (float)this.segmentToChangeLoss, (float)this.startticknessLoss, (float)this.laterThicknessLoss);
            }
            this.atumness = castleIvy.this.tweaker.value("atumness", 0.0f);
            if (this.atumness > 0.0f) {
                this.branchGrowth = 0.0f;
            }
            if (this.atumness > 0.5f) {
                this.leafGrowthSpeed = 0.0f;
            }
            if (this.atumness >= 1.0f) {
                this.atumness = 1.0f;
                this.leafGoBoom = true;
            }
            if (this.leafGoBoom && this.timeOfBoom == 0.0f) {
                this.timeOfBoom = castleIvy.this.secondsFromStart();
            }
            this.mean.set(this.root.startpos);
            this.secondFromPreviousUpdate = castleIvy.this.secondsSince(this.previousSecondsFromStart);
            this.previousSecondsFromStart = castleIvy.this.secondsFromStart();
            this.root.startThickness += this.branchGrowth * this.secondFromPreviousUpdate;
            if (this.root.startThickness > this.maxBranchWidth) {
                this.root.startThickness = this.maxBranchWidth;
            }
            this.root.update();
            this.prevMean.set(this.mean.div((float)this.branchamount));
        }

        public void drawIvy() {
            castleIvy.this.noStroke();
            this.updateIvy();
            this.root.drawSegment();
        }
    }

    class Leaf {
        PlantSegment parentSegment;
        Ivy plant;
        int leafCol;
        int autumCol;
        int currentSummerColor;
        float leafsize = 0.0f;
        float maxLeafsize = 1.0f;
        float leafBirthSecondFromStart;
        PVector randomDirection;

        Leaf(Ivy plant, PlantSegment parentSegment) {
            this.plant = plant;
            this.parentSegment = parentSegment;
            this.leafBirthSecondFromStart = castleIvy.this.secondsFromStart();
            this.leafCol = castleIvy.this.color(castleIvy.this.hue(plant.leafColor + (int)castleIvy.this.random(-10.0f, 10.0f)), castleIvy.this.saturation(plant.leafColor) + (float)((int)castleIvy.this.random(-10.0f, 10.0f)), castleIvy.this.brightness(plant.leafColor) + (float)((int)castleIvy.this.random(-10.0f, 10.0f)));
            this.autumCol = castleIvy.this.color(castleIvy.this.hue(plant.leafColorAutum + (int)castleIvy.this.random(-10.0f, 10.0f)), castleIvy.this.saturation(plant.leafColorAutum) + (float)((int)castleIvy.this.random(-25.0f, 15.0f)), castleIvy.this.brightness(plant.leafColorAutum) + (float)((int)castleIvy.this.random(-15.0f, 15.0f)));
            this.currentSummerColor = this.leafCol;
            this.randomDirection = new PVector(castleIvy.this.random(0.0f, 3.0f), castleIvy.this.random(-0.5f, 1.0f), castleIvy.this.random(-1.0f, 1.0f));
        }

        public void updateLeaf() {
            this.leafsize += this.plant.leafGrowthSpeed * this.plant.secondFromPreviousUpdate;
            if (this.leafsize > this.maxLeafsize) {
                this.leafsize = this.maxLeafsize;
            }
        }

        public void drawLeaf() {
            this.plant.rnd.setSeed((float)this.parentSegment.segmentcount + this.plant.ivyseed, new float[0]);
            if (this.plant.atumness == 0.0f) {
                float colorage = castleIvy.this.secondsSince(this.leafBirthSecondFromStart) * this.plant.leafColorChangeRate;
                if (colorage > 1.0f) {
                    colorage = 1.0f;
                }
                this.currentSummerColor = castleIvy.this.lerpColor(this.plant.sproutColor, this.leafCol, colorage);
                castleIvy.this.fill(this.currentSummerColor);
            } else {
                castleIvy.this.fill(castleIvy.this.lerpColor(this.currentSummerColor, this.autumCol, this.plant.atumness));
            }
            if (!this.plant.leafGoBoom) {
                castleIvy.this.pushMatrix();
                castleIvy.this.translate(this.parentSegment.endpos.x, this.parentSegment.endpos.y, this.parentSegment.endpos.z);
                castleIvy.this.rotateX(1.5707964f);
                castleIvy.this.rotateZ(this.plant.rnd.nextFloat((float)Math.PI * 2));
                castleIvy.this.rotateX((float)Math.PI * -2 * this.plant.rnd.nextFloat(0.0f, 0.1f) + this.plant.atumness * ((float)Math.PI * 2) * 0.15f);
                castleIvy.this.translate(0.0f, -this.parentSegment.endThickness, 0.0f);
                castleIvy.this.scale(this.leafsize);
                this.drawPart();
                castleIvy.this.popMatrix();
            } else {
                castleIvy.this.pushMatrix();
                castleIvy.this.translate(this.parentSegment.endpos.x + this.randomDirection.x * castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.boomspeed, this.parentSegment.endpos.y + this.randomDirection.y * castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.boomspeed, this.parentSegment.endpos.z + this.randomDirection.z * castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.boomspeed);
                this.plant.rnd.setSeed((float)this.parentSegment.segmentcount + this.plant.ivyseed, new float[0]);
                castleIvy.this.rotateX(1.5707964f + castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.rnd.nextFloat(0.9f, 4.0f));
                castleIvy.this.rotateZ(this.plant.rnd.nextFloat((float)Math.PI * 2) + castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.rnd.nextFloat(0.5f, 3.0f));
                castleIvy.this.rotateY(castleIvy.this.secondsSince(this.plant.timeOfBoom) * this.plant.rnd.nextFloat(1.0f, 2.0f));
                castleIvy.this.scale(this.leafsize);
                this.drawPart();
                castleIvy.this.popMatrix();
            }
        }

        public void addTriangle(PVector p1, PVector p2, PVector p3) {
            this.faceNormal(p1, p2, p3, this.plant.tNormal);
            castleIvy.this.normal(this.plant.tNormal.x, this.plant.tNormal.y, this.plant.tNormal.z);
            castleIvy.this.vertex(p1);
            castleIvy.this.vertex(p2);
            castleIvy.this.vertex(p3);
        }

        public PVector faceNormal(PVector p1, PVector p2, PVector p3, PVector normall) {
            this.plant.t1.set(p1);
            this.plant.t1.sub(p2);
            this.plant.t2.set(p1);
            this.plant.t2.sub(p3);
            this.plant.t1.cross(this.plant.t2, normall);
            return normall;
        }

        public void drawPart() {
            int leafSegments = 6;
            float leafLength = 0.95f;
            float leafWidth = 0.6f;
            float upTilt = 0.25f;
            castleIvy.this.noStroke();
            castleIvy.this.beginShape(9);
            int i = 0;
            while (i < leafSegments) {
                float relPos = castleIvy.map((float)i, (float)0.0f, (float)leafSegments, (float)0.0f, (float)1.0f);
                float nextRelPos = castleIvy.map((float)(i + 1), (float)0.0f, (float)leafSegments, (float)0.0f, (float)1.0f);
                this.leafEdgePoint(relPos, 0.5f * leafWidth, leafLength, upTilt, this.plant.p1);
                this.leafCenterPoint(relPos, leafLength, this.plant.p2);
                this.leafCenterPoint(nextRelPos, leafLength, this.plant.p3);
                this.addTriangle(this.plant.p1, this.plant.p2, this.plant.p3);
                this.leafCenterPoint(nextRelPos, leafLength, this.plant.p1);
                this.leafEdgePoint(nextRelPos, 0.5f * leafWidth, leafLength, upTilt, this.plant.p2);
                this.leafEdgePoint(relPos, 0.5f * leafWidth, leafLength, upTilt, this.plant.p3);
                this.addTriangle(this.plant.p1, this.plant.p2, this.plant.p3);
                this.leafCenterPoint(relPos, leafLength, this.plant.p1);
                this.leafEdgePoint(relPos, -0.5f * leafWidth, leafLength, upTilt, this.plant.p2);
                this.leafCenterPoint(nextRelPos, leafLength, this.plant.p3);
                this.addTriangle(this.plant.p1, this.plant.p2, this.plant.p3);
                this.leafEdgePoint(nextRelPos, -0.5f * leafWidth, leafLength, upTilt, this.plant.p1);
                this.leafCenterPoint(nextRelPos, leafLength, this.plant.p2);
                this.leafEdgePoint(relPos, -0.5f * leafWidth, leafLength, upTilt, this.plant.p3);
                this.addTriangle(this.plant.p1, this.plant.p2, this.plant.p3);
                ++i;
            }
            castleIvy.this.endShape();
        }

        public float mapClamp(float value, float sourceStart, float sourceEnd, float destStart, float destEnd) {
            return castleIvy.map((float)castleIvy.constrain((float)value, (float)sourceStart, (float)sourceEnd), (float)sourceStart, (float)sourceEnd, (float)destStart, (float)destEnd);
        }

        public void leafCenterPoint(float relPos, float leafLen, PVector pos) {
            float y = this.mix(relPos, 0.0f, -leafLen);
            pos.x = 0.0f;
            pos.y = y;
            pos.z = 0.0f;
        }

        public float mix(float t, float a, float b) {
            return (b - a) * t + a;
        }

        public void leafEdgePoint(float relPos, float leafR, float leafLen, float upTilt, PVector pos) {
            float cutoverPoint = 0.8f;
            float baseW = castleIvy.pow((float)this.mapClamp(relPos, 0.0f, cutoverPoint, 0.0f, 1.0f), (float)0.5f);
            float tipW = 0.5f * (1.0f + castleIvy.cos((float)((float)Math.PI * 2 * this.mapClamp(relPos, cutoverPoint, 1.0f, 0.0f, 1.0f) * 0.5f)));
            float w = this.mix(relPos, baseW, tipW);
            float x = 0.5f * leafR * w;
            float z = 0.0f + upTilt * castleIvy.abs((float)leafR) * castleIvy.sin((float)((float)Math.PI * castleIvy.min((float)relPos, (float)(1.0f - relPos))));
            float y = this.mix(relPos, 0.0f, -leafLen);
            pos.x = x;
            pos.y = y;
            pos.z = z;
        }
    }

    class PlantSegment {
        PlantSegment parent;
        PlantSegment nextSegment;
        PlantSegment branchSegment;
        Leaf leaf;
        Ivy plant;
        PVector startpos = new PVector();
        PVector endpos = new PVector();
        float startThickness;
        float endThickness;
        PVector direction = new PVector();
        float segmentLength;
        int segmentcount;
        boolean branchTried = false;
        float noiseseed = 0.0f;
        float branchProbability = 0.0f;
        boolean branchEnding = false;
        int maxBranchLength = 0;
        boolean triedLeaf = false;
        float segmentBirthSecondFromStart;

        PlantSegment(PVector startpos, Ivy plant) {
            this.startpos.set(startpos);
            this.endpos.set(startpos);
            this.plant = plant;
            this.startThickness = 0.0f;
            this.endThickness = 0.0f;
            this.direction.set(plant.upDirection);
            this.direction.normalize();
            this.segmentLength = 0.0f;
            plant.addSegmentAmount();
            this.segmentcount = 1;
            this.noiseseed = 0.0f;
            this.branchProbability = plant.branchProbability;
            this.maxBranchLength = plant.maxBranchLength;
            this.segmentBirthSecondFromStart = castleIvy.this.secondsFromStart();
        }

        PlantSegment(PlantSegment parent, Ivy plant) {
            this.parent = parent;
            this.noiseseed = parent.noiseseed;
            this.startpos.set(parent.endpos);
            this.endpos.set(parent.endpos);
            this.plant = plant;
            this.startThickness = parent.endThickness;
            this.endThickness = 0.0f;
            this.segmentcount = parent.segmentcount + 1;
            float noisepos = (float)this.segmentcount / 2.0f;
            this.direction.set(parent.direction);
            this.direction.normalize();
            this.branchProbability = parent.branchProbability;
            this.segmentBirthSecondFromStart = castleIvy.this.secondsFromStart();
            this.segmentLength = 0.0f;
            plant.addSegmentAmount();
            this.maxBranchLength = parent.maxBranchLength;
            this.direction.add(castleIvy.map((float)castleIvy.this.noise(this.noiseseed + noisepos + 113.13f), (float)0.0f, (float)1.0f, (float)(-plant.turnstrength), (float)plant.turnstrength), castleIvy.map((float)castleIvy.this.noise(this.noiseseed + noisepos + 231.12f), (float)0.0f, (float)1.0f, (float)(-plant.turnstrength), (float)plant.turnstrength), castleIvy.map((float)castleIvy.this.noise(this.noiseseed + noisepos + 21.21f), (float)0.0f, (float)1.0f, (float)(-plant.turnstrength), (float)plant.turnstrength));
            this.direction.add(plant.upDirection.x * 0.07f, plant.upDirection.y * 0.07f, plant.upDirection.z * 0.07f);
            plant.tempForDissat.set(plant.prevMean).sub(this.startpos).normalize().mult(-0.05f);
            this.direction.add(plant.tempForDissat);
            boolean foundWall = castleIvy.this.castle.getCastleDistance(this.endpos, plant.ca);
            if (foundWall) {
                float distance = plant.ca.mag();
                plant.ca.normalize();
                if (distance < 0.95f) {
                    this.direction.add(plant.ca.mult(-0.5f));
                }
                if (distance > 0.95f) {
                    this.direction.add(plant.ca.mult(0.5f));
                }
            }
            this.direction.normalize();
        }

        PlantSegment(PlantSegment parent, Ivy plant, PVector direction, float maxLengthMul) {
            this.parent = parent;
            this.startpos.set(parent.endpos);
            this.endpos.set(parent.endpos);
            this.plant = plant;
            this.startThickness = parent.endThickness;
            this.endThickness = 0.0f;
            this.direction.set(direction);
            direction.normalize();
            this.segmentLength = 0.0f;
            this.noiseseed = castleIvy.this.random(0.0f, 100.0f);
            plant.addSegmentAmount();
            this.segmentcount = parent.segmentcount + 1;
            this.branchProbability = plant.branchProbabilityMultiplier * parent.branchProbability;
            this.maxBranchLength = (int)((float)parent.maxBranchLength * maxLengthMul);
            this.segmentBirthSecondFromStart = castleIvy.this.secondsFromStart();
        }

        public void update() {
            float r;
            if (this.parent != null) {
                this.startThickness = this.parent.endThickness;
                this.endThickness = this.startThickness * this.plant.thicknesLoss;
                if (this.nextSegment == null && this.branchSegment == null) {
                    this.endThickness = 0.0f;
                } else if (this.endThickness < 0.01f) {
                    this.endThickness = 0.01f;
                }
            } else {
                this.endThickness = this.startThickness * this.plant.thicknesLoss;
            }
            boolean startposChanged = false;
            if (this.parent != null && !this.parent.endpos.equals((Object)this.startpos)) {
                this.startpos.set(this.parent.endpos);
                startposChanged = false;
            }
            boolean segmentGrown = false;
            if (this.segmentLength < this.plant.maxSegmentLenght) {
                segmentGrown = true;
                this.segmentLength += this.plant.growthSpeed;
                if (this.segmentLength > this.plant.maxSegmentLenght) {
                    this.segmentLength = this.plant.maxSegmentLenght;
                }
            }
            if (startposChanged || segmentGrown) {
                this.endpos.set(this.direction);
                this.endpos.mult(this.segmentLength);
                this.endpos.add(this.startpos);
            }
            if (this.segmentLength > this.plant.segmentChildbirtLengt && this.nextSegment == null && !this.branchEnding) {
                if (castleIvy.this.random(0.0f, 1.0f) > (float)(this.segmentcount / this.maxBranchLength)) {
                    this.nextSegment = new PlantSegment(this, this.plant);
                } else {
                    this.branchEnding = true;
                }
            }
            if (!this.branchTried && this.segmentLength > this.plant.segmentBranchLenght) {
                this.branchTried = true;
                if ((float)this.plant.branchamount < this.plant.maxBranchAmount) {
                    PVector d;
                    r = castleIvy.this.random(0.0f, 1.0f);
                    if (r < this.branchProbability) {
                        d = this.direction.copy();
                        d.add(castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness), castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness), castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness));
                        this.branchSegment = new PlantSegment(this, this.plant, d.normalize(), 0.75f);
                        this.plant.addBranchAmount();
                    }
                    if ((r = castleIvy.this.random(0.0f, 1.0f)) < this.branchProbability * 0.1f) {
                        d = this.direction.copy();
                        d.add(castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness), castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness), castleIvy.this.random(-this.plant.branchWildness, this.plant.branchWildness));
                        this.branchSegment = new PlantSegment(this, this.plant, d.normalize(), 0.1f);
                        this.plant.addBranchAmount();
                    }
                }
            }
            if (this.leaf == null && this.branchSegment == null && this.branchTried && !this.triedLeaf) {
                r = castleIvy.this.random(0.0f, 1.0f);
                this.triedLeaf = true;
                if (r < this.plant.leafprob) {
                    this.leaf = new Leaf(this.plant, this);
                }
            }
            if (this.branchEnding && this.leaf == null) {
                this.leaf = new Leaf(this.plant, this);
            }
            if (this.branchSegment == null && this.nextSegment == null) {
                this.plant.addToMean(this.endpos);
            }
            if (!this.plant.branchPosFound && this.branchSegment == null && this.nextSegment == null && !this.branchEnding) {
                this.plant.branchPosFound = true;
                this.plant.branchPos = this.endpos;
            }
            if (this.leaf != null) {
                this.leaf.updateLeaf();
            }
            if (this.nextSegment != null) {
                this.nextSegment.update();
            }
            if (this.branchSegment != null) {
                this.branchSegment.update();
            }
        }

        public void drawSegment() {
            float since = castleIvy.this.secondsSince(this.segmentBirthSecondFromStart);
            float colorage = since * this.plant.freshColorChangeRate;
            if (colorage < 1.0f) {
                castleIvy.this.fill(castleIvy.this.lerpColor(this.plant.sproutColor, this.plant.branchColor, colorage));
            } else {
                colorage = (since -= 1.0f / this.plant.freshColorChangeRate) * this.plant.colorChangeRate;
                if (colorage > 1.0f) {
                    colorage = 1.0f;
                }
                castleIvy.this.fill(castleIvy.this.lerpColor(this.plant.branchColor, this.plant.rootColor, colorage));
            }
            castleIvy.this.pushMatrix();
            castleIvy.this.drawCylinder(this.direction, this.startpos, this.endpos, this.startThickness, this.endThickness, this.plant.segmentSideAmount);
            castleIvy.this.popMatrix();
            if (this.leaf != null) {
                this.leaf.drawLeaf();
            }
            if (this.nextSegment != null) {
                this.nextSegment.drawSegment();
            }
            if (this.branchSegment != null) {
                this.branchSegment.drawSegment();
            }
        }
    }

    class Terrain {
        int size;
        float cellSize;
        float[][] heights;
        PVector start;
        PVector end;
        float kumpareDepth;
        float kumparePIsiirto;
        float kumpareKorkeus;
        float surfaceRandomization;
        boolean showGrass;
        PShape terrainShape;
        boolean terrainBuilt = false;
        int summerGround;
        int autumnGround;
        int grassBaseColor;
        int grassMidColor;
        int grassTopColor;
        int grassBaseSummerColor;
        int grassMidSummerColor;
        int grassTopSummerColor;
        int grassBaseAutumnColor;
        int grassMidAutumnColor;
        int grassTopAutumnColor;

        Terrain(float cellSize, float kumpareDepth, float kumparePIsiirto, float kumpareKorkeus, float surfaceRandomization, boolean showGrass) {
            this.summerGround = castleIvy.this.color(25, 30, 26);
            this.autumnGround = castleIvy.this.color(19, 40, 55);
            this.grassBaseColor = castleIvy.this.color(19, 40, 55);
            this.grassMidColor = castleIvy.this.color(19, 40, 55);
            this.grassTopColor = castleIvy.this.color(19, 40, 55);
            this.grassBaseSummerColor = castleIvy.this.color(30, 30, 25);
            this.grassMidSummerColor = castleIvy.this.color(30, 40, 35);
            this.grassTopSummerColor = castleIvy.this.color(24, 25, 45);
            this.grassBaseAutumnColor = castleIvy.this.color(25, 20, 35);
            this.grassMidAutumnColor = castleIvy.this.color(20, 24, 45);
            this.grassTopAutumnColor = castleIvy.this.color(15, 20, 55);
            this.size = 30;
            this.cellSize = cellSize;
            this.kumpareDepth = kumpareDepth;
            this.kumparePIsiirto = kumparePIsiirto;
            this.end = new PVector();
            this.start = new PVector();
            this.heights = new float[this.size][this.size];
            this.kumpareKorkeus = kumpareKorkeus;
            this.surfaceRandomization = surfaceRandomization;
            this.showGrass = showGrass;
            int x = 0;
            while (x < this.size) {
                int z = 0;
                while (z < this.size) {
                    float pikkukumpare = castleIvy.this.noise((float)x * 0.1f + surfaceRandomization * 234.982f, (float)z * 0.1f + surfaceRandomization * 123.123f) * cellSize * (float)this.size * 0.05f;
                    float worldX = (float)x * cellSize - (float)(this.size / 2) * cellSize;
                    float worldZ = (float)z * cellSize - (float)(this.size / 2) * cellSize;
                    float distance = castleIvy.sqrt((float)(worldX * worldX + worldZ * worldZ));
                    float kumpare = castleIvy.sin((float)(distance * kumpareDepth * (float)Math.PI + kumparePIsiirto * (float)Math.PI));
                    this.heights[x][z] = kumpare * kumpareKorkeus + pikkukumpare * -4.0f;
                    ++z;
                }
                ++x;
            }
        }

        public void rebuild() {
            this.terrainBuilt = false;
        }

        public void draw() {
            int z;
            int x;
            if (!this.terrainBuilt) {
                this.terrainBuilt = true;
                this.buildTerrain();
            }
            castleIvy.this.shape(this.terrainShape);
            castleIvy.this.pushMatrix();
            float autumness = castleIvy.this.tweaker.value("atumness");
            int groundColor = castleIvy.this.lerpColor(this.summerGround, this.autumnGround, autumness);
            this.grassBaseColor = castleIvy.this.lerpColor(this.grassBaseSummerColor, this.grassBaseAutumnColor, autumness);
            this.grassMidColor = castleIvy.this.lerpColor(this.grassMidSummerColor, this.grassMidAutumnColor, autumness);
            this.grassTopColor = castleIvy.this.lerpColor(this.grassTopSummerColor, this.grassTopAutumnColor, autumness);
            castleIvy.this.fill(groundColor);
            castleIvy.this.translate(-this.cellSize * (float)this.size / 2.0f, 58.0f, -this.cellSize * (float)this.size / 2.0f);
            castleIvy.this.beginShape(5);
            if (this.showGrass) {
                x = 0;
                while (x < this.size - 1) {
                    z = 0;
                    while (z < this.size - 1) {
                        float dX = x - this.size / 2;
                        float dZ = z - this.size / 2;
                        float centerDistance = castleIvy.sqrt((float)(dX * dX + dZ * dZ));
                        float grassAmount = castleIvy.max((float)0.0f, (float)castleIvy.map((float)centerDistance, (float)0.0f, (float)((float)this.size / 2.8f), (float)20.0f, (float)0.0f));
                        this.drawItems(x, z, (int)grassAmount, this.cellSize * 0.2f, true);
                        ++z;
                    }
                    ++x;
                }
            }
            if (!this.showGrass) {
                x = 0;
                while (x < this.size - 1) {
                    z = 0;
                    while (z < this.size - 1) {
                        this.drawItems(x, z, 2, this.cellSize * 0.8f, false);
                        ++z;
                    }
                    ++x;
                }
            }
            castleIvy.this.popMatrix();
        }

        public void buildTerrain() {
            this.terrainShape = castleIvy.this.createShape();
            this.terrainShape.translate(-this.cellSize * (float)this.size / 2.0f, 58.0f, -this.cellSize * (float)this.size / 2.0f);
            this.terrainShape.beginShape(9);
            this.terrainShape.noStroke();
            this.terrainShape.fill(this.summerGround);
            int x = 0;
            while (x < this.size - 1) {
                int z = 0;
                while (z < this.size - 1) {
                    this.drawCell(this.terrainShape, x, z);
                    ++z;
                }
                ++x;
            }
            this.terrainShape.endShape();
        }

        public void drawCell(PShape terrainShape, int cellX, int cellZ) {
            float y1 = this.heights[cellX][cellZ];
            float y2 = this.heights[cellX + 1][cellZ];
            float y3 = this.heights[cellX][cellZ + 1];
            float y4 = this.heights[cellX + 1][cellZ + 1];
            float x1 = this.cellSize * (float)cellX;
            float x2 = this.cellSize * (float)(cellX + 1);
            float z1 = this.cellSize * (float)cellZ;
            float z2 = this.cellSize * (float)(cellZ + 1);
            this.drawTriangle(terrainShape, x1, y1, z1, x2, y2, z1, x1, y3, z2, cellX, cellZ, cellX + 1, cellZ, cellX, cellZ + 1);
            this.drawTriangle(terrainShape, x2, y2, z1, x2, y4, z2, x1, y3, z2, cellX + 1, cellZ, cellX + 1, cellZ + 1, cellX, cellZ + 1);
        }

        public void drawItems(int cellX, int cellZ, int itemAmount, float shuffle, boolean drawGrass) {
            castleIvy.this.strokeWeight(2.0f);
            int x = 0;
            while (x < itemAmount) {
                int z = 0;
                while (z < itemAmount) {
                    float dX = (float)x * 1.0f / (float)itemAmount * this.cellSize;
                    float dZ = (float)z * 1.0f / (float)itemAmount * this.cellSize;
                    float gX = (float)cellX * this.cellSize + dX;
                    float gZ = (float)cellZ * this.cellSize + dZ;
                    float tX = castleIvy.map((float)castleIvy.this.noise(gX, gZ), (float)0.0f, (float)1.0f, (float)(-shuffle), (float)shuffle);
                    float tZ = castleIvy.map((float)castleIvy.this.noise(gX + 113.35f, gZ + 142.93f), (float)0.0f, (float)1.0f, (float)(-shuffle), (float)shuffle);
                    gX += tX;
                    gZ += tZ;
                    float y1 = this.heights[cellX][cellZ];
                    float y2 = this.heights[cellX + 1][cellZ];
                    float y3 = this.heights[cellX][cellZ + 1];
                    float y4 = this.heights[cellX + 1][cellZ + 1];
                    float yA = castleIvy.map((float)x, (float)0.0f, (float)itemAmount, (float)y1, (float)y2);
                    float yB = castleIvy.map((float)x, (float)0.0f, (float)itemAmount, (float)y3, (float)y4);
                    float yC = castleIvy.map((float)z, (float)0.0f, (float)itemAmount, (float)yA, (float)yB);
                    float windSpeed = 0.25f;
                    float windAmount = this.cellSize * 0.2f;
                    float wX = castleIvy.map((float)castleIvy.this.noise(castleIvy.this.secondsFromStart() * windSpeed + gX * 2.437f + gZ * 2.56f), (float)0.0f, (float)1.0f, (float)(-windAmount), (float)windAmount);
                    float wZ = castleIvy.map((float)castleIvy.this.noise(castleIvy.this.secondsFromStart() * windSpeed + 9.4992f + gZ * 3.154f + gX * 4.65f), (float)0.0f, (float)1.0f, (float)(-windAmount), (float)windAmount);
                    if (drawGrass) {
                        castleIvy.this.beginShape(5);
                        castleIvy.this.stroke(this.grassBaseColor);
                        castleIvy.this.vertex(gX, yC, gZ);
                        castleIvy.this.stroke(this.grassMidColor);
                        castleIvy.this.vertex(gX + wX, yC - 2.0f, gZ + wZ);
                        castleIvy.this.vertex(gX + wX, yC - 2.0f, gZ + wZ);
                        castleIvy.this.stroke(this.grassTopColor);
                        float tipWindIncrease = 2.0f;
                        castleIvy.this.vertex(gX + wX * tipWindIncrease, yC - 3.0f, gZ + wZ * tipWindIncrease);
                        castleIvy.this.endShape();
                    } else {
                        castleIvy.this.noStroke();
                        this.start.set(gX, yC + 0.1f, gZ);
                        this.end.set(gX, yC - 8.0f, gZ);
                        castleIvy.this.drawTree(this.start, this.end, 3.0f, 1.0f, 0.1f, 20);
                    }
                    ++z;
                }
                ++x;
            }
        }

        public void calculateNormal(PShape terrainShape, int x, int z) {
            if (x <= 0 || x >= this.size - 1 || z <= 0 || z >= this.size - 1) {
                terrainShape.normal(0.0f, -1.0f, 0.0f);
                return;
            }
            float yx1 = this.heights[x - 1][z];
            float yx2 = this.heights[x + 1][z];
            float yz1 = this.heights[x][z - 1];
            float yz2 = this.heights[x][z + 1];
            castleIvy.this.tempVn.x = yx2 - yx1;
            castleIvy.this.tempVn.y = -this.cellSize * 2.0f;
            castleIvy.this.tempVn.z = yz2 - yz1;
            castleIvy.this.tempVn.normalize();
            terrainShape.normal(castleIvy.this.tempVn.x, castleIvy.this.tempVn.y, castleIvy.this.tempVn.z);
        }

        public void drawTriangle(PShape terrainShape, float xA, float yA, float zA, float xB, float yB, float zB, float xC, float yC, float zC, int cellXA, int cellZA, int cellXB, int cellZB, int cellXC, int cellZC) {
            castleIvy.this.noStroke();
            castleIvy.this.tempV1.set(xB - xA, yB - yA, zB - zA);
            castleIvy.this.tempV2.set(xC - xA, yC - yA, zC - zA);
            this.calculateNormal(terrainShape, cellXA, cellZA);
            terrainShape.vertex(xA, yA, zA);
            this.calculateNormal(terrainShape, cellXB, cellZB);
            terrainShape.vertex(xB, yB, zB);
            this.calculateNormal(terrainShape, cellXC, cellZC);
            terrainShape.vertex(xC, yC, zC);
        }
    }

    class VoxelCastle {
        Voxels voxels;
        XoroShiro random = new XoroShiro();
        long seed;
        int volumeX = 100;
        int volumeY = 70;
        int volumeZ = 100;

        VoxelCastle(float voxelSize, float posX, float posY, float posZ, long seed) {
            this.voxels = new Voxels(voxelSize, this.volumeX, this.volumeY, this.volumeZ);
            this.voxels.position.x += posX;
            this.voxels.position.y += posY;
            this.voxels.position.z += posZ;
            this.seed = seed;
            this.random.setSeed(seed, new long[0]);
            this.generateCastle(42L);
        }

        public void draw() {
            this.voxels.draw();
        }

        public void generateCastle(long seed) {
            this.random.setSeed(seed, new long[0]);
            int rubblePiles = this.random.nextInt(5, 20);
            int i = 0;
            while (i < rubblePiles) {
                this.generateRubble(this.random.nextInt(30, this.volumeX - 30), this.random.nextInt(30, this.volumeX - 30), this.random.nextInt(3, 7), this.random.nextInt(10, 700), seed + (long)i + 11L);
                ++i;
            }
            int baseY = 20;
            int castleNum = 3;
            int i2 = 0;
            while (i2 < castleNum) {
                float relCenter = castleIvy.map((float)i2, (float)0.0f, (float)(castleNum - 1), (float)0.0f, (float)1.0f);
                float baseSize = castleIvy.map((float)i2, (float)0.0f, (float)(castleNum - 1), (float)((float)this.volumeX * 0.6f), (float)((float)this.volumeX * 0.2f));
                int minLevels = (int)castleIvy.map((float)relCenter, (float)0.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                this.generateWalls((int)this.random.nextGaussianFloat((float)(this.volumeX / 2), baseSize * 0.2f), baseY, (int)this.random.nextGaussianFloat((float)(this.volumeZ / 2), baseSize * 0.2f), (int)this.random.nextGaussianFloat(baseSize, baseSize * 0.2f), (int)this.random.nextGaussianFloat(baseSize, baseSize * 0.2f), this.random.nextInt(i2 * 2, 3 + i2 * 4), this.random.nextInt(4, 6), this.random.nextInt(4, 10), minLevels, this.random.nextInt(minLevels + i2, minLevels + i2 * 2), baseY, seed + (long)(17 * i2));
                ++i2;
            }
            this.generateTower(this.volumeX / 2, baseY, this.volumeZ / 2, 12, 12, 10, 4, 3, 0.8f, baseY, seed + 71L);
        }

        public void generateWalls(int centerX, int baseY, int centerZ, int sizeX, int sizeZ, int wallHeight, int wallWidth, int towerDiam, int towerMinLevels, int towerMaxLevels, int foundationDepth, long seed) {
            this.random.setSeed(seed, new long[0]);
            float windowProb = 0.5f;
            this.generateTower(centerX - sizeX / 2, baseY, centerZ - sizeZ / 2, towerDiam, towerDiam, 8, this.random.nextInt(towerMinLevels, towerMaxLevels), 2, windowProb, foundationDepth, seed + 1L);
            this.generateTower(centerX + sizeX / 2, baseY, centerZ - sizeZ / 2, towerDiam, towerDiam, 8, this.random.nextInt(towerMinLevels, towerMaxLevels), 2, windowProb, foundationDepth, seed + 2L);
            this.generateTower(centerX - sizeX / 2, baseY, centerZ + sizeZ / 2, towerDiam, towerDiam, 8, this.random.nextInt(towerMinLevels, towerMaxLevels), 2, windowProb, foundationDepth, seed + 3L);
            this.generateTower(centerX + sizeX / 2, baseY, centerZ + sizeZ / 2, towerDiam, towerDiam, 8, this.random.nextInt(towerMinLevels, towerMaxLevels), 2, windowProb, foundationDepth, seed + 4L);
            int wallsOverhang = 0;
            this.generateTower(centerX + sizeX / 2, baseY, centerZ, wallWidth, sizeZ, wallHeight, 1, wallsOverhang, 0.0f, foundationDepth, seed + 7L);
            this.generateTower(centerX - sizeX / 2, baseY, centerZ, wallWidth, sizeZ, wallHeight, 1, wallsOverhang, 0.0f, foundationDepth, seed + 8L);
            this.generateTower(centerX, baseY, centerZ - sizeZ / 2, sizeX, wallWidth, wallHeight, 1, wallsOverhang, 0.0f, foundationDepth, seed + 9L);
            this.generateTower(centerX, baseY, centerZ + sizeZ / 2, sizeX, wallWidth, wallHeight, 1, wallsOverhang, 0.0f, foundationDepth, seed + 11L);
        }

        public void generateTower(int centerX, int baseY, int centerZ, int sizeX, int sizeZ, int levelHeight, int levels, int overhang, float windowProb, int foundationDepth, long seed) {
            int level = 0;
            while (level < levels) {
                this.generateRoom(centerX, baseY + level * levelHeight, centerZ, sizeX, levelHeight, sizeZ, windowProb, seed + (long)(level * 31));
                ++level;
            }
            int roofBase = baseY + levels * levelHeight;
            int upperWidthX = sizeX + overhang * 2;
            int upperWidthZ = sizeZ + overhang * 2;
            this.makeWall(centerX, roofBase, centerZ, upperWidthX, 1, upperWidthZ, false);
            this.generateCrenellations(centerX, roofBase + 1, centerZ - upperWidthZ / 2, upperWidthX, false, 2, 2, 0, 2);
            this.generateCrenellations(centerX, roofBase + 1, centerZ + upperWidthZ / 2, upperWidthX, false, 2, 2, 0, 2);
            this.generateCrenellations(centerX - upperWidthX / 2, roofBase + 1, centerZ, upperWidthZ, true, 2, 2, 0, 2);
            this.generateCrenellations(centerX + upperWidthX / 2, roofBase + 1, centerZ, upperWidthZ, true, 2, 2, 0, 2);
            this.generateRoom(centerX, baseY - foundationDepth - 1, centerZ, sizeX, foundationDepth, sizeZ, 0.0f, seed * 12L);
        }

        public void generateRubble(int centerX, int centerZ, float radius, int count, long seed) {
            this.random.setSeed(seed, new long[0]);
            int i = 0;
            while (i < count) {
                int x = (int)this.random.nextGaussianFloat((float)centerX, radius);
                int z = (int)this.random.nextGaussianFloat((float)centerZ, radius);
                int y = this.voxels.countY - 1;
                while (y > 0 && this.voxels.get(x, y - 1, z) == 0) {
                    --y;
                }
                this.voxels.set(x, y, z, this.randomBlock(x, y, z));
                ++i;
            }
        }

        public void generateCrenellations(int centerX, int baseY, int centerZ, int length, boolean alongX, int baseHeight, int topHeight, int gapRadius, int topLen) {
            int sizeX = 1;
            int sizeZ = 1;
            if (alongX) {
                sizeZ = length;
            } else {
                sizeX = length;
            }
            this.makeWall(centerX, baseY, centerZ, sizeX, baseHeight + topHeight - 1, sizeZ, false);
            int p = 0;
            int baseX = centerX - sizeX / 2;
            int baseZ = centerZ - sizeZ / 2;
            while (p < length) {
                int c = p + (gapRadius * 2 + 1 + topLen) / 2;
                int x = baseX;
                int z = baseZ;
                if (alongX) {
                    z += c;
                } else {
                    x += c;
                }
                int gr = gapRadius;
                this.voxels.clearVolume(x - gr, baseY + baseHeight, z - gr, x + gr, baseY + baseHeight + topHeight - 1, z + gr);
                p += gapRadius * 2 + 1 + topLen;
            }
        }

        public void generateRoom(int centerX, int baseY, int centerZ, int sizeX, int sizeY, int sizeZ, float windowProb, long seed) {
            this.random.setSeed(seed, new long[0]);
            int x1 = centerX - sizeX / 2;
            int x2 = centerX + sizeX / 2;
            int z1 = centerZ - sizeZ / 2;
            int z2 = centerZ + sizeZ / 2;
            this.makeWall(x1, baseY, centerZ, 1, sizeY, sizeZ, this.random.nextBoolean(windowProb));
            this.makeWall(x2, baseY, centerZ, 1, sizeY, sizeZ, this.random.nextBoolean(windowProb));
            this.makeWall(centerX, baseY, z1, sizeX, sizeY, 1, this.random.nextBoolean(windowProb));
            this.makeWall(centerX, baseY, z2, sizeX, sizeY, 1, this.random.nextBoolean(windowProb));
            this.makeWall(centerX, baseY, centerZ, sizeX, 1, sizeZ, false);
            this.makeWall(centerX, baseY + sizeY, centerZ, sizeX, 1, sizeZ, false);
            this.voxels.setVolume(x1 + 1, baseY + 1, z1 + 1, x2 - 1, baseY + sizeY - 1, z2 - 1, this.voxels.DARKNESS);
        }

        public void makeWall(int centerX, int baseY, int centerZ, int sizeX, int sizeY, int sizeZ, boolean cutWindow) {
            int x = centerX - sizeX / 2;
            while (x <= centerX + sizeX / 2) {
                int y = baseY;
                while (y < baseY + sizeY) {
                    int z = centerZ - sizeZ / 2;
                    while (z <= centerZ + sizeZ / 2) {
                        this.voxels.set(x, y, z, this.randomBlock(x, y, z));
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (cutWindow) {
                int windowRad = 1;
                int windowBase = 2;
                int windowHeight = 5;
                this.voxels.clearVolume(centerX - windowRad, baseY + windowBase, centerZ - windowRad, centerX + windowRad, castleIvy.min((int)(baseY + windowBase + windowHeight - 1), (int)(baseY + sizeY - 1)), centerZ + windowRad);
            }
        }

        public int randomBlock(int x, int y, int z) {
            this.random.setSeed((long)x, new long[]{y, z});
            int posBased = (int)(castleIvy.map((float)y, (float)0.0f, (float)this.voxels.countY, (float)this.voxels.GRANITE_FIRST, (float)this.voxels.GRANITE_LAST) + this.random.nextGaussianFloat(0.0f, 3.0f));
            if (posBased < this.voxels.GRANITE_FIRST) {
                posBased = this.voxels.GRANITE_FIRST;
            }
            if (posBased > this.voxels.GRANITE_LAST) {
                posBased = this.voxels.GRANITE_LAST;
            }
            return posBased;
        }

        public boolean getCastleDistance(PVector position, PVector vectorToClosestWall) {
            return this.voxels.getClosestBlock(position, vectorToClosestWall);
        }
    }

    class Voxels {
        int countX;
        int countY;
        int countZ;
        byte[][][] voxels;
        int[] blockColors;
        int VOID = 0;
        int DARKNESS = 1;
        int GRANITE_FIRST = 2;
        int GRANITE_LAST = 50;
        float voxelSize = 0.25f;
        PVector position = new PVector();
        private boolean redrawNeeded = true;
        private PShape shape;
        private PVector tempCenter = new PVector();
        private int byteToUnsignedMask = 255;
        private XoroShiro random = new XoroShiro(1234L);
        private PVector tempDelta = new PVector();
        private PVector tC = new PVector();
        private PVector tU = new PVector();
        private PVector tV = new PVector();
        private PVector unitX = new PVector(1.0f, 0.0f, 0.0f);
        private PVector unitY = new PVector(0.0f, 1.0f, 0.0f);
        private PVector unitZ = new PVector(0.0f, 0.0f, 1.0f);
        private PVector tempA = new PVector();
        private PVector tempB = new PVector();
        private PVector tempC = new PVector();
        private PVector tempD = new PVector();

        Voxels(float voxelSize, int countX, int countY, int countZ) {
            this.voxelSize = voxelSize;
            this.countX = countX;
            this.countY = countY;
            this.countZ = countZ;
            this.blockColors = new int[256];
            this.initBlockColors();
            this.position.set((float)(-countX) * voxelSize / 2.0f, 0.0f, (float)(-countX) * voxelSize / 2.0f);
            this.voxels = new byte[countX][countY][countZ];
        }

        public void set(int x, int y, int z, int type) {
            if (x >= 0 && x < this.countX && y >= 0 && y < this.countY && z >= 0 && z < this.countZ) {
                this.voxels[x][y][z] = (byte)type;
            }
        }

        public int get(int x, int y, int z) {
            if (x >= 0 && x < this.countX && y >= 0 && y < this.countY && z >= 0 && z < this.countZ) {
                return this.voxels[x][y][z] & this.byteToUnsignedMask;
            }
            return 0;
        }

        public boolean isSolid(int x, int y, int z) {
            return this.get(x, y, z) != 0;
        }

        public void clearVolume(int x1, int y1, int z1, int x2, int y2, int z2) {
            this.setVolume(x1, y1, z1, x2, y2, z2, 0);
        }

        public void setVolume(int x1, int y1, int z1, int x2, int y2, int z2, int type) {
            int x = x1;
            int y = y1;
            int z = z1;
            x = x1;
            while (x <= x2) {
                y = y1;
                while (y <= y2) {
                    z = z1;
                    while (z <= z2) {
                        this.set(x, y, z, type);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }

        public void clear(int x, int y, int z) {
            this.set(x, y, z, 0);
        }

        public void initBlockColors() {
            int hueCount = 8;
            int satCount = 8;
            int lumCount = 4;
            int colorIndex = 0;
            int sat = 0;
            while (sat < satCount) {
                int lum = 0;
                while (lum < lumCount) {
                    int hue = 0;
                    while (hue < hueCount) {
                        this.blockColors[colorIndex++] = castleIvy.this.color((hue + 1) * 100 / hueCount, castleIvy.map((float)((sat + 1) * 100 / satCount), (float)0.0f, (float)100.0f, (float)0.0f, (float)10.0f), castleIvy.map((float)((lum + 1) * 100 / lumCount), (float)0.0f, (float)100.0f, (float)40.0f, (float)60.0f));
                        ++hue;
                    }
                    ++lum;
                }
                ++sat;
            }
            this.blockColors[this.DARKNESS] = castleIvy.this.color(0, 0, 0);
            int i = this.GRANITE_FIRST;
            while (i <= this.GRANITE_LAST) {
                float p = castleIvy.map((float)i, (float)this.GRANITE_FIRST, (float)this.GRANITE_LAST, (float)0.0f, (float)1.0f);
                this.blockColors[i] = castleIvy.this.color(castleIvy.map((float)p, (float)0.0f, (float)1.0f, (float)70.0f, (float)10.0f) + this.random.nextGaussianFloat(0.0f, 5.0f), castleIvy.map((float)p, (float)0.0f, (float)1.0f, (float)30.0f, (float)20.0f) + this.random.nextGaussianFloat(0.0f, 5.0f), castleIvy.map((float)p, (float)0.0f, (float)1.0f, (float)40.0f, (float)70.0f) + this.random.nextGaussianFloat(0.0f, 5.0f));
                ++i;
            }
        }

        public void toWorldPos(int x, int y, int z, PVector out) {
            out.x = ((float)x + 0.5f) * this.voxelSize + this.position.x;
            out.y = ((float)y + 0.5f) * this.voxelSize + this.position.y;
            out.z = ((float)z + 0.5f) * this.voxelSize + this.position.z;
        }

        private void setVectorToBlock(int x, int y, int z, PVector pos, PVector deltaOut) {
            this.toWorldPos(x, y, z, deltaOut);
            deltaOut.sub(pos);
        }

        public boolean getClosestBlock(PVector pos, PVector vectorToClosestWall) {
            int voxelX = (int)((pos.x - this.position.x) / this.voxelSize);
            int voxelY = (int)((pos.y - this.position.y) / this.voxelSize);
            int voxelZ = (int)((pos.z - this.position.z) / this.voxelSize);
            if (this.isSolid(voxelX, voxelY, voxelZ)) {
                this.setVectorToBlock(voxelX, voxelY, voxelZ, pos, vectorToClosestWall);
                return true;
            }
            int searchRadius = 8;
            int i = 1;
            while (i < searchRadius) {
                float closestDistSquared = -1.0f;
                boolean foundClosestDist = false;
                int x = voxelX - i;
                while (x <= voxelX + 1) {
                    int y = voxelY - i;
                    while (y <= voxelY + 1) {
                        int z = voxelZ - i;
                        while (z <= voxelZ + 1) {
                            if (this.isSolid(x, y, z)) {
                                this.setVectorToBlock(x, y, z, pos, this.tempDelta);
                                float distSquared = this.tempDelta.magSq();
                                if (!foundClosestDist || distSquared < closestDistSquared) {
                                    foundClosestDist = true;
                                    closestDistSquared = distSquared;
                                    vectorToClosestWall.set(this.tempDelta);
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (foundClosestDist) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void redraw() {
            this.redrawNeeded = true;
        }

        public void draw() {
            if (this.redrawNeeded) {
                this.buildShape();
                this.redrawNeeded = false;
            }
            castleIvy.this.shape(this.shape);
        }

        private void buildShape() {
            this.shape = castleIvy.this.createShape();
            this.shape.beginShape(9);
            float xPos = 0.0f;
            float yPos = 0.0f;
            float zPos = 0.0f;
            int z = 0;
            while (z < this.countZ) {
                zPos = (float)z * this.voxelSize;
                int y = 0;
                while (y < this.countY) {
                    yPos = (float)y * this.voxelSize;
                    int x = 0;
                    while (x < this.countX) {
                        xPos = (float)x * this.voxelSize;
                        int voxelType = this.voxels[x][y][z] & this.byteToUnsignedMask;
                        if (voxelType != 0) {
                            this.tempCenter.set(xPos + this.voxelSize * 0.5f + this.position.x, -(yPos + this.voxelSize * 0.5f + this.position.y), zPos + this.voxelSize * 0.5f + this.position.z);
                            this.drawBlock(this.tempCenter, this.blockColors[voxelType]);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this.shape.endShape();
        }

        private void drawBlock(PVector center, int c) {
            this.shape.fill(c);
            castleIvy.this.addScaled(this.tC.set(center), this.unitX, this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitY, this.unitZ, false);
            castleIvy.this.addScaled(this.tC.set(center), this.unitX, -this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitZ, this.unitY, true);
            castleIvy.this.addScaled(this.tC.set(center), this.unitY, this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitX, this.unitZ, false);
            castleIvy.this.addScaled(this.tC.set(center), this.unitY, -this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitZ, this.unitX, true);
            castleIvy.this.addScaled(this.tC.set(center), this.unitZ, this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitY, this.unitX, false);
            castleIvy.this.addScaled(this.tC.set(center), this.unitZ, -this.voxelSize * 0.5f);
            this.drawFace(this.tC, this.unitX, this.unitY, true);
        }

        private void drawFace(PVector center, PVector u, PVector v, boolean flip) {
            this.tempA.set(center);
            this.tempB.set(center);
            this.tempC.set(center);
            this.tempD.set(center);
            castleIvy.this.addScaled(this.tempA, u, -this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempA, v, -this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempB, u, this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempB, v, -this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempC, u, this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempC, v, this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempD, u, -this.voxelSize * 0.5f);
            castleIvy.this.addScaled(this.tempD, v, this.voxelSize * 0.5f);
            if (flip) {
                castleIvy.this.makeShapeRectangle(this.shape, this.tempA, this.tempB, this.tempC, this.tempD);
            } else {
                castleIvy.this.makeShapeRectangle(this.shape, this.tempD, this.tempC, this.tempB, this.tempA);
            }
        }
    }
}

