;
; Rec by Nap/Dilemma
; a 256 byte intro to Function 2019
;
; Thanks to Hellmood, TomCat, Rrrola, Digimind, Baudsurfer and all sizecoders :)
;

%define		C2		(0x30-0x39)
%define		C2x		(0x31-0x39)
%define		D2		(0x32-0x39)
%define		D2x		(0x33-0x39)
%define		E2		(0x34-0x39)
%define		F2		(0x35-0x39)
%define		F2x		(0x36-0x39)
%define		G2		(0x37-0x39)
%define		G2x		(0x38-0x39)
%define		A2		(0x39-0x39)
%define		A2x		(0x3A-0x39)
%define		B2		(0x3B-0x39)

%define		C3		(0x3C-0x39)
%define		C3x		(0x3D-0x39)
%define		D3		(0x3E-0x39)
%define		D3x		(0x3F-0x39)
%define		E3		(0x40-0x39)
%define		F3		(0x41-0x39)
%define		F3x		(0x42-0x39)
%define		G3		(0x43-0x39)
%define		G3x		(0x44-0x39)
%define		A3		(0x45-0x39)
%define		A3x		(0x46-0x39)
%define		B3		(0x47-0x39)

%define		C4		(0x48-0x39)

org 0x100

mov	al,13h
int 10h

	mov dx,music			
	mov ax,0x251C
	int 0x21

push 0a000h
pop es

frame:
xor dx,dx
xor si,si
mov cx,320
mov ax,di
div cx	

rec:
mov cl,64
mov bx,bp

innerloop:					
	push ax
	push dx
	add dx,bp	
	sub al,bl
	sub dl,bl
il:
	and al,cl		;->and al,dl
	and al,cl
	xor si,ax
	pop dx
	pop ax
	shr bx,1
	shr cl,1
jnz innerloop

shr si,2
xchg si,ax
dob:
and al,15
add al,16
stosb
inc di
inc di
jnz frame

		cmp word [counter],256+128+32
		jae quit

inc bp
in al,60h
dec al
jnz frame

quit:
;	mov		al,3
;	int		10h
	ret

counter:		dw		0
counter2:		db		0

music:
	pusha

mov 	al,	3Fh			;	set UART mode - command
mov 	dx,	331h		;	MIDI Control Port
out 	dx,	al 			;	send !	
dec		dx

	mov		di,counter
	inc		byte [di+2]
;	test	byte [di+2], 00000011b
	test	byte [di+2], dh		;dh=3
	jnz		musicend

;	mov		byte [dob+1],15
	mov		byte [di+(dob-counter)+1],15
	inc		word [di]

	xor		bx,bx
	mov		si,bass
	call	play

	cmp 	[di], byte 64
	jb		drumplay
;	mov		word [il+1], 0d0h		;change and al,cl -> and al,dl
	mov		byte [di-(counter-il)+1],0d0h

	cmp 	[di], byte 128
	jb		ok
;	mov		[okt+1],byte 39h
	mov		byte [di+(okt-counter)+1],39h

;	inc		byte [rec+1]
	inc		byte [di-(counter-rec)+1]
ok:

	inc		bx
;	mov		si, piano
	call	play
	

drumplay:

	test [di],byte 00100000b
	jz musicend

	mov al,99h
	out dx,al
	and	bp,15
	mov	al,[drums+bp]
	out	dx,al			; send the drum
	mov	al,127			; set volume to maximum
	out	dx,al			; send volume

	mov		byte [dob+1],al		;al=127

musicend:

	popa
	iret

play:
	mov		bp,[di]
	and		bp,31
	mov		ah,[lead+bp]
	cmp		bl,bh		;bh=0
	je		p
	shr		ah,4
p:
	and		ah,15
	jz		noplay
	outsb
	outsb
	outsb
	xchg	al,ah
okt:
	add		al,39h-12
	out		dx,al
	outsb
noplay:
	ret

bass:
	db	0c0h, 38, 90h, 96
piano:
	db	0c3h, 1, 93h, 127
;drum:
;	db 99h, 127

;35,36=bass drum, 42=hihat, 40=snare
drums:
db		35,42
db		40,35
db		42,42
db		40,35
db		42,42
db		40,35
db		35,35
db		40,35

lead:
db	 E3+  B3*16,  0+  0, B3+  0*16,  0+ B3*16,
db	 E3+   0*16,  0+  0, B3+ B3*16, E3+  0*16,
db	  0+  B3*16, E3+  0, B3+ C4*16,  0+  0*16,
db	 E3+  B3*16,  0+  0, B3+ A3*16,  0+  0*16,
db	 C3+  G3*16,  0+  0, G3+  0*16,  0+ G3*16,
db	 C3+   0*16,  0+  0, G3+ G3*16, D3+  0*16,
db	  0+  A3*16, D3+  0, A3+ A3*16,  0+  0*16,
db	 D3+  B3*16,  0+  0, A3+ A3*16,  0+  0*16,

