cbuffer cbPerObject
{
	float4x4 WVP;
};

Texture2D DiffuseMap;

SamplerState TriLinearSample
{
	Filter = MIN_MAG_MIP_LINEAR;
};

struct VS_OUTPUT    //output structure for vertex shader
{
	float4 Pos : SV_POSITION;
	float2 texCoord : TEXCOORD;
};

// Vertex Shader
VS_OUTPUT VS(float4 inPos : POSITION, float2 inTexCoord : TEXCOORD)
{
	VS_OUTPUT output = (VS_OUTPUT)0;




	output.Pos = mul(inPos, WVP);

	output.texCoord = inTexCoord;

	return output;        //send color and position to pixel shader
}

// Pixel Shader
float4 PS(VS_OUTPUT input) : SV_Target
{
	float4 diffuse = DiffuseMap.Sample(TriLinearSample, input.texCoord);
	return diffuse;    // Set the color of the pixel to the corresponding texel in the loaded image is.



}

technique10 Tech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS()));
		SetPixelShader(CompileShader(ps_4_0, PS()));
	}
}