/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ImageDrawer;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002JF\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018JF\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f0\u001dJ>\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J8\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f0\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/openrndr/internal/ImageDrawer;", "", "()V", "arrayTextureShaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "instanceAttributes", "Lorg/openrndr/draw/VertexBuffer;", "instanceFormat", "Lorg/openrndr/draw/VertexFormat;", "shaderManager", "vertices", "assertInstanceSize", "", "size", "", "drawImage", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "arrayTexture", "Lorg/openrndr/draw/ArrayTexture;", "layer", "x", "", "y", "width", "height", "layers", "", "rectangles", "Lkotlin/Pair;", "Lorg/openrndr/shape/Rectangle;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "openrndr-core"})
public final class ImageDrawer {
    private final VertexBuffer vertices;
    private final VertexFormat instanceFormat;
    private VertexBuffer instanceAttributes;
    private final ShadeStyleManager shaderManager;
    private final ShadeStyleManager arrayTextureShaderManager;

    private final void assertInstanceSize(int size) {
        if (this.instanceAttributes.getVertexCount() < size) {
            this.instanceAttributes.destroy();
            this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, size);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, @NotNull List<Pair<Rectangle, Rectangle>> rectangles) {
        Object object;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Intrinsics.checkParameterIsNotNull(rectangles, "rectangles");
        this.assertInstanceSize(rectangles.size());
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        BufferWriter iw = this.instanceAttributes.getShadow().writer();
        iw.rewind();
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void source;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Pair pair = it;
            Rectangle rectangle = (Rectangle)pair.component1();
            Rectangle target2 = (Rectangle)pair.component2();
            iw.write(new Vector4(source.getCorner().getX() / (double)colorBuffer.getWidth(), source.getCorner().getY() / (double)colorBuffer.getHeight(), source.getWidth() / (double)colorBuffer.getWidth(), source.getHeight() / (double)colorBuffer.getHeight()));
            iw.write(new Vector4(target2.getCorner().getX(), target2.getCorner().getY(), target2.getWidth(), target2.getHeight()));
            iw.write(0.0f);
        }
        this.instanceAttributes.getShadow().uploadElements(0, rectangles.size());
        colorBuffer.bind(0);
        shader2.begin();
        drawContext.applyToShader(shader2);
        shader2.uniform("u_flipV", colorBuffer.getFlipV() ? 1 : 0);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(this.instanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, rectangles.size());
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ArrayTexture arrayTexture, @NotNull List<Integer> layers2, @NotNull List<Pair<Rectangle, Rectangle>> rectangles) {
        Object object;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(arrayTexture, "arrayTexture");
        Intrinsics.checkParameterIsNotNull(layers2, "layers");
        Intrinsics.checkParameterIsNotNull(rectangles, "rectangles");
        this.assertInstanceSize(rectangles.size());
        Shader shader2 = this.arrayTextureShaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        BufferWriter iw = this.instanceAttributes.getShadow().writer();
        iw.rewind();
        Iterable $this$forEachIndexed$iv = rectangles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void source;
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Pair pair = (Pair)item$iv;
            int index = n2;
            boolean bl2 = false;
            void var19_19 = it;
            Rectangle rectangle = (Rectangle)var19_19.component1();
            Rectangle target2 = (Rectangle)var19_19.component2();
            iw.write(new Vector4(source.getCorner().getX() / (double)arrayTexture.getWidth(), source.getCorner().getY() / (double)arrayTexture.getHeight(), source.getWidth() / (double)arrayTexture.getWidth(), source.getHeight() / (double)arrayTexture.getHeight()));
            iw.write(new Vector4(target2.getCorner().getX(), target2.getCorner().getY(), target2.getWidth(), target2.getHeight()));
            iw.write(((Number)layers2.get(index)).intValue());
        }
        this.instanceAttributes.getShadow().uploadElements(0, rectangles.size());
        arrayTexture.bind(0);
        shader2.begin();
        drawContext.applyToShader(shader2);
        shader2.uniform("u_flipV", arrayTexture.getFlipV() ? 1 : 0);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(this.instanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, rectangles.size());
        shader2.end();
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, double x, double y, double width, double height) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.drawImage(drawContext, drawStyle, colorBuffer, CollectionsKt.listOf(TuplesKt.to(colorBuffer.getBounds(), new Rectangle(x, y, width, height))));
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ArrayTexture arrayTexture, int layer, double x, double y, double width, double height) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(arrayTexture, "arrayTexture");
        this.drawImage(drawContext, drawStyle, arrayTexture, CollectionsKt.listOf(layer), CollectionsKt.listOf(TuplesKt.to(arrayTexture.getBounds(), new Rectangle(x, y, width, height))));
    }

    public ImageDrawer() {
        VertexFormat vertexFormat2 = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        ImageDrawer imageDrawer = this;
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat $this$apply = vertexFormat2;
        boolean bl3 = false;
        $this$apply.position(3);
        $this$apply.normal(3);
        VertexFormat.textureCoordinate$default($this$apply, 2, 0, 2, null);
        VertexFormat vertexFormat3 = vertexFormat2;
        imageDrawer.vertices = companion.createDynamic(vertexFormat3, 6);
        this.instanceFormat = VertexFormatKt.vertexFormat(instanceFormat.1.INSTANCE);
        this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, 10);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageVertexShader";
            }

            public final String getSignature() {
                return "imageVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageFragmentShader";
            }

            public final String getSignature() {
                return "imageFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
        this.arrayTextureShaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageArrayTextureVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageArrayTextureVertexShader";
            }

            public final String getSignature() {
                return "imageArrayTextureVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageArrayTextureFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageArrayTextureFragmentShader";
            }

            public final String getSignature() {
                return "imageArrayTextureFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        Vector3 pa = new Vector3(0.0, 0.0, 0.0);
        Vector3 pb = new Vector3(1.0, 0.0, 0.0);
        Vector3 pc = new Vector3(1.0, 1.0, 0.0);
        Vector3 pd = new Vector3(0.0, 1.0, 0.0);
        double u0 = 0.0;
        double u1 = 1.0;
        double v0 = 1.0;
        double v1 = 0.0;
        Vector2 ta = new Vector2(u0, v1);
        Vector2 tb = new Vector2(u1, v1);
        Vector2 tc = new Vector2(u1, v0);
        Vector2 td = new Vector2(u0, v0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter bufferWriter2 = w;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferWriter $this$apply2 = bufferWriter2;
        boolean bl6 = false;
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        $this$apply2.write(pd);
        $this$apply2.write(n);
        $this$apply2.write(td);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pb);
        $this$apply2.write(n);
        $this$apply2.write(tb);
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

