/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRReusableSync {
    public static final int EGL_SYNC_STATUS_KHR = 12529;
    public static final int EGL_SIGNALED_KHR = 12530;
    public static final int EGL_UNSIGNALED_KHR = 12531;
    public static final int EGL_TIMEOUT_EXPIRED_KHR = 12533;
    public static final int EGL_CONDITION_SATISFIED_KHR = 12534;
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_REUSABLE_KHR = 12538;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 1;
    public static final long EGL_FOREVER_KHR = -1L;
    public static final long EGL_NO_SYNC_KHR = 0L;

    protected KHRReusableSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateSyncKHR, caps.eglDestroySyncKHR, caps.eglClientWaitSyncKHR, caps.eglSignalSyncKHR, caps.eglGetSyncAttribKHR);
    }

    public static long neglCreateSyncKHR(long dpy, int type2, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(dpy, type2, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSyncKHR")
    public static long eglCreateSyncKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int type2, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return KHRReusableSync.neglCreateSyncKHR(dpy, type2, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroySyncKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSyncKHR") long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPI(dpy, sync, __functionAddress) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglClientWaitSyncKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSyncKHR") long sync, @NativeType(value="EGLint") int flags, @NativeType(value="EGLTimeKHR") long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPJI(dpy, sync, flags, timeout, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglSignalSyncKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSyncKHR") long sync, @NativeType(value="EGLenum") int mode) {
        long __functionAddress = EGL.getCapabilities().eglSignalSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPI(dpy, sync, mode, __functionAddress) != 0;
    }

    public static int neglGetSyncAttribKHR(long dpy, long sync, int attribute, long value2) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPPI(dpy, sync, attribute, value2, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSyncKHR") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") IntBuffer value2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value2, 1);
        }
        return KHRReusableSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value2)) != 0;
    }

    @NativeType(value="EGLSyncKHR")
    public static long eglCreateSyncKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int type2, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPP(dpy, type2, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSyncKHR") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") int[] value2) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
            Checks.check(value2, 1);
        }
        return JNI.callPPPI(dpy, sync, attribute, value2, __functionAddress) != 0;
    }
}

