/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTCompositor {
    public static final int EGL_PRIMARY_COMPOSITOR_CONTEXT_EXT = 13408;
    public static final int EGL_EXTERNAL_REF_ID_EXT = 13409;
    public static final int EGL_COMPOSITOR_DROP_NEWEST_FRAME_EXT = 13410;
    public static final int EGL_COMPOSITOR_KEEP_NEWEST_FRAME_EXT = 13411;

    protected EXTCompositor() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCompositorSetContextListEXT, caps.eglCompositorSetContextAttributesEXT, caps.eglCompositorSetWindowListEXT, caps.eglCompositorSetWindowAttributesEXT, caps.eglCompositorBindTexWindowEXT, caps.eglCompositorSetSizeEXT, caps.eglCompositorSwapPolicyEXT);
    }

    public static int neglCompositorSetContextListEXT(long external_ref_ids, int num_entries) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetContextListEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_ids, num_entries, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetContextListEXT(@NativeType(value="EGLint const *") IntBuffer external_ref_ids) {
        return EXTCompositor.neglCompositorSetContextListEXT(MemoryUtil.memAddress(external_ref_ids), external_ref_ids.remaining()) != 0;
    }

    public static int neglCompositorSetContextAttributesEXT(int external_ref_id, long context_attributes, int num_entries) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetContextAttributesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_id, context_attributes, num_entries, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetContextAttributesEXT(@NativeType(value="EGLint") int external_ref_id, @NativeType(value="EGLint const *") IntBuffer context_attributes) {
        return EXTCompositor.neglCompositorSetContextAttributesEXT(external_ref_id, MemoryUtil.memAddress(context_attributes), context_attributes.remaining()) != 0;
    }

    public static int neglCompositorSetWindowListEXT(int external_ref_id, long external_win_ids, int num_entries) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetWindowListEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_id, external_win_ids, num_entries, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetWindowListEXT(@NativeType(value="EGLint") int external_ref_id, @NativeType(value="EGLint const *") IntBuffer external_win_ids) {
        return EXTCompositor.neglCompositorSetWindowListEXT(external_ref_id, MemoryUtil.memAddress(external_win_ids), external_win_ids.remaining()) != 0;
    }

    public static int neglCompositorSetWindowAttributesEXT(int external_win_id, long window_attributes, int num_entries) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetWindowAttributesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_win_id, window_attributes, num_entries, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetWindowAttributesEXT(@NativeType(value="EGLint") int external_win_id, @NativeType(value="EGLint const *") IntBuffer window_attributes) {
        return EXTCompositor.neglCompositorSetWindowAttributesEXT(external_win_id, MemoryUtil.memAddress(window_attributes), window_attributes.remaining()) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorBindTexWindowEXT(@NativeType(value="EGLint") int external_win_id) {
        long __functionAddress = EGL.getCapabilities().eglCompositorBindTexWindowEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(external_win_id, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetSizeEXT(@NativeType(value="EGLint") int external_win_id, @NativeType(value="EGLint") int width, @NativeType(value="EGLint") int height) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetSizeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(external_win_id, width, height, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSwapPolicyEXT(@NativeType(value="EGLint") int external_win_id, @NativeType(value="EGLint") int policy) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSwapPolicyEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(external_win_id, policy, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetContextListEXT(@NativeType(value="EGLint const *") int[] external_ref_ids) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetContextListEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_ids, external_ref_ids.length, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetContextAttributesEXT(@NativeType(value="EGLint") int external_ref_id, @NativeType(value="EGLint const *") int[] context_attributes) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetContextAttributesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_id, context_attributes, context_attributes.length, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetWindowListEXT(@NativeType(value="EGLint") int external_ref_id, @NativeType(value="EGLint const *") int[] external_win_ids) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetWindowListEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_ref_id, external_win_ids, external_win_ids.length, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCompositorSetWindowAttributesEXT(@NativeType(value="EGLint") int external_win_id, @NativeType(value="EGLint const *") int[] window_attributes) {
        long __functionAddress = EGL.getCapabilities().eglCompositorSetWindowAttributesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(external_win_id, window_attributes, window_attributes.length, __functionAddress) != 0;
    }
}

