/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.structures;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import jouvieje.bass.structures.StructureJNI;
import jouvieje.bass.structures.TAG_CART_TIMER;
import jouvieje.bass.utils.Pointer;

public class TAG_CART
extends Pointer {
    public static TAG_CART asTAG_CART(Pointer pointer) {
        long address = Pointer.getPointer(pointer);
        if (address == 0L) {
            return null;
        }
        return new TAG_CART(address);
    }

    public static TAG_CART allocate() {
        long pointer = StructureJNI.TAG_CART_new();
        if (pointer == 0L) {
            throw new OutOfMemoryError();
        }
        return new TAG_CART(pointer);
    }

    protected TAG_CART(long pointer) {
        super(pointer);
    }

    public TAG_CART() {
    }

    public void release() {
        if (this.pointer != 0L) {
            StructureJNI.TAG_CART_delete(this.pointer);
        }
        this.pointer = 0L;
    }

    public char getVersion(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 4) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 4 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_Version_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getVersion() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_Version(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setVersion(int elementIndex, char version) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 4) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 4 + "[");
        }
        StructureJNI.TAG_CART_set_Version(this.pointer, elementIndex, version);
    }

    public char getTitle(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_Title_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getTitle() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_Title(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setTitle(int elementIndex, char title) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_Title(this.pointer, elementIndex, title);
    }

    public char getArtist(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_Artist_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getArtist() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_Artist(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setArtist(int elementIndex, char artist) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_Artist(this.pointer, elementIndex, artist);
    }

    public char getCutID(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_CutID_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getCutID() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_CutID(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setCutID(int elementIndex, char cutID) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_CutID(this.pointer, elementIndex, cutID);
    }

    public char getClientID(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_ClientID_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getClientID() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_ClientID(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setClientID(int elementIndex, char clientID) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_ClientID(this.pointer, elementIndex, clientID);
    }

    public char getCategory(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_Category_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getCategory() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_Category(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setCategory(int elementIndex, char category) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_Category(this.pointer, elementIndex, category);
    }

    public char getClassification(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_Classification_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getClassification() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_Classification(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setClassification(int elementIndex, char classification) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_Classification(this.pointer, elementIndex, classification);
    }

    public char getOutCue(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_OutCue_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getOutCue() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_OutCue(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setOutCue(int elementIndex, char outCue) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_OutCue(this.pointer, elementIndex, outCue);
    }

    public char getStartDate(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 10) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 10 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_StartDate_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getStartDate() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_StartDate(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setStartDate(int elementIndex, char startDate) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 10) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 10 + "[");
        }
        StructureJNI.TAG_CART_set_StartDate(this.pointer, elementIndex, startDate);
    }

    public char getStartTime(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_StartTime_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getStartTime() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_StartTime(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setStartTime(int elementIndex, char startTime) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        StructureJNI.TAG_CART_set_StartTime(this.pointer, elementIndex, startTime);
    }

    public char getEndDate(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 10) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 10 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_EndDate_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getEndDate() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_EndDate(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setEndDate(int elementIndex, char endDate) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 10) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 10 + "[");
        }
        StructureJNI.TAG_CART_set_EndDate(this.pointer, elementIndex, endDate);
    }

    public char getEndTime(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_EndTime_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getEndTime() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_EndTime(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setEndTime(int elementIndex, char endTime) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        StructureJNI.TAG_CART_set_EndTime(this.pointer, elementIndex, endTime);
    }

    public char getProducerAppID(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_ProducerAppID_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getProducerAppID() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_ProducerAppID(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setProducerAppID(int elementIndex, char producerAppID) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_ProducerAppID(this.pointer, elementIndex, producerAppID);
    }

    public char getProducerAppVersion(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_ProducerAppVersion_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getProducerAppVersion() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_ProducerAppVersion(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setProducerAppVersion(int elementIndex, char producerAppVersion) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_ProducerAppVersion(this.pointer, elementIndex, producerAppVersion);
    }

    public char getUserDef(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_UserDef_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getUserDef() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_UserDef(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setUserDef(int elementIndex, char userDef) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 64) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 64 + "[");
        }
        StructureJNI.TAG_CART_set_UserDef(this.pointer, elementIndex, userDef);
    }

    public int getDwLevelReference() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        int javaResult = StructureJNI.TAG_CART_get_dwLevelReference(this.pointer);
        return javaResult;
    }

    public void setDwLevelReference(int dwLevelReference) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        StructureJNI.TAG_CART_set_dwLevelReference(this.pointer, dwLevelReference);
    }

    public TAG_CART_TIMER getPostTimer(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        long javaResult = StructureJNI.TAG_CART_get_PostTimer_element(this.pointer, elementIndex);
        return javaResult == 0L ? null : TAG_CART_TIMER.asTAG_CART_TIMER(Pointer.newPointer(javaResult));
    }

    public TAG_CART_TIMER[] getPostTimer() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        long javaResult = StructureJNI.TAG_CART_get_PostTimer(this.pointer);
        int PostTimerLength = 8;
        if (PostTimerLength <= 0 || javaResult == 0L) {
            return null;
        }
        TAG_CART_TIMER[] PostTimerArray = new TAG_CART_TIMER[PostTimerLength];
        int SIZEOF_TAG_CART_TIMER = StructureJNI.TAG_CART_TIMER_SIZEOF();
        int i = 0;
        while (i < PostTimerArray.length) {
            PostTimerArray[i] = new TAG_CART_TIMER(javaResult + (long)(i * SIZEOF_TAG_CART_TIMER));
            ++i;
        }
        return PostTimerArray;
    }

    public void setPostTimer(int elementIndex, TAG_CART_TIMER postTimer) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 8) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 8 + "[");
        }
        StructureJNI.TAG_CART_set_PostTimer(this.pointer, elementIndex, Pointer.getPointer(postTimer));
    }

    public char getUrl(int elementIndex) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 1024) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 1024 + "[");
        }
        char javaResult = StructureJNI.TAG_CART_get_URL_element(this.pointer, elementIndex);
        return javaResult;
    }

    public CharBuffer getUrl() {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        ByteBuffer javaResult = StructureJNI.TAG_CART_get_URL(this.pointer);
        if (javaResult == null) {
            return null;
        }
        javaResult.order(ByteOrder.nativeOrder());
        return javaResult.asCharBuffer();
    }

    public void setUrl(int elementIndex, char url) {
        if (this.pointer == 0L) {
            throw new NullPointerException();
        }
        if (elementIndex < 0 || elementIndex > 1024) {
            throw new IndexOutOfBoundsException(String.valueOf(elementIndex) + " out of bounds [0; " + 1024 + "[");
        }
        StructureJNI.TAG_CART_set_URL(this.pointer, elementIndex, url);
    }
}

