/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Path2;
import io.lacuna.artifex.Region2;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.utils.Scalars;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.LinearMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class DistanceField {
    private final float[][][] field;
    private final Box2 shapeBounds;
    private final Box2 fieldBounds;
    private static final byte BLACK = 0;
    private static final byte RED = 1;
    private static final byte GREEN = 2;
    private static final byte YELLOW = 3;
    private static final byte BLUE = 4;
    private static final byte MAGENTA = 5;
    private static final byte CYAN = 6;
    private static final byte WHITE = 7;

    private DistanceField(float[][][] field, Box2 shapeBounds, Box2 fieldBounds) {
        this.field = field;
        this.shapeBounds = shapeBounds;
        this.fieldBounds = fieldBounds;
    }

    public int width() {
        return this.field.length;
    }

    public int height() {
        return this.field[0].length;
    }

    public Box2 shapeBounds() {
        return this.shapeBounds;
    }

    public Box2 fieldBounds() {
        return this.fieldBounds;
    }

    private static Vec3 normalizedPixel(Vec3 pixel, float range) {
        return (Vec3)((Vec3)((Vec3)pixel.div(range / 2.0f)).add(0.5)).clamp(0.0, 1.0);
    }

    private Vec3 pixel(int x, int y) {
        float[] pixel = this.field[x][y];
        return new Vec3(pixel[0], pixel[1], pixel[2]);
    }

    public Vec3 get(double x, double y) {
        int x1 = (int)(x * (double)(this.width() - 1));
        int x2 = Math.min(this.width() - 1, x1 + 1);
        int y1 = (int)(y * (double)(this.height() - 1));
        int y2 = Math.min(this.height() - 1, y1 + 1);
        double xt = x * (double)this.width() - (double)x1;
        double yt = y * (double)this.height() - (double)y1;
        return (Vec3)Vec.lerp(Vec.lerp(this.pixel(x1, y1), this.pixel(x1, y2), yt), Vec.lerp(this.pixel(x2, y1), this.pixel(x2, y2), yt), xt);
    }

    public Vec3 normalized(double x, double y, double scale2) {
        return (Vec3)((Vec3)((Vec3)this.get(x, y).div(scale2 / 2.0)).add(0.5)).clamp(0.0, 1.0);
    }

    public Vec3 test(double x, double y) {
        return this.get(x, y).map(n -> n < 0.0 ? 0.0 : 1.0);
    }

    public Vec3 rendered(double x, double y) {
        Vec3 pixel = this.get(x, y);
        return DistanceField.median(pixel.x, pixel.y, pixel.z) < 0.0 ? Vec3.ORIGIN : Vec.vec(1.0, 1.0, 1.0);
    }

    public Vec3 pixel(int x, int y, float scale2) {
        float[] colors = this.field[x][y];
        return (Vec3)((Vec3)((Vec3)new Vec3(colors[0], colors[1], colors[2]).div(scale2 / 2.0f)).add(0.5)).clamp(0.0, 1.0);
    }

    public static DistanceField from(Region2 region, double sampleFrequency) {
        return DistanceField.from(region, 4, sampleFrequency, Math.toRadians(3.0));
    }

    public static DistanceField from(Region2 region, int padding, double sampleFrequency, double cornerThreshold) {
        Box2 shapeBounds = region.bounds();
        int w = (int)Math.ceil(((Vec2)shapeBounds.size()).x * sampleFrequency);
        int h = (int)Math.ceil(((Vec2)shapeBounds.size()).y * sampleFrequency);
        Vec2 pixelSize = ((Vec2)shapeBounds.size()).div(Vec.vec(w, h));
        Box2 fieldBounds = (Box2)shapeBounds.expand(pixelSize.mul(padding));
        IMap<Curve2, Byte> curveMap = new LinearMap<Curve2, Byte>();
        for (Ring2 r : region.rings()) {
            curveMap = curveMap.union(DistanceField.edgeColors(r, cornerThreshold));
        }
        FieldCurve[] curves = (FieldCurve[])curveMap.stream().map(e -> new FieldCurve((Curve2)e.key(), (Byte)e.value())).toArray(FieldCurve[]::new);
        float[][][] field = new float[w][h][3];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                SignedDistance b = null;
                SignedDistance g = null;
                SignedDistance r = null;
                Vec2 t = new Vec2(((double)x + 0.5) / (double)(w + 1), ((double)y + 0.5) / (double)(h + 1));
                Vec2 p = fieldBounds.lerp(t);
                for (FieldCurve c2 : curves) {
                    double ds = c2.bounds.distanceSquared(p);
                    if (r != null && g != null && b != null && ds >= r.distSquared && ds >= g.distSquared && ds >= b.distSquared) continue;
                    SignedDistance d = new SignedDistance(c2.curve, p);
                    if ((c2.color & 1) > 0 && (r == null || r.compareTo(d) > 0)) {
                        r = d;
                    }
                    if ((c2.color & 2) > 0 && (g == null || g.compareTo(d) > 0)) {
                        g = d;
                    }
                    if ((c2.color & 4) <= 0 || b != null && b.compareTo(d) <= 0) continue;
                    b = d;
                }
                field[x][y][0] = r != null ? (float)r.distance() : 0.0f;
                field[x][y][1] = g != null ? (float)g.distance() : 0.0f;
                field[x][y][2] = b != null ? (float)b.distance() : 0.0f;
            }
        }
        DistanceField.fixClashes(field, Vec.vec(0.0, 0.0));
        return new DistanceField(field, shapeBounds, fieldBounds);
    }

    private static boolean isCorner(Curve2 a2, Curve2 b, double crossThreshold) {
        Vec2 tb;
        Vec2 ta = (Vec2)a2.direction(1.0).norm();
        return Vec.dot(ta, tb = (Vec2)b.direction(0.0).norm()) <= 0.0 || Math.abs(Vec2.cross(ta, tb)) > crossThreshold;
    }

    private static List<Integer> cornerIndices(Ring2 ring, double angleThreshold) {
        ArrayList<Integer> corners = new ArrayList<Integer>();
        Curve2[] curves = ring.curves;
        double crossThreshold = Math.sin(angleThreshold);
        Curve2 prev = curves[curves.length - 1];
        for (int i = 0; i < curves.length; ++i) {
            Curve2 curr = curves[i];
            if (DistanceField.isCorner(prev, curr, crossThreshold)) {
                corners.add(i);
            }
            prev = curr;
        }
        return corners;
    }

    private static Curve2[] splitIntoThirds(Curve2 c2) {
        return c2.split(new double[]{0.33, 0.66});
    }

    private static IMap<Curve2, Byte> edgeColors(Ring2 ring, double angleThreshold) {
        LinearMap<Curve2, Byte> edgeColors = new LinearMap<Curve2, Byte>();
        List<Integer> corners = DistanceField.cornerIndices(ring, angleThreshold);
        Curve2[] curves = ring.curves;
        if (corners.isEmpty()) {
            for (Curve2 c2 : curves) {
                edgeColors.put(c2, (byte)7);
            }
        } else if (corners.size() == 1) {
            int offset2 = corners.get(0);
            byte[] colors = new byte[]{5, 7, 3};
            int num = curves.length;
            if (num >= 3) {
                for (int i = 0; i < num; ++i) {
                    Curve2 c3 = curves[(i + offset2) % num];
                    int colorIdx = (int)(3.0 + 2.875 * (double)i / (double)(num - 1) - 1.4375 + 0.5) - 2;
                    edgeColors.put(c3, colors[colorIdx]);
                }
            } else if (num == 2) {
                Curve2[] a2 = DistanceField.splitIntoThirds(curves[0]);
                Curve2[] b = DistanceField.splitIntoThirds(curves[1]);
                for (int i = 0; i < 6; ++i) {
                    edgeColors.put(i < 3 ? a2[i] : b[i - 3], colors[i / 2]);
                }
            } else {
                Curve2[] thirds = DistanceField.splitIntoThirds(curves[0]);
                for (int i = 0; i < 3; ++i) {
                    edgeColors.put(thirds[i], colors[i]);
                }
            }
        } else {
            int offset3 = corners.get(0);
            int cIdx = 0;
            byte[] colors = new byte[]{corners.size() % 3 == 1 ? (byte)3 : 6, 6, 5, 3};
            for (int i = 0; i < curves.length; ++i) {
                int idx = (i + offset3) % curves.length;
                if (cIdx + 1 < corners.size() && corners.get(cIdx + 1) == idx) {
                    ++cIdx;
                }
                edgeColors.put(curves[idx], colors[1 + cIdx % 3 - (cIdx == 0 ? 1 : 0)]);
            }
        }
        return edgeColors;
    }

    public static double median(double a2, double b, double c2) {
        return Math.max(Math.min(a2, b), Math.min(Math.max(a2, b), c2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean clash(float[] a2, float[] b, double threshold) {
        float bc;
        float ac;
        float bb;
        float ab;
        float ba;
        float aa;
        boolean bIn;
        boolean aIn = (a2[0] > 0.0f ? 1 : 0) + (a2[1] > 0.0f ? 1 : 0) + (a2[2] > 0.0f ? 1 : 0) >= 2;
        boolean bl = bIn = (b[0] > 0.0f ? 1 : 0) + (b[1] > 0.0f ? 1 : 0) + (b[2] > 0.0f ? 1 : 0) >= 2;
        if (aIn != bIn) {
            return false;
        }
        if (a2[0] > 0.0f && a2[1] > 0.0f) {
            if (a2[2] > 0.0f) return false;
        }
        if (a2[0] < 0.0f && a2[1] < 0.0f) {
            if (a2[2] < 0.0f) return false;
        }
        if (b[0] > 0.0f && b[1] > 0.0f) {
            if (b[2] > 0.0f) return false;
        }
        if (b[0] < 0.0f && b[1] < 0.0f && b[2] < 0.0f) {
            return false;
        }
        if (a2[0] > 0.0f != b[0] > 0.0f && a2[0] < 0.0f != b[0] < 0.0f) {
            aa = a2[0];
            ba = b[0];
            if (a2[1] > 0.0f != b[1] > 0.0f && a2[1] < 0.0f != b[1] < 0.0f) {
                ab = a2[1];
                bb = b[1];
                ac = a2[2];
                bc = b[2];
            } else {
                if (a2[2] > 0.0f == b[2] > 0.0f) return false;
                if (a2[2] < 0.0f == b[2] < 0.0f) return false;
                ab = a2[2];
                bb = b[2];
                ac = a2[1];
                bc = b[1];
            }
        } else {
            if (a2[1] > 0.0f == b[1] > 0.0f) return false;
            if (a2[1] < 0.0f == b[1] < 0.0f) return false;
            if (a2[2] > 0.0f == b[2] > 0.0f) return false;
            if (a2[2] < 0.0f == b[2] < 0.0f) return false;
            aa = a2[1];
            ba = b[1];
            ab = a2[2];
            bb = b[2];
            ac = a2[0];
            bc = b[0];
        }
        if (!((double)Math.abs(aa - ba) >= threshold)) return false;
        if (!((double)Math.abs(ab - bb) >= threshold)) return false;
        if (!(Math.abs(ac) >= Math.abs(bc))) return false;
        return true;
    }

    private static void fixClashes(float[][][] field, Vec2 threshold) {
        int width = field.length;
        int height = field[0].length;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float median;
                float[] color = field[i][j];
                if (!(i > 0 && DistanceField.clash(color, field[i - 1][j], threshold.x) || i < width - 1 && DistanceField.clash(color, field[i + 1][j], threshold.x) || j > 0 && DistanceField.clash(color, field[i][j - 1], threshold.y)) && (j >= height - 1 || !DistanceField.clash(color, field[i][j + 1], threshold.y))) continue;
                color[1] = color[2] = (median = (float)DistanceField.median(color[0], color[1], color[2]));
                color[0] = color[2];
            }
        }
    }

    private static boolean insideRing2s(List<Path2> rings, Vec2 point) {
        return rings.stream().flatMap((Function<Path2, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$insideRing2s$3(io.lacuna.artifex.Path2 ), (Lio/lacuna/artifex/Path2;)Ljava/util/stream/Stream;)()).map((Function<Curve2, SignedDistance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$insideRing2s$4(io.lacuna.artifex.Vec2 io.lacuna.artifex.Curve2 ), (Lio/lacuna/artifex/Curve2;)Lio/lacuna/artifex/DistanceField$SignedDistance;)((Vec2)point)).sorted().findFirst().get().inside;
    }

    private static /* synthetic */ SignedDistance lambda$insideRing2s$4(Vec2 point, Curve2 c2) {
        return new SignedDistance(c2, point);
    }

    private static /* synthetic */ Stream lambda$insideRing2s$3(Path2 rs) {
        return Arrays.stream(rs.curves());
    }

    static class SignedDistance
    implements Comparable<SignedDistance> {
        private static final Comparator<SignedDistance> COMPARATOR = Comparator.comparing(d -> d.distSquared).thenComparing(d -> d.dot);
        public final double distSquared;
        public final double pseudoDistSquared;
        public final double dot;
        public boolean inside;

        public SignedDistance(Curve2 curve, Vec2 origin) {
            double param = curve.nearestPoint(origin);
            double clampedParam = Scalars.clamp(0.0, param, 1.0);
            Vec2 pos = curve.position(clampedParam);
            Vec2 dir = (Vec2)curve.direction(clampedParam).norm();
            Vec2 po = origin.sub(pos);
            this.distSquared = po.lengthSquared();
            boolean bl = this.inside = Vec2.cross(dir, po) > 0.0;
            if (param == clampedParam) {
                this.dot = 0.0;
                this.pseudoDistSquared = -1.0;
            } else {
                double ts = Vec.dot(po, dir);
                this.dot = Math.abs(Vec.dot(dir, (Vec2)po.norm()));
                if (Math.signum(ts) == Math.signum(param)) {
                    double pseudoDistance = Vec2.cross(po, dir);
                    this.pseudoDistSquared = pseudoDistance * pseudoDistance;
                } else {
                    this.pseudoDistSquared = -1.0;
                }
            }
        }

        public double distance() {
            return Math.sqrt(this.distanceSquared()) * (double)(this.inside ? 1 : -1);
        }

        public double distanceSquared() {
            return this.pseudoDistSquared > 0.0 && this.pseudoDistSquared < this.distSquared ? this.pseudoDistSquared : this.distSquared;
        }

        @Override
        public int compareTo(SignedDistance o) {
            return COMPARATOR.compare(this, o);
        }
    }

    private static class FieldCurve {
        public final Curve2 curve;
        public final Box2 bounds;
        public final byte color;

        public FieldCurve(Curve2 curve, byte color) {
            this.curve = curve;
            this.bounds = curve.bounds();
            this.color = color;
        }
    }
}

