						EXPORT	AFTERBURNER


AFTERBURNER_LOCAL_VARIABLE_SIZE	EQU	10


AB_AIR_FLAG_ALIVE	EQU		1
AB_AIR_FLAG_IS_AIR	EQU		2

AB_OBJ_X			EQU		0		; 1 byte
AB_OBJ_Y			EQU		1		; 1 byte
AB_OBJ_Z			EQU		2		; 1 byte
AB_OBJ_BANK			EQU		3		; 1 byte
AB_OBJ_PTN_PTR		EQU		4		; 2 byte pointer
AB_OBJ_PTN_SIZE		EQU		6		; 1 byte pattern size
AB_OBJ_LOD_PTR		EQU		7		; 2 byte pointer for LOD (when Z>32)
AB_OBJ_LOD_SIZE		EQU		9		; 1 byte pattern size
AB_OBJ_FLAGS		EQU		10		; 1 byte flags
AB_OBJ_COUNTER		EQU		11		; 1 byte counter
AB_OBJ_SCRNX		EQU		12		; 2 byte X Projected screen coordinate (LU=(0,0))
AB_OBJ_SCRNY		EQU		14		; 2 byte Y
AB_OBJ_SCRNBANK		EQU		16		; 1 byte Bank on the screen
AB_OBJ_SCRNSCALE	EQU		17		; 1 byte scaling
AB_OBJ_DATA_SIZE	EQU		18


AB_OBJ_MAX_NUM_OBJ	EQU		16


AB_BANK_STEP		EQU		6
AB_MOVE_STEP		EQU		8


AB_SEQUENCE_COUNTER	FCB		0
AB_FRAME_COUNTER	FCB		0

AB_AIRCRAFT_PASS	FCB		0

AB_VIEW_PITCH		FCB		0
AB_VIEW_BANK		FCB		0
AB_VIEW_Y			FDB		#127
AB_VIEW_Z			FDB		0		; Only for rendering ground.

AB_SEQUENCE_FINISH	FCB		0

AB_NUM_OBJ			FCB		0
AB_OBJ_DATA_BUF		RZB		AB_OBJ_DATA_SIZE*AB_OBJ_MAX_NUM_OBJ



AFTERBURNER
					;	[9,S]	1 byte	unused
					;	[8,S]	1 byte	unused
					;	[6,S]	2 byte	unused
					;	[4,S]	2 byte	unused
					;	[3,S]	1 byte
					;	[2,S]	1 byte	Sequence
					;	[1,S]	1 byte	Sub-Counter
					;	[,S]	1 byte	Counter

					LBSR	AFTERBURNER_INIT

					LDA		#AFTERBURNER_LOCAL_VARIABLE_SIZE
AFTERBURNER_CLEAR_LOCAL
					CLR		,-S
					DECA
					BNE		AFTERBURNER_CLEAR_LOCAL


					LDX		#120
					STX		4,S


AFTERBURNER_OUTER_LOOP
					LBSR	AFTERBURNER_TRANSFORM_OBJ_ARRAY
					BSR		AFTERBURNER_RENDER


					LDX		AB_VIEW_Z,PCR
					LEAX	1,X
					STX		AB_VIEW_Z,PCR


					LBSR	AFTERBURNER_MOVE

					INC		,S

					TST		AB_SEQUENCE_FINISH,PCR
					BEQ		AFTERBURNER_OUTER_LOOP


					LEAS	AFTERBURNER_LOCAL_VARIABLE_SIZE,S
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_RENDER
					LBSR	HALT_SUBCPU
					LBSR	MMR_ENABLE_ACCESS_SUBCPU_RAM


					LDY		#LINEDATA_BUF
					LDA		2+0,S
					ANDA	#1
					LBSR	SUBCPU_PUSH_BEGIN_FRAME_CMD


					LBSR	AFTERBURNER_RENDER_OBJ_ARRAY



					;	Y		Pointer where Sub-CPU commands need to be stored.
					;	A		Pitch
					;	B		Bank
					;	X		View Z (0-127)
					;	U		View Y (0-255)
					LDD		AB_VIEW_PITCH,PCR
					LDX		AB_VIEW_Z,PCR
					LDU		AB_VIEW_Y,PCR
					LBSR	RENDER_HORIZON



					LDA		2+0,S
					ANDA	#1
					LBSR	SUBCPU_PUSH_END_FRAME_CMD


					LDA		#LINE_CMD_2D_END_OF_CMDSET
					STA		,Y+


					LBSR	MMR_DISABLE
					LBSR	RELEASE_SUBCPU

					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


AFTERBURNER_INIT
					CLR		AB_SEQUENCE_FINISH,PCR
					CLR		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_FRAME_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR

					LDX		#127
					STX		AB_VIEW_Y,PCR
					LDD		#0
					STA		AB_VIEW_BANK,PCR
					STD		AB_VIEW_Z,PCR


					CLR		AB_NUM_OBJ,PCR
					LEAU	AB_OBJ_DATA_BUF,PCR

					LDX		#AB_OBJ_DATA_SIZE*AB_OBJ_MAX_NUM_OBJ
AFTERBURNER_INIT_CLEAR_DATA_BUF
					CLR		,U+
					LEAX	-1,X
					BNE		AFTERBURNER_INIT_CLEAR_DATA_BUF


					LEAU	AB_OBJ_DATA_BUF,PCR

					; F-14
					INC		AB_NUM_OBJ,PCR

					LDX		#$0000
					STX		AB_OBJ_X,U		; X,Y

					LDX		#$0300
					STX		AB_OBJ_Z,U		; Z,Bank

					LEAX	F14_2D_DATA,PCR
					STX		AB_OBJ_PTN_PTR,U	; Pattern pointer
					STX		AB_OBJ_LOD_PTR,U

					CLR		AB_OBJ_PTN_SIZE,U
					STA		AB_OBJ_LOD_SIZE,U

					LDA		#AB_AIR_FLAG_ALIVE|AB_AIR_FLAG_IS_AIR
					CLRB
					STD		AB_OBJ_FLAGS,U	; Flags, Counter



					LEAU	AB_OBJ_DATA_SIZE,U

					; AV8B
					INC		AB_NUM_OBJ,PCR

					LDX		#$009F
					STX		AB_OBJ_X,U		; X,Y

					LDX		#$2800
					STX		AB_OBJ_Z,U		; Z,Bank

					LEAX	AV8B_2D_DATA,PCR
					STX		AB_OBJ_PTN_PTR,U	; Pattern pointer

					CLR		AB_OBJ_PTN_SIZE,U

					LEAX	AV8B_2D_LOD_DATA,PCR
					STX		AB_OBJ_LOD_PTR,U	; Pattern pointer

					CLR		AB_OBJ_LOD_SIZE,U

					LDA		#AB_AIR_FLAG_IS_AIR
					CLRB
					STD		AB_OBJ_FLAGS,U	; Flags, Counter



					LEAU	AB_OBJ_DATA_SIZE,U

					; AV8B
					INC		AB_NUM_OBJ,PCR

					LDX		#$81B0
					STX		AB_OBJ_X,U		; X,Y

					LDX		#$5000
					STX		AB_OBJ_Z,U		; Z,Bank

					LEAX	AV8B_2D_DATA,PCR
					STX		AB_OBJ_PTN_PTR,U	; Pattern pointer

					CLR		AB_OBJ_PTN_SIZE,U

					LEAX	AV8B_2D_LOD_DATA,PCR
					STX		AB_OBJ_LOD_PTR,U	; Pattern pointer

					CLR		AB_OBJ_LOD_SIZE,U

					LDA		#AB_AIR_FLAG_IS_AIR
					CLRB
					STD		AB_OBJ_FLAGS,U	; Flags, Counter



					LEAU	AB_OBJ_DATA_SIZE,U

					; AV8B
					INC		AB_NUM_OBJ,PCR

					LDX		#$7F70
					STX		AB_OBJ_X,U		; X,Y

					LDX		#$7800
					STX		AB_OBJ_Z,U		; Z,Bank

					LEAX	AV8B_2D_DATA,PCR
					STX		AB_OBJ_PTN_PTR,U	; Pattern pointer

					CLR		AB_OBJ_PTN_SIZE,U

					LEAX	AV8B_2D_LOD_DATA,PCR
					STX		AB_OBJ_LOD_PTR,U	; Pattern pointer

					CLR		AB_OBJ_LOD_SIZE,U

					LDA		#AB_AIR_FLAG_IS_AIR
					CLRB
					STD		AB_OBJ_FLAGS,U	; Flags, Counter


					RTS


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Use
;			AB_VIEW_BANK

AFTERBURNER_TRANSFORM_OBJ_ARRAY
					LEAU	AB_OBJ_DATA_BUF,PCR
					LDA		AB_NUM_OBJ,PCR
					PSHS	U,A

					TSTA
					LBEQ	AFTERBURNER_TRANSFORM_OBJ_ARRAY_EXIT

					; [,S]		OBJ COUNTER
					; [1,S]		OBJ POINTER

AFTERBURNER_TRANSFORM_OBJ_ARRAY_LOOP
					LDU		1,S

					LDA		AB_OBJ_FLAGS,U
					BITA	#AB_AIR_FLAG_ALIVE
					BEQ		AFTERBURNER_TRANSFORM_OBJ_ARRAY_NEXT

					LDB		AB_OBJ_X,U
					SEX
					TFR		D,X

					LDB		AB_OBJ_Y,U
					CLRA
					SUBD	AB_VIEW_Y,PCR
					TFR		D,Y

					LDB		AB_OBJ_Z,U


					LBSR	PROJECT_PERSPECTIVE_ONE_COORD_SCALING_ONLY
					; X,Y rotated coordinate in screen scale.  Still Positive-Y is up.

					TFR		X,D
					LSLB
					ROLA
					TFR		D,X

					TFR		Y,D
					LSLB
					ROLA
					TFR		D,Y

					LDB		AB_VIEW_BANK,PCR
					NEGB
					LBSR	ROT16

					LEAX	160,X
					STX		AB_OBJ_SCRNX,U

					STY		AB_OBJ_SCRNY,U
					LDD		#100
					SUBD	AB_OBJ_SCRNY,U
					STD		AB_OBJ_SCRNY,U

					LDB		AB_OBJ_BANK,U
					SUBB	AB_VIEW_BANK,PCR
					STB		AB_OBJ_SCRNBANK,U

					LEAX	DIVTABLE,PCR
					LDB		AB_OBJ_Z,U
					ABX
					LDB		,X
					STB		AB_OBJ_SCRNSCALE,U


AFTERBURNER_TRANSFORM_OBJ_ARRAY_NEXT
					LDU		1,S
					LEAU	AB_OBJ_DATA_SIZE,U
					STU		1,S
					DEC		,S
					BNE		AFTERBURNER_TRANSFORM_OBJ_ARRAY_LOOP


AFTERBURNER_TRANSFORM_OBJ_ARRAY_EXIT
					PULS	A,U,PC


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Input
;		Y pointer to store rendering data
AFTERBURNER_RENDER_OBJ_ARRAY
					LEAU	AB_OBJ_DATA_BUF,PCR
					LDA		AB_NUM_OBJ,PCR
					PSHS	A

					; [,S]		OBJ COUNTER

AFTERBURNER_RENDER_OBJ_ARRAY_LOOP
					LDA		AB_OBJ_FLAGS,U
					ANDA	#AB_AIR_FLAG_ALIVE
					BEQ		AFTERBURNER_RENDER_OBJ_ARRAY_NEXT

					LDA		#LINE_CMD_SET_TRANS
					STA		,Y+

					LDD		AB_OBJ_SCRNBANK,U	; Bank, Scaling
					STD		,Y++

					LDD		AB_OBJ_SCRNX,U		; X
					STD		,Y++

					LDD		AB_OBJ_SCRNY,U		; X
					STD		,Y++

					LDA		#LINE_CMD_2D_TRANS_CLIP
					STA		,Y+

					LDX		AB_OBJ_PTN_PTR,U

					LDA		AB_OBJ_Z,U
					CMPA	#16
					BLE		AFTERBURNER_RENDER_OBJ_ARRAY_TRANSFER_LOOP_START

					LDX		AB_OBJ_LOD_PTR,U

AFTERBURNER_RENDER_OBJ_ARRAY_TRANSFER_LOOP_START
					LDB		,X+
					STB		,Y+

					PSHS	U
AFTERBURNER_RENDER_OBJ_ARRAY_TRANSFER_LOOP
					LDA		,X+
					STA		,Y+
					LDU		,X++
					STU		,Y++
					LDU		,X++
					STU		,Y++
					DECB
					BNE		AFTERBURNER_RENDER_OBJ_ARRAY_TRANSFER_LOOP
					PULS	U

AFTERBURNER_RENDER_OBJ_ARRAY_NEXT
					LEAU	AB_OBJ_DATA_SIZE,U
					DEC		,S
					BNE		AFTERBURNER_RENDER_OBJ_ARRAY_LOOP


AFTERBURNER_RENDER_OBJ_ARRAY_EXIT
					PULS	A,PC


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_EVERYTHING_FORWARD
					LEAU	AB_OBJ_DATA_BUF,PCR
					LDB		AB_NUM_OBJ,PCR
					BEQ		AFTERBURNER_MOVE_FORWARD_END

					LEAU	AB_OBJ_DATA_SIZE,U
					DECB
					BEQ		AFTERBURNER_MOVE_FORWARD_END

AFTERBURNER_MOVE_FORWARD_LOOP
					LDA		AB_OBJ_FLAGS,U
					ANDA	#AB_AIR_FLAG_ALIVE
					BEQ		AFTERBURNER_MOVE_FORWARD_NEXT

					LDA		AB_OBJ_Z,U
					DECA
					BPL		AFTERBURNER_MOVE_FORWARD_NO_PASS

					PSHS	A
					LDA		AB_OBJ_FLAGS,U
					ANDA	#AB_AIR_FLAG_IS_AIR
					PULS	A
					BEQ		AFTERBURNER_MOVE_FORWARD_NO_PASS

					INC		AB_AIRCRAFT_PASS,PCR

AFTERBURNER_MOVE_FORWARD_NO_PASS
					ANDA	#127
					STA		AB_OBJ_Z,U

AFTERBURNER_MOVE_FORWARD_NEXT
					LEAU	AB_OBJ_DATA_SIZE,U
					DECB
					BNE		AFTERBURNER_MOVE_FORWARD_LOOP

AFTERBURNER_MOVE_FORWARD_END
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE
					BSR		AFTERBURNER_MOVE_EVERYTHING_FORWARD

					LDA		AB_SEQUENCE_COUNTER,PCR

					BEQ		AFTERBURNER_MOVE_SEQUENCE0
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE1
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE2
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE3
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE4
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE5
					DECA
					BEQ		AFTERBURNER_MOVE_SEQUENCE6

					CLRA	; Clear carry
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE0
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0
					INC		AB_OBJ_Y,U
					LDA		AB_OBJ_Y,U
					CMPA	#$9F
					BCS		AFTERBURNER_MOVE_SEQUENCE0_EXIT

					INC		AB_SEQUENCE_COUNTER,PCR

					LDB		AB_NUM_OBJ,PCR
AFTERBURNER_MOVE_SEQUENCE0_NEXTSEQUENCE
					LDA		AB_OBJ_FLAGS,U
					ORA		#AB_AIR_FLAG_ALIVE
					STA		AB_OBJ_FLAGS,U
					LEAU	AB_OBJ_DATA_SIZE,U
					DECB
					BNE		AFTERBURNER_MOVE_SEQUENCE0_NEXTSEQUENCE

AFTERBURNER_MOVE_SEQUENCE0_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE1
					BSR		AFTERBURNER_MOVE_F14_LEFT
					LDA		AB_AIRCRAFT_PASS,PCR
					BEQ		AFTERBURNER_MOVE_SEQUENCE1_EXIT
					INC		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR
AFTERBURNER_MOVE_SEQUENCE1_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE2
					LBSR	AFTERBURNER_MOVE_F14_RIGHT
					LDA		AB_AIRCRAFT_PASS,PCR
					BEQ		AFTERBURNER_MOVE_SEQUENCE2_EXIT
					INC		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR
AFTERBURNER_MOVE_SEQUENCE2_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE3
					LBSR	AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL
					BCC		AFTERBURNER_MOVE_SEQUENCE3_EXIT
					INC		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR
AFTERBURNER_MOVE_SEQUENCE3_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE4
					LBSR	AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL
					BCC		AFTERBURNER_MOVE_SEQUENCE4_EXIT
					INC		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR
AFTERBURNER_MOVE_SEQUENCE4_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE5
					LBSR	AFTERBURNER_MOVE_F14_CENTER
					BCC		AFTERBURNER_MOVE_SEQUENCE5_EXIT
					INC		AB_SEQUENCE_COUNTER,PCR
					CLR		AB_AIRCRAFT_PASS,PCR
					LDA		2,S
					ANDA	#1
					STA		2,S

AFTERBURNER_MOVE_SEQUENCE5_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_SEQUENCE6
					LDA		2,S
					CMPA	#254
					BCC		AFTERBURNER_MOVE_SEQUENCE6_END_OF_SEQUENCE

					LBSR	TIMER_GET_COUNTER

					; Should stop at #$18000
					; Actual FM77AV40 is a bit slower than XM7.
					; AFTERBURNER sequence should terminate slightly earlier.
					; Say $17E80.
					CMPX	#1
					BLO		AFTERBURNER_MOVE_SEQUENCE6_CONTINUE
					BHI		AFTERBURNER_MOVE_SEQUENCE6_END_OF_SEQUENCE
					CMPD	#$7E80	; Timing to start landing sequence.
					BHI		AFTERBURNER_MOVE_SEQUENCE6_END_OF_SEQUENCE

AFTERBURNER_MOVE_SEQUENCE6_CONTINUE
					RTS

AFTERBURNER_MOVE_SEQUENCE6_END_OF_SEQUENCE
					COM		AB_SEQUENCE_FINISH,PCR
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_F14_LEFT
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0

					LDA		AB_OBJ_X,U
					CMPA	#-120
					BLE		AFTERBURNER_MOVE_F14_LEFT_MOVED_LEFT

					SUBA	#AB_MOVE_STEP
					STA		AB_OBJ_X,U

					LDA		AB_OBJ_BANK,U
					CMPA	#48
					BGE		AFTERBURNER_MOVE_F14_LEFT_BANKED

					ADDA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR

AFTERBURNER_MOVE_F14_LEFT_BANKED
					BRA		AFTERBURNER_MOVE_F14_LEFT_EXIT

AFTERBURNER_MOVE_F14_LEFT_MOVED_LEFT
					LDA		AB_OBJ_BANK,U
					BMI		AFTERBURNER_MOVE_F14_LEFT_EXIT
					BEQ		AFTERBURNER_MOVE_F14_LEFT_EXIT

					SUBA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR

AFTERBURNER_MOVE_F14_LEFT_EXIT
					CLRA	; Carry clear
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_F14_CENTER
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0
					LDA		AB_OBJ_X,U
					CMPA	#-AB_MOVE_STEP
					BLT		AFTERBURNER_MOVE_F14_RIGHT
					CMPA	#AB_MOVE_STEP
					BGT		AFTERBURNER_MOVE_F14_LEFT

					CLR		AB_OBJ_X,U
					LDA		AB_OBJ_BANK,U
					BEQ		AFTERBURNER_MOVE_F14_CENTER_MOVED
					CMPA	#-AB_BANK_STEP
					BLE		AFTERBURNER_MOVE_F14_CENTER_ROLL_LEFT
					CMPA	#AB_BANK_STEP
					BGE		AFTERBURNER_MOVE_F14_CENTER_ROLL_RIGHT

					CLR		AB_OBJ_BANK,U
					CLR		AB_VIEW_BANK,PCR
					RTS

AFTERBURNER_MOVE_F14_CENTER_ROLL_RIGHT
					SUBA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR
					CLRA	; Clear carry
					RTS

AFTERBURNER_MOVE_F14_CENTER_ROLL_LEFT
					ADDA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR
					CLRA	; Clear carry
					RTS

AFTERBURNER_MOVE_F14_CENTER_MOVED
					COMA	; Set carry
					RTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_F14_RIGHT
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0

					LDA		AB_OBJ_X,U
					CMPA	#119
					BGE		AFTERBURNER_MOVE_F14_RIGHT_MOVED_RIGHT

					ADDA	#AB_MOVE_STEP
					STA		AB_OBJ_X,U

					LDA		AB_OBJ_BANK,U
					CMPA	#-48
					BLE		AFTERBURNER_MOVE_F14_RIGHT_BANKED

					SUBA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR

AFTERBURNER_MOVE_F14_RIGHT_BANKED
					BRA		AFTERBURNER_MOVE_F14_RIGHT_EXIT

AFTERBURNER_MOVE_F14_RIGHT_MOVED_RIGHT
					LDA		AB_OBJ_BANK,U
					BPL		AFTERBURNER_MOVE_F14_RIGHT_EXIT

					ADDA	#AB_BANK_STEP
					STA		AB_OBJ_BANK,U
					ASRA
					STA		AB_VIEW_BANK,PCR


AFTERBURNER_MOVE_F14_RIGHT_EXIT
					CLRA	; Carry clear
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0

					LDA		AB_OBJ_X,U
					CMPA	#-120
					BLE		AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL_MOVED_LEFT

					SUBA	#AB_MOVE_STEP
					STA		AB_OBJ_X,U

AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL_MOVED_LEFT
					LDA		AB_OBJ_BANK,U
					ADDA	#AB_BANK_STEP*2
					STA		AB_OBJ_BANK,U

					LDA		AB_VIEW_BANK,PCR
					ADDA	#AB_BANK_STEP
					STA		AB_VIEW_BANK,PCR

					BCC		AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL_EXIT

					CLR		AB_OBJ_BANK,U
					CLR		AB_VIEW_BANK,PCR
					COMA	; Carry set

AFTERBURNER_MOVE_F14_LEFT_BARREL_ROLL_EXIT
					RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL
					LEAU	AB_OBJ_DATA_BUF,PCR	; F-14 is OBJ#0

					LDA		AB_OBJ_X,U
					CMPA	#119
					BGE		AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL_MOVED_RIGHT

					ADDA	#AB_MOVE_STEP
					STA		AB_OBJ_X,U

AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL_MOVED_RIGHT
					LDA		AB_OBJ_BANK,U
					SUBA	#AB_BANK_STEP*2
					STA		AB_OBJ_BANK,U

					LDA		AB_VIEW_BANK,PCR
					SUBA	#AB_BANK_STEP
					STA		AB_VIEW_BANK,PCR

					BCC		AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL_EXIT

					CLRA
					TST		AB_OBJ_X,U
					BMI		AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL_EXIT

					CLR		AB_OBJ_BANK,U
					CLR		AB_VIEW_BANK,PCR
					COMA	; Carry set

AFTERBURNER_MOVE_F14_RIGHT_BARREL_ROLL_EXIT
					RTS

