#version 130

uniform sampler2D image;
uniform sampler2D flow;
uniform float dt;
uniform vec2 size;

out vec4 fragColor;

void main()
{
  vec2 xy = gl_FragCoord.xy-vec2(0.5,0.5);
  vec2 uv = xy-dt*texture2D(flow,(xy+vec2(0.5,0.5))/size).rg;  
  vec2 ex = uv-clamp(uv,vec2(0.0,0.0),vec2(size)-vec2(1.0,1.0));
  vec2 uv2 = texture2D(image,(uv+vec2(0.5,0.5))/size).rg+ex;
  fragColor = vec4(uv2,0.0,0.0); //XXX: half-pixel offset!
}
