/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.shape.Composition;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGLoader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u00a8\u0006\u0007"}, d2={"loadSVG", "Lorg/openrndr/shape/Composition;", "svgString", "", "parseColor", "Lorg/openrndr/color/ColorRGBa;", "scolor", "openrndr-svg"})
public final class SVGLoaderKt {
    @NotNull
    public static final Composition loadSVG(@NotNull String svgString) {
        Intrinsics.checkParameterIsNotNull(svgString, "svgString");
        SVGDocument doc = new SVGLoader().loadSVG(svgString);
        return doc.composition();
    }

    @Nullable
    public static final ColorRGBa parseColor(@NotNull String scolor) {
        ColorRGBa colorRGBa;
        Intrinsics.checkParameterIsNotNull(scolor, "scolor");
        CharSequence charSequence = scolor;
        if (charSequence.length() == 0 || Intrinsics.areEqual(scolor, "none")) {
            colorRGBa = null;
        } else if (StringsKt.startsWith$default(scolor, "#", false, 2, null)) {
            ColorRGBa color;
            Long v = Long.decode(scolor);
            int vi = (int)v.longValue();
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            colorRGBa = color = new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, null, 16, null);
        } else {
            throw (Throwable)new RuntimeException("could not parse color: " + scolor);
        }
        return colorRGBa;
    }
}

