/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.VertexBufferGL3;
import org.openrndr.internal.gl3.VertexBufferGL3Kt;
import org.openrndr.internal.gl3.VertexBufferShadowGL3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0006\u0010&\u001a\u00020 J\u0018\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lorg/openrndr/internal/gl3/VertexBufferGL3;", "Lorg/openrndr/draw/VertexBuffer;", "buffer", "", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "(ILorg/openrndr/draw/VertexFormat;I)V", "getBuffer", "()I", "bufferHash", "getBufferHash$openrndr_gl3", "isDestroyed", "", "isDestroyed$openrndr_gl3", "()Z", "setDestroyed$openrndr_gl3", "(Z)V", "realShadow", "Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;", "getRealShadow$openrndr_gl3", "()Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;", "setRealShadow$openrndr_gl3", "(Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;)V", "shadow", "Lorg/openrndr/draw/VertexBufferShadow;", "getShadow", "()Lorg/openrndr/draw/VertexBufferShadow;", "getVertexCount", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "bind", "", "destroy", "read", "data", "Ljava/nio/ByteBuffer;", "offset", "unbind", "write", "Companion", "openrndr-gl3"})
public final class VertexBufferGL3
implements VertexBuffer {
    private final int bufferHash;
    @Nullable
    private VertexBufferShadowGL3 realShadow;
    private boolean isDestroyed;
    private final int buffer;
    @NotNull
    private final VertexFormat vertexFormat;
    private final int vertexCount;
    public static final Companion Companion = new Companion(null);

    public final int getBufferHash$openrndr_gl3() {
        return this.bufferHash;
    }

    @Nullable
    public final VertexBufferShadowGL3 getRealShadow$openrndr_gl3() {
        return this.realShadow;
    }

    public final void setRealShadow$openrndr_gl3(@Nullable VertexBufferShadowGL3 vertexBufferShadowGL3) {
        this.realShadow = vertexBufferShadowGL3;
    }

    public final boolean isDestroyed$openrndr_gl3() {
        return this.isDestroyed;
    }

    public final void setDestroyed$openrndr_gl3(boolean bl) {
        this.isDestroyed = bl;
    }

    @Override
    @NotNull
    public VertexBufferShadow getShadow() {
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (this.realShadow == null) {
            this.realShadow = new VertexBufferShadowGL3(this);
        }
        VertexBufferShadowGL3 vertexBufferShadowGL3 = this.realShadow;
        if (vertexBufferShadowGL3 == null) {
            Intrinsics.throwNpe();
        }
        return vertexBufferShadowGL3;
    }

    @Override
    public void write(@NotNull ByteBuffer data, int offset2) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (data.isDirect()) {
            VertexBufferGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(data){
                final /* synthetic */ ByteBuffer $data;

                @NotNull
                public final String invoke() {
                    return "writing to vertex buffer, " + this.$data.remaining() + " bytes";
                }
                {
                    this.$data = byteBuffer;
                    super(0);
                }
            });
            ((Buffer)data).rewind();
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            this.bind();
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            GL33C.glBufferSubData(34962, (long)offset2, data);
            ErrorGL3Kt.checkGLErrors((Function1<? super Integer, String>)new Function1<Integer, String>(this, offset2){
                final /* synthetic */ VertexBufferGL3 this$0;
                final /* synthetic */ int $offset;

                @Nullable
                public final String invoke(int it) {
                    String string;
                    int[] vertexArrayBinding = new int[1];
                    GL33C.glGetIntegerv(34229, vertexArrayBinding);
                    int[] arrayBufferBinding = new int[1];
                    GL33C.glGetIntegerv(34964, arrayBufferBinding);
                    boolean isBuffer = GL33C.glIsBuffer(this.this$0.getBuffer());
                    switch (it) {
                        case 1282: {
                            string = "zero is bound to target. (is buffer: " + isBuffer + ", GL_VERTEX_ARRAY_BINDING: " + vertexArrayBinding[0] + ", GL_ARRAY_BUFFER_BINDING: " + arrayBufferBinding[0] + ')';
                            break;
                        }
                        case 1281: {
                            string = "offset (" + this.$offset + ") or size is negative, or offset+sizeoffset+size is greater than the value of GL_BUFFER_SIZE for the specified buffer object.";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    return string;
                }
                {
                    this.this$0 = vertexBufferGL3;
                    this.$offset = n;
                    super(1);
                }
            });
        } else {
            ByteBuffer temp = BufferUtils.createByteBuffer(data.capacity());
            temp.put(data);
            ByteBuffer byteBuffer = temp;
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "temp");
            this.write(byteBuffer, offset2);
        }
    }

    @Override
    public void read(@NotNull ByteBuffer data, int offset2) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (data.isDirect()) {
            this.bind();
            GL33C.glGetBufferSubData(34962, (long)offset2, data);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
        } else {
            ByteBuffer temp;
            ByteBuffer byteBuffer = temp = BufferUtils.createByteBuffer(data.capacity());
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "temp");
            this.read(byteBuffer, offset2);
            data.put(temp);
        }
    }

    @Override
    public void destroy() {
        VertexBufferGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ VertexBufferGL3 this$0;

            @NotNull
            public final String invoke() {
                return "destroying vertex buffer with id " + this.this$0.getBuffer();
            }
            {
                this.this$0 = vertexBufferGL3;
                super(0);
            }
        });
        this.isDestroyed = true;
        GL33C.glDeleteBuffers(this.buffer);
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
    }

    public final void bind() {
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        VertexBufferGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ VertexBufferGL3 this$0;

            @NotNull
            public final String invoke() {
                return "binding vertex buffer " + this.this$0.getBuffer();
            }
            {
                this.this$0 = vertexBufferGL3;
                super(0);
            }
        });
        GL33C.glBindBuffer(34962, this.buffer);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    public final void unbind() {
        VertexBufferGL3Kt.access$getLogger$p().trace(unbind.1.INSTANCE);
        GL33C.glBindBuffer(34962, 0);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    public VertexBufferGL3(int buffer, @NotNull VertexFormat vertexFormat2, int vertexCount2) {
        Intrinsics.checkParameterIsNotNull(vertexFormat2, "vertexFormat");
        this.buffer = buffer;
        this.vertexFormat = vertexFormat2;
        this.vertexCount = vertexCount2;
        this.bufferHash = VertexBufferGL3Kt.access$getBufferId$p().getAndAdd(1);
    }

    @Override
    public int put(@NotNull Function1<? super BufferWriter, Unit> putter) {
        Intrinsics.checkParameterIsNotNull(putter, "putter");
        return VertexBuffer.DefaultImpls.put(this, putter);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/VertexBufferGL3$Companion;", "", "()V", "createDynamic", "Lorg/openrndr/internal/gl3/VertexBufferGL3;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final VertexBufferGL3 createDynamic(@NotNull VertexFormat vertexFormat2, int vertexCount2) {
            Intrinsics.checkParameterIsNotNull(vertexFormat2, "vertexFormat");
            int buffer = GL33C.glGenBuffers();
            VertexBufferGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(buffer){
                final /* synthetic */ int $buffer;

                @NotNull
                public final String invoke() {
                    return "created new vertex buffer with id " + this.$buffer;
                }
                {
                    this.$buffer = n;
                    super(0);
                }
            });
            GL33C.glBindBuffer(34962, buffer);
            int sizeInBytes = vertexFormat2.getSize() * vertexCount2;
            GL33C.nglBufferData(34962, sizeInBytes, 0L, 35048);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            return new VertexBufferGL3(buffer, vertexFormat2, vertexCount2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

