/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DepthFormat;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.internal.gl3.DepthBufferGL3Kt;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.RenderTargetGL3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0001H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/internal/gl3/DepthBufferGL3;", "Lorg/openrndr/draw/DepthBuffer;", "texture", "", "target", "width", "height", "format", "Lorg/openrndr/draw/DepthFormat;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "(IIIILorg/openrndr/draw/DepthFormat;Lorg/openrndr/draw/BufferMultisample;)V", "getFormat", "()Lorg/openrndr/draw/DepthFormat;", "getHeight", "()I", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "getTarget", "getTexture", "getWidth", "bind", "", "textureUnit", "destroy", "resolveTo", "Companion", "openrndr-gl3"})
public final class DepthBufferGL3
implements DepthBuffer {
    private final int texture;
    private final int target;
    private final int width;
    private final int height;
    @NotNull
    private final DepthFormat format;
    @NotNull
    private final BufferMultisample multisample;
    public static final Companion Companion = new Companion(null);

    @Override
    public void resolveTo(@NotNull DepthBuffer target2) {
        RenderTarget renderTarget2;
        RenderTargetGL3 readTarget2;
        Intrinsics.checkParameterIsNotNull(target2, "target");
        if (Intrinsics.areEqual(target2.getMultisample(), BufferMultisample.Disabled.INSTANCE)) {
            RenderTarget renderTarget3 = RenderTargetKt.renderTarget$default(this.getWidth(), this.getHeight(), 0.0, null, new Function1<RenderTargetBuilder, Unit>(this){
                final /* synthetic */ DepthBufferGL3 this$0;

                public final void invoke(@NotNull RenderTargetBuilder $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    $receiver.depthBuffer(this.this$0);
                }
                {
                    this.this$0 = depthBufferGL3;
                    super(1);
                }
            }, 12, null);
            if (renderTarget3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            readTarget2 = (RenderTargetGL3)renderTarget3;
            renderTarget2 = RenderTargetKt.renderTarget$default(target2.getWidth(), target2.getHeight(), 0.0, null, new Function1<RenderTargetBuilder, Unit>(target2){
                final /* synthetic */ DepthBuffer $target;

                public final void invoke(@NotNull RenderTargetBuilder $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    $receiver.depthBuffer(this.$target);
                }
                {
                    this.$target = depthBuffer;
                    super(1);
                }
            }, 12, null);
            if (renderTarget2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
        } else {
            throw (Throwable)new IllegalArgumentException("cannot resolve to multisample target");
        }
        RenderTargetGL3 writeTarget2 = (RenderTargetGL3)renderTarget2;
        writeTarget2.bind();
        GL33C.glBindFramebuffer(36008, readTarget2.getFramebuffer());
        GL33C.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight(), 256, 9728);
        writeTarget2.unbind();
        writeTarget2.detachColorBuffers();
        writeTarget2.destroy();
        readTarget2.detachColorBuffers();
        readTarget2.destroy();
    }

    @Override
    public void destroy() {
        GL33C.glDeleteTextures(this.texture);
    }

    @Override
    public void bind(int textureUnit) {
        GL33C.glActiveTexture(33984 + textureUnit);
        GL33C.glBindTexture(this.target, this.texture);
    }

    public final int getTexture() {
        return this.texture;
    }

    public final int getTarget() {
        return this.target;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public DepthFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public BufferMultisample getMultisample() {
        return this.multisample;
    }

    public DepthBufferGL3(int texture, int target2, int width, int height, @NotNull DepthFormat format, @NotNull BufferMultisample multisample) {
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull(multisample, "multisample");
        this.texture = texture;
        this.target = target2;
        this.width = width;
        this.height = height;
        this.format = format;
        this.multisample = multisample;
    }

    @Override
    public boolean getHasStencil() {
        return DepthBuffer.DefaultImpls.getHasStencil(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/internal/gl3/DepthBufferGL3$Companion;", "", "()V", "create", "Lorg/openrndr/internal/gl3/DepthBufferGL3;", "width", "", "height", "format", "Lorg/openrndr/draw/DepthFormat;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final DepthBufferGL3 create(int width, int height, @NotNull DepthFormat format, @NotNull BufferMultisample multisample) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)format, "format");
            Intrinsics.checkParameterIsNotNull(multisample, "multisample");
            int glTexture = GL33C.glGenTextures();
            BufferMultisample bufferMultisample = multisample;
            if (Intrinsics.areEqual(bufferMultisample, BufferMultisample.Disabled.INSTANCE)) {
                n = 3553;
            } else if (bufferMultisample instanceof BufferMultisample.SampleCount) {
                n = 37120;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int target2 = n;
            GL33C.glBindTexture(target2, glTexture);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            ByteBuffer nullBuffer = null;
            BufferMultisample bufferMultisample2 = multisample;
            if (Intrinsics.areEqual(bufferMultisample2, BufferMultisample.Disabled.INSTANCE)) {
                GL33C.glTexImage2D(3553, 0, DepthBufferGL3Kt.access$toGLFormat(format), width, height, 0, 6402, 5121, nullBuffer);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                GL33C.glTexParameteri(3553, 10241, 9728);
                GL33C.glTexParameteri(3553, 10240, 9728);
                GL33C.glTexParameteri(3553, 10242, 33071);
                GL33C.glTexParameteri(3553, 10243, 33071);
            } else if (bufferMultisample2 instanceof BufferMultisample.SampleCount) {
                GL33C.glTexImage2DMultisample(target2, RangesKt.coerceAtMost(((BufferMultisample.SampleCount)multisample).getSampleCount(), GL33C.glGetInteger(37135)), DepthBufferGL3Kt.access$toGLFormat(format), width, height, true);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            }
            return new DepthBufferGL3(glTexture, target2, width, height, format, multisample);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

