/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.LineCap;
import org.openrndr.draw.LineJoin;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionKt;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.Path$WhenMappings;
import org.openrndr.internal.PathPoint;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ,\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000b2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ.\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0014\u0010'\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/openrndr/internal/Path;", "", "()V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "contours", "", "", "Lorg/openrndr/internal/PathPoint;", "getContours", "()Ljava/util/List;", "convex", "getConvex", "setConvex", "nbevel", "", "getNbevel", "()I", "setNbevel", "(I)V", "calculateJoins", "", "points", "w", "", "lineJoin", "Lorg/openrndr/draw/LineJoin;", "miterLimit", "expandFill", "Lorg/openrndr/internal/Expansion;", "fringeWidth", "expandStroke", "weight", "lineCap", "Lorg/openrndr/draw/LineCap;", "prepare", "Companion", "openrndr-core"})
public final class Path {
    private boolean convex;
    private boolean closed;
    private int nbevel;
    @NotNull
    private final List<List<PathPoint>> contours;
    public static final Companion Companion = new Companion(null);

    public final boolean getConvex() {
        return this.convex;
    }

    public final void setConvex(boolean bl) {
        this.convex = bl;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    public final int getNbevel() {
        return this.nbevel;
    }

    public final void setNbevel(int n) {
        this.nbevel = n;
    }

    @NotNull
    public final List<List<PathPoint>> getContours() {
        return this.contours;
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateJoins(@NotNull List<PathPoint> points, double w, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull((Object)lineJoin, "lineJoin");
        this.nbevel = 0;
        double iw = w > 0.0 ? 1.0 / w : 0.0;
        int nleft = 0;
        PathPoint p0 = points.get(points.size() - 1);
        PathPoint p1 = points.get(0);
        int p1ptr = 0;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void j;
            double limit;
            double dlx0 = p0.getDy();
            double dly0 = -p0.getDx();
            double dlx1 = p1.getDy();
            double dly1 = -p1.getDx();
            p1.setDmx((dlx0 + dlx1) * 0.5);
            p1.setDmy((dly0 + dly1) * 0.5);
            double dmr2 = p1.getDmx() * p1.getDmx() + p1.getDmy() * p1.getDmy();
            if (dmr2 > (double)1.0E-6f) {
                double scale2 = 1.0 / dmr2;
                if (scale2 > 600.0) {
                    scale2 = 600.0;
                }
                PathPoint pathPoint = p1;
                pathPoint.setDmx(pathPoint.getDmx() * scale2);
                PathPoint pathPoint2 = p1;
                pathPoint2.setDmy(pathPoint2.getDmy() * scale2);
            }
            p1.setFlags((p1.getFlags() & PathPoint.Companion.getCORNER()) != 0 ? PathPoint.Companion.getCORNER() : 0);
            double cross = p1.getDx() * p0.getDy() - p0.getDx() * p1.getDy();
            if (cross > 0.0) {
                ++nleft;
                p1.setFlags(p1.getFlags() | PathPoint.Companion.getLEFT());
            }
            if (dmr2 * (limit = Math.max(1.01, Math.min(p0.getLength(), p1.getLength()) * iw)) * limit < (double)1.0f) {
                p1.setFlags(p1.getFlags() | PathPoint.Companion.getINNER_BEVEL());
            }
            if ((p1.getFlags() & PathPoint.Companion.getCORNER()) != 0 && (dmr2 * miterLimit * miterLimit < (double)1.0f || lineJoin == LineJoin.BEVEL || lineJoin == LineJoin.ROUND)) {
                p1.setFlags(p1.getFlags() | PathPoint.Companion.getBEVEL());
            }
            if ((p1.getFlags() & (PathPoint.Companion.getBEVEL() | PathPoint.Companion.getINNER_BEVEL())) != 0) {
                int n3 = this.nbevel;
                this.nbevel = n3 + 1;
            }
            p0 = p1;
            if (++p1ptr < points.size()) {
                p1 = points.get(p1ptr);
            }
            ++j;
        }
        this.convex = nleft == points.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void prepare(@NotNull List<PathPoint> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        PathPoint p0 = points.get(points.size() - 1);
        PathPoint p1 = points.get(0);
        int p1ptr = 0;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void i;
            p0.setDx(p1.getX() - p0.getX());
            p0.setDy(p1.getY() - p0.getY());
            p0.setLength(Math.sqrt(p0.getDx() * p0.getDx() + p0.getDy() * p0.getDy()));
            if (p0.getLength() > 0.0) {
                PathPoint pathPoint = p0;
                pathPoint.setDx(pathPoint.getDx() / p0.getLength());
                PathPoint pathPoint2 = p0;
                pathPoint2.setDy(pathPoint2.getDy() / p0.getLength());
            } else {
                p0.setDx(0.0);
                p0.setDy(0.0);
            }
            p0 = p1;
            if (++p1ptr < points.size()) {
                p1 = points.get(p1ptr);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Expansion expandStroke(double fringeWidth, double weight, @NotNull LineCap lineCap, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkParameterIsNotNull((Object)lineCap, "lineCap");
        Intrinsics.checkParameterIsNotNull((Object)lineJoin, "lineJoin");
        Collection collection = this.contours;
        if (!collection.isEmpty()) {
            double length;
            double dy;
            int p1ptr;
            List<PathPoint> points = this.contours.get(0);
            double tessTol = 0.1;
            int capSteps = ExpansionKt.curveDivs(weight, Math.PI, tessTol);
            this.prepare(points);
            this.calculateJoins(points, weight, lineJoin, miterLimit);
            int cverts = 0;
            cverts += lineJoin == LineJoin.ROUND ? (points.size() + this.nbevel * (capSteps + 2) + 1) * 2 : (points.size() + this.nbevel * 5 + 1) * 2;
            if (!this.closed) {
                cverts += lineCap == LineCap.ROUND ? (capSteps * 2 + 2) * 2 : 12;
            }
            Expansion expansion = new Expansion(ExpansionType.STROKE, new float[cverts * 5], 0);
            double offset2 = 0.0;
            double aa = fringeWidth;
            PathPoint p0 = this.closed ? points.get(points.size() - 1) : points.get(0);
            PathPoint p1 = this.closed ? points.get(0) : points.get(1);
            int start = this.closed ? 0 : 1;
            int end2 = this.closed ? points.size() : points.size() - 1;
            int n = p1ptr = this.closed ? 0 : 1;
            if (!this.closed) {
                double dx = p1.getX() - p0.getX();
                length = Math.sqrt(dx * dx + (dy = p1.getY() - p0.getY()) * dy);
                if (length > 0.0) {
                    dx /= length;
                    dy /= length;
                }
                switch (Path$WhenMappings.$EnumSwitchMapping$0[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapStart(p0, dx, dy, weight, -aa * 0.5, aa, offset2);
                        break;
                    }
                    case 2: {
                        expansion.buttCapStart(p0, dx, dy, weight, weight - aa, aa, offset2);
                        break;
                    }
                    case 3: {
                        expansion.roundCapStart(p0, dx, dy, weight, capSteps, aa, offset2);
                    }
                }
            }
            int dx = start;
            int n2 = end2;
            while (dx < n2) {
                void j;
                offset2 += p0.getLength();
                if ((p1.getFlags() & (PathPoint.Companion.getBEVEL() | PathPoint.Companion.getINNER_BEVEL())) != 0) {
                    if (lineJoin == LineJoin.ROUND) {
                        expansion.roundJoin(p0, p1, weight, weight, 0.0, 1.0, capSteps, aa, offset2);
                    } else {
                        expansion.bevelJoin(p0, p1, weight, weight, 0.0, 1.0, aa, offset2);
                    }
                } else {
                    expansion.addVertex(p1.getX() + p1.getDmx() * weight, p1.getY() + p1.getDmy() * weight, 0.0, 1.0, offset2);
                    expansion.addVertex(p1.getX() - p1.getDmx() * weight, p1.getY() - p1.getDmy() * weight, 1.0, 1.0, offset2);
                }
                p0 = p1;
                if (++p1ptr < points.size()) {
                    p1 = points.get(p1ptr);
                }
                ++j;
            }
            if (points.size() == 2) {
                double dx2 = p1.getX() - p0.getX();
                dy = p1.getY() - p0.getY();
                offset2 = length = Math.sqrt(dx2 * dx2 + dy * dy);
            }
            if (this.closed) {
                Vector2 v0 = expansion.vertex(0);
                Vector2 v1 = expansion.vertex(1);
                expansion.addVertex(v0.getX(), v0.getY(), 0.0, 1.0, offset2);
                expansion.addVertex(v1.getX(), v1.getY(), 1.0, 1.0, offset2);
            } else {
                double dx3 = p1.getX() - p0.getX();
                double l = Math.sqrt(dx3 * dx3 + (dy = p1.getY() - p0.getY()) * dy);
                if (l > 0.0) {
                    dx3 /= l;
                    dy /= l;
                }
                switch (Path$WhenMappings.$EnumSwitchMapping$1[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapEnd(p1, dx3, dy, weight, -aa * 0.5, aa, offset2);
                        break;
                    }
                    case 2: {
                        expansion.buttCapEnd(p1, dx3, dy, weight, weight - aa, aa, offset2);
                        break;
                    }
                    case 3: {
                        expansion.roundCapEnd(p1, dx3, dy, weight, capSteps, aa, offset2);
                    }
                }
            }
            return expansion;
        }
        return new Expansion(ExpansionType.SKIP, new float[0], 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Expansion> expandFill(double fringeWidth, double w, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkParameterIsNotNull((Object)lineJoin, "lineJoin");
        Collection collection = this.contours;
        if (!collection.isEmpty()) {
            List it;
            List result = new ArrayList();
            Iterable $receiver$iv = this.contours;
            for (Object element$iv : $receiver$iv) {
                it = (List)element$iv;
                this.prepare(it);
            }
            $receiver$iv = this.contours;
            for (Object element$iv : $receiver$iv) {
                it = (List)element$iv;
                this.calculateJoins(it, w, lineJoin, miterLimit);
            }
            if (this.contours.size() > 1) {
                this.convex = false;
            }
            double aa = fringeWidth;
            double woff = 0.5 * aa;
            boolean generateFringe = w > 0.0;
            double offset2 = 0.0;
            Iterable iterable = this.contours;
            for (Object element$iv : iterable) {
                List points = (List)element$iv;
                int size = 4;
                Iterable $receiver$iv3 = points;
                for (Object element$iv2 : $receiver$iv3) {
                    PathPoint point = (PathPoint)element$iv2;
                    size += (point.getFlags() & PathPoint.Companion.getBEVEL()) != 0 ? 12 : 4;
                }
                Expansion fill = new Expansion(ExpansionType.FILL, new float[size * 5], 0);
                if (generateFringe) {
                    PathPoint p0 = (PathPoint)points.get(points.size() - 1);
                    PathPoint p1 = (PathPoint)points.get(0);
                    int p1ptr = 0;
                    int $i$a$1$forEach = 0;
                    int $i$f$forEach = ((Collection)points).size();
                    while ($i$a$1$forEach < $i$f$forEach) {
                        void j;
                        if ((p1.getFlags() & PathPoint.Companion.getBEVEL()) != 0) {
                            if ((p1.getFlags() & PathPoint.Companion.getLEFT()) != 0) {
                                fill.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, offset2);
                            } else {
                                double dlx0 = p0.getDy();
                                double dly0 = -p0.getDx();
                                double dlx1 = p1.getDy();
                                double dly1 = -p1.getDx();
                                double lx0 = p1.getX() + dlx0 * woff;
                                double ly0 = p1.getY() + dly0 * woff;
                                double lx1 = p1.getX() + dlx1 * woff;
                                double ly1 = p1.getY() + dly1 * woff;
                                fill.addVertex(lx0, ly0, 0.5, 1.0, offset2);
                                fill.addVertex(lx1, ly1, 0.5, 1.0, offset2);
                            }
                        } else {
                            fill.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, offset2);
                        }
                        p0 = p1;
                        if (++p1ptr < points.size()) {
                            p1 = (PathPoint)points.get(p1ptr);
                        }
                        ++j;
                    }
                } else {
                    int p0 = 0;
                    int n = points.size();
                    while (p0 < n) {
                        void j;
                        fill.addVertex(((PathPoint)points.get((int)j)).getX(), ((PathPoint)points.get((int)j)).getY(), 0.5, 1.0, offset2);
                        ++j;
                    }
                }
                result.add(fill);
            }
            if (generateFringe) {
                for (List list : this.contours) {
                    int size = 2;
                    for (PathPoint point : list) {
                        if ((point.getFlags() & PathPoint.Companion.getBEVEL()) != 0) {
                            size += 12;
                            continue;
                        }
                        size += 4;
                    }
                    Expansion fringe = new Expansion(ExpansionType.FRINGE, new float[size * 5], 0);
                    double lw = w + woff;
                    double rw = w - woff;
                    double lu = 0.0;
                    double ru = 1.0;
                    if (this.convex) {
                        lw = woff;
                        lu = 0.5;
                    }
                    PathPoint p0 = (PathPoint)list.get(list.size() - 1);
                    PathPoint p1 = (PathPoint)list.get(0);
                    int p1ptr = 0;
                    int dlx1 = 0;
                    int n = ((Collection)list).size();
                    while (dlx1 < n) {
                        void j;
                        if ((p1.getFlags() & (PathPoint.Companion.getBEVEL() | PathPoint.Companion.getINNER_BEVEL())) != 0) {
                            fringe.bevelJoin(p0, p1, lw, rw, lu, ru, fringeWidth, offset2);
                        } else {
                            fringe.addVertex(p1.getX() + p1.getDmx() * lw, p1.getY() + p1.getDmy() * lw, lu, 1.0, offset2);
                            fringe.addVertex(p1.getX() - p1.getDmx() * rw, p1.getY() - p1.getDmy() * rw, ru, 1.0, offset2);
                        }
                        p0 = p1;
                        if (++p1ptr < list.size()) {
                            p1 = (PathPoint)list.get(p1ptr);
                        }
                        ++j;
                    }
                    Vector2 v0 = fringe.vertex(0);
                    Vector2 v1 = fringe.vertex(1);
                    fringe.addVertex(v0.getX(), v0.getY(), lu, 1.0, offset2);
                    fringe.addVertex(v1.getX(), v1.getY(), ru, 1.0, offset2);
                    result.add(fringe);
                }
            }
            return result;
        }
        return CollectionsKt.emptyList();
    }

    public Path() {
        List list;
        Path path = this;
        path.contours = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006\u00a8\u0006\f"}, d2={"Lorg/openrndr/internal/Path$Companion;", "", "()V", "fromLineStrip", "Lorg/openrndr/internal/Path;", "segments", "", "Lorg/openrndr/math/Vector2;", "closed", "", "fromLineStrips", "contours", "openrndr-core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineStrip(@NotNull Iterable<Vector2> segments, boolean closed) {
            void $receiver$iv$iv;
            Iterable<Vector2> $receiver$iv;
            Intrinsics.checkParameterIsNotNull(segments, "segments");
            Path sp = new Path();
            Iterable<Vector2> iterable = $receiver$iv = segments;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                PathPoint pathPoint;
                Vector2 vector2 = (Vector2)item$iv$iv;
                Collection collection = destination$iv$iv;
                PathPoint $receiver = pathPoint = new PathPoint();
                $receiver.setX(it.getX());
                $receiver.setY(it.getY());
                $receiver.setFlags(PathPoint.Companion.getCORNER());
                PathPoint pathPoint2 = pathPoint;
                collection.add(pathPoint2);
            }
            List path = (List)destination$iv$iv;
            Collection collection = path;
            if (!collection.isEmpty()) {
                if (!closed) {
                    ((PathPoint)path.get(0)).setFlags(0);
                    ((PathPoint)path.get(path.size() - 1)).setFlags(0);
                }
                sp.getContours().add(path);
            }
            sp.setClosed(closed);
            return sp;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineStrips(@NotNull Iterable<? extends Iterable<Vector2>> contours) {
            Intrinsics.checkParameterIsNotNull(contours, "contours");
            Path sp = new Path();
            Iterable<? extends Iterable<Vector2>> $receiver$iv = contours;
            Iterator<? extends Iterable<Vector2>> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                void $receiver$iv$iv;
                Iterable<Vector2> element$iv;
                Iterable<Vector2> contour2;
                Iterable<Vector2> $receiver$iv2;
                Iterable<Vector2> iterable = $receiver$iv2 = (contour2 = (element$iv = iterator2.next()));
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PathPoint pathPoint;
                    Vector2 vector2 = (Vector2)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    PathPoint $receiver = pathPoint = new PathPoint();
                    $receiver.setX(it.getX());
                    $receiver.setY(it.getY());
                    $receiver.setFlags(PathPoint.Companion.getCORNER());
                    PathPoint pathPoint2 = pathPoint;
                    collection.add(pathPoint2);
                }
                List path = (List)destination$iv$iv;
                sp.getContours().add(path);
            }
            sp.setClosed(true);
            return sp;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

