/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ImageDrawer;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J8\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/internal/ImageDrawer;", "", "()V", "instanceAttributes", "Lorg/openrndr/draw/VertexBuffer;", "instanceFormat", "Lorg/openrndr/draw/VertexFormat;", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "assertInstanceSize", "", "size", "", "drawImage", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "x", "", "y", "width", "height", "rectangles", "", "Lkotlin/Pair;", "Lorg/openrndr/shape/Rectangle;", "openrndr-core"})
public final class ImageDrawer {
    private final VertexBuffer vertices;
    private final VertexFormat instanceFormat;
    private VertexBuffer instanceAttributes;
    private final ShadeStyleManager shaderManager;

    private final void assertInstanceSize(int size) {
        if (this.instanceAttributes.getVertexCount() < size) {
            this.instanceAttributes.destroy();
            this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, size);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, @NotNull List<Pair<Rectangle, Rectangle>> rectangles) {
        Object object;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Intrinsics.checkParameterIsNotNull(rectangles, "rectangles");
        this.assertInstanceSize(rectangles.size());
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        BufferWriter iw = this.instanceAttributes.getShadow().writer();
        iw.rewind();
        Iterable $receiver$iv = rectangles;
        for (Object element$iv : $receiver$iv) {
            void source;
            Pair it;
            Pair pair = it = (Pair)element$iv;
            Rectangle rectangle = (Rectangle)pair.component1();
            Rectangle target2 = (Rectangle)pair.component2();
            iw.write(new Vector4(source.getCorner().getX() / (double)colorBuffer.getWidth(), source.getCorner().getY() / (double)colorBuffer.getHeight(), source.getWidth() / (double)colorBuffer.getWidth(), source.getHeight() / (double)colorBuffer.getHeight()));
            iw.write(new Vector4(target2.getCorner().getX(), target2.getCorner().getY(), target2.getWidth(), target2.getHeight()));
        }
        this.instanceAttributes.getShadow().uploadElements(0, rectangles.size());
        colorBuffer.bind(0);
        shader2.begin();
        drawContext.applyToShader(shader2);
        shader2.uniform("u_flipV", colorBuffer.getFlipV() ? 1 : 0);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(this.instanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, rectangles.size());
        shader2.end();
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, double x, double y, double width, double height) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.drawImage(drawContext, drawStyle, colorBuffer, CollectionsKt.listOf(TuplesKt.to(colorBuffer.getBounds(), new Rectangle(x, y, width, height))));
    }

    public ImageDrawer() {
        BufferWriter bufferWriter2;
        VertexFormat vertexFormat2 = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        ImageDrawer imageDrawer = this;
        VertexFormat $receiver = vertexFormat2;
        $receiver.position(3);
        $receiver.normal(3);
        VertexFormat.textureCoordinate$default($receiver, 2, 0, 2, null);
        VertexFormat vertexFormat3 = vertexFormat2;
        imageDrawer.vertices = companion.createDynamic(vertexFormat3, 6);
        this.instanceFormat = VertexFormatKt.vertexFormat(instanceFormat.1.INSTANCE);
        this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, 10);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageVertexShader";
            }

            public final String getSignature() {
                return "imageVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageFragmentShader";
            }

            public final String getSignature() {
                return "imageFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        Vector3 pa = new Vector3(0.0, 0.0, 0.0);
        Vector3 pb = new Vector3(1.0, 0.0, 0.0);
        Vector3 pc = new Vector3(1.0, 1.0, 0.0);
        Vector3 pd = new Vector3(0.0, 1.0, 0.0);
        double u0 = 0.0;
        double u1 = 1.0;
        double v0 = 1.0;
        double v1 = 0.0;
        Vector2 ta = new Vector2(u0, v1);
        Vector2 tb = new Vector2(u1, v1);
        Vector2 tc = new Vector2(u1, v0);
        Vector2 td = new Vector2(u0, v0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver2 = bufferWriter2 = w;
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        $receiver2.write(pd);
        $receiver2.write(n);
        $receiver2.write(td);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pb);
        $receiver2.write(n);
        $receiver2.write(tb);
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

