/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.PathPoint;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012JF\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J>\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J>\u0010<\u001a\u00020&2\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J&\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00109\u001a\u00020\u0012J>\u0010A\u001a\u00020&2\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J>\u0010C\u001a\u00020&2\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012JN\u0010D\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0007R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\r\u00a8\u0006H"}, d2={"Lorg/openrndr/internal/Expansion;", "", "type", "Lorg/openrndr/internal/ExpansionType;", "fb", "", "bufferStart", "", "(Lorg/openrndr/internal/ExpansionType;[FI)V", "bufferPosition", "getBufferPosition", "()I", "setBufferPosition", "(I)V", "getBufferStart", "getFb", "()[F", "maxx", "", "getMaxx", "()D", "setMaxx", "(D)V", "maxy", "getMaxy", "setMaxy", "minx", "getMinx", "setMinx", "miny", "getMiny", "setMiny", "getType", "()Lorg/openrndr/internal/ExpansionType;", "vertexCount", "getVertexCount", "setVertexCount", "addVertex", "", "x", "y", "u", "v", "offset", "bevelJoin", "p0", "Lorg/openrndr/internal/PathPoint;", "p1", "lw", "rw", "lu", "ru", "fringe", "buttCapEnd", "p", "dx", "dy", "w", "d", "aa", "buttCapStart", "chooseBevel", "", "bevel", "", "roundCapEnd", "ncap", "roundCapStart", "roundJoin", "vertex", "Lorg/openrndr/math/Vector2;", "idx", "openrndr-core"})
public final class Expansion {
    private int vertexCount;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private int bufferPosition;
    @NotNull
    private final ExpansionType type;
    @NotNull
    private final float[] fb;
    private final int bufferStart;

    public final int getVertexCount() {
        return this.vertexCount;
    }

    public final void setVertexCount(int n) {
        this.vertexCount = n;
    }

    public final double getMinx() {
        return this.minx;
    }

    public final void setMinx(double d) {
        this.minx = d;
    }

    public final double getMaxx() {
        return this.maxx;
    }

    public final void setMaxx(double d) {
        this.maxx = d;
    }

    public final double getMiny() {
        return this.miny;
    }

    public final void setMiny(double d) {
        this.miny = d;
    }

    public final double getMaxy() {
        return this.maxy;
    }

    public final void setMaxy(double d) {
        this.maxy = d;
    }

    public final int getBufferPosition() {
        return this.bufferPosition;
    }

    public final void setBufferPosition(int n) {
        this.bufferPosition = n;
    }

    @NotNull
    public final double[] chooseBevel(boolean bevel, @NotNull PathPoint p0, @NotNull PathPoint p1, double w) {
        double y1;
        double x1;
        double y0;
        double x0;
        Intrinsics.checkParameterIsNotNull(p0, "p0");
        Intrinsics.checkParameterIsNotNull(p1, "p1");
        if (bevel) {
            x0 = p1.getX() + p0.getDy() * w;
            y0 = p1.getY() - p0.getDx() * w;
            x1 = p1.getX() + p1.getDy() * w;
            y1 = p1.getY() - p1.getDx() * w;
        } else {
            x0 = p1.getX() + p1.getDmx() * w;
            y0 = p1.getY() + p1.getDmy() * w;
            x1 = p1.getX() + p1.getDmx() * w;
            y1 = p1.getY() + p1.getDmy() * w;
        }
        return new double[]{x0, y0, x1, y1};
    }

    public final void bevelJoin(@NotNull PathPoint p0, @NotNull PathPoint p1, double lw, double rw, double lu, double ru, double fringe, double offset2) {
        Intrinsics.checkParameterIsNotNull(p0, "p0");
        Intrinsics.checkParameterIsNotNull(p1, "p1");
        double dlx0 = p0.getDy();
        double dly0 = -p0.getDx();
        double dlx1 = p1.getDy();
        double dly1 = -p1.getDx();
        if ((p1.getFlags() & PathPoint.Companion.getLEFT()) != 0) {
            double[] r = this.chooseBevel((p1.getFlags() & PathPoint.Companion.getINNER_BEVEL()) != 0, p0, p1, lw);
            double lx0 = r[0];
            double ly0 = r[1];
            double lx1 = r[2];
            double ly1 = r[3];
            this.addVertex(lx0, ly0, lu, 1.0, offset2);
            this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset2);
            if ((p1.getFlags() & PathPoint.Companion.getBEVEL()) != 0) {
                this.addVertex(lx0, ly0, lu, 1.0, offset2);
                this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset2);
                this.addVertex(lx1, ly1, lu, 1.0, offset2);
                this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset2);
            } else {
                double rx0 = p1.getX() - p1.getDmx() * rw;
                double ry0 = p1.getY() - p1.getDmy() * rw;
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
                this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset2);
                this.addVertex(rx0, ry0, ru, 1.0, offset2);
                this.addVertex(rx0, ry0, ru, 1.0, offset2);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
                this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset2);
            }
            this.addVertex(lx1, ly1, lu, 1.0, offset2);
            this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset2);
        } else {
            double[] r = this.chooseBevel((p1.getFlags() & PathPoint.Companion.getINNER_BEVEL()) != 0, p0, p1, -rw);
            double rx0 = r[0];
            double ry0 = r[1];
            double rx1 = r[2];
            double ry1 = r[3];
            this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset2);
            this.addVertex(rx0, ry0, ru, 1.0, offset2);
            if ((p1.getFlags() & PathPoint.Companion.getBEVEL()) != 0) {
                this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset2);
                this.addVertex(rx0, ry0, ru, 1.0, offset2);
                this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset2);
                this.addVertex(rx1, ry1, ru, 1.0, offset2);
            } else {
                double lx0 = p1.getX() + p1.getDmx() * lw;
                double ly0 = p1.getY() + p1.getDmy() * lw;
                this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset2);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
                this.addVertex(lx0, ly0, lu, 1.0, offset2);
                this.addVertex(lx0, ly0, lu, 1.0, offset2);
                this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset2);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
            }
            this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset2);
            this.addVertex(rx1, ry1, ru, 1.0, offset2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void roundJoin(@NotNull PathPoint p0, @NotNull PathPoint p1, double lw, double rw, double lu, double ru, int ncap, double fringe, double offset2) {
        Intrinsics.checkParameterIsNotNull(p0, "p0");
        Intrinsics.checkParameterIsNotNull(p1, "p1");
        double dlx0 = p0.getDy();
        double dly0 = -p0.getDx();
        double dlx1 = p1.getDy();
        double dly1 = -p1.getDx();
        if ((p1.getFlags() & PathPoint.Companion.getLEFT()) != 0) {
            double[] r = this.chooseBevel((p1.getFlags() & PathPoint.Companion.getINNER_BEVEL()) != 0, p0, p1, lw);
            double lx0 = r[0];
            double ly0 = r[1];
            double lx1 = r[2];
            double ly1 = r[3];
            double a0 = Math.atan2(-dly0, -dlx0);
            double a1 = Math.atan2(-dly1, -dlx1);
            if (a1 > a0) {
                a0 += Math.PI * 2;
            }
            if (a0 < 0.0 || a1 < 0.0) {
                a0 += Math.PI * 2;
                a1 += Math.PI * 2;
            }
            this.addVertex(lx0, ly0, lu, 1.0, offset2);
            this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset2);
            int n = RangesKt.coerceIn(ncap, (int)Math.ceil((a0 - a1) / Math.PI * (double)ncap), 2);
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void i;
                double u = (double)i / ((double)n - 1.0);
                double a2 = a0 + u * (a1 - a0);
                double rx = p1.getX() + Math.cos(a2) * rw;
                double ry = p1.getY() + Math.sin(a2) * rw;
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
                this.addVertex(rx, ry, ru, 1.0, offset2);
                ++i;
            }
            this.addVertex(lx1, ly1, lu, 1.0, offset2);
            this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset2);
        } else {
            double[] r = this.chooseBevel((p1.getFlags() & PathPoint.Companion.getINNER_BEVEL()) != 0, p0, p1, -rw);
            double rx0 = r[0];
            double ry0 = r[1];
            double rx1 = r[2];
            double ry1 = r[3];
            double a0 = Math.atan2(dly0, dlx0);
            double a1 = Math.atan2(dly1, dlx1);
            if (a1 < a0) {
                a1 += Math.PI * 2;
            }
            this.addVertex(p1.getX() + dlx0 * rw, p1.getY() + dly0 * rw, lu, 1.0, offset2);
            this.addVertex(rx0, ry0, ru, 1.0, offset2);
            int n = RangesKt.coerceIn(ncap, (int)Math.ceil((a1 - a0) / Math.PI * (double)ncap), 2);
            int n4 = n;
            for (int i = 0; i < n4; ++i) {
                double a3 = a0 + (double)i / ((double)n - 1.0) * (a1 - a0);
                this.addVertex(p1.getX() + Math.cos(a3) * lw, p1.getY() + Math.sin(a3) * lw, lu, 1.0, offset2);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset2);
            }
            this.addVertex(p1.getX() + dlx1 * rw, p1.getY() + dly1 * rw, lu, 1.0, offset2);
            this.addVertex(rx1, ry1, ru, 1.0, offset2);
        }
    }

    public final void buttCapStart(@NotNull PathPoint p, double dx, double dy, double w, double d, double aa, double offset2) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        double px = p.getX() - dx * d;
        double py = p.getY() - dy * d;
        double dly = -dx;
        this.addVertex(px + dy * w - dx * aa, py + dly * w - dy * aa, 0.0, 0.0, offset2);
        this.addVertex(px - dy * w - dx * aa, py - dly * w - dy * aa, 1.0, 0.0, offset2);
        this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset2);
        this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset2);
    }

    public final void buttCapEnd(@NotNull PathPoint p, double dx, double dy, double w, double d, double aa, double offset2) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        double px = p.getX() - dx * d;
        double py = p.getY() - dy * d;
        double dly = -dx;
        this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset2);
        this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset2);
        this.addVertex(px + dy * w + dx * aa, py + dly * w + dy * aa, 0.0, 0.0, offset2);
        this.addVertex(px - dy * w + dx * aa, py - dly * w + dy * aa, 1.0, 0.0, offset2);
    }

    /*
     * WARNING - void declaration
     */
    public final void roundCapStart(@NotNull PathPoint p, double dx, double dy, double w, int ncap, double aa, double offset2) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        double px = p.getX();
        double py = p.getY();
        double dly = -dx;
        int n = 0;
        int n2 = ncap;
        while (n < n2) {
            void i;
            double a2 = (double)i / ((double)ncap - 1.0) * Math.PI;
            double ax = Math.cos(a2) * w;
            double ay = Math.sin(a2) * w;
            this.addVertex(px - dy * ax - dx * ay, py - dly * ax - dy * ay, 0.0, 1.0, offset2);
            this.addVertex(px, py, 0.5, 1.0, offset2);
            ++i;
        }
        this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset2);
        this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset2);
    }

    /*
     * WARNING - void declaration
     */
    public final void roundCapEnd(@NotNull PathPoint p, double dx, double dy, double w, int ncap, double aa, double offset2) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        double px = p.getX();
        double py = p.getY();
        double dly = -dx;
        this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset2);
        this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset2);
        int n = 0;
        int n2 = ncap;
        while (n < n2) {
            void i;
            double a2 = (double)i / (double)(ncap - 1) * Math.PI;
            double ax = Math.cos(a2) * w;
            double ay = Math.sin(a2) * w;
            this.addVertex(px, py, 0.5, 1.0, offset2);
            this.addVertex(px - dy * ax + dx * ay, py - dly * ax + dy * ay, 0.0, 1.0, offset2);
            ++i;
        }
    }

    @NotNull
    public final Vector2 vertex(int idx) {
        return new Vector2(this.fb[this.bufferStart + idx * 5], this.fb[this.bufferStart + idx * 5 + 1]);
    }

    public final void addVertex(double x, double y, double u, double v, double offset2) {
        if (x != x) {
            throw (Throwable)new RuntimeException("" + x + ' ' + y + ' ' + u + ' ' + v);
        }
        this.minx = Math.min(this.minx, x);
        this.maxx = Math.max(this.maxx, x);
        this.miny = Math.min(this.miny, y);
        this.maxy = Math.max(this.maxy, y);
        int n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)x;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)y;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)u;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)v;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)offset2;
        n = this.vertexCount;
        this.vertexCount = n + 1;
    }

    @NotNull
    public final ExpansionType getType() {
        return this.type;
    }

    @NotNull
    public final float[] getFb() {
        return this.fb;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public Expansion(@NotNull ExpansionType type, @NotNull float[] fb, int bufferStart) {
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        Intrinsics.checkParameterIsNotNull(fb, "fb");
        this.type = type;
        this.fb = fb;
        this.bufferStart = bufferStart;
        this.minx = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        this.maxx = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        this.miny = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        this.maxy = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        this.bufferPosition = this.bufferStart;
    }
}

