/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.meshgenerators;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/openrndr/extras/meshgenerators/GeneratorBuffer;", "", "()V", "data", "", "Lorg/openrndr/extras/meshgenerators/GeneratorBuffer$VertexData;", "getData", "()Ljava/util/List;", "setData", "(Ljava/util/List;)V", "concat", "", "other", "toByteBuffer", "Ljava/nio/ByteBuffer;", "transform", "m", "Lorg/openrndr/math/Matrix44;", "write", "position", "Lorg/openrndr/math/Vector3;", "normal", "texCoord", "Lorg/openrndr/math/Vector2;", "VertexData", "orx-mesh-generators"})
public final class GeneratorBuffer {
    @NotNull
    private List<VertexData> data;

    @NotNull
    public final List<VertexData> getData() {
        return this.data;
    }

    public final void setData(@NotNull List<VertexData> list) {
        Intrinsics.checkParameterIsNotNull(list, "<set-?>");
        this.data = list;
    }

    public final void write(@NotNull Vector3 position, @NotNull Vector3 normal, @NotNull Vector2 texCoord) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(normal, "normal");
        Intrinsics.checkParameterIsNotNull(texCoord, "texCoord");
        this.data.add(new VertexData(position, normal, texCoord));
    }

    public final void concat(@NotNull GeneratorBuffer other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.data.addAll((Collection<VertexData>)other.data);
    }

    /*
     * WARNING - void declaration
     */
    public final void transform(@NotNull Matrix44 m2) {
        Collection<VertexData> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(m2, "m");
        Iterable iterable = this.data;
        GeneratorBuffer generatorBuffer = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            VertexData vertexData = (VertexData)item$iv$iv;
            collection = destination$iv$iv;
            VertexData vertexData2 = new VertexData(m2.times(it.getPosition().getXyz1()).getXyz(), m2.times(it.getNormal().getXyz0()).getXyz(), it.getTexCoord());
            collection.add(vertexData2);
        }
        collection = (List)destination$iv$iv;
        generatorBuffer.data = CollectionsKt.toMutableList((Collection)collection);
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.data.size() * 32);
        bb.order(ByteOrder.nativeOrder());
        bb.rewind();
        for (VertexData d : this.data) {
            bb.putFloat((float)d.getPosition().getX());
            bb.putFloat((float)d.getPosition().getY());
            bb.putFloat((float)d.getPosition().getZ());
            bb.putFloat((float)d.getNormal().getX());
            bb.putFloat((float)d.getNormal().getY());
            bb.putFloat((float)d.getNormal().getZ());
            bb.putFloat((float)d.getTexCoord().getX());
            bb.putFloat((float)d.getTexCoord().getY());
        }
        ByteBuffer byteBuffer = bb;
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "bb");
        return byteBuffer;
    }

    public GeneratorBuffer() {
        List list;
        GeneratorBuffer generatorBuffer = this;
        generatorBuffer.data = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/extras/meshgenerators/GeneratorBuffer$VertexData;", "", "position", "Lorg/openrndr/math/Vector3;", "normal", "texCoord", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;)V", "getNormal", "()Lorg/openrndr/math/Vector3;", "getPosition", "getTexCoord", "()Lorg/openrndr/math/Vector2;", "orx-mesh-generators"})
    public static final class VertexData {
        @NotNull
        private final Vector3 position;
        @NotNull
        private final Vector3 normal;
        @NotNull
        private final Vector2 texCoord;

        @NotNull
        public final Vector3 getPosition() {
            return this.position;
        }

        @NotNull
        public final Vector3 getNormal() {
            return this.normal;
        }

        @NotNull
        public final Vector2 getTexCoord() {
            return this.texCoord;
        }

        public VertexData(@NotNull Vector3 position, @NotNull Vector3 normal, @NotNull Vector2 texCoord) {
            Intrinsics.checkParameterIsNotNull(position, "position");
            Intrinsics.checkParameterIsNotNull(normal, "normal");
            Intrinsics.checkParameterIsNotNull(texCoord, "texCoord");
            this.position = position;
            this.normal = normal;
            this.texCoord = texCoord;
        }
    }
}

