/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.ValueNoise3DKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0014\b\u0006\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\bH\u0086\b\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a&\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"value", "", "seed", "", "x", "y", "z", "interpolation", "Lkotlin/Function1;", "valueHermite", "valueLinear", "valueQuintic", "orx-noise"})
public final class ValueNoise3DKt {
    public static final double valueLinear(int seed, double x, double y, double z) {
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int z0$iv = MathUtilsKt.fastFloor(z);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        int z1$iv = z0$iv + 1;
        double p1 = x - (double)x0$iv;
        double xs$iv = InterpolationKt.linear(p1);
        double p12 = y - (double)y0$iv;
        double ys$iv = InterpolationKt.linear(p12);
        double p13 = z - (double)z0$iv;
        double zs$iv = InterpolationKt.linear(p13);
        double xf00$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z0$iv), xs$iv);
        double xf10$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z0$iv), xs$iv);
        double xf01$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z1$iv), xs$iv);
        double xf11$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z1$iv), xs$iv);
        double yf0$iv = InterpolationKt.lerp(xf00$iv, xf10$iv, ys$iv);
        double yf1$iv = InterpolationKt.lerp(xf01$iv, xf11$iv, ys$iv);
        return InterpolationKt.lerp(yf0$iv, yf1$iv, zs$iv);
    }

    public static final double valueQuintic(int seed, double x, double y, double z) {
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int z0$iv = MathUtilsKt.fastFloor(z);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        int z1$iv = z0$iv + 1;
        double p1 = x - (double)x0$iv;
        double xs$iv = InterpolationKt.quintic(p1);
        double p12 = y - (double)y0$iv;
        double ys$iv = InterpolationKt.quintic(p12);
        double p13 = z - (double)z0$iv;
        double zs$iv = InterpolationKt.quintic(p13);
        double xf00$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z0$iv), xs$iv);
        double xf10$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z0$iv), xs$iv);
        double xf01$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z1$iv), xs$iv);
        double xf11$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z1$iv), xs$iv);
        double yf0$iv = InterpolationKt.lerp(xf00$iv, xf10$iv, ys$iv);
        double yf1$iv = InterpolationKt.lerp(xf01$iv, xf11$iv, ys$iv);
        return InterpolationKt.lerp(yf0$iv, yf1$iv, zs$iv);
    }

    public static final double valueHermite(int seed, double x, double y, double z) {
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int z0$iv = MathUtilsKt.fastFloor(z);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        int z1$iv = z0$iv + 1;
        double p1 = x - (double)x0$iv;
        double xs$iv = InterpolationKt.hermite(p1);
        double p12 = y - (double)y0$iv;
        double ys$iv = InterpolationKt.hermite(p12);
        double p13 = z - (double)z0$iv;
        double zs$iv = InterpolationKt.hermite(p13);
        double xf00$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z0$iv), xs$iv);
        double xf10$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z0$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z0$iv), xs$iv);
        double xf01$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y0$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y0$iv, z1$iv), xs$iv);
        double xf11$iv = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0$iv, y1$iv, z1$iv), GradCoordKt.valCoord3D(seed, x1$iv, y1$iv, z1$iv), xs$iv);
        double yf0$iv = InterpolationKt.lerp(xf00$iv, xf10$iv, ys$iv);
        double yf1$iv = InterpolationKt.lerp(xf01$iv, xf11$iv, ys$iv);
        return InterpolationKt.lerp(yf0$iv, yf1$iv, zs$iv);
    }

    public static final double value(int seed, double x, double y, double z, @NotNull Function1<? super Double, Double> interpolation) {
        Intrinsics.checkParameterIsNotNull(interpolation, "interpolation");
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int z0 = MathUtilsKt.fastFloor(z);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        double xs = ((Number)interpolation.invoke((Double)(x - (double)x0))).doubleValue();
        double ys = ((Number)interpolation.invoke((Double)(y - (double)y0))).doubleValue();
        double zs = ((Number)interpolation.invoke((Double)(z - (double)z0))).doubleValue();
        double xf00 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y0, z0), GradCoordKt.valCoord3D(seed, x1, y0, z0), xs);
        double xf10 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y1, z0), GradCoordKt.valCoord3D(seed, x1, y1, z0), xs);
        double xf01 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y0, z1), GradCoordKt.valCoord3D(seed, x1, y0, z1), xs);
        double xf11 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y1, z1), GradCoordKt.valCoord3D(seed, x1, y1, z1), xs);
        double yf0 = InterpolationKt.lerp(xf00, xf10, ys);
        double yf1 = InterpolationKt.lerp(xf01, xf11, ys);
        return InterpolationKt.lerp(yf0, yf1, zs);
    }

    public static /* synthetic */ double value$default(int seed, double x, double y, double z, Function1 interpolation, int n, Object object) {
        if ((n & 0x10) != 0) {
            interpolation = value.1.INSTANCE;
        }
        Intrinsics.checkParameterIsNotNull(interpolation, "interpolation");
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int z0 = MathUtilsKt.fastFloor(z);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        double xs = ((Number)interpolation.invoke(x - (double)x0)).doubleValue();
        double ys = ((Number)interpolation.invoke(y - (double)y0)).doubleValue();
        double zs = ((Number)interpolation.invoke(z - (double)z0)).doubleValue();
        double xf00 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y0, z0), GradCoordKt.valCoord3D(seed, x1, y0, z0), xs);
        double xf10 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y1, z0), GradCoordKt.valCoord3D(seed, x1, y1, z0), xs);
        double xf01 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y0, z1), GradCoordKt.valCoord3D(seed, x1, y0, z1), xs);
        double xf11 = InterpolationKt.lerp(GradCoordKt.valCoord3D(seed, x0, y1, z1), GradCoordKt.valCoord3D(seed, x1, y1, z1), xs);
        double yf0 = InterpolationKt.lerp(xf00, xf10, ys);
        double yf1 = InterpolationKt.lerp(xf01, xf11, ys);
        return InterpolationKt.lerp(yf0, yf1, zs);
    }
}

