/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jouvieje.bass.utils.MiscJNI;

public class Pointer {
    protected long pointer;

    public Pointer() {
        this.pointer = 0L;
    }

    protected Pointer(long pointer) {
        this.pointer = pointer;
    }

    public String asString() {
        long address = this.pointer;
        return address == 0L ? null : MiscJNI.Pointer_toString(address);
    }

    public String asString(int offset2, int length) {
        long tempAddress = this.pointer;
        if (tempAddress == 0L) {
            return null;
        }
        long address = tempAddress + (long)offset2;
        String s2 = MiscJNI.Pointer_toString(address);
        if (s2 != null && s2.length() > length) {
            return s2.substring(0, length);
        }
        return s2;
    }

    public ByteBuffer asByteBuffer(int offsetInBytes, int capacityInBytes) {
        ByteBuffer result = MiscJNI.newDirectByteBuffer(this.pointer + (long)offsetInBytes, capacityInBytes);
        if (result != null) {
            result.order(ByteOrder.nativeOrder());
        }
        return result;
    }

    public int asInt() {
        if (this.pointer != 0L) {
            return MiscJNI.asInt(this.pointer);
        }
        return 0;
    }

    public long asLong() {
        return this.pointer;
    }

    public float asFloat() {
        if (this.pointer != 0L) {
            return MiscJNI.asFloat(this.pointer);
        }
        return 0.0f;
    }

    public double asDouble() {
        if (this.pointer != 0L) {
            return MiscJNI.asDouble(this.pointer);
        }
        return 0.0;
    }

    public Pointer asPointer(long offset2) {
        return new Pointer(this.pointer + offset2);
    }

    public boolean equals(Object object) {
        if (object instanceof Pointer) {
            return this.pointer == Pointer.getPointer((Pointer)object);
        }
        return false;
    }

    public boolean isNull() {
        return this.pointer == 0L;
    }

    public void shareMemory(Pointer source) {
        this.pointer = Pointer.getPointer(source);
    }

    protected static long getPointer(Pointer pointer) {
        if (pointer != null) {
            return pointer.pointer;
        }
        return 0L;
    }

    protected static Pointer newPointer(long address) {
        return new Pointer(address);
    }
}

