/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.nodes;

import io.lacuna.bifurcan.utils.Bits;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Util {
    private static final PrimitiveIterator.OfInt EMPTY_INT = new PrimitiveIterator.OfInt(){

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };
    static final Object DEFAULT_VALUE = new Object();
    static final int NONE_NONE = 0;
    static final int NODE_NONE = 1;
    static final int ENTRY_NONE = 2;
    static final int NONE_NODE = 4;
    static final int NONE_ENTRY = 8;
    static final int ENTRY_NODE = 6;
    static final int NODE_ENTRY = 9;
    static final int ENTRY_ENTRY = 10;
    static final int NODE_NODE = 5;

    static int mergeState(int mask, int nodeA, int dataA, int nodeB, int dataB) {
        int state = 0;
        state |= (mask & nodeA) != 0 ? 1 : 0;
        state |= (mask & dataA) != 0 ? 2 : 0;
        state |= (mask & nodeB) != 0 ? 4 : 0;
        return state |= (mask & dataB) != 0 ? 8 : 0;
    }

    static int compressedIndex(int bitmap, int hashMask) {
        return Integer.bitCount(bitmap & hashMask - 1);
    }

    public static int startIndex(int bitmap) {
        return Bits.bitOffset(Bits.lowestBit((long)bitmap & 0xFFFFFFFFL));
    }

    public static int endIndex(int bitmap) {
        return Bits.bitOffset(Bits.highestBit((long)bitmap & 0xFFFFFFFFL));
    }

    static PrimitiveIterator.OfInt masks(final int bitmap) {
        return new PrimitiveIterator.OfInt(){
            int b;
            {
                this.b = bitmap;
            }

            @Override
            public int nextInt() {
                int result = Bits.lowestBit(this.b);
                this.b &= ~result;
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.b != 0;
            }
        };
    }

    static PrimitiveIterator.OfInt reverseMasks(final int bitmap) {
        return new PrimitiveIterator.OfInt(){
            int b;
            {
                this.b = bitmap;
            }

            @Override
            public int nextInt() {
                int result = Bits.highestBit(this.b);
                this.b &= ~result;
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.b != 0;
            }
        };
    }
}

