/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IntMap;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.utils.Iterators;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.IntStream;

public class Lists {
    public static final IList EMPTY = new IList(){

        public Object nth(long idx) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public long size() {
            return 0L;
        }

        public IList set(long idx, Object value2) {
            if (idx == 0L) {
                return this.addLast(value2);
            }
            throw new IndexOutOfBoundsException();
        }

        public IList addLast(Object value2) {
            return new List().addLast(value2);
        }

        public IList addFirst(Object value2) {
            return new List().addFirst(value2);
        }

        public IList removeLast() {
            return this;
        }

        public IList removeFirst() {
            return this;
        }

        @Override
        public IList forked() {
            return this;
        }

        @Override
        public IList linear() {
            return new List().linear();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IList) {
                return ((IList)obj).size() == 0L;
            }
            return false;
        }

        public IList clone() {
            return this;
        }

        public String toString() {
            return Lists.toString(this);
        }
    };

    public static <V, U> IList<U> lazyMap(IList<V> l, Function<V, U> f) {
        return Lists.from(l.size(), i -> f.apply(l.nth(i)));
    }

    public static <V> boolean equals(IList<V> a2, IList<V> b) {
        return Lists.equals(a2, b, Objects::equals);
    }

    public static <V> boolean equals(IList<V> a2, IList<V> b, BiPredicate<V, V> equals) {
        if (a2 == b) {
            return true;
        }
        if (a2.size() != b.size()) {
            return false;
        }
        return Iterators.equals(a2.iterator(), b.iterator(), equals);
    }

    public static <V> long hash(IList<V> l) {
        return Lists.hash(l, Objects::hashCode, (a2, b) -> a2 * 31L + b);
    }

    public static <V> long hash(IList<V> l, ToLongFunction<V> hash, LongBinaryOperator combiner) {
        return l.stream().mapToLong(hash).reduce(combiner).orElse(0L);
    }

    public static <V> String toString(IList<V> l) {
        return Lists.toString(l, Objects::toString);
    }

    public static <V> String toString(IList<V> l, Function<V, String> printer) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<V> it = l.iterator();
        while (it.hasNext()) {
            sb.append(printer.apply(it.next()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static <V> java.util.List<V> toList(IList<V> list) {
        return new JavaList<V>(list);
    }

    public static <V> IList<V> slice(IList<V> list, long start, long end2) {
        Slice<V> result;
        long size = end2 - start;
        if (size == 0L) {
            result = EMPTY;
        } else {
            if (start < 0L || end2 > list.size()) {
                throw new IllegalArgumentException();
            }
            result = new Slice<V>(list, start, size);
        }
        return list.isLinear() ? result.linear() : result;
    }

    public static <V> IList<V> from(V[] array) {
        return Lists.from(array.length, idx -> array[(int)idx]);
    }

    public static <V> IList<V> from(java.util.List<V> list) {
        return Lists.from(list.size(), idx -> list.get((int)idx), list::iterator);
    }

    public static <V> IList<V> from(final long size, final LongFunction<V> elementFn) {
        return new IList<V>(){

            public int hashCode() {
                return (int)Lists.hash(this);
            }

            public boolean equals(Object obj) {
                if (obj instanceof IList) {
                    return Lists.equals(this, (IList)obj);
                }
                return false;
            }

            public String toString() {
                return Lists.toString(this);
            }

            @Override
            public V nth(long idx) {
                if (idx < 0L || size <= idx) {
                    throw new IndexOutOfBoundsException(idx + " must be within [0," + size + ")");
                }
                return elementFn.apply(idx);
            }

            @Override
            public IList<V> clone() {
                return this;
            }

            @Override
            public long size() {
                return size;
            }
        };
    }

    public static <V> IList<V> from(final long size, final LongFunction<V> elementFn, final Supplier<Iterator<V>> iteratorFn) {
        return new IList<V>(){

            public int hashCode() {
                return (int)Lists.hash(this);
            }

            public boolean equals(Object obj) {
                if (obj instanceof IList) {
                    return Lists.equals(this, (IList)obj);
                }
                return false;
            }

            public String toString() {
                return Lists.toString(this);
            }

            @Override
            public V nth(long idx) {
                if (idx < 0L || size <= idx) {
                    throw new IndexOutOfBoundsException(idx + " must be within [0," + size + ")");
                }
                return elementFn.apply(idx);
            }

            @Override
            public Iterator<V> iterator() {
                return (Iterator)iteratorFn.get();
            }

            @Override
            public IList<V> clone() {
                return this;
            }

            @Override
            public long size() {
                return size;
            }
        };
    }

    public static <V> Collector<V, LinearList<V>, LinearList<V>> linearCollector() {
        return Lists.linearCollector(8);
    }

    public static <V> Collector<V, LinearList<V>, LinearList<V>> linearCollector(final int capacity) {
        return new Collector<V, LinearList<V>, LinearList<V>>(){

            @Override
            public Supplier<LinearList<V>> supplier() {
                return () -> new LinearList(capacity);
            }

            @Override
            public BiConsumer<LinearList<V>, V> accumulator() {
                return LinearList::addLast;
            }

            @Override
            public BinaryOperator<LinearList<V>> combiner() {
                return LinearList::linearConcat;
            }

            @Override
            public Function<LinearList<V>, LinearList<V>> finisher() {
                return x -> x;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }

    public static <V> Collector<V, List<V>, List<V>> collector() {
        return new Collector<V, List<V>, List<V>>(){

            @Override
            public Supplier<List<V>> supplier() {
                return () -> new List().linear();
            }

            @Override
            public BiConsumer<List<V>, V> accumulator() {
                return List::addLast;
            }

            @Override
            public BinaryOperator<List<V>> combiner() {
                return (a2, b) -> (List)a2.concat(b);
            }

            @Override
            public Function<List<V>, List<V>> finisher() {
                return List::forked;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.noneOf(Collector.Characteristics.class);
            }
        };
    }

    public static <V> Iterator<V> iterator(IList<V> list) {
        return Iterators.range(list.size(), list::nth);
    }

    public static <V> IList<V> concat(IList<V> a2, IList<V> b) {
        Object result = a2.size() == 0L ? b.forked() : (b.size() == 0L ? a2.forked() : (a2 instanceof Concat && b instanceof Concat ? ((Concat)a2).concat((Concat)b) : (a2 instanceof Concat ? ((Concat)a2).concat(new Concat<V>(b)) : (b instanceof Concat ? new Concat<V>(a2).concat((Concat)b) : new Concat<V>(a2, b)))));
        return a2.isLinear() ? result.linear() : result;
    }

    public static <V> IList<V> reverse(IList<V> l) {
        return Lists.from(l.size(), i -> l.nth(l.size() - (i + 1L)));
    }

    public static <V> IList<V> sort(IList<V> l, Comparator<V> comparator) {
        Object[] array = l.toArray();
        Arrays.sort(array, (a2, b) -> comparator.compare(a2, b));
        return Lists.from(array);
    }

    public static <V> IList<V> concat(IList<V> ... lists) {
        return Arrays.stream(lists).reduce(Lists::concat).orElseGet(List::new);
    }

    static class VirtualList<V>
    implements IList<V> {
        private IList<V> prefix;
        private IList<V> base;
        private IList<V> suffix;
        private final boolean linear;

        public VirtualList(IList<V> base2) {
            this(EMPTY, base2, EMPTY, false);
        }

        private VirtualList(IList<V> prefix, IList<V> base2, IList<V> suffix, boolean linear) {
            this.prefix = prefix;
            this.base = base2;
            this.suffix = suffix;
            this.linear = linear;
        }

        @Override
        public V nth(long idx) {
            long prefixSize = this.prefix.size();
            long listSize = this.base.size();
            if (idx < prefixSize) {
                return this.prefix.nth(idx);
            }
            if (idx < prefixSize + listSize) {
                return this.base.nth(idx - prefixSize);
            }
            return this.suffix.nth(idx - (prefixSize + listSize));
        }

        @Override
        public Iterator<V> iterator() {
            if (this.prefix == EMPTY && this.suffix == EMPTY) {
                return this.base.iterator();
            }
            return Lists.iterator(this);
        }

        @Override
        public long size() {
            return this.prefix.size() + this.base.size() + this.suffix.size();
        }

        @Override
        public IList<V> addLast(V value2) {
            IList<V> suffixPrime = this.suffix.addLast(value2);
            return this.linear ? this : new VirtualList<V>(this.prefix, this.base, suffixPrime, false);
        }

        @Override
        public IList<V> addFirst(V value2) {
            IList<V> prefixPrime = this.prefix.addFirst(value2);
            return this.linear ? this : new VirtualList<V>(prefixPrime, this.base, this.suffix, false);
        }

        @Override
        public IList<V> removeLast() {
            if (this.suffix.size() > 0L) {
                IList<V> suffixPrime = this.suffix.removeLast();
                return this.linear ? this : new VirtualList<V>(this.prefix, this.base, suffixPrime, false);
            }
            if (this.base.size() > 0L) {
                IList<V> basePrime = this.base.slice(0L, this.base.size() - 1L);
                if (this.linear) {
                    this.base = basePrime;
                    return this;
                }
                return new VirtualList<V>(this.prefix, basePrime, this.suffix, false);
            }
            IList<V> prefixPrime = this.prefix.removeLast();
            return this.linear ? this : new VirtualList<V>(prefixPrime, this.base, this.suffix, false);
        }

        @Override
        public IList<V> removeFirst() {
            if (this.prefix.size() > 0L) {
                IList<V> prefixPrime = this.prefix.removeFirst();
                return this.linear ? this : new VirtualList<V>(prefixPrime, this.base, this.suffix, false);
            }
            if (this.base.size() > 0L) {
                IList<V> basePrime = this.base.slice(1L, this.base.size());
                if (this.linear) {
                    this.base = basePrime;
                    return this;
                }
                return new VirtualList<V>(this.prefix, basePrime, this.suffix, false);
            }
            IList<V> suffixPrime = this.suffix.removeFirst();
            return this.linear ? this : new VirtualList<V>(this.prefix, this.base, suffixPrime, false);
        }

        @Override
        public IList<V> set(long idx, V value2) {
            long prefixSize = this.prefix.size();
            long baseSize = this.base.size();
            if (idx < 0L || idx > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (idx == this.size()) {
                return this.addLast(value2);
            }
            if (idx < prefixSize) {
                IList<V> prefixPrime = this.prefix.set(idx, value2);
                return this.linear ? this : new VirtualList<V>(prefixPrime, this.base, this.suffix, false);
            }
            if (idx < prefixSize + baseSize) {
                IList basePrime = Lists.concat(this.base.slice(0L, idx -= prefixSize), new LinearList(1).addLast((Object)value2), this.base.slice(idx + 1L, this.base.size()));
                return new VirtualList<V>(this.prefix, basePrime, this.suffix, this.linear);
            }
            IList<V> suffixPrime = this.suffix.set(idx -= prefixSize + baseSize, value2);
            return this.linear ? this : new VirtualList<V>(this.prefix, this.base, suffixPrime, false);
        }

        @Override
        public IList<V> forked() {
            return this.linear ? new VirtualList<V>(this.prefix.forked(), this.base, this.suffix.forked(), false) : this;
        }

        @Override
        public IList<V> linear() {
            return this.linear ? this : new VirtualList<V>(this.prefix.linear(), this.base, this.suffix.linear(), true);
        }

        public int hashCode() {
            return (int)Lists.hash(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IList) {
                return Lists.equals(this, (IList)obj);
            }
            return false;
        }

        @Override
        public VirtualList<V> clone() {
            return new VirtualList<V>(this.prefix.clone(), this.base, this.suffix.clone(), this.isLinear());
        }

        public String toString() {
            return Lists.toString(this);
        }
    }

    private static class JavaList<V>
    implements java.util.List<V>,
    RandomAccess {
        private final IList<V> list;

        public JavaList(IList<V> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return (int)this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.size() == 0L;
        }

        @Override
        public boolean contains(Object o) {
            return this.list.stream().anyMatch(e -> Objects.equals(o, e));
        }

        @Override
        public Iterator<V> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            Object[] ary = a2.length < this.size() ? (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size()) : a2;
            IntStream.range(0, this.size()).forEach((int i) -> {
                ary[i] = this.get(i);
            });
            return ary;
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return c2.stream().allMatch(e -> this.contains(e));
        }

        @Override
        public boolean addAll(Collection<? extends V> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(int index) {
            return this.list.nth(index);
        }

        @Override
        public V set(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return IntStream.range(0, this.size()).filter(idx -> Objects.equals(this.get(idx), o)).findFirst().orElse(-1);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.size() - IntStream.range(0, this.size()).filter(idx -> Objects.equals(this.get(this.size() - (idx + 1)), o)).findFirst().orElse(this.size() + 1);
        }

        @Override
        public ListIterator<V> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<V> listIterator(final int index) {
            return new ListIterator<V>(){
                int idx;
                {
                    this.idx = index;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < this.size();
                }

                @Override
                public V next() {
                    return this.get(this.idx++);
                }

                @Override
                public boolean hasPrevious() {
                    return this.idx > index;
                }

                @Override
                public V previous() {
                    return this.get(--this.idx);
                }

                @Override
                public int nextIndex() {
                    return this.idx;
                }

                @Override
                public int previousIndex() {
                    return this.idx - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(V v) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(V v) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public java.util.List<V> subList(int fromIndex, int toIndex) {
            return Lists.toList(this.list.slice(fromIndex, toIndex));
        }

        @Override
        public int hashCode() {
            return (int)Lists.hash(this.list, Objects::hashCode, (a2, b) -> a2 * 31L + b);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof java.util.List) {
                return Lists.equals(this.list, Lists.from(this));
            }
            return false;
        }

        public String toString() {
            return Lists.toString(this.list);
        }
    }

    private static class Slice<V>
    implements IList<V> {
        private final IList<V> list;
        private final long offset;
        private final long size;

        Slice(IList<V> list, long offset2, long size) {
            this.list = list;
            this.offset = offset2;
            this.size = size;
        }

        @Override
        public V nth(long idx) {
            if (idx < 0L || this.size <= idx) {
                throw new IndexOutOfBoundsException(idx + " must be within [0," + this.size + ")");
            }
            return this.list.nth(this.offset + idx);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public IList<V> slice(long start, long end2) {
            if (start == end2) {
                return EMPTY;
            }
            if (start < 0L || end2 <= start || end2 > this.size) {
                throw new IllegalArgumentException();
            }
            return new Slice<V>(this.list, this.offset + start, end2 - start);
        }

        public int hashCode() {
            return (int)Lists.hash(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IList) {
                return Lists.equals(this, (IList)obj);
            }
            return false;
        }

        @Override
        public IList<V> clone() {
            return this;
        }

        public String toString() {
            return Lists.toString(this);
        }
    }

    private static class Concat<V>
    implements IList<V> {
        final IntMap<IList<V>> lists;
        final long size;

        Concat(IList<V> a2, IList<V> b) {
            this.lists = ((IntMap)new IntMap().linear()).put(0L, a2).put(a2.size(), b).forked();
            this.size = a2.size() + b.size();
        }

        Concat(IList<V> list) {
            this.lists = ((IntMap)new IntMap().linear()).put(0L, list).linear();
            this.size = list.size();
        }

        private Concat(IntMap<IList<V>> lists, long size) {
            this.lists = lists;
            this.size = size;
        }

        @Override
        public V nth(long idx) {
            if (idx < 0L || this.size <= idx) {
                throw new IndexOutOfBoundsException(idx + " must be within [0," + this.size + ")");
            }
            IEntry<Long, IList<V>> entry = this.lists.floor(idx);
            return entry.value().nth(idx - entry.key());
        }

        @Override
        public Iterator<V> iterator() {
            return Iterators.flatMap(this.lists.iterator(), e -> ((IList)e.value()).iterator());
        }

        @Override
        public long size() {
            return this.size;
        }

        public int hashCode() {
            return (int)Lists.hash(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IList) {
                return Lists.equals(this, (IList)obj);
            }
            return false;
        }

        public String toString() {
            return Lists.toString(this);
        }

        @Override
        public IList<V> slice(long start, long end2) {
            if (end2 > this.size() || start < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (start == 0L && end2 == this.size()) {
                return this;
            }
            if (start == end2) {
                return EMPTY;
            }
            IntMap<IList<IList<V>>> m2 = new IntMap().linear();
            long pos = start;
            while (pos < end2) {
                IEntry<Long, IList<V>> e = this.lists.floor(pos);
                IList<V> l = e.value().slice(pos - e.key(), Math.min(end2 - e.key(), e.value().size()));
                m2 = m2.put(pos - start, (IList<IList<V>>)l);
                pos = e.key() + e.value().size();
            }
            return new Concat<V>(m2.forked(), end2 - start);
        }

        @Override
        Concat<V> concat(Concat<V> o) {
            IntMap<IList> m2 = this.lists.linear();
            long nSize = this.size;
            for (IList l : o.lists.values()) {
                if (l.size() <= 0L) continue;
                m2 = m2.put(nSize, l);
                nSize += l.size();
            }
            return new Concat<V>(m2.forked(), nSize);
        }

        @Override
        public IList<V> clone() {
            return this;
        }
    }
}

