/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IForkable;
import io.lacuna.bifurcan.ILinearizable;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISplittable;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Set;
import io.lacuna.bifurcan.Sets;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ISet<V>
extends Iterable<V>,
ISplittable<ISet<V>>,
ILinearizable<ISet<V>>,
IForkable<ISet<V>>,
Predicate<V> {
    default public ToIntFunction<V> valueHash() {
        return Objects::hashCode;
    }

    default public BiPredicate<V, V> valueEquality() {
        return Objects::equals;
    }

    public boolean contains(V var1);

    public long size();

    default public IList<V> elements() {
        return Lists.from(this.size(), this::nth, this::iterator);
    }

    default public <U> IMap<V, U> zip(Function<V, U> f) {
        IMap m2 = new Map(this.valueHash(), this.valueEquality()).linear();
        this.forEach(arg_0 -> ISet.lambda$zip$0((Map)m2, f, arg_0));
        return ((Map)m2).forked();
    }

    public long indexOf(V var1);

    public V nth(long var1);

    default public V nth(long index, V defaultValue) {
        if (0L <= index && index < this.size()) {
            return this.nth(index);
        }
        return defaultValue;
    }

    default public boolean containsAll(ISet<V> set) {
        return set.elements().stream().allMatch(this::contains);
    }

    default public boolean containsAll(IMap<V, ?> map2) {
        return this.containsAll(map2.keys());
    }

    default public boolean containsAny(ISet<V> set) {
        if (this.size() < set.size()) {
            return set.containsAny(this);
        }
        return set.elements().stream().anyMatch(this::contains);
    }

    default public boolean containsAny(IMap<V, ?> map2) {
        return this.containsAny(map2.keys());
    }

    default public ISet<V> add(V value2) {
        return new Sets.VirtualSet<V>(this).add(value2);
    }

    default public ISet<V> remove(V value2) {
        return new Sets.VirtualSet<V>(this).remove(value2);
    }

    @Override
    default public Iterator<V> iterator() {
        return this.elements().iterator();
    }

    @Override
    default public Spliterator<V> spliterator() {
        return Spliterators.spliterator(this.iterator(), this.size(), 1);
    }

    default public Stream<V> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public ISet<V> union(ISet<V> s2) {
        return Sets.union(this, s2);
    }

    default public ISet<V> difference(ISet<V> s2) {
        return Sets.difference(this, s2);
    }

    default public ISet<V> intersection(ISet<V> s2) {
        ISet<V> result = Sets.intersection(new Set<V>(this.valueHash(), this.valueEquality()).linear(), this, s2);
        return this.isLinear() ? result : result.forked();
    }

    default public java.util.Set<V> toSet() {
        return Sets.toSet(this.elements(), this::contains);
    }

    default public Object[] toArray() {
        Object[] ary = new Object[(int)this.size()];
        IList es = this.elements();
        IntStream.range(0, ary.length).forEach((int i) -> {
            ary[i] = es.nth(i);
        });
        return ary;
    }

    default public V[] toArray(IntFunction<V[]> allocator) {
        Object[] ary = allocator.apply((int)this.size());
        IList es = this.elements();
        IntStream.range(0, ary.length).forEach((int i) -> {
            ary[i] = es.nth(i);
        });
        return ary;
    }

    @Override
    default public boolean isLinear() {
        return false;
    }

    @Override
    default public ISet<V> forked() {
        return this;
    }

    @Override
    default public ISet<V> linear() {
        return new Sets.VirtualSet(this).linear();
    }

    public ISet<V> clone();

    @Override
    default public IList<? extends ISet<V>> split(int parts) {
        parts = Math.max(1, Math.min((int)this.size(), parts));
        return this.elements().split(parts).stream().map(LinearSet::from).collect(Lists.collector());
    }

    @Override
    default public boolean test(V v) {
        return this.contains(v);
    }

    private static /* synthetic */ void lambda$zip$0(Map m2, Function f, Object e) {
        m2.put(e, f.apply(e));
    }
}

