/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.artifex.Vec2;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.LinearMap;
import io.lacuna.bifurcan.LinearSet;
import java.util.Iterator;

public class EdgeList {
    private final LinearMap<Vec2, HalfEdge> vertices = new LinearMap();
    private final LinearSet<HalfEdge> pseudoFaces = new LinearSet();
    private boolean invalidated = false;

    public ISet<Vec2> vertices() {
        return this.vertices.keys();
    }

    public IList<HalfEdge> faces() {
        if (this.invalidated) {
            int i = 0;
            while ((long)i < this.pseudoFaces.size()) {
                HalfEdge e = this.pseudoFaces.nth(i);
                int j = 0;
                HalfEdge curr = e.next;
                while (curr != null && curr != e) {
                    if (j++ > 1000000) {
                        throw new IllegalStateException(e.toString());
                    }
                    this.pseudoFaces.remove((Object)curr);
                    curr = curr.next;
                }
                ++i;
            }
            this.invalidated = false;
        }
        return LinearList.from(this.pseudoFaces.elements());
    }

    private void registerFace(HalfEdge e) {
        ((LinearSet)this.pseudoFaces.add((Object)e)).add(e.twin);
        this.invalidated = true;
    }

    private void insert(HalfEdge src, HalfEdge e) {
        src.prev.link(e);
        e.twin.link(src);
        this.registerFace(e);
    }

    private void insert(HalfEdge e) {
        block6: {
            HalfEdge src = this.vertices.get(e.origin, null);
            if (src == null) {
                this.vertices.put((Object)e.origin, (Object)e);
                this.registerFace(e);
            } else if (src.prev == null) {
                e.twin.link(src);
                src.twin.link(e);
            } else {
                HalfEdge curr = src;
                while (true) {
                    if (curr.visible(e.twin.origin)) {
                        this.insert(curr, e);
                        break block6;
                    }
                    curr = curr.twin.next;
                    assert (curr != src);
                }
            }
        }
    }

    public HalfEdge add(Vec2 a2, Vec2 b) {
        HalfEdge e = new HalfEdge(a2, b);
        this.insert(e);
        this.insert(e.twin);
        return e;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (HalfEdge e : this.faces()) {
            LinearList<HalfEdge> l = LinearList.from(e.face());
            l.forEach(x -> b.append(x.origin).append(" -> "));
            b.append(((HalfEdge)l.last()).next == null ? "null" : "cycle").append("\n");
        }
        return b.toString();
    }

    public static class HalfEdge {
        public HalfEdge prev;
        public HalfEdge next;
        public HalfEdge twin;
        public final Vec2 origin;

        private HalfEdge(Vec2 origin, HalfEdge twin) {
            this.origin = origin;
            this.twin = twin;
        }

        public HalfEdge(Vec2 a2, Vec2 b) {
            this.origin = a2;
            this.twin = new HalfEdge(b, this);
        }

        public boolean visible(Vec2 p) {
            double t0 = Vec2.angleBetween(this.prev.origin.sub(this.origin), p.sub(this.origin));
            double t1 = this.interiorAngle();
            return 0.0 < t0 && t0 <= t1;
        }

        public double interiorAngle() {
            return -Vec2.angleBetween(this.prev.origin.sub(this.origin), this.twin.origin.sub(this.origin));
        }

        public void link(HalfEdge e) {
            assert (this.twin.origin.equals(e.origin));
            this.next = e;
            e.prev = this;
        }

        public Iterable<HalfEdge> face() {
            return () -> new Iterator<HalfEdge>(){
                HalfEdge curr;
                boolean started;
                {
                    this.curr = this;
                    this.started = false;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null && (!this.started || this.curr != this);
                }

                @Override
                public HalfEdge next() {
                    HalfEdge result = this.curr;
                    this.started = true;
                    this.curr = this.curr.next;
                    return result;
                }
            };
        }

        public String toString() {
            return this.origin + " -> " + this.twin.origin;
        }
    }
}

