"use strict";

var CABLES=CABLES||{};
CABLES.OPS=CABLES.OPS||{};

var Ops=Ops || {};
Ops.Ui=Ops.Ui || {};
Ops.Gl=Ops.Gl || {};
Ops.Exp=Ops.Exp || {};
Ops.Time=Ops.Time || {};
Ops.Vars=Ops.Vars || {};
Ops.Json=Ops.Json || {};
Ops.Html=Ops.Html || {};
Ops.User=Ops.User || {};
Ops.Anim=Ops.Anim || {};
Ops.Math=Ops.Math || {};
Ops.Array=Ops.Array || {};
Ops.Admin=Ops.Admin || {};
Ops.Color=Ops.Color || {};
Ops.Patch=Ops.Patch || {};
Ops.Value=Ops.Value || {};
Ops.Exp.Gl=Ops.Exp.Gl || {};
Ops.Json3d=Ops.Json3d || {};
Ops.String=Ops.String || {};
Ops.Points=Ops.Points || {};
Ops.Devices=Ops.Devices || {};
Ops.Trigger=Ops.Trigger || {};
Ops.Boolean=Ops.Boolean || {};
Ops.WebAudio=Ops.WebAudio || {};
Ops.TimeLine=Ops.TimeLine || {};
Ops.Gl.Meshes=Ops.Gl.Meshes || {};
Ops.Gl.Shader=Ops.Gl.Shader || {};
Ops.Gl.Matrix=Ops.Gl.Matrix || {};
Ops.Deprecated=Ops.Deprecated || {};
Ops.Gl.Geometry=Ops.Gl.Geometry || {};
Ops.Gl.Textures=Ops.Gl.Textures || {};
Ops.User.pandur=Ops.User.pandur || {};
Ops.Math.Compare=Ops.Math.Compare || {};
Ops.Deprecated.Gl=Ops.Deprecated.Gl || {};
Ops.Devices.Mouse=Ops.Devices.Mouse || {};
Ops.Exp.Gl.Shader=Ops.Exp.Gl.Shader || {};
Ops.Gl.ShaderEffects=Ops.Gl.ShaderEffects || {};
Ops.Deprecated.Json3d=Ops.Deprecated.Json3d || {};
Ops.Gl.TextureEffects=Ops.Gl.TextureEffects || {};
Ops.Exp.Gl.ShaderEffects=Ops.Exp.Gl.ShaderEffects || {};
Ops.Gl.TextureEffects.Noise=Ops.Gl.TextureEffects.Noise || {};
Ops.Deprecated.Gl.TextureEffects=Ops.Deprecated.Gl.TextureEffects || {};



// **************************************************************
// 
// Ops.Gl.MainLoop
// 
// **************************************************************

Ops.Gl.MainLoop = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const fpsLimit=op.inValue("FPS Limit",0);
const trigger=op.outTrigger("trigger");
const width=op.outValue("width");
const height=op.outValue("height");
const reduceLoadingFPS=op.inValueBool("Reduce FPS loading");
const clear=op.inValueBool("Clear",true);
const clearAlpha=op.inValueBool("ClearAlpha",true);
const fullscreen=op.inValueBool("Fullscreen Button",false);
const active=op.inValueBool("Active",true);
const hdpi=op.inValueBool("Hires Displays",false);

op.onAnimFrame=render;
hdpi.onChange=function()
{
    if(hdpi.get()) op.patch.cgl.pixelDensity=window.devicePixelRatio;
        else op.patch.cgl.pixelDensity=1;

    op.patch.cgl.updateSize();
    if(CABLES.UI) gui.setLayout();
};

active.onChange=function()
{
    op.patch.removeOnAnimFrame(op);

    if(active.get())
    {
        op.setUiAttrib({"extendTitle":""});
        op.onAnimFrame=render;
        op.patch.addOnAnimFrame(op);
        op.log("adding again!");
    }
    else
    {
        op.setUiAttrib({"extendTitle":"Inactive"});
    }

};

var cgl=op.patch.cgl;
var rframes=0;
var rframeStart=0;

if(!op.patch.cgl) op.uiAttr( { 'error': 'No webgl cgl context' } );

var identTranslate=vec3.create();
vec3.set(identTranslate, 0,0,0);
var identTranslateView=vec3.create();
vec3.set(identTranslateView, 0,0,-2);

fullscreen.onChange=updateFullscreenButton;
setTimeout(updateFullscreenButton,100);
var fsElement=null;

function updateFullscreenButton()
{
    function onMouseEnter()
    {
        if(fsElement)fsElement.style.display="block";
    }

    function onMouseLeave()
    {
        if(fsElement)fsElement.style.display="none";
    }

    op.patch.cgl.canvas.addEventListener('mouseleave', onMouseLeave);
    op.patch.cgl.canvas.addEventListener('mouseenter', onMouseEnter);

    if(fullscreen.get())
    {
        if(!fsElement)
        {
            fsElement = document.createElement('div');

            var container = op.patch.cgl.canvas.parentElement;
            if(container)container.appendChild(fsElement);

            fsElement.addEventListener('mouseenter', onMouseEnter);
            fsElement.addEventListener('click', function(e)
            {
                if(CABLES.UI && !e.shiftKey) gui.cycleRendererSize();
                    else
                    {
                        cgl.fullScreen();
                    }
            });
        }

        fsElement.style.padding="10px";
        fsElement.style.position="absolute";
        fsElement.style.right="5px";
        fsElement.style.top="5px";
        fsElement.style.width="20px";
        fsElement.style.height="20px";
        fsElement.style.cursor="pointer";
        fsElement.style['border-radius']="40px";
        fsElement.style.background="#444";
        fsElement.style["z-index"]="9999";
        fsElement.style.display="none";
        fsElement.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 490 490" style="width:20px;height:20px;" xml:space="preserve" width="512px" height="512px"><g><path d="M173.792,301.792L21.333,454.251v-80.917c0-5.891-4.776-10.667-10.667-10.667C4.776,362.667,0,367.442,0,373.333V480     c0,5.891,4.776,10.667,10.667,10.667h106.667c5.891,0,10.667-4.776,10.667-10.667s-4.776-10.667-10.667-10.667H36.416     l152.459-152.459c4.093-4.237,3.975-10.99-0.262-15.083C184.479,297.799,177.926,297.799,173.792,301.792z" fill="#FFFFFF"/><path d="M480,0H373.333c-5.891,0-10.667,4.776-10.667,10.667c0,5.891,4.776,10.667,10.667,10.667h80.917L301.792,173.792     c-4.237,4.093-4.354,10.845-0.262,15.083c4.093,4.237,10.845,4.354,15.083,0.262c0.089-0.086,0.176-0.173,0.262-0.262     L469.333,36.416v80.917c0,5.891,4.776,10.667,10.667,10.667s10.667-4.776,10.667-10.667V10.667C490.667,4.776,485.891,0,480,0z" fill="#FFFFFF"/><path d="M36.416,21.333h80.917c5.891,0,10.667-4.776,10.667-10.667C128,4.776,123.224,0,117.333,0H10.667     C4.776,0,0,4.776,0,10.667v106.667C0,123.224,4.776,128,10.667,128c5.891,0,10.667-4.776,10.667-10.667V36.416l152.459,152.459     c4.237,4.093,10.99,3.975,15.083-0.262c3.992-4.134,3.992-10.687,0-14.82L36.416,21.333z" fill="#FFFFFF"/><path d="M480,362.667c-5.891,0-10.667,4.776-10.667,10.667v80.917L316.875,301.792c-4.237-4.093-10.99-3.976-15.083,0.261     c-3.993,4.134-3.993,10.688,0,14.821l152.459,152.459h-80.917c-5.891,0-10.667,4.776-10.667,10.667s4.776,10.667,10.667,10.667     H480c5.891,0,10.667-4.776,10.667-10.667V373.333C490.667,367.442,485.891,362.667,480,362.667z" fill="#FFFFFF"/></g></svg>';
    }
    else
    {
        if(fsElement)
        {
            fsElement.style.display="none";
            fsElement.remove();
            fsElement=null;
        }
    }
}

fpsLimit.onChange=function()
{
    op.patch.config.fpsLimit=fpsLimit.get()||0;
};

op.onDelete=function()
{
    cgl.gl.clearColor(0,0,0,0);
    cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);
};

op.patch.loading.setOnFinishedLoading(function(cb)
{
    op.patch.config.fpsLimit=fpsLimit.get();
});


function render(time)
{
    if(!active.get())return;
    if(cgl.aborted || cgl.canvas.clientWidth===0 || cgl.canvas.clientHeight===0)return;

    if(op.patch.loading.getProgress()<1.0 && reduceLoadingFPS.get())
    {
        op.patch.config.fpsLimit=5;
    }

    if(cgl.canvasWidth==-1)
    {
        cgl.setCanvas(op.patch.config.glCanvasId);
        return;
    }

    if(cgl.canvasWidth!=width.get() || cgl.canvasHeight!=height.get())
    {
        width.set(cgl.canvasWidth);
        height.set(cgl.canvasHeight);
    }

    if(CABLES.now()-rframeStart>1000)
    {
        CGL.fpsReport=CGL.fpsReport||[];
        if(op.patch.loading.getProgress()>=1.0 && rframeStart!==0)CGL.fpsReport.push(rframes);
        rframes=0;
        rframeStart=CABLES.now();
    }
    CGL.MESH.lastShader=null;
    CGL.MESH.lastMesh=null;

    cgl.renderStart(cgl,identTranslate,identTranslateView);

    if(clear.get())
    {
        cgl.gl.clearColor(0,0,0,1);
        cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);
    }

    trigger.trigger();

    if(CGL.MESH.lastMesh)CGL.MESH.lastMesh.unBind();

    if(CGL.Texture.previewTexture)
    {
        if(!CGL.Texture.texturePreviewer) CGL.Texture.texturePreviewer=new CGL.Texture.texturePreview(cgl);
        CGL.Texture.texturePreviewer.render(CGL.Texture.previewTexture);
    }
    cgl.renderEnd(cgl);

    if(clearAlpha.get())
    {
        cgl.gl.clearColor(1, 1, 1, 1);
        cgl.gl.colorMask(false, false, false, true);
        cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT);
        cgl.gl.colorMask(true, true, true, true);
    }

    if(!cgl.frameStore.phong)cgl.frameStore.phong={};
    rframes++;
};












};

Ops.Gl.MainLoop.prototype = new CABLES.Op();
CABLES.OPS["b0472a1d-db16-4ba6-8787-f300fbdc77bb"]={f:Ops.Gl.MainLoop,objName:"Ops.Gl.MainLoop"};




// **************************************************************
// 
// Ops.Anim.SineAnim
// 
// **************************************************************

Ops.Anim.SineAnim = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    trigOut = op.outTrigger("Trigger out"),
    result=op.outValue("result"),
    phase=op.inValueFloat("phase",0),
    mul=op.inValueFloat("frequency",1),
    amplitude=op.inValueFloat("amplitude",1);

op.toWorkPortsNeedToBeLinked(exe);

exe.onTriggered=exec;
exec();

function exec()
{
    result.set( amplitude.get() * Math.sin( (op.patch.freeTimer.get()*mul.get()) + phase.get() ));
    trigOut.trigger();
}

};

Ops.Anim.SineAnim.prototype = new CABLES.Op();
CABLES.OPS["736d3d0e-c920-449e-ade0-f5ca6018fb5c"]={f:Ops.Anim.SineAnim,objName:"Ops.Anim.SineAnim"};




// **************************************************************
// 
// Ops.Math.MapRange
// 
// **************************************************************

Ops.Math.MapRange = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const result=op.outValue("result");
var v=op.inValueFloat("value");
var old_min=op.inValueFloat("old min");
var old_max=op.inValueFloat("old max");
var new_min=op.inValueFloat("new min");
var new_max=op.inValueFloat("new max");
var easing=op.inValueSelect("Easing",["Linear","Smoothstep","Smootherstep"],"Linear");

op.setPortGroup("Input Range",[old_min,old_max]);
op.setPortGroup("Output Range",[new_min,new_max]);

var ease=0;
var r=0;

easing.onChange=function()
{
    if(easing.get()=="Smoothstep") ease=1;
        else if(easing.get()=="Smootherstep") ease=2;
            else ease=0;
};


function exec()
{
    if(v.get()>=Math.max( old_max.get(),old_min.get() ))
    {
        result.set(new_max.get());
        return;
    }
    else
    if(v.get()<=Math.min( old_max.get(),old_min.get() ))
    {
        result.set(new_min.get());
        return;
    }

    var nMin=new_min.get();
    var nMax=new_max.get();
    var oMin=old_min.get();
    var oMax=old_max.get();
    var x=v.get();

    var reverseInput = false;
    var oldMin = Math.min( oMin, oMax );
    var oldMax = Math.max( oMin, oMax );
    if(oldMin!= oMin) reverseInput = true;

    var reverseOutput = false;
    var newMin = Math.min( nMin, nMax );
    var newMax = Math.max( nMin, nMax );
    if(newMin != nMin) reverseOutput = true;

    var portion=0;

    if(reverseInput) portion = (oldMax-x)*(newMax-newMin)/(oldMax-oldMin);
        else portion = (x-oldMin)*(newMax-newMin)/(oldMax-oldMin);

    if(reverseOutput) r=newMax - portion;
        else r=portion + newMin;

    if(ease===0)
    {
        result.set(r);
    }
    else
    if(ease==1)
    {
        x = Math.max(0, Math.min(1, (r-nMin)/(nMax-nMin)));
        result.set( nMin+x*x*(3 - 2*x)* (nMax-nMin) ); // smoothstep
    }
    else
    if(ease==2)
    {
        x = Math.max(0, Math.min(1, (r-nMin)/(nMax-nMin)));
        result.set( nMin+x*x*x*(x*(x*6 - 15) + 10) * (nMax-nMin) ) ; // smootherstep
    }

}

v.set(0);
old_min.set(0);
old_max.set(1);
new_min.set(-1);
new_max.set(1);


v.onChange=exec;
old_min.onChange=exec;
old_max.onChange=exec;
new_min.onChange=exec;
new_max.onChange=exec;

result.set(0);

exec();

};

Ops.Math.MapRange.prototype = new CABLES.Op();
CABLES.OPS["2617b407-60a0-4ff6-b4a7-18136cfa7817"]={f:Ops.Math.MapRange,objName:"Ops.Math.MapRange"};




// **************************************************************
// 
// Ops.Gl.Render2Texture
// 
// **************************************************************

Ops.Gl.Render2Texture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const cgl=op.patch.cgl;

const
    render=op.inTrigger('render'),
    useVPSize=op.inValueBool("use viewport size",true),
    width=op.inValueInt("texture width",512),
    height=op.inValueInt("texture height",512),
    tfilter=op.inSwitch("filter",['nearest','linear','mipmap'],'linear'),
    msaa=op.inSwitch("MSAA",["none","2x","4x","8x"],"none"),
    trigger=op.outTrigger('trigger'),
    tex=op.outTexture("texture"),
    texDepth=op.outTexture("textureDepth"),
    fpTexture=op.inValueBool("HDR"),
    depth=op.inValueBool("Depth",true),
    clear=op.inValueBool("Clear",true);

var fb=null;
var reInitFb=true;
tex.set(CGL.Texture.getEmptyTexture(cgl));

op.setPortGroup('Alignment',[useVPSize,width,height,tfilter]);


// todo why does it only work when we render a mesh before>?>?????
// only happens with matcap material with normal map....

useVPSize.onChange=updateVpSize;
function updateVpSize()
{
    if(useVPSize.get())
    {
        width.setUiAttribs({greyout:true});
        height.setUiAttribs({greyout:true});
    }
    else
    {
        width.setUiAttribs({greyout:false});
        height.setUiAttribs({greyout:false});
    }
}

function initFbLater()
{
    reInitFb=true;
}

fpTexture.onChange=
    depth.onChange=
    clear.onChange=
    tfilter.onChange=
    msaa.onChange=initFbLater;

function doRender()
{
    if(!fb || reInitFb)
    {
        if(fb) fb.delete();
        if(cgl.glVersion>=2)
        {
            var ms=true;
            var msSamples=4;

            if(msaa.get()=="none")
            {
                msSamples=0;
                ms=false;
            }
            if(msaa.get()=="2x")msSamples=2;
            if(msaa.get()=="4x")msSamples=4;
            if(msaa.get()=="8x")msSamples=8;

            fb=new CGL.Framebuffer2(cgl,8,8,
            {
                isFloatingPointTexture:fpTexture.get(),
                multisampling:ms,
                depth:depth.get(),
                multisamplingSamples:msSamples,
                clear:clear.get()
            });
        }
        else
        {
            fb=new CGL.Framebuffer(cgl,8,8,{isFloatingPointTexture:fpTexture.get()});
        }

        if(tfilter.get()=='nearest') fb.setFilter(CGL.Texture.FILTER_NEAREST);
            else if(tfilter.get()=='linear') fb.setFilter(CGL.Texture.FILTER_LINEAR);
            else if(tfilter.get()=='mipmap') fb.setFilter(CGL.Texture.FILTER_MIPMAP);

        texDepth.set(fb.getTextureDepth());
        reInitFb=false;
    }

    if(useVPSize.val)
    {
        width.set( cgl.getViewPort()[2] );
        height.set( cgl.getViewPort()[3] );
    }

    if(fb.getWidth()!=Math.ceil(width.get()) || fb.getHeight()!=Math.ceil(height.get()) )
    {
        fb.setSize(
            Math.max(1,Math.ceil(width.get())),
            Math.max(1,Math.ceil(height.get())) );
    }

    fb.renderStart(cgl);

    trigger.trigger();
    fb.renderEnd(cgl);

    cgl.resetViewPort();

    tex.set( fb.getTextureColor() );
}


render.onTriggered=doRender;
op.preRender=doRender;


updateVpSize();

};

Ops.Gl.Render2Texture.prototype = new CABLES.Op();
CABLES.OPS["d01fa820-396c-4cb5-9d78-6b14762852af"]={f:Ops.Gl.Render2Texture,objName:"Ops.Gl.Render2Texture"};




// **************************************************************
// 
// Ops.Sequence
// 
// **************************************************************

Ops.Sequence = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const exe=op.inTrigger("exe");
const exes=[];
const triggers=[];
const num=16;
exe.onTriggered=triggerAll;

function triggerAll()
{
    for(var i=0;i<triggers.length;i++) triggers[i].trigger();
}

for(var i=0;i<num;i++)
{
    triggers.push( op.outTrigger("trigger "+i));

    if(i<num-1)
    {
        var newExe=op.inTrigger("exe "+i);
        newExe.onTriggered=triggerAll;
        exes.push( newExe );
    }
}

};

Ops.Sequence.prototype = new CABLES.Op();
CABLES.OPS["a466bc1f-06e9-4595-8849-bffb9fe22f99"]={f:Ops.Sequence,objName:"Ops.Sequence"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ImageCompose
// 
// **************************************************************

Ops.Gl.TextureEffects.ImageCompose = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const useVPSize=op.addInPort(new CABLES.Port(op,"use viewport size",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
const width=op.inValueInt("width");
const height=op.inValueInt("height");

const tfilter=op.inSwitch("filter",['nearest','linear','mipmap'],"linear");
const twrap=op.inValueSelect("wrap",['clamp to edge','repeat','mirrored repeat']);
const fpTexture=op.inValueBool("HDR");

const trigger=op.outTrigger("trigger");
const texOut=op.outTexture("texture_out");

const bgAlpha=op.inValueSlider("Background Alpha",1);
const outRatio=op.outValue("Aspect Ratio");

op.setPortGroup("Texture Size",[useVPSize,width,height]);
op.setPortGroup("Texture Settings",[twrap,tfilter,fpTexture]);



const cgl=op.patch.cgl;
texOut.set(CGL.Texture.getEmptyTexture(cgl));
var effect=null;
var tex=null;

var w=8,h=8;
var prevViewPort=[0,0,0,0];
var reInitEffect=true;

var bgFrag=''
    .endl()+'uniform float a;'
    .endl()+'void main()'
    .endl()+'{'
    .endl()+'   outColor= vec4(0.0,0.0,0.0,a);'
    .endl()+'}';
var bgShader=new CGL.Shader(cgl,'imgcompose bg');
bgShader.setSource(bgShader.getDefaultVertexShader(),bgFrag);
var uniBgAlpha=new CGL.Uniform(bgShader,'f','a',bgAlpha);

var selectedFilter=CGL.Texture.FILTER_LINEAR;
var selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

function initEffect()
{
    if(effect)effect.delete();
    if(tex)tex.delete();

    effect=new CGL.TextureEffect(cgl,{"isFloatingPointTexture":fpTexture.get()});

    tex=new CGL.Texture(cgl,
        {
            "name":"image compose",
            "isFloatingPointTexture":fpTexture.get(),
            "filter":selectedFilter,
            "wrap":selectedWrap,
            "width": Math.ceil(width.get()),
            "height": Math.ceil(height.get()),
        });

    effect.setSourceTexture(tex);
    texOut.set(CGL.Texture.getEmptyTexture(cgl));
    // texOut.set(effect.getCurrentSourceTexture());

    // texOut.set(effect.getCurrentSourceTexture());

    reInitEffect=false;

    // op.log("reinit effect");
    // tex.printInfo();
}

fpTexture.onChange=function()
{
    reInitEffect=true;

    // var e1=cgl.gl.getExtension('EXT_color_buffer_float');
    // var e2=cgl.gl.getExtension('EXT_float_blend');

};

function updateResolution()
{
    if(!effect)initEffect();

    if(useVPSize.get())
    {
        w=cgl.getViewPort()[2];
        h=cgl.getViewPort()[3];
    }
    else
    {
        w=Math.ceil(width.get());
        h=Math.ceil(height.get());
    }

    if((w!=tex.width || h!= tex.height) && (w!==0 && h!==0))
    {
        height.set(h);
        width.set(w);
        tex.setSize(w,h);
        outRatio.set(w/h);
        effect.setSourceTexture(tex);
        // texOut.set(null);
        texOut.set(CGL.Texture.getEmptyTexture(cgl));
        texOut.set(tex);
    }

    if(texOut.get())
        if(!texOut.get().isPowerOfTwo() )
        {
            if(!op.uiAttribs.hint)
                op.uiAttr(
                    {
                        hint:'texture dimensions not power of two! - texture filtering will not work.',
                        warning:null
                    });
        }
        else
        if(op.uiAttribs.hint)
        {
            op.uiAttr({hint:null,warning:null}); //todo only when needed...
        }

}


function updateSizePorts()
{
    if(useVPSize.get())
    {
        width.setUiAttribs({greyout:true});
        height.setUiAttribs({greyout:true});
    }
    else
    {
        width.setUiAttribs({greyout:false});
        height.setUiAttribs({greyout:false});
    }
}


useVPSize.onChange=function()
{
    updateSizePorts();
    if(useVPSize.get())
    {
        width.onChange=null;
        height.onChange=null;
    }
    else
    {
        width.onChange=updateResolution;
        height.onChange=updateResolution;
    }
    updateResolution();

};


op.preRender=function()
{
    doRender();
    bgShader.bind();
};


var doRender=function()
{
    if(!effect || reInitEffect)
    {
        initEffect();
    }
    var vp=cgl.getViewPort();
    prevViewPort[0]=vp[0];
    prevViewPort[1]=vp[1];
    prevViewPort[2]=vp[2];
    prevViewPort[3]=vp[3];

    cgl.gl.blendFunc(cgl.gl.SRC_ALPHA, cgl.gl.ONE_MINUS_SRC_ALPHA);

    updateResolution();

    cgl.currentTextureEffect=effect;
    effect.setSourceTexture(tex);

    effect.startEffect();

    // render background color...
    cgl.setShader(bgShader);
    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();

    texOut.set(effect.getCurrentSourceTexture());
    // texOut.set(effect.getCurrentTargetTexture());


    // if(effect.getCurrentSourceTexture.filter==CGL.Texture.FILTER_MIPMAP)
    // {
    //         this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, effect.getCurrentSourceTexture.tex);
    //         effect.getCurrentSourceTexture.updateMipMap();
    //     // else
    //     // {
    //     //     this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, this._textureSource.tex);;
    //     //     this._textureSource.updateMipMap();
    //     // }

    //     this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, null);
    // }

    effect.endEffect();

    cgl.setViewPort(prevViewPort[0],prevViewPort[1],prevViewPort[2],prevViewPort[3]);


    cgl.gl.blendFunc(cgl.gl.SRC_ALPHA,cgl.gl.ONE_MINUS_SRC_ALPHA);

    cgl.currentTextureEffect=null;
};


function onWrapChange()
{
    if(twrap.get()=='repeat') selectedWrap=CGL.Texture.WRAP_REPEAT;
    if(twrap.get()=='mirrored repeat') selectedWrap=CGL.Texture.WRAP_MIRRORED_REPEAT;
    if(twrap.get()=='clamp to edge') selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

    reInitEffect=true;
    updateResolution();
}

twrap.set('repeat');
twrap.onChange=onWrapChange;


function onFilterChange()
{
    if(tfilter.get()=='nearest') selectedFilter=CGL.Texture.FILTER_NEAREST;
    if(tfilter.get()=='linear')  selectedFilter=CGL.Texture.FILTER_LINEAR;
    if(tfilter.get()=='mipmap')  selectedFilter=CGL.Texture.FILTER_MIPMAP;

    reInitEffect=true;
    updateResolution();
    // effect.setSourceTexture(tex);
    // updateResolution();
}

tfilter.set('linear');
tfilter.onChange=onFilterChange;

useVPSize.set(true);
render.onTriggered=doRender;
op.preRender=doRender;


width.set(640);
height.set(360);
onFilterChange();
onWrapChange();
updateSizePorts();

};

Ops.Gl.TextureEffects.ImageCompose.prototype = new CABLES.Op();
CABLES.OPS["5c04608d-1e42-4e36-be00-1be4a81fc309"]={f:Ops.Gl.TextureEffects.ImageCompose,objName:"Ops.Gl.TextureEffects.ImageCompose"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.PseudoLensFlares
// 
// **************************************************************

Ops.Gl.TextureEffects.PseudoLensFlares = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={lensflares_frag:"UNI sampler2D tex;\n// UNI sampler2D texInput;\nUNI float haloWidth;\nUNI int numGhosts;\nUNI float dispersal;\nUNI float amountGhosts;\nUNI float amountHalo;\nUNI sampler2D texLookup;\n\nIN vec2 texCoord;\n\nvec3 lumi(vec3 c)\n{\n   return vec3(sqrt(c.r*c.r*0.241+c.g*c.g*0.691+c.b*c.b*0.068));\n}\n\nvec4 myTexture(sampler2D tex,vec2 coords)\n{\n    vec4 c=texture(tex, coords);\n    c.rgb=lumi(c.rgb);\n    return c;\n}\n\nvoid main()\n{\n    vec2 texcoord = -texCoord + vec2(1.0);\n    // vec2 texelSize = 1.0 / vec2(textureSize(texInput, 0));\n    vec2 ghostVec = (vec2(0.5) - texcoord) * (0.5*dispersal);\n    vec4 result = vec4(0.0,0.0,0.0,1.0);//texture(tex,texCoord);\n\n\n\n    // ghosts\n    for (int i = 0; i < numGhosts; ++i)\n    {\n        vec2 offset = fract(texcoord + ghostVec * float(i));\n        float weightA = length(vec2(0.5) - offset) / length(vec2(0.5));\n        weightA = pow(1. - weightA, 10.0);\n        result += myTexture(tex, offset)*weightA*amountGhosts;\n    }\n\n    // halo\n    vec2 haloVec = normalize(ghostVec) * haloWidth;\n    float weight = length(vec2(0.5) - fract(texcoord + haloVec)) / length(vec2(0.5));\n\n    weight = pow(1.0 - weight, 5.0);\n    result += myTexture(tex, texcoord + haloVec) * weight * amountHalo;\n\n    #ifdef TEX_LOOPUP\n        result *= texture(texLookup, vec2(length(vec2(0.5) - texcoord) / length(vec2(0.5)),0.5));\n    #endif\n\n    outColor=result;\n}\n\n",};
// http://john-chapman-graphics.blogspot.com/2013/02/pseudo-lens-flare.html

const render=op.inTrigger("render"),
    inAmountGhosts=op.inValueSlider("Ghosts",1.0),
    inNumGhosts=op.inValueInt("Num Ghosts",3),
    inDispersal=op.inValueSlider("Dispersal",0.5),
    inAmountHalo=op.inValueSlider("Halo",1.0),
    inHaloWidth=op.inValueSlider("Halo Width",0.5),
    textureLookup=op.inTexture("Color Lookup"),
    trigger=op.outTrigger("trigger");

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.lensflares_frag||'');

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    textureLookupUni=new CGL.Uniform(shader,'t','texLookup',1),
    uniHaloWidth=new CGL.Uniform(shader,'f','haloWidth',inHaloWidth),
    uniNumGhosts=new CGL.Uniform(shader,'i','numGhosts',inNumGhosts),
    uniDispersal=new CGL.Uniform(shader,'f','dispersal',inDispersal),
    uniAmountGhosts=new CGL.Uniform(shader,'f','amountGhosts',inAmountGhosts),
    uniAmounthalo=new CGL.Uniform(shader,'f','amountHalo',inAmountHalo);

textureLookup.onChange=function()
{
    if(textureLookup.get())shader.define("TEX_LOOPUP");
        else shader.removeDefine("TEX_LOOPUP");
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );
    if(textureLookup.get()) cgl.setTexture(1, textureLookup.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.PseudoLensFlares.prototype = new CABLES.Op();
CABLES.OPS["9e4a5694-ed59-4401-9f7b-123a627924c5"]={f:Ops.Gl.TextureEffects.PseudoLensFlares,objName:"Ops.Gl.TextureEffects.PseudoLensFlares"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.DrawImage_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.DrawImage_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={drawimage_frag:"#ifdef HAS_TEXTURES\n    IN vec2 texCoord;\n    UNI sampler2D tex;\n    UNI sampler2D image;\n#endif\n\nIN mat3 transform;\nUNI float rotate;\n\n{{CGL.BLENDMODES}}\n\n#ifdef HAS_TEXTUREALPHA\n   UNI sampler2D imageAlpha;\n#endif\n\nUNI float amount;\n\n#ifdef ASPECT_RATIO\n    UNI float aspectTex;\n    UNI float aspectPos;\n#endif\n\nvoid main()\n{\n    vec4 blendRGBA=vec4(0.0,0.0,0.0,1.0);\n    #ifdef HAS_TEXTURES\n        vec2 tc=texCoord;\n\n        #ifdef TEX_FLIP_X\n            tc.x=1.0-tc.x;\n        #endif\n        #ifdef TEX_FLIP_Y\n            tc.y=1.0-tc.y;\n        #endif\n\n        #ifdef ASPECT_RATIO\n            #ifdef ASPECT_AXIS_X\n                tc.y=(1.0-aspectPos)-(((1.0-aspectPos)-tc.y)*aspectTex);\n            #endif\n            #ifdef ASPECT_AXIS_Y\n                tc.x=(1.0-aspectPos)-(((1.0-aspectPos)-tc.x)/aspectTex);\n            #endif\n        #endif\n\n        #ifdef TEX_TRANSFORM\n            vec3 coordinates=vec3(tc.x, tc.y,1.0);\n            tc=(transform * coordinates ).xy;\n        #endif\n\n        blendRGBA=texture(image,tc);\n\n        vec3 blend=blendRGBA.rgb;\n        vec4 baseRGBA=texture(tex,texCoord);\n        vec3 base=baseRGBA.rgb;\n        vec3 colNew=_blend(base,blend);\n\n        #ifdef REMOVE_ALPHA_SRC\n            blendRGBA.a=1.0;\n        #endif\n\n        #ifdef HAS_TEXTUREALPHA\n            vec4 colImgAlpha=texture(imageAlpha,texCoord);\n            float colImgAlphaAlpha=colImgAlpha.a;\n\n            #ifdef ALPHA_FROM_LUMINANCE\n                vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), colImgAlpha.rgb ));\n                colImgAlphaAlpha=(gray.r+gray.g+gray.b)/3.0;\n            #endif\n\n            #ifdef ALPHA_FROM_INV_UMINANCE\n                vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), colImgAlpha.rgb ));\n                colImgAlphaAlpha=1.0-(gray.r+gray.g+gray.b)/3.0;\n            #endif\n\n            blendRGBA.a=colImgAlphaAlpha*blendRGBA.a;\n        #endif\n    #endif\n\n    #ifdef CLIP_REPEAT\n        if(tc.y>1.0 || tc.y<0.0 || tc.x>1.0 || tc.x<0.0)colNew.rgb=vec3(0.0);\n    #endif\n\n    #ifdef ASPECT_RATIO\n        #ifdef ASPECT_CROP\n            if(tc.y>1.0 || tc.y<0.0 || tc.x>1.0 || tc.x<0.0) colNew.rgb=base.rgb;//vec3(0.0);\n        #endif\n    #endif\n\n    blendRGBA.rgb=mix( colNew, base ,1.0-blendRGBA.a*amount);\n    blendRGBA.a=1.0;\n\n    outColor= blendRGBA;\n\n}",drawimage_vert:"IN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\n\nUNI mat4 projMatrix;\nUNI mat4 mvMatrix;\n\nUNI float posX;\nUNI float posY;\nUNI float scaleX;\nUNI float scaleY;\nUNI float rotate;\n\nOUT vec2 texCoord;\nOUT vec3 norm;\nOUT mat3 transform;\n\nvoid main()\n{\n   texCoord=attrTexCoord;\n   norm=attrVertNormal;\n\n   #ifdef TEX_TRANSFORM\n        vec3 coordinates=vec3(attrTexCoord.x, attrTexCoord.y,1.0);\n        float angle = radians( rotate );\n        vec2 scale= vec2(scaleX,scaleY);\n        vec2 translate= vec2(posX,posY);\n\n        transform = mat3(   scale.x * cos( angle ), scale.x * sin( angle ), 0.0,\n            - scale.y * sin( angle ), scale.y * cos( angle ), 0.0,\n            - 0.5 * scale.x * cos( angle ) + 0.5 * scale.y * sin( angle ) - 0.5 * translate.x*2.0 + 0.5,  - 0.5 * scale.x * sin( angle ) - 0.5 * scale.y * cos( angle ) - 0.5 * translate.y*2.0 + 0.5, 1.0);\n   #endif\n\n   gl_Position = projMatrix * mvMatrix * vec4(vPosition,  1.0);\n}\n",};
var render=op.inTrigger('render');
var blendMode=CGL.TextureEffect.AddBlendSelect(op,"blendMode");
var amount=op.inValueSlider("amount",1);

var image=op.inTexture("image");
var removeAlphaSrc=op.inValueBool("removeAlphaSrc",false);

var imageAlpha=op.inTexture("imageAlpha");
var alphaSrc=op.inValueSelect("alphaSrc",['alpha channel','luminance','luminance inv']);
var invAlphaChannel=op.inValueBool("invert alpha channel");

const inAspect=op.inValueBool("Aspect Ratio",false);
const inAspectAxis=op.inValueSelect("Stretch Axis",['X','Y'],"X");
const inAspectPos=op.inValueSlider("Position",0.0);
const inAspectCrop=op.inValueBool("Crop",false);


var trigger=op.outTrigger('trigger');

blendMode.set('normal');
var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'drawimage');


imageAlpha.onLinkChanged=updateAlphaPorts;

op.setPortGroup("Mask",[imageAlpha,alphaSrc,invAlphaChannel]);
op.setPortGroup("Aspect Ratio",[inAspect,inAspectPos,inAspectCrop,inAspectAxis]);


removeAlphaSrc.onChange=updateRemoveAlphaSrc;

function updateAlphaPorts()
{
    if(imageAlpha.isLinked())
    {
        removeAlphaSrc.setUiAttribs({greyout:true});
        alphaSrc.setUiAttribs({greyout:false});
        invAlphaChannel.setUiAttribs({greyout:false});
    }
    else
    {
        removeAlphaSrc.setUiAttribs({greyout:false});
        alphaSrc.setUiAttribs({greyout:true});
        invAlphaChannel.setUiAttribs({greyout:true});
    }
}

op.toWorkPortsNeedToBeLinked(image);

shader.setSource(attachments.drawimage_vert,attachments.drawimage_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var textureImaghe=new CGL.Uniform(shader,'t','image',1);
var textureAlpha=new CGL.Uniform(shader,'t','imageAlpha',2);

const uniTexAspect=new CGL.Uniform(shader,'f','aspectTex',1);
const uniAspectPos=new CGL.Uniform(shader,'f','aspectPos',inAspectPos);

invAlphaChannel.onChange=function()
{
    if(invAlphaChannel.get()) shader.define('INVERT_ALPHA');
        else shader.removeDefine('INVERT_ALPHA');
};


inAspect.onChange=updateAspectRatio;
inAspectCrop.onChange=updateAspectRatio;
inAspectAxis.onChange=updateAspectRatio;
function updateAspectRatio()
{
    shader.removeDefine('ASPECT_AXIS_X');
    shader.removeDefine('ASPECT_AXIS_Y');

    if(inAspect.get())
    {
        shader.define('ASPECT_RATIO');

        if(inAspectCrop.get()) shader.define('ASPECT_CROP');
            else shader.removeDefine('ASPECT_CROP');

        if(inAspectAxis.get()=="X") shader.define('ASPECT_AXIS_X');
        if(inAspectAxis.get()=="Y") shader.define('ASPECT_AXIS_Y');


        inAspectPos.setUiAttribs({greyout:false});
        inAspectCrop.setUiAttribs({greyout:false});
        inAspectAxis.setUiAttribs({greyout:false});
    }
    else
    {
        shader.removeDefine('ASPECT_RATIO');
        if(inAspectCrop.get()) shader.define('ASPECT_CROP');
            else shader.removeDefine('ASPECT_CROP');

        if(inAspectAxis.get()=="X") shader.define('ASPECT_AXIS_X');
        if(inAspectAxis.get()=="Y") shader.define('ASPECT_AXIS_Y');

        inAspectPos.setUiAttribs({greyout:true});
        inAspectCrop.setUiAttribs({greyout:true});
        inAspectAxis.setUiAttribs({greyout:true});
    }
}




function updateRemoveAlphaSrc()
{
    if(removeAlphaSrc.get()) shader.define('REMOVE_ALPHA_SRC');
        else shader.removeDefine('REMOVE_ALPHA_SRC');
}


alphaSrc.onChange=function()
{
    shader.toggleDefine('ALPHA_FROM_LUMINANCE',alphaSrc.get()=='luminance');
    shader.toggleDefine('ALPHA_FROM_INV_UMINANCE',alphaSrc.get()=='luminance_inv');
};

alphaSrc.set("alpha channel");


{
    //
    // texture flip
    //
    var flipX=op.inValueBool("flip x");
    var flipY=op.inValueBool("flip y");

    flipX.onChange=function()
    {
        if(flipX.get()) shader.define('TEX_FLIP_X');
            else shader.removeDefine('TEX_FLIP_X');
    };

    flipY.onChange=function()
    {
        if(flipY.get()) shader.define('TEX_FLIP_Y');
            else shader.removeDefine('TEX_FLIP_Y');
    };
}

{
    //
    // texture transform
    //

    var doTransform=op.inValueBool("Transform");

    var scaleX=op.inValueSlider("Scale X",1);
    var scaleY=op.inValueSlider("Scale Y",1);

    var posX=op.inValue("Position X",0);
    var posY=op.inValue("Position Y",0);

    var rotate=op.inValue("Rotation",0);

    var inClipRepeat=op.inValueBool("Clip Repeat",false);

    inClipRepeat.onChange=updateClip;
    function updateClip()
    {
        if(inClipRepeat.get()) shader.define('CLIP_REPEAT');
            else shader.removeDefine('CLIP_REPEAT');
    }


    var uniScaleX=new CGL.Uniform(shader,'f','scaleX',scaleX);
    var uniScaleY=new CGL.Uniform(shader,'f','scaleY',scaleY);

    var uniPosX=new CGL.Uniform(shader,'f','posX',posX);
    var uniPosY=new CGL.Uniform(shader,'f','posY',posY);
    var uniRotate=new CGL.Uniform(shader,'f','rotate',rotate);

    doTransform.onChange=updateTransformPorts;
}

function updateTransformPorts()
{
    shader.toggleDefine('TEX_TRANSFORM',doTransform.get());
    if(doTransform.get())
    {
        // scaleX.setUiAttribs({hidePort:false});
        // scaleY.setUiAttribs({hidePort:false});
        // posX.setUiAttribs({hidePort:false});
        // posY.setUiAttribs({hidePort:false});
        // rotate.setUiAttribs({hidePort:false});

        scaleX.setUiAttribs({greyout:false});
        scaleY.setUiAttribs({greyout:false});
        posX.setUiAttribs({greyout:false});
        posY.setUiAttribs({greyout:false});
        rotate.setUiAttribs({greyout:false});
    }
    else
    {
        scaleX.setUiAttribs({greyout:true});
        scaleY.setUiAttribs({greyout:true});
        posX.setUiAttribs({greyout:true});
        posY.setUiAttribs({greyout:true});
        rotate.setUiAttribs({greyout:true});

        // scaleX.setUiAttribs({"hidePort":true});
        // scaleY.setUiAttribs({"hidePort":true});
        // posX.setUiAttribs({"hidePort":true});
        // posY.setUiAttribs({"hidePort":true});
        // rotate.setUiAttribs({"hidePort":true});


    }

    // op.refreshParams();
}

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

var amountUniform=new CGL.Uniform(shader,'f','amount',amount);

imageAlpha.onChange=function()
{
    if(imageAlpha.get() && imageAlpha.get().tex)
    {
        shader.define('HAS_TEXTUREALPHA');
    }
    else
    {
        shader.removeDefine('HAS_TEXTUREALPHA');
    }
};

function doRender()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var tex=image.get();
    if(tex && tex.tex && amount.get()>0.0)
    {
        cgl.setShader(shader);
        cgl.currentTextureEffect.bind();

        const imgTex=cgl.currentTextureEffect.getCurrentSourceTexture();
        cgl.setTexture(0,imgTex.tex );

        uniTexAspect.setValue( 1/(tex.height/tex.width*imgTex.width/imgTex.height));



        cgl.setTexture(1, tex.tex );
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, image.get().tex );

        if(imageAlpha.get() && imageAlpha.get().tex)
        {
            cgl.setTexture(2, imageAlpha.get().tex );
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, imageAlpha.get().tex );
        }

        cgl.currentTextureEffect.finish();
        cgl.setPreviousShader();
    }

    trigger.trigger();
}

render.onTriggered=doRender;
updateTransformPorts();
updateRemoveAlphaSrc();
updateAlphaPorts();
updateAspectRatio();


};

Ops.Gl.TextureEffects.DrawImage_v2.prototype = new CABLES.Op();
CABLES.OPS["f94b5136-61fd-4558-8348-e7c8db5a6348"]={f:Ops.Gl.TextureEffects.DrawImage_v2,objName:"Ops.Gl.TextureEffects.DrawImage_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Mirror
// 
// **************************************************************

Ops.Gl.TextureEffects.Mirror = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={mirror_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float axis;\nUNI float width;\nUNI float flip;\nUNI float offset;\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n\n   float tc=texCoord.x;\n   if(axis==1.0) tc=(texCoord.y);\n\n   float x=(tc);\n   if(tc>=0.5)x=1.0-tc;\n\n   x*=width*2.0;\n   if(flip==1.0)x=1.0-x;\n   x*=1.0-offset;\n\n   if(axis==1.0) col=texture(tex,vec2(texCoord.x,x) );\n       else col=texture(tex,vec2(x,texCoord.y) );\n\n   outColor= col;\n}",};
const
    render=op.inTrigger('render'),
    trigger=op.outTrigger('trigger'),
    axis=op.inSwitch("axis",["X","Y"],"X"),
    width=op.inValueFloat("width",0.5),
    offset=op.inValueFloat("offset"),
    flip=op.inValueBool("flip");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.mirror_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    uniAxis=new CGL.Uniform(shader,'f','axis',0),
    uniWidth=new CGL.Uniform(shader,'f','width',width),
    uniOffset=new CGL.Uniform(shader,'f','offset',offset),
    uniFlip=new CGL.Uniform(shader,'f','flip',0);

flip.onChange=function()
{
    if(flip.get())uniFlip.setValue(1);
        else uniFlip.setValue(0);
};

axis.onChange=function()
{
    if(axis.get()=='X')uniAxis.setValue(0);
        else if(axis.get()=='Y')uniAxis.setValue(1);
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Mirror.prototype = new CABLES.Op();
CABLES.OPS["10d3c769-9a7f-4bd3-a849-7354d3e5f7f0"]={f:Ops.Gl.TextureEffects.Mirror,objName:"Ops.Gl.TextureEffects.Mirror"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Blur
// 
// **************************************************************

Ops.Gl.TextureEffects.Blur = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={blur_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float dirX;\nUNI float dirY;\nUNI float amount;\n\n#ifdef HAS_MASK\n    UNI sampler2D imageMask;\n#endif\n\nfloat random(vec3 scale, float seed)\n{\n    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);\n}\n\nvoid main()\n{\n    vec4 color = vec4(0.0);\n    float total = 0.0;\n\n    float am=amount;\n    #ifdef HAS_MASK\n        am=amount*texture(imageMask,texCoord).r;\n        if(am<=0.02)\n        {\n            outColor=texture(tex, texCoord);\n            return;\n        }\n    #endif\n\n   vec2 delta=vec2(dirX*am*0.01,dirY*am*0.01);\n\n\n    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0);\n\n    #ifdef MOBILE\n        offset = 0.1;\n    #endif\n\n    #if defined(FASTBLUR) && !defined(MOBILE)\n        const float range=5.0;\n    #else\n        const float range=20.0;\n    #endif\n\n    for (float t = -range; t <= range; t+=1.0)\n    {\n        float percent = (t + offset - 0.5) / range;\n        float weight = 1.0 - abs(percent);\n        vec4 smpl = texture(tex, texCoord + delta * percent);\n\n        smpl.rgb *= smpl.a;\n\n        color += smpl * weight;\n        total += weight;\n    }\n\n    outColor= color / total;\n\n    outColor.rgb /= outColor.a + 0.00001;\n\n\n\n}\n",};
const render=op.inTrigger('render');
const trigger=op.outTrigger('trigger');
const amount=op.inValueFloat("amount");
const direction=op.inSwitch("direction",['both','vertical','horizontal'],'both');
const fast=op.inValueBool("Fast",true);
const cgl=op.patch.cgl;

amount.set(10);

var shader=new CGL.Shader(cgl);

shader.define("FASTBLUR");

fast.onChange=function()
{
    if(fast.get()) shader.define("FASTBLUR");
    else shader.removeDefine("FASTBLUR");
};

shader.setSource(shader.getDefaultVertexShader(),attachments.blur_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var uniDirX=new CGL.Uniform(shader,'f','dirX',0);
var uniDirY=new CGL.Uniform(shader,'f','dirY',0);

var uniWidth=new CGL.Uniform(shader,'f','width',0);
var uniHeight=new CGL.Uniform(shader,'f','height',0);

var uniAmount=new CGL.Uniform(shader,'f','amount',amount.get());
amount.onChange=function(){ uniAmount.setValue(amount.get()); };

var textureAlpha=new CGL.Uniform(shader,'t','imageMask',1);



var dir=0;

direction.onChange=function()
{
    if(direction.get()=='both')dir=0;
    if(direction.get()=='horizontal')dir=1;
    if(direction.get()=='vertical')dir=2;
};

var mask=op.inTexture("mask");

mask.onChange=function()
{
    if(mask.get() && mask.get().tex) shader.define('HAS_MASK');
        else shader.removeDefine('HAS_MASK');
};



render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    // first pass
    if(dir===0 || dir==2)
    {

        cgl.currentTextureEffect.bind();
        cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


        if(mask.get() && mask.get().tex)
        {
            cgl.setTexture(1, mask.get().tex );
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, mask.get().tex );
        }


        uniDirX.setValue(0.0);
        uniDirY.setValue(1.0);

        cgl.currentTextureEffect.finish();
    }

    // second pass
    if(dir===0 || dir==1)
    {

        cgl.currentTextureEffect.bind();
        cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


        if(mask.get() && mask.get().tex)
        {
            cgl.setTexture(1, mask.get().tex );
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, mask.get().tex );
        }

        uniDirX.setValue(1.0);
        uniDirY.setValue(0.0);

        cgl.currentTextureEffect.finish();
    }

    cgl.setPreviousShader();
    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Blur.prototype = new CABLES.Op();
CABLES.OPS["54f26f53-f637-44c1-9bfb-a2f2b722e998"]={f:Ops.Gl.TextureEffects.Blur,objName:"Ops.Gl.TextureEffects.Blur"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.EdgeDetection3
// 
// **************************************************************

Ops.Gl.TextureEffects.EdgeDetection3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={edgedetect_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float width;\nUNI float strength;\nUNI float texWidth;\nUNI float texHeight;\nUNI float mulColor;\n\nconst vec4 lumcoeff = vec4(0.299,0.587,0.114, 0.);\n\nvec3 desaturate(vec3 color)\n{\n    return vec3(dot(vec3(0.2126,0.7152,0.0722), color));\n}\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    // vec4 col=vec4(1.0,0.0,0.0,1.0);\n\n    // float pixelX=0.27/texWidth;\n    // float pixelY=0.27/texHeight;\n    float pixelX=(width+0.01)*4.0/texWidth;\n    float pixelY=(width+0.01)*4.0/texHeight;\n\nvec2 tc=texCoord;\n// #ifdef OFFSETPIXEL\n    tc.x+=1.0/texWidth*0.5;\n    tc.y+=1.0/texHeight*0.5;\n// #endif\n    // col=texture(tex,texCoord);\n\n    float count=1.0;\n\n\tvec4 horizEdge = vec4( 0.0 );\n\thorizEdge -= texture( tex, vec2( tc.x - pixelX, tc.y - pixelY ) ) * 1.0;\n\thorizEdge -= texture( tex, vec2( tc.x - pixelX, tc.y     ) ) * 2.0;\n\thorizEdge -= texture( tex, vec2( tc.x - pixelX, tc.y + pixelY ) ) * 1.0;\n\thorizEdge += texture( tex, vec2( tc.x + pixelX, tc.y - pixelY ) ) * 1.0;\n\thorizEdge += texture( tex, vec2( tc.x + pixelX, tc.y     ) ) * 2.0;\n\thorizEdge += texture( tex, vec2( tc.x + pixelX, tc.y + pixelY ) ) * 1.0;\n\tvec4 vertEdge = vec4( 0.0 );\n\tvertEdge -= texture( tex, vec2( tc.x - pixelX, tc.y - pixelY ) ) * 1.0;\n\tvertEdge -= texture( tex, vec2( tc.x    , tc.y - pixelY ) ) * 2.0;\n\tvertEdge -= texture( tex, vec2( tc.x + pixelX, tc.y - pixelY ) ) * 1.0;\n\tvertEdge += texture( tex, vec2( tc.x - pixelX, tc.y + pixelY ) ) * 1.0;\n\tvertEdge += texture( tex, vec2( tc.x    , tc.y + pixelY ) ) * 2.0;\n\tvertEdge += texture( tex, vec2( tc.x + pixelX, tc.y + pixelY ) ) * 1.0;\n\n\n\tvec3 edge = sqrt((horizEdge.rgb/count * horizEdge.rgb/count) + (vertEdge.rgb/count * vertEdge.rgb/count));\n\n    edge=desaturate(edge);\n    edge*=strength;\n\n    if(mulColor>0.0) edge*=texture( tex, texCoord ).rgb*mulColor*4.0;\n    edge=max(min(edge,1.0),0.0);\n\n    //blend section\n    vec4 col=vec4(edge,1.0);\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,col,amount);\n}\n\n",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    strength=op.inFloat("Strength",4.0),
    width=op.inValueSlider("Width",0.1),
    mulColor=op.inValueSlider("Mul Color",0),
    // offsetPixel=op.inBool("Offset Pixel",false),
    trigger=op.outTrigger("Trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);
// offsetPixel.onChange=updateOffsetPixel;

shader.setSource(shader.getDefaultVertexShader(),attachments.edgedetect_frag);

// updateOffsetPixel();

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    strengthUniform=new CGL.Uniform(shader,'f','strength',strength),
    widthUniform=new CGL.Uniform(shader,'f','width',width),
    uniWidth=new CGL.Uniform(shader,'f','texWidth',128),
    uniHeight=new CGL.Uniform(shader,'f','texHeight',128),
    uniMulColor=new CGL.Uniform(shader,'f','mulColor',mulColor);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

// function updateOffsetPixel()
// {
//     shader.toggleDefine('OFFSETPIXEL',offsetPixel.get());
// }

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.EdgeDetection3.prototype = new CABLES.Op();
CABLES.OPS["3cdc351c-8d6e-4d3d-8da0-0777a6062c0d"]={f:Ops.Gl.TextureEffects.EdgeDetection3,objName:"Ops.Gl.TextureEffects.EdgeDetection3"};




// **************************************************************
// 
// Ops.Gl.Matrix.Camera
// 
// **************************************************************

Ops.Gl.Matrix.Camera = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const trigger=op.outTrigger("trigger");

/* Inputs */
// projection | prespective & ortogonal
const projectionMode=op.inValueSelect("projection mode",['prespective','ortogonal'], 'prespective');
const zNear=op.inValue("frustum near",0.01);
const zFar=op.inValue("frustum far",5000.0);

const fov=op.inValue("fov",45);
const autoAspect=op.inValueBool("Auto Aspect Ratio",true);
const aspect=op.inValue("Aspect Ratio",1);

// look at camera
const eyeX=op.inValue("eye X",0);
const eyeY=op.inValue("eye Y",0);
const eyeZ=op.inValue("eye Z",5);

const centerX=op.inValue("center X",0);
const centerY=op.inValue("center Y",0);
const centerZ=op.inValue("center Z",0);

// camera transform and movements
const posX=op.inValue("truck",0);
const posY=op.inValue("boom",0);
const posZ=op.inValue("dolly",0);

const rotX=op.inValue("tilt",0);
const rotY=op.inValue("pan",0);
const rotZ=op.inValue("roll",0);


/* Outputs */
const outAsp=op.outValue("Aspect");
const outArr=op.outArray("Look At Array");

/* logic */
var cgl=op.patch.cgl;

var asp=0;

var vUp=vec3.create();
var vEye=vec3.create();
var vCenter=vec3.create();
var transMatrix=mat4.create();
mat4.identity(transMatrix);

var arr=[];

// Transform and move
var vPos=vec3.create();
var transMatrixMove=mat4.create();
mat4.identity(transMatrixMove);

var updateCameraMovementMatrix=true;

render.onTriggered=function() {
    // Aspect ration
    if(!autoAspect.get()) asp=aspect.get();
    else asp=cgl.getViewPort()[2]/cgl.getViewPort()[3];
    outAsp.set(asp);

    // translation (truck, boom, dolly)
    cgl.pushViewMatrix();

    if (updateCameraMovementMatrix) {
        mat4.identity(transMatrixMove);

        vec3.set(vPos, posX.get(),posY.get(),posZ.get());
        if(posX.get()!==0.0 || posY.get()!==0.0 || posZ.get()!==0.0)
            mat4.translate(transMatrixMove,transMatrixMove, vPos);

        if(rotX.get()!==0)
            mat4.rotateX(transMatrixMove,transMatrixMove, rotX.get()*CGL.DEG2RAD);
        if(rotY.get()!==0)
            mat4.rotateY(transMatrixMove,transMatrixMove, rotY.get()*CGL.DEG2RAD);
        if(rotZ.get()!==0)
            mat4.rotateZ(transMatrixMove,transMatrixMove, rotZ.get()*CGL.DEG2RAD);

        updateCameraMovementMatrix = false;
    }

    mat4.multiply(cgl.vMatrix,cgl.vMatrix,transMatrixMove);

    // projection (prespective / ortogonal)
    cgl.pushPMatrix();

    // look at
    cgl.pushViewMatrix();

    if (projectionMode.get()=='prespective') {
        mat4.perspective(
            cgl.pMatrix,
            fov.get()*0.0174533,
            asp,
            zNear.get(),
            zFar.get()
        );
    } else if (projectionMode.get()=='ortogonal') {
        mat4.ortho(
            cgl.pMatrix,
            -1 * (fov.get() / 14),
             1 * (fov.get() / 14),
            -1 * (fov.get() / 14) / asp,
             1 * (fov.get() / 14) / asp,
            zNear.get(),
            zFar.get()
        );
    }


	arr[0]=eyeX.get();
	arr[1]=eyeY.get();
	arr[2]=eyeZ.get();

	arr[3]=centerX.get();
	arr[4]=centerY.get();
	arr[5]=centerZ.get();

	arr[6]=0;
	arr[7]=1;
	arr[8]=0;

    outArr.set(null);
	outArr.set(arr);

	vec3.set(vUp, 0, 1, 0);
	vec3.set(vEye, eyeX.get(),eyeY.get(),eyeZ.get());
	vec3.set(vCenter, centerX.get(),centerY.get(),centerZ.get());

	mat4.lookAt(transMatrix, vEye, vCenter, vUp);

	mat4.multiply(cgl.vMatrix,cgl.vMatrix,transMatrix);

	trigger.trigger();

	cgl.popViewMatrix();
	cgl.popPMatrix();

	cgl.popViewMatrix();


	// GUI for dolly, boom and truck
	if(CABLES.UI && gui.patch().isCurrentOp(op))
		gui.setTransformGizmo({
			posX:posX,
			posY:posY,
			posZ:posZ
		});
};

var updateUI=function() {
	if(!autoAspect.get()) {
		aspect.setUiAttribs({hidePort:false,greyout:false});
	} else {
		aspect.setUiAttribs({hidePort:true,greyout:true});
	}
};

var cameraMovementChanged=function() {
	updateCameraMovementMatrix = true;
};

// listeners
posX.onChange=cameraMovementChanged;
posY.onChange=cameraMovementChanged;
posZ.onChange=cameraMovementChanged;

rotX.onChange=cameraMovementChanged;
rotY.onChange=cameraMovementChanged;
rotZ.onChange=cameraMovementChanged;

autoAspect.onChange=updateUI;
updateUI();




};

Ops.Gl.Matrix.Camera.prototype = new CABLES.Op();
CABLES.OPS["b24dbfdc-485c-49d2-92a1-7258efd9239a"]={f:Ops.Gl.Matrix.Camera,objName:"Ops.Gl.Matrix.Camera"};




// **************************************************************
// 
// Ops.Gl.Meshes.Cube
// 
// **************************************************************

Ops.Gl.Meshes.Cube = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger('render'),
    width=op.inValue('width',1),
    height=op.inValue('height',1),
    lengt=op.inValue('length',1),
    center=op.inValueBool('center',true),
    active=op.inValueBool('Active',true),
    trigger=op.outTrigger('trigger'),
    geomOut=op.outObject("geometry");

const cgl=op.patch.cgl;

op.setPortGroup("Geometry",[width,height,lengt]);

var geom=null;
var mesh=null;

width.onChange=buildMesh;
height.onChange=buildMesh;
lengt.onChange=buildMesh;
center.onChange=buildMesh;

buildMesh();


render.onTriggered=function()
{
    if(active.get() && mesh) mesh.render(cgl.getShader());
    trigger.trigger();
};

op.preRender=function()
{
    buildMesh();
    mesh.render(cgl.getShader());
};

function buildMesh()
{
    if(!geom)geom=new CGL.Geometry("cubemesh");
    geom.clear();

    var x=width.get();
    var nx=-1*width.get();
    var y=lengt.get();
    var ny=-1*lengt.get();
    var z=height.get();
    var nz=-1*height.get();

    if(!center.get())
    {
        nx=0;
        ny=0;
        nz=0;
    }
    else
    {
        x*=0.5;
        nx*=0.5;
        y*=0.5;
        ny*=0.5;
        z*=0.5;
        nz*=0.5;
    }

    geom.vertices = [
        // Front face
        nx, ny,  z,
        x, ny,  z,
        x,  y,  z,
        nx,  y,  z,
        // Back face
        nx, ny, nz,
        nx,  y, nz,
        x,  y, nz,
        x, ny, nz,
        // Top face
        nx,  y, nz,
        nx,  y,  z,
        x,  y,  z,
        x,  y, nz,
        // Bottom face
        nx, ny, nz,
        x, ny, nz,
        x, ny,  z,
        nx, ny,  z,
        // Right face
        x, ny, nz,
        x,  y, nz,
        x,  y,  z,
        x, ny,  z,
        // zeft face
        nx, ny, nz,
        nx, ny,  z,
        nx,  y,  z,
        nx,  y, nz
        ];

    geom.setTexCoords( [
          // Front face
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          // Back face
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          // Top face
          0.0, 0.0,
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          // Bottom face
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          1.0, 1.0,
          // Right face
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          // Left face
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
        ]);

    geom.vertexNormals = [
        // Front face
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,

        // Back face
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,

        // Top face
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,

        // Bottom face
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,

        // Right face
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,

        // Left face
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0
    ];
    geom.tangents = [
        // front face
        -1,0,0, -1,0,0, -1,0,0, -1,0,0,
        // back face
        1,0,0, 1,0,0, 1,0,0, 1,0,0,
        // top face
        1,0,0, 1,0,0, 1,0,0, 1,0,0,
        // bottom face
        -1,0,0, -1,0,0, -1,0,0, -1,0,0,
        // right face
        0,0,-1, 0,0,-1, 0,0,-1, 0,0,-1,
        // left face
        0,0,1, 0,0,1, 0,0,1, 0,0,1
    ];
    geom.biTangents = [
        // front face
        0,-1,0, 0,-1,0, 0,-1,0, 0,-1,0,
        // back face
        0,1,0, 0,1,0, 0,1,0, 0,1,0,
        // top face
        0,0,-1, 0,0,-1, 0,0,-1, 0,0,-1,
        // bottom face
        0,0,1, 0,0,1, 0,0,1, 0,0,1,
        // right face
        0,1,0, 0,1,0, 0,1,0, 0,1,0,
        // left face
        0,1,0, 0,1,0, 0,1,0, 0,1,0
    ];

    geom.verticesIndices = [
        0, 1, 2,      0, 2, 3,    // Front face
        4, 5, 6,      4, 6, 7,    // Back face
        8, 9, 10,     8, 10, 11,  // Top face
        12, 13, 14,   12, 14, 15, // Bottom face
        16, 17, 18,   16, 18, 19, // Right face
        20, 21, 22,   20, 22, 23  // Left face
    ];

    if(mesh)mesh.dispose();
    mesh=new CGL.Mesh(cgl,geom);
    geomOut.set(null);
    geomOut.set(geom);
}


op.onDelete=function()
{
    if(mesh)mesh.dispose();
}

};

Ops.Gl.Meshes.Cube.prototype = new CABLES.Op();
CABLES.OPS["ff0535e2-603a-4c07-9ce6-e9e0db857dfe"]={f:Ops.Gl.Meshes.Cube,objName:"Ops.Gl.Meshes.Cube"};




// **************************************************************
// 
// Ops.Admin.SimosPhong
// 
// **************************************************************

Ops.Admin.SimosPhong = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={simosphong_frag:"\n// https://www.mathematik.uni-marburg.de/~thormae/lectures/graphics1/code/WebGLShaderLightMat/ShaderLightMat.html\nstruct Material {\n\tvec3 ambient;\n\tvec3 diffuse;\n\tvec3 specular;\n\tfloat shininess;\n\tfloat specularCoefficient;\n};\n\nstruct Light {\n vec3 position;\n vec3 color;\n vec3 ambient;\n vec3 specular;\n int type;\n float intensity;\n float radius;\n float falloff;\n float ambientCoefficient;\n float constantAttenuation;\n float linearAttenuation;\n float quadraticAttenuation;\n float coneAngle;\n float cosConeAngle;\n float coneAngleInner;\n float cosConeAngleInner;\n float spotExponent;\n vec3 conePointAt;\n};\n\nuniform Material material;\nuniform Light light;\nuniform vec3 ambient;\n\nUNI mat4 projMatrix;\nUNI mat4 viewMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 normalMatrix;\n\n#ifdef HAS_TEXTURE_DIFFUSE\nUNI sampler2D texDiffuse;\n#endif\n\n#ifdef HAS_TEXTURE_SPECULAR\nUNI sampler2D texSpecular;\n#endif\n\n#ifdef HAS_TEXTURE_NORMAL\nUNI sampler2D texNormal;\n#endif\n\n#ifdef HAS_TEXTURE_AO\nUNI sampler2D texAO;\n#endif\n\nUNI float inDiffuseR;\nUNI float inDiffuseG;\nUNI float inDiffuseB;\nUNI float shininess;\nUNI float inSpecularCoefficient;\n\nUNI float inNormalIntensity;\n\nUNI int numLights;\nUNI vec3 camPos;\nUNI Light[MAX_LIGHTS] lights;\n\nUNI float intensity;\nUNI float constantAttenuation;\nUNI float linearAttenuation;\nUNI float quadraticAttenuation;\n\nUNI float inAlpha;\n\nIN vec2 texCoord;\nIN vec3 norm;\nIN vec3 normInterpolated;\nIN vec3 vertPosOut;\nIN vec3 noViewMatVertPos;\nIN vec3 fragPos;\nIN mat3 TBN_Matrix;\nIN mat3 mvMatrixMat3;\n\n\n#define PI 3.1415926535897932384626433832795\n#define NONE -1\n#define AMBIENT 0\n#define POINT 1\n#define DIRECTIONAL 2\n#define SPOT 3\n#define AREA 4\nconst float TWO_PI = 2.*PI;\nconst float EIGHT_PI = 8.*PI;\n{{MODULES_HEAD}}\n\n#ifdef CONSERVE_ENERGY\n// http://www.rorydriscoll.com/2009/01/25/energy-conservation-in-games/\nfloat EnergyConservation(float shininess) {\n    #ifndef SPECULAR_BLINN\n    return (shininess + 2.)/TWO_PI;\n    #endif\n    #ifdef SPECULAR_BLINN\n    return (shininess + 8.)/EIGHT_PI;\n    #endif\n}\n#endif\n\nfloat Attenuation(Light light, float distanceLightFrag)\n{\n    float denom = distanceLightFrag / light.radius; // + 1.0;\n    // float attenuation = 1.0 / (denom*denom);\n    float attenuation = light.intensity * (1./(light.constantAttenuation + 0.01*light.linearAttenuation*distanceLightFrag + light.quadraticAttenuation*0.001*(distanceLightFrag*distanceLightFrag)));\n\n    float t = (attenuation - 0.1) / (1.0 - 0.1);\n\n    //t = t * (light.falloff*light.falloff);\n\n    return min(1.0,max(t, 0.0));\n}\n\nvec3 AmbientLight(Light light, Material material) {\n    #ifdef HAS_TEXTURE_AO\n        light.color *= texture(texAO, texCoord).rgb;\n    #endif\n    return light.intensity*light.color; //*material.diffuse;\n}\nvec3 DirectionalLight(Light light, Material material) {\n    vec3 vertex = vertPosOut;\n    vec3 normal = normalize(normInterpolated);\n\n    #ifdef HAS_TEXTURE_NORMAL\n    normal = texture(texNormal, texCoord).rgb;\n    normal = normalize(normal * 2. - 1.);\n    normal = normalize(TBN_Matrix * normal);\n    #endif\n\n    #ifdef DOUBLE_SIDED\n    if(!gl_FrontFacing) normal = normal*-1.0;\n    #endif\n\n    vec3 viewDirection = normalize(camPos - fragPos);\n\n//    viewDirection = normalize(camPos - fragPos);\n    vec3 lightDirection = normalize(light.position);\n    float lambertian = max(dot(lightDirection, normal), 0.0);\n\n    vec3 ambientColor = vec3(0.);\n\n    #ifdef HAS_TEXTURE_DIFFUSE\n    vec2 uv = vec2(texCoord.s,1.0-texCoord.t);\n    ambientColor = vec3(0.); //light.ambient * vec3(texture(texDiffuse, uv));\n    #endif\n\n    vec3 diffuseColor = lambertian*material.diffuse*light.color;\n    vec3 specularColor = vec3(0.);\n    float attenuation = 1.;\n\n    if (lambertian > 0.0) {\n        #ifndef SPECULAR_BLINN\n        vec3 reflectDirection = reflect(-lightDirection, normal);\n        float specularAngle = max(dot(reflectDirection, viewDirection), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor = specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n\n        #endif\n\n        #ifdef SPECULAR_BLINN\n        vec3 halfDirection = normalize(lightDirection + viewDirection);\n        float specularAngle = max(dot(halfDirection, normal), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor = specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n        #endif\n\n        #ifdef CONSERVE_ENERGY\n        float conserveEnergyFactor = EnergyConservation(material.shininess);\n        specularColor = conserveEnergyFactor * specularColor;\n        #endif\n    } else {\n        attenuation = 0.;\n    }\n\n    return ambientColor + light.intensity*(diffuseColor + specularColor);\n}\n\nvec3 SpotLight(Light light, Material material) {\n    vec3 normal = normalize(normInterpolated);\n    #ifdef HAS_TEXTURE_NORMAL\n    normal = texture(texNormal, texCoord).rgb;\n    normal = normalize(normal * 2. - 1.);\n    normal.z *= (1. -inNormalIntensity);\n    normal = normalize(TBN_Matrix * normal);\n    #endif\n\n    #ifdef DOUBLE_SIDED\n    if(!gl_FrontFacing) normal = normal*-1.0;\n    #endif\n\n    vec3 lightDirection = normalize(light.position - fragPos);\n    vec3 viewDirection = normalize(camPos - fragPos);\n\n    // ambient\n    vec3 ambientColor = vec3(0.); //light.ambient*material.diffuse;\n\n    #ifdef HAS_TEXTURE_DIFFUSE\n    vec2 uv = vec2(texCoord.s,1.0-texCoord.t);\n    //ambientColor = light.ambient * vec3(texture(texDiffuse, uv));\n    #endif\n\n    // diffuse coefficient\n    float lambertian = max(dot(lightDirection, normal), 0.0);\n    vec3 diffuseColor = lambertian*material.diffuse*light.color;\n\n    vec3 specularColor = vec3(1.);\n\n\n    // attenuation\n    float distanceLightFrag = length(light.position - fragPos); //distance(light.position, noViewMatVertPos);\n    float attenuation = light.intensity * (1./(light.constantAttenuation + 0.01*light.linearAttenuation*distanceLightFrag + light.quadraticAttenuation*0.001*(distanceLightFrag*distanceLightFrag)));\n    //attenuation = Attenuation(light, distanceLightFrag);\n    if (lambertian > 0.0) {\n        #ifdef HAS_TEXTURE_SPECULAR\n        vec2 uv2 = vec2(texCoord.s, 1.0-texCoord.t);\n        specularColor = texture(texSpecular, texCoord).xyz;\n        #endif\n\n        // specular\n        #ifndef SPECULAR_BLINN\n        vec3 reflectDirection = reflect(-lightDirection, normal);\n        float specularAngle = max(dot(viewDirection, reflectDirection), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor *= specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n\n        #endif\n\n        #ifdef SPECULAR_BLINN\n        vec3 halfDirection = normalize(lightDirection + viewDirection);\n        float specularAngle = max(dot(halfDirection, normal), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor *= specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n        #endif\n\n        // * SPOT LIGHT *\n        vec3 spotLightDirection = -1.*normalize(light.position-light.conePointAt);\n        float spotAngle = dot(lightDirection, spotLightDirection);\n\n        if (spotAngle > light.cosConeAngle) {\n            attenuation = 0.;\n        } else {\n        float epsilon = light.cosConeAngle - light.cosConeAngleInner;\n\n        float spotIntensity = clamp((spotAngle - light.cosConeAngle)/epsilon, 0.0, 1.0);\n        spotIntensity = pow(spotIntensity, max(0.01, light.spotExponent));\n\n        diffuseColor *= spotIntensity;\n        specularColor *= spotIntensity;\n\n        }\n\n        #ifdef CONSERVE_ENERGY\n        float conserveEnergyFactor = EnergyConservation(material.shininess);\n        specularColor = conserveEnergyFactor * specularColor;\n        #endif\n    }\n    else {\n        attenuation = 0.;\n    }\n    return ambientColor+attenuation*(diffuseColor + specularColor);\n}\n\nvec3 PointLight(Light light, Material material) {\n\n\n    vec3 normal = normalize(normInterpolated);\n\n    #ifdef HAS_TEXTURE_NORMAL\n    normal = texture(texNormal, texCoord).rgb;\n    normal.b = inNormalIntensity*(1. - inNormalIntensity);\n    normal = normalize(normal * 2. - 1.);\n    normal = normalize(TBN_Matrix * normal);\n    #endif\n\n    #ifdef DOUBLE_SIDED\n    if(!gl_FrontFacing) normal = normal*-1.0;\n    #endif\n\n\n    vec3 lightDirection = normalize(light.position - fragPos);\n    vec3 viewDirection = normalize(camPos - fragPos);\n\n    // ambient\n    vec3 ambientColor = vec3(0.); //light.ambient*material.diffuse;\n\n    #ifdef HAS_TEXTURE_DIFFUSE\n    vec2 uv = vec2(texCoord.s,1.0-texCoord.t);\n    //ambientColor = light.ambient * vec3(texture(texDiffuse, uv));\n    #endif\n\n    // diffuse coefficient\n    float lambertian = max(dot(lightDirection, normal), 0.0);\n    vec3 diffuseColor = lambertian*material.diffuse*light.color;\n\n    vec3 specularColor = vec3(0.);\n\n    // attenuation\n    float distanceLightFrag = length(light.position - fragPos); //distance(light.position, noViewMatVertPos);\n    float attenuation = light.intensity * (1./(light.constantAttenuation + light.linearAttenuation*distanceLightFrag + light.quadraticAttenuation*(distanceLightFrag*distanceLightFrag)));\n\n    if (lambertian > 0.0) {\n        // specular\n        #ifndef SPECULAR_BLINN\n        vec3 reflectDirection = reflect(-lightDirection, normal);\n        float specularAngle = max(dot(viewDirection, reflectDirection), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor = specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n        #endif\n\n        #ifdef SPECULAR_BLINN\n        vec3 halfDirection = normalize(lightDirection + viewDirection);\n        float specularAngle = max(dot(halfDirection, normal), 0.);\n        float specularFactor = pow(specularAngle, max(0.01, 1. - material.shininess)*256.);\n        specularColor = specularFactor * material.specularCoefficient * light.color * light.specular; // * material.diffuse;\n        #endif\n\n        #ifdef CONSERVE_ENERGY\n        float conserveEnergyFactor = EnergyConservation(material.shininess);\n        specularColor = conserveEnergyFactor * specularColor;\n        #endif\n    }\n    else {\n        attenuation = 0.;\n    }\n    return ambientColor+attenuation*(diffuseColor + specularColor);\n}\n\nvoid main() {\n    {{MODULE_BEGIN_FRAG}}\n    {{MODULE_COLOR}}\n\n    vec3 normal = normalize(normInterpolated);\n    vec3 vertex = vertPosOut;\n\n    vec3 ambientColor = vec3(1.);\n    vec3 specularColor = vec3(1.);\n    vec3 diffuseColor = vec3(1.);\n    Material _material = material;\n    _material.diffuse = vec3(inDiffuseR, inDiffuseG, inDiffuseB);\n    _material.shininess = shininess;\n    _material.specularCoefficient = inSpecularCoefficient;\n    float alpha = inAlpha;\n    #ifdef HAS_TEXTURES\n        vec2 uv = vec2(texCoord.s, 1.0-texCoord.t);\n\n       #ifdef HAS_TEXTURE_DIFFUSE\n            _material.diffuse = texture(texDiffuse,uv).xyz;\n            #ifdef COLORIZE_TEXTURE\n                _material.diffuse *= vec3(inDiffuseR, inDiffuseG, inDiffuseB);\n            #endif\n            alpha = inAlpha * texture(texDiffuse,uv).a;\n        #endif\n\n        #ifdef HAS_TEXTURE_SPECULAR\n            vec2 uv2 = vec2(texCoord.s, 1.0-texCoord.t);\n            _material.specular = texture(texSpecular, texCoord).xyz;\n        #endif\n\n        #ifdef HAS_TEXTURE_NORMAL\n        // TODO: calc tangentspace light dir and view dir in vertex shader instead of normal transform here\n        normal = texture(texNormal, texCoord).rgb;\n        normal = normalize(normal * 2. - 1.);\n        normal = normalize(TBN_Matrix * normal);\n        #endif\n\n    #endif\n\n    vec3 color = vec3(0.);\n\n    for (int i = 0; i < MAX_LIGHTS; i++) {\n        Light light = lights[i];\n        if (light.type == POINT) {\n            color = PointLight(light, _material);\n        }\n        else if (light.type == SPOT) {\n            color = SpotLight(light, _material);\n            //continue;\n        }\n        else if (light.type == DIRECTIONAL) {\n            color = DirectionalLight(light, _material);\n        }\n        else if (light.type == AMBIENT) {\n            color = AmbientLight(light, _material);\n        }\n         else {\n            continue;\n        }\n\n        outColor += vec4(color, inAlpha);\n    }\n\n}\n\n\n",simosphong_vert:"\n{{MODULES_HEAD}}\nIN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\nIN float attrVertIndex;\nIN vec3 attrTangent;\nIN vec3 attrBiTangent;\n\nOUT vec2 texCoord;\nOUT vec3 norm;\nOUT vec3 normInterpolated;\nOUT vec3 vertPosOut;\nOUT vec3 noViewMatVertPos;\nOUT vec3 v_Vertex;\nOUT vec3 fragPos;\nOUT mat3 TBN_Matrix; // tangent bitangent normal space transform matrix\nOUT mat3 mvMatrixMat3;\n\n#ifdef HAS_TEXTURES\n    UNI float inDiffuseRepeatX;\n    UNI float inDiffuseRepeatY;\n    UNI float inTextureOffsetX;\n    UNI float inTextureOffsetY;\n#endif\n\nUNI vec3 camPos;\nUNI mat4 projMatrix;\nUNI mat4 viewMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 normalMatrix;\nUNI mat4 transMatrix;\nmat3 transposeMat3(mat3 m)\n{\n    return mat3(m[0][0], m[1][0], m[2][0],\n        m[0][1], m[1][1], m[2][1],\n        m[0][2], m[1][2], m[2][2]);\n}\n\nmat3 inverseMat3(mat3 m)\n{\n    float a00 = m[0][0], a01 = m[0][1], a02 = m[0][2];\n    float a10 = m[1][0], a11 = m[1][1], a12 = m[1][2];\n    float a20 = m[2][0], a21 = m[2][1], a22 = m[2][2];\n\n    float b01 = a22 * a11 - a12 * a21;\n    float b11 = -a22 * a10 + a12 * a20;\n    float b21 = a21 * a10 - a11 * a20;\n\n    float det = a00 * b01 + a01 * b11 + a02 * b21;\n\n    return mat3(b01, (-a22 * a01 + a02 * a21), (a12 * a01 - a02 * a11),\n        b11, (a22 * a00 - a02 * a20), (-a12 * a00 + a02 * a10),\n        b21, (-a21 * a00 + a01 * a20), (a11 * a00 - a01 * a10)) / det;\n}\n\nvoid main()\n{\n   mat4 mMatrix=modelMatrix;\n   mat4 MV_Matrix = (viewMatrix * mMatrix);\n   vec4 pos=vec4(vPosition,  1.0);\n   mvMatrixMat3 = mat3(MV_Matrix);\n   texCoord=attrTexCoord;\n   norm=attrVertNormal;\n   vec4 cameraSpace_pos = MV_Matrix * pos;\n   {{MODULE_VERTEX_POSITION}}\n    #ifdef HAS_TEXTURES\n        texCoord.x=texCoord.x*inDiffuseRepeatX+inTextureOffsetX;\n        texCoord.y=texCoord.y*inDiffuseRepeatY+inTextureOffsetY;\n    #endif\n   //vec3 _norm = ((viewMatrix*mMatrix)* vec4(norm, 0.0)).xyz;\n   vec3 norm = transposeMat3(inverseMat3(mat3(mMatrix)))*norm;\n   normInterpolated = norm;\n   vec3 normCameraSpace = normalize((mMatrix * vec4(attrVertNormal, 1.0)).xyz);\n   vec3 tangCameraSpace = normalize((mMatrix * vec4(attrTangent, 1.0)).xyz);\n   vec3 bitangCameraSpace = normalize((mMatrix * vec4(attrBiTangent, 1.0)).xyz);\n   //normInterpolated = vec3(normalMatrix*vec4(norm, 1.0));\n   //normInterpolated = (transpose(inverse(mMatrix))*vec4(norm, 1.0)).xyz;\n\n   // * TODO: Transform lightDir and viewDir to TBN space here in vertex shader\n   // * TODO: dont transfer normals from normalmap to world space in fragment\n   // * TODO: since TBN is an orthogonal matrix, we can use transpose instead of inverse A^T = A^-1\n   TBN_Matrix = mat3(tangCameraSpace, bitangCameraSpace, normCameraSpace);\n\n   //TBN_Matrix =\n   fragPos = vec3((mMatrix) * pos);\n   vertPosOut = vec3(cameraSpace_pos.xyz); ///_vertPosOut.w;\n\n   noViewMatVertPos = vec3((mMatrix) * pos);\n\n\n\n   gl_Position = projMatrix * (viewMatrix*mMatrix) * pos;\n}",};

function Light(config) {
     this.type = config.type || "point";
     this.color = config.color || [1, 1, 1];
     this.specular = config.specular || [0, 0, 0];
     this.position = config.position || null;
     this.intensity = config.intensity || 1;
     this.constantAttenuation = config.constantAttenuation || 0;
     this.linearAttenuation = config.linearAttenuation || 0;
     this.quadraticAttenuation = config.quadraticAttenuation || 0;
     this.spotExponent = config.spotExponent || 1;
     this.cosConeAngleInner = Math.cos(CGL.DEG2RAD*config.coneAngleInner) || 0; // spot light
     this.coneAngleInner = config.coneAngleInner;
     this.coneAngle = config.coneAngle || 0; // spot light
     this.cosConeAngle = config.cosConeAngle || 0;
     this.conePointAt = config.conePointAt || [0, 0, 0];
     return this;
}


const cgl = op.patch.cgl;
const inTrigger = op.inTrigger("Trigger In");


// * DIFFUSE *
const inDiffuseR = op.inFloat("R", Math.random());
const inDiffuseG = op.inFloat("G", Math.random());
const inDiffuseB = op.inFloat("B", Math.random());
const inDiffuseA = op.inFloatSlider("A", 1);
inDiffuseR.setUiAttribs({ colorPick: true });
const diffuseColors = [inDiffuseR, inDiffuseG, inDiffuseB, inDiffuseA];
op.setPortGroup("Color", diffuseColors);


// * SPECULAR *
const inShininess = op.inFloatSlider("Shininess", 1);
const inSpecularCoefficient = op.inFloatSlider("Specular Coefficient", 1);
const specularColors = [inShininess, inSpecularCoefficient];
op.setPortGroup("Specular", specularColors);



// * LIGHT *
const inBlinn = op.inValueBool("Blinn Reflection Model", false);
const inEnergyConservation = op.inValueBool("Energy Conservation", false);
const inToggleDoubleSided = op.inBool("Double Sided Material", false);
const lightProps = [inBlinn, inEnergyConservation, inToggleDoubleSided];
op.setPortGroup("Light Options", lightProps);

// TEXTURES
const inDiffuseTexture = op.inTexture("Diffuse Texture");
const inSpecularTexture = op.inTexture("Specular Texture");
const inNormalTexture = op.inTexture("Normal Map");
const inAoTexture = op.inTexture("AO Texture");
op.setPortGroup("Textures",[inDiffuseTexture, inSpecularTexture, inNormalTexture, inAoTexture]);

// TEXTURE TRANSFORMS
const inColorizeTexture = op.inBool("Colorize Texture",false);
const inDiffuseRepeatX = op.inFloat("Diffuse Repeat X", 0);
const inDiffuseRepeatY = op.inFloat("Diffuse Repeat Y", 0);
const inTextureOffsetX = op.inFloat("Texture Offset X", 0);
const inTextureOffsetY = op.inFloat("Texture Offset Y", 0);
const inNormalIntensity = op.inFloatSlider("Normal Map Intensity");
op.setPortGroup("Texture Transforms",[inNormalIntensity, inColorizeTexture, inDiffuseRepeatY, inDiffuseRepeatX, inTextureOffsetY, inTextureOffsetX]);
function bindTextures() {
    if(inDiffuseTexture.get()) cgl.setTexture(0, inDiffuseTexture.get().tex);
    if (inSpecularTexture.get()) cgl.setTexture(1, inSpecularTexture.get().tex);
    if(inNormalTexture.get()) cgl.setTexture(2, inNormalTexture.get().tex);
    if (inAoTexture.get()) cgl.setTexture(3, inAoTexture.get().tex);
}


const outTrigger = op.outTrigger("Trigger Out");
const outLength = op.outNumber("NUM_LIGHTS");
const shaderOut = op.outObject("Shader");
shaderOut.ignoreValueSerialize = true;


const shader = new CGL.Shader(cgl,"simosphong");
shader.setModules(['MODULE_VERTEX_POSITION', 'MODULE_COLOR', 'MODULE_BEGIN_FRAG']);
shader.setSource(attachments.simosphong_vert, attachments.simosphong_frag);

let diffuseTextureUniform = null;
let specularTextureUniform = null;
let normalTextureUniform = null;
let aoTextureUniform = null;

inColorizeTexture.onChange = function() {
    shader.toggleDefine("COLORIZE_TEXTURE", inColorizeTexture.get());
}
function updateDiffuseTexture() {
    if (inDiffuseTexture.get()) {
            if(!shader.hasDefine('HAS_TEXTURE_DIFFUSE')) {
                shader.define('HAS_TEXTURE_DIFFUSE');
                if (!diffuseTextureUniform) diffuseTextureUniform = new CGL.Uniform(shader, 't', 'texDiffuse', 0);
            }
    } else {
                shader.removeUniform('texDiffuse');
                shader.removeDefine('HAS_TEXTURE_DIFFUSE');
                diffuseTextureUniform = null;
            }
}

function updateSpecularTexture() {
    if (inSpecularTexture.get()) {
        if(!shader.hasDefine('HAS_TEXTURE_SPECULAR')) {
            shader.define('HAS_TEXTURE_SPECULAR');
            if (!specularTextureUniform) specularTextureUniform = new CGL.Uniform(shader, 't', 'texSpecular', 1);
        }
    } else {
        shader.removeUniform('texSpecular');
        shader.removeDefine('HAS_TEXTURE_SPECULAR');
        specularTextureUniform = null;
        }
}

function updateNormalTexture() {
    if (inNormalTexture.get()) {
        if(!shader.hasDefine('HAS_TEXTURE_NORMAL')) {
            shader.define('HAS_TEXTURE_NORMAL');
            if (!normalTextureUniform) normalTextureUniform = new CGL.Uniform(shader, 't', 'texNormal', 2);
        }
    } else {
        shader.removeUniform('texNormal');
        shader.removeDefine('HAS_TEXTURE_NORMAL');
        normalTextureUniform = null;
        }
}

function updateAoTexture() {
        if (inAoTexture.get()) {
        if(!shader.hasDefine('HAS_TEXTURE_AO')) {
            shader.define('HAS_TEXTURE_AO');
            if (!aoTextureUniform) aoTextureUniform = new CGL.Uniform(shader, 't', 'texAO', 3);
        }
    } else {
        shader.removeUniform('texAO');
        shader.removeDefine('HAS_TEXTURE_AO');
        aoTextureUniform = null;
        }
}
inDiffuseTexture.onChange = updateDiffuseTexture;
inSpecularTexture.onChange = updateSpecularTexture;
inNormalTexture.onChange = updateNormalTexture;
inAoTexture.onChange = updateAoTexture;

const MAX_LIGHTS = 16;

shader.define('MAX_LIGHTS',MAX_LIGHTS.toString());
shader.bindTextures = bindTextures;

const LIGHT_TYPES = {
    none: -1,
    ambient: 0,
    point: 1,
    directional: 2,
    spot: 3,
};

inBlinn.onChange = function() {
    shader.toggleDefine("SPECULAR_BLINN", inBlinn.get());
}

inEnergyConservation.onChange = function() {
    shader.toggleDefine("CONSERVE_ENERGY", inEnergyConservation.get());
}

inToggleDoubleSided.onChange = function () {
    shader.toggleDefine("DOUBLE_SIDED", inToggleDoubleSided.get());
}

// * INIT UNIFORMS *
const initialUniforms = [
    new CGL.Uniform(shader, "i", "numLights", MAX_LIGHTS),
    new CGL.Uniform(shader, "f", "inDiffuseR", inDiffuseR),
    new CGL.Uniform(shader, "f", "inDiffuseG", inDiffuseG),
    new CGL.Uniform(shader, "f", "inDiffuseB", inDiffuseB),
    new CGL.Uniform(shader, "f", "inAlpha", inDiffuseA),
    new CGL.Uniform(shader, "f", "shininess", inShininess),
    new CGL.Uniform(shader, "f", "inSpecularCoefficient", inSpecularCoefficient),
    new CGL.Uniform(shader, "f", "inNormalIntensity", inNormalIntensity),
    new CGL.Uniform(shader, "f", "inDiffuseRepeatX", inDiffuseRepeatX),
    new CGL.Uniform(shader, "f", "inDiffuseRepeatY", inDiffuseRepeatY),
    new CGL.Uniform(shader, "f", "inTextureOffsetX", inTextureOffsetX),
    new CGL.Uniform(shader, "f", "inTextureOffsetY", inTextureOffsetY),
];

const lightUniforms = [];
const initialLight = new Light({
    type: "point",
    color: [1, 1, 1],
    specular: [1, 1, 1],
    position: [-1, 2, 2],
    intensity: 0.3,
    radius: 10,
    falloff: 0.5,
    constantAttenuation: 0.01,
    linearAttenuation: 0.069,
    quadraticAttenuation: 0.001,
    coneAngleInner: null,
    cosConeAngleInner: null,
    coneAngleOuter: null,
    spotExponent: null,
    coneAngle: null,
    conePointAt: null,
});

for (let i = 0; i < MAX_LIGHTS; i += 1) {
    lightUniforms.push({
        type: new CGL.Uniform(shader, "i", "lights" + "[" + i + "]" + ".type", i === 0 ? LIGHT_TYPES.point : LIGHT_TYPES.none),
        color: new CGL.Uniform(shader, "3f", "lights" + "[" + i + "]" + ".color", i === 0 ? initialLight.color : [0, 0, 0]),
        specular: new CGL.Uniform(shader, "3f", "lights" + "[" + i + "]" + ".specular", i === 0 ? initialLight.specular : [1, 1, 1]),
        position: new CGL.Uniform(shader, "3f", "lights" + "[" + i + "]" + ".position", i === 0 ? initialLight.position : [0, 0, 0]),
        intensity: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".intensity", i === 0 ? initialLight.intensity : 0),
        constantAttenuation: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".constantAttenuation", i === 0 ? initialLight.constantAttenuation : 0),
        linearAttenuation: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".linearAttenuation", i === 0 ? initialLight.linearAttenuation : 0),
        quadraticAttenuation: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".quadraticAttenuation", i === 0 ? initialLight.quadraticAttenuation : 0),
        radius: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".radius", i === 0 ? initialLight.radius : 0),
        falloff: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".falloff", i === 0 ? initialLight.falloff : 0),
        spotExponent: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".spotExponent", null),
        coneAngleInner: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".coneAngleInner", null),
        coneAngle: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".coneAngle", null),
        cosConeAngle: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".cosConeAngle", null),
        cosConeAngleInner: new CGL.Uniform(shader, "f", "lights" + "[" + i + "]" + ".cosConeAngleInner", null),
        conePointAt: new CGL.Uniform(shader, "3f", "lights" + "[" + i + "]" + ".conePointAt", null)
    });
};

const render = function() {
    if (!shader) {
        console.log("NO SHADER");
        return;
    }
    cgl.setShader(shader);
    shader.bindTextures();
    outTrigger.trigger();
    cgl.setPreviousShader();
}

op.init = function() {

}

op.preRender = function() {
    shader.bind();
    render();
}

inTrigger.onTriggered = function() {
    if (cgl.lightStack) {
        if (cgl.lightStack.length === 0) {
            // if there is no lights in the stack, we set the material back to its initialLight
            for (let i = 0; i < lightUniforms.length; i += 1) {
                if (i === 0) {
                    const keys = Object.keys(initialLight);

                    for (let j = 0; j < keys.length; j += 1) {
                        if (keys[j] === "type") {
                            lightUniforms[i][keys[j]].setValue(LIGHT_TYPES[initialLight[keys[j]]]);
                        }
                        else {
                            lightUniforms[i][keys[j]].setValue(initialLight[keys[j]]);

                        }
                    }
                } else {
                    lightUniforms[i].type.setValue(LIGHT_TYPES.none);
                }
            }
            render();
        } else {
            // we have lights in the stack
            for (let i = 0; i < MAX_LIGHTS; i += 1) {
                const light = cgl.lightStack[i];
                if (!light) {
                    lightUniforms[i].type.setValue(LIGHT_TYPES.none);

                    continue;
                }

                const keys = Object.keys(light);

                for (let j = 0; j < keys.length; j += 1) {
                    if (keys[j] === "type") lightUniforms[i][keys[j]].setValue(LIGHT_TYPES[light[keys[j]]]);
                    else lightUniforms[i][keys[j]].setValue(light[keys[j]]);
                }
            }
        render();
        }
    }
}

updateDiffuseTexture();
updateSpecularTexture();
updateNormalTexture();
updateAoTexture();

};

Ops.Admin.SimosPhong.prototype = new CABLES.Op();
CABLES.OPS["c88b306a-bc7f-4444-84ed-4ceb89b25f70"]={f:Ops.Admin.SimosPhong,objName:"Ops.Admin.SimosPhong"};




// **************************************************************
// 
// Ops.Admin.SimosPointLight
// 
// **************************************************************

Ops.Admin.SimosPointLight = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

function Light(config) {
     this.type = config.type || "point";
     this.color = config.color || [1, 1, 1];
     this.specular = config.specular || [0, 0, 0];
     this.position = config.position || null;
     this.intensity = config.intensity || 1;
     this.constantAttenuation = config.constantAttenuation || 0;
     this.linearAttenuation = config.linearAttenuation || 0;
     this.quadraticAttenuation = config.quadraticAttenuation || 0;
     this.radius = config.radius || 1;
     this.falloff = config.falloff || 1;
     this.spotExponent = config.spotExponent || 1;
     this.coneAngleInner = config.coneAngleInner || 0; // spot light
     this.coneAngle = config.coneAngle || 0; // spot light
     this.cosConeAngle = Math.cos(CGL.DEG2RAD * this.coneAngle);
     this.conePointAt = config.conePointAt || [0, 0, 0];
     return this;
}

Light.prototype.updateColor = () => {
    this.color = [0,1,2].map((_, i) => colorIn[i].get());
}

Light.prototype.updateColor = () => {
    this.color = [0,1,2].map((_, i) => colorIn[i].get());
}


Light.prototype.update = function(keys, ports) {
    if (keys)
        keys.forEach(key => {
            if (key === "color") {
                this.updateColor();
                return;
            }
            if (key === "position") {
                this.updatePosition();
            }
            this[key] = ports[key].get();
        });
}


// * OP START *
const inTrigger = op.inTrigger("Trigger In");

const inPosX = op.inFloat("X", 0);
const inPosY = op.inFloat("Y", 1);
const inPosZ = op.inFloat("Z", 0.75);

const positionIn = [inPosX, inPosY, inPosZ];
op.setPortGroup("Position", positionIn);

const inR = op.inFloat("R", 1);
const inG = op.inFloat("G", 1);
const inB = op.inFloat("B", 1);

inR.setUiAttribs({ colorPick: true });
const colorIn = [inR, inG, inB];
op.setPortGroup("Color", colorIn);

const inSpecularR = op.inFloat("Specular R", 0.1);
const inSpecularG = op.inFloat("Specular G", 0.1);
const inSpecularB = op.inFloat("Specular B", 0.1);

inSpecularR.setUiAttribs({ colorPick: true });
const colorSpecularIn = [inSpecularR, inSpecularG, inSpecularB];
op.setPortGroup("Specular Color", colorSpecularIn);


const inIntensity = op.inFloatSlider("Intensity", 1);
const inRadius = op.inFloat("Radius", 10);
const inFalloff = op.inFloatSlider("Falloff", 0.8);
const inConstantAttenuation = op.inFloatSlider("Constant Attenuation", 0.894);
const inLinearAttenuation = op.inFloatSlider("Linear Attenuation", 0.378);
const inQuadraticAttenuation = op.inFloatSlider("Quadratic Attenuation", 0.266);
const attribIns = [inIntensity, inRadius, inFalloff, inConstantAttenuation, inLinearAttenuation, inQuadraticAttenuation];
op.setPortGroup("Light Attributes", attribIns);

const outTrigger = op.outTrigger("Trigger Out");

const inLight = {
  position: [inPosX, inPosY, inPosZ],
  color: [inR, inG, inB],
  specular: [inSpecularR, inSpecularG, inSpecularB],
  intensity: inIntensity,
  constantAttenuation: inConstantAttenuation,
  linearAttenuation: inLinearAttenuation,
  quadraticAttenuation: inQuadraticAttenuation,
  radius: inRadius,
  falloff: inFalloff,
};

const cgl = op.patch.cgl;

const light = new Light({
    type: "point",
    position: [0, 1, 2].map(function(i){ return positionIn[i].get() }),
    color: [0 , 1, 2].map(function(i) { return colorIn[i].get() }),
    specular: [0 , 1, 2].map(function(i) { return colorSpecularIn[i].get() }),
    intensity: inIntensity.get(),
    constantAttenuation: inConstantAttenuation.get(),
    linearAttenuation: inLinearAttenuation.get(),
    quadraticAttenuation: inLinearAttenuation.get(),
    radius: inRadius.get(),
    falloff: inFalloff.get(),
});

Object.keys(inLight).forEach(function(key) {
    if (inLight[key].length) {
        for (let i = 0; i < inLight[key].length; i += 1) {
            inLight[key][i].onChange = function() {
                light[key][i] = inLight[key][i].get();
            }
        }
    } else {
        inLight[key].onChange = function() {
            light[key] = inLight[key].get();
        }
    }
});


inTrigger.onTriggered = function() {
    if (!cgl.lightStack) cgl.lightStack = [];

    if(CABLES.UI && gui.patch().isCurrentOp(op)) {
        gui.setTransformGizmo({
            posX:inPosX,
            posY:inPosY,
            posZ:inPosZ,
        });


    }
    cgl.lightStack.push(light);
    outTrigger.trigger();
    cgl.lightStack.pop();
}




};

Ops.Admin.SimosPointLight.prototype = new CABLES.Op();
CABLES.OPS["df61a65d-05c5-45c0-8107-d41fef689774"]={f:Ops.Admin.SimosPointLight,objName:"Ops.Admin.SimosPointLight"};




// **************************************************************
// 
// Ops.Gl.Texture
// 
// **************************************************************

Ops.Gl.Texture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var filename=op.inFile("file","image");
var tfilter=op.inSwitch("filter",['nearest','linear','mipmap']);
var wrap=op.inValueSelect("wrap",['repeat','mirrored repeat','clamp to edge'],"clamp to edge");
var flip=op.inValueBool("flip",false);
var unpackAlpha=op.inValueBool("unpackPreMultipliedAlpha",false);

var textureOut=op.outTexture("texture");
var width=op.outValue("width");
var height=op.outValue("height");
var loading=op.outValue("loading");
var ratio=op.outValue("Aspect Ratio");


op.setPortGroup("Size",[width,height]);

unpackAlpha.hidePort();

op.toWorkPortsNeedToBeLinked(textureOut);

const cgl=op.patch.cgl;
var cgl_filter=0;
var cgl_wrap=0;

filename.onChange=flip.onChange=function(){reloadSoon();};

tfilter.onChange=onFilterChange;
wrap.onChange=onWrapChange;
unpackAlpha.onChange=function(){ reloadSoon(); };

var timedLoader=0;

tfilter.set('mipmap');
wrap.set('repeat');

textureOut.set(CGL.Texture.getEmptyTexture(cgl));

var setTempTexture=function()
{
    var t=CGL.Texture.getTempTexture(cgl);
    textureOut.set(t);
};

var loadingId=null;
var tex=null;
function reloadSoon(nocache)
{
    // if(!loadingId)loadingId=cgl.patch.loading.start('textureOp',filename.get());

    // if(timedLoader!=0)
    // {
    //     console.log('tex load canceled...');
    // }
    clearTimeout(timedLoader);
    timedLoader=setTimeout(function()
    {
        // console.log('tex load yay...');
        realReload(nocache);
    },30);
}

function realReload(nocache)
{
    if(!loadingId)loadingId=cgl.patch.loading.start('textureOp',filename.get());

    var url=op.patch.getFilePath(String(filename.get()));
    if(nocache)url+='?rnd='+CABLES.generateUUID();

    if((filename.get() && filename.get().length>1))
    {
        loading.set(true);

        if(tex)tex.delete();
        tex=CGL.Texture.load(cgl,url,
            function(err)
            {
                if(err)
                {
                    setTempTexture();
                    op.uiAttr({'error':'could not load texture "'+filename.get()+'"'});
                    cgl.patch.loading.finished(loadingId);
                    return;
                }
                else op.uiAttr({'error':null});
                textureOut.set(tex);
                width.set(tex.width);
                height.set(tex.height);
                ratio.set(tex.width/tex.height);

                if(!tex.isPowerOfTwo()) op.uiAttr(
                    {
                        hint:'texture dimensions not power of two! - texture filtering will not work.',
                        warning:null
                    });
                    else op.uiAttr(
                        {
                            hint:null,
                            warning:null
                        });

                textureOut.set(null);
                textureOut.set(tex);
                // tex.printInfo();

            },{
                wrap:cgl_wrap,
                flip:flip.get(),
                unpackAlpha:unpackAlpha.get(),
                filter:cgl_filter
            });

        textureOut.set(null);
        textureOut.set(tex);

        if(!textureOut.get() && nocache)
        {
        }

        cgl.patch.loading.finished(loadingId);
    }
    else
    {
        cgl.patch.loading.finished(loadingId);
        setTempTexture();
    }
}

function onFilterChange()
{
    if(tfilter.get()=='nearest') cgl_filter=CGL.Texture.FILTER_NEAREST;
    if(tfilter.get()=='linear') cgl_filter=CGL.Texture.FILTER_LINEAR;
    if(tfilter.get()=='mipmap') cgl_filter=CGL.Texture.FILTER_MIPMAP;

    reloadSoon();
}

function onWrapChange()
{
    if(wrap.get()=='repeat') cgl_wrap=CGL.Texture.WRAP_REPEAT;
    if(wrap.get()=='mirrored repeat') cgl_wrap=CGL.Texture.WRAP_MIRRORED_REPEAT;
    if(wrap.get()=='clamp to edge') cgl_wrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

    reloadSoon();
}

op.onFileChanged=function(fn)
{
    if(filename.get() && filename.get().indexOf(fn)>-1)
    {
        textureOut.set(null);
        textureOut.set(CGL.Texture.getTempTexture(cgl));

        realReload(true);
    }
};







};

Ops.Gl.Texture.prototype = new CABLES.Op();
CABLES.OPS["466394d4-6c1a-4e5d-a057-0063ab0f096a"]={f:Ops.Gl.Texture,objName:"Ops.Gl.Texture"};




// **************************************************************
// 
// Ops.Gl.Meshes.FullscreenRectangle
// 
// **************************************************************

Ops.Gl.Meshes.FullscreenRectangle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={shader_frag:"UNI sampler2D tex;\nIN vec2 texCoord;\n\nvoid main()\n{\n   outColor= texture(tex,vec2(texCoord.x,(1.0-texCoord.y)));\n}\n",shader_vert:"{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nUNI mat4 projMatrix;\nUNI mat4 mvMatrix;\n\nOUT vec2 texCoord;\nIN vec2 attrTexCoord;\n\nvoid main()\n{\n   vec4 pos=vec4(vPosition,  1.0);\n\n   texCoord=attrTexCoord;\n\n   gl_Position = projMatrix * mvMatrix * pos;\n}\n",};
const
    render=op.inTrigger('render'),
    centerInCanvas=op.inValueBool("Center in Canvas"),
    flipY=op.inValueBool("Flip Y"),
    flipX=op.inValueBool("Flip X"),
    inTexture=op.inTexture("Texture"),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
var mesh=null;
var geom=new CGL.Geometry("fullscreen rectangle");
var x=0,y=0,z=0,w=0,h=0;

centerInCanvas.onChange=rebuild;
    flipX.onChange=rebuildFlip;
    flipY.onChange=rebuildFlip;

const shader=new CGL.Shader(cgl,'fullscreenrectangle');
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);

shader.setSource(attachments.shader_vert,attachments.shader_frag);
shader.fullscreenRectUniform=new CGL.Uniform(shader,'t','tex',0);

var useShader=false;
var updateShaderLater=true;
render.onTriggered=doRender;

op.toWorkPortsNeedToBeLinked(render);

inTexture.onChange=function()
{
    updateShaderLater=true;
};

function updateShader()
{
    var tex=inTexture.get();
    if(tex) useShader=true;
        else useShader=false;
}

op.preRender=function()
{
    updateShader();
    // if(useShader)
    {
        shader.bind();
        if(mesh)mesh.render(shader);
        doRender();
    }
};

function doRender()
{
    if( cgl.getViewPort()[2]!=w || cgl.getViewPort()[3]!=h ||!mesh ) rebuild();

    if(updateShaderLater) updateShader();

    cgl.pushPMatrix();
    mat4.identity(cgl.pMatrix);
    mat4.ortho(cgl.pMatrix, 0, w,h, 0, -10.0, 1000);

    cgl.pushModelMatrix();
    mat4.identity(cgl.mMatrix);

    cgl.pushViewMatrix();
    mat4.identity(cgl.vMatrix);

    if(centerInCanvas.get())
    {
        var x=0;
        var y=0;
        if(w<cgl.canvasWidth) x=(cgl.canvasWidth-w)/2;
        if(h<cgl.canvasHeight) y=(cgl.canvasHeight-h)/2;

        cgl.setViewPort(x,y,w,h);
    }

    if(useShader)
    {
        if(inTexture.get())
        {
            cgl.setTexture(0,inTexture.get().tex);
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, inTexture.get().tex);
        }

        mesh.render(shader);
    }
    else
    {
        mesh.render(cgl.getShader());
    }

    cgl.gl.clear(cgl.gl.DEPTH_BUFFER_BIT);

    cgl.popPMatrix();
    cgl.popModelMatrix();
    cgl.popViewMatrix();

    trigger.trigger();
}

function rebuildFlip()
{
    mesh=null;
}


function rebuild()
{
    const currentViewPort=cgl.getViewPort();

    if(currentViewPort[2]==w && currentViewPort[3]==h && mesh)return;

    var xx=0,xy=0;

    w=currentViewPort[2];
    h=currentViewPort[3];

    geom.vertices = new Float32Array([
         xx+w, xy+h,  0.0,
         xx,   xy+h,  0.0,
         xx+w, xy,    0.0,
         xx,   xy,    0.0
    ]);

    var tc=null;

    if(flipY.get())
        tc=new Float32Array([
            1.0, 0.0,
            0.0, 0.0,
            1.0, 1.0,
            0.0, 1.0
        ]);
    else
        tc=new Float32Array([
            1.0, 1.0,
            0.0, 1.0,
            1.0, 0.0,
            0.0, 0.0
        ]);

    if(flipX.get())
    {
        tc[0]=0.0;
        tc[2]=1.0;
        tc[4]=0.0;
        tc[6]=1.0;
    }

    geom.setTexCoords(tc);

    geom.verticesIndices = new Float32Array([
        2, 1, 0,
        3, 1, 2
    ]);


    geom.vertexNormals=new Float32Array([
        0,0,1,
        0,0,1,
        0,0,1,
        0,0,1,
        ]);
    geom.tangents=new Float32Array([
        -1,0,0,
        -1,0,0,
        -1,0,0,
        -1,0,0]);
    geom.biTangents==new Float32Array([
        0,-1,0,
        0,-1,0,
        0,-1,0,
        0,-1,0]);

                // norms.push(0,0,1);
                // tangents.push(-1,0,0);
                // biTangents.push(0,-1,0);


    if(!mesh) mesh=new CGL.Mesh(cgl,geom);
        else mesh.setGeom(geom);
}


};

Ops.Gl.Meshes.FullscreenRectangle.prototype = new CABLES.Op();
CABLES.OPS["255bd15b-cc91-4a12-9b4e-53c710cbb282"]={f:Ops.Gl.Meshes.FullscreenRectangle,objName:"Ops.Gl.Meshes.FullscreenRectangle"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ChromaticAberration
// 
// **************************************************************

Ops.Gl.TextureEffects.ChromaticAberration = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={chromatic_frag:"\nIN vec2 texCoord;\nUNI sampler2D tex;\nUNI float pixel;\nUNI float onePixel;\nUNI float amount;\nUNI float lensDistort;\n\n#ifdef MASK\nUNI sampler2D texMask;\n#endif\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n   vec4 base=texture(tex,texCoord);\n   vec4 col=texture(tex,texCoord);\n\n   vec2 tc=texCoord;;\n   float pix = pixel;\n   if(lensDistort>0.0)\n   {\n       float dist = distance(texCoord, vec2(0.5,0.5));\n       tc-=0.5;\n       tc *=smoothstep(-0.9,1.0*lensDistort,1.0-dist);\n       tc+=0.5;\n   }\n\n    #ifdef MASK\n        vec4 m=texture(texMask,texCoord);\n        pix*=m.r*m.a;\n    #endif\n\n    #ifdef SMOOTH\n    #ifdef WEBGL2\n        float numSamples=round(pix/onePixel/4.0+1.0);\n        col.r=0.0;\n        col.b=0.0;\n\n        for(float off=0.0;off<numSamples;off++)\n        {\n            float diff=(pix/numSamples)*off;\n            col.r+=texture(tex,vec2(tc.x+diff,tc.y)).r/numSamples;\n            col.b+=texture(tex,vec2(tc.x-diff,tc.y)).b/numSamples;\n        }\n    #endif\n    #endif\n\n    #ifndef SMOOTH\n        col.r=texture(tex,vec2(tc.x+pix,tc.y)).r;\n        col.b=texture(tex,vec2(tc.x-pix,tc.y)).b;\n    #endif\n\n//   outColor = col;\n   outColor= cgl_blend(base,col,amount);\n\n}\n",};
const
    render=op.inTrigger('render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    pixel=op.inValue("Pixel",5),
    lensDistort=op.inValueSlider("Lens Distort",0),
    doSmooth=op.inValueBool("Smooth",false),
    textureMask=op.inTexture("Mask"),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,"chromatic");

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

shader.setSource(shader.getDefaultVertexShader(),attachments.chromatic_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0),
    uniPixel=new CGL.Uniform(shader,'f','pixel',0),
    uniOnePixel=new CGL.Uniform(shader,'f','onePixel',0),
    unitexMask=new CGL.Uniform(shader,'t','texMask',1),
    uniAmount=new CGL.Uniform(shader,'f','amount',amount),
    unilensDistort=new CGL.Uniform(shader,'f','lensDistort',lensDistort);

doSmooth.onChange=function()
{
    if(doSmooth.get())shader.define("SMOOTH");
    else shader.removeDefine("SMOOTH");
};

textureMask.onChange=function()
{
    if(textureMask.get())shader.define("MASK");
    else shader.removeDefine("MASK");
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    uniPixel.setValue(pixel.get()*(1/texture.width));
    uniOnePixel.setValue(1/texture.width);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );

    if(textureMask.get()) cgl.setTexture(1, textureMask.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.ChromaticAberration.prototype = new CABLES.Op();
CABLES.OPS["38ac43a1-1757-48f4-9450-29f07ac0d376"]={f:Ops.Gl.TextureEffects.ChromaticAberration,objName:"Ops.Gl.TextureEffects.ChromaticAberration"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Vignette_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.Vignette_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={vignette_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float lensRadius1;\nUNI float aspect;\nUNI float amount;\nUNI float strength;\nUNI float sharp;\n\nUNI float r,g,b;\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec4 vcol=vec4(r,g,b,1.0);\n    vec4 col=texture(tex,texCoord);\n    vec2 tcPos=vec2(texCoord.x,(texCoord.y-0.5)*aspect+0.5);\n    float dist = distance(tcPos, vec2(0.5,0.5));\n    float am = (1.0-smoothstep( (lensRadius1+0.5), (lensRadius1*0.99+0.5)*sharp, dist));\n\n    col=mix(col,vcol,am*strength);\n    vec4 base=texture(tex,texCoord);\n\n\n    outColor=cgl_blend(base,col,amount);\n\n\n\n}\n",};
const
     render=op.inTrigger("Render"),
     blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
     amount=op.inValueSlider("Amount",1),
     trigger=op.outTrigger("Trigger"),
     strength=op.inValueSlider("Strength",1),
     lensRadius1=op.inValueSlider("Radius",0.3),
     sharp=op.inValueSlider("Sharp",0.25),
     aspect=op.inValue("Aspect",1),
     r = op.inValueSlider("r", 0),
     g = op.inValueSlider("g", 0),
     b = op.inValueSlider("b", 0);

r.setUiAttribs({ colorPick: true });

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'vignette');

shader.setSource(shader.getDefaultVertexShader(),attachments.vignette_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    uniLensRadius1=new CGL.Uniform(shader,'f','lensRadius1',lensRadius1),
    uniaspect=new CGL.Uniform(shader,'f','aspect',aspect),
    unistrength=new CGL.Uniform(shader,'f','strength',strength),
    unisharp=new CGL.Uniform(shader,'f','sharp',sharp),
    unir=new CGL.Uniform(shader,'f','r',r),
    unig=new CGL.Uniform(shader,'f','g',g),
    unib=new CGL.Uniform(shader,'f','b',b);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Vignette_v2.prototype = new CABLES.Op();
CABLES.OPS["ee274501-ac60-49ab-a854-80aa38c36f76"]={f:Ops.Gl.TextureEffects.Vignette_v2,objName:"Ops.Gl.TextureEffects.Vignette_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ColorBalance
// 
// **************************************************************

Ops.Gl.TextureEffects.ColorBalance = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={colorbalance_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float r;\nUNI float g;\nUNI float b;\n\nfloat lumi(vec3 color)\n{\n   return vec3(dot(vec3(0.2126,0.7152,0.0722), color)).r;\n}\n\nvoid main()\n{\n   vec3 base=texture(tex,texCoord).rgb;\n   float l=lumi(base);\n\n   #ifdef TONE_MID\n       l=smoothstep(0.33,0.66,l);\n   #endif\n   \n   #ifdef TONE_LOW\n       l=1.0-l;\n   #endif\n   \n   l=l*l;\n   vec3 color=base+vec3(l*r*0.1,l*g*0.1,l*b*0.1);\n   outColor= vec4(color,1.0);\n}\n",};
const render=op.inTrigger("render");
const trigger=op.outTrigger("trigger")
const tone=op.inValueSelect("Tone",["Highlights","Midtones","Shadows"],"Highlights");
const r=op.inValue("r");
const g=op.inValue("g");
const b=op.inValue("b");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.colorbalance_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const uniR=new CGL.Uniform(shader,'f','r',r);
const uniG=new CGL.Uniform(shader,'f','g',g);
const uniB=new CGL.Uniform(shader,'f','b',b);

tone.onChange=function()
{
    shader.removeDefine("TONE_HIGH");
    shader.removeDefine("TONE_MID");
    shader.removeDefine("TONE_LOW");
    if(tone.get()=="Highlights") shader.define("TONE_HIGH");
    if(tone.get()=="Midtones") shader.define("TONE_MID");
    if(tone.get()=="Shadows") shader.define("TONE_LOW");
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.ColorBalance.prototype = new CABLES.Op();
CABLES.OPS["24fc08e4-9a66-4fb9-9ebd-f72f6a986b24"]={f:Ops.Gl.TextureEffects.ColorBalance,objName:"Ops.Gl.TextureEffects.ColorBalance"};




// **************************************************************
// 
// Ops.Gl.ClearColor
// 
// **************************************************************

Ops.Gl.ClearColor = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    trigger=op.outTrigger("trigger"),
    r=op.inFloatSlider("r",0.1),
    g=op.inFloatSlider("g",0.1),
    b=op.inFloatSlider("b",0.1),
    a=op.inFloatSlider("a",1);

r.setUiAttribs({ colorPick: true });

const cgl=op.patch.cgl;

render.onTriggered=function()
{
    cgl.gl.clearColor(r.get(),g.get(),b.get(),a.get());
    cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);
    trigger.trigger();
};

};

Ops.Gl.ClearColor.prototype = new CABLES.Op();
CABLES.OPS["19b441eb-9f63-4f35-ba08-b87841517c4d"]={f:Ops.Gl.ClearColor,objName:"Ops.Gl.ClearColor"};




// **************************************************************
// 
// Ops.Ui.PatchInput
// 
// **************************************************************

Ops.Ui.PatchInput = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

op.getPatchOp=function()
{
    for(var i in op.patch.ops)
    {
        if(op.patch.ops[i].patchId)
        {
            if(op.patch.ops[i].patchId.get()==op.uiAttribs.subPatch)
            {
                return op.patch.ops[i];
            }
        }
    }
};


};

Ops.Ui.PatchInput.prototype = new CABLES.Op();
CABLES.OPS["e3f68bc3-892a-4c78-9974-aca25c27025d"]={f:Ops.Ui.PatchInput,objName:"Ops.Ui.PatchInput"};




// **************************************************************
// 
// Ops.Ui.PatchOutput
// 
// **************************************************************

Ops.Ui.PatchOutput = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

// empty

};

Ops.Ui.PatchOutput.prototype = new CABLES.Op();
CABLES.OPS["851b44cb-5667-4140-9800-5aeb7031f1d7"]={f:Ops.Ui.PatchOutput,objName:"Ops.Ui.PatchOutput"};




// **************************************************************
// 
// Ops.Ui.SubPatch
// 
// **************************************************************

Ops.Ui.SubPatch = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.dyn=op.addInPort(new CABLES.Port(op,"create port",CABLES.OP_PORT_TYPE_DYNAMIC));
op.dynOut=op.addOutPort(new CABLES.Port(op,"create port out",CABLES.OP_PORT_TYPE_DYNAMIC));

var dataStr=op.addInPort(new CABLES.Port(op,"dataStr",CABLES.OP_PORT_TYPE_VALUE,{ display:'readonly' }));
op.patchId=op.addInPort(new CABLES.Port(op,"patchId",CABLES.OP_PORT_TYPE_VALUE,{ display:'readonly' }));



dataStr.setUiAttribs({hideParam:true});
op.patchId.setUiAttribs({hideParam:true});

var data={"ports":[],"portsOut":[]};

// Ops.Ui.Patch.maxPatchId=CABLES.generateUUID();

op.patchId.onChange=function()
{
    // console.log("subpatch changed...");
    // clean up old subpatch if empty
    var oldPatchOps=op.patch.getSubPatchOps(oldPatchId);

    // console.log("subpatch has childs ",oldPatchOps.length);

    if(oldPatchOps.length==2)
    {
        for(var i=0;i<oldPatchOps.length;i++)
        {
            // console.log("delete ",oldPatchOps[i]);
            op.patch.deleteOp(oldPatchOps[i].id);
        }
    }
    else
    {
        // console.log("old subpatch has ops.,...");
    }
};

var oldPatchId=CABLES.generateUUID();
op.patchId.set(oldPatchId);

op.onLoaded=function()
{
    // op.patchId.set(CABLES.generateUUID());
};

op.onLoadedValueSet=function()
{
    data=JSON.parse(dataStr.get());
    if(!data)
    {
        data={"ports":[],"portsOut":[]};
    }
    setupPorts();
};

function loadData()
{
}

getSubPatchInputOp();
getSubPatchOutputOp();

var dataLoaded=false;
dataStr.onChange=function()
{
    if(dataLoaded)return;
console.log(dataStr.get());


    if(!dataStr.get())return;
    try
    {
        // console.log('parse subpatch data');
        loadData();
    }
    catch(e)
    {
        // op.log('cannot load subpatch data...');
        console.log(e);
    }
};

function saveData()
{
    dataStr.set(JSON.stringify(data));
    console.log(dataStr.get());
}

function addPortListener(newPort,newPortInPatch)
{
    //console.log('newPort',newPort.name);

    newPort.addEventListener("onUiAttrChange",function(attribs)
    {
        console.log("onUiAttrChange!!!");


        if(attribs.title)
        {




            var i=0;
            for(i=0;i<data.portsOut.length;i++)
                if(data.portsOut[i].name==newPort.name)
                    data.portsOut[i].title=attribs.title;

            for(i=0;i<data.ports.length;i++)
                if(data.ports[i].name==newPort.name)
                    data.ports[i].title=attribs.title;

            saveData();
        }

    });


    if(newPort.direction==CABLES.PORT_DIR_IN)
    {
        if(newPort.type==CABLES.OP_PORT_TYPE_FUNCTION)
        {
            newPort.onTriggered=function()
            {
                if(newPortInPatch.isLinked())
                    newPortInPatch.trigger();
            };
        }
        else
        {
            newPort.onChange=function()
            {
                newPortInPatch.set(newPort.get());
            };
        }
    }
}

function setupPorts()
{
    if(!op.patchId.get())return;
    var ports=data.ports||[];
    var portsOut=data.portsOut||[];
    var i=0;

    for(i=0;i<ports.length;i++)
    {
        if(!op.getPortByName(ports[i].name))
        {
            // console.log("ports[i].name",ports[i].name);

            var newPort=op.addInPort(new CABLES.Port(op,ports[i].name,ports[i].type));
            var patchInputOp=getSubPatchInputOp();





            // console.log(patchInputOp);

            var newPortInPatch=patchInputOp.addOutPort(new CABLES.Port(patchInputOp,ports[i].name,ports[i].type));

// console.log('newPortInPatch',newPortInPatch);


            newPort.ignoreValueSerialize=true;
            newPort.setUiAttribs({"editableTitle":true});
            if(ports[i].title)
            {
                newPort.setUiAttribs({"title":ports[i].title});
                newPortInPatch.setUiAttribs({"title":ports[i].title});
            }
            addPortListener(newPort,newPortInPatch);

        }
    }

    for(i=0;i<portsOut.length;i++)
    {
        if(!op.getPortByName(portsOut[i].name))
        {
            var newPortOut=op.addOutPort(new CABLES.Port(op,portsOut[i].name,portsOut[i].type));
            var patchOutputOp=getSubPatchOutputOp();
            var newPortOutPatch=patchOutputOp.addInPort(new CABLES.Port(patchOutputOp,portsOut[i].name,portsOut[i].type));

            newPortOut.ignoreValueSerialize=true;
            newPortOut.setUiAttribs({"editableTitle":true});

            if(portsOut[i].title)
            {
                newPortOut.setUiAttribs({"title":portsOut[i].title});
                newPortOutPatch.setUiAttribs({"title":portsOut[i].title});
            }


            // addPortListener(newPortOut,newPortOutPatch);
            addPortListener(newPortOutPatch,newPortOut);

        }
    }

    dataLoaded=true;

}



op.dyn.onLinkChanged=function()
{
    if(op.dyn.isLinked())
    {
        var otherPort=op.dyn.links[0].getOtherPort(op.dyn);
        op.dyn.removeLinks();
        otherPort.removeLinkTo(op.dyn);


        var newName="in"+data.ports.length+" "+otherPort.parent.name+" "+otherPort.name;

        data.ports.push({"name":newName,"type":otherPort.type});

        setupPorts();

        var l=gui.scene().link(
            otherPort.parent,
            otherPort.getName(),
            op,
            newName
            );

        // console.log('-----+===== ',otherPort.getName(),otherPort.get() );
        // l._setValue();
        // l.setValue(otherPort.get());

        dataLoaded=true;
        saveData();
    }
    else
    {
        setTimeout(function()
        {
            op.dyn.removeLinks();
            gui.patch().removeDeadLinks();
        },100);
    }
};

op.dynOut.onLinkChanged=function()
{
    if(op.dynOut.isLinked())
    {
        var otherPort=op.dynOut.links[0].getOtherPort(op.dynOut);
        op.dynOut.removeLinks();
        otherPort.removeLinkTo(op.dynOut);
        var newName="out"+data.ports.length+" "+otherPort.parent.name+" "+otherPort.name;

        data.portsOut.push({"name":newName,"type":otherPort.type});

        setupPorts();

        gui.scene().link(
            otherPort.parent,
            otherPort.getName(),
            op,
            newName
            );

        dataLoaded=true;
        saveData();
    }
    else
    {
        setTimeout(function()
        {
            op.dynOut.removeLinks();
            gui.patch().removeDeadLinks();
        },100);


        op.log('dynOut unlinked...');
    }
    gui.patch().removeDeadLinks();
};



function getSubPatchOutputOp()
{
    var patchOutputOP=op.patch.getSubPatchOp(op.patchId.get(),'Ops.Ui.PatchOutput');

    if(!patchOutputOP)
    {
        // console.log("Creating output for ",op.patchId.get());
        op.patch.addOp('Ops.Ui.PatchOutput',{'subPatch':op.patchId.get()} );
        patchOutputOP=op.patch.getSubPatchOp(op.patchId.get(),'Ops.Ui.PatchOutput');

        if(!patchOutputOP) console.warn('no patchinput2!');
    }
    return patchOutputOP;

}

function getSubPatchInputOp()
{
    var patchInputOP=op.patch.getSubPatchOp(op.patchId.get(),'Ops.Ui.PatchInput');

    if(!patchInputOP)
    {
        op.patch.addOp('Ops.Ui.PatchInput',{'subPatch':op.patchId.get()} );
        patchInputOP=op.patch.getSubPatchOp(op.patchId.get(),'Ops.Ui.PatchInput');
        if(!patchInputOP) console.warn('no patchinput2!');
    }


    return patchInputOP;
}

op.addSubLink=function(p,p2)
{
    var num=data.ports.length;

    var sublPortname="in"+(num-1)+" "+p2.parent.name+" "+p2.name;
    console.log('sublink! ',sublPortname);

    if(p.direction==CABLES.PORT_DIR_IN)
    {
        var l=gui.scene().link(
            p.parent,
            p.getName(),
            getSubPatchInputOp(),
            sublPortname
            );

        // console.log('- ----=====EEE ',p.getName(),p.get() );
        // console.log('- ----=====EEE ',l.getOtherPort(p).getName() ,l.getOtherPort(p).get() );
    }
    else
    {
        var l=gui.scene().link(
            p.parent,
            p.getName(),
            getSubPatchOutputOp(),
            "out"+(num)+" "+p2.parent.name+" "+p2.name
            );
    }

    var bounds=gui.patch().getSubPatchBounds(op.patchId.get());

    getSubPatchInputOp().uiAttr(
        {
            "translate":
            {
                "x":bounds.minx,
                "y":bounds.miny-100
            }
        });

    getSubPatchOutputOp().uiAttr(
        {
            "translate":
            {
                "x":bounds.minx,
                "y":bounds.maxy+100
            }
        });
    saveData();
    return sublPortname;
};



op.onDelete=function()
{
    for (var i = op.patch.ops.length-1; i >=0 ; i--)
    {
        if(op.patch.ops[i].uiAttribs && op.patch.ops[i].uiAttribs.subPatch==op.patchId.get())
        {
            // console.log(op.patch.ops[i].objName);
            op.patch.deleteOp(op.patch.ops[i].id);
        }
    }



};


};

Ops.Ui.SubPatch.prototype = new CABLES.Op();
CABLES.OPS["84d9a6f0-ed7a-466d-b386-225ed9e89c60"]={f:Ops.Ui.SubPatch,objName:"Ops.Ui.SubPatch"};




// **************************************************************
// 
// Ops.WebAudio.AudioBuffer
// 
// **************************************************************

Ops.WebAudio.AudioBuffer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const audioCtx = CABLES.WEBAUDIO.createAudioContext(op);
const inUrlPort = op.inFile("URL",'audio');
const audioBufferPort = op.outObject("Audio Buffer");
const finishedLoadingPort = op.outValue("Finished Loading", false);
const sampleRatePort = op.outValue("Sample Rate", 0);
const lengthPort = op.outValue("Length", 0);
const durationPort = op.outValue("Duration", 0);
const numberOfChannelsPort = op.outValue("Number of Channels", 0);

// change listeners
inUrlPort.onChange = function() {
    var url=op.patch.getFilePath(inUrlPort.get());
    if(typeof url === 'string' && url.length > 1) {
        CABLES.WEBAUDIO.loadAudioFile(op.patch, url, onLoadFinished, onLoadFailed);
    }
};

function onLoadFinished(buffer) {
    lengthPort.set(buffer.length);
    durationPort.set(buffer.duration);
    numberOfChannelsPort.set(buffer.numberOfChannels);
    sampleRatePort.set(buffer.sampleRate);
    audioBufferPort.set(buffer);
    finishedLoadingPort.set(true);
    op.log("AudioBuffer loaded: ", buffer);
}

function onLoadFailed(e) {
    console.error("Error: Loading audio file failed: ", e);
    invalidateOutPorts();
}

function invalidateOutPorts() {
    lengthPort.set(0);
    durationPort.set(0);
    numberOfChannelsPort.set(0);
    sampleRatePort.set(0);
    audioBufferPort.set(0);
    finishedLoadingPort.set(false);
}

};

Ops.WebAudio.AudioBuffer.prototype = new CABLES.Op();
CABLES.OPS["2cf4b0a1-b657-405b-8bf9-8555dbd5c231"]={f:Ops.WebAudio.AudioBuffer,objName:"Ops.WebAudio.AudioBuffer"};




// **************************************************************
// 
// Ops.WebAudio.AudioBufferPlayer
// 
// **************************************************************

Ops.WebAudio.AudioBufferPlayer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var audioCtx = CABLES.WEBAUDIO.createAudioContext(op);

// input ports
var audioBufferPort = op.inObject("Audio Buffer");
var playPort = op.inValueBool("Start / Stop", false);
var startTimePort = op.inValue("Start Time", 0);
var stopTimePort = op.inValue("Stop Time", 0);
var offsetPort = op.inValue("Offset", 0);
var autoPlayPort = op.inValueBool("Autoplay", false);
var loopPort = op.inValueBool("Loop", false);
var detunePort = op.inValue("Detune", 0);
var playbackRatePort = op.inValue("Playback Rate", 1);

// output ports
var audioOutPort = op.outObject("Audio Out");

// vars
var source = null;

// change listeners
audioBufferPort.onChange = function() {
    createAudioBufferSource();
    if(
        (autoPlayPort.get() && audioBufferPort.get()) ||
    (playPort.get() && audioBufferPort.get())
    ) {
        start(startTimePort.get());
    }
};
playPort.onChange = function() {
    if(source) {
        if(playPort.get()) {
            var startTime = startTimePort.get() || 0;
            start(startTime);    
        } else {
            var stopTime = stopTimePort.get() || 0;
            stop(stopTime);    
        } 
    }
};
loopPort.onChange = function() {
    if(source) {
        source.loop = loopPort.get() ? true : false;
    }
};

detunePort.onChange = setDetune;

function setDetune() {
    if(source) {
        var detune = detunePort.get() || 0;
        if(source.detune) {
            source.detune.setValueAtTime(
                detune,
                audioCtx.currentTime    
            );
        }
    }
}

playbackRatePort.onChange = setPlaybackRate;

function setPlaybackRate() {
    if(source) {
        var playbackRate = playbackRatePort.get() || 0;
        if(playbackRate >= source.playbackRate.minValue && playbackRate <= source.playbackRate.maxValue) {
            source.playbackRate.setValueAtTime(
                playbackRate,
                audioCtx.currentTime    
            );    
        }
    }
}

// functions
function createAudioBufferSource() {
    if(source)stop(0);
    source = audioCtx.createBufferSource();
    var buffer = audioBufferPort.get();
    if(buffer) {
        source.buffer = buffer;
    }
    source.onended = onPlaybackEnded;
    source.loop = loopPort.get();
    setPlaybackRate();
    setDetune();
    audioOutPort.set(source);
}

function start(time) {
    try {
        source.start(time,offsetPort.get()); // 0 = now
    } catch(e){
        // console.log(e);
    } // already playing!?
}

function stop(time) {
    try {
        source.stop(time); // 0 = now
    } catch(e) 
    {
        // console.log(e);
    } // not playing!?
}

function onPlaybackEnded() {
    createAudioBufferSource(); // we can only play back once, so we need to create a new one
}

};

Ops.WebAudio.AudioBufferPlayer.prototype = new CABLES.Op();
CABLES.OPS["05385277-92fc-4d49-b730-11f9ed5e5c0d"]={f:Ops.WebAudio.AudioBufferPlayer,objName:"Ops.WebAudio.AudioBufferPlayer"};




// **************************************************************
// 
// Ops.TimeLine.TimeLineControls
// 
// **************************************************************

Ops.TimeLine.TimeLineControls = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var plauPause=op.outValue("Play/Stop");
var time=op.outValue("time");

op.patch.timer.onPlayPause(seek);
op.patch.timer.onTimeChange(seek);

function seek()
{
    plauPause.set(false);

    setTimeout(function()
    {
        time.set(op.patch.timer.getTime());
        plauPause.set(op.patch.timer.isPlaying());
    },10);
}

};

Ops.TimeLine.TimeLineControls.prototype = new CABLES.Op();
CABLES.OPS["53cb7b1a-56c7-405f-b427-12db78fbfd2f"]={f:Ops.TimeLine.TimeLineControls,objName:"Ops.TimeLine.TimeLineControls"};




// **************************************************************
// 
// Ops.WebAudio.Output
// 
// **************************************************************

Ops.WebAudio.Output = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.requirements=[CABLES.Requirements.WEBAUDIO];

var audioCtx = CABLES.WEBAUDIO.createAudioContext(op);

// constants
var VOLUME_DEFAULT = 1.0;
var VOLUME_MIN = 0;
var VOLUME_MAX = 1;

// vars
var gainNode = audioCtx.createGain();
var destinationNode = audioCtx.destination;
gainNode.connect(destinationNode);
var masterVolume = 1;

// inputs
var audioInPort = CABLES.WEBAUDIO.createAudioInPort(op, "Audio In", gainNode);
var volumePort = op.inValueSlider("Volume", VOLUME_DEFAULT);
var mutePort = op.inValueBool("Mute", false);

// functions
// sets the volume, multiplied by master volume
function setVolume() {
    var volume = volumePort.get() * masterVolume;
    if(volume >= VOLUME_MIN && volume <= VOLUME_MAX) {
        // gainNode.gain.value = volume;
        gainNode.gain.setValueAtTime(volume, audioCtx.currentTime);
    } else {
        // gainNode.gain.value = VOLUME_DEFAULT * masterVolume;
        gainNode.gain.setValueAtTime(VOLUME_DEFAULT * masterVolume, audioCtx.currentTime);
    }
}

function mute(b) {
    if(b) {
        // gainNode.gain.value = 0;
        gainNode.gain.setValueAtTime(0, audioCtx.currentTime);
    } else {
        setVolume();
    }
}

// change listeners
mutePort.onChange = function() {
    mute(mutePort.get());
};

volumePort.onChange = function() {
    if(mutePort.get()) {
        return;
    }
    setVolume();
};

op.onMasterVolumeChanged = function(v) {
    masterVolume = v;
    setVolume();
};




};

Ops.WebAudio.Output.prototype = new CABLES.Op();
CABLES.OPS["53fdbf4a-bc8d-4c5d-a698-f34fdeb53827"]={f:Ops.WebAudio.Output,objName:"Ops.WebAudio.Output"};




// **************************************************************
// 
// Ops.Anim.Timer_v2
// 
// **************************************************************

Ops.Anim.Timer_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inSpeed=op.inValue("Speed",1),
    playPause=op.inValueBool("Play",true),
    reset=op.inTriggerButton("Reset"),
    inSyncTimeline=op.inValueBool("Sync to timeline",false),
    outTime=op.outValue("Time");

op.setPortGroup("Controls",[playPause,reset,inSpeed]);

const timer=new CABLES.Timer();
var lastTime=0;
var time=0;
var syncTimeline=false;

playPause.onChange=setState;
setState();

function setState()
{
    if(playPause.get())
    {
        timer.play();
        op.patch.addOnAnimFrame(op);
    }
    else
    {
        timer.pause();
        op.patch.removeOnAnimFrame(op);
    }
}

reset.onTriggered=function()
{
    time=0;
    lastTime=0;
    timer.setTime(0);
    outTime.set(0);
};

inSyncTimeline.onChange=function()
{
    syncTimeline=inSyncTimeline.get();
    playPause.setUiAttribs({greyout:syncTimeline});
    reset.setUiAttribs({greyout:syncTimeline});
};

op.onAnimFrame=function(t)
{
    if(timer.isPlaying())
    {

        if(syncTimeline)
        {
            outTime.set(t*inSpeed.get());
        }
        else
        {
            timer.update();
            var timerVal=timer.get();

            if(lastTime===0)
            {
                lastTime=timerVal;
                return;
            }

            const t=timerVal-lastTime;
            lastTime=timerVal;
            time+=t*inSpeed.get();
            if(time!=time)time=0;
            outTime.set(time);
        }
    }
};




};

Ops.Anim.Timer_v2.prototype = new CABLES.Op();
CABLES.OPS["aac7f721-208f-411a-adb3-79adae2e471a"]={f:Ops.Anim.Timer_v2,objName:"Ops.Anim.Timer_v2"};




// **************************************************************
// 
// Ops.Math.Sum
// 
// **************************************************************

Ops.Math.Sum = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    number1=op.inValueFloat("number1",1),
    number2=op.inValueFloat("number2",1),
    result=op.outValue("result");

number1.onChange=
number2.onChange=exec;
exec();

function exec()
{
    var v=number1.get()+number2.get();
    if(!isNaN(v)) result.set( v );
}



};

Ops.Math.Sum.prototype = new CABLES.Op();
CABLES.OPS["c8fb181e-0b03-4b41-9e55-06b6267bc634"]={f:Ops.Math.Sum,objName:"Ops.Math.Sum"};




// **************************************************************
// 
// Ops.Math.Modulo
// 
// **************************************************************

Ops.Math.Modulo = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const result=op.outValue("result");
const number1=op.inValueFloat("number1");
const number2=op.inValueFloat("number2");
const pingpong=op.inValueBool("pingpong");

// pointer to function
var calculateFunction = calculateModule;

number1.onChange=exec;
number2.onChange=exec;

number1.set(1);
number2.set(2);

pingpong.onChange=updatePingPong;

function exec()
{
    var n2=number2.get();
    var n1=number1.get();

    result.set( calculateFunction(n1, n2) );
    return;
}

function calculateModule(n1, n2) {
    var re = ((n1%n2)+n2)%n2;
    if(re!=re) re=0;
    return re;
}

function calculatePingPong(n1, n2) {
    var r = ((n1%n2)+n2)%n2*2;
    if(r>n2) return n2 * 2.0-r;
    else return r;
}

function updatePingPong()
{
    if (pingpong.get()) calculateFunction = calculatePingPong;
    else calculateFunction = calculateModule;
}



};

Ops.Math.Modulo.prototype = new CABLES.Op();
CABLES.OPS["ebc13b25-3705-4265-8f06-5f985b6a7bb1"]={f:Ops.Math.Modulo,objName:"Ops.Math.Modulo"};




// **************************************************************
// 
// Ops.Gl.Matrix.OrbitControls
// 
// **************************************************************

Ops.Gl.Matrix.OrbitControls = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const minDist=op.inValueFloat("min distance");
const maxDist=op.inValueFloat("max distance");

const minRotY=op.inValue("min rot y",0);
const maxRotY=op.inValue("max rot y",0);

// const minRotX=op.inValue("min rot x",0);
// const maxRotX=op.inValue("max rot x",0);

const initialRadius=op.inValue("initial radius",0);
const initialAxis=op.inValueSlider("initial axis y");
const initialX=op.inValueSlider("initial axis x");

const mul=op.inValueFloat("mul");
const smoothness=op.inValueSlider("Smoothness",1.0);
const speedX=op.inValue("Speed X",1);
const speedY=op.inValue("Speed Y",1);

const active=op.inValueBool("Active",true);

const allowPanning=op.inValueBool("Allow Panning",true);
const allowZooming=op.inValueBool("Allow Zooming",true);
const allowRotation=op.inValueBool("Allow Rotation",true);
const restricted=op.inValueBool("restricted",true);
const pointerLock=op.inValueBool("Pointerlock",false);

const trigger=op.outTrigger("trigger");
const outRadius=op.outValue("radius");
const outYDeg=op.outValue("Rot Y");
const outXDeg=op.outValue("Rot X");

const
    outPosX=op.outNumber("Eye Pos X"),
    outPosY=op.outNumber("Eye Pos Y"),
    outPosZ=op.outNumber("Eye Pos Z");

const inReset=op.inTriggerButton("Reset");

op.setPortGroup("Initial Values",[initialAxis,initialX,initialRadius]);
op.setPortGroup("Interaction",[mul,smoothness,speedX,speedY]);
op.setPortGroup("Boundaries",[minRotY,maxRotY,minDist,maxDist]);



mul.set(1);
minDist.set(0.05);
maxDist.set(99999);

inReset.onTriggered=reset;

const cgl=op.patch.cgl;
var eye=vec3.create();
var vUp=vec3.create();
var vCenter=vec3.create();
var viewMatrix=mat4.create();
var vOffset=vec3.create();

initialAxis.set(0.5);


var mouseDown=false;
var radius=5;
outRadius.set(radius);

var lastMouseX=0,lastMouseY=0;
var percX=0,percY=0;


vec3.set(vCenter, 0,0,0);
vec3.set(vUp, 0,1,0);

var tempEye=vec3.create();
var finalEye=vec3.create();
var tempCenter=vec3.create();
var finalCenter=vec3.create();

var px=0;
var py=0;

var divisor=1;
var element=null;
updateSmoothness();

op.onDelete=unbind;

var doLockPointer=false;

pointerLock.onChange=function()
{
    doLockPointer=pointerLock.get();
    console.log("doLockPointer",doLockPointer);
};

function reset()
{
    px=px%(Math.PI*2);
    py=py%(Math.PI*2);

    vec3.set(vOffset,0,0,0);
    vec3.set(vCenter, 0,0,0);
    vec3.set(vUp, 0,1,0);

    percX=(initialX.get()*Math.PI*2);
    percY=(initialAxis.get()-0.5);
    radius=initialRadius.get();
    eye=circlePos( percY );
}

function updateSmoothness()
{
    divisor=smoothness.get()*10+1.0;
}

smoothness.onChange=updateSmoothness;

var initializing=true;

function ip(val,goal)
{
    if(initializing)return goal;
    return val+(goal-val)/divisor;
}

var lastPy=0;
var lastPx=0;

render.onTriggered=function()
{
    cgl.pushViewMatrix();

    px=ip(px,percX);
    py=ip(py,percY);

    var degY=(py+0.5)*180;


    if(minRotY.get()!==0 && degY<minRotY.get())
    {
        degY=minRotY.get();
        py=lastPy;
    }
    else if(maxRotY.get()!==0 && degY>maxRotY.get())
    {
        degY=maxRotY.get();
        py=lastPy;
    }
    else
    {
        lastPy=py;
    }

    var degX=(px)*CGL.RAD2DEG;

    outYDeg.set( degY );
    outXDeg.set( degX );

    circlePosi(eye, py );

    vec3.add(tempEye, eye, vOffset);
    vec3.add(tempCenter, vCenter, vOffset);

    finalEye[0]=ip(finalEye[0],tempEye[0]);
    finalEye[1]=ip(finalEye[1],tempEye[1]);
    finalEye[2]=ip(finalEye[2],tempEye[2]);

    finalCenter[0]=ip(finalCenter[0],tempCenter[0]);
    finalCenter[1]=ip(finalCenter[1],tempCenter[1]);
    finalCenter[2]=ip(finalCenter[2],tempCenter[2]);

    outPosX.set(finalEye[0]);
    outPosY.set(finalEye[1]);
    outPosZ.set(finalEye[2]);

    mat4.lookAt(viewMatrix, finalEye, finalCenter, vUp);
    mat4.rotate(viewMatrix, viewMatrix, px, vUp);
    mat4.multiply(cgl.vMatrix,cgl.vMatrix,viewMatrix);

    trigger.trigger();
    cgl.popViewMatrix();
    initializing=false;
};

function circlePosi(vec,perc)
{
    const mmul=mul.get();
    if(radius<minDist.get()*mmul)radius=minDist.get()*mmul;
    if(radius>maxDist.get()*mmul)radius=maxDist.get()*mmul;

    outRadius.set(radius*mmul);

    var i=0,degInRad=0;
    // var vec=vec3.create();
    degInRad = 360*perc/2*CGL.DEG2RAD;
    vec3.set(vec,
        Math.cos(degInRad)*radius*mmul,
        Math.sin(degInRad)*radius*mmul,
        0);
    return vec;
}


function circlePos(perc)
{
    const mmul=mul.get();
    if(radius<minDist.get()*mmul)radius=minDist.get()*mmul;
    if(radius>maxDist.get()*mmul)radius=maxDist.get()*mmul;

    outRadius.set(radius*mmul);

    var i=0,degInRad=0;
    var vec=vec3.create();
    degInRad = 360*perc/2*CGL.DEG2RAD;
    vec3.set(vec,
        Math.cos(degInRad)*radius*mmul,
        Math.sin(degInRad)*radius*mmul,
        0);
    return vec;
}

function onmousemove(event)
{
    if(!mouseDown) return;

    var x = event.clientX;
    var y = event.clientY;

    var movementX=(x-lastMouseX);
    var movementY=(y-lastMouseY);

    if(doLockPointer)
    {
        movementX=event.movementX*mul.get();
        movementY=event.movementY*mul.get();
    }

    movementX*=speedX.get();
    movementY*=speedY.get();

    if(event.which==3 && allowPanning.get())
    {
        vOffset[2]+=movementX*0.01*mul.get();
        vOffset[1]+=movementY*0.01*mul.get();
    }
    else
    if(event.which==2 && allowZooming.get())
    {
        radius+=movementY*0.05;
        eye=circlePos(percY);
    }
    else
    {
        if(allowRotation.get())
        {
            percX+=movementX*0.003;
            percY+=movementY*0.002;

            if(restricted.get())
            {
                if(percY>0.5)percY=0.5;
                if(percY<-0.5)percY=-0.5;
            }
        }
    }

    lastMouseX=x;
    lastMouseY=y;
}

function onMouseDown(event)
{
    lastMouseX = event.clientX;
    lastMouseY = event.clientY;
    mouseDown=true;

    if(doLockPointer)
    {
        var el=op.patch.cgl.canvas;
        el.requestPointerLock = el.requestPointerLock || el.mozRequestPointerLock || el.webkitRequestPointerLock;
        if(el.requestPointerLock) el.requestPointerLock();
        else console.log("no t found");
        // document.addEventListener("mousemove", onmousemove, false);

        document.addEventListener('pointerlockchange', lockChange, false);
        document.addEventListener('mozpointerlockchange', lockChange, false);
        document.addEventListener('webkitpointerlockchange', lockChange, false);
    }
}

function onMouseUp()
{
    mouseDown=false;
    // cgl.canvas.style.cursor='url(/ui/img/rotate.png),pointer';

    if(doLockPointer)
    {
        document.removeEventListener('pointerlockchange', lockChange, false);
        document.removeEventListener('mozpointerlockchange', lockChange, false);
        document.removeEventListener('webkitpointerlockchange', lockChange, false);

        if(document.exitPointerLock) document.exitPointerLock();
        document.removeEventListener("mousemove", pointerLock, false);
    }
}

function lockChange()
{
    var el=op.patch.cgl.canvas;

    if (document.pointerLockElement === el || document.mozPointerLockElement === el || document.webkitPointerLockElement === el)
    {
        document.addEventListener("mousemove", onmousemove, false);
        console.log("listening...");
    }
}

function onMouseEnter(e)
{
    // cgl.canvas.style.cursor='url(/ui/img/rotate.png),pointer';
}

initialRadius.onChange=function()
{
    radius=initialRadius.get();
    reset();
};

initialX.onChange=function()
{
    px=percX=(initialX.get()*Math.PI*2);
};

initialAxis.onChange=function()
{
    py=percY=(initialAxis.get()-0.5);
    eye=circlePos(percY);
};

var onMouseWheel=function(event)
{
    if(allowZooming.get())
    {
        var delta=CGL.getWheelSpeed(event)*0.06;
        radius+=(parseFloat(delta))*1.2;

        eye=circlePos(percY);
        event.preventDefault();
    }
};

var ontouchstart=function(event)
{
    doLockPointer=false;
    if(event.touches && event.touches.length>0) onMouseDown(event.touches[0]);
};

var ontouchend=function(event)
{
    doLockPointer=false;
    onMouseUp();
};

var ontouchmove=function(event)
{
    doLockPointer=false;
    if(event.touches && event.touches.length>0) onmousemove(event.touches[0]);
};

active.onChange=function()
{
    if(active.get())bind();
        else unbind();
}

function setElement(ele)
{
    unbind();
    element=ele;
    bind();
}

function bind()
{
    element.addEventListener('mousemove', onmousemove);
    element.addEventListener('mousedown', onMouseDown);
    element.addEventListener('mouseup', onMouseUp);
    element.addEventListener('mouseleave', onMouseUp);
    element.addEventListener('mouseenter', onMouseEnter);
    element.addEventListener('contextmenu', function(e){e.preventDefault();});
    element.addEventListener('wheel', onMouseWheel);

    element.addEventListener('touchmove', ontouchmove);
    element.addEventListener('touchstart', ontouchstart);
    element.addEventListener('touchend', ontouchend);
}

function unbind()
{
    if(!element)return;

    element.removeEventListener('mousemove', onmousemove);
    element.removeEventListener('mousedown', onMouseDown);
    element.removeEventListener('mouseup', onMouseUp);
    element.removeEventListener('mouseleave', onMouseUp);
    element.removeEventListener('mouseenter', onMouseUp);
    element.removeEventListener('wheel', onMouseWheel);

    element.removeEventListener('touchmove', ontouchmove);
    element.removeEventListener('touchstart', ontouchstart);
    element.removeEventListener('touchend', ontouchend);
}

eye=circlePos(0);
setElement(cgl.canvas);


bind();

initialX.set(0.25);
initialRadius.set(0.05);


};

Ops.Gl.Matrix.OrbitControls.prototype = new CABLES.Op();
CABLES.OPS["eaf4f7ce-08a3-4d1b-b9f4-ebc0b7b1cde1"]={f:Ops.Gl.Matrix.OrbitControls,objName:"Ops.Gl.Matrix.OrbitControls"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.Noise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.Noise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={noise_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float time;\n\n{{CGL.BLENDMODES}}\n{{MODULES_HEAD}}\n\n{{CGL.RANDOM_TEX}}\n\nvoid main()\n{\n    vec4 rnd;\n\n    #ifndef RGB\n        float r=cgl_random(texCoord.xy+vec2(time));\n        rnd=vec4( r,r,r,1.0 );\n    #endif\n\n    #ifdef RGB\n        rnd=vec4(cgl_random3(texCoord.xy+vec2(time)),1.0);\n    #endif\n\n    vec4 base=texture(tex,texCoord);\n    vec4 col=vec4( _blend(base.rgb,rnd.rgb) ,1.0);\n\n    outColor=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n}",};
const
    render=op.inTrigger('Render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    animated=op.inValueBool("Animated",true),
    inRGB=op.inValueBool("RGB",false),
    trigger=op.outTrigger("Next");

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    timeUniform=new CGL.Uniform(shader,'f','time',1.0),
    textureUniform=new CGL.Uniform(shader,'t','tex',0);

shader.setSource(shader.getDefaultVertexShader(),attachments.noise_frag);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

op.toWorkPortsNeedToBeLinked(render);

inRGB.onChange=function()
{
    if(inRGB.get())shader.define("RGB");
    else shader.removeDefine("RGB");
};

shader.bindTextures=function()
{
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(animated.get()) timeUniform.setValue(op.patch.freeTimer.get()/1000%100);
        else timeUniform.setValue(0);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Noise.Noise.prototype = new CABLES.Op();
CABLES.OPS["81253441-cc73-42fa-b903-6d23806873d9"]={f:Ops.Gl.TextureEffects.Noise.Noise,objName:"Ops.Gl.TextureEffects.Noise.Noise"};




// **************************************************************
// 
// Ops.Gl.ClearDepth
// 
// **************************************************************

Ops.Gl.ClearDepth = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger('render');
var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;

render.onTriggered=function()
{
    cgl.gl.clear(cgl.gl.DEPTH_BUFFER_BIT);
    trigger.trigger();
};




};

Ops.Gl.ClearDepth.prototype = new CABLES.Op();
CABLES.OPS["9e8a4b73-4ba7-4c4f-b266-81c5f9db9b7a"]={f:Ops.Gl.ClearDepth,objName:"Ops.Gl.ClearDepth"};




// **************************************************************
// 
// Ops.Gl.Textures.CopyTexture
// 
// **************************************************************

Ops.Gl.Textures.CopyTexture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={copytexture_frag:"UNI float a;\nUNI sampler2D tex;\nIN vec2 texCoord;\n\nvoid main()\n{\n   vec4 col=texture(tex,texCoord);\n   outColor= col;\n}",};
const
    render=op.inTrigger('render'),
    inTexture=op.inTexture('Texture'),
    useVPSize=op.inValueBool('use original size'),
    width=op.inValueInt('width'),
    height=op.inValueInt('height'),
    tfilter=op.inSwitch('filter',['nearest','linear','mipmap']),
    twrap=op.inValueSelect('wrap',['clamp to edge','repeat','mirrored repeat']),
    fpTexture=op.inValueBool('HDR'),
    trigger=op.outTrigger('trigger'),
    texOut=op.outTexture('texture_out'),
    outRatio=op.outValue("Aspect Ratio");

texOut.set(null);
var cgl=op.patch.cgl;
var effect=null;
var tex=null;

var w=8,h=8;
var prevViewPort=[0,0,0,0];
var reInitEffect=true;

op.setPortGroup("Size",[useVPSize,width,height]);

var bgShader=new CGL.Shader(cgl,'imgcompose bg');
bgShader.setSource(bgShader.getDefaultVertexShader(),attachments.copytexture_frag);
var textureUniform=new CGL.Uniform(bgShader,'t','tex',0);

var selectedFilter=CGL.Texture.FILTER_LINEAR;
var selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;


function initEffect()
{
    if(effect)effect.delete();
    if(tex)tex.delete();

    effect=new CGL.TextureEffect(cgl,{"isFloatingPointTexture":fpTexture.get()});

    tex=new CGL.Texture(cgl,
        {
            "name":"copytexture",
            "isFloatingPointTexture":fpTexture.get(),
            "filter":selectedFilter,
            "wrap":selectedWrap,
            "width": Math.floor(width.get()),
            "height": Math.floor(height.get()),
        });

    effect.setSourceTexture(tex);
    texOut.set(null);
    reInitEffect=false;
}

fpTexture.onChange=function()
{
    reInitEffect=true;
};

function updateResolution()
{
    if(!effect)initEffect();
    if(!inTexture.get())return;

    if(useVPSize.get())
    {
        w=inTexture.get().width;
        h=inTexture.get().height;
    }
    else
    {
        w=Math.floor(width.get());
        h=Math.floor(height.get());
    }

    if((w!=tex.width || h!= tex.height) && (w!==0 && h!==0))
    {
        height.set(h);
        width.set(w);
        tex.filter=selectedFilter;
        tex.setSize(w,h);
        outRatio.set(w/h);
        effect.setSourceTexture(tex);
    }

    if(texOut.get())
        if(!texOut.get().isPowerOfTwo() )
        {
            if(!op.uiAttribs.hint)
                op.uiAttr(
                    {
                        hint:'texture dimensions not power of two! - texture filtering will not work.',
                        warning:null
                    });
        }
        else
        if(op.uiAttribs.hint)
        {
            op.uiAttr({hint:null,warning:null}); //todo only when needed...
        }

}


function updateSizePorts()
{
    if(useVPSize.get())
    {
        width.setUiAttribs({hidePort:true,greyout:true});
        height.setUiAttribs({hidePort:true,greyout:true});
    }
    else
    {
        width.setUiAttribs({hidePort:false,greyout:false});
        height.setUiAttribs({hidePort:false,greyout:false});
    }
}

useVPSize.onChange=function()
{
    updateSizePorts();
    if(useVPSize.get())
    {
        width.onChange=null;
        height.onChange=null;
    }
    else
    {
        width.onChange=updateResolution;
        height.onChange=updateResolution;
    }
    updateResolution();
};

var lastTex=null;

var doRender=function()
{

    if(!effect || reInitEffect || lastTex!=inTexture.get())
    {
        initEffect();
    }
    var vp=cgl.getViewPort();
    prevViewPort[0]=vp[0];
    prevViewPort[1]=vp[1];
    prevViewPort[2]=vp[2];
    prevViewPort[3]=vp[3];

    updateResolution();

    if(!inTexture.get())return;

    lastTex=inTexture.get();
    var oldEffect=cgl.currentTextureEffect;
    cgl.currentTextureEffect=effect;
    effect.setSourceTexture(tex);

    effect.startEffect();

    // render background color...
    cgl.setShader(bgShader);
    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, inTexture.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();


    texOut.set(effect.getCurrentSourceTexture());

    effect.endEffect();

    cgl.setViewPort(prevViewPort[0],prevViewPort[1],prevViewPort[2],prevViewPort[3]);

    cgl.currentTextureEffect=oldEffect;

    trigger.trigger();
};


function onWrapChange()
{
    if(twrap.get()=='repeat') selectedWrap=CGL.Texture.WRAP_REPEAT;
    if(twrap.get()=='mirrored repeat') selectedWrap=CGL.Texture.WRAP_MIRRORED_REPEAT;
    if(twrap.get()=='clamp to edge') selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

    reInitEffect=true;
    updateResolution();
}

twrap.set('clamp to edge');
twrap.onChange=onWrapChange;

function onFilterChange()
{
    if(tfilter.get()=='nearest') selectedFilter=CGL.Texture.FILTER_NEAREST;
    else if(tfilter.get()=='linear')  selectedFilter=CGL.Texture.FILTER_LINEAR;
    else if(tfilter.get()=='mipmap')  selectedFilter=CGL.Texture.FILTER_MIPMAP;

    reInitEffect=true;
    updateResolution();
}

tfilter.set('linear');
tfilter.onChange=onFilterChange;

useVPSize.set(true);
render.onTriggered=doRender;

width.set(640);
height.set(360);
updateSizePorts();

};

Ops.Gl.Textures.CopyTexture.prototype = new CABLES.Op();
CABLES.OPS["18a6d1f4-a7f8-4a3e-ab1d-0c2d2efe3861"]={f:Ops.Gl.Textures.CopyTexture,objName:"Ops.Gl.Textures.CopyTexture"};




// **************************************************************
// 
// Ops.Gl.BlendMode
// 
// **************************************************************

Ops.Gl.BlendMode = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exec=op.inTrigger("Render"),
    inBlend=op.inValueSelect("Blendmode",['None','Normal','Add','Subtract','Multiply'],'Normal'),
    inPremul=op.inValueBool("Premultiplied"),
    next=op.outTrigger("Next");

const cgl=op.patch.cgl;
var blendMode=0;
inBlend.onChange=update;
update();

function update()
{
    if(inBlend.get()=="Normal")blendMode=CGL.BLEND_NORMAL;
        else if(inBlend.get()=="Add")blendMode=CGL.BLEND_ADD;
        else if(inBlend.get()=="Subtract")blendMode=CGL.BLEND_SUB;
        else if(inBlend.get()=="Multiply")blendMode=CGL.BLEND_MUL;
        else blendMode=CGL.BLEND_NONE;

    if(CABLES.UI)
    {
        var blstr='';
        if(inBlend.get()=="Normal")blstr='';
            else if(inBlend.get()=="Add")blstr='Add';
            else if(inBlend.get()=="Subtract")blstr='Sub';
            else if(inBlend.get()=="Multiply")blstr='Mul';
            else blstr='None';

        op.setUiAttrib({"extendTitle":blstr});
    }

}

exec.onTriggered=function()
{
    cgl.pushBlendMode(blendMode,inPremul.get());
    cgl.pushBlend(blendMode!=CGL.BLEND_NONE);
    next.trigger();
    cgl.popBlend();
    cgl.popBlendMode();
	cgl.gl.blendEquationSeparate( cgl.gl.FUNC_ADD, cgl.gl.FUNC_ADD );
	cgl.gl.blendFuncSeparate( cgl.gl.SRC_ALPHA, cgl.gl.ONE_MINUS_SRC_ALPHA, cgl.gl.ONE, cgl.gl.ONE_MINUS_SRC_ALPHA );
};


};

Ops.Gl.BlendMode.prototype = new CABLES.Op();
CABLES.OPS["ce0fff72-1438-4373-924f-e1d0f78b053f"]={f:Ops.Gl.BlendMode,objName:"Ops.Gl.BlendMode"};




// **************************************************************
// 
// Ops.Gl.FaceCulling
// 
// **************************************************************

Ops.Gl.FaceCulling = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    trigger=op.outTrigger("trigger"),
    enable=op.inValueBool("enable",true),
    facing=op.inSwitch("facing",['back','front','both'],'back'),
    cgl=op.patch.cgl;

var whichFace=cgl.gl.BACK;

render.onTriggered=function()
{
    if(enable.get()) cgl.gl.enable(cgl.gl.CULL_FACE);
        else cgl.gl.disable(cgl.gl.CULL_FACE);

    cgl.gl.cullFace(whichFace);
    trigger.trigger();
    cgl.gl.disable(cgl.gl.CULL_FACE);
};

facing.onChange=function()
{
    whichFace=cgl.gl.BACK;
    if(facing.get()=='front') whichFace=cgl.gl.FRONT;
        else if(facing.get()=='both') whichFace=cgl.gl.FRONT_AND_BACK;
};

};

Ops.Gl.FaceCulling.prototype = new CABLES.Op();
CABLES.OPS["a389f42c-7324-45c9-bb47-369e31d602f0"]={f:Ops.Gl.FaceCulling,objName:"Ops.Gl.FaceCulling"};




// **************************************************************
// 
// Ops.Gl.Shader.BasicMaterial_v2
// 
// **************************************************************

Ops.Gl.Shader.BasicMaterial_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={basicmaterial_frag:"{{MODULES_HEAD}}\n\nIN vec2 texCoord;\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\n#ifdef HAS_TEXTURES\n    IN vec2 texCoordOrig;\n    #ifdef HAS_TEXTURE_DIFFUSE\n        UNI sampler2D tex;\n    #endif\n    #ifdef HAS_TEXTURE_OPACITY\n        UNI sampler2D texOpacity;\n   #endif\n#endif\n\nvoid main()\n{\n    {{MODULE_BEGIN_FRAG}}\n    vec4 col=vec4(r,g,b,a);\n\n    #ifdef HAS_TEXTURES\n        vec2 uv=vec2(texCoord.s,1.0-texCoord.t);\n\n        #ifdef HAS_TEXTURE_DIFFUSE\n            col=texture(tex,uv);\n\n            #ifdef COLORIZE_TEXTURE\n                col.r*=r;\n                col.g*=g;\n                col.b*=b;\n            #endif\n        #endif\n        col.a*=a;\n        #ifdef HAS_TEXTURE_OPACITY\n            #ifdef TRANSFORMALPHATEXCOORDS\n                uv=vec2(texCoordOrig.s,1.0-texCoordOrig.t);\n            #endif\n            #ifdef ALPHA_MASK_ALPHA\n                col.a*=texture(texOpacity,uv).a;\n            #endif\n            #ifdef ALPHA_MASK_LUMI\n                col.a*=dot(vec3(0.2126,0.7152,0.0722), texture(texOpacity,uv).rgb);\n            #endif\n            #ifdef ALPHA_MASK_R\n                col.a*=texture(texOpacity,uv).r;\n            #endif\n            #ifdef ALPHA_MASK_G\n                col.a*=texture(texOpacity,uv).g;\n            #endif\n            #ifdef ALPHA_MASK_B\n                col.a*=texture(texOpacity,uv).b;\n            #endif\n            // #endif\n        #endif\n    #endif\n\n    {{MODULE_COLOR}}\n\n    #ifdef DISCARDTRANS\n        if(col.a<0.2) discard;\n    #endif\n\n    outColor = col;\n}\n",basicmaterial_vert:"{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nIN vec3 attrVertNormal;\nIN vec2 attrTexCoord;\n\nOUT vec3 norm;\nOUT vec2 texCoord;\nOUT vec2 texCoordOrig;\n\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\n#ifdef HAS_TEXTURES\n    UNI float diffuseRepeatX;\n    UNI float diffuseRepeatY;\n    UNI float texOffsetX;\n    UNI float texOffsetY;\n#endif\n\nvoid main()\n{\n    mat4 mMatrix=modelMatrix;\n    mat4 mvMatrix;\n\n    norm=attrVertNormal;\n    texCoordOrig=attrTexCoord;\n    texCoord=attrTexCoord;\n    #ifdef HAS_TEXTURES\n        texCoord.x=texCoord.x*diffuseRepeatX+texOffsetX;\n        texCoord.y=texCoord.y*diffuseRepeatY+texOffsetY;\n    #endif\n\n    vec4 pos = vec4(vPosition, 1.0);\n\n    #ifdef BILLBOARD\n       vec3 position=vPosition;\n       mvMatrix=viewMatrix*modelMatrix;\n\n       gl_Position = projMatrix * mvMatrix * vec4((\n           position.x * vec3(\n               mvMatrix[0][0],\n               mvMatrix[1][0],\n               mvMatrix[2][0] ) +\n           position.y * vec3(\n               mvMatrix[0][1],\n               mvMatrix[1][1],\n               mvMatrix[2][1]) ), 1.0);\n    #endif\n\n    {{MODULE_VERTEX_POSITION}}\n\n    #ifndef BILLBOARD\n        mvMatrix=viewMatrix * mMatrix;\n    #endif\n\n\n    #ifndef BILLBOARD\n        // gl_Position = projMatrix * viewMatrix * modelMatrix * pos;\n        gl_Position = projMatrix * mvMatrix * pos;\n    #endif\n}\n",};
const render=op.inTrigger("render");
const trigger=op.outTrigger('trigger');
const shaderOut=op.outObject("shader");
shaderOut.ignoreValueSerialize=true;

const cgl=op.patch.cgl;




op.toWorkPortsNeedToBeLinked(render,trigger);

const shader=new CGL.Shader(cgl,"basicmaterialnew");
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.bindTextures=bindTextures;
shader.setSource(attachments.basicmaterial_vert,attachments.basicmaterial_frag);
shaderOut.set(shader);

render.onTriggered=doRender;

function bindTextures()
{
    if(diffuseTexture.get()) cgl.setTexture(0, diffuseTexture.get().tex);
    if(op.textureOpacity.get()) cgl.setTexture(1, op.textureOpacity.get().tex);
}

op.preRender=function()
{
    shader.bind();
    doRender();
};

function doRender()
{
    if(!shader)return;

    cgl.setShader(shader);
    shader.bindTextures();
    trigger.trigger();
    cgl.setPreviousShader();
}

// rgba colors
const r=op.inValueSlider("r",Math.random());
const g=op.inValueSlider("g",Math.random());
const b=op.inValueSlider("b",Math.random());
const a=op.inValueSlider("a",1);
r.setUiAttribs({"colorPick":true});

const unir=new CGL.Uniform(shader,'f','r',r);
const unig=new CGL.Uniform(shader,'f','g',g);
const unib=new CGL.Uniform(shader,'f','b',b);
const unia=new CGL.Uniform(shader,'f','a',a);

op.setPortGroup("Color",[r,g,b,a]);

    // diffuse outTexture

    var diffuseTexture=op.inTexture("texture");
    var diffuseTextureUniform=null;
    shader.bindTextures=bindTextures;

    diffuseTexture.onChange=updateDiffuseTexture;

    function updateDiffuseTexture()
    {
        if(diffuseTexture.get())
        {
            if(!shader.hasDefine('HAS_TEXTURE_DIFFUSE'))shader.define('HAS_TEXTURE_DIFFUSE');
            if(!diffuseTextureUniform)diffuseTextureUniform=new CGL.Uniform(shader,'t','texDiffuse',0);

            diffuseRepeatX.setUiAttribs({greyout:false});
            diffuseRepeatY.setUiAttribs({greyout:false});
            diffuseOffsetX.setUiAttribs({greyout:false});
            diffuseOffsetY.setUiAttribs({greyout:false});
            colorizeTexture.setUiAttribs({greyout:false});
        }
        else
        {
            shader.removeUniform('texDiffuse');
            shader.removeDefine('HAS_TEXTURE_DIFFUSE');
            diffuseTextureUniform=null;

            diffuseRepeatX.setUiAttribs({greyout:true});
            diffuseRepeatY.setUiAttribs({greyout:true});
            diffuseOffsetX.setUiAttribs({greyout:true});
            diffuseOffsetY.setUiAttribs({greyout:true});
            colorizeTexture.setUiAttribs({greyout:true});

        }
    };
const colorizeTexture=op.inValueBool("colorizeTexture",false);

op.setPortGroup("Color Texture",[diffuseTexture,colorizeTexture]);


// opacity texture
op.textureOpacity=op.inTexture("textureOpacity");
op.textureOpacityUniform=null;

op.alphaMaskSource=op.inSwitch("Alpha Mask Source",["Luminance","R","G","B","A"],"Luminance");
op.alphaMaskSource.onChange=updateAlphaMaskMethod;
op.alphaMaskSource.setUiAttribs({greyout:true});

function updateAlphaMaskMethod()
{
    if(op.alphaMaskSource.get()=='Alpha Channel') shader.define('ALPHA_MASK_ALPHA');
        else shader.removeDefine('ALPHA_MASK_ALPHA');

    if(op.alphaMaskSource.get()=='Luminance') shader.define('ALPHA_MASK_LUMI');
        else shader.removeDefine('ALPHA_MASK_LUMI');

    if(op.alphaMaskSource.get()=='R') shader.define('ALPHA_MASK_R');
        else shader.removeDefine('ALPHA_MASK_R');

    if(op.alphaMaskSource.get()=='G') shader.define('ALPHA_MASK_G');
        else shader.removeDefine('ALPHA_MASK_G');

    if(op.alphaMaskSource.get()=='B') shader.define('ALPHA_MASK_B');
        else shader.removeDefine('ALPHA_MASK_B');
}

op.textureOpacity.onChange=updateOpacity;
function updateOpacity()
{

    if(op.textureOpacity.get())
    {
        if(op.textureOpacityUniform!==null)return;
        shader.removeUniform('texOpacity');
        shader.define('HAS_TEXTURE_OPACITY');
        if(!op.textureOpacityUniform)op.textureOpacityUniform=new CGL.Uniform(shader,'t','texOpacity',1);

        op.alphaMaskSource.setUiAttribs({greyout:false});
        discardTransPxl.setUiAttribs({greyout:false});
        texCoordAlpha.setUiAttribs({greyout:false});

    }
    else
    {
        shader.removeUniform('texOpacity');
        shader.removeDefine('HAS_TEXTURE_OPACITY');
        op.textureOpacityUniform=null;

        op.alphaMaskSource.setUiAttribs({greyout:true});
        discardTransPxl.setUiAttribs({greyout:true});
        texCoordAlpha.setUiAttribs({greyout:true});
    }
    updateAlphaMaskMethod();
};


var texCoordAlpha=op.inValueBool("Opacity TexCoords Transform",false);
const discardTransPxl=op.inValueBool("Discard Transparent Pixels");

discardTransPxl.onChange=function()
{
    if(discardTransPxl.get()) shader.define('DISCARDTRANS');
        else shader.removeDefine('DISCARDTRANS');
};


texCoordAlpha.onChange=function()
{
    if(texCoordAlpha.get()) shader.define('TRANSFORMALPHATEXCOORDS');
        else shader.removeDefine('TRANSFORMALPHATEXCOORDS');
};

op.setPortGroup("Opacity",[op.textureOpacity,op.alphaMaskSource,discardTransPxl,texCoordAlpha]);


colorizeTexture.onChange=function()
{
    if(colorizeTexture.get()) shader.define('COLORIZE_TEXTURE');
        else shader.removeDefine('COLORIZE_TEXTURE');
};




// texture coords

const diffuseRepeatX=op.inValue("diffuseRepeatX",1);
const diffuseRepeatY=op.inValue("diffuseRepeatY",1);
const diffuseOffsetX=op.inValue("Tex Offset X",0);
const diffuseOffsetY=op.inValue("Tex Offset Y",0);

const diffuseRepeatXUniform=new CGL.Uniform(shader,'f','diffuseRepeatX',diffuseRepeatX);
const diffuseRepeatYUniform=new CGL.Uniform(shader,'f','diffuseRepeatY',diffuseRepeatY);
const diffuseOffsetXUniform=new CGL.Uniform(shader,'f','texOffsetX',diffuseOffsetX);
const diffuseOffsetYUniform=new CGL.Uniform(shader,'f','texOffsetY',diffuseOffsetY);

op.setPortGroup("Texture Transform",[diffuseRepeatX,diffuseRepeatY,diffuseOffsetX,diffuseOffsetY]);



const doBillboard=op.inValueBool("billboard",false);

doBillboard.onChange=function()
{
    if(doBillboard.get()) shader.define('BILLBOARD');
        else shader.removeDefine('BILLBOARD');
};

updateOpacity();
updateDiffuseTexture();

};

Ops.Gl.Shader.BasicMaterial_v2.prototype = new CABLES.Op();
CABLES.OPS["51f2207b-daaa-447f-bdbe-87fdd72f0c40"]={f:Ops.Gl.Shader.BasicMaterial_v2,objName:"Ops.Gl.Shader.BasicMaterial_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Color
// 
// **************************************************************

Ops.Gl.TextureEffects.Color = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={color_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float amount;\n\n#ifdef MASK\n    UNI sampler2D mask;\n#endif\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec4 col=vec4(r,g,b,1.0);\n    vec4 base=texture(tex,texCoord);\n\n    float am=amount;\n    #ifdef MASK\n        float msk=texture(mask,texCoord).r;\n        #ifdef INVERTMASK\n            msk=1.0-msk;\n        #endif\n        am*=1.0-msk;\n    #endif\n\n    outColor= cgl_blend(base,col,am);\n    outColor.a*=base.a;\n\n}\n",};
const
    render=op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    inMask=op.inTexture("Mask"),
    inMaskInvert=op.inValueBool("Mask Invert"),
    r=op.inValueSlider("r",Math.random()),
    g=op.inValueSlider("g",Math.random()),
    b=op.inValueSlider("b",Math.random()),
    trigger=op.outTrigger("trigger");

r.setUiAttribs({colorPick:true});

op.setPortGroup('Color',[r,g,b]);

const TEX_SLOT=0;
const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'textureeffect color');

var srcFrag=attachments.color_frag||'';

shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',TEX_SLOT),
    makstextureUniform=new CGL.Uniform(shader,'t','mask',1),
    uniformR=new CGL.Uniform(shader,'f','r',r),
    uniformG=new CGL.Uniform(shader,'f','g',g),
    uniformB=new CGL.Uniform(shader,'f','b',b),
    uniformAmount=new CGL.Uniform(shader,'f','amount',amount);

inMask.onChange=function()
{
    if(inMask.get())shader.define("MASK");
        else shader.removeDefine("MASK");
};

inMaskInvert.onChange=function()
{
    if(inMaskInvert.get())shader.define("INVERTMASK");
        else shader.removeDefine("INVERTMASK");
};


CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(TEX_SLOT, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    if(inMask.get()) cgl.setTexture(1, inMask.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Color.prototype = new CABLES.Op();
CABLES.OPS["c0acfc80-16f9-4f17-978d-bad650f3ed1c"]={f:Ops.Gl.TextureEffects.Color,objName:"Ops.Gl.TextureEffects.Color"};




// **************************************************************
// 
// Ops.Gl.RandomCluster
// 
// **************************************************************

Ops.Gl.RandomCluster = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    num=op.inValueInt("num"),
    seed=op.inValueFloat("random seed",1),
    round=op.inValueBool('round',false),
    size=op.inValueFloat("size",10),
    scaleX=op.inValueFloat("scaleX",1),
    scaleY=op.inValueFloat("scaleY",1),
    scaleZ=op.inValueFloat("scaleZ",1),
    trigger=op.outTrigger("trigger"),
    idx=op.outValue("index"),
    rnd=op.outValue("rnd"),
    rotX=op.inValueSlider("Rotate X",1),
    rotY=op.inValueSlider("Rotate Y",1),
    rotZ=op.inValueSlider("Rotate Z",1),
    scrollX=op.inValue("Scroll X",0);

op.setPortGroup("Area",[size,scaleX,scaleY,scaleZ]);
op.setPortGroup("Rotation",[rotX,rotY,rotZ]);
op.setPortGroup("Parameters",[num,round,seed]);
op.toWorkPortsNeedToBeLinked(exe,trigger);

const cgl=op.patch.cgl;
var randoms=[];
var origRandoms=[];
var randomsRot=[];
var randomsFloats=[];

var transVec=vec3.create();
var mat=mat4.create();

function doRender()
{

    if(CABLES.UI && (CABLES.UI.renderHelper || gui.patch().isCurrentOp(op)))
    {
        CABLES.GL_MARKER.drawCube(op,
            size.get()/2*scaleX.get(),
            size.get()/2*scaleY.get(),
            size.get()/2*scaleZ.get());
    }

    if(scrollX.get()!=0)
    {
        for(var i=0;i<origRandoms.length;i++)
        {
            randoms[i][0]=origRandoms[i][0]+scrollX.get();
            randoms[i][0]=(randoms[i][0]%size.get())-(size.get()/2);
        }
    }

    for(var i=0;i<randoms.length;i++)
    {
        cgl.pushModelMatrix();

        mat4.translate(cgl.mMatrix,cgl.mMatrix, randoms[i]);

        if(randomsRot[i][0]) mat4.rotateX(cgl.mMatrix,cgl.mMatrix, randomsRot[i][0]);
        if(randomsRot[i][1]) mat4.rotateY(cgl.mMatrix,cgl.mMatrix, randomsRot[i][1]);
        if(randomsRot[i][2]) mat4.rotateZ(cgl.mMatrix,cgl.mMatrix, randomsRot[i][2]);

        idx.set(i);
        rnd.set(randomsFloats[i]);

        trigger.trigger();
        // op.patch.instancing.increment();

        cgl.popModelMatrix();
    }
    // op.patch.instancing.popLoop();

}

exe.onTriggered=doRender;

function getRandomPos()
{
    return vec3.fromValues(
        scaleX.get()*(Math.seededRandom()-0.5)*size.get(),
        scaleY.get()*(Math.seededRandom()-0.5)*size.get(),
        scaleZ.get()*(Math.seededRandom()-0.5)*size.get()
        );
}


function reset()
{
    randoms.length=0;
    randomsRot.length=0;
    randomsFloats.length=0;
    origRandoms.length=0;

    Math.randomSeed=seed.get();

    var makeRound=round.get();

    for(var i=0;i<num.get();i++)
    {
        randomsFloats.push(Math.seededRandom());

        var v=getRandomPos();

        if(makeRound)
            while(vec3.len(v)>size.get()/2)
                v=getRandomPos();

        origRandoms.push( [ v[0],v[1],v[2] ]);
        randoms.push(v);

        randomsRot.push(vec3.fromValues(
            Math.seededRandom()*360*CGL.DEG2RAD*rotX.get(),
            Math.seededRandom()*360*CGL.DEG2RAD*rotY.get(),
            Math.seededRandom()*360*CGL.DEG2RAD*rotZ.get()
            ));
    }
}

seed.onChange=reset;
num.onChange=reset;
size.onChange=reset;
scaleX.onChange=reset;
scaleZ.onChange=reset;
scaleY.onChange=reset;
round.onChange=reset;
rotX.onChange=reset;
rotY.onChange=reset;
rotZ.onChange=reset;

num.set(100);

};

Ops.Gl.RandomCluster.prototype = new CABLES.Op();
CABLES.OPS["ca3bc984-e596-48fb-b53d-502eb13979b0"]={f:Ops.Gl.RandomCluster,objName:"Ops.Gl.RandomCluster"};




// **************************************************************
// 
// Ops.Gl.Meshes.Rectangle
// 
// **************************************************************

Ops.Gl.Meshes.Rectangle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger("render");
var trigger=op.outTrigger('trigger');

var width=op.inValue("width",1);
var height=op.inValue("height",1);

var pivotX=op.inSwitch("pivot x",["left","center","right"]);
var pivotY=op.inSwitch("pivot y",["top","center","bottom"]);

var nColumns=op.inValueInt("num columns",1);
var nRows=op.inValueInt("num rows",1);
var axis=op.inSwitch("axis",["xy","xz"],"xy");

var active=op.inValueBool('Active',true);

var geomOut=op.outObject("geometry");
geomOut.ignoreValueSerialize=true;

var cgl=op.patch.cgl;
axis.set('xy');
pivotX.set('center');
pivotY.set('center');

op.setPortGroup('Pivot',[pivotX,pivotY]);
op.setPortGroup('Size',[width,height]);
op.setPortGroup('Structure',[nColumns,nRows]);

var geom=new CGL.Geometry('rectangle');
var mesh=null;

axis.onChange=rebuild;
pivotX.onChange=rebuild;
pivotY.onChange=rebuild;
width.onChange=rebuild;
height.onChange=rebuild;
nRows.onChange=rebuild;
nColumns.onChange=rebuild;
rebuild();

op.preRender=
render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpNotInTextureEffect(op)) return;


    if(active.get() && mesh) mesh.render(cgl.getShader());
    trigger.trigger();
};

function rebuild()
{
    var w=width.get();
    var h=height.get();
    var x=0;
    var y=0;

    if(typeof w=='string')w=parseFloat(w);
    if(typeof h=='string')h=parseFloat(h);

    if(pivotX.get()=='center') x=0;
    else if(pivotX.get()=='right') x=-w/2;
    else if(pivotX.get()=='left') x=+w/2;

    if(pivotY.get()=='center') y=0;
    else if(pivotY.get()=='top') y=-h/2;
    else if(pivotY.get()=='bottom') y=+h/2;

    var verts=[];
    var tc=[];
    var norms=[];
    var tangents=[];
    var biTangents=[];
    var indices=[];

    var numRows=Math.round(nRows.get());
    var numColumns=Math.round(nColumns.get());

    var stepColumn=w/numColumns;
    var stepRow=h/numRows;

    var c,r,a;
    a=axis.get();
    for(r=0;r<=numRows;r++)
    {
        for(c=0;c<=numColumns;c++)
        {
            verts.push( c*stepColumn - width.get()/2+x );
            if(a=='xz') verts.push( 0.0 );
            verts.push( r*stepRow - height.get()/2+y );
            if(a=='xy') verts.push( 0.0 );

            tc.push( c/numColumns );
            tc.push( 1.0-r/numRows );

            if(a=='xz')
            {
                norms.push(0,1,0);
                tangents.push(1,0,0);
                biTangents.push(0,0,1);
            }
            else if(a=='xy')
            {
                norms.push(0,0,1);
                tangents.push(-1,0,0);
                biTangents.push(0,-1,0);
            }
        }
    }

    for(c=0;c<numColumns;c++)
    {
        for(r=0;r<numRows;r++)
        {
            var ind = c+(numColumns+1)*r;
            var v1=ind;
            var v2=ind+1;
            var v3=ind+numColumns+1;
            var v4=ind+1+numColumns+1;

            indices.push(v1);
            indices.push(v3);
            indices.push(v2);

            indices.push(v2);
            indices.push(v3);
            indices.push(v4);
        }
    }

    geom.clear();
    geom.vertices=verts;
    geom.texCoords=tc;
    geom.verticesIndices=indices;
    geom.vertexNormals=norms;
    geom.tangents=tangents;
    geom.biTangents=biTangents;

    if(numColumns*numRows>64000)geom.unIndex();

    if(!mesh) mesh=new CGL.Mesh(cgl,geom);
        else mesh.setGeom(geom);

    geomOut.set(null);
    geomOut.set(geom);

}

op.onDelete=function()
{
    if(mesh)mesh.dispose();
}

};

Ops.Gl.Meshes.Rectangle.prototype = new CABLES.Op();
CABLES.OPS["20f3c4e7-04d1-44e0-b868-05756d1c66c6"]={f:Ops.Gl.Meshes.Rectangle,objName:"Ops.Gl.Meshes.Rectangle"};




// **************************************************************
// 
// Ops.Anim.RandomAnim
// 
// **************************************************************

Ops.Anim.RandomAnim = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=op.inTrigger("exe");

var min=op.inValue("min",0);
var max=op.inValue("max",1);
var seed=op.inValue("random seed",0);

var duration=op.inValue("duration",0.5);
var pause=op.inValue("pause between",0);
var next=op.outTrigger("Next");
var result=op.outValue("result");
var looped=op.outTrigger("Looped");
var anim=new CABLES.Anim();
anim.createPort(op,"easing",reinit);

op.setPortGroup("Timing",[duration,pause]);
op.setPortGroup("Value",[min,max,seed]);

op.toWorkPortsNeedToBeLinked(exe);

var counter=0;

min.onChange=
max.onChange=
pause.onChange=
seed.onChange=
duration.onChange=reinitLater;

var needsReinit=true;

function reinitLater()
{
    needsReinit=true;
}

function getRandom()
{
    var minVal = ( min.get() );
    return Math.seededRandom() * (  max.get()  - minVal ) + minVal;
}

function reinit()
{
    Math.randomSeed=seed.get()+counter*100;
    init(getRandom());
    needsReinit=false;
}

function init(v)
{
    anim.clear();

    anim.setValue(op.patch.freeTimer.get(), v);
    if(pause.get()!==0.0) anim.setValue(op.patch.freeTimer.get()+pause.get(), v);

    anim.setValue(duration.get()+op.patch.freeTimer.get()+pause.get(), getRandom());
}


exe.onTriggered=updateExe;

function updateExe()
{
    if(needsReinit)reinit();

    var t=op.patch.freeTimer.get();
    var v=anim.getValue(t);

    if(anim.hasEnded(t))
    {
        counter++;
        anim.clear();
        init(v);
        looped.trigger();
    }
    result.set(v);
    next.trigger();
};



};

Ops.Anim.RandomAnim.prototype = new CABLES.Op();
CABLES.OPS["2d2e5f0e-b69f-4789-9a48-1ee6ade5049a"]={f:Ops.Anim.RandomAnim,objName:"Ops.Anim.RandomAnim"};




// **************************************************************
// 
// Ops.Math.Multiply
// 
// **************************************************************

Ops.Math.Multiply = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1=op.inValueFloat("number1");
const number2=op.inValueFloat("number2");
const result=op.outValue("result");

number1.set(1);
number2.set(2);

number1.onChange=update;
number2.onChange=update;
update();

function update()
{
    const n1=number1.get();
    const n2=number2.get();

    if(isNaN(n1))n1=0;
    if(isNaN(n2))n2=0;

    result.set( n1*n2 );
}



};

Ops.Math.Multiply.prototype = new CABLES.Op();
CABLES.OPS["1bbdae06-fbb2-489b-9bcc-36c9d65bd441"]={f:Ops.Math.Multiply,objName:"Ops.Math.Multiply"};




// **************************************************************
// 
// Ops.Gl.DepthTest
// 
// **************************************************************

Ops.Gl.DepthTest = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// todo:rename to depthtest

var render=op.inTrigger("Render");
var enable=op.inValueBool("Enable depth testing",true);
var meth=op.inValueSelect("Depth Test Method",['never','always','less','less or equal','greater', 'greater or equal','equal','not equal'],'less or equal');
var write=op.inValueBool("Write to depth buffer",true);
var trigger=op.outTrigger("Next");

var cgl=op.patch.cgl;
var compareMethod=cgl.gl.LEQUAL;

meth.onChange=updateFunc;

function updateFunc()
{
    if(meth.get()=='never') compareMethod=cgl.gl.NEVER;
    else if(meth.get()=='always') compareMethod=cgl.gl.ALWAYS;
    else if(meth.get()=='less') compareMethod=cgl.gl.LESS;
    else if(meth.get()=='less or equal') compareMethod=cgl.gl.LEQUAL;
    else if(meth.get()=='greater') compareMethod=cgl.gl.GREATER;
    else if(meth.get()=='greater or equal') compareMethod=cgl.gl.GEQUAL;
    else if(meth.get()=='equal') compareMethod=cgl.gl.EQUAL;
    else if(meth.get()=='not equal') compareMethod=cgl.gl.NOTEQUAL;
}

render.onTriggered=function()
{
    cgl.pushDepthTest(enable.get());
    cgl.pushDepthWrite(write.get());
    cgl.pushDepthFunc(compareMethod);

    trigger.trigger();

    cgl.popDepthTest();
    cgl.popDepthWrite();
    cgl.popDepthFunc();
};

};

Ops.Gl.DepthTest.prototype = new CABLES.Op();
CABLES.OPS["3996ed5d-8143-4bec-9cfd-c1b193a295af"]={f:Ops.Gl.DepthTest,objName:"Ops.Gl.DepthTest"};




// **************************************************************
// 
// Ops.Gl.Matrix.Transform
// 
// **************************************************************

Ops.Gl.Matrix.Transform = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    posX=op.inValue("posX",0),
    posY=op.inValue("posY",0),
    posZ=op.inValue("posZ",0),
    scale=op.inValue("scale",1),
    rotX=op.inValue("rotX",0),
    rotY=op.inValue("rotY",0),
    rotZ=op.inValue("rotZ",0),
    trigger=op.outTrigger("trigger");

op.setPortGroup('Rotation',[rotX,rotY,rotZ]);
op.setPortGroup('Position',[posX,posY,posZ]);
op.setPortGroup('Scale',[scale]);
op.setUiAxisPorts(posX,posY,posZ);

const cgl=op.patch.cgl;
var vPos=vec3.create();
var vScale=vec3.create();
var transMatrix = mat4.create();
mat4.identity(transMatrix);

var
    doScale=false,
    doTranslate=false,
    translationChanged=true,
    scaleChanged=true,
    rotChanged=true;

rotX.onChange=rotY.onChange=rotZ.onChange=setRotChanged;
posX.onChange=posY.onChange=posZ.onChange=setTranslateChanged;
scale.onChange=setScaleChanged;

render.onTriggered=function()
{
    // if(!CGL.TextureEffect.checkOpNotInTextureEffect(op)) return;

    var updateMatrix=false;
    if(translationChanged)
    {
        updateTranslation();
        updateMatrix=true;
    }
    if(scaleChanged)
    {
        updateScale();
        updateMatrix=true;
    }
    if(rotChanged) updateMatrix=true;

    if(updateMatrix) doUpdateMatrix();

    cgl.pushModelMatrix();
    mat4.multiply(cgl.mMatrix,cgl.mMatrix,transMatrix);

    trigger.trigger();
    cgl.popModelMatrix();

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:posX,
                posY:posY,
                posZ:posZ,
            });
};

op.transform3d=function()
{
    return { pos:[posX,posY,posZ] };
};

function doUpdateMatrix()
{
    mat4.identity(transMatrix);
    if(doTranslate)mat4.translate(transMatrix,transMatrix, vPos);

    if(rotX.get()!==0)mat4.rotateX(transMatrix,transMatrix, rotX.get()*CGL.DEG2RAD);
    if(rotY.get()!==0)mat4.rotateY(transMatrix,transMatrix, rotY.get()*CGL.DEG2RAD);
    if(rotZ.get()!==0)mat4.rotateZ(transMatrix,transMatrix, rotZ.get()*CGL.DEG2RAD);

    if(doScale)mat4.scale(transMatrix,transMatrix, vScale);
    rotChanged=false;
}

function updateTranslation()
{
    doTranslate=false;
    if(posX.get()!==0.0 || posY.get()!==0.0 || posZ.get()!==0.0) doTranslate=true;
    vec3.set(vPos, posX.get(),posY.get(),posZ.get());
    translationChanged=false;
}

function updateScale()
{
    // doScale=false;
    // if(scale.get()!==0.0)
    doScale=true;
    vec3.set(vScale, scale.get(),scale.get(),scale.get());
    scaleChanged=false;
}

function setTranslateChanged()
{
    translationChanged=true;
}

function setScaleChanged()
{
    scaleChanged=true;
}

function setRotChanged()
{
    rotChanged=true;
}

doUpdateMatrix();




};

Ops.Gl.Matrix.Transform.prototype = new CABLES.Op();
CABLES.OPS["650baeb1-db2d-4781-9af6-ab4e9d4277be"]={f:Ops.Gl.Matrix.Transform,objName:"Ops.Gl.Matrix.Transform"};




// **************************************************************
// 
// Ops.Gl.Matrix.Scale
// 
// **************************************************************

Ops.Gl.Matrix.Scale = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    scale=op.inValueFloat("scale",1.0),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const vScale=vec3.create();

scale.onChange=scaleChanged;
scaleChanged();

render.onTriggered=function()
{
    cgl.pushModelMatrix();
    mat4.scale(cgl.mMatrix,cgl.mMatrix, vScale);
    trigger.trigger();
    cgl.popModelMatrix();
};

function scaleChanged()
{
    var s=scale.get();
    vec3.set(vScale, s,s,s);
}



};

Ops.Gl.Matrix.Scale.prototype = new CABLES.Op();
CABLES.OPS["50e7f565-0cdb-47ca-912b-87c04e2f00e3"]={f:Ops.Gl.Matrix.Scale,objName:"Ops.Gl.Matrix.Scale"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.BarrelDistortion
// 
// **************************************************************

Ops.Gl.TextureEffects.BarrelDistortion = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={barreldistort_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\n\n// adapted from https://www.shadertoy.com/view/MlSXR3\n\n\nvec2 brownConradyDistortion(vec2 uv)\n{\n// positive values of K1 give barrel distortion, negative give pincushion\n    float barrelDistortion1 = 0.15-amount; // K1 in text books\n    float barrelDistortion2 = 0.0-amount; // K2 in text books\n    float r2 = uv.x*uv.x + uv.y*uv.y;\n    uv *= 1.0 + barrelDistortion1 * r2 + barrelDistortion2 * r2 * r2;\n\n    // tangential distortion (due to off center lens elements)\n    // is not modeled in this function, but if it was, the terms would go here\n    return uv;\n}\n\nvoid main()\n{\n   vec2 tc=brownConradyDistortion(texCoord-0.5)+0.5;\n   vec4 col=texture(tex,tc);\n   outColor= col;\n}",};
var render=op.inTrigger('render');
var amount=op.inValue("amount");

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.barreldistort_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniamount=new CGL.Uniform(shader,'f','amount',0);


render.onTriggered=function()
{

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    uniamount.setValue(amount.get()*(1/texture.width));

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );
    // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, texture.tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.BarrelDistortion.prototype = new CABLES.Op();
CABLES.OPS["57eda803-bda4-4b22-b578-608cabb9859e"]={f:Ops.Gl.TextureEffects.BarrelDistortion,objName:"Ops.Gl.TextureEffects.BarrelDistortion"};




// **************************************************************
// 
// Ops.TimeLine.TimeLineTime
// 
// **************************************************************

Ops.TimeLine.TimeLineTime = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var theTime=op.outValue("time");

op.onAnimFrame=function(time)
{
    theTime.set(time);
};

};

Ops.TimeLine.TimeLineTime.prototype = new CABLES.Op();
CABLES.OPS["3ab26f26-a12a-4c48-9411-20591a5f569d"]={f:Ops.TimeLine.TimeLineTime,objName:"Ops.TimeLine.TimeLineTime"};




// **************************************************************
// 
// Ops.Math.Divide
// 
// **************************************************************

Ops.Math.Divide = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    number1 = op.inValueFloat("number1",1),
    number2 = op.inValueFloat("number2",1),
    result = op.outValue("result");

number1.onChange=number2.onChange=exec;
exec();

function exec()
{
    result.set( number1.get() / number2.get() );
}



};

Ops.Math.Divide.prototype = new CABLES.Op();
CABLES.OPS["86fcfd8c-038d-4b91-9820-a08114f6b7eb"]={f:Ops.Math.Divide,objName:"Ops.Math.Divide"};




// **************************************************************
// 
// Ops.Math.Floor
// 
// **************************************************************

Ops.Math.Floor = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1=op.inValue("Number");
const result=op.outValue("Result");
number1.onChange=exec;

function exec()
{
    result.set(Math.floor(number1.get()));
}



};

Ops.Math.Floor.prototype = new CABLES.Op();
CABLES.OPS["0c77617c-b688-4b55-addf-2cbcaabf98af"]={f:Ops.Math.Floor,objName:"Ops.Math.Floor"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Levels
// 
// **************************************************************

Ops.Gl.TextureEffects.Levels = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={levels_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float inMin;\nUNI float inMax;\nUNI float midPoint;\nUNI float outMax;\nUNI float outMin;\n\nvoid main()\n{\n    vec3 base=texture(tex,texCoord).rgb;\n    vec3 inputRange = min(max(base - vec3(inMin), vec3(0.0)) / (vec3(inMax) - vec3(inMin)), vec3(outMax));\n\n    inputRange = pow(inputRange, vec3(1.0 / (1.5 - midPoint)));\n\n    outColor.a=1.0;\n    outColor.rgb= mix(vec3(outMin), vec3(1.0), inputRange);\n}",};
var render=op.inTrigger('Render');

var inMin=op.inValueSlider("In Min",0);
var inMid=op.inValueSlider("Midpoint",0.5);
var inMax=op.inValueSlider("In Max",1);

var outMin=op.inValueSlider("Out Min",0);
var outMax=op.inValueSlider("Out Max",1);

var trigger=op.addOutPort(new CABLES.Port(op,"Next",CABLES.OP_PORT_TYPE_FUNCTION));

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);

var uniInMin=new CGL.Uniform(shader,'f','inMin',inMin);
var uniInMid=new CGL.Uniform(shader,'f','midPoint',inMid);
var uniInMax=new CGL.Uniform(shader,'f','inMax',inMax);

var uniOutMin=new CGL.Uniform(shader,'f','outMin',outMin);
var uniOutMax=new CGL.Uniform(shader,'f','outMax',outMax);

shader.setSource(shader.getDefaultVertexShader(),attachments.levels_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Levels.prototype = new CABLES.Op();
CABLES.OPS["42ad6bbe-df17-48c7-89dd-bd7022113897"]={f:Ops.Gl.TextureEffects.Levels,objName:"Ops.Gl.TextureEffects.Levels"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.PixelDisplacement_v3
// 
// **************************************************************

Ops.Gl.TextureEffects.PixelDisplacement_v3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={pixeldisplace3_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI sampler2D displaceTex;\nUNI float amountX;\nUNI float amountY;\nUNI float amount;\n\n{{CGL.BLENDMODES}}\n\nvec3 getOffset(vec3 offset)\n{\n    #ifdef ZERO_BLACK\n        return offset;\n    #endif\n\n    #ifdef ZERO_GREY\n        return offset*2.0-1.0;\n    #endif\n}\n\nfloat getOffset(float offset)\n{\n    #ifdef ZERO_BLACK\n        return offset;\n    #endif\n\n    #ifdef ZERO_GREY\n        return offset*2.0-1.0;\n    #endif\n}\n\nvoid main()\n{\n    vec3 offset=texture(displaceTex,texCoord).rgb;\n    float x,y;\n\n    #ifdef INPUT_REDGREEN\n        offset=getOffset(offset);\n        x=offset.r*amountX+texCoord.x;\n        y=offset.g*amountY+texCoord.y;\n    #endif\n    #ifdef INPUT_RED\n        offset=getOffset(offset);\n        x=offset.r*amountX+texCoord.x;\n        y=offset.r*amountY+texCoord.y;\n    #endif\n    #ifdef INPUT_GREEN\n        offset=getOffset(offset);\n        x=offset.g*amountX+texCoord.x;\n        y=offset.g*amountY+texCoord.y;\n    #endif\n    #ifdef INPUT_BLUE\n        offset=getOffset(offset);\n        x=offset.b*amountX+texCoord.x;\n        y=offset.b*amountY+texCoord.y;\n    #endif\n    #ifdef INPUT_LUMINANCE\n        float o=dot(vec3(0.2126,0.7152,0.0722), offset);\n        o=getOffset(o);\n        x=o*amountX+texCoord.x;\n        y=o*amountY+texCoord.y;\n    #endif\n    #ifdef WRAP_CLAMP\n        x=clamp(x,0.0,1.0);\n        y=clamp(y,0.0,1.0);\n    #endif\n    #ifdef WRAP_REPEAT\n        x=mod(x,1.0);\n        y=mod(y,1.0);\n    #endif\n    #ifdef WRAP_MIRROR\n        float mx=mod(x,2.0);\n        float my=mod(y,2.0);\n        x=abs((floor(mx)-fract(mx)));\n        y=abs((floor(my)-fract(my)));\n    #endif\n\n    vec4 col=texture(tex,vec2(x,y));\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,col,amount);\n}",};
const
    render=op.inTrigger("render"),
    displaceTex=op.inTexture("displaceTex"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    amountX=op.inValueSlider("amount X"),
    amountY=op.inValueSlider("amount Y"),
    inWrap=op.inSwitch("Wrap",["Mirror","Clamp","Repeat"],"Mirror"),
    inInput=op.inValueSelect("Input",["Luminance","RedGreen","Red","Green","Blue"],"Luminance"),
    inZero=op.inSwitch("Zero Displace",["Grey","Black"],"Grey"),
    // displaceTex=op.inTexture("displaceTex"),
    trigger=op.outTrigger("trigger");

op.setPortGroup("Axis Displacement Strength",[amountX,amountY]);
op.setPortGroup("Modes",[inWrap,inInput]);
op.toWorkPortsNeedToBeLinked(displaceTex);

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.pixeldisplace3_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    textureDisplaceUniform=new CGL.Uniform(shader,'t','displaceTex',1),
    amountXUniform=new CGL.Uniform(shader,'f','amountX',amountX),
    amountYUniform=new CGL.Uniform(shader,'f','amountY',amountY),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount);

inZero.onChange=updateZero;
inWrap.onChange=updateWrap;
inInput.onChange=updateInput;

updateWrap();
updateInput();
updateZero();

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

function updateZero()
{
    shader.removeDefine("ZERO_BLACK");
    shader.removeDefine("ZERO_GREY");
    shader.define("ZERO_"+(inZero.get()+'').toUpperCase());
}

function updateWrap()
{
    shader.removeDefine("WRAP_CLAMP");
    shader.removeDefine("WRAP_REPEAT");
    shader.removeDefine("WRAP_MIRROR");
    shader.define("WRAP_"+(inWrap.get()+'').toUpperCase());
}

function updateInput()
{
    shader.removeDefine("INPUT_LUMINANCE");
    shader.removeDefine("INPUT_REDGREEN");
    shader.removeDefine("INPUT_RED");
    shader.define("INPUT_"+(inInput.get()+'').toUpperCase());
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    if(displaceTex.get()) cgl.setTexture(1, displaceTex.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.PixelDisplacement_v3.prototype = new CABLES.Op();
CABLES.OPS["c089646e-9324-48b2-8b32-81240408222e"]={f:Ops.Gl.TextureEffects.PixelDisplacement_v3,objName:"Ops.Gl.TextureEffects.PixelDisplacement_v3"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Gradient
// 
// **************************************************************

Ops.Gl.TextureEffects.Gradient = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={gradient_frag:"IN vec2 texCoord;\nUNI float amount;\nUNI float pos;\nUNI float width;\n\nUNI vec3 colA;\nUNI vec3 colB;\nUNI vec3 colC;\nUNI sampler2D tex;\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec4 col;\n    float ax=texCoord.x;\n\n    #ifdef GRAD_Y\n        ax=texCoord.y;\n    #endif\n    #ifdef GRAD_XY\n        ax=(texCoord.x+texCoord.y)/2.0;\n    #endif\n    #ifdef GRAD_RADIAL\n        ax=distance(texCoord,vec2(0.5,0.5))*2.0;\n    #endif\n\n    ax=((ax-0.5)*width)+0.5;\n\n    #ifndef GRAD_SMOOTHSTEP\n        if(ax<=pos) col = vec4(mix(colA, colB, ax*1.0/pos),1.0);\n            else col = vec4(mix(colB, colC, min(1.0,(ax-pos)*1.0/(1.0-pos))),1.0);\n    #endif\n\n    #ifdef GRAD_SMOOTHSTEP\n        if(ax<=pos) col = vec4(mix(colA, colB, smoothstep(0.0,1.0,ax*1.0/pos)),1.0);\n            else col = vec4(mix(colB, colC, smoothstep(0.0,1.0,min(1.0,(ax-pos)*1.0/(1.0-pos)))),1.0);\n    #endif\n\n    outColor=cgl_blend(base,col,amount);\n}",};
const render=op.inTrigger("Render");
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const width=op.inValue("Width",1);
const gType=op.inSwitch("Type",['X','Y','XY','Radial'],"X");
const pos1=op.inValueSlider("Pos",0.5);
const smoothStep=op.inValueBool("Smoothstep",true);

const r = op.inValueSlider("r", Math.random());
const g = op.inValueSlider("g", Math.random());
const b = op.inValueSlider("b", Math.random());
r.setUiAttribs({ colorPick: true });

const r2 = op.inValueSlider("r2", Math.random());
const g2 = op.inValueSlider("g2", Math.random());
const b2 = op.inValueSlider("b2", Math.random());
r2.setUiAttribs({ colorPick: true });

const r3 = op.inValueSlider("r3", Math.random());
const g3 = op.inValueSlider("g3", Math.random());
const b3 = op.inValueSlider("b3", Math.random());
r3.setUiAttribs({ colorPick: true });

smoothStep.onChange=updateSmoothstep;

op.setPortGroup('Blending',[blendMode,amount]);
op.setPortGroup('Color A',[r,g,b]);
op.setPortGroup('Color B',[r2,g2,b2]);
op.setPortGroup('Color C',[r3,g3,b3]);

const randomize=op.inTriggerButton("Randomize");
var next=op.outTrigger("Next");

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'gradient');

shader.setSource(shader.getDefaultVertexShader(),attachments.gradient_frag);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);
var uniPos=new CGL.Uniform(shader,'f','pos',pos1);
var uniWidth=new CGL.Uniform(shader,'f','width',width);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var r3uniform,r2uniform,runiform;

r2.onChange=g2.onChange=b2.onChange=updateCol2;
r3.onChange=g3.onChange=b3.onChange=updateCol3;
r.onChange=g.onChange=b.onChange=updateCol;

updateCol();
updateCol2();
updateCol3();
updateSmoothstep();

function updateSmoothstep()
{
    if(smoothStep.get()) shader.define('GRAD_SMOOTHSTEP');
        else shader.removeDefine('GRAD_SMOOTHSTEP');
}

gType.onChange=function()
{
    shader.removeDefine('GRAD_X');
    shader.removeDefine('GRAD_Y');
    shader.removeDefine('GRAD_XY');
    shader.removeDefine('GRAD_RADIAL');

    if(gType.get()=='XY') shader.define('GRAD_XY');
    if(gType.get()=='X') shader.define('GRAD_X');
    if(gType.get()=='Y') shader.define('GRAD_Y');
    if(gType.get()=='Radial')shader.define('GRAD_RADIAL');
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

randomize.onTriggered=function()
{
    r.set(Math.random());
    g.set(Math.random());
    b.set(Math.random());

    r2.set(Math.random());
    g2.set(Math.random());
    b2.set(Math.random());

    r3.set(Math.random());
    g3.set(Math.random());
    b3.set(Math.random());
};

function updateCol()
{
    var colA=[r.get(),g.get(),b.get()];
    if(!runiform) runiform=new CGL.Uniform(shader,'3f','colA',colA);
        else runiform.setValue(colA);
}

function updateCol2()
{
    var colB=[r2.get(),g2.get(),b2.get()];
    if(!r2uniform) r2uniform=new CGL.Uniform(shader,'3f','colB',colB);
        else r2uniform.setValue(colB);
}

function updateCol3()
{
    var colC=[r3.get(),g3.get(),b3.get()];
    if(!r3uniform) r3uniform=new CGL.Uniform(shader,'3f','colC',colC);
        else r3uniform.setValue(colC);
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    next.trigger();
};


};

Ops.Gl.TextureEffects.Gradient.prototype = new CABLES.Op();
CABLES.OPS["5ada9bd8-227a-4a1f-87ad-0f879c7aa84d"]={f:Ops.Gl.TextureEffects.Gradient,objName:"Ops.Gl.TextureEffects.Gradient"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ScaleTexture
// 
// **************************************************************

Ops.Gl.TextureEffects.ScaleTexture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={scale_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float uScaleX,uScaleY;\nUNI float offsetX,offsetY;\nUNI float centerX,centerY;\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec2 uv = texCoord;\n\n    uv.x = (uv.x - centerX) / uScaleX + centerX+offsetX;\n    uv.y = (uv.y - centerY) / uScaleY + centerY+offsetY;\n\n    //blend section\n    vec4 col = texture(tex,uv);\n    //original texture\n    vec4 base = texture(tex,texCoord);\n\n    //blend stuff\n\n    outColor=cgl_blend(base,col,amount);\n}\n",};
const
    render=op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    scaleX=op.inValue("Scale X",1.5),
    scaleY=op.inValue("Scale Y",1.5),
    offsetX=op.inValueSlider("offset X",0),
    offsetY=op.inValueSlider("offset Y",0),
    centerX=op.inValueSlider("center X",0.5),
    centerY=op.inValueSlider("center Y",0.5),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.scale_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    scaleXUniform=new CGL.Uniform(shader,'f','uScaleX',scaleX),
    scaleYUniform=new CGL.Uniform(shader,'f','uScaleY',scaleY),
    centerXUniform=new CGL.Uniform(shader,'f','centerX',centerX),
    centerYUniform=new CGL.Uniform(shader,'f','centerY',centerY),
    offsetXUniform=new CGL.Uniform(shader,'f','offsetX',offsetX),
    offsetYUniform=new CGL.Uniform(shader,'f','offsetY',offsetY);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.ScaleTexture.prototype = new CABLES.Op();
CABLES.OPS["12cfa989-d575-4ee2-9deb-5392097c5a27"]={f:Ops.Gl.TextureEffects.ScaleTexture,objName:"Ops.Gl.TextureEffects.ScaleTexture"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Circle_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.Circle_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={circle_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float amount;\nUNI float size;\nUNI float inner;\nUNI float fadeOut;\n\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\nUNI float aspect;\nUNI float stretch;\n\nUNI float x;\nUNI float y;\n\n{{CGL.BLENDMODES}}\n\nfloat dist(float x,float y,float x2,float y2)\n{\n\tfloat xd = x2-x;\n\tfloat yd = y2-y;\n\treturn abs(sqrt(xd*xd + yd*yd*(1.0-stretch)));\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec4 col=vec4(0.0,0.0,0.0,1.0);\n    float dist = dist(x,y,texCoord.x-0.5,(1.0-texCoord.y-1.0)*aspect+0.5);\n\n    float sz=size*0.5;\n    float v=0.0;\n    float fade=fadeOut+0.002;\n\n    if(dist<sz && dist>inner*sz) v=1.0;\n\n    #ifdef FALLOFF_SMOOTHSTEP\n        if(dist>sz && dist<sz+fade)v=1.0-(smoothstep(0.0,1.0,(dist-sz)/(fade)) );\n    #endif\n    #ifndef FALLOFF_SMOOTHSTEP\n        if(dist>sz && dist<sz+fade)v=1.0-((dist-sz)/(fade));\n    #endif\n\n    col=vec4( _blend(base.rgb,vec3(r,g,b)) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*v*amount),1.0);\n    outColor=col;\n\n    #ifdef WARN_OVERFLOW\n        float width=0.01;\n        if( texCoord.x>(1.0-width) || texCoord.y>(1.0-width) || texCoord.y<width || texCoord.x<width )\n            if(v>0.001*amount)outColor= vec4(1.0,0.0,0.0, 1.0);\n    #endif\n}\n",};
var render=op.inTrigger("render");
var blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
var amount=op.inValueSlider("Amount",1);
var inSize=op.inValueSlider("size");
var inInner=op.inValueSlider("Inner");
var inStretch=op.inValueSlider("Stretch");

var inX=op.inValue("Pos X",0);
var inY=op.inValue("Pos Y",0);

var fallOff=op.inValueSelect("fallOff",['Linear','SmoothStep'],"Linear");
var inFadeOut=op.inValueSlider("fade Out");
var warnOverflow=op.inValueBool("warn overflow",true);

const r = op.inValueSlider("r", 1);
const g = op.inValueSlider("g", 1);
const b = op.inValueSlider("b", 1);
const a = op.inValueSlider("a", 1);

r.setUiAttribs({ colorPick: true });

op.setPortGroup("Size",[inSize,inInner,inStretch]);
op.setPortGroup("Position",[inX,inY]);
op.setPortGroup("Style",[warnOverflow,fallOff,inFadeOut]);


var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'textureeffect stripes');
shader.setSource(shader.getDefaultVertexShader(),attachments.circle_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);


var uniStretch=new CGL.Uniform(shader,'f','stretch',inStretch);
var uniSize=new CGL.Uniform(shader,'f','size',inSize);
var uniFadeOut=new CGL.Uniform(shader,'f','fadeOut',inFadeOut);
var uniInner=new CGL.Uniform(shader,'f','inner',inInner);
var aspect=new CGL.Uniform(shader,'f','aspect',1);

inSize.set(0.25);

setFallOf();
setWarnOverflow();

var uniformR=new CGL.Uniform(shader,'f','r',r);
var uniformG=new CGL.Uniform(shader,'f','g',g);
var uniformB=new CGL.Uniform(shader,'f','b',b);
var uniformA=new CGL.Uniform(shader,'f','a',a);

var uniformX=new CGL.Uniform(shader,'f','x',inX);
var uniformY=new CGL.Uniform(shader,'f','y',inY);

fallOff.onChange=setFallOf;
warnOverflow.onChange=setWarnOverflow;

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

function setFallOf()
{
    shader.removeDefine('FALLOFF_LINEAR');
    shader.removeDefine('FALLOFF_SMOOTHSTEP');

    if(fallOff.get()=='Linear') shader.define('FALLOFF_LINEAR');
    if(fallOff.get()=='SmoothStep') shader.define('FALLOFF_SMOOTHSTEP');
}

function setWarnOverflow()
{
    if(warnOverflow.get()) shader.define('WARN_OVERFLOW');
        else shader.removeDefine('WARN_OVERFLOW');
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var a=cgl.currentTextureEffect.getCurrentSourceTexture().height/cgl.currentTextureEffect.getCurrentSourceTexture().width;
    aspect.set(a);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Circle_v2.prototype = new CABLES.Op();
CABLES.OPS["03a2ff88-f3af-4042-8e64-62e70e17e1bc"]={f:Ops.Gl.TextureEffects.Circle_v2,objName:"Ops.Gl.TextureEffects.Circle_v2"};




// **************************************************************
// 
// Ops.Gl.Performance
// 
// **************************************************************

Ops.Gl.Performance = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    inShow=op.inValueBool("Visible",true),
    next=op.outTrigger("childs"),
    outFPS=op.outValue("FPS");

// var exe=this.addInPort(new CABLES.Port(this,"exe",CABLES.OP_PORT_TYPE_FUNCTION));
// var next=this.addOutPort(new CABLES.Port(this,"childs",CABLES.OP_PORT_TYPE_FUNCTION)) ;

const cgl=op.patch.cgl;
var element = document.createElement('div');
var elementMeasures=null;
var ctx=null;
var opened=false;
var frameCount=0;
var fps=0;
var fpsStartTime=0;
var childsTime=0;
var avgMsChilds=0;
var queue=[];
var queueChilds=[];
var numBars=128;
var avgMs=0;
var selfTime=0;
var canvas=null;
var lastTime=0;
var loadingCounter=0;
var loadingChars=['|','/','-','\\'];

exe.onLinkChanged =
    inShow.onChange = updateVisibility;


for(var i=0;i<numBars;i++)
{
    queue[i]=-1;
    queueChilds[i]=-1;
}

element.id="performance";
element.style.position="absolute";
element.style.left="0px";
element.style.top="0px";
element.style.opacity="0.8";
element.style.padding="10px";
element.style.cursor="pointer";
element.style.background="#222";
element.style.color="white";
element.style["font-family"]="monospace";
element.style["font-size"]="12px";
element.style["z-index"]="9999";
element.innerHTML="&nbsp;";

var container = op.patch.cgl.canvas.parentElement;
container.appendChild(element);

element.addEventListener("click", toggleOpened);


op.onDelete=function()
{
    if(canvas)canvas.remove();
    if(element)element.remove();
};


function updateVisibility()
{
    if(!inShow.get() || !exe.isLinked())
    {
        element.style.display='none';
        element.style.opacity=0;
    }
    else
    {
        element.style.display='block';
        element.style.opacity=1;
    }
}

function toggleOpened()
{
    if(!inShow.get())return;
    element.style.opacity=1;
    opened=!opened;
    updateText();
    if(!canvas)createCanvas();
    if(opened)
    {
        canvas.style.display="block";
        element.style.left=numBars+"px";
        element.style["min-height"]="56px";
    }
    else
    {
        canvas.style.display="none";
        element.style.left="0px";
        element.style["min-height"]="auto";
    }
}

function updateCanvas()
{
    ctx.fillStyle="#222222";
    ctx.fillRect(0,0,canvas.width,canvas.height);

    ctx.fillStyle="#555555";
    var k=0;
    for(k=numBars;k>=0;k--)
    {
        if(queue[k]>30)ctx.fillStyle="#ff5555";
        ctx.fillRect(numBars-k,canvas.height-queue[k]*2.5,1,queue[k]*2.5);
        if(queue[k]>30)ctx.fillStyle="#555555";
    }

    ctx.fillStyle="#aaaaaa";
    for(k=numBars;k>=0;k--)
    {
        if(queueChilds[k]>30)ctx.fillStyle="#ff00ff";
        ctx.fillRect(numBars-k,canvas.height-queueChilds[k]*2.5,1,queueChilds[k]*2.5);
        if(queueChilds[k]>30)ctx.fillStyle="#aaaaaa";
    }

}

function createCanvas()
{
    canvas = document.createElement('canvas');
    canvas.id     = "performance_"+op.patch.config.glCanvasId;
    canvas.width  = numBars;
    canvas.height = "128";
    canvas.style.display   = "block";
    canvas.style.opacity   = 0.9;
    canvas.style.position  = "absolute";
    canvas.style.left  = "0px";
    canvas.style.cursor  = "pointer";
    canvas.style.top  = "-64px";
    canvas.style['z-index']   = "9998";
    container.appendChild(canvas);
    ctx = canvas.getContext('2d');

    canvas.addEventListener("click", toggleOpened);

}

function updateText()
{
    if(!inShow.get())return;
    var warn="";
    if(CGL.profileData.profileShaderCompiles>0)warn+='Shader compile ('+CGL.profileData.profileShaderCompileName+') ';
    if(CGL.profileData.profileShaderGetUniform>0)warn+='Shader get uni loc! ('+CGL.profileData.profileShaderGetUniformName+')';
    if(CGL.profileData.profileTextureResize>0)warn+='Texture resize! ';
    if(CGL.profileData.profileFrameBuffercreate>0)warn+='Framebuffer create! ';
    if(CGL.profileData.profileEffectBuffercreate>0)warn+='Effectbuffer create! ';
    if(CGL.profileData.profileTextureDelete>0)warn+='Texture delete! ';
    if(CGL.profileData.profileNonTypedAttrib>0)warn+='Not-Typed Buffer Attrib! '+CGL.profileData.profileNonTypedAttribNames;

    if(warn.length>0)
    {
        warn='| <span style="color:#f80;">WARNING: '+warn+'<span>';
    }

    element.innerHTML=fps+" fps | "+Math.round(childsTime*100)/100+"ms "+warn;
    if(op.patch.loading.getProgress()!=1.0)
    {
        element.innerHTML+="<br/>loading "+Math.round(op.patch.loading.getProgress()*100)+'% '+loadingChars[ (++loadingCounter)%loadingChars.length ];
    }

    if(opened)
    {
        var count=0;
        avgMs=0;
        avgMsChilds=0;
        for(var i=queue.length;i>queue.length-queue.length/3;i--)
        {
            if(queue[i]>-1)
            {
                avgMs+=queue[i];
                count++;
            }

            if(queueChilds[i]>-1)
            {
                avgMsChilds+=queueChilds[i];
            }
        }

        avgMs/=count;
        avgMsChilds/=count;

        element.innerHTML+='<br/> '+cgl.canvasWidth+' x '+cgl.canvasHeight+' (x'+cgl.pixelDensity+') ';
        element.innerHTML+='<br/>frame avg: '+Math.round(avgMsChilds*100)/100+' ms ('+Math.round(avgMsChilds/avgMs*100)+'%) / '+Math.round(avgMs*100)/100+' ms';
        element.innerHTML+=' (self: '+Math.round((selfTime)*100)/100+' ms) ';

        element.innerHTML+='<br/>shader binds: '+Math.ceil(CGL.profileData.profileShaderBinds/fps)+
            ' uniforms: '+Math.ceil(CGL.profileData.profileUniformCount/fps)+
            ' mvp_uni_mat4: '+Math.ceil(CGL.profileData.profileMVPMatrixCount/fps)+
            ' mesh.setGeom: '+CGL.profileData.profileMeshSetGeom+
            ' videos: '+CGL.profileData.profileVideosPlaying;


        // var vars= CABLES.patch.getVars();

        // element.innerHTML+='<br/><br/>vars:<br/>';

        // for(var ki in vars)
        // {
        //     var v=parseFloat(vars[ki].getValue());
        //     if(isNaN(v)) v="[...]"
        //     element.innerHTML+=' - '+ki+': <b>'+v+'</b><br/>';
        // }
    }

    CGL.profileData.profileUniformCount=0;
    CGL.profileData.profileShaderGetUniform=0;
    CGL.profileData.profileShaderCompiles=0;
    CGL.profileData.profileShaderBinds=0;
    CGL.profileData.profileTextureResize=0;
    CGL.profileData.profileFrameBuffercreate=0;
    CGL.profileData.profileEffectBuffercreate=0;
    CGL.profileData.profileTextureDelete=0;
    CGL.profileData.profileMeshSetGeom=0;
    CGL.profileData.profileVideosPlaying=0;
    CGL.profileData.profileMVPMatrixCount=0;
    CGL.profileData.profileNonTypedAttrib=0;
    CGL.profileData.profileNonTypedAttribNames="";
}


function styleMeasureEle(ele)
{
    ele.style.padding="0px";
    ele.style.margin="0px";
}

function addMeasureChild(m,parentEle,timeSum,level)
{
    const height=20;
    m.usedAvg=(m.usedAvg||m.used);

    if(!m.ele || initMeasures)
    {
        var newEle = document.createElement('div');
        m.ele=newEle;

        if(m.childs && m.childs.length>0) newEle.style.height='500px';
            else  newEle.style.height=height+'px';

        newEle.style.overflow='hidden';
        newEle.style.display='inline-block';

        if(!m.isRoot)
        {
            newEle.innerHTML='<div style="min-height:'+height+'px;width:100%;overflow:hidden;color:black;position:relative">&nbsp;'+m.name+'</div>';
            newEle.style['background-color']="rgb("+m.colR+","+m.colG+","+m.colB+")";
            newEle.style['border-left']='1px solid black';
        }

        parentEle.appendChild(newEle);
    }


    if(!m.isRoot)
    {
        if(performance.now()-m.lastTime>200)
        {
            m.ele.style.display="none";
            m.hidden=true;
        }
        else
        {
            if(m.hidden)
            {
                m.ele.style.display="inline-block";
                m.hidden=false;
            }
        }

        m.ele.style.float='left';
        m.ele.style.width=Math.floor((m.usedAvg/timeSum)*98.)+'%';
    }
    else
    {
        m.ele.style.width='100%';
        m.ele.style.clear='both';
        m.ele.style.float='none';
    }

    if(m && m.childs && m.childs.length>0)
    {
        var thisTimeSum=0;
        for(var i=0;i<m.childs.length;i++)
        {
            m.childs[i].usedAvg=(m.childs[i].usedAvg||m.childs[i].used)*0.95+m.childs[i].used*0.05;
            thisTimeSum+=m.childs[i].usedAvg;
        }
        for(var i=0;i<m.childs.length;i++)
        {
            addMeasureChild(m.childs[i],m.ele,thisTimeSum,level+1);
        }
    }

}

var initMeasures=true;

function clearMeasures(p)
{
    for(var i=0;i<p.childs.length;i++)
    {
        clearMeasures(p.childs[i]);
    }

    p.childs.length=0;

}

function measures()
{
    if(!CGL.performanceMeasures)return;

    if(!elementMeasures)
    {
        op.log("create measure ele");
        elementMeasures = document.createElement('div');
        elementMeasures.style.width="100%";
        elementMeasures.style['background-color']="#444";
        elementMeasures.style.bottom="10px";
        elementMeasures.style.height="100px";
        elementMeasures.style.opacity="1";
        elementMeasures.style.position="absolute";

        elementMeasures.style['z-index']="99999";
        elementMeasures.innerHTML='';
        container.appendChild(elementMeasures);
    }

    var timeSum=0;

    var root=CGL.performanceMeasures[0];

    for(var i=0;i<root.childs.length;i++)
    {
        timeSum+=root.childs[i].used;
    }

    addMeasureChild(CGL.performanceMeasures[0],elementMeasures,timeSum,0);

    root.childs.length=0;

    clearMeasures(CGL.performanceMeasures[0]);

    CGL.performanceMeasures.length=0;
    initMeasures=false;
}



exe.onTriggered=function()
{
    var selfTimeStart=performance.now();
    frameCount++;

    if(fpsStartTime===0)fpsStartTime=Date.now();
    if(Date.now()-fpsStartTime>=1000)
    {
        fps=frameCount;
        frameCount=0;
        frames=0;
        outFPS.set(fps);
        if(inShow.get())updateText();

        fpsStartTime=Date.now();
    }

    if(inShow.get())
    {
        measures();

        if(opened)
        {
            var timeUsed=performance.now()-lastTime;
            // if(timeUsed>30)op.log("peak ",performance.now()-lastTime);
            queue.push(timeUsed);
            queue.shift();

            queueChilds.push(childsTime);
            queueChilds.shift();

            updateCanvas();
        }
    }

    lastTime=performance.now();
    selfTime=performance.now()-selfTimeStart;
    var startTimeChilds=performance.now();

    next.trigger();

    childsTime=performance.now()-startTimeChilds;

};




};

Ops.Gl.Performance.prototype = new CABLES.Op();
CABLES.OPS["9cd2d9de-000f-4a14-bd13-e7d5f057583c"]={f:Ops.Gl.Performance,objName:"Ops.Gl.Performance"};




// **************************************************************
// 
// Ops.Patch.LoadingStatus
// 
// **************************************************************

Ops.Patch.LoadingStatus = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var self=this;
const cgl=op.patch.cgl;
const patch=op.patch;

this.exe=this.addInPort(new CABLES.Port(op,"exe",CABLES.OP_PORT_TYPE_FUNCTION));
this.finished=this.addOutPort(new CABLES.Port(op,"finished",CABLES.OP_PORT_TYPE_FUNCTION));
var result=this.addOutPort(new CABLES.Port(op,"status",CABLES.OP_PORT_TYPE_VALUE));
var isFinishedPort = op.outValue('all loaded', false);
var preRenderStatus=this.addOutPort(new CABLES.Port(op,"preRenderStatus",CABLES.OP_PORT_TYPE_VALUE));
var preRenderTimeFrames=this.addInPort(new CABLES.Port(op,"preRenderTimes",CABLES.OP_PORT_TYPE_VALUE));
var preRenderOps=op.inValueBool("PreRender Ops");
var startTimeLine=op.inBool("Play Timeline",true);
preRenderStatus.set(0);
this.numAssets=this.addOutPort(new CABLES.Port(op,"numAssets",CABLES.OP_PORT_TYPE_VALUE));
this.loading=this.addOutPort(new CABLES.Port(op,"loading",CABLES.OP_PORT_TYPE_FUNCTION));
var loadingFinished=op.outTrigger("loading finished");//this.addOutPort(new CABLES.Port(op,"loading finished",CABLES.OP_PORT_TYPE_FUNCTION));

var finishedAll=false;
var preRenderTimes=[];
var firstTime=true;

var identTranslate=vec3.create();
vec3.set(identTranslate, 0,0,0);
var identTranslateView=vec3.create();
vec3.set(identTranslateView, 0,0,-2);

document.body.classList.add("cables-loading");


var prerenderCount=0;
var preRenderAnimFrame=function(t)
{
    var time=preRenderTimes[prerenderCount];

    preRenderStatus.set(prerenderCount/(preRenderTimeFrames.anim.keys.length-1));

    op.patch.timer.setTime(time);
    cgl.renderStart(cgl,identTranslate,identTranslateView);

    self.finished.trigger();

    cgl.gl.clearColor(0,0,0,1);
    cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);

    self.loading.trigger();

    cgl.renderEnd(cgl);
    prerenderCount++;
};

this.onAnimFrame=null;
var loadingIdPrerender='';

this.onLoaded=function()
{
    if(preRenderTimeFrames.isAnimated())
    if(preRenderTimeFrames.anim)
        for(var i=0;i<preRenderTimeFrames.anim.keys.length;i++)
            preRenderTimes.push( preRenderTimeFrames.anim.keys[i].time );

    preRenderTimes.push(1);
};

function checkPreRender()
{
    if(patch.loading.getProgress()>=1.0)
    {
        if(preRenderTimeFrames.anim && prerenderCount>=preRenderTimeFrames.anim.keys.length)
        {
            self.onAnimFrame=function(){};
            isFinishedPort.set(true);
            finishedAll=true;
        }
        else
        {
            setTimeout(checkPreRender,30);
        }
    }
    else
    {
        setTimeout(checkPreRender,100);
    }
}

var loadingId=patch.loading.start('delayloading','delayloading');
setTimeout(function()
{
    patch.loading.finished(loadingId);
},100);

this.exe.onTriggered= function()
{
    result.set(patch.loading.getProgress());
    self.numAssets.set(patch.loading.getNumAssets());

    if(patch.loading.getProgress()>=1.0 && finishedAll)
    {
        if(firstTime)
        {
            if(preRenderOps.get()) op.patch.preRenderOps();
            loadingFinished.trigger();
            op.patch.timer.setTime(0);
            if(startTimeLine.get())
            {
                op.patch.timer.play();
                isFinishedPort.set(true);
            }
            firstTime=false;
        }

        self.finished.trigger();
        document.body.classList.remove("cables-loading");
        document.body.classList.add("cables-loaded");
    }
    else
    {
        if(!preRenderTimeFrames.anim)
        {
            finishedAll=true;
            self.onAnimFrame=function(){};
        }

        if(preRenderTimeFrames.anim && patch.loading.getProgress()>=1.0
            && prerenderCount<preRenderTimeFrames.anim.keys.length
        )
        {
            self.onAnimFrame=preRenderAnimFrame;
            checkPreRender();
            self.loading.trigger();
        }

        if(patch.loading.getProgress()<1.0)
        {
            self.loading.trigger();
            op.patch.timer.setTime(0);
            op.patch.timer.pause();
        }
    }

};

};

Ops.Patch.LoadingStatus.prototype = new CABLES.Op();
CABLES.OPS["30f01b6d-b234-4ebe-a2c3-ebffd96a31e9"]={f:Ops.Patch.LoadingStatus,objName:"Ops.Patch.LoadingStatus"};




// **************************************************************
// 
// Ops.Trigger.TriggerSend
// 
// **************************************************************

Ops.Trigger.TriggerSend = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var trigger=op.inTrigger("Trigger");
var varname=op.inValueSelect("Named Trigger");

varname.onChange=updateName;

trigger.onTriggered=doTrigger;

op.patch.addEventListener('namedTriggersChanged',updateVarNamesDropdown);

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.namedTriggers;
        varnames.push('+ create new one');
        for(var i in vars) varnames.push(i);
        varname.uiAttribs.values=varnames;
    }
}

function updateName()
{
    if(CABLES.UI)
    {
        if(varname.get()=='+ create new one')
        {
        	CABLES.UI.MODAL.prompt("New Trigger","enter a name for the new trigger",'',
        		function(str)
        		{
        		    varname.set(str);
                    op.patch.namedTriggers[str]=op.patch.namedTriggers[str]||[];
                    updateVarNamesDropdown();
        		});
            return;
        }

        gui.patch().showOpParams(op);
    }

    if(!op.patch.namedTriggers[varname.get()])
    {
        op.patch.namedTriggers[varname.get()]=op.patch.namedTriggers[varname.get()]||[];
        op.patch.emitEvent("namedTriggersChanged");
    }

    op.setTitle('>' + varname.get());

    if(CABLES.UI) gui.patch().showOpParams(op);
}

function doTrigger()
{
    var arr=op.patch.namedTriggers[varname.get()];

    if(!arr)
    {
        console.log("unknown trigger array!",varname.get());
        return;
    }

    for(var i=0;i<arr.length;i++)
    {
        arr[i]();
    }
}















};

Ops.Trigger.TriggerSend.prototype = new CABLES.Op();
CABLES.OPS["ce1eaf2b-943b-4dc0-ab5e-ee11b63c9ed0"]={f:Ops.Trigger.TriggerSend,objName:"Ops.Trigger.TriggerSend"};




// **************************************************************
// 
// Ops.Trigger.TriggerReceive
// 
// **************************************************************

Ops.Trigger.TriggerReceive = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const next=op.outTrigger("Triggered");
var varname=op.inValueSelect("Named Trigger");

updateVarNamesDropdown();
op.patch.addEventListener('namedTriggersChanged',updateVarNamesDropdown);


var oldName=null;

function doTrigger()
{
    next.trigger();
};


function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.namedTriggers;
        varnames.push('+ create new one');
        for(var i in vars) varnames.push(i);
        varname.uiAttribs.values=varnames;
    }
}

varname.onChange=function()
{

    if(oldName)
    {
        var oldCbs=op.patch.namedTriggers[oldName];
        var a=oldCbs.indexOf(doTrigger);
        if(a!=-1) oldCbs.splice(a,1);
    }

    op.setTitle('>' + varname.get());
    op.patch.namedTriggers[varname.get()]=op.patch.namedTriggers[varname.get()]||[];
    var cbs=op.patch.namedTriggers[varname.get()];

    cbs.push(doTrigger);
    oldName=varname.get();
};



};

Ops.Trigger.TriggerReceive.prototype = new CABLES.Op();
CABLES.OPS["0816c999-f2db-466b-9777-2814573574c5"]={f:Ops.Trigger.TriggerReceive,objName:"Ops.Trigger.TriggerReceive"};




// **************************************************************
// 
// Ops.Gl.Meshes.Circle
// 
// **************************************************************

Ops.Gl.Meshes.Circle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const radius=op.inValue('radius',0.5);
const innerRadius=op.inValueSlider('innerRadius',0);
const segments=op.inValueInt('segments',40);
const percent=op.inValueSlider('percent',1);
const steps=op.inValue('steps',0);
const invertSteps=op.inValueBool('invertSteps',false);
const mapping=op.inSwitch("mapping",['flat','round']);
const drawSpline=op.inValueBool("Spline",false);
const inDraw=op.inValueBool('Draw',true);
const trigger=op.outTrigger('trigger');
const geomOut=op.outObject("geometry");


op.setPortGroup('Size',[radius,innerRadius]);
op.setPortGroup('Display',[percent,steps,invertSteps]);

mapping.set('flat');

mapping.onChange=
    segments.onChange=
    radius.onChange=
    innerRadius.onChange=
    percent.onChange=
    steps.onChange=
    invertSteps.onChange=
    drawSpline.onChange=calcLater;

geomOut.ignoreValueSerialize=true;
const cgl=op.patch.cgl;

var geom=new CGL.Geometry("circle");
var mesh=null;
var lastSegs=-1;

var oldPrim=0;
var shader=null;
var needsCalc=true;

op.preRender=
render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpNotInTextureEffect(op)) return;

    if(needsCalc)calc();
    shader=cgl.getShader();
    if(!shader)return;
    oldPrim=shader.glPrimitive;

    if(drawSpline.get()) shader.glPrimitive=cgl.gl.LINE_STRIP;

    if(inDraw.get())mesh.render(shader);
    trigger.trigger();

    shader.glPrimitive=oldPrim;
};

function calc()
{
    var segs=Math.max(3,Math.floor(segments.get()));

    geom.clear();

    var faces=[];
    var texCoords=[];
    var vertexNormals=[];
    var tangents=[];
    var biTangents=[];

    var i=0,degInRad=0;
    var oldPosX=0,oldPosY=0;
    var oldPosXTexCoord=0,oldPosYTexCoord=0;

    var oldPosXIn=0,oldPosYIn=0;
    var oldPosXTexCoordIn=0,oldPosYTexCoordIn=0;

    var posxTexCoordIn=0,posyTexCoordIn=0;
    var posxTexCoord=0,posyTexCoord=0;
    var posx=0,posy=0;

    var verts=[];

    if(drawSpline.get())
    {
        var lastX=0;
        var lastY=0;
        var tc=[];
        for (i=0; i <= segs*percent.get(); i++)
        {
            degInRad = (360/segs)*i*CGL.DEG2RAD;
            posx=Math.cos(degInRad)*radius.get();
            posy=Math.sin(degInRad)*radius.get();

            posyTexCoord=0.5;

            if(i>0)
            {
                verts.push(lastX);
                verts.push(lastY);
                verts.push(0);
                posxTexCoord=1.0-(i-1)/segs;

                tc.push(posxTexCoord,posyTexCoord);
            }
            verts.push(posx);
            verts.push(posy);
            verts.push(0);

            lastX=posx;
            lastY=posy;
        }
        geom.setPointVertices(verts);
    }
    else
    if(innerRadius.get()<=0)
    {

        for (i=0; i <= segs*percent.get(); i++)
        {
            degInRad = (360/segs)*i*CGL.DEG2RAD;
            posx=Math.cos(degInRad)*radius.get();
            posy=Math.sin(degInRad)*radius.get();

            if(mapping.get()=='flat')
            {
                posxTexCoord=(Math.cos(degInRad)+1.0)/2;
                posyTexCoord=1.0-(Math.sin(degInRad)+1.0)/2;
                posxTexCoordIn=0.5;
                posyTexCoordIn=0.5;
            }
            else if(mapping.get()=='round')
            {
                posxTexCoord=1.0-i/segs;
                posyTexCoord=0;
                posxTexCoordIn=posxTexCoord;
                posyTexCoordIn=1;
            }

            faces.push(
                      [posx,posy,0],
                      [oldPosX,oldPosY,0],
                      [0,0,0]
                      );

            texCoords.push(posxTexCoord,posyTexCoord,oldPosXTexCoord,oldPosYTexCoord,posxTexCoordIn,posyTexCoordIn);
            vertexNormals.push(0,0,1,0,0,1,0,0,1);
            tangents.push(1,0,0,1,0,0,1,0,0);
            biTangents.push(0,1,0,0,1,0,0,1,0);

            oldPosXTexCoord=posxTexCoord;
            oldPosYTexCoord=posyTexCoord;

            oldPosX=posx;
            oldPosY=posy;
        }

        geom=CGL.Geometry.buildFromFaces(faces);
        geom.vertexNormals=vertexNormals;
        geom.tangents=tangents;
        geom.biTangents=biTangents;
        geom.texCoords=texCoords;
    }
    else
    {
        var count=0;
        var numSteps=segs*percent.get();
        var pos=0;

        for (i=0; i <= numSteps; i++)
        {
            count++;

            degInRad = (360/segs)*i*CGL.DEG2RAD;
            posx=Math.cos(degInRad)*radius.get();
            posy=Math.sin(degInRad)*radius.get();

            var posxIn=Math.cos(degInRad)*innerRadius.get()*radius.get();
            var posyIn=Math.sin(degInRad)*innerRadius.get()*radius.get();

            if(mapping.get()=='round')
            {
                posxTexCoord=1.0-i/segs;
                posyTexCoord=0;
                posxTexCoordIn=posxTexCoord;
                posyTexCoordIn=1;
            }

            if(steps.get()===0.0 ||
                (count%parseInt(steps.get(),10)===0 && !invertSteps.get()) ||
                (count%parseInt(steps.get(),10)!==0 && invertSteps.get()) )
            {
                faces.push(
                        [posx,posy,0],
                        [oldPosX,oldPosY,0],
                        [posxIn,posyIn,0]
                        );

                faces.push(
                        [posxIn,posyIn,0],
                        [oldPosX,oldPosY,0],
                        [oldPosXIn,oldPosYIn,0]
                        );

                texCoords.push(
                    posxTexCoord,0,
                    oldPosXTexCoord,0,
                    posxTexCoordIn,1,

                    posxTexCoord,1,
                    oldPosXTexCoord,0,
                    oldPosXTexCoordIn,1);

                vertexNormals.push(
                    0,0,1,0,0,1,0,0,1,
                    0,0,1,0,0,1,0,0,1
                );
                tangents.push(
                    1,0,0,1,0,0,1,0,0,
                    1,0,0,1,0,0,1,0,0
                );
                biTangents.push(
                    0,1,0,0,1,0,0,1,0,
                    0,1,0,0,1,0,0,1,0
                );
            }

            oldPosXTexCoordIn=posxTexCoordIn;
            oldPosYTexCoordIn=posyTexCoordIn;

            oldPosXTexCoord=posxTexCoord;
            oldPosYTexCoord=posyTexCoord;

            oldPosX=posx;
            oldPosY=posy;

            oldPosXIn=posxIn;
            oldPosYIn=posyIn;
        }

        geom=CGL.Geometry.buildFromFaces(faces);
        geom.vertexNormals=vertexNormals;
        geom.tangents=tangents;
        geom.biTangents=biTangents;

        if(mapping.get()=='flat') geom.mapTexCoords2d();
            else geom.texCoords=texCoords;
    }

    geomOut.set(null);
    geomOut.set(geom);

    if(geom.vertices.length==0)return;
    if(mesh) mesh.dispose();
    mesh=null;
    mesh=new CGL.Mesh(cgl,geom);
    needsCalc=false;
}

function calcLater()
{
    needsCalc=true;
}

op.onDelete=function()
{
    if(mesh)mesh.dispose();
}

};

Ops.Gl.Meshes.Circle.prototype = new CABLES.Op();
CABLES.OPS["4db917cc-2cef-43f4-83d5-38c4572fe943"]={f:Ops.Gl.Meshes.Circle,objName:"Ops.Gl.Meshes.Circle"};




// **************************************************************
// 
// Ops.Gl.TriggerOnCanvasResize
// 
// **************************************************************

Ops.Gl.TriggerOnCanvasResize = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const onResize=op.outTrigger("Resized");

op.patch.cgl.addEventListener("resize",resize);

function resize()
{
    onResize.trigger();
}


};

Ops.Gl.TriggerOnCanvasResize.prototype = new CABLES.Op();
CABLES.OPS["856de8cf-b8d1-4668-b8ff-80c68bc73ddd"]={f:Ops.Gl.TriggerOnCanvasResize,objName:"Ops.Gl.TriggerOnCanvasResize"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Scroll
// 
// **************************************************************

Ops.Gl.TextureEffects.Scroll = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={scroll_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amountX;\nUNI float amountY;\n\n#ifdef MASK\nUNI sampler2D texMask;\n#endif\n\nvoid main()\n{\n    float amX=amountX;\n    float amY=amountY;\n\n    #ifdef MASK\n        vec4 m=texture(texMask,texCoord);\n        amX*=(m.r-0.5)*2.0;\n        amY*=(m.g-0.5)*2.0;\n        // amX*=m.r;\n        // amY*=m.g;\n    #endif\n\n    vec4 col=vec4(0.0,0.0,0.0,1.0);\n    float x=mod(texCoord.x+amX,1.0);\n    float y=mod(texCoord.y+amY,1.0);\n\n\n    #ifdef NO_REPEAT\n        x=texCoord.x+amX*0.1;\n        y=texCoord.y+amY*0.1;\n    #endif\n\n    col=texture(tex,vec2(x,y));\n\n    #ifdef NO_REPEAT\n        if(x>1.0 || x<0.0 || y>1.0 || y<0.0) col=vec4(0.0,0.0,0.0,1.0);\n    #endif\n    outColor= col;\n}",};
const
    render=op.inTrigger('render'),
    trigger=op.outTrigger('trigger'),
    amountX=op.inValue("amountX"),
    amountY=op.inValue("amountY"),
    textureMask=op.inTexture("Mask"),
    repeat=op.inValueBool("Repeat",true);

repeat.onChange=updateRepeat;

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);
shader.setSource(shader.getDefaultVertexShader(),attachments.scroll_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountXUniform=new CGL.Uniform(shader,'f','amountX',amountX),
    amountYUniform=new CGL.Uniform(shader,'f','amountY',amountY),
    unitexMask=new CGL.Uniform(shader,'t','texMask',1);

updateRepeat();

textureMask.onChange=function()
{
    if(textureMask.get())shader.define("MASK");
    else shader.removeDefine("MASK");
};

function updateRepeat()
{
    if(!repeat.get())shader.define("NO_REPEAT");
    else shader.removeDefine("NO_REPEAT");
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    if(textureMask.get()) cgl.setTexture(1, textureMask.get().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Scroll.prototype = new CABLES.Op();
CABLES.OPS["9b151d99-7888-4948-81c7-cd23b334e8d4"]={f:Ops.Gl.TextureEffects.Scroll,objName:"Ops.Gl.TextureEffects.Scroll"};




// **************************************************************
// 
// Ops.Gl.Meshes.Sphere_v2
// 
// **************************************************************

Ops.Gl.Meshes.Sphere_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    TAU = Math.PI * 2,
    cgl = op.patch.cgl,
    inTrigger = op.inTrigger("render"),
    inRadius = op.inValue("radius", 1),
    inStacks = op.inValue("stacks", 32),
    inSlices = op.inValue("slices", 32),
    inStacklimit = op.inValueSlider("Filloffset", 1),
    inDraw = op.inValueBool("Render", true),
    outTrigger = op.outTrigger("trigger"),
    outGeometry = op.outObject("geometry"),
    UP = vec3.fromValues(0,1,0),
    RIGHT = vec3.fromValues(1,0,0)
;

var
    geom = new CGL.Geometry("Sphere"),
    tmpNormal = vec3.create(),
    tmpVec = vec3.create(),
    needsRebuild = true,
    mesh
;

function buildMesh () {
    const
        stacks = Math.max(inStacks.get(),2),
        slices = Math.max(inSlices.get(),3),
        stackLimit = Math.min(Math.max(inStacklimit.get()*stacks,1),stacks),
        radius = inRadius.get()
    ;

    var
        positions = [],
        texcoords = [],
        normals = [],
        tangents = [],
        biTangents = [],
        indices = [],
        x,y,z,d,t,a,
        o,u,v,i,j
    ;

    for (i = o = 0; i < stacks + 1; i++) {
        v = (i/stacks-.5)*Math.PI;
        y = Math.sin(v);
        a = Math.cos(v);
        for (j = 0; j < slices+1; j++) {
            u = (j/slices)*TAU;
            x = Math.cos(u)*a;
            z = Math.sin(u)*a;

            positions.push(x*radius,y*radius,z*radius);
            // texcoords.push(i/(stacks+1),j/slices);
            texcoords.push(j/slices,i/(stacks+1));

            d = Math.sqrt(x*x+y*y+z*z);
            normals.push(
                tmpNormal[0] = x/d,
                tmpNormal[1] = y/d,
                tmpNormal[2] = z/d
            );

            if (y == d) t = RIGHT;
            else t = UP;
            vec3.cross(tmpVec, tmpNormal, t);
            vec3.normalize(tmpVec,tmpVec);
            Array.prototype.push.apply(tangents, tmpVec);
            vec3.cross(tmpVec, tmpVec, tmpNormal);
            Array.prototype.push.apply(biTangents, tmpVec);
        }
        if (i == 0 || i > stackLimit) continue;
        for(j = 0; j < slices; j++,o++) {
            indices.push(
                o,o+1,o+slices+1,
                o+1,o+slices+2,o+slices+1
            );
        }
        o++;
    }

    // set geometry
    geom.clear();
    geom.vertices = positions;
    geom.texCoords = texcoords;
    geom.vertexNormals = normals;
    geom.tangents = tangents;
    geom.biTangents = biTangents;
    geom.verticesIndices = indices;

    outGeometry.set(null);
    outGeometry.set(geom);

    if (!mesh) mesh = new CGL.Mesh(cgl, geom);
    else mesh.setGeom(geom);

    needsRebuild = false;
}

// set event handlers
inTrigger.onTriggered = function () {
    if (needsRebuild) buildMesh();
    if (inDraw.get()) mesh.render(cgl.getShader());
    outTrigger.trigger();
};

inStacks.onChange =
inSlices.onChange =
inStacklimit.onChange =
inRadius.onChange = function() {
    // only calculate once, even after multiple settings could were changed
    needsRebuild = true;
};

// set lifecycle handlers
op.onDelete = function () { if(mesh)mesh.dispose(); };


};

Ops.Gl.Meshes.Sphere_v2.prototype = new CABLES.Op();
CABLES.OPS["450b4d68-2278-4d9f-9849-0abdfa37ef69"]={f:Ops.Gl.Meshes.Sphere_v2,objName:"Ops.Gl.Meshes.Sphere_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Invert
// 
// **************************************************************

Ops.Gl.TextureEffects.Invert = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={invert_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n   col=texture(tex,texCoord);\n   col.rgb=1.0-col.rgb;\n   outColor= col;\n}\n",};
const render=op.inTrigger('render');
const trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.invert_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Invert.prototype = new CABLES.Op();
CABLES.OPS["7188ff85-e73c-4a3b-8237-49508a00d63a"]={f:Ops.Gl.TextureEffects.Invert,objName:"Ops.Gl.TextureEffects.Invert"};




// **************************************************************
// 
// Ops.Array.ArrayGetString
// 
// **************************************************************

Ops.Array.ArrayGetString = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var array=op.inArray("array");
var index=op.inValueInt("index");

//when out is set to op.outString then index.onChange doesn't work
var result=op.outString("result");//original code

//setting it to a op.outValue does work on change
//var result=op.outValue("result");

array.ignoreValueSerialize=true;

index.onChange=update;
var arr=null;

array.onChange=function()
{
    arr=array.get();
    update();
};

function update()
{
    if(arr) result.set( arr[index.get()]);
}

};

Ops.Array.ArrayGetString.prototype = new CABLES.Op();
CABLES.OPS["be8f16c0-0c8a-48a2-a92b-45dbf88c76c1"]={f:Ops.Array.ArrayGetString,objName:"Ops.Array.ArrayGetString"};




// **************************************************************
// 
// Ops.String.StringNew2Old
// 
// **************************************************************

Ops.String.StringNew2Old = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const
    inStr=op.inString("String"),
    outStr=op.outValue("Result");

inStr.onChange=function(){
    const str=inStr.get();

    if(str!==0) outStr.set(str);
};

};

Ops.String.StringNew2Old.prototype = new CABLES.Op();
CABLES.OPS["dd3cf0b4-3dbc-41e1-9320-87befc0a0774"]={f:Ops.String.StringNew2Old,objName:"Ops.String.StringNew2Old"};




// **************************************************************
// 
// Ops.Trigger.TriggerCounterLoop
// 
// **************************************************************

Ops.Trigger.TriggerCounterLoop = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTriggerButton("trigger in"),
    reset=op.inTriggerButton("reset"),
    trigger=op.outTrigger("trigger out"),
    num=op.outValue("current count"),

    inMinLoopValue = op.inValueInt("Loop min",0.0),
    inMaxLoopValue = op.inValueInt("Loop max",4.0);

var n = Math.floor(inMinLoopValue.get());

//increments with each trigger and loops
//depending on min and max loop values
//can also work with negative numbers
//if min is greater than max then it decrements
//instead of incrementing
exe.onTriggered= function()
{
    var inMin = Math.floor(inMinLoopValue.get());
    var inMax = Math.floor(inMaxLoopValue.get());

    if(inMin < inMax)
    {
        if(n < inMin)
        {
            n = inMinLoopValue.get();
        }
        else if(n >= inMax)
        {
            n = inMinLoopValue.get();
        }
        else
        {
            n++;
        }
    }
    else if (inMin > inMax)
    {
        if(n < inMax)
        {
            n = inMin;
        }
        else if(n > inMin)
        {
            inMin;
        }
        else if (n <= inMax)
        {
            n = inMin;
        }
        else
        {
            n--;
        }
    }
    num.set(n);
    trigger.trigger();
};

reset.onTriggered= function()
{
    var inMin = Math.floor(inMinLoopValue.get());
    var inMax = Math.floor(inMaxLoopValue.get());

    if(inMin < inMax)
    {
        n = inMin
    }
    else if (inMax < inMin)
    {
        n = inMin;
    }
    else
    {
        n = 0;
    }
    num.set(n);
};


};

Ops.Trigger.TriggerCounterLoop.prototype = new CABLES.Op();
CABLES.OPS["d3356c53-e278-433f-af0b-d8327cd99a2d"]={f:Ops.Trigger.TriggerCounterLoop,objName:"Ops.Trigger.TriggerCounterLoop"};




// **************************************************************
// 
// Ops.Devices.Mouse.Mouse
// 
// **************************************************************

Ops.Devices.Mouse.Mouse = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    relative=op.inValueBool("relative"),
    normalize=op.inValueBool("normalize"),
    active=op.inValueBool("Active",true),
    smooth=op.inValueBool("smooth"),
    smoothSpeed=op.inValueFloat("smoothSpeed",20),
    area=op.inValueSelect("Area",['Canvas','Document','Parent Element'],"Canvas"),
    multiply=op.inValueFloat("multiply",1),
    flipY=op.inValueBool("flip y",true),
    outMouseX=op.outValue("x"),
    outMouseY=op.outValue("y"),
    rightClickPrevDef=op.inBool("right click prevent default",true),
    mouseDown=op.outValueBool("button down"),
    mouseClick=op.outTrigger("click"),
    mouseUp=op.outTrigger("Button Up"),
    mouseClickRight=op.outTrigger("click right"),

    mouseOver=op.outValueBool("mouseOver"),
    outButton=op.outValue("button");

var smoothTimer=0;
var cgl=op.patch.cgl;
var listenerElement=null;

function setValue(x,y)
{
    if(normalize.get())
    {
        var w=cgl.canvas.width/cgl.pixelDensity;
        var h=cgl.canvas.height/cgl.pixelDensity;
        if(listenerElement==document.body)
        {
            w=listenerElement.clientWidth/cgl.pixelDensity;
            h=listenerElement.clientHeight/cgl.pixelDensity;
        }
        outMouseX.set( (x/w*2.0-1.0)*multiply.get() );
        outMouseY.set( (y/h*2.0-1.0)*multiply.get() );
    }
    else
    {
        outMouseX.set( x*multiply.get() );
        outMouseY.set( y*multiply.get() );
    }
}

smooth.onChange=function()
{
    if(smooth.get()) smoothTimer = setInterval(updateSmooth, 5);
        else if(smoothTimer)clearTimeout(smoothTimer);
};

var smoothX,smoothY;
var lineX=0,lineY=0;

normalize.onChange=function()
{
    mouseX=0;
    mouseY=0;
    setValue(mouseX,mouseY);
};

var mouseX=cgl.canvas.width/2;
var mouseY=cgl.canvas.height/2;

lineX=mouseX;
lineY=mouseY;

outMouseX.set(mouseX);
outMouseY.set(mouseY);

var relLastX=0;
var relLastY=0;
var offsetX=0;
var offsetY=0;
addListeners();

area.onChange=addListeners;

var speed=0;

function updateSmooth()
{
    speed=smoothSpeed.get();
    if(speed<=0)speed=0.01;
    var distanceX = Math.abs(mouseX - lineX);
    var speedX = Math.round( distanceX / speed, 0 );
    lineX = (lineX < mouseX) ? lineX + speedX : lineX - speedX;

    var distanceY = Math.abs(mouseY - lineY);
    var speedY = Math.round( distanceY / speed, 0 );
    lineY = (lineY < mouseY) ? lineY + speedY : lineY - speedY;

    setValue(lineX,lineY);
}

function onMouseEnter(e)
{
    mouseDown.set(false);
    mouseOver.set(true);
    speed=smoothSpeed.get();
}

function onMouseDown(e)
{
    outButton.set(e.which);
    mouseDown.set(true);
}

function onMouseUp(e)
{
    outButton.set(0);
    mouseDown.set(false);
    mouseUp.trigger();
}

function onClickRight(e)
{
    mouseClickRight.trigger();
    if(rightClickPrevDef.get()) e.preventDefault();
}

function onmouseclick(e)
{
    mouseClick.trigger();
}


function onMouseLeave(e)
{
    relLastX=0;
    relLastY=0;

    speed=100;

    if(area.get()!='Document')
    {
        // leave anim
        if(smooth.get())
        {
            mouseX=cgl.canvas.width/2;
            mouseY=cgl.canvas.height/2;
        }

    }
    mouseOver.set(false);
    mouseDown.set(false);
}

relative.onChange=function()
{
    offsetX=0;
    offsetY=0;
}

function onmousemove(e)
{
    mouseOver.set(true);

    if(!relative.get())
    {
        if(area.get()!="Document")
        {
            offsetX=e.offsetX;
            offsetY=e.offsetY;
        }
        else
        {
            offsetX=e.clientX;
            offsetY=e.clientY;
        }

        if(smooth.get())
        {
            mouseX=offsetX;

            if(flipY.get()) mouseY=listenerElement.clientHeight-offsetY;
                else mouseY=offsetY;
        }
        else
        {
            if(flipY.get()) setValue(offsetX,listenerElement.clientHeight-offsetY);
                else setValue(offsetX,offsetY);
        }
    }
    else
    {
        if(relLastX!=0 && relLastY!=0)
        {
            offsetX=e.offsetX-relLastX;
            offsetY=e.offsetY-relLastY;
        }
        else
        {

        }

        relLastX=e.offsetX;
        relLastY=e.offsetY;

        mouseX+=offsetX;
        mouseY+=offsetY;

        if(mouseY>460)mouseY=460;
    }
};

function ontouchstart(event)
{
    mouseDown.set(true);

    if(event.touches && event.touches.length>0) onMouseDown(event.touches[0]);
}

function ontouchend(event)
{
    mouseDown.set(false);
    onMouseUp();
}

function removeListeners()
{
    listenerElement.removeEventListener('touchend', ontouchend);
    listenerElement.removeEventListener('touchstart', ontouchstart);

    listenerElement.removeEventListener('click', onmouseclick);
    listenerElement.removeEventListener('mousemove', onmousemove);
    listenerElement.removeEventListener('mouseleave', onMouseLeave);
    listenerElement.removeEventListener('mousedown', onMouseDown);
    listenerElement.removeEventListener('mouseup', onMouseUp);
    listenerElement.removeEventListener('mouseenter', onMouseEnter);
    listenerElement.removeEventListener('contextmenu', onClickRight);
    listenerElement=null;
}

function addListeners()
{
    if(listenerElement)removeListeners();

    listenerElement=cgl.canvas;
    if(area.get()=='Document') listenerElement=document.body;
    if(area.get()=='Parent Element') listenerElement=cgl.canvas.parentElement;

    listenerElement.addEventListener('touchend', ontouchend);
    listenerElement.addEventListener('touchstart', ontouchstart);

    listenerElement.addEventListener('click', onmouseclick);
    listenerElement.addEventListener('mousemove', onmousemove);
    listenerElement.addEventListener('mouseleave', onMouseLeave);
    listenerElement.addEventListener('mousedown', onMouseDown);
    listenerElement.addEventListener('mouseup', onMouseUp);
    listenerElement.addEventListener('mouseenter', onMouseEnter);
    listenerElement.addEventListener('contextmenu', onClickRight);
}

active.onChange=function()
{
    if(listenerElement)removeListeners();
    if(active.get())addListeners();
}

op.onDelete=function()
{
    removeListeners();
};

addListeners();


};

Ops.Devices.Mouse.Mouse.prototype = new CABLES.Op();
CABLES.OPS["0bf51f3e-3161-4cc5-aecf-6e9160089fd2"]={f:Ops.Devices.Mouse.Mouse,objName:"Ops.Devices.Mouse.Mouse"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.BrightnessContrast
// 
// **************************************************************

Ops.Gl.TextureEffects.BrightnessContrast = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={brightness_contrast_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float amountbright;\n\nvoid main()\n{\n    vec4 col=vec4(1.0,0.0,0.0,1.0);\n    col=texture(tex,texCoord);\n\n    // apply contrast\n    col.rgb = ((col.rgb - 0.5) * max(amount*2.0, 0.0))+0.5;\n\n    // apply brightness\n    col.rgb *= amountbright*2.0;\n\n    outColor = col;\n}",};
var render=op.inTrigger("render");
var amount=op.inValueSlider('contrast',0.5);
var amountBright=op.inValueSlider('brightness',0.5);

var trigger=op.outTrigger('trigger');
var cgl=op.patch.cgl;

var shader=new CGL.Shader(cgl,'brightnesscontrast');
shader.setSource(shader.getDefaultVertexShader(),attachments.brightness_contrast_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);
var amountBrightUniform=new CGL.Uniform(shader,'f','amountbright',amountBright);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(!cgl.currentTextureEffect.getCurrentSourceTexture()) return;
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.BrightnessContrast.prototype = new CABLES.Op();
CABLES.OPS["54b89199-c594-4dff-bc48-82d6c7a55e8a"]={f:Ops.Gl.TextureEffects.BrightnessContrast,objName:"Ops.Gl.TextureEffects.BrightnessContrast"};




// **************************************************************
// 
// Ops.Math.TriggerRandomNumber
// 
// **************************************************************

Ops.Math.TriggerRandomNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTriggerButton('Generate'),
    min=op.inValue("min",0),
    max=op.inValue("max",1),
    outTrig = op.outTrigger("next"),
    result=op.outValue("result"),
    inInteger=op.inValueBool("Integer",false);

exe.onTriggered=genRandom;
max.onChange=genRandom;
min.onChange=genRandom;
inInteger.onChange=genRandom;

op.setPortGroup("Value Range",[min,max]);
genRandom();

function genRandom()
{
    var r=(Math.random()*(max.get()-min.get()))+min.get();
    if(inInteger.get())r=Math.floor(r);
    result.set(r);
    outTrig.trigger();
}


};

Ops.Math.TriggerRandomNumber.prototype = new CABLES.Op();
CABLES.OPS["8cb69d73-3e0e-4785-b4cc-499c8372d03c"]={f:Ops.Math.TriggerRandomNumber,objName:"Ops.Math.TriggerRandomNumber"};




// **************************************************************
// 
// Ops.Gl.Perspective
// 
// **************************************************************

Ops.Gl.Perspective = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// http://stackoverflow.com/questions/5504635/computing-fovx-opengl

var render=op.inTrigger('render');
var fovY=op.inValueFloat("fov y",45);
var zNear=op.inValueFloat("frustum near",0.01);
var zFar=op.inValueFloat("frustum far",20);
var autoAspect=op.inValueBool("Auto Aspect Ratio",true);
var aspect=op.inValue("Aspect Ratio");

var trigger=op.outTrigger('trigger');


var cgl=op.patch.cgl;

fovY.onChange=zFar.onChange=zNear.onChange=changed;

changed();

op.setPortGroup("Field of View",fovY);
op.setPortGroup("Frustrum",zNear,zFar);

var asp=0;

render.onTriggered=function()
{
    asp=cgl.getViewPort()[2]/cgl.getViewPort()[3];
    if(!autoAspect.get())asp=aspect.get();

    cgl.pushPMatrix();
    mat4.perspective(
        cgl.pMatrix,
        fovY.get()*0.0174533,
        asp,
        zNear.get(),
        zFar.get());

    trigger.trigger();

    cgl.popPMatrix();
};

function changed()
{
    cgl.frameStore.perspective=
    {
        fovy:fovY.get(),
        zFar:zFar.get(),
        zNear:zNear.get(),
    };
}



};

Ops.Gl.Perspective.prototype = new CABLES.Op();
CABLES.OPS["7a78e163-d28c-4f70-a6d0-6d952da79f50"]={f:Ops.Gl.Perspective,objName:"Ops.Gl.Perspective"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Wobble
// 
// **************************************************************

Ops.Gl.TextureEffects.Wobble = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={wobble_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI sampler2D texMask;\nUNI float time;\nUNI float speedX;\nUNI float speedY;\nUNI float repeatX;\nUNI float repeatY;\nUNI float mul;\n\nconst vec4 lumcoeff = vec4(0.299,0.587,0.114, 0.);\n\nvoid main()\n{\n    vec4 col=vec4(1.0,0.0,0.0,1.0);\n\nfloat mult=mul;\n#ifdef MASK\n    mult*=texture(texMask,texCoord).r;\n#endif\n\n    vec2 tc = texCoord + cos( (time*vec2(speedX, speedY) + vec2(texCoord.s*repeatX,texCoord.t*repeatY)))*mult;\n\n    col=texture(tex,tc);\n\n    outColor= col;\n}",};
const
    render=op.inTrigger("Render"),
    time=op.inValue("time",0),
    speedX=op.inValue("SpeedX",4),
    speedY=op.inValue("SpeedY",8),

    repeatX=op.inValue("RepeatX",11),
    repeatY=op.inValue("RepeatY",11),
    mul=op.inValue("Multiply",0.01),
    maskTex = op.inTexture("Mask"),

    trigger=op.outTrigger("Trigger");



const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.wobble_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const timeUniform=new CGL.Uniform(shader,'f','time',time);
const speedXUniform=new CGL.Uniform(shader,'f','speedX',speedX);
const speedYUniform=new CGL.Uniform(shader,'f','speedY',speedY);
const repeatXUniform=new CGL.Uniform(shader,'f','repeatX',repeatX);
const repeatYUniform=new CGL.Uniform(shader,'f','repeatY',repeatY);
const mulUniform=new CGL.Uniform(shader,'f','mul',mul);
const maskUniform=new CGL.Uniform(shader,'t','texMask',1);

maskTex.onChange = function()
{
    shader.toggleDefine('MASK',maskTex.isLinked());
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    if(maskTex.get()) cgl.setTexture(1, maskTex.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Wobble.prototype = new CABLES.Op();
CABLES.OPS["c349f178-eb83-4753-829e-c9a50b7f459c"]={f:Ops.Gl.TextureEffects.Wobble,objName:"Ops.Gl.TextureEffects.Wobble"};




// **************************************************************
// 
// Ops.Points.PointsCircle
// 
// **************************************************************

Ops.Points.PointsCircle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    outArr=op.outArray("Points"),
    percent=op.inValueSlider('percent',1),
    segments=op.inValue('segments',40),
    radius=op.inValue('radius',1),
    outTotalPoints = op.outNumber("Total points"),
    outArrayLength = op.outNumber("Array lengths");

radius.onChange=
    percent.onChange=
    segments.onChange=calcArray;

function calcArray()
{
    const segs=Math.max(3,Math.floor(segments.get()));
    const points=[];

    let count=0;
    for (let i=0; i < segs*percent.get(); i++)
    {
        var degInRad = (360/segs)*i*CGL.DEG2RAD;
        var posx=Math.cos(degInRad)*radius.get();
        var posy=Math.sin(degInRad)*radius.get();

        points.push(posx);
        points.push(posy);
        points.push(0);
    }

    outArr.set(null);
    outArr.set(points);
    outTotalPoints.set(points.length/3);
    outArrayLength.set(points.length);
}

calcArray();


};

Ops.Points.PointsCircle.prototype = new CABLES.Op();
CABLES.OPS["ef54ba67-8b1d-41b0-8140-bb97061eaa97"]={f:Ops.Points.PointsCircle,objName:"Ops.Points.PointsCircle"};




// **************************************************************
// 
// Ops.Array.ArrayUnpack3
// 
// **************************************************************

Ops.Array.ArrayUnpack3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const inArray1=op.inArray("Array in xyz"),
    outArray1=op.outArray("Array 1 out"),
    outArray2=op.outArray("Array 2 out"),
    outArray3=op.outArray("Array 3 out"),
    outArrayLength = op.outNumber("Array lengths");

var showingError = false;

const arr1=[];
const arr2=[];
const arr3=[];

inArray1.onChange = update;

function update()
{
    var array1=inArray1.get();

    if(!array1)
    {
        outArray1.set(null);
        return;
    }

    if(array1.length % 3 !== 0)
    {
        if(!showingError)
        {
            op.uiAttr({error:"Arrays length not divisible by 3 !"});
            outArrayLength.set(0);
            showingError = true;
        }
        return;
    }

    if(showingError)
    {
        showingError = false;
        op.uiAttr({error:null});
    }

    arr1.length = Math.floor(array1.length/3);
    arr2.length = Math.floor(array1.length/3);
    arr3.length = Math.floor(array1.length/3);

    for(var i=0;i<array1.length/3;i++)
    {
        arr1[i] = array1[i*3];
        arr2[i] = array1[i*3+1];
        arr3[i] = array1[i*3+2];
    }

    outArray1.set(null);
    outArray2.set(null);
    outArray3.set(null);
    outArray1.set(arr1);
    outArray2.set(arr2);
    outArray3.set(arr3);
    outArrayLength.set(arr1.length);
}



};

Ops.Array.ArrayUnpack3.prototype = new CABLES.Op();
CABLES.OPS["fa671f66-6957-41e6-ac35-d615b7c29285"]={f:Ops.Array.ArrayUnpack3,objName:"Ops.Array.ArrayUnpack3"};




// **************************************************************
// 
// Ops.Trigger.TriggerOnce
// 
// **************************************************************

Ops.Trigger.TriggerOnce = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTriggerButton("Exec"),
    reset=op.inTriggerButton("Reset"),
    next=op.outTrigger("Next");
var outTriggered=op.outValue("Was Triggered");

var triggered=false;

op.toWorkPortsNeedToBeLinked(exe,next);

reset.onTriggered=function()
{
    triggered=false;
    outTriggered.set(triggered);
};

exe.onTriggered=function()
{
    if(triggered)return;

    triggered=true;
    next.trigger();
    outTriggered.set(triggered);

};

};

Ops.Trigger.TriggerOnce.prototype = new CABLES.Op();
CABLES.OPS["cf3544e4-e392-432b-89fd-fcfb5c974388"]={f:Ops.Trigger.TriggerOnce,objName:"Ops.Trigger.TriggerOnce"};




// **************************************************************
// 
// Ops.Array.TransformArray3
// 
// **************************************************************

Ops.Array.TransformArray3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inExec=op.inTriggerButton("Transform"),
    inArr=op.inArray("Array"),
    transX=op.inValue("Translate X"),
    transY=op.inValue("Translate Y"),
    transZ=op.inValue("Translate Z"),
    scaleX=op.inValueSlider("Scale X",1),
    scaleY=op.inValueSlider("Scale Y",1),
    scaleZ=op.inValueSlider("Scale Z",1),
    rotX=op.inValue("Rotation X"),
    rotY=op.inValue("Rotation Y"),
    rotZ=op.inValue("Rotation Z"),
    next=op.outTrigger("Next"),
    outArr=op.outArray("Result");

var resultArr=[];
var needsCalc = true;

var rotVec=vec3.create();
var emptyVec=vec3.create();
var transVec=vec3.create();
var centerVec=vec3.create();

inExec.onTriggered=doTransform;

inArr.onChange=
transX.onChange=transY.onChange=transZ.onChange=
scaleX.onChange=scaleY.onChange=scaleZ.onChange=
rotX.onChange=rotY.onChange=rotZ.onChange=calcLater;

function calcLater()
{
    needsCalc=true;
}

function doTransform()
{
    var arr=inArr.get();
    if(!arr)
    {
        outArr.set(null);
        return;
    }
    if(needsCalc)
    {
        resultArr.length=arr.length;

        for(var i=0;i<arr.length;i+=3)
        {
            resultArr[i+0]=arr[i+0]*scaleX.get();
            resultArr[i+1]=arr[i+1]*scaleY.get();
            resultArr[i+2]=arr[i+2]*scaleZ.get();

            resultArr[i+0]=resultArr[i+0]+transX.get();
            resultArr[i+1]=resultArr[i+1]+transY.get();
            resultArr[i+2]=resultArr[i+2]+transZ.get();
        }

        for(var i=0;i<arr.length;i+=3)
        {
            vec3.set(rotVec,
                resultArr[i+0],
                resultArr[i+1],
                resultArr[i+2]);

            vec3.rotateX(rotVec,rotVec,transVec,rotX.get()*CGL.DEG2RAD);
            vec3.rotateY(rotVec,rotVec,transVec,rotY.get()*CGL.DEG2RAD);
            vec3.rotateZ(rotVec,rotVec,transVec,rotZ.get()*CGL.DEG2RAD);

            resultArr[i+0]=rotVec[0];
            resultArr[i+1]=rotVec[1];
            resultArr[i+2]=rotVec[2];
        }

        needsCalc=false;
        outArr.set(null);
        outArr.set(resultArr);
        next.trigger();
    }
}

};

Ops.Array.TransformArray3.prototype = new CABLES.Op();
CABLES.OPS["b18040d6-13d7-4f55-950f-3f95cafa4e90"]={f:Ops.Array.TransformArray3,objName:"Ops.Array.TransformArray3"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Stripes_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.Stripes_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={stripes_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float num;\nUNI float width;\nUNI float axis;\nUNI float offset;\nUNI float rotate;\n\nUNI float r;\nUNI float g;\nUNI float b;\n\n\n{{CGL.BLENDMODES}}\n\n#define PI 3.14159265\n#define TAU (2.0*PI)\n\nvoid pR(inout vec2 p, float a)\n{\n\tp = cos(a)*p + sin(a)*vec2(p.y, -p.x);\n}\nvoid main()\n{\n    vec2 uv = texCoord-0.5;\n    pR(uv.xy,rotate*TAU);\n    vec4 stripe=vec4(0.0);\n\n    float v=0.0;\n    float c=1.0;\n    v=uv.y;\n    v+=offset;\n\n    float m=mod(v,1.0/num);\n\n    #ifdef CIRCULAR\n        m=mod((length(uv)+offset)*1.5,1.0/num);\n    #endif\n\n    float rm=width*2.0*1.0/num/2.0;\n\n    if(m>rm)\n       stripe.rgb=mix(stripe.rgb,vec3( r,g,b ),1.0);\n\n    #ifdef STRIPES_SMOOTHED\n       m*=2.0;\n       stripe.rgb= vec3(r,g,b) * vec3(smoothstep(0.,1., abs(( ((m-rm) )/ (rm) )  ) ));\n       //stripe.rgb= vec3(smoothstep(0.,1., abs(( ((m-rm) )/ (rm) )  ) ));\n    #endif\n\n    //blend section\n    vec4 col=vec4(stripe.rgb,1.0);\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,col,amount);\n}\n",};
const
    render=op.inTrigger('Render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    num=op.inValue("Num",5),
    width=op.inValue("Width",0.5),
    rotate=op.inValueSlider("Rotate",0),
    offset=op.inValue("Offset",0),
    smoothed=op.inValueBool("Gradients"),
    circular=op.inValueBool("Circular"),
    r=op.inValueSlider("r", Math.random()),
    g=op.inValueSlider("g", Math.random()),
    b=op.inValueSlider("b", Math.random()),
    trigger=op.outTrigger('trigger');

r.setUiAttribs({ colorPick: true });

smoothed.onChange=updateDefines;
circular.onChange=updateDefines;

function updateDefines()
{

    shader.toggleDefine("STRIPES_SMOOTHED",smoothed.get());
    shader.toggleDefine("CIRCULAR",circular.get());
}


const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl,'textureeffect stripes');

shader.setSource(shader.getDefaultVertexShader(),attachments.stripes_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    rotateUniform=new CGL.Uniform(shader,'f','rotate',rotate),
    numUniform=new CGL.Uniform(shader,'f','num',num),
    uniWidth=new CGL.Uniform(shader,'f','width',width),
    uniOffset=new CGL.Uniform(shader,'f','offset',offset),
    uniformR=new CGL.Uniform(shader,'f','r',r),
    uniformG=new CGL.Uniform(shader,'f','g',g),
    uniformB=new CGL.Uniform(shader,'f','b',b);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Stripes_v2.prototype = new CABLES.Op();
CABLES.OPS["b8a37747-1e84-4665-b1cc-29256d55cc7c"]={f:Ops.Gl.TextureEffects.Stripes_v2,objName:"Ops.Gl.TextureEffects.Stripes_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.WorleyNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.WorleyNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={worleynoise_frag:"// Author: Stefan Gustavson\n// Title: Worley noise 2x2x2\n\nIN vec2 texCoord;\n\nUNI float amount;\nUNI float x;\nUNI float y;\nUNI float z;\nUNI float scale;\nUNI sampler2D tex;\nUNI float rangeA;\nUNI float rangeB;\n\n{{CGL.BLENDMODES}}\n\n// Cellular noise (\"Worley noise\") in 3D in GLSL.\n// Copyright (c) Stefan Gustavson 2011-04-19. All rights reserved.\n// This code is released under the conditions of the MIT license.\n// See LICENSE file for details.\n\n// Permutation polynomial: (34x^2 + x) mod 289\nvec4 permute(vec4 x) {\n  return mod((34.0 * x + 1.0) * x, 289.0);\n}\nvec3 permute(vec3 x) {\n  return mod((34.0 * x + 1.0) * x, 289.0);\n}\n\n// Cellular noise, returning F1 and F2 in a vec2.\n// Speeded up by using 2x2x2 search window instead of 3x3x3,\n// at the expense of some pattern artifacts.\n// F2 is often wrong and has sharp discontinuities.\n// If you need a good F2, use the slower 3x3x3 version.\nvec2 cellular2x2x2(vec3 P) {\n\t#define K 0.142857142857 // 1/7\n\t#define Ko 0.428571428571 // 1/2-K/2\n\t#define K2 0.020408163265306 // 1/(7*7)\n\t#define Kz 0.166666666667 // 1/6\n\t#define Kzo 0.416666666667 // 1/2-1/6*2\n\t#define jitter 0.8 // smaller jitter gives less errors in F2\n\tvec3 Pi = mod(floor(P), 289.0);\n \tvec3 Pf = fract(P);\n\tvec4 Pfx = Pf.x + vec4(0.0, -1.0, 0.0, -1.0);\n\tvec4 Pfy = Pf.y + vec4(0.0, 0.0, -1.0, -1.0);\n\tvec4 p = permute(Pi.x + vec4(0.0, 1.0, 0.0, 1.0));\n\tp = permute(p + Pi.y + vec4(0.0, 0.0, 1.0, 1.0));\n\tvec4 p1 = permute(p + Pi.z); // z+0\n\tvec4 p2 = permute(p + Pi.z + vec4(1.0)); // z+1\n\tvec4 ox1 = fract(p1*K) - Ko;\n\tvec4 oy1 = mod(floor(p1*K), 7.0)*K - Ko;\n\tvec4 oz1 = floor(p1*K2)*Kz - Kzo; // p1 < 289 guaranteed\n\tvec4 ox2 = fract(p2*K) - Ko;\n\tvec4 oy2 = mod(floor(p2*K), 7.0)*K - Ko;\n\tvec4 oz2 = floor(p2*K2)*Kz - Kzo;\n\tvec4 dx1 = Pfx + jitter*ox1;\n\tvec4 dy1 = Pfy + jitter*oy1;\n\tvec4 dz1 = Pf.z + jitter*oz1;\n\tvec4 dx2 = Pfx + jitter*ox2;\n\tvec4 dy2 = Pfy + jitter*oy2;\n\tvec4 dz2 = Pf.z - 1.0 + jitter*oz2;\n\tvec4 d1 = dx1 * dx1 + dy1 * dy1 + dz1 * dz1; // z+0\n\tvec4 d2 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2; // z+1\n\n\t// Sort out the two smallest distances (F1, F2)\n#if 0\n\t// Cheat and sort out only F1\n\td1 = min(d1, d2);\n\td1.xy = min(d1.xy, d1.wz);\n\td1.x = min(d1.x, d1.y);\n\treturn sqrt(d1.xx);\n#else\n\t// Do it right and sort out both F1 and F2\n\tvec4 d = min(d1,d2); // F1 is now in d\n\td2 = max(d1,d2); // Make sure we keep all candidates for F2\n\td.xy = (d.x < d.y) ? d.xy : d.yx; // Swap smallest to d.x\n\td.xz = (d.x < d.z) ? d.xz : d.zx;\n\td.xw = (d.x < d.w) ? d.xw : d.wx; // F1 is now in d.x\n\td.yzw = min(d.yzw, d2.yzw); // F2 now not in d2.yzw\n\td.y = min(d.y, d.z); // nor in d.z\n\td.y = min(d.y, d.w); // nor in d.w\n\td.y = min(d.y, d2.x); // F2 is now in d.y\n\treturn sqrt(d.xy); // F1 and F2\n#endif\n}\n\nvoid main(void) {\n\tvec2 st = texCoord;//gl_FragCoord.xy/u_resolution.xy;\n\n\t#ifdef DO_TILEABLE\n\t    st=abs(texCoord-0.5);\n\t#endif\n\n    st.x-=0.5;\n    st.y-=0.5;\n\tst *= scale;\n    st.x+=0.5;\n    st.y+=0.5;\n\n\tst.x+=x;\n\tst.y+=y;\n\n\n\tvec2 F = cellular2x2x2(vec3(st,z));\n\tfloat n = smoothstep(rangeA,rangeB, F.x);\n\n    #ifdef DO_INVERT\n        n=1.0-n;\n    #endif\n\n    vec4 col=vec4(n,n,n,1.0);\n\n    vec4 base=texture(tex,texCoord);\n\n\n    outColor=cgl_blend(base,col,amount);\n\n}\n",};
var render=op.inTrigger('render');

var blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
var amount=op.inValueSlider("Amount",1);

var x=op.inValue("X",0);
var y=op.inValue("Y",0);
var z=op.inValue("Z",0);
var scale=op.inValue("Scale",22);
var inv=op.inValueBool("Invert",true);

var rangeA=op.inValueSlider("RangeA",0.4);
var rangeB=op.inValueSlider("RangeB",0.5);

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);


shader.setSource(shader.getDefaultVertexShader(),attachments.worleynoise_frag );
const textureUniform=new CGL.Uniform(shader,'t','tex',0);

const uniZ=new CGL.Uniform(shader,'f','z',z);
const uniX=new CGL.Uniform(shader,'f','x',x);
const uniY=new CGL.Uniform(shader,'f','y',y);
const uniScale=new CGL.Uniform(shader,'f','scale',scale);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);
const rangeAUniform=new CGL.Uniform(shader,'f','rangeA',rangeA);
const rangeBUniform=new CGL.Uniform(shader,'f','rangeB',rangeB);

inv.onChange=updateInvert;
updateInvert();

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);


function updateInvert()
{
    if(inv.get())shader.define("DO_INVERT");
        else shader.removeDefine("DO_INVERT");
}

var tile=op.inValueBool("Tileable",false);
tile.onChange=updateTileable;
function updateTileable()
{
    if(tile.get())shader.define("DO_TILEABLE");
        else shader.removeDefine("DO_TILEABLE");
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.WorleyNoise.prototype = new CABLES.Op();
CABLES.OPS["cc0e941c-6f03-4c40-8cc2-8cecaac2e059"]={f:Ops.Gl.TextureEffects.Noise.WorleyNoise,objName:"Ops.Gl.TextureEffects.Noise.WorleyNoise"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.PerlinNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.PerlinNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={perlinnoise3d_frag:"UNI float z;\nUNI float x;\nUNI float y;\nUNI float scale;\nIN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float amount;\n\n{{CGL.BLENDMODES}}\n\n\nfloat Interpolation_C2( float x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }   //  6x^5-15x^4+10x^3\t( Quintic Curve.  As used by Perlin in Improved Noise.  http://mrl.nyu.edu/~perlin/paper445.pdf )\nvec2 Interpolation_C2( vec2 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec3 Interpolation_C2( vec3 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2( vec4 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2_InterpAndDeriv( vec2 x ) { return x.xyxy * x.xyxy * ( x.xyxy * ( x.xyxy * ( x.xyxy * vec2( 6.0, 0.0 ).xxyy + vec2( -15.0, 30.0 ).xxyy ) + vec2( 10.0, -60.0 ).xxyy ) + vec2( 0.0, 30.0 ).xxyy ); }\nvec3 Interpolation_C2_Deriv( vec3 x ) { return x * x * (x * (x * 30.0 - 60.0) + 30.0); }\n\n\nvoid FAST32_hash_3D( \tvec3 gridcell,\n                        out vec4 lowz_hash_0,\n                        out vec4 lowz_hash_1,\n                        out vec4 lowz_hash_2,\n                        out vec4 highz_hash_0,\n                        out vec4 highz_hash_1,\n                        out vec4 highz_hash_2\t)\t\t//\tgenerates 3 random numbers for each of the 8 cell corners\n{\n    //    gridcell is assumed to be an integer coordinate\n\n    //\tTODO: \tthese constants need tweaked to find the best possible noise.\n    //\t\t\tprobably requires some kind of brute force computational searching or something....\n    const vec2 OFFSET = vec2( 50.0, 161.0 );\n    const float DOMAIN = 69.0;\n    const vec3 SOMELARGEFLOATS = vec3( 635.298681, 682.357502, 668.926525 );\n    const vec3 ZINC = vec3( 48.500388, 65.294118, 63.934599 );\n\n    //\ttruncate the domain\n    gridcell.xyz = gridcell.xyz - floor(gridcell.xyz * ( 1.0 / DOMAIN )) * DOMAIN;\n    vec3 gridcell_inc1 = step( gridcell, vec3( DOMAIN - 1.5 ) ) * ( gridcell + 1.0 );\n\n    //\tcalculate the noise\n    vec4 P = vec4( gridcell.xy, gridcell_inc1.xy ) + OFFSET.xyxy;\n    P *= P;\n    P = P.xzxz * P.yyww;\n    vec3 lowz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell.zzz * ZINC.xyz ) );\n    vec3 highz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell_inc1.zzz * ZINC.xyz ) );\n    lowz_hash_0 = fract( P * lowz_mod.xxxx );\n    highz_hash_0 = fract( P * highz_mod.xxxx );\n    lowz_hash_1 = fract( P * lowz_mod.yyyy );\n    highz_hash_1 = fract( P * highz_mod.yyyy );\n    lowz_hash_2 = fract( P * lowz_mod.zzzz );\n    highz_hash_2 = fract( P * highz_mod.zzzz );\n}\n\n//\n//\tPerlin Noise 3D  ( gradient noise )\n//\tReturn value range of -1.0->1.0\n//\thttp://briansharpe.files.wordpress.com/2011/11/perlinsample.jpg\n//\nfloat Perlin3D( vec3 P )\n{\n    //\testablish our grid cell and unit position\n    vec3 Pi = floor(P);\n    vec3 Pf = P - Pi;\n    vec3 Pf_min1 = Pf - 1.0;\n\n#if 1\n    //\n    //\tclassic noise.\n    //\trequires 3 random values per point.  with an efficent hash function will run faster than improved noise\n    //\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hashx0, hashy0, hashz0, hashx1, hashy1, hashz1;\n    FAST32_hash_3D( Pi, hashx0, hashy0, hashz0, hashx1, hashy1, hashz1 );\n    //SGPP_hash_3D( Pi, hashx0, hashy0, hashz0, hashx1, hashy1, hashz1 );\n\n    //\tcalculate the gradients\n    vec4 grad_x0 = hashx0 - 0.49999;\n    vec4 grad_y0 = hashy0 - 0.49999;\n    vec4 grad_z0 = hashz0 - 0.49999;\n    vec4 grad_x1 = hashx1 - 0.49999;\n    vec4 grad_y1 = hashy1 - 0.49999;\n    vec4 grad_z1 = hashz1 - 0.49999;\n    vec4 grad_results_0 = inversesqrt( grad_x0 * grad_x0 + grad_y0 * grad_y0 + grad_z0 * grad_z0 ) * ( vec2( Pf.x, Pf_min1.x ).xyxy * grad_x0 + vec2( Pf.y, Pf_min1.y ).xxyy * grad_y0 + Pf.zzzz * grad_z0 );\n    vec4 grad_results_1 = inversesqrt( grad_x1 * grad_x1 + grad_y1 * grad_y1 + grad_z1 * grad_z1 ) * ( vec2( Pf.x, Pf_min1.x ).xyxy * grad_x1 + vec2( Pf.y, Pf_min1.y ).xxyy * grad_y1 + Pf_min1.zzzz * grad_z1 );\n\n#if 1\n    //\tClassic Perlin Interpolation\n    vec3 blend = Interpolation_C2( Pf );\n    vec4 res0 = mix( grad_results_0, grad_results_1, blend.z );\n    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );\n    float final = dot( res0, blend2.zxzx * blend2.wwyy );\n    final *= 1.1547005383792515290182975610039;\t\t//\t(optionally) scale things to a strict -1.0->1.0 range    *= 1.0/sqrt(0.75)\n    return final;\n#else\n    //\tClassic Perlin Surflet\n    //\thttp://briansharpe.wordpress.com/2012/03/09/modifications-to-classic-perlin-noise/\n    Pf *= Pf;\n    Pf_min1 *= Pf_min1;\n    vec4 vecs_len_sq = vec4( Pf.x, Pf_min1.x, Pf.x, Pf_min1.x ) + vec4( Pf.yy, Pf_min1.yy );\n    float final = dot( Falloff_Xsq_C2( min( vec4( 1.0 ), vecs_len_sq + Pf.zzzz ) ), grad_results_0 ) + dot( Falloff_Xsq_C2( min( vec4( 1.0 ), vecs_len_sq + Pf_min1.zzzz ) ), grad_results_1 );\n    final *= 2.3703703703703703703703703703704;\t\t//\t(optionally) scale things to a strict -1.0->1.0 range    *= 1.0/cube(0.75)\n    return final;\n#endif\n\n#else\n    //\n    //\timproved noise.\n    //\trequires 1 random value per point.  Will run faster than classic noise if a slow hashing function is used\n    //\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hash_lowz, hash_highz;\n    FAST32_hash_3D( Pi, hash_lowz, hash_highz );\n    //BBS_hash_3D( Pi, hash_lowz, hash_highz );\n    //SGPP_hash_3D( Pi, hash_lowz, hash_highz );\n\n    //\n    //\t\"improved\" noise using 8 corner gradients.  Faster than the 12 mid-edge point method.\n    //\tKen mentions using diagonals like this can cause \"clumping\", but we'll live with that.\n    //\t[1,1,1]  [-1,1,1]  [1,-1,1]  [-1,-1,1]\n    //\t[1,1,-1] [-1,1,-1] [1,-1,-1] [-1,-1,-1]\n    //\n    hash_lowz -= 0.5;\n    vec4 grad_results_0_0 = vec2( Pf.x, Pf_min1.x ).xyxy * sign( hash_lowz );\n    hash_lowz = abs( hash_lowz ) - 0.25;\n    vec4 grad_results_0_1 = vec2( Pf.y, Pf_min1.y ).xxyy * sign( hash_lowz );\n    vec4 grad_results_0_2 = Pf.zzzz * sign( abs( hash_lowz ) - 0.125 );\n    vec4 grad_results_0 = grad_results_0_0 + grad_results_0_1 + grad_results_0_2;\n\n    hash_highz -= 0.5;\n    vec4 grad_results_1_0 = vec2( Pf.x, Pf_min1.x ).xyxy * sign( hash_highz );\n    hash_highz = abs( hash_highz ) - 0.25;\n    vec4 grad_results_1_1 = vec2( Pf.y, Pf_min1.y ).xxyy * sign( hash_highz );\n    vec4 grad_results_1_2 = Pf_min1.zzzz * sign( abs( hash_highz ) - 0.125 );\n    vec4 grad_results_1 = grad_results_1_0 + grad_results_1_1 + grad_results_1_2;\n\n    //\tblend the gradients and return\n    vec3 blend = Interpolation_C2( Pf );\n    vec4 res0 = mix( grad_results_0, grad_results_1, blend.z );\n    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );\n    return dot( res0, blend2.zxzx * blend2.wwyy ) * (2.0 / 3.0);\t//\t(optionally) mult by (2.0/3.0) to scale to a strict -1.0->1.0 range\n#endif\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec2 p=vec2(texCoord.x-0.5,texCoord.y-0.5);\n\n    p=p*scale;\n    p=vec2(p.x+0.5-x,p.y+0.5-y);\n\n    float aa=texture(tex,texCoord).r;\n    float v=Perlin3D(vec3(p.x,p.y,z))*0.5+0.5;\n\n\n    vec4 col=vec4(v,v,v,1.0);\n\n    outColor=cgl_blend(base,col,amount);\n}\n",};
const
    render=op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    scale=op.inValue("Scale",22),
    x=op.inValue("X",0),
    y=op.inValue("Y",0),
    z=op.inValue("Z",0),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'perlinnoise');

op.setPortGroup("Position",[x,y,z]);

shader.setSource(shader.getDefaultVertexShader(),attachments.perlinnoise3d_frag );

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    uniZ=new CGL.Uniform(shader,'f','z',z),
    uniX=new CGL.Uniform(shader,'f','x',x),
    uniY=new CGL.Uniform(shader,'f','y',y),
    uniScale=new CGL.Uniform(shader,'f','scale',scale),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.PerlinNoise.prototype = new CABLES.Op();
CABLES.OPS["446442ba-1a7e-4c71-bb43-b12005aa6511"]={f:Ops.Gl.TextureEffects.Noise.PerlinNoise,objName:"Ops.Gl.TextureEffects.Noise.PerlinNoise"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.EdgeDetection_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.EdgeDetection_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={edgedetect_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float strength;\nUNI float texWidth;\nUNI float texHeight;\nUNI float mulColor;\n\nconst vec4 lumcoeff = vec4(0.299,0.587,0.114, 0.);\n\nvec3 desaturate(vec3 color)\n{\n    return vec3(dot(vec3(0.2126,0.7152,0.0722), color));\n}\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    // vec4 col=vec4(1.0,0.0,0.0,1.0);\n\n    float pixelX=strength/texWidth;\n    float pixelY=strength/texHeight;\n\n    // col=texture(tex,texCoord);\n\n    float count=1.0;\n\n\tvec4 horizEdge = vec4( 0.0 );\n\thorizEdge -= texture( tex, vec2( texCoord.x - pixelX, texCoord.y - pixelY ) ) * 1.0;\n\thorizEdge -= texture( tex, vec2( texCoord.x - pixelX, texCoord.y     ) ) * 2.0;\n\thorizEdge -= texture( tex, vec2( texCoord.x - pixelX, texCoord.y + pixelY ) ) * 1.0;\n\thorizEdge += texture( tex, vec2( texCoord.x + pixelX, texCoord.y - pixelY ) ) * 1.0;\n\thorizEdge += texture( tex, vec2( texCoord.x + pixelX, texCoord.y     ) ) * 2.0;\n\thorizEdge += texture( tex, vec2( texCoord.x + pixelX, texCoord.y + pixelY ) ) * 1.0;\n\tvec4 vertEdge = vec4( 0.0 );\n\tvertEdge -= texture( tex, vec2( texCoord.x - pixelX, texCoord.y - pixelY ) ) * 1.0;\n\tvertEdge -= texture( tex, vec2( texCoord.x    , texCoord.y - pixelY ) ) * 2.0;\n\tvertEdge -= texture( tex, vec2( texCoord.x + pixelX, texCoord.y - pixelY ) ) * 1.0;\n\tvertEdge += texture( tex, vec2( texCoord.x - pixelX, texCoord.y + pixelY ) ) * 1.0;\n\tvertEdge += texture( tex, vec2( texCoord.x    , texCoord.y + pixelY ) ) * 2.0;\n\tvertEdge += texture( tex, vec2( texCoord.x + pixelX, texCoord.y + pixelY ) ) * 1.0;\n\n\n\tvec3 edge = sqrt((horizEdge.rgb/count * horizEdge.rgb/count) + (vertEdge.rgb/count * vertEdge.rgb/count));\n\n    edge=desaturate(edge);\n\n    if(mulColor>0.0) edge*=texture( tex, texCoord ).rgb*mulColor*4.0;\n    edge=max(min(edge,1.0),0.0);\n\n    //blend section\n    vec4 col=vec4(edge,1.0);\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,col,amount);\n}\n\n",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    strength=op.inValueSlider("strength",1),
    mulColor=op.inValueSlider("Mul Color",0),
    trigger=op.outTrigger("Trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);


shader.setSource(shader.getDefaultVertexShader(),attachments.edgedetect_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    strengthUniform=new CGL.Uniform(shader,'f','strength',strength),
    uniWidth=new CGL.Uniform(shader,'f','texWidth',128),
    uniHeight=new CGL.Uniform(shader,'f','texHeight',128),
    uniMulColor=new CGL.Uniform(shader,'f','mulColor',mulColor);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.EdgeDetection_v2.prototype = new CABLES.Op();
CABLES.OPS["ca2e8b01-77b8-4838-ba03-d93437e7bfc0"]={f:Ops.Gl.TextureEffects.EdgeDetection_v2,objName:"Ops.Gl.TextureEffects.EdgeDetection_v2"};




// **************************************************************
// 
// Ops.Gl.Matrix.TransformView
// 
// **************************************************************

Ops.Gl.Matrix.TransformView = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger('render'),
    posX=op.inValueFloat("posX"),
    posY=op.inValueFloat("posY"),
    posZ=op.inValueFloat("posZ"),
    scale=op.inValueFloat("scale"),
    rotX=op.inValueFloat("rotX"),
    rotY=op.inValueFloat("rotY"),
    rotZ=op.inValueFloat("rotZ"),
    trigger=op.outTrigger('trigger');

op.setPortGroup("Position",[posX,posY,posZ]);
op.setPortGroup("Scale",[scale]);
op.setPortGroup("Rotation",[rotX,rotZ,rotY]);

var cgl=op.patch.cgl;
var vPos=vec3.create();
var vScale=vec3.create();
var transMatrix = mat4.create();
mat4.identity(transMatrix);

var doScale=false;
var doTranslate=false;

var translationChanged=true;
var scaleChanged=true;
var rotChanged=true;

render.onTriggered=function()
{
    var updateMatrix=false;
    if(translationChanged)
    {
        updateTranslation();
        updateMatrix=true;
    }
    if(scaleChanged)
    {
        updateScale();
        updateMatrix=true;
    }
    if(rotChanged)
    {
        updateMatrix=true;
    }
    if(updateMatrix)doUpdateMatrix();

    cgl.pushViewMatrix();
    mat4.multiply(cgl.vMatrix,cgl.vMatrix,transMatrix);

    trigger.trigger();
    cgl.popViewMatrix();

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:posX,
                posY:posY,
                posZ:posZ,
            });
};

op.transform3d=function()
{
    return {
            pos:[posX,posY,posZ]
        };

};

var doUpdateMatrix=function()
{
    mat4.identity(transMatrix);
    if(doTranslate)mat4.translate(transMatrix,transMatrix, vPos);

    if(rotX.get()!==0)mat4.rotateX(transMatrix,transMatrix, rotX.get()*CGL.DEG2RAD);
    if(rotY.get()!==0)mat4.rotateY(transMatrix,transMatrix, rotY.get()*CGL.DEG2RAD);
    if(rotZ.get()!==0)mat4.rotateZ(transMatrix,transMatrix, rotZ.get()*CGL.DEG2RAD);

    if(doScale)mat4.scale(transMatrix,transMatrix, vScale);
    rotChanged=false;
};

function updateTranslation()
{
    doTranslate=false;
    if(posX.get()!==0.0 || posY.get()!==0.0 || posZ.get()!==0.0) doTranslate=true;
    vec3.set(vPos, posX.get(),posY.get(),posZ.get());
    translationChanged=false;
}

function updateScale()
{
    doScale=false;
    if(scale.get()!==0.0)doScale=true;
    vec3.set(vScale, scale.get(),scale.get(),scale.get());
    scaleChanged=false;
}

var translateChanged=function()
{
    translationChanged=true;
};

var scaleChanged=function()
{
    scaleChanged=true;
};

var rotChanged=function()
{
    rotChanged=true;
};


rotX.onChange=rotChanged;
rotY.onChange=rotChanged;
rotZ.onChange=rotChanged;

scale.onChange=scaleChanged;

posX.onChange=translateChanged;
posY.onChange=translateChanged;
posZ.onChange=translateChanged;

rotX.set(0.0);
rotY.set(0.0);
rotZ.set(0.0);

scale.set(1.0);

posX.set(0.0);
posY.set(0.0);
posZ.set(0.0);

doUpdateMatrix();



};

Ops.Gl.Matrix.TransformView.prototype = new CABLES.Op();
CABLES.OPS["0b3e04f7-323e-4ac8-8a22-a21e2f36e0e9"]={f:Ops.Gl.Matrix.TransformView,objName:"Ops.Gl.Matrix.TransformView"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.RotateTexture
// 
// **************************************************************

Ops.Gl.TextureEffects.RotateTexture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={rotate_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI sampler2D multiplierTex;\nUNI float amount;\nUNI float resX;\nUNI float resY;\nUNI float rotate;\n\n{{CGL.BLENDMODES}}\n\n#define PI 3.14159265\n#define TAU (2.0*PI)\n\nvoid pR(inout vec2 p, float a)\n{\n\tp = cos(a)*p + sin(a)*vec2(p.y, -p.x);\n}\n\nvoid main()\n{\n    float multiplier = 0.0;\n\n    #ifdef ROTATE_TEXTURE\n        multiplier = dot(vec3(0.2126,0.7152,0.0722), texture(multiplierTex,texCoord).rgb);\n    #endif\n\n    vec2 uv = texCoord;\n    vec2 res = vec2(resX,resY);\n    uv -= 0.5;\n    pR(uv.xy,(rotate + multiplier) * (TAU)  );\n    uv += 0.5;\n\n    #ifdef CROP_IMAGE\n    if(uv.x>1.0 ||uv.x<0.0  || uv.y>1.0 ||uv.y<0.0 )\n    {\n        discard;\n        return;\n    }\n    #endif\n\n    //blend section\n    vec4 col=texture(tex,uv);\n    //original texture\n    vec4 base=texture(tex,texCoord);\n    // outColor= col;\n    outColor=cgl_blend(base,col,amount);\n}",};
const render=op.inTrigger('render'),
    multiplierTex = op.inTexture("Multiplier"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    inRotate=op.inValueSlider("Rotate",0.125),
    crop=op.inValueBool("Crop",true),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.rotate_frag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const textureMultiplierUniform=new CGL.Uniform(shader,'t','multiplierTex',1);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);
const rotateUniform=new CGL.Uniform(shader,'f','rotate',inRotate);

crop.onChange=updateCrop;
updateCrop();


CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

function updateCrop()
{
    shader.toggleDefine('CROP_IMAGE',crop.get());
}
multiplierTex.onChange = function()
{
    shader.toggleDefine('ROTATE_TEXTURE',multiplierTex.isLinked());
}
render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    if(multiplierTex.get()) cgl.setTexture(1, multiplierTex.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.RotateTexture.prototype = new CABLES.Op();
CABLES.OPS["207bf2af-a3fc-458d-9efb-eb108a854072"]={f:Ops.Gl.TextureEffects.RotateTexture,objName:"Ops.Gl.TextureEffects.RotateTexture"};




// **************************************************************
// 
// Ops.User.pandur.triangulate
// 
// **************************************************************

Ops.User.pandur.triangulate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
//empty file...

};

Ops.User.pandur.triangulate.prototype = new CABLES.Op();





// **************************************************************
// 
// Ops.Gl.RenderGeometry
// 
// **************************************************************

Ops.Gl.RenderGeometry = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger('render'),
    geometry=op.inObject("Geometry"),
    updateAll=op.inValueBool('Update All',true),
    updateFaces=op.inValueBool('Update Face Indices',false),
    updateVerts=op.inValueBool('Update Vertices',false),
    updateTexcoords=op.inValueBool('Update Texcoords',false),
    vertNums=op.inValueBool('Vertex Numbers',true),
    trigger=op.outTrigger('trigger');

geometry.ignoreValueSerialize=true;

vertNums.onChange=
    geometry.onChange=update;

var mesh=null;

render.onTriggered=function()
{
    if(mesh) mesh.render(op.patch.cgl.getShader());
    trigger.trigger();
};


function update()
{
    var geom=geometry.get();
    if(geom)
    {
        if(mesh)mesh.dispose();
        if(!mesh)
        {
            mesh=new CGL.Mesh(op.patch.cgl,geom);
            mesh.addVertexNumbers=vertNums.get();
            mesh.setGeom(geom);
        }

        if(updateFaces.get() || updateAll.get())
            mesh.setVertexIndices(geom.verticesIndices);

        if(updateTexcoords.get() || updateAll.get())
            mesh.updateTexCoords(geom);

        if(updateVerts.get() || updateAll.get())
            mesh.updateVertices(geom);

        mesh.addVertexNumbers=vertNums.get();

        if(updateAll.get())
        {
            if(geom.hasOwnProperty('tangents') && geom.tangents && geom.tangents.length>0) mesh.setAttribute('attrTangent',geom.tangents,3);
            if(geom.hasOwnProperty('biTangents') && geom.biTangents && geom.biTangents.length>0) mesh.setAttribute('attrBiTangent',geom.biTangents,3);
        }
    }
    else
    {
        mesh=null;
    }
}



};

Ops.Gl.RenderGeometry.prototype = new CABLES.Op();
CABLES.OPS["40fa6f13-ee0e-4386-a86b-711e1fbcf1bc"]={f:Ops.Gl.RenderGeometry,objName:"Ops.Gl.RenderGeometry"};




// **************************************************************
// 
// Ops.Array.ArrayPack2
// 
// **************************************************************

Ops.Array.ArrayPack2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe = op.inTrigger("Trigger in"),
    inArr1=op.inArray("Array 1"),
    inArr2=op.inArray("Array 2"),
    exeOut = op.outTrigger("Trigger out"),
    outArr=op.outArray("Array out"),
    outArrayLength = op.outNumber("Array length");

var showingError = false;

var arr=[];
var emptyArray=[];
var needsCalc = true;

exe.onTriggered = update;

inArr1.onChange=inArr2.onChange=calcLater;
function calcLater()
{
    needsCalc=true;
}

function update()
{
    var array1=inArr1.get();
    var array2=inArr2.get();

    if(!array1 && !array2 )
    {
        outArr.set(null);
        return;
    }
    if(needsCalc)
    {
        var arrlen=0;

        if(!array1 || !array2)
        {
            if(array1) arrlen=array1.length;
                else if(array2) arrlen=array2.length;

            if(emptyArray.length!=arrlen)
                for(var i=0;i<arrlen;i++) emptyArray[i]=0;

            if(!array1)array1=emptyArray;
            if(!array2)array2=emptyArray;
        }

        if(array1.length !== array2.length)
        {
            if(!showingError)
            {
                op.uiAttr({error:"Arrays do not have the same length !"});
                showingError = true;
            }
            return;
        }

        if(showingError)
        {
            showingError = false;
            op.uiAttr({error:null});
        }

        arr.length = array1.length;
        for(var i=0;i<array1.length;i++)
        {
            arr[i*2+0] = array1[i];
            arr[i*2+1] = array2[i];
        }

        needsCalc = false;
        outArr.set(null);
        outArr.set(arr);
        outArrayLength.set(arr.length);
    }

    exeOut.trigger();
}



};

Ops.Array.ArrayPack2.prototype = new CABLES.Op();
CABLES.OPS["0db296db-e4a7-4356-9593-858f7e1bc7f3"]={f:Ops.Array.ArrayPack2,objName:"Ops.Array.ArrayPack2"};




// **************************************************************
// 
// Ops.Admin.Tess2
// 
// **************************************************************

Ops.Admin.Tess2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const
    inExec=op.inTriggerButton("Update"),
    inWinding=op.inDropDown("Combine",['Positive','Odd','Intersect'],"Positive"),
    inPath=op.inArray("2d Point Path"),
    inPath2=op.inArray("Path 2"),
    inPath3=op.inArray("Path 3"),
    outGeom=op.outObject("Geometry");

inExec.onTriggered=tess;

function tess()
{
    // var Tess2 = require('tess2');

    // Define input
    // var ca = [0,0, 10,0, 5,10];
    // var cb = [0,2, 10,2, 10,6, 0,6];
    // var contours = [ca,cb];

    var points=inPath.get();

    if(!points || points.length===0)
    {
        outGeom.set(null);
        return;
    }

    var contours=[points];

    var points2=inPath2.get();
    if(points2 && points2.length>0) contours.push(points2);

    var points3=inPath3.get();
    if(points3 && points3.length>0) contours.push(points3);


    // console.log('contours',contours);

    var winding=Tess2.WINDING_ODD;
    if(inWinding.get()=="Positive")
    {
        winding=Tess2.WINDING_POSITIVE;
    }
    if(inWinding.get()=="Intersect")
    {
        winding=Tess2.WINDING_ABS_GEQ_TWO;
    }

    var res=null;
    try {
        // Tesselate
        res = Tess2.tesselate({
        	contours: contours,
        	windingRule: winding,
        	elementType: Tess2.POLYGONS,
        	polySize: 3,
        	vertexSize: 2
        });
    } catch (e) {}

    if(res)
    {
        const geom=new CGL.Geometry("tess2geom");

        var verts3=[];
        for(var i=0;i<res.vertices.length;i+=2)
        {
            verts3.push(res.vertices[i+0],res.vertices[i+1],0);
        }

        geom.vertices=verts3;
        geom.verticesIndices=res.elements;
        geom.calculateNormals();

        outGeom.set(null);
        outGeom.set(geom);

    }


}







};

Ops.Admin.Tess2.prototype = new CABLES.Op();
CABLES.OPS["6165a15f-abf3-4398-87f7-541bedc109e5"]={f:Ops.Admin.Tess2,objName:"Ops.Admin.Tess2"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.AreaDiscardPixel
// 
// **************************************************************

Ops.Gl.ShaderEffects.AreaDiscardPixel = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={areadiscard_frag:"\n\n\n\n\nfloat MOD_de=0.0;\n\n#ifdef MOD_AREA_SPHERE\n    MOD_de=distance(vec3(MOD_x,MOD_y,MOD_z),MOD_areaPos.xyz);\n#endif\n\n#ifdef MOD_AREA_AXIS_X\n    MOD_de=abs(MOD_x-MOD_areaPos.x);\n#endif\n#ifdef MOD_AREA_AXIS_XY\n    MOD_de=abs(MOD_x-MOD_areaPos.x+MOD_areaPos.y);\n#endif\n#ifdef MOD_AREA_AXIS_XZ\n    MOD_de=abs(MOD_x-MOD_areaPos.x+MOD_areaPos.z);\n#endif\n#ifdef MOD_AREA_AXIS_Y\n    MOD_de=abs(MOD_y-MOD_areaPos.y);\n#endif\n#ifdef MOD_AREA_AXIS_Z\n    MOD_de=abs(MOD_z-MOD_areaPos.z);\n#endif\n\n#ifdef MOD_AREA_AXIS_X_INFINITE\n    MOD_de=MOD_x-MOD_areaPos.x;\n#endif\n#ifdef MOD_AREA_AXIS_Y_INFINITE\n    MOD_de=MOD_y-MOD_areaPos.y;\n#endif\n#ifdef MOD_AREA_AXIS_Z_INFINITE\n    MOD_de=MOD_z-MOD_areaPos.z;\n#endif\n\n#ifdef MOD_AREA_REPEAT\n    MOD_de=mod(MOD_de,MOD_size+MOD_repeat);\n#endif\n\nMOD_de=MOD_de/MOD_size;\n\n#ifdef MOD_AREA_INVERT\n    MOD_de=1.0-MOD_de;\n#endif\n\n\nif(MOD_de<=0.5) discard;\n\n",areadiscard_head_frag:"IN vec4 MOD_areaPos;\nUNI float MOD_size;\nUNI float MOD_amount;\n\nUNI float MOD_x;\nUNI float MOD_y;\nUNI float MOD_z;\nUNI float MOD_repeat;",};

var cgl=op.patch.cgl;

op.render=op.inTrigger("render");
op.trigger=op.outTrigger("trigger");

var inArea=op.inValueSelect("Area",["Sphere","Axis X","Axis Y","Axis Z","Axis XY","Axis XZ","Axis X Infinite","Axis Y Infinite","Axis Z Infinite"],"Sphere");

var inSize=op.inValue("Size",1);


var inInvert=op.inValueBool("Invert");
var inRepeat=op.inValueBool("Repeat");
var inRepeatDist=op.inValueFloat("Repeat Distance",0.0);

{
    // position
    var x=op.inValue("x");
    var y=op.inValue("y");
    var z=op.inValue("z");
}

var inWorldSpace=op.inValueBool("WorldSpace",true);

var shader=null;

var srcHeadVert=''
    .endl()+'OUT vec4 MOD_areaPos;'
    .endl();

var srcBodyVert=''
    .endl()+'#ifndef MOD_WORLDSPACE'
    .endl()+'   MOD_areaPos=pos;'
    .endl()+'#endif'
    .endl()+'#ifdef MOD_WORLDSPACE'
    .endl()+'   MOD_areaPos=mMatrix*pos;'
    .endl()+'#endif'
    .endl();

var moduleFrag=null;
var moduleVert=null;

op.render.onLinkChanged=removeModule;
inWorldSpace.onChange=updateWorldspace;
inArea.onChange=updateArea;
inInvert.onChange=updateInvert;
inRepeat.onChange=updateRepeat;


function updateInvert()
{
    if(!shader)return;
    if(inInvert.get()) shader.define(moduleVert.prefix+"AREA_INVERT");
        else shader.removeDefine(moduleVert.prefix+"AREA_INVERT");
}

function updateRepeat()
{
    if(!shader)return;
    if(inRepeat.get()) shader.define(moduleVert.prefix+"AREA_REPEAT");
        else shader.removeDefine(moduleVert.prefix+"AREA_REPEAT");
}

function updateArea()
{
    if(!shader)return;

    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_X");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_XY");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_XZ");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Y");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Z");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_X_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Y_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Z_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_SPHERE");
    if(inArea.get()=="Axis X")shader.define(moduleVert.prefix+"AREA_AXIS_X");
    else if(inArea.get()=="Axis Y")shader.define(moduleVert.prefix+"AREA_AXIS_Y");
    else if(inArea.get()=="Axis Z")shader.define(moduleVert.prefix+"AREA_AXIS_Z");

    else if(inArea.get()=="Axis XY")shader.define(moduleVert.prefix+"AREA_AXIS_XY");
    else if(inArea.get()=="Axis XZ")shader.define(moduleVert.prefix+"AREA_AXIS_XZ");


    else if(inArea.get()=="Axis X Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_X_INFINITE");
    else if(inArea.get()=="Axis Y Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_Y_INFINITE");
    else if(inArea.get()=="Axis Z Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_Z_INFINITE");
    else shader.define(moduleVert.prefix+"AREA_SPHERE");
}

function updateWorldspace()
{
    if(!shader)return;
    if(inWorldSpace.get()) shader.define(moduleVert.prefix+"WORLDSPACE");
        else shader.removeDefine(moduleVert.prefix+"WORLDSPACE");
}

function removeModule()
{
    if(shader && moduleFrag) shader.removeModule(moduleFrag);
    if(shader && moduleVert) shader.removeModule(moduleVert);
    shader=null;
}

op.render.onTriggered=function()
{

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:x,
                posY:y,
                posZ:z
            });

    if(CABLES.UI && CABLES.UI.renderHelper)
    {
        CABLES.GL_MARKER.drawSphere(op,inSize.get());
    }

    if(!cgl.getShader())
    {
         op.trigger.trigger();
         return;
    }

    if(cgl.getShader()!=shader)
    {

        console.log("Areapixeldiscard shader change!");
        if(shader) removeModule();
        shader=cgl.getShader();

        moduleVert=shader.addModule(
            {
                priority:2,
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:srcHeadVert,
                srcBodyVert:srcBodyVert
            });

        moduleFrag=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_COLOR',
                srcHeadFrag:attachments.areadiscard_head_frag||'',
                srcBodyFrag:attachments.areadiscard_frag||''
            },moduleVert);

        inSize.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'size',inSize);

        x.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'x',x);
        y.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'y',y);
        z.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'z',z);
        inRepeatDist.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'repeat',inRepeatDist);

        updateWorldspace();
        updateArea();
        updateInvert();
        updateRepeat();
    }

    if(!shader)return;

    op.trigger.trigger();
};















};

Ops.Gl.ShaderEffects.AreaDiscardPixel.prototype = new CABLES.Op();
CABLES.OPS["85846539-6ef7-46ba-aaf5-156bb6f49b87"]={f:Ops.Gl.ShaderEffects.AreaDiscardPixel,objName:"Ops.Gl.ShaderEffects.AreaDiscardPixel"};




// **************************************************************
// 
// Ops.Math.Ease
// 
// **************************************************************

Ops.Math.Ease = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var inVal=op.inValue("Value");

var inMin=op.inValue("Min",0);
var inMax=op.inValue("Max",1);

var result=op.outValue("Result");

var anim=new CABLES.Anim();

anim.createPort(op,"Easing",updateAnimEasing);

anim.setValue(0,0);
anim.setValue(1,1);

inMin.onChange=inMax.onChange=updateMinMax;

function updateMinMax()
{
    anim.keys[0].time=anim.keys[0].value=Math.min(inMin.get(),inMax.get());
    anim.keys[1].time=anim.keys[1].value=Math.max(inMin.get(),inMax.get());
}

function updateAnimEasing()
{
    anim.keys[0].setEasing(anim.defaultEasing);    
}


inVal.onChange=function()
{
    var v=inVal.get();
    var r=anim.getValue(v);
    result.set(r);

};

};

Ops.Math.Ease.prototype = new CABLES.Op();
CABLES.OPS["8f6e4a08-33e6-408f-ac4a-198bd03b417b"]={f:Ops.Math.Ease,objName:"Ops.Math.Ease"};




// **************************************************************
// 
// Ops.Gl.Geometry.GeometryInfo
// 
// **************************************************************

Ops.Gl.Geometry.GeometryInfo = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    geometry=op.inObject("Geometry"),
    outIndexed=op.outValue("Indexed",false),
    outFaces=op.outValue("Faces"),
    outVertices=op.outValue("Vertices"),
    outNormals=op.outValue("Normals"),
    outTexCoords=op.outValue("TexCoords"),
    outTangents=op.outValue("Tangents"),
    outBiTangents=op.outValue("BiTangents"),
    outVertexColors=op.outValue("VertexColors"),
    outAttribs=op.outValue("Other Attributes");

geometry.onChange=function()
{
    var geom=geometry.get();
    if(geom)
    {
        outFaces.set(geom.verticesIndices.length/3);

        if(geom.vertices) outVertices.set(geom.vertices.length/3);
            else outVertices.set(0);

        if(geom.vertexNormals) outNormals.set(geom.vertexNormals.length/3);
            else outNormals.set(0);

        if(geom.texCoords) outTexCoords.set(geom.texCoords.length/2);
            else outTexCoords.set(0);

        if(geom.tangents) outTangents.set(geom.tangents.length/3);
            else outTangents.set(0);

        if(geom.biTangents) outBiTangents.set(geom.biTangents.length/3);
            else outBiTangents.set(0);

        if(geom.biTangents) outBiTangents.set(geom.biTangents.length/3);
            else outBiTangents.set(0);

        if(geom.vertexColors) outVertexColors.set(geom.vertexColors.length/3);
            else outVertexColors.set(0);

        if(geom.getAttributes()) outAttribs.set(Object.keys(geom.getAttributes()).length);
            else outAttribs.set(0);

        outIndexed.set(geom.isIndexed());
    }
    else
    {
        outIndexed.set(null);
        outFaces.set(null);
        outVertices.set(null);
        outNormals.set(null);
        outTexCoords.set(null);
        outTangents.set(null);
        outBiTangents.set(null);
        outVertexColors.set(null);
        outAttribs.set(null);
    }

};

};

Ops.Gl.Geometry.GeometryInfo.prototype = new CABLES.Op();
CABLES.OPS["a9208e84-e957-43ac-9a79-9c719eff95eb"]={f:Ops.Gl.Geometry.GeometryInfo,objName:"Ops.Gl.Geometry.GeometryInfo"};




// **************************************************************
// 
// Ops.Value.DelayedValue
// 
// **************************************************************

Ops.Value.DelayedValue = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var exe=op.inTrigger("Update");
var v=op.inValue("Value",0);
var delay=op.inValue("Delay",0.5);
var result=op.outValue("Result",0);
var clear=op.inValueBool("Clear on Change",false);

var anim=new CABLES.Anim();
anim.createPort(op,"easing",function(){}).set("absolute");

exe.onTriggered=function()
{
    result.set(anim.getValue( op.patch.freeTimer.get() )||0);
};

v.onChange=function()
{
    var current=anim.getValue( op.patch.freeTimer.get() );
    var t=op.patch.freeTimer.get();

    if(clear.get()) anim.clear(t);

    anim.setValue(t+delay.get(),v.get());
};

};

Ops.Value.DelayedValue.prototype = new CABLES.Op();
CABLES.OPS["8e7741e0-0b1b-40f3-a62c-ac8a8828dffb"]={f:Ops.Value.DelayedValue,objName:"Ops.Value.DelayedValue"};




// **************************************************************
// 
// Ops.Boolean.IfTrueThen
// 
// **************************************************************

Ops.Boolean.IfTrueThen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    boolean=op.inValueBool("boolean",false),
    triggerThen=op.outTrigger("then"),
    triggerElse=op.outTrigger("else");

boolean.onChange=execBool;
exe.onTriggered=exec;

function execBool()
{
    if(exe.isLinked())return;
    exec();
}

function exec()
{
    if(boolean.get() || boolean.get()>=1 ) triggerThen.trigger();
        else triggerElse.trigger();
}



};

Ops.Boolean.IfTrueThen.prototype = new CABLES.Op();
CABLES.OPS["99892fda-8821-4660-ac57-3103d1546924"]={f:Ops.Boolean.IfTrueThen,objName:"Ops.Boolean.IfTrueThen"};




// **************************************************************
// 
// Ops.Math.Compare.Equals
// 
// **************************************************************

Ops.Math.Compare.Equals = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1 = op.inValue("number1",1);
const number2 = op.inValue("number2",1);
const result = op.outValue("result");


number1.onChange=exec;
number2.onChange=exec;
exec();

function exec()
{
    result.set( number1.get() == number2.get() );
}



};

Ops.Math.Compare.Equals.prototype = new CABLES.Op();
CABLES.OPS["4dd3cc55-eebc-4187-9d4e-2e053a956fab"]={f:Ops.Math.Compare.Equals,objName:"Ops.Math.Compare.Equals"};




// **************************************************************
// 
// Ops.Boolean.Not
// 
// **************************************************************

Ops.Boolean.Not = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var bool=op.inValueBool("Boolean");
var outbool=op.outValue("Result");

bool.changeAlways=true;

bool.onChange=function()
{
    outbool.set( ! (true==bool.get()) );
};


};

Ops.Boolean.Not.prototype = new CABLES.Op();
CABLES.OPS["6d123c9f-7485-4fd9-a5c2-76e59dcbeb34"]={f:Ops.Boolean.Not,objName:"Ops.Boolean.Not"};




// **************************************************************
// 
// Ops.Value.Number
// 
// **************************************************************

Ops.Value.Number = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const v=op.inValueFloat("value");
const result=op.outValue("result");

v.onChange=exec;

function exec()
{
    result.set(parseFloat(v.get()));
}

};

Ops.Value.Number.prototype = new CABLES.Op();
CABLES.OPS["8fb2bb5d-665a-4d0a-8079-12710ae453be"]={f:Ops.Value.Number,objName:"Ops.Value.Number"};




// **************************************************************
// 
// Ops.Value.ValueChangedTrigger
// 
// **************************************************************

Ops.Value.ValueChangedTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var val=op.addInPort(new CABLES.Port(op,"Value"));
var exe=op.inTrigger("Execute");
var trigger=op.outTrigger('trigger');

var changed=false;

exe.onTriggered=function()
{
    if(changed)
    {
        changed=false;
        trigger.trigger();
    }
};

val.onChange=function()
{
    changed=true;
};



};

Ops.Value.ValueChangedTrigger.prototype = new CABLES.Op();
CABLES.OPS["9f353fcc-da0b-4af8-ae5c-4edd256fc9e3"]={f:Ops.Value.ValueChangedTrigger,objName:"Ops.Value.ValueChangedTrigger"};




// **************************************************************
// 
// Ops.Time.TimeSinceTrigger
// 
// **************************************************************

Ops.Time.TimeSinceTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    trigger=op.inTriggerButton("trigger"),
    reset=op.inTriggerButton("reset"),
    next=op.outTrigger("next"),
    time=op.outValue("time");

var lastTrigger=op.patch.freeTimer.get();
time.set(0);

exe.onTriggered=function()
{
    time.set( op.patch.freeTimer.get()-lastTrigger);
    next.trigger();
};

reset.onTriggered=function()
{
    time.set(0);
};

trigger.onTriggered=function()
{
    lastTrigger=op.patch.freeTimer.get();
    time.set(0);
};

};

Ops.Time.TimeSinceTrigger.prototype = new CABLES.Op();
CABLES.OPS["df54103f-5ef6-4a4f-adcf-dddc005132f8"]={f:Ops.Time.TimeSinceTrigger,objName:"Ops.Time.TimeSinceTrigger"};




// **************************************************************
// 
// Ops.Math.Clamp
// 
// **************************************************************

Ops.Math.Clamp = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const val=op.inValueFloat("val",0.5);
const min=op.inValueFloat("min",0);
const max=op.inValueFloat("max",1);
const ignore=op.inValueBool("ignore outside values");
const result=op.outValue("result");

val.onChange=min.onChange=max.onChange=clamp;

function clamp()
{
    if(ignore.get())
    {
        if(val.get()>max.get()) return;
        if(val.get()<min.get()) return;
    }
    result.set( Math.min(Math.max(val.get(), min.get()), max.get()));
}



};

Ops.Math.Clamp.prototype = new CABLES.Op();
CABLES.OPS["cda1a98e-5e16-40bd-9b18-a67e9eaad5a1"]={f:Ops.Math.Clamp,objName:"Ops.Math.Clamp"};




// **************************************************************
// 
// Ops.Trigger.SetNumberOnTrigger
// 
// **************************************************************

Ops.Trigger.SetNumberOnTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    setValuePort = op.inTriggerButton("Set"),
    valuePort = op.inValueFloat("Number"),
    outNext=op.outTrigger("Next"),
    outValuePort = op.outValue("Out Value");

outValuePort.changeAlways = true;

setValuePort.onTriggered = function()
{
    outValuePort.set(valuePort.get());
    outNext.trigger();
};

};

Ops.Trigger.SetNumberOnTrigger.prototype = new CABLES.Op();
CABLES.OPS["9989b1c0-1073-4d5f-bfa0-36dd98b66e27"]={f:Ops.Trigger.SetNumberOnTrigger,objName:"Ops.Trigger.SetNumberOnTrigger"};




// **************************************************************
// 
// Ops.Trigger.TimedSequence
// 
// **************************************************************

Ops.Trigger.TimedSequence = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTrigger("exe");
const current=op.inValueInt("current",0);
const overwriteTime=op.inValueBool("overwriteTime");
const ignoreInSubPatch=op.inValueBool("ignoreInSubPatch",false);
const triggerAlways=op.outTrigger("triggerAlways");
const outNames=op.outArray("Names",[]);
const currentKeyTime=op.outValue("currentKeyTime");
const outCurrent=op.outValue("Current");
var triggers=[];

for(var i=0;i<32;i++)
{
    var p=op.outTrigger("trigger "+i);
    p.onLinkChanged=updateNames;
    triggers.push( p );
}

function updateNames()
{
    var names=[];
    for(var i=0;i<triggers.length;i++)
        if(triggers[i].isLinked()) names.push(triggers[i].links[0].getOtherPort(triggers[i]).parent.uiAttribs.title);
            else names.push("none");

    outNames.set(names);
}

op.onLoaded=updateNames;

var lastUiValue=-1;

exe.onTriggered=doTrigger;

function doTrigger(_time)
{
    var spl=0;

    var outIndex=Math.round(current.get()-0.5);

    if(window.gui)
    {

        if(current.get()!=lastUiValue)
        {
            lastUiValue=current.get();
            for(spl=0;spl<triggers.length;spl++)
            {
                if(spl==lastUiValue) triggers[spl].setUiActiveState(true);
                    else triggers[spl].setUiActiveState(false);
            }
        }
    }

    if(current.anim)
    {
        var time=_time;
        if(_time===undefined) time=current.parent.patch.timer.getTime();

var key=current.anim.getKey(time);
var timeOff=0;
if(key) timeOff=key.time

        currentKeyTime.set(time-timeOff);

        if(current.isAnimated())
        {
            if(overwriteTime.get())
            {
                current.parent.patch.timer.overwriteTime=currentKeyTime.get();  // todo  why current ? why  not self ?
            }
        }
    }

    if(op.patch.gui && ignoreInSubPatch.get() )
    {
        for(var i=0;i<triggers.length;i++)
        {
            for(spl=0;spl<triggers[i].links.length;spl++)
            {
                if(triggers[i].links[spl])
                {
                    if(triggers[i].links[spl].portIn.parent.patchId)
                    {
                        if(gui.patch().getCurrentSubPatch() == triggers[i].links[spl].portIn.parent.patchId.get())
                        {
                            op.patch.timer.overwriteTime=-1;
                            triggers[i].trigger();
                            return;
                        }
                    }
                }
            }
        }
    }


    if(outIndex>=0 && outIndex<triggers.length)
    {
        outCurrent.set(outIndex);
        triggers[outIndex].trigger();
    }

    op.patch.timer.overwriteTime=-1;
    triggerAlways.trigger();
}


};

Ops.Trigger.TimedSequence.prototype = new CABLES.Op();
CABLES.OPS["73c892c9-3e81-4ddc-952a-fbe6bf00ef2c"]={f:Ops.Trigger.TimedSequence,objName:"Ops.Trigger.TimedSequence"};




// **************************************************************
// 
// Ops.Deprecated.Gl.TextureEffects.Stripes
// 
// **************************************************************

Ops.Deprecated.Gl.TextureEffects.Stripes = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={stripes_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float num;\nUNI float width;\nUNI float axis;\nUNI float offset;\n\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\nvoid main()\n{\n   vec4 col=texture(tex,texCoord);\n\n   float v=0.0;\n   float c=1.0;\n   if(axis==0.0) v=texCoord.y;\n   if(axis==1.0) v=texCoord.x;\n   if(axis==2.0) v=texCoord.x+texCoord.y;\n   if(axis==3.0) v=texCoord.x-texCoord.y;\n   v+=offset;\n\n\n   float m=mod(v,1.0/num);\n   float rm=width*2.0*1.0/num/2.0;\n\n   if(m>rm)\n       col.rgb=mix(col.rgb,vec3( r,g,b ),a);\n\n   #ifdef STRIPES_SMOOTHED\n       m*=2.0;\n       col.rgb=vec3(  smoothstep(0.,1., abs(( ((m-rm) )/ (rm) )  ) ));\n   #endif\n\n   outColor= col;\n}",};

var render=op.inTrigger('render');
var num=op.addInPort(new CABLES.Port(op,"num",CABLES.OP_PORT_TYPE_VALUE));
var width=op.addInPort(new CABLES.Port(op,"width",CABLES.OP_PORT_TYPE_VALUE,{display:'range'}));
var axis=op.addInPort(new CABLES.Port(op,"axis",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['X','Y','Diagonal','Diagonal Flip']}));

var offset=op.addInPort(new CABLES.Port(op,"offset",CABLES.OP_PORT_TYPE_VALUE));

var smoothed=op.inValueBool("Gradients");

var r=op.addInPort(new CABLES.Port(op,"r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true'}));
var g=op.addInPort(new CABLES.Port(op,"g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var b=op.addInPort(new CABLES.Port(op,"b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var a=op.addInPort(new CABLES.Port(op,"a",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));

var trigger=op.outTrigger('trigger');

smoothed.onChange=function()
{

    if(smoothed.get())shader.define("STRIPES_SMOOTHED");
    else shader.removeDefine("STRIPES_SMOOTHED");
};

axis.onChange=function()
{
    if(axis.get()=='X')uniAxis.setValue(0);
    if(axis.get()=='Y')uniAxis.setValue(1);
    if(axis.get()=='Diagonal')uniAxis.setValue(2);
    if(axis.get()=='Diagonal Flip')uniAxis.setValue(3);
};

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'textureeffect stripes');
shader.setSource(shader.getDefaultVertexShader(),attachments.stripes_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);


var numUniform=new CGL.Uniform(shader,'f','num',num);
var uniWidth=new CGL.Uniform(shader,'f','width',width);
var uniAxis=new CGL.Uniform(shader,'f','axis',0);
var uniOffset=new CGL.Uniform(shader,'f','offset',offset);

r.set(1.0);
g.set(1.0);
b.set(1.0);
a.set(1.0);
axis.set('X');
num.set(5);
width.set(0.5);

var uniformR=new CGL.Uniform(shader,'f','r',r);
var uniformG=new CGL.Uniform(shader,'f','g',g);
var uniformB=new CGL.Uniform(shader,'f','b',b);
var uniformA=new CGL.Uniform(shader,'f','a',a);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Deprecated.Gl.TextureEffects.Stripes.prototype = new CABLES.Op();
CABLES.OPS["38576e9c-3690-4a44-ac9b-ad28816749a1"]={f:Ops.Deprecated.Gl.TextureEffects.Stripes,objName:"Ops.Deprecated.Gl.TextureEffects.Stripes"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.BulgePinch
// 
// **************************************************************

Ops.Gl.TextureEffects.BulgePinch = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={bulgepinch_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float radius;\nUNI float strength;\nUNI float centerX;\nUNI float centerY;\n\nvoid main()\n{\n   vec2 center=vec2(centerX,centerY);\n   vec2 coord=texCoord;\n   coord -= center;\n   float distance = length(coord);\n   float percent = distance / radius;\n   if (strength > 0.0) coord *= mix(1.0, smoothstep(0.0, radius / distance, percent), strength * 0.75);\n   else coord *= mix(1.0, pow(percent, 1.0 + strength * 0.75) * radius / distance, 1.0 - percent);\n   coord += center;\n   vec4 col=texture(tex,coord);\n   outColor= col;\n}",};
const
    render=op.inTrigger('render'),
    radius=op.inValueFloat("Radius",0.5),
    strength=op.inValueFloat("Strength",1),
    centerX=op.inValueFloat("Center X",0.5),
    centerY=op.inValueFloat("Center Y",0.5),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'bulgepinch');
shader.setSource(shader.getDefaultVertexShader(),attachments.bulgepinch_frag);

const
    uniRadius=new CGL.Uniform(shader,'f','radius',radius),
    uniStrength=new CGL.Uniform(shader,'f','strength',strength),
    uniCenterX=new CGL.Uniform(shader,'f','centerX',centerX),
    uniCenterY=new CGL.Uniform(shader,'f','centerY',centerY),
    textureUniform=new CGL.Uniform(shader,'t','tex',0);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.BulgePinch.prototype = new CABLES.Op();
CABLES.OPS["25696840-bd64-463e-9301-964a81385bfb"]={f:Ops.Gl.TextureEffects.BulgePinch,objName:"Ops.Gl.TextureEffects.BulgePinch"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Interlace
// 
// **************************************************************

Ops.Gl.TextureEffects.Interlace = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={interlace_frag:"\n#ifdef HAS_TEXTURES\n  IN vec2 texCoord;\n  UNI sampler2D tex;\n#endif\nUNI float amount;\nUNI float lum;\nUNI float add;\nUNI float lineSize;\nUNI float scroll;\nUNI float displace;\n\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n\n   col=texture(tex,texCoord);\n    // .endl()+'   col=clamp(col,0.0,1.0);'\n\n    float dir;\n    #ifdef DIRECTION\n        dir = gl_FragCoord.x;\n    #endif\n\n    #ifndef DIRECTION\n        dir = gl_FragCoord.y;\n    #endif\n\n   if( mod(dir+scroll,lineSize)>=lineSize*0.5)\n   {\n       col=texture(tex,vec2(texCoord.x+displace*0.05,texCoord.y));\n       float gray = vec3(dot(vec3(0.2126,0.7152,0.0722), col.rgb)).r;\n       col.rgb=col.rgb*(1.0-amount) + (col.rgb*gray*gray*lum)*amount;\n   }\n   else col+=add;\n\n\n   outColor= col;\n}",};
var render=op.inTrigger('render');
var amount=op.inValueSlider("amount",0.5);
var lum=op.inValueSlider("Lumi Scale",0.9);
var direction = op.inBool("X or Y",true);
var lineSize=op.inValue("Line Size",4);
var displace=op.inValueSlider("Displacement",0);

var add=op.inValue("Add",0.02);
var inScroll=op.inValue("scroll",0);

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.interlace_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniAmount=new CGL.Uniform(shader,'f','amount',amount);

var uniLum=new CGL.Uniform(shader,'f','lum',lum);
var uniLineSize=new CGL.Uniform(shader,'f','lineSize',lineSize);
var uniAdd=new CGL.Uniform(shader,'f','add',add);
var uniDisplace=new CGL.Uniform(shader,'f','displace',displace);
var uniScroll=new CGL.Uniform(shader,'f','scroll',inScroll);

direction.onChange=function()
{
    shader.toggleDefine('DIRECTION',direction.get());
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Interlace.prototype = new CABLES.Op();
CABLES.OPS["3cd69d5b-6c05-4522-9551-52458f99421a"]={f:Ops.Gl.TextureEffects.Interlace,objName:"Ops.Gl.TextureEffects.Interlace"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Circle
// 
// **************************************************************

Ops.Gl.TextureEffects.Circle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={circle_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float amount;\nUNI float size;\nUNI float inner;\nUNI float fadeOut;\n\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\nUNI float aspect;\nUNI float stretch;\n\nUNI float x;\nUNI float y;\n\n{{CGL.BLENDMODES}}\n\nfloat dist(float x,float y,float x2,float y2)\n{\n\tfloat xd = x2-x;\n\tfloat yd = y2-y;\n\treturn abs(sqrt(xd*xd + yd*yd*(1.0-stretch)));\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec4 col=vec4(0.0,0.0,0.0,1.0);\n    float dist = dist(x,y,texCoord.x+0.5,(texCoord.y-0.5)*aspect+0.5);\n\n    float sz=size*0.5;\n    float v=0.0;\n    float fade=fadeOut+0.002;\n\n    if(dist<sz && dist>inner*sz) v=1.0;\n\n    #ifdef FALLOFF_SMOOTHSTEP\n        if(dist>sz && dist<sz+fade)v=1.0-(smoothstep(0.0,1.0,(dist-sz)/(fade)) );\n    #endif\n    #ifndef FALLOFF_SMOOTHSTEP\n        if(dist>sz && dist<sz+fade)v=1.0-((dist-sz)/(fade));\n    #endif\n\n    col=vec4( _blend(base.rgb,vec3(r,g,b)) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*v*amount),1.0);\n    outColor=col;\n\n    #ifdef WARN_OVERFLOW\n        float width=0.01;\n        if( texCoord.x>(1.0-width) || texCoord.y>(1.0-width) || texCoord.y<width || texCoord.x<width )\n            if(v>0.001*amount)outColor= vec4(1.0,0.0,0.0, 1.0);\n    #endif\n}\n",};
var render=op.inTrigger("render");
var blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
var amount=op.inValueSlider("Amount",1);
var inSize=op.inValueSlider("size");
var inInner=op.inValueSlider("Inner");
var inStretch=op.inValueSlider("Stretch");

var inX=op.inValue("Pos X",0.5);
var inY=op.inValue("Pos Y",0.5);

var fallOff=op.inValueSelect("fallOff",['Linear','SmoothStep'],"Linear");
var inFadeOut=op.inValueSlider("fade Out");
var warnOverflow=op.inValueBool("warn overflow",true);

const r = op.inValueSlider("r", 1);
const g = op.inValueSlider("g", 1);
const b = op.inValueSlider("b", 1);
const a = op.inValueSlider("a", 1);

r.setUiAttribs({ colorPick: true });

op.setPortGroup("Size",[inSize,inInner,inStretch]);
op.setPortGroup("Position",[inX,inY]);
op.setPortGroup("Style",[warnOverflow,fallOff,inFadeOut]);


var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'textureeffect stripes');
shader.setSource(shader.getDefaultVertexShader(),attachments.circle_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);


var uniStretch=new CGL.Uniform(shader,'f','stretch',inStretch);
var uniSize=new CGL.Uniform(shader,'f','size',inSize);
var uniFadeOut=new CGL.Uniform(shader,'f','fadeOut',inFadeOut);
var uniInner=new CGL.Uniform(shader,'f','inner',inInner);
var aspect=new CGL.Uniform(shader,'f','aspect',1);

inSize.set(0.25);

setFallOf();
setWarnOverflow();

var uniformR=new CGL.Uniform(shader,'f','r',r);
var uniformG=new CGL.Uniform(shader,'f','g',g);
var uniformB=new CGL.Uniform(shader,'f','b',b);
var uniformA=new CGL.Uniform(shader,'f','a',a);

var uniformX=new CGL.Uniform(shader,'f','x',inX);
var uniformY=new CGL.Uniform(shader,'f','y',inY);

fallOff.onChange=setFallOf;
warnOverflow.onChange=setWarnOverflow;

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

function setFallOf()
{
    shader.removeDefine('FALLOFF_LINEAR');
    shader.removeDefine('FALLOFF_SMOOTHSTEP');

    if(fallOff.get()=='Linear') shader.define('FALLOFF_LINEAR');
    if(fallOff.get()=='SmoothStep') shader.define('FALLOFF_SMOOTHSTEP');
}

function setWarnOverflow()
{
    if(warnOverflow.get()) shader.define('WARN_OVERFLOW');
        else shader.removeDefine('WARN_OVERFLOW');
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var a=cgl.currentTextureEffect.getCurrentSourceTexture().height/cgl.currentTextureEffect.getCurrentSourceTexture().width;
    aspect.set(a);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Circle.prototype = new CABLES.Op();
CABLES.OPS["c260d839-065c-4101-8943-c4680b771343"]={f:Ops.Gl.TextureEffects.Circle,objName:"Ops.Gl.TextureEffects.Circle"};




// **************************************************************
// 
// Ops.Deprecated.Gl.TextureEffects.Twirl
// 
// **************************************************************

Ops.Deprecated.Gl.TextureEffects.Twirl = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var render=op.inTrigger('render');
var amount=op.inValue("amount");


var times=op.inValue("times",1);

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);


var srcFrag=''
    .endl()+'IN vec2 texCoord;'
    .endl()+'UNI sampler2D tex;'
    .endl()+'UNI float amount;'
    .endl()+'UNI float times;'

    .endl()+'void main()'
    .endl()+'{'
    .endl()+'   vec2 tc = texCoord.st-0.5;'
    
    // .endl()+'   tc.x+=centerX;'

    .endl()+'   float angle = times*atan(tc.y,tc.x);'
    .endl()+'   float radius = length(tc);'
    .endl()+'   angle+= radius*amount*1.0;'
    .endl()+'   vec2 shifted = radius*vec2(cos(angle), sin(angle));'
    .endl()+'   vec4 col = texture2D(tex, (shifted+0.5));'

    .endl()+'   outColor= col;'
    .endl()+'}';

shader.setSource(shader.getDefaultVertexShader(),srcFrag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniamount=new CGL.Uniform(shader,'f','amount',0);
var unitimes=new CGL.Uniform(shader,'f','times',times);




render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    uniamount.setValue(amount.get()*(1/texture.width));

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );
    // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, texture.tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Deprecated.Gl.TextureEffects.Twirl.prototype = new CABLES.Op();
CABLES.OPS["2c321015-1af1-49da-b5a6-1664b5ad9a35"]={f:Ops.Deprecated.Gl.TextureEffects.Twirl,objName:"Ops.Deprecated.Gl.TextureEffects.Twirl"};




// **************************************************************
// 
// Ops.Gl.Shader.BasicMaterial
// 
// **************************************************************

Ops.Gl.Shader.BasicMaterial = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={shader_frag:"{{MODULES_HEAD}}\n\nIN vec2 texCoord;\n#ifdef HAS_TEXTURES\n    IN vec2 texCoordOrig;\n    #ifdef HAS_TEXTURE_DIFFUSE\n        UNI sampler2D tex;\n    #endif\n    #ifdef HAS_TEXTURE_OPACITY\n        UNI sampler2D texOpacity;\n   #endif\n#endif\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\nvoid main()\n{\n    {{MODULE_BEGIN_FRAG}}\n    vec4 col=vec4(r,g,b,a);\n\n    #ifdef HAS_TEXTURES\n        #ifdef HAS_TEXTURE_DIFFUSE\n\n           col=texture(tex,vec2(texCoord.x,(1.0-texCoord.y)));\n\n           #ifdef COLORIZE_TEXTURE\n               col.r*=r;\n               col.g*=g;\n               col.b*=b;\n           #endif\n        #endif\n\n        col.a*=a;\n        #ifdef HAS_TEXTURE_OPACITY\n            #ifdef TRANSFORMALPHATEXCOORDS\n                col.a*=texture(texOpacity,vec2(texCoordOrig.s,1.0-texCoordOrig.t)).g;\n            #endif\n            #ifndef TRANSFORMALPHATEXCOORDS\n                col.a*=texture(texOpacity,vec2(texCoord.s,1.0-texCoord.t)).g;\n            #endif\n       #endif\n\n    #endif\n\n    {{MODULE_COLOR}}\n\n    outColor = col;\n\n\n}\n",shader_vert:"{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nIN vec3 attrVertNormal;\nIN vec2 attrTexCoord;\n\nOUT vec3 norm;\nOUT vec2 texCoord;\nOUT vec2 texCoordOrig;\n\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\n#ifdef HAS_TEXTURES\n    #ifdef TEXTURE_REPEAT\n        UNI float diffuseRepeatX;\n        UNI float diffuseRepeatY;\n        UNI float texOffsetX;\n        UNI float texOffsetY;\n    #endif\n#endif\n\n\nvoid main()\n{\n    mat4 mMatrix=modelMatrix;\n    mat4 mvMatrix;\n    \n    texCoordOrig=attrTexCoord;\n    texCoord=attrTexCoord;\n    #ifdef HAS_TEXTURES\n        #ifdef TEXTURE_REPEAT\n            texCoord.x=texCoord.x*diffuseRepeatX+texOffsetX;\n            texCoord.y=texCoord.y*diffuseRepeatY+texOffsetY;\n        #endif\n    #endif\n\n    vec4 pos = vec4( vPosition, 1. );\n\n\n    #ifdef BILLBOARD\n       vec3 position=vPosition;\n       mvMatrix=viewMatrix*modelMatrix;\n\n       gl_Position = projMatrix * mvMatrix * vec4((\n           position.x * vec3(\n               mvMatrix[0][0],\n               mvMatrix[1][0],\n               mvMatrix[2][0] ) +\n           position.y * vec3(\n               mvMatrix[0][1],\n               mvMatrix[1][1],\n               mvMatrix[2][1]) ), 1.0);\n    #endif\n\n    {{MODULE_VERTEX_POSITION}}\n\n    #ifndef BILLBOARD\n        mvMatrix=viewMatrix * mMatrix;\n    #endif\n\n\n    #ifndef BILLBOARD\n        // gl_Position = projMatrix * viewMatrix * modelMatrix * pos;\n        gl_Position = projMatrix * mvMatrix * pos;\n    #endif\n}\n",};
const render=op.inTrigger("render"),
    trigger=op.outTrigger("trigger"),
    shaderOut=op.outObject("shader");

shaderOut.ignoreValueSerialize=true;
const cgl=op.patch.cgl;

var shader=new CGL.Shader(cgl,'BasicMaterial');
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.bindTextures=bindTextures;
shader.setSource(attachments.shader_vert,attachments.shader_frag);
shaderOut.set(shader);

render.onTriggered=doRender;

var textureOpacity=null;
var textureOpacityUniform=null;


function bindTextures()
{
    if(diffuseTexture.get()) cgl.setTexture(0, diffuseTexture.get().tex);
    if(textureOpacity.get()) cgl.setTexture(1, textureOpacity.get().tex);
}

op.preRender=function()
{
    shader.bind();
    doRender();
};

function doRender()
{
    if(!shader)return;

    cgl.setShader(shader);
    shader.bindTextures();

    trigger.trigger();

    cgl.setPreviousShader();
}


{
    // rgba colors
    const r = op.inValueSlider("r", Math.random()),
        g = op.inValueSlider("g", Math.random()),
        b = op.inValueSlider("b", Math.random()),
        a = op.inValueSlider("a",1.0);
        r.setUiAttribs({ colorPick: true });



    a.uniform=new CGL.Uniform(shader,'f','a',a);
    b.uniform=new CGL.Uniform(shader,'f','b',b);
    r.uniform=new CGL.Uniform(shader,'f','r',r);
    g.uniform=new CGL.Uniform(shader,'f','g',g);

    op.setPortGroup('Color',[r,g,b,a]);

}

{
    // diffuse outTexture


    var diffuseTexture=op.inTexture("texture");
    var diffuseTextureUniform=null;
    shader.bindTextures=bindTextures;

    diffuseTexture.onChange=function()
    {
        if(diffuseTexture.get())
        {
            // if(diffuseTextureUniform!==null)return;
            // shader.addveUniform('texDiffuse');
            if(!shader.hasDefine('HAS_TEXTURE_DIFFUSE'))shader.define('HAS_TEXTURE_DIFFUSE');
            if(!diffuseTextureUniform)diffuseTextureUniform=new CGL.Uniform(shader,'t','texDiffuse',0);
            updateTexRepeat();
        }
        else
        {
            shader.removeUniform('texDiffuse');
            shader.removeDefine('HAS_TEXTURE_DIFFUSE');
            diffuseTextureUniform=null;
        }
    };
}

{
    // opacity texture
    textureOpacity=op.inTexture("textureOpacity");

    textureOpacity.onChange=function()
    {
        if(textureOpacity.get())
        {
            if(textureOpacityUniform!==null)return;
            shader.removeUniform('texOpacity');
            shader.define('HAS_TEXTURE_OPACITY');
            if(!textureOpacityUniform)textureOpacityUniform=new CGL.Uniform(shader,'t','texOpacity',1);
        }
        else
        {
            shader.removeUniform('texOpacity');
            shader.removeDefine('HAS_TEXTURE_OPACITY');
            textureOpacityUniform=null;
        }
    };

}

op.colorizeTexture=op.inValueBool("colorizeTexture");
op.colorizeTexture.set(false);
op.colorizeTexture.onChange=function()
{
    if(op.colorizeTexture.get()) shader.define('COLORIZE_TEXTURE');
        else shader.removeDefine('COLORIZE_TEXTURE');
};

op.doBillboard=op.inValueBool("billboard");
op.doBillboard.set(false);

op.doBillboard.onChange=function()
{
    if(op.doBillboard.get()) shader.define('BILLBOARD');
        else shader.removeDefine('BILLBOARD');
};

var texCoordAlpha=op.inValueBool("Opacity TexCoords Transform",false);

texCoordAlpha.onChange=function()
{
    if(texCoordAlpha.get()) shader.define('TRANSFORMALPHATEXCOORDS');
        else shader.removeDefine('TRANSFORMALPHATEXCOORDS');

};

var preMultipliedAlpha=op.inValueBool("preMultiplied alpha");

function updateTexRepeat()
{
    if(!diffuseRepeatXUniform)
    {
        diffuseRepeatXUniform=new CGL.Uniform(shader,'f','diffuseRepeatX',diffuseRepeatX);
        diffuseRepeatYUniform=new CGL.Uniform(shader,'f','diffuseRepeatY',diffuseRepeatY);
        diffuseOffsetXUniform=new CGL.Uniform(shader,'f','texOffsetX',diffuseOffsetX);
        diffuseOffsetYUniform=new CGL.Uniform(shader,'f','texOffsetY',diffuseOffsetY);
    }

    diffuseRepeatXUniform.setValue(diffuseRepeatX.get());
    diffuseRepeatYUniform.setValue(diffuseRepeatY.get());
    diffuseOffsetXUniform.setValue(diffuseOffsetX.get());
    diffuseOffsetYUniform.setValue(diffuseOffsetY.get());
}

{
    // texture coords

    var diffuseRepeatX=op.inValueFloat("diffuseRepeatX",1);
    var diffuseRepeatY=op.inValueFloat("diffuseRepeatY",1);
    var diffuseOffsetX=op.inValueFloat("Tex Offset X");
    var diffuseOffsetY=op.inValueFloat("Tex Offset Y");

    op.setPortGroup('Transform Texture',[diffuseRepeatX,diffuseRepeatY,diffuseOffsetX,diffuseOffsetY]);

    diffuseRepeatX.onChange=updateTexRepeat;
    diffuseRepeatY.onChange=updateTexRepeat;
    diffuseOffsetY.onChange=updateTexRepeat;
    diffuseOffsetX.onChange=updateTexRepeat;

    var diffuseRepeatXUniform=null;
    var diffuseRepeatYUniform=null;
    var diffuseOffsetXUniform=null;
    var diffuseOffsetYUniform=null;

    shader.define('TEXTURE_REPEAT');

    diffuseOffsetX.set(0);
    diffuseOffsetY.set(0);
    diffuseRepeatX.set(1);
    diffuseRepeatY.set(1);
}


updateTexRepeat();


};

Ops.Gl.Shader.BasicMaterial.prototype = new CABLES.Op();
CABLES.OPS["85ae5cfa-5eca-4dd8-8b30-850ac34f7cd5"]={f:Ops.Gl.Shader.BasicMaterial,objName:"Ops.Gl.Shader.BasicMaterial"};




// **************************************************************
// 
// Ops.Deprecated.Gl.TextureEffects.Color
// 
// **************************************************************

Ops.Deprecated.Gl.TextureEffects.Color = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.name='Color';
var render=op.inTrigger('render');
var r=op.addInPort(new CABLES.Port(op,"r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true'}));
var g=op.addInPort(new CABLES.Port(op,"g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var b=op.addInPort(new CABLES.Port(op,"b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var a=op.addInPort(new CABLES.Port(op,"a",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'textureeffect color');



var srcFrag=''
    .endl()+'precision highp float;'
    .endl()+'#ifdef HAS_TEXTURES'
    .endl()+'  IN vec2 texCoord;'
    .endl()+'  uniform sampler2D tex;'
    .endl()+'#endif'
    .endl()+'uniform float r;'
    .endl()+'uniform float g;'
    .endl()+'uniform float b;'
    .endl()+'uniform float a;'
    .endl()+''
    .endl()+'void main()'
    .endl()+'{'
    .endl()+'   vec4 col=vec4(r,g,b,a);'
    .endl()+'   gl_FragColor = col;'
    .endl()+'}';

shader.setSource(shader.getDefaultVertexShader(),srcFrag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
r.set(1.0);
g.set(1.0);
b.set(1.0);
a.set(1.0);

var uniformR=new CGL.Uniform(shader,'f','r',r);
var uniformG=new CGL.Uniform(shader,'f','g',g);
var uniformB=new CGL.Uniform(shader,'f','b',b);
var uniformA=new CGL.Uniform(shader,'f','a',a);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0,cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

// op.name='Color';
// var render=op.inTrigger('render');


// var blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
// var amount=op.inValueSlider("Amount",1);


// var r=op.addInPort(new CABLES.Port(op,"r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true'}));
// var g=op.addInPort(new CABLES.Port(op,"g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
// var b=op.addInPort(new CABLES.Port(op,"b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
// var a=op.addInPort(new CABLES.Port(op,"a",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
// var trigger=op.outTrigger('trigger');

// var cgl=op.patch.cgl;
// var shader=new CGL.Shader(cgl,'textureeffect color');



// var srcFrag=''+
//     CGL.TextureEffect.getBlendCode()
//     .endl()+'precision highp float;'
//     .endl()+'#ifdef HAS_TEXTURES'
//     .endl()+'  IN vec2 texCoord;'
//     .endl()+'  uniform sampler2D tex;'
//     .endl()+'#endif'
//     .endl()+'uniform float r;'
//     .endl()+'uniform float g;'
//     .endl()+'uniform float b;'
//     .endl()+'uniform float a;'
//     .endl()+'uniform float amount;'
//     .endl()+''
//     .endl()+'void main()'
//     .endl()+'{'
//     .endl()+'   vec4 col=vec4(r,g,b,a);'

//     .endl()+'if(amount>0.0)'
//     .endl()+'{'
//     .endl()+'   vec4 base=texture2D(tex,texCoord);'
//     .endl()+'   col=vec4( _blend(base.rgb,col.rgb) ,1.0);'
//     .endl()+'   col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);'

//     .endl()+'}'




//     .endl()+'   gl_FragColor = col;'
//     .endl()+'}';

// shader.setSource(shader.getDefaultVertexShader(),srcFrag);
// var textureUniform=new CGL.Uniform(shader,'t','tex',0);
// r.set(1.0);
// g.set(1.0);
// b.set(1.0);
// a.set(1.0);

// var uniformR=new CGL.Uniform(shader,'f','r',r);
// var uniformG=new CGL.Uniform(shader,'f','g',g);
// var uniformB=new CGL.Uniform(shader,'f','b',b);
// var uniformA=new CGL.Uniform(shader,'f','a',a);

// var amountUniform=new CGL.Uniform(shader,'f','amount',amount);


// blendMode.onChange=function()
// {
//     CGL.TextureEffect.onChangeBlendSelect(shader,blendMode.get());
// };


// render.onTriggered=function()
// {
//     if(!cgl.currentTextureEffect)return;

//     cgl.setShader(shader);
//     cgl.currentTextureEffect.bind();

//     cgl.setTexture(0,cgl.currentTextureEffect.getCurrentSourceTexture().tex);
//

//     cgl.currentTextureEffect.finish();
//     cgl.setPreviousShader();

//     trigger.trigger();
// };


};

Ops.Deprecated.Gl.TextureEffects.Color.prototype = new CABLES.Op();
CABLES.OPS["b1059b01-539f-4356-b2cc-695cd0f22b0b"]={f:Ops.Deprecated.Gl.TextureEffects.Color,objName:"Ops.Deprecated.Gl.TextureEffects.Color"};




// **************************************************************
// 
// Ops.Color.ColorPalettes
// 
// **************************************************************

Ops.Color.ColorPalettes = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const index=op.inValueInt("Index",0);
const textureOut=op.outTexture("Texture");
const inLinear=op.inValueBool("Smooth")
const arrOut=op.outArray("Color Array");

var canvas = document.createElement('canvas');
canvas.id = "canvas_"+CABLES.generateUUID();
canvas.width=5;
canvas.height=8;
canvas.style.display = "none";

var body = document.getElementsByTagName("body")[0];
body.appendChild(canvas);
var ctx = canvas.getContext('2d');

index.onChange=
inLinear.onChange=buildTexture;

var arr=[];
arr.length=5*3;
var lastFilter=null;

function hexToR(h) {
    return parseInt((cutHex(h)).substring(0,2),16);
}
function hexToG(h) {
    return parseInt((cutHex(h)).substring(2,4),16);
}
function hexToB(h) {
    return parseInt((cutHex(h)).substring(4,6),16);
}
function cutHex(h) {
    return (h.charAt(0)=="#") ? h.substring(1,7):h;
}


function buildTexture()
{
    var ind=Math.round(index.get())*5;
    if(ind>=colors.length-5)ind=0;
    if(ind<0)ind=0;
    if(ind!=ind)ind=0;

    for(var i=0;i<5;i++)
    {
        var r = hexToR(colors[ind+i]);
        var g = hexToG(colors[ind+i]);
        var b = hexToB(colors[ind+i]);

        arr[i*3+0]=r/255;
        arr[i*3+1]=g/255;
        arr[i*3+2]=b/255;

        ctx.fillStyle = 'rgb('+r+','+g+','+b+')';
        ctx.fillRect(
            canvas.width/5*i,
            0,
            canvas.width/5,
            canvas.height
            );
    }

    var filter=CGL.Texture.FILTER_NEAREST;
    if(inLinear.get())filter=CGL.Texture.FILTER_LINEAR;

    if(lastFilter==filter && textureOut.get()) textureOut.get().initTexture(canvas,filter);
        else textureOut.set(new CGL.Texture.createFromImage( op.patch.cgl, canvas, { "filter":filter } ));

    arrOut.set(null);
    arrOut.set(arr);
    textureOut.get().unpackAlpha=false;
    lastFilter=filter;

}



op.onDelete=function()
{
    canvas.remove();
};





const colors=[
'#E6E2AF','#A7A37E','#EFECCA','#046380','002F2F',
'#468966','#FFF0A5','#FFB03B','#B64926','8E2800',
'#FCFFF5','#D1DBBD','#91AA9D','#3E606F','193441',
'#FF6138','#FFFF9D','#BEEB9F','#79BD8F','00A388',
'#105B63','#FFFAD5','#FFD34E','#DB9E36','BD4932',
'#225378','#1695A3','#ACF0F2','#F3FFE2','EB7F00',
'#2C3E50','#E74C3C','#ECF0F1','#3498DB','2980B9',
'#000000','#263248','#7E8AA2','#FFFFFF','FF9800',
'#004358','#1F8A70','#BEDB39','#FFE11A','FD7400',
'#DC3522','#D9CB9E','#374140','#2A2C2B','1E1E20',
'#7D8A2E','#C9D787','#FFFFFF','#FFC0A9','FF8598',
'#B9121B','#4C1B1B','#F6E497','#FCFAE1','BD8D46',
'#2E0927','#D90000','#FF2D00','#FF8C00','04756F',
'#595241','#B8AE9C','#FFFFFF','#ACCFCC','8A0917',
'#10222B','#95AB63','#BDD684','#E2F0D6','F6FFE0',
'#F6F792','#333745','#77C4D3','#DAEDE2','EA2E49',
'#703030','#2F343B','#7E827A','#E3CDA4','C77966',
'#2F2933','#01A2A6','#29D9C2','#BDF271','FFFFA6',
'#D8CAA8','#5C832F','#284907','#382513','363942',
'#FFF8E3','#CCCC9F','#33332D','#9FB4CC','DB4105',
'#85DB18','#CDE855','#F5F6D4','#A7C520','493F0B',
'#04BFBF','#CAFCD8','#F7E967','#A9CF54','588F27',
'#292929','#5B7876','#8F9E8B','#F2E6B6','412A22',
'#332532','#644D52','#F77A52','#FF974F','A49A87',
'#405952','#9C9B7A','#FFD393','#FF974F','F54F29',
'#2B3A42','#3F5765','#BDD4DE','#EFEFEF','FF530D',
'#962D3E','#343642','#979C9C','#F2EBC7','348899',
'#96CA2D','#B5E655','#EDF7F2','#4BB5C1','7FC6BC',
'#1C1D21','#31353D','#445878','#92CDCF','EEEFF7',
'#3E454C','#2185C5','#7ECEFD','#FFF6E5','FF7F66',
'#00585F','#009393','#FFFCC4','#F0EDBB','FF3800',
'#B4AF91','#787746','#40411E','#32331D','C03000',
'#63A69F','#F2E1AC','#F2836B','#F2594B','CD2C24',
'#88A825','#35203B','#911146','#CF4A30','ED8C2B',
'#F2385A','#F5A503','#E9F1DF','#4AD9D9','36B1BF',
'#CFC291','#FFF6C5','#A1E8D9','#FF712C','695D46',
'#FF5335','#B39C85','#306E73','#3B424D','1D181F',
'#000000','#333333','#FF358B','#01B0F0','AEEE00',
'#E8E595','#D0A825','#40627C','#26393D','FFFAE4',
'#E7E8D1','#D3CEAA','#FBF7E4','#424242','8E001C',
'#354242','#ACEBAE','#FFFF9D','#C9DE55','7D9100',
'#2F2933','#01A2A6','#29D9C2','#BDF271','FFFFA6',
'#DDDCC5','#958976','#611427','#1D2326','6A6A61',
'#6C6E58','#3E423A','#417378','#A4CFBE','F4F7D9',
'#E1E6FA','#C4D7ED','#ABC8E2','#375D81','183152',
'#6B0C22','#D9042B','#F4CB89','#588C8C','011C26',
'#304269','#91BED4','#D9E8F5','#FFFFFF','F26101',
'#96CEB4','#FFEEAD','#FF6F69','#FFCC5C','AAD8B0',
'#B0CC99','#677E52','#B7CA79','#F6E8B1','89725B',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF5A49',
'#16193B','#35478C','#4E7AC7','#7FB2F0','ADD5F7',
'#00261C','#044D29','#168039','#45BF55','96ED89',
'#36362C','#5D917D','#A8AD80','#E6D4A7','825534',
'#F9E4AD','#E6B098','#CC4452','#723147','31152B',
'#2C3E50','#FC4349','#D7DADB','#6DBCDB','FFFFFF',
'#002635','#013440','#AB1A25','#D97925','EFE7BE',
'#FF8000','#FFD933','#CCCC52','#8FB359','192B33',
'#272F32','#9DBDC6','#FFFFFF','#FF3D2E','DAEAEF',
'#B8ECD7','#083643','#B1E001','#CEF09D','476C5E',
'#002F32','#42826C','#A5C77F','#FFC861','C84663',
'#5C4B51','#8CBEB2','#F2EBBF','#F3B562','F06060',
'#5A1F00','#D1570D','#FDE792','#477725','A9CC66',
'#5E0042','#2C2233','#005869','#00856A','8DB500',
'#52656B','#FF3B77','#CDFF00','#FFFFFF','B8B89F',
'#801637','#047878','#FFB733','#F57336','C22121',
'#730046','#BFBB11','#FFC200','#E88801','C93C00',
'#24221F','#363F45','#4B5F6D','#5E7C88','FEB41C',
'#E64661','#FFA644','#998A2F','#2C594F','002D40',
'#C24704','#D9CC3C','#FFEB79','#A0E0A9','00ADA7',
'#484A47','#C1CE96','#ECEBF0','#687D77','353129',
'#588C7E','#F2E394','#F2AE72','#D96459','8C4646',
'#BAB293','#A39770','#EFE4BD','#A32500','2B2922',
'#6A7059','#FDEEA7','#9BCC93','#1A9481','003D5C',
'#174C4F','#207178','#FF9666','#FFE184','F5E9BE',
'#D5FBFF','#9FBCBF','#647678','#2F3738','59D8E6',
'#DB5800','#FF9000','#F0C600','#8EA106','59631E',
'#450003','#5C0002','#94090D','#D40D12','FF1D23',
'#211426','#413659','#656F8C','#9BBFAB','F2EFDF',
'#EA6045','#F8CA4D','#F5E5C0','#3F5666','2F3440',
'#F2F2F2','#C6E070','#91C46C','#287D7D','1C344D',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF5A49',
'#705B35','#C7B07B','#E8D9AC','#FFF6D9','570026',
'#F7F2B2','#ADCF4F','#84815B','#4A1A2C','8E3557',
'#1A1F2B','#30395C','#4A6491','#85A5CC','D0E4F2',
'#25064D','#36175E','#553285','#7B52AB','9768D1',
'#004056','#2C858D','#74CEB7','#C9FFD5','FFFFCB',
'#CFCA4C','#FCF5BF','#9FE5C2','#5EB299','745A33',
'#776045','#A8C545','#DFD3B6','#FFFFFF','0092B2',
'#CC3910','#F1F2C0','#CCC59E','#8FA68E','332F29',
'#FF6600','#C13B00','#5E6D70','#424E4F','1B1D1E',
'#690011','#BF0426','#CC2738','#F2D99C','E5B96F',
'#1B1D26','#425955','#778C7A','#F1F2D8','BFBD9F',
'#F6B1C3','#F0788C','#DE264C','#BC0D35','A20D1E',
'#597533','#332F28','#61B594','#E6DEA5','C44E18',
'#3FB8AF','#7FC7AF','#DAD8A7','#FF9E9D','FF3D7F',
'#0F2D40','#194759','#296B73','#3E8C84','D8F2F0',
'#42282F','#74A588','#D6CCAD','#DC9C76','D6655A',
'#002A4A','#17607D','#FFF1CE','#FF9311','D64700',
'#003056','#04518C','#00A1D9','#47D9BF','F2D03B',
'#13140F','#D4FF00','#E4FFE6','#68776C','00D6DD',
'#FCFAD0','#A1A194','#5B605F','#464646','A90641',
'#289976','#67CC8E','#B1FF91','#FFE877','FF5600',
'#302B1D','#3F522B','#737D26','#A99E46','D9CB84',
'#56626B','#6C9380','#C0CA55','#F07C6C','AD5472',
'#32450C','#717400','#DC8505','#EC5519','BE2805',
'#C7B773','#E3DB9A','#F5FCD0','#B1C2B3','778691',
'#E83A25','#FFE9A3','#98CC96','#004563','191B28',
'#3399CC','#67B8DE','#91C9E8','#B4DCED','E8F8FF',
'#1A212C','#1D7872','#71B095','#DEDBA7','D13F32',
'#7D2A35','#CC9258','#917A56','#B4BA6C','FEFFC2',
'#E7E9D1','#D3D4AA','#FCFAE6','#444444','901808',
'#FFFFFF','#AEAEAE','#E64C66','#2D3E50','1BBC9B',
'#E0FFB3','#61C791','#31797D','#2A2F36','F23C55',
'#EB5937','#1C1919','#403D3C','#456F74','D3CBBD',
'#E6DD00','#8CB302','#008C74','#004C66','332B40',
'#14A697','#F2C12E','#F29D35','#F27649','F25252',
'#261822','#40152A','#731630','#CC1E2C','FF5434',
'#261F27','#FEE169','#CDD452','#F9722E','C9313D',
'#5C4B51','#8CBEB2','#F2EBBF','#F3B562','F06060',
'#2F3837','#C5C7B6','#FFF8D3','#4C493E','222028',
'#E3CBAC','#9C9985','#C46D3B','#788880','324654',
'#3F0B1B','#7A1631','#CF423C','#FC7D49','FFD462',
'#14212B','#293845','#4F6373','#8F8164','D9D7AC',
'#98A89E','#BAC0AC','#FAFAC6','#FF4411','D40015',
'#FEFFFF','#3C3F36','#9FB03E','#EBE9DC','72918B',
'#CC6B32','#FFAB48','#FFE7AD','#A7C9AE','888A63',
'#262526','#404040','#8C8979','#F2F2F2','F60A20',
'#00305A','#004B8D','#0074D9','#4192D9','7ABAF2',
'#0C273D','#54D0ED','#FFFEF1','#70B85D','2C5E2E',
'#4C1B33','#EFE672','#98A942','#2D6960','141D14',
'#2F3540','#666A73','#F2EDE4','#D9D1C7','8C8681',
'#0D1F30','#3B6670','#8BADA3','#F0E3C0','DB6C0F',
'#FFBC67','#DA727E','#AC6C82','#685C79','455C7B',
'#092140','#024959','#F2C777','#F24738','BF2A2A',
'#133463','#365FB7','#799AE0','#F4EFDC','BA9B65',
'#C4D4CB','#55665E','#30282A','#542733','E84167',
'#CDDEC6','#4DAAAB','#1E4F6A','#2A423C','93A189',
'#EF5411','#FA5B0F','#FF6517','#FF6D1F','FF822E',
'#41434A','#6E9489','#DEDCC3','#F2F1E9','877963',
'#292929','#2BBFBD','#F2B33D','#F29B30','F22E2E',
'#F2385A','#F5A503','#E9F1DF','#56D9CD','3AA1BF',
'#D5F8B4','#A6E3A8','#8A9A85','#7E566B','422335',
'#3CBAC8','#93EDD4','#F3F5C4','#F9CB8F','F19181',
'#979926','#38CCB5','#EEFF8E','#FFD767','CC2A09',
'#404040','#024959','#037E8C','#F2EFDC','F24C27',
'#94B34D','#D3FF82','#363D52','#121D2B','111B1C',
'#282E33','#25373A','#164852','#495E67','FF3838',
'#313732','#8AA8B0','#DEDEDE','#FFFFFF','F26101',
'#FFFFFF','#E5E1D1','#52616D','#2C343B','C44741',
'#FFF6B8','#ABCCA7','#403529','#7A5E2F','A68236',
'#4F1025','#C5003E','#D9FF5B','#78AA00','15362D',
'#49404F','#596166','#D1FFCD','#A9BD8B','948A54',
'#FF2151','#FF7729','#FFAD29','#FFEBCA','1AB58A',
'#73603D','#BF8A49','#F2CA80','#5E5A59','0D0D0D',
'#3D4C53','#70B7BA','#F1433F','#E7E1D4','FFFFFF',
'#006D8D','#008A6E','#549E39','#8AB833','C0CF3A',
'#BDDFB3','#2BAA9C','#2F2E2E','#0F2625','465F3F',
'#F2F2F2','#BF0404','#8C0303','#590202','400101',
'#76A19A','#272123','#A68D60','#B0C5BB','D9593D',
'#0E3D59','#88A61B','#F29F05','#F25C05','D92525',
'#C1E1ED','#76C7C6','#273D3B','#131A19','E35C14',
'#2D112C','#530031','#820233','#CA293E','EF4339',
'#AF7575','#EFD8A1','#BCD693','#AFD7DB','3D9CA8',
'#D74B4B','#DCDDD8','#475F77','#354B5E','FFFFFF',
'#FFF6C9','#C8E8C7','#A4DEAB','#85CC9F','499E8D',
'#229396','#8BA88F','#C7C5A7','#F0DFD0','F23C3C',
'#57385C','#A75265','#EC7263','#FEBE7E','FFEDBC',
'#96526B','#D17869','#EBAD60','#F5CF66','8BAB8D',
'#0D1C33','#17373C','#2B6832','#4F9300','A1D700',
'#1B2B32','#37646F','#A3ABAF','#E1E7E8','B22E2F',
'#C5D9B2','#53A194','#572C2C','#3D2324','695A3B',
'#425957','#81AC8B','#F2E5A2','#F89883','D96666',
'#002E40','#2A5769','#FFFFFF','#FABD4A','FA9600',
'#FFFEFC','#E2E3DF','#515B5E','#2E3233','CAF200',
'#FFF0A3','#B8CC6E','#4B6000','#E4F8FF','004460',
'#3B596A','#427676','#3F9A82','#A1CD73','ECDB60',
'#F2E6CE','#8AB39F','#606362','#593325','1D1D1F',
'#212B40','#C2E078','#FFFFFF','#BADCDD','547B97',
'#0B3C4D','#0E5066','#136480','#127899','1A8BB3',
'#222130','#464D57','#D4E8D3','#FFFCFB','ED8917',
'#B33600','#FF8A00','#FFC887','#CC5400','B31E00',
'#012530','#28544B','#ACBD86','#FFD6A0','FF302C',
'#2E95A3','#50B8B4','#C6FFFA','#E2FFA8','D6E055',
'#112F41','#068587','#4FB99F','#F2B134','ED553B',
'#202B30','#4E7178','#4FA9B8','#74C0CF','F1F7E2',
'#302B2F','#696153','#FFA600','#9BB58F','FFD596',
'#458C6B','#F2D8A7','#D9A86C','#D94436','A62424',
'#22475E','#75B08A','#F0E797','#FF9D84','FF5460',
'#FFAA5C','#DA727E','#AC6C82','#685C79','455C7B',
'#686E75','#9BAAC1','#82787B','#E4F1DB','AAC19B',
'#F0C755','#E2AD3B','#BF5C00','#901811','5C110F',
'#FFFBDC','#BFBCA5','#7F7D6E','#3F3E37','E5E2C6',
'#BEBEBE','#F1E4D8','#594735','#94C7BA','D8F1E4',
'#1B1E26','#F2EFBD','#B6D051','#70A99A','2F6D7A',
'#F7E4A2','#A7BD5B','#DC574E','#8DC7B8','ED9355',
'#70E8CB','#FFE9C7','#FF5B5B','#545454','2D2D2F',
'#17111A','#321433','#660C47','#B33467','CCBB51',
'#2B2E2E','#595855','#A2ABA5','#CAE6E8','313F54',
'#023B47','#295E52','#F2E085','#FCAB55','EE7F38',
'#302C29','#D1D1BC','#A7C4BB','#6C8C84','466964',
'#212629','#067778','#49B8A8','#85EDB6','D9E5CD',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF4949',
'#2C3E50','#FC4349','#6DBCDB','#D7DADB','FFFFFF',
'#35262D','#FFFBFF','#E8ECED','#A4B7BB','76A0B0',
'#61E8D2','#FCEEB9','#302F25','#704623','BBE687',
'#E1E6B9','#C4D7A4','#ABC8A4','#375D3B','183128',
'#C98B2F','#803C27','#C56520','#E1B41B','807916',
'#A3D9B0','#93BF9E','#F2F0D5','#8C8474','40362E',
'#524656','#CF4747','#EA7A58','#E4DCCB','A6C4BC',
'#5C2849','#A73E5C','#EC4863','#FFDA66','1FCECB',
'#0EEAFF','#15A9FA','#1B76FF','#1C3FFD','2C1DFF',
'#010000','#393845','#9B96A3','#5C0009','940315',
'#468071','#FFE87A','#FFCA53','#FF893B','E62738',
'#404040','#024959','#037E8C','#F2EFDC','F24C27',
'#FF765E','#C2AE8B','#FCCF65','#FFE5C6','B7BDC4',
'#003647','#00717D','#F2D8A7','#A4A66A','515932',
'#FAFAC0','#C4BE90','#8C644C','#594D37','293033',
'#2B3A42','#3F5765','#BDD4DE','#EFEFEF','E74C3C',
'#3B3B3B','#A8877E','#FFA49D','#FF7474','FF476C',
'#0A3A4A','#196674','#33A6B2','#9AC836','D0E64B',
'#FFA340','#38001C','#571133','#017A74','00C2BA',
'#DCEBDD','#A0D5D6','#789AA1','#304345','AD9A27',
'#588C7E','#F2E394','#F2AE72','#D96459','8C4646',
'#F0E6B1','#B5D6AA','#99A37A','#70584B','3D3536',
'#2F400D','#8CBF26','#A8CA65','#E8E5B0','419184',
'#010712','#13171F','#1C1F26','#24262D','961227',
'#403F33','#6E755F','#AFC2AA','#FFDEA1','E64C10',
'#C74029','#FAE8CD','#128085','#385052','F0AD44',
'#CFF09E','#A8DBA8','#79BD9A','#3B8686','0B486B',
'#E0401C','#E6B051','#272F30','#F7EDB7','9E2B20',
'#FFE2C5','#FFEEDD','#FFDDAA','#FFC484','FFDD99',
'#FFFFE4','#F2E5BD','#B9BF8E','#A69F7C','8C6865',
'#5C8A2D','#AFD687','#FFFFFF','#00C3A9','008798',
'#4F3130','#FF1F3D','#5BE3E3','#FDFFF1','8B9698',
'#D23600','#D95100','#DE6D00','#EE8900','FCA600',
'#FFFFFA','#A1A194','#5B605F','#464646','FF6600',
'#F34A53','#FAE3B4','#AAC789','#437356','1E4147',
'#2A7A8C','#176273','#063540','#E6D9CF','403D3A',
'#21455B','#567D8C','#A59E8C','#8C8372','F2F2F2',
'#012340','#026873','#83A603','#BBBF45','F2F0CE',
'#FDFF98','#A7DB9E','#211426','#6B073B','DA8C25',
'#002F36','#142426','#D1B748','#EDDB43','FFFD84',
'#420000','#600000','#790000','#931111','BF1616',
'#3C989E','#5DB5A4','#F4CDA5','#F57A82','ED5276',
'#23A38F','#B7C11E','#EFF1C2','#F0563D','2E313D',
'#F5ECD9','#2BACB5','#B4CCB9','#E84D5B','3B3B3B',
'#A5EB3C','#60C21E','#159E31','#53DB50','C5FFCB',
'#263138','#406155','#7C9C71','#DBC297','FF5755',
'#0A111F','#263248','#7E8AA2','#E3E3E3','C73226',
'#003B59','#00996D','#A5D900','#F2E926','FF930E',
'#00A19A','#04BF9D','#F2E85C','#F53D54','404040',
'#324152','#47535E','#796466','#C1836A','DEA677',
'#036F73','#84CDC2','#FEF2D8','#F18C79','EF504F',
'#174040','#888C65','#D9CA9C','#D98162','A65858',
'#56797F','#87A0A4','#FCFBDC','#F2DDB6','A6937C',
'#A8BAA9','#FFF5CF','#DBCDAD','#B39C7D','806854',
'#60655F','#AB9675','#FFE0C9','#D4CCBA','CF8442',
'#BDDFB3','#009D57','#2C372E','#0F2925','465F3F',
'#3E3947','#735360','#D68684','#F1B0B0','EBD0C4',
'#0A7B83','#2AA876','#FFD265','#F19C65','CE4D45',
'#FFFFFF','#F4921E','#858585','#C5D2DB','3E6B85',
'#11151E','#212426','#727564','#B9AA81','690C07',
'#000000','#910000','#CBB370','#FFFBF1','21786C',
'#F78F00','#C43911','#75003C','#37154A','0F2459',
'#003354','#91BED4','#D9E8F5','#FFFFFF','F26101',
'#3DA8A4','#7ACCBE','#FFFFF7','#FF99A1','FF5879',
'#64C733','#F0F0F0','#3E879E','#57524D','36302B',
'#343844','#2AB69D','#E65848','#FDC536','FCF2D7',
'#E34517','#F5FF53','#B4E85E','#00BD72','0B4239',
'#A84B3A','#FF9F67','#233138','#FFF7F5','4C646B',
'#59535E','#FAEEFF','#F1BAF3','#5D4970','372049',
'#FF6F22','#D9984F','#FFE8A9','#3E4237','32948A',
'#5D7370','#7FA6A1','#B8D9B8','#D6EDBD','FFF5BC',
'#FFBE00','#FFDC00','#FFD10F','#FFDE20','E8CA00',
'#003840','#005A5B','#007369','#008C72','02A676',
'#E1E6FA','#C4D7ED','#ABC8E2','#375D81','183152',
'#BA2F1D','#FFF8A4','#F5E67F','#264A59','1E2C30',
'#222526','#FFBB6E','#F28D00','#D94F00','80203B',
'#EBD096','#D1B882','#5D8A66','#1A6566','21445B',
'#F00807','#5F6273','#A4ABBF','#CCC9D1','E2E1E9',
'#DFE0AF','#A4BAA2','#569492','#41505E','383245',
'#152737','#2B4E69','#799AA5','#FFFFF0','682321',
'#C44C51','#FFB6B8','#FFEFB6','#A2B5BF','5F8CA3',
'#5ADED4','#4DAAAB','#26596A','#163342','6C98A1',
'#FF5B2B','#B1221C','#34393E','#8CC6D7','FFDA8C',
'#3D4D4D','#99992E','#E6E666','#F2FFBF','800033',
'#242424','#437346','#97D95C','#D9FF77','E9EB9B',
'#FFEBB0','#FFB05A','#F84322','#C33A1A','9F3818',
'#4D2B2F','#E57152','#E8DE67','#FFEFC3','C0CCAB',
'#A82221','#DB5E31','#EDA23E','#F2CB67','BFB840',
'#3B3140','#BFB8A3','#F2E0C9','#F2B9AC','D97E7E',
'#43464D','#9197A6','#D3DCF2','#7690CF','48577D',
'#EFDFBB','#9EBEA6','#335D6A','#D64F2A','7A8A7F',
'#000001','#313634','#C7CECF','#5C0402','941515',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF5A49',
'#F5F4E1','#D6C9B5','#B4AA97','#D44917','82877A',
'#19162B','#1C425C','#6ABDC4','#F0E4C5','D6C28F',
'#00132B','#7F9DB0','#C5E2ED','#FFFFFF','F95900',
'#1F3642','#6D968D','#B6CCB8','#FFE2B3','56493F',
'#08A689','#82BF56','#C7D93D','#E9F2A0','F2F2F2',
'#DE3961','#A4E670','#FFFFDC','#B3EECC','00ADA7',
'#849972','#D9D094','#A6A23E','#4F2F1D','8F5145',
'#F41C54','#FF9F00','#FBD506','#A8BF12','00AAB5',
'#00585F','#009393','#F5F3DC','#454445','FF5828',
'#FF6138','#FFFF9D','#BEEB9F','#79BD8F','00A388',
'#140B04','#332312','#B59D75','#E3D2B4','FFF7EA',
'#ED3B3B','#171F26','#77B59C','#F2E7B1','635656',
'#46594B','#A6977C','#D9B384','#734F30','260B01',
'#CCB8A3','#FF8FB1','#FFF5EA','#4E382F','B29882',
'#B70000','#FFFFFF','#FFCA3D','#94C4F4','0092B3',
'#053B44','#06736C','#A53539','#B9543C','EAD075',
'#E8C1B9','#FFB3AB','#FFCAB8','#E8B69C','FFCEAB',
'#E7F2DF','#69043B','#59023B','#231E2D','161726',
'#E82B1E','#E5DEAF','#A0B688','#557A66','453625',
'#F1E6D4','#BA3D49','#791F33','#9F9694','E3E1DC',
'#CED59F','#F1EDC0','#B1BEA4','#647168','282828',
'#2C3E50','#E74C3C','#ECF0F1','#3498DB','646464',
'#DE7047','#FFDE8D','#FFFFFF','#CDDE47','528540',
'#8EAB99','#40232B','#D95829','#D97338','DEC085',
'#E9662C','#EBAF3C','#00AC65','#068894','2B2B2B',
'#46483C','#A0AA8F','#EBE3CB','#FFFFFF','F26101',
'#170F0E','#290418','#505217','#FFD372','FFF1AF',
'#263545','#C4273C','#D7DADB','#6DBCDB','FFFFFF',
'#DCFAC0','#B1E1AE','#85C79C','#56AE8B','00968B',
'#075807','#097609','#70AF1A','#B9D40B','E5EB0B',
'#521000','#712800','#744E1D','#879666','F1D98C',
'#261F26','#3F3B40','#6C7367','#BFBF8A','F2E086',
'#2C3E50','#FC4349','#D7DADB','#6DBCDB','FFFFFF',
'#506D7D','#94CCB9','#FFECA7','#FFB170','F07D65',
'#3F4036','#8DA681','#F2E1C2','#BF2806','8C1D04',
'#990700','#CC542E','#FF964F','#FFCB7C','787730',
'#195073','#7F8C1F','#EE913F','#F2E5BD','9FD7C7',
'#1B3E59','#F2F0F0','#FFAC00','#BF0404','730202',
'#EA6045','#F8CA4D','#F5E5C0','#3F5666','2F3440',
'#F95759','#FDA099','#FFFFFF','#D9F3CB','8AC2B0',
'#265573','#386D73','#81A68A','#9FBF8F','D4D9B0',
'#E1DA36','#FFEA1B','#6FE4DA','#1DB0BC','007BBC',
'#013859','#185E65','#F9CC7F','#F15C25','9E1617',
'#36CC7C','#D6FFBE','#94D794','#228765','77A668',
'#94201F','#D4421F','#478A80','#D9E061','F08835',
'#F16233','#00B5B5','#F0F0F0','#3E4651','5C6D7E',
'#2E806C','#76CC99','#E0FFED','#FF5F3A','D2413C',
'#00393B','#00766C','#44A18E','#E5EDB6','F6695B',
'#734854','#F2F2E9','#D9D7C5','#A69580','736766',
'#03497E','#0596D5','#9DEBFC','#8D7754','FEB228',
'#F0E14C','#FFBB20','#FA7B12','#E85305','59CC0D',
'#FE4365','#FC9D9A','#F9CDAD','#C8C8A9','83AF9B',
'#00557C','#186D94','#3488AD','#81C1DC','BBE5F3',
'#DEE8D7','#918773','#420A1A','#240001','4D493A',
'#FFFFFF','#CAC535','#97AF25','#158471','41342C',
'#041F3D','#0B2E41','#165751','#448C61','9AC16D',
'#FA8C01','#FF6405','#577700','#082400','A0A600',
'#78C0F9','#FFDDCE','#FFFFFF','#FFDBE6','FE86A4',
'#351330','#CC2A41','#E7CAA4','#759A8A','524549',
'#02151A','#043A47','#087891','#C8C8C8','B31D14',
'#F34A53','#FAE3B4','#AAC789','#437356','1E4147',
'#58838C','#DAD7C7','#BF996B','#BF5841','A61C1C',
'#556354','#E68F0D','#8C948A','#495450','42423F',
'#323640','#5B6470','#8C94A1','#BDC7D6','DFE2FF',
'#FF0000','#FF950B','#2FA88C','#DEEB00','4B2C04',
'#0F3D48','#174C5B','#366774','#ECECE7','E96151',
'#3DBB7E','#A3CD39','#FBAC1D','#F96C1E','EE4036',
'#23363B','#A44F3F','#F8983D','#8D9151','BBC946',
'#4B5657','#969481','#D2C9B0','#F4E3C1','B6B835',
'#E8980C','#B1F543','#F2FF00','#FF5E00','59BBAB',
'#849696','#FEFFFB','#232D33','#17384D','FF972C',
'#555555','#7BB38E','#F4F1D7','#F8AB65','F15C4C',
'#1D3C42','#67BFAD','#F2EC99','#F2C48D','F25050',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF4949',
'#B8E1F2','#249AA7','#ABD25E','#F8C830','F1594A',
'#FDEDD0','#BCF1ED','#FF634D','#FD795B','FFF0AA',
'#FFFFFF','#E5E1D1','#52616D','#2C343B','C44741',
'#FFFFF1','#D5FF9B','#8FB87F','#5A7B6C','374E5A',
'#010340','#0E1E8C','#0003C7','#1510F0','1441F7',
'#002A4A','#17607D','#FFF1CE','#FF9311','E33200',
'#871E31','#CCC097','#9E9D7B','#687061','262626',
'#F16663','#F48D6C','#F2E07B','#8ABE9B','4A6D8B',
'#001F11','#204709','#0C8558','#FFD96A','FF4533',
'#1D1626','#F2E0BD','#BFAA8F','#8C786C','594C4C',
'#685D47','#913420','#1E2729','#C1D9C5','FEEFB1',
'#1D7561','#FC8448','#FF4138','#A8282B','38141B',
'#BF0633','#FF484E','#FF9273','#D1D0B4','E5ECED',
'#8E9E63','#E6DBB0','#F5EED7','#C4BCA0','176573',
'#665446','#809994','#AECCB6','#DEF2C4','E6683F',
'#3D0D26','#660A3E','#891C56','#B0276F','C93482',
'#082136','#00294D','#004B8D','#0068C4','2998FF',
'#3C4631','#9A746F','#F8A2AB','#F1C6B3','EAE9C0',
'#FF534E','#FFD7AC','#BED194','#499989','176785',
'#006D80','#BDA44D','#3C2000','#84CECC','78A419',
'#352C2B','#3C555C','#9E9657','#FFEBCD','CD5510',
'#2C3E50','#FC4349','#6DBCDB','#D7DADB','FFFFFF',
'#523631','#D1BE91','#605E3A','#4D462F','592F39',
'#18293B','#5B5A56','#F2DEA0','#D0B580','FFFBFF',
'#C8DBB6','#ECEBB7','#CCC68A','#B8B165','827A5D ',
'#7DA88C','#EBE9A0','#BED24B','#859132','35323C',
'#E8574C','#F27B29','#E6A51B','#D9CC3C','399977',
'#324032','#B7C22C','#FFFFE1','#22A8B5','2A3F42',
'#B3A589','#FFB896','#FFF9B1','#9AB385','11929E',
'#272433','#343F4F','#3D6066','#77994D','B2D249',
'#250701','#6D4320','#B0925F','#E7DEC0','82ABB8',
'#023550','#028A9E','#04BFBF','#EFEFEF','FF530D',
'#594732','#40342A','#7A422E','#D4CA9A','EDE5AE',
'#013C4D','#BA5B22','#DB913C','#F0B650','FAD46B',
'#143840','#5C6B63','#A69E89','#E0C297','D96523',
'#3FB8AF','#7FC7AF','#DAD8A7','#FFB38B','FF3F34',
'#CA3995','#F58220','#FFDF05','#BED73D','61BC46',
'#FFE1D0','#FFBFB4','#FF837E','#FF4242','BF1616',
'#C4EEFF','#7BA32D','#094201','#A41717','C48726',
'#001325','#187072','#90BD90','#D7D8A2','F2E4C2',
'#1A4F63','#068587','#6FB07F','#FCB03C','FC5B3F',
'#97B350','#333230','#736D61','#BAAB90','FFE5BA',
'#403D33','#807966','#CCC2A3','#8C0000','590000',
'#5F8A42','#86AD59','#F6FAA1','#F28410','D66011',
'#BF355D','#ED8168','#FAB66A','#F2DC86','83BFA1',
'#E1F03E','#FFBA14','#DB3A0F','#A1003D','630024',
'#212226','#45433F','#687067','#BDBB99','F0EAC3',
'#FE4365','#FC9D9A','#F9CDAD','#C8C8A9','83AF9B',
'#293B47','#5F7A87','#FFFFFF','#CBFF48','00ADA9',
'#282A33','#697371','#FFE7A6','#F5BA52','FA8000',
'#0C304A','#2B79A1','#F3F4F1','#85A71E','BFD841',
'#008B83','#4DAE83','#A0AE79','#FFE499','FF665E',
'#5D7359','#E0D697','#D6AA5C','#8C5430','661C0E',
'#324452','#97BDBF','#F2DFBB','#F28705','BF3604',
'#EEEFB9','#6ACFAE','#369C93','#232928','B03831',
'#332F45','#015770','#2A8782','#9FD6AE','FFFED2',
'#2B2830','#5C504F','#ABAB8E','#D9D7A3','C7BE88',
'#DC941B','#EDC266','#B6952C','#E1D3A6','E9A119',
'#00305A','#00448D','#0074D9','#4192D9','7ABAF2',
'#344459','#485F73','#5DA6A6','#A9D9CB','F2EAD0',
'#060719','#4D1B2F','#9E332E','#EB6528','FC9D1C',
'#96CEB4','#FFEEAD','#FF6F69','#FFCC5C','AAD8B0',
'#05F2F2','#04BFBF','#EEF1D9','#A60201','7E100E',
'#E6F1F5','#636769','#AAB3B6','#6E7476','4B4E50',
'#DA0734','#F1A20D','#4AABB1','#FCF3E7','3F1833',
'#202D44','#FC4349','#6DBCDB','#D7DADB','FFFFFF',
'#CC3B37','#398899','#FFFCE8','#FF857F','CCC1A3',
'#5DBEA9','#EFEDDF','#EF7247','#4E3F35','D1CBBA',
'#FFC62D','#E49400','#DD5200','#EFE38A','91B166',
'#B67D14','#F2921F','#F0B23E','#A62409','441208',
'#C71B1B','#D6BA8A','#017467','#E08F23','0B0D0C',
'#474143','#A69E9D','#E7E2DA','#FFFFFF','E7E8E7',
'#435772','#2DA4A8','#FEAA3A','#FD6041','CF2257',
'#6DD19D','#99E89D','#D0E8A1','#FFF9C0','D40049',
'#FAF1D5','#DEC9AC','#CCA18B','#11282D','A5C4BB',
'#000000','#141414','#1C1919','#1A1716','24201F',
'#D5D8DD','#5CA2BE','#135487','#2A4353','989DA4',
'#73161E','#BF0F30','#BFB093','#037F8C','0A2140',
'#195962','#F56F6C','#FFFFFF','#252932','191C21',
'#F8EFB6','#FEBAC5','#6CD1EA','#FACFD7','C2EAE9',
'#91D6BC','#768C6A','#755F31','#B37215','FFBA4B',
'#F2E6BB','#DD4225','#202724','#63BD99','F8FDD8',
'#762B1B','#807227','#CCBF7A','#FFEF98','60B0A1',
'#707864','#C1D74E','#F5FF7C','#DFE6B4','A6B89C',
'#FFF3D2','#97B48F','#E87657','#FF9B6F','E8D495',
'#33262E','#733230','#CC5539','#E6D27F','86A677',
'#122430','#273E45','#FFFCE2','#EBD2B5','E63531',
'#30394F','#FF434C','#6ACEEB','#EDE8DF','FFFBED',
'#0A3A4A','#196A73','#32A6A6','#A1BF36','C8D94A',
'#FFF7CC','#CCC28F','#70995C','#33664D','142933',
'#43464D','#9197A6','#D3DCF2','#7690CF','48577D',
'#DFE0AF','#A4BAA2','#569492','#41505E','383245',
'#B52841','#FFC051','#FF8939','#E85F4D','590051',
'#473C35','#A36D5C','#9C968B','#D9CEAD','8A866A',
'#DB4C39','#2D3638','#109489','#44D487','D0DB86',
'#6F8787','#AEC2AE','#E6DFAE','#B0B57B','888F51',
'#C8385A','#FFCF48','#ECEABE','#1FCECB','1CA9C9',
'#42282E','#75A48B','#D9CFB0','#DC9B74','D6665A',
'#362F2D','#4C4C4C','#94B73E','#B5C0AF','FAFDF2',
'#98293A','#B14A58','#C86C6B','#DE9D76','EFC77F',
'#C1D301','#76AB01','#0E6A00','#083500','042200',
'#453F22','#7A6B26','#CCAD5C','#A1191F','4E1716',
'#541E32','#8E3557','#88A33E','#C2BD86','F7F2B2',
'#2B1B2E','#54344D','#FFFFD6','#B89E95','6E444F',
'#6EC1A5','#9FBEA6','#F5D3A3','#FF9F88','FB7878',
'#2F252C','#D3CCB2','#99AD93','#6E6751','5C3122',
'#BE333F','#F2E9CE','#C8C5B1','#939F88','307360',
'#F0F1F2','#232625','#647362','#B3D929','D2D9B8',
'#FA2B31','#FFBF1F','#FFF146','#ABE319','00C481',
'#09455C','#527E7C','#F5FFCC','#E0EB6E','C4D224',
'#F2DA91','#F2B950','#F29D35','#D96704','BF4904',
'#A2CFA5','#E0E7AB','#F5974E','#E96B56','D24344',
'#150033','#310D42','#5C2445','#AB6946','FFCE4C',
'#23A38F','#B7C11E','#EFF1C2','#F0563D','2E313D',
'#FF2468','#E0D4B1','#FFFFE3','#00A5A6','005B63',
'#65A683','#218777','#3F585F','#47384D','F53357',
'#000623','#28475C','#4A6C74','#8BA693','F0E3C0',
'#E65322','#D19552','#B8BF73','#B6DB83','FFF991',
'#112F41','#068587','#6FB07F','#FCB03C','FC5B3F',
'#C89B41','#A16B2B','#77312B','#1C2331','152C52',
'#C24366','#D9C099','#FFF8D8','#A8E0BA','00ADA7',
'#CC0000','#006600','#FFFFEC','#9C9178','6C644F',
'#3D0319','#720435','#C1140E','#FC5008','32241B',
'#CFC7A4','#5A9E94','#005275','#002344','A38650',
'#FFEBC3','#CC3A00','#FF3600','#FF851B','800C00',
'#EFC164','#F3835D','#F35955','#286275','00434C',
'#E9F29D','#B7C29D','#878E8F','#67617A','51456B',
'#445859','#03A696','#49C4BE','#F1F2E4','FF7746',
'#FA726C','#FFD794','#BAD174','#3BA686','5F6F8C',
'#4D2B1F','#635D61','#7992A2','#97BFD5','BFDCF5',
'#CC4D00','#E6CF73','#668059','#264D4D','00CCB3',
'#4385F5','#DC4437','#FCBE1F','#109D59','FFFFFF',
'#271F2E','#A4A680','#F2EBC9','#D9B166','A66B38',
'#0B2C3C','#FF6666','#DADFE1','#FFFFFF','444444',
'#CFF09E','#A8DBA8','#79BD9A','#3B8686','0B486B',
'#302B26','#A6B827','#EDE9DD','#98D3D4','594E7A',
'#4B0505','#720707','#BFB694','#004659','00292B',
'#B52C38','#EBD1B0','#536682','#D9964B','DE6846',
'#F2F1DF','#F2B705','#F2C84B','#BF820F','734002',
'#26140C','#3D2216','#784E3D','#AB8574','D6BCB1',
'#26221D','#8C2C0F','#E6E5B8','#BFB38D','402D1F',
'#1F8181','#F2BC79','#F28972','#BF1B39','730240',
'#002635','#013440','#AB1A25','#D97925','EFE7BE',
'#8EC447','#FFFFFF','#96D3D4','#636466','2D2D2E',
'#2D1E1E','#4B3C37','#96A576','#CDE196','FFFFBE',
'#F06060','#FA987D','#F7F2CB','#72CCA7','10A296',
'#1D8281','#44BF87','#FBD258','#F29A3F','DB634F',
'#DEDE91','#EF9950','#F34E52','#C91452','492449',
'#6D8EAD','#1F3447','#1A0B07','#362416','CFCDB4',
'#00CD73','#008148','#2D9668','#3ECD8E','004E2C',
'#3D8080','#628282','#858383','#A38282','C28080',
'#475159','#839795','#B2BDB7','#CCC9C0','F2F2F2',
'#0E6870','#C6B599','#C65453','#FFDDB4','EDAA7D',
'#CEF0B7','#A8DBA8','#79BD9A','#3B8686','0B486B',
'#292C44','#FF5349','#F0F0F1','#18CDCA','4F80E1',
'#272A2B','#383737','#473B39','#692B28','940500',
'#D6C274','#DB9E46','#25706B','#3D2423','AB362E',
'#FFA68F','#FF4867','#FFF9C8','#B5EBB9','18B29D',
'#A1A16A','#727D59','#366353','#133C40','03212E',
'#D45354','#A9DC3A','#2FCAD8','#818B85','CDCDC1',
'#F14B6A','#3D3C3E','#22BDAF','#BAD7D4','F4F4F4',
'#FFE2C5','#FFEEDD','#FFDDAA','#FFC484','FFDD99',
'#9FFF4A','#1ABF93','#087363','#004040','2F1933',
'#FFDB97','#B28F4E','#FFFDFB','#466CB2','97BBFF',
'#991C00','#E09A25','#FFFCDB','#008B83','262B30',
'#44281A','#00ACAE','#F5EFD5','#F37606','EE4717',
'#FF5952','#FCEEC9','#96D6D9','#4FAAC9','176075',
'#5C4B51','#8CBEB2','#F2EBBF','#A5C88F','EF847B',
'#105F73','#F7F3B2','#C6CC33','#F28322','CC5404',
'#137072','#56B292','#B7F5AB','#FBFFC0','BF223D',
'#E3F23E','#6C821C','#A6A53F','#E0E0AC','33302E',
'#00215E','#003CAA','#1967F7','#5E4000','AA7400',
'#273A3D','#54695C','#AD9970','#FFBF87','FF8F60',
'#FFAA00','#C2B93E','#808F5D','#576157','302F30',
'#BE1405','#F2DCAC','#AABEAA','#736E41','413C2D',
'#6B1229','#C76A61','#FAB99A','#F7D9B5','CCB1A7',
'#2D9993','#58B3A3','#83BFA3','#B0D9A8','FFFCB6',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF5A49',
'#F30B55','#010326','#012840','#54717F','F2E6CE',
'#2A3411','#73662C','#BC9847','#FFDFB2','6B0031',
'#637D74','#403D3A','#8C3B3B','#AB6937','D4A960',
'#010A26','#011640','#B6D6F2','#FFFFFF','E83338',
'#924847','#EB986C','#E4C678','#9C7885','372C2C',
'#022440','#3F95AA','#4EC6DE','#EAE2DF','F7572F',
'#2B1D2E','#323657','#076473','#54B087','D6F567',
'#052229','#004043','#BCC373','#E3FF55','D0D90C',
'#4C514A','#907A62','#879796','#755854','B09880',
'#1D2939','#1CAF9A','#FFFFFF','#EE4F4B','D1DC48',
'#004B67','#41CCB4','#FFEA95','#FF7C5D','C70151',
'#C0272D','#FCFBE7','#9FD3DA','#008C9A','05484F',
'#213130','#FF5E3D','#C9C83E','#FDFFF1','559398',
'#B1E4FC','#366D78','#39D5F1','#FFFFFF','D9FF03',
'#DECE6C','#FCF9B6','#BFE3B5','#5D826E','262E2B',
'#520A17','#668F91','#F5E6AC','#AB8E5B','52301C',
'#2D3032','#DD5F18','#FBA922','#F7F7F7','404333',
'#0C2538','#2B434F','#638270','#BCC98E','EDE059',
'#E85066','#F28E76','#E6CEB0','#5A8C81','382837',
'#BF2633','#A6242F','#D9CEAD','#C0B18F','011C26',
'#002A4A','#17607D','#FFF1CE','#FF9311','E33200',
'#0A8B91','#485956','#C4B98F','#FFF9BC','EEDF2E',
'#B89A7B','#9BBAAC','#F2D649','#D95D50','DBDBDB',
'#BD7938','#8D4421','#643001','#532700','3A1C00',
'#E1E6FA','#C4D7ED','#ABC8E2','#375D81','183152',
'#2E4259','#F7483B','#ECF0F1','#03C8FA','737373',
'#364656','#5D6B74','#94A4A5','#F2F5E9','FF8C31',
'#3E5916','#93A605','#F28705','#F25C05','E5EFFA',
'#248077','#74AD8D','#C82754','#F7BB21','F9E2B7',
'#20736A','#8BD9CA','#B1D95B','#93A651','403E34',
'#D74B4B','#DCDDD8','#475F77','#354B5E','FFFFFF',
'#252F33','#415C4F','#869C80','#93C2CC','CEEAEE',
'#012840','#79C7D9','#9BF2EA','#497358','9DBF8E',
'#EE7E94','#F8B4C4','#C7CAC9','#D8505C','41424',
'#282828','#505050','#FFFFFF','#2DCEDB','F20000',
'#004358','#1F8A70','#BEDB39','#FF5347','FD7400',
'#470C3B','#802F56','#C0576F','#E38679','FFBD83',
'#573328','#B05A3A','#FF8548','#29332E','0F1B1C',
'#461F2D','#E1FFBB','#BAD47F','#849C23','52533F',
'#333A40','#4C5E5E','#ADD0E5','#CDE4FF','729EBF',
'#DE5605','#F7A035','#B1DEB5','#EFECCA','65ABA6',
'#76D6D2','#F9E270','#EF6F56','#F4EED8','596B56',
'#403E3F','#F2F2F2','#D9D9D9','#9DAABB','8C8C8C',
'#059E9A','#F4F2ED','#F5A243','#DB3E3B','585857',
'#FFBF41','#EE8943','#C02221','#FFF4D3','249CA9',
'#024E76','#39A6B2','#FCE138','#F5B824','F08106',
'#FF0067','#FF3D6A','#E7FF04','#9CFF00','56FF00',
'#003540','#0D3F40','#487360','#8FA671','F2D795',
'#FF493C','#FFFFFF','#B3ECEF','#31C4F5','ADEB41',
'#244358','#4A8B87','#7CBCAE','#F0D4AF','C5252B',
'#EA5930','#F8AF1E','#F5E5C0','#097380','372560',
'#A1DBB2','#FEE5AD','#FACA66','#F7A541','F45D4C',
'#2C4A47','#6C9A7F','#BB523D','#C89D11','81810B',
'#F0F1F2','#232625','#647362','#FF5629','D2D9B8',
'#7C9B5F','#B8D197','#E3FFF3','#9BDEC7','568F84',
'#E54E45','#DBC390','#F2F2EF','#13A3A5','403833',
'#77A7FB','#E57368','#FBCB43','#34B67A','FFFFFF',
'#001A2E','#8F0000','#FFFFFF','#8A874B','41594F',
'#312F40','#49A69C','#EFEAC5','#E89063','BF5656',
'#047C8C','#018B8D','#F3BF81','#F49B78','F1706D',
'#00303E','#7096AD','#C1D1DE','#FFF9EF','EC4911',
'#2D6891','#70A0BF','#F5EEDC','#DC4C1A','F0986C',
'#040002','#3D1309','#E8B96A','#BC5D15','5C0F00',
'#8B929C','#5E6070','#514454','#3B313D','FF2479',
'#142D58','#447F6E','#E1B65B','#C8782A','9E3E17',
'#22104D','#2D1E5E','#483A85','#7067AB','A49CFA',
'#919C86','#9E373E','#2B2E36','#D1B993','C45A3B',
'#332F45','#015770','#2A8782','#9FD6AE','FFFED2',
'#37C78F','#FEE293','#FF4D38','#CC2249','380C2A',
'#47282C','#8C8468','#C9B37F','#DBDAB7','C4C49C',
'#14191A','#2D2B21','#A69055','#CCB287','FFB88C',
'#F5E3CD','#696158','#B6A898','#877D71','504A43',
'#005151','#009393','#F56200','#454445','969692',
'#D95F47','#FFF2C1','#80A894','#106153','072C36',
'#9E352C','#E6E8A9','#93C28C','#2E5A5C','2B2623',
'#03013A','#334A94','#6B9EDF','#83C3F2','99E6FF',
'#372A26','#4D4D4D','#6DA0A7','#9ED5A8','C7F5FF',
'#03658C','#022E40','#F2B705','#F28705','F25C05',
'#FF3B16','#E87826','#E8BA4A','#80A272','003045',
'#00748E','#E3DFBB','#F4BA4D','#E3753C','DA3B3A',
'#25401E','#56732C','#84A63C','#B8D943','EAF2AC',
'#449BB5','#043D5D','#EB5055','#68C39F','FFFCF5',
'#108F97','#FF8B6B','#FFE39F','#16866D','103636',
'#1A4F63','#068F86','#6FD57F','#FCB03C','FC5B3F',
'#381C19','#472E29','#948658','#F0E99A','362E29',
'#D7E8F7','#BBD0E3','#9CB7CF','#6A8BAB','375D81',
'#0F1C28','#136972','#67BFA7','#F3CF5B','F07444',
'#FFFFFF','#4EA9A0','#969514','#FE9C03','FCDE8E',
'#2F2D30','#656566','#65537A','#51386E','2A2333',
'#4C2916','#F05A28','#FBAF3F','#38B449','FFFFFF',
'#132537','#006C80','#EBCAB8','#FE8315','FA3113',
'#ECEEE1','#A8DACF','#F05B4F','#D8403A','221E1F',
'#00305A','#004B8C','#0074D9','#4192D9','7ABAF2',
'#72CF3F','#85FF00','#23E000','#2FB81B','00FF1C',
'#45CEEF','#FFF5A5','#FFD4DA','#99D2E4','D8CAB4',
'#FF5B00','#A1716C','#728296','#439AAB','00CABD',
'#EB6C2D','#D9C8A2','#939C80','#496158','232F38',
'#D94214','#FFF2C1','#80A894','#52736B','093844',
'#4D1B2F','#9E332E','#EB6528','#FC9D1C','FFCA50',
'#FFEEB0','#9AE8A4','#C7C12D','#F76245','ED1C43',
'#FFFAED','#D4DBFF','#879AC9','#242942','FF8800',
'#022840','#013440','#517360','#9DA67C','F2DC99',
'#331A0F','#519994','#BA4B3C','#EEDDAA','789F63',
'#577867','#EDCE82','#D68644','#AB3229','662845',
'#435A66','#88A6AF','#F5F2EB','#D9CDB8','424342',
'#FF8840','#958D4F','#737B55','#595540','513E38',
'#9D805A','#EBC99D','#FFE6C5','#9DCEEA','4B809E',
'#272D40','#364659','#55736D','#9DBF8E','D0D991',
'#23A38F','#B7C11E','#EFF1C2','#F0563D','2E313D',
'#98C000','#3D4C53','#EA2E49','#FFE11A','0CDBE8',
'#A20E30','#E93C4F','#DCDCD4','#ADBCC3','2D4255',
'#1C2640','#263357','#384C80','#4E6AB3','5979CD',
'#D94214','#FFF2C1','#80A894','#52736B','093844',
'#3B596A','#427676','#3F9A82','#A1CD73','ECDB60',
'#1E1E1F','#424143','#67666A','#807F83','CBC9CF',
'#E04946','#3BA686','#B6D15D','#FFD495','FA847E',
'#FFEBB0','#FFB05A','#F84322','#C33A1A','9F3818',
'#FFA136','#FF814A','#E6635A','#785D6B','534557',
'#CDCF91','#EBEACC','#D6D5B8','#6D7D80','41545E',
'#011526','#011C40','#4E8DA6','#F2EA79','F2B33D',
'#353230','#3F4E51','#7B8F70','#99B2BE','F6F4EA',
'#063559','#0D8C7F','#8FBF4D','#F2D13E','D95929',
'#158000','#199900','#20BF00','#24D900','29FF00',
'#0B0D0E','#137074','#7EB7A3','#F1DDBB','EC6766',
'#02151A','#043A47','#087891','#C8C8C8','B31D14',
'#59361F','#5C992E','#A3CC52','#E6E673','FF5933',
'#FE4365','#FC9D9A','#F9CDAD','#C8C8A9','83AF9B',
'#4B1E18','#F9E5C2','#BBB082','#829993','4F5D4E',
'#032843','#1F595B','#508C6D','#71A670','A6DB89',
'#191724','#4C4547','#8C594E','#D18952','FDB157',
'#191919','#182828','#60702D','#AAB232','E6FA87',
'#212A3F','#434F5B','#F2F2F2','#8AB839','2E2E2E',
'#004158','#026675','#038B8B','#F1EEC9','F09979',
'#023059','#3F7EA6','#F2F2F2','#D99E32','BF5E0A',
'#F21E52','#FFFFFF','#3D3B42','#0C6F73','63CFD4',
'#452743','#E7635E','#F8E9A8','#89E0AD','00928C',
'#FAAD63','#D1714D','#785E48','#39403B','3D1C24',
'#4C0016','#FFF7EB','#DCCEA7','#A17345','104F53',
'#BF2431','#F24150','#2A4557','#3B848C','EFF2E4',
'#3B3013','#8F6031','#E88833','#9C0C0A','FDF3C1',
'#1E2422','#88BEB1','#FF006D','#DAFFFF','718A94',
'#F1F4F7','#AF9F7B','#775E43','#40413C','251C17',
'#00182E','#0C6BA1','#D4D6D4','#FFFDEB','FF7500',
'#FFAB4A','#CCBAAB','#1E2129','#3D5E6E','47A3A3',
'#66B3A7','#C0D4B6','#EEF0BD','#F0563D','2C2F3B',
'#332525','#907465','#EDC5B5','#878C6D','63674A',
'#F04C16','#DBDBD0','#EDBD1F','#4CB09C','313B4A',
'#2B211D','#611C26','#C5003E','#8EB7A8','F1E4B7',
'#1A1F2B','#30395C','#4A6491','#85A5CC','D0E4F2',
'#03497E','#0596D5','#9DEBFC','#999999','FE4B28',
'#2F4159','#465E73','#88A649','#F2ECE4','D98841',
'#323A46','#22282F','#EB4A33','#FFFFFF','E9F0F5',
'#2C3E50','#FC4349','#6DBCDB','#D7DADB','FFFFFF',
'#F29727','#E05723','#B0382F','#982E4B','713045',
'#4D584A','#465943','#428552','#3E754E','4C694B',
'#47191C','#59574B','#829690','#B5B09A','E1E3CB',
'#1D5123','#B1C661','#FFDA68','#FE9257','F64448',
'#59323C','#260126','#F2EEB3','#BFAF80','8C6954',
'#4E0805','#9E0522','#FFF4D4','#B8C591','447622',
'#424862','#FB9A63','#BFC4D5','#F6FBF4','FEBC98',
'#FF2468','#E0D4B1','#FFFFE3','#00A5A6','005B63',
'#1C2F40','#4C6173','#8094A6','#D9D1BA','F2E9D8',
'#DFD7B7','#EB7707','#5C5445','#3B2323','9CBFC7',
'#262E3B','#9C8878','#CFCAAA','#FBF8FF','992435',
'#FFBC67','#DA727E','#AC6C82','#685C79','455C7B',
'#404A69','#516C8A','#8AC0DE','#FFFFFF','FFAC00',
'#485B61','#4B8C74','#74C476','#A4E66D','CFFC83',
'#A31180','#C42795','#DE52B4','#EA88CE','FFBFE5',
'#E64D2E','#FFF5F1','#7893AD','#576B9C','2D2A52',
'#BF0436','#8C0327','#590219','#F2CBA1','8C674C',
'#CF5B6F','#FFF8C8','#CAD9B1','#8FB3A0','648991',
'#341D44','#744D90','#BB8CDD','#3E4417','88904D',
'#00293E','#003D4E','#006269','#00918F','00BAB5',
'#43212E','#D9666F','#F2D57E','#A9A688','516057',
'#2A3B30','#ABFFD1','#EBFFF5','#9DFEFF','273B40',
'#A63343','#E65159','#F5E9DB','#F4F7CF','BAD984',
'#1BA68C','#54BFAC','#F2EDA7','#F2E530','D94625',
'#1A2A40','#3F7369','#F2DEA0','#CE5251','EA895E',
'#1E9382','#70A758','#EFF1C2','#F0563D','2E313D',
'#A991E8','#FFB4BB','#ACF7FF','#A2E891','FFEDAE',
'#225B66','#17A3A5','#8DBF67','#FCCB5F','FC6E59',
'#282624','#BFB7AA','#403D39','#807A71','ABA398',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF4949',
'#440008','#605521','#988432','#D9A54E','9E3711',
'#649670','#36291E','#69AD6C','#92E67C','C5FF84',
'#42342C','#738076','#B2B39B','#DFE5E1','294359',
'#1A3838','#3F7A51','#82A352','#D1C062','FFBE59',
'#7D8C22','#B3BF67','#F2E49B','#D9DFF4','6791BF',
'#8A7D6D','#2D2D38','#E86E48','#FFFFE8','9CC9C9',
'#CFC949','#FFF5BF','#A9E6C4','#6AB39F','665841',
'#A1172D','#FDFFBA','#A7DB9E','#275C57','1F1B19',
'#FF6C0D','#F29E00','#E6C10F','#44996F','216273',
'#2C3E50','#FA4248','#D7DADB','#6DBCDB','FFFFFF',
'#627369','#99B397','#E2F2C6','#91CCAD','376266',
'#04496E','#66CAFF','#A3FC7E','#70D44A','2C6B0F',
'#1BA68C','#97BF3F','#F2ECD8','#F2B035','F2522E',
'#A2D9B1','#7CBF9E','#F2F1B9','#8C8575','193741',
'#024959','#037E8C','#F2EFDC','#E74C30','363636',
'#212625','#9CA6A2','#D0D9D6','#BF0404','C2C6AF',
'#00FFFF','#00FF00','#FFFF00','#FF5100','FF007C',
'#212629','#CDCF19','#FFF77D','#96C4AB','CF2A56',
'#CFF9FF','#BFC7BB','#787051','#332730','57324F',
'#98CACB','#FDEFBE','#F0542B','#736E5B','ABA68E',
'#F2F1EB','#BFB9A4','#262222','#802A30','8C0303',
'#65356B','#AB434F','#C76347','#FFA24C','519183',
'#78BF82','#A4D17C','#CFD96C','#EBD464','FFD970',
'#806265','#FFA256','#F7DD77','#E0D054','ABA73C',
'#8F323C','#123943','#80BDDB','#4189AB','C98127',
'#683820','#8C9A89','#E7D6A2','#BEAA65','9A8234',
'#021B21','#032C36','#065F73','#E8DFD6','FF2A1D',
'#2D6C73','#3FA693','#B4D9CB','#9ABF49','C6D93B',
'#141F26','#2B4040','#405950','#A69E86','F2D9BB',
'#4A8279','#003330','#610400','#003B06','02730F',
'#69B5E1','#D4E4F5','#EAF2F8','#BEDBED','000000',
'#893660','#EF7261','#68D693','#A0D7E2','299CA8',
'#073A59','#2D9AA6','#F2E2DC','#F23322','A61B1B',
'#2A3A48','#3E6372','#B2D4DC','#FAFAFF','FF6900',
'#F3BD8D','#F1A280','#BE6D6B','#704A5B','3E263C',
'#1C2742','#3C91C7','#5A9ABE','#95C5DE','E0EEFB',
'#426261','#465A59','#577573','#739A97','9AC1C0',
'#002A4A','#17607D','#FFF1CE','#FF9311','D64700',
'#589373','#BFBD99','#F2D6B3','#C2512F','241E1E',
'#1F518B','#1488C8','#F7E041','#E2413E','B5292A',
'#549494','#E85649','#232C2E','#E6E8D2','706558',
'#392133','#FFECBE','#D9D098','#C4AB6D','AB7D3A',
'#F0F0F0','#1C1C1C','#A2FDF5','#1CCDC7','27EDDF',
'#011526','#025959','#027353','#03A678','03A696',
'#004358','#1F8A70','#BEDB39','#FFE11A','FD7400',
'#37465D','#F2F2F2','#9DC02E','#779324','051A37',
'#580022','#AA2C30','#FFBE8D','#487B80','011D24',
'#F9F9F9','#03A678','#E9EDEB','#F44647','00707F',
'#800000','#BF0000','#E2D6C2','#F6EDD8','FFFFFF',
'#F7F6AF','#1B2124','#D62822','#97D6A6','468263',
'#432852','#992255','#FF3D4C','#28656E','00968F',
'#444344','#52BBB2','#2B344D','#EE5555','F8F7EE',
'#45334A','#796B7D','#CCC4B0','#FFF1B5','FFA3A3',
'#5A4B53','#9C3C58','#DE2B5B','#D86A41','D2A825',
'#14151C','#0C242B','#297059','#84D66E','D1FB7A',
'#272D40','#364659','#55736D','#9DBF8E','D0D991',
'#23A38F','#B7C11E','#EFF1C2','#F0563D','2E313D',
'#2E064D','#80176B','#B356A1','#59580B','FFFF00',
'#CC3333','#FF9D33','#F7F7F0','#3EBBA7','00747A',
'#5C4B51','#8CBEB2','#F2EBBF','#F3B562','BD6060',
'#0D3E58','#1C848C','#19C0C2','#F3EDD6','DA6260',
'#022629','#2A5945','#FAFFED','#E6DCC0','B3371C',
'#F4FAC7','#7BAD8D','#FFB159','#F77F45','C2454E',
'#A2C1C6','#86B1B7','#AECBAD','#CFDCB0','D6E1D1',
'#B0DAFF','#325B80','#64B7FF','#586D80','5092CC',
'#0F808C','#6C8C26','#F2A71B','#F26A1B','D91818',
'#FFBC6C','#FE9F6C','#BD716E','#74495F','3B2C4D',
'#FF4D41','#F2931F','#E6CA21','#91B321','1E8C65',
'#302821','#453629','#5C4837','#8A735F','BDA895',
'#415457','#5F7B7F','#9ACCAF','#E6EBC4','F9F7C8',
'#474143','#A69E9D','#E7E2DA','#FFFFFF','E7E8E7',
'#805939','#BD9962','#E6CD7D','#578072','2D4B4D',
'#03588C','#1763A6','#419CA6','#54BF83','8DBF41',
'#00CCFF','#A1FCFF','#040438','#004878','C9FAFF',
'#534C64','#B7DECF','#F0F3D7','#7E858C','D96557',
'#7F7364','#CBB08E','#CBC1B7','#789DCB','646F7F',
'#5C2849','#A73E5C','#EC7263','#FE9551','FFD285',
'#FF0012','#FF7D00','#FFD900','#5BE300','0084B0',
'#F24C32','#F29471','#FCDFA6','#36B898','3D7585',
'#083157','#0A6C87','#459C97','#92CCA5','C9F0B1',
'#DC941B','#EDC266','#B6952C','#E1D3A6','E9A119',
'#323836','#BAD1B5','#DBE8CF','#F0F7E8','FFFEF5',
'#081724','#589494','#8EBBB4','#D0DCD0','F5EED2',
'#50781C','#9CAD1C','#EAF7E6','#40A5DE','0B5191',
'#537F79','#78A68F','#CBD49C','#FED457','CB252A',
'#F23C13','#CBAB78','#FFFFFF','#898373','1F1C17',
'#450003','#5C0002','#94090D','#D40D12','FFED75',
'#0770A2','#82D9F7','#FEFEFE','#AEC844','F36622',
'#30394F','#FF434C','#6ACEEB','#EDE8DF','0E6569',
'#FF6B6B','#556270','#C7F464','#4ECDC4','EDC8BB',
'#D9B500','#FFED9C','#BFCC85','#748F74','454545',
'#452E32','#A34B1B','#B5A187','#EDDF9A','A7CC31',
'#2C2B33','#596664','#909980','#CCC08D','FF8A00',
'#C21F1F','#FFFFFC','#E34446','#FFFFDB','E36D6F',
'#282828','#00AAB5','#C1C923','#F41C54','F5F0F0',
'#3A3F40','#202627','#151B1E','#EFF4FF','41444D',
'#DEBB73','#4D0017','#010000','#4D0F30','9A002F',
'#EB9328','#FFA754','#FFD699','#FFF5DC','4FA6B3',
'#025E73','#037F8C','#D9D59A','#D9BD6A','590202',
'#636266','#E0CEA4','#E8A579','#7D6855','42403E',
'#FF0000','#FF4000','#FF7F00','#FFBF00','FFFF00',
'#FFFFFF','#74ADA6','#1E5E6F','#241B1F','68A81E',
'#5A0532','#FF6745','#FFC861','#9DAE64','27404A',
'#ACCBBC','#467847','#E8E4C1','#A60303','730202',
'#5C4B51','#8CBEB2','#F2EBBF','#F3B562','F06060',
'#0D2557','#93A8C9','#FFFFFF','#F5DED5','558D96',
'#F53C4A','#565157','#10CFC8','#F2EEE7','F5D662',
'#FFD97B','#E65029','#A60027','#660033','191C26',
'#595408','#A6800D','#A66D03','#A63F03','730C02',
'#2E031F','#590424','#8C072B','#BF0A2B','DEEFC5',
'#E0C882','#A6874E','#BFA169','#D9B779','F2D399',
'#D88681','#A67673','#746566','#535A5D','324F54',
'#FC297D','#FB607A','#FDA286','#FDC188','FEE78A',
'#FFECA1','#B3B27F','#4C5E52','#2F3436','FFBE2C',
'#D93312','#B3AB82','#45735F','#394D47','2C3233',
'#324143','#6595A3','#C8E3E8','#FCFFED','B6C28B',
'#477984','#FEF5EB','#C03C44','#EEAA4D','313E4A',
'#334D5C','#45B29D','#EFC94C','#E27A3F','DF4949',
'#630B11','#33322F','#2A2927','#1E1D1C','000000',
'#D94214','#FFF2C1','#80A894','#52736B','093844',
'#051E21','#00302D','#856434','#F28C28','FFAD4E',
'#D7DADD','#DDDEE3','#E1E1E9','#EDEFF4','F2F3F8',
'#BF495E','#41A693','#F2EC9B','#D9CF48','D9583B',
'#067072','#14A589','#DECFA6','#BAAE8C','F94B06',
'#423A38','#47B8C8','#E7EEE2','#BDB9B1','D7503E',
'#730324','#DFE3E6','#B4C4D4','#8BA2BD','456382',
'#537374','#F9BD7F','#EBD7A5','#ADC9A5','5C9E99',
'#88B59E','#B6DEC8','#39464D','#C04229','ABD1AB',
'#11A7FC','#95D127','#F2E415','#FF8638','EE3551',
'#212640','#5D718C','#4B95A6','#60BFBF','EFF2D8',
'#D8A64D','#9B5422','#351411','#5B0D0D','991C11',
'#53324F','#668D6E','#F2E0A0','#F19B7A','F0756E',
'#DFE0AF','#A4BAA2','#569492','#41505E','383245',
'#7BBADE','#93DE7F','#FFED5D','#F29E4A','FF7050',
'#133800','#1B4F1B','#398133','#5C9548','93E036',
'#D9D7AD','#91A685','#FF6A00','#37485C','1C232E',
'#008767','#FFB27A','#FF6145','#AB2141','5E1638',
'#727B7F','#CCEAEA','#7A7556','#2E2125','44CACC',
'#FFFFED','#FF2C38','#FF9A3A','#FFF040','67D9FF',
'#007148','#60A859','#9BDA6A','#C7F774','F9FFEF',
'#092740','#45698B','#90B0CC','#F1FAFF','8FD36F',
'#E2FFA0','#7D8076','#FAFFED','#C2CCBE','8F7D70',
'#00736A','#00BC9F','#F1EEC7','#FEA301','F2561A',
'#26282E','#AD5138','#F7F7F7','#DDDAE0','8594AE',
'#1A191F','#35352F','#484042','#4E5252','E64D38',
'#49454A','#E69B02','#FAF4C6','#B1D631','324052',
'#5F1A2B','#1D2834','#6F8B78','#E4D49E','C96466',
'#012D3D','#38AD9E','#FFEB9E','#FF6867','D0DBED',
'#0D1F36','#104954','#1E9C89','#38CC85','60EB7B',
'#8C4E03','#9FA66A','#F2EC94','#F23005','8B0F03',
'#000001','#20201F','#E2E2E4','#590402','B80000',
'#344059','#465973','#F2D272','#A69460','595139',
'#33454C','#608F85','#B6E5CB','#8BAF95','54584E',
'#FBFEF6','#B7BFA4','#687F70','#1A3841','BF3847',
'#D7E836','#86FFC7','#FFB048','#E8366C','593BFF',
'#34A9FF','#5982DB','#665EB8','#684682','632E62',
'#004056','#2C858D','#74CEB7','#C9FFD5','FFFFCB',
'#BFB978','#84945C','#516967','#4D3130','281B24',
'#103B73','#20638C','#3786A6','#4EABBF','EBEFF2',
'#9FB1BF','#1D2D63','#1C5357','#1F6E56','196331',
'#FFEBBA','#C3BD91','#88947B','#4C3F3F','2A2727',
'#347373','#4EA6A6','#91D9D9','#FFFFFD','F2E205',
'#828948','#EFDFC2','#006971','#DC533E','840000',
'#000137','#29003F','#79003D','#D04D14','F89801',
'#370005','#4B0005','#5F0005','#730005','870005',
'#C3AE8D','#F25260','#2D5F73','#6BADC9','8FCED6',
'#9E1B36','#F7EDBA','#E69B3D','#EB3355','3D241D',
'#1D8281','#44BF87','#FBD258','#F29A3F','DB634F',
'#035C75','#1B808C','#31A6A8','#F3F1BC','F3AD14',
'#FF7500','#665130','#EBB643','#CEDAA8','668E84',
'#384D3A','#3E6653','#728053','#A68357','D97C71',
'#012326','#17455C','#E1CAAB','#FE8333','FA4913',
'#1A2944','#2DA7C7','#56ACBA','#98C4C9','CBD5D2',
'#BF3542','#CDC5BA','#EBE3D6','#3C3C3C','2E2E2E',
'#231921','#695F74','#BEB4CB','#EBEBF0','D2DCEB',
'#34373F','#686C75','#F3E9D0','#BEB7A7','8E867C',
'#661510','#D9351A','#F2C76F','#BF9727','204D3F',
'#3CFFEE','#24AABC','#356781','#2C3D51','1C1F24',
'#DA3537','#FFFCC4','#00585F','#6A6A61','2A2C2B',
'#AE3135','#D1AF87','#8C826B','#3D3C33','F2F0CE',
'#FF0894','#FF5E9F','#FF91A7','#FFB5CA','F5F0BA',
'#99878D','#323232','#646464','#7E4A5C','372129',
'#3FB8AF','#7FC7AF','#DAD8A7','#FFB38B','FF3F34',
'#402B3C','#6AA6A6','#D9CCA7','#F2B263','F26835',
'#6AA690','#F2BC1B','#F2DC99','#F29057','BF1F1F',
'#F4FAC7','#7BAD8D','#FFB158','#F77F45','C2454E',
'#E5533C','#F5E346','#93D06D','#50AC6A','227864',
'#39588A','#A9BDD7','#FFFFFF','#FFEADD','FFD0BB',
'#B0B595','#615F4F','#828567','#91A380','EAFFCD',
'#00427F','#0066BD','#66B5CC','#F0E4C5','D6C28F',
'#FF6313','#F9E4B3','#C29689','#74474B','45232E',
'#00585F','#009393','#FFFCC4','#C7C49B','EB0A00',
'#091840','#44A2FF','#F7F7EA','#B3CC63','4C6620',
'#5CBBE3','#FCF1BC','#5C8182','#383A47','B4F257',
'#9E9E9E','#E5E1D1','#E0393D','#253746','425563',
'#4D9453','#FFFFB1','#ADDE4E','#FF9D27','A62A16',
'#B70046','#FF850B','#FFEBC5','#109679','675A4C',
'#363636','#0599B0','#A4BD0A','#FFA615','FF2E00',
'#7D8077','#BBBFB2','#FAFFED','#E82A33','E3DEBC',
'#FD9F44','#FC5C65','#007269','#03A679','FAF0B9',
'#134B57','#81A489','#F1D8B5','#F2A054','C04D31',
'#946E49','#394042','#EDDBAC','#872A0C','BA8E3A',
'#404040','#024959','#037E8C','#FFFFFF','F24C27',
'#2A3342','#163C6E','#4E5F61','#E6A015','EDE7BE',
'#445060','#829AB5','#849E91','#C14543','D6D5D1',
'#8A9126','#B7BF5E','#FFE9C4','#F5B776','F58E45',
'#9B2D1E','#3C3A28','#78A080','#9BCD9E','FFFFAE',
'#FF6138','#FFFF9D','#BEEB9F','#79BD8F','00A388',
'#990000','#FF6600','#FF9900','#996633','CC9966',
'#DCE6DA','#B8CCBB','#98B3A5','#7A9994','62858C',
'#0B1C29','#3B7C8F','#73A5A3','#98C1B7','F0EBD2',
'#F6CB51','#E25942','#13A89E','#3F4953','F2E7DA',
'#282F36','#FFFEFC','#BDA21D','#BFBC5B','D2E098',
'#8C182D','#DE7140','#FCB95A','#FAE285','6A7349',
'#6B9100','#FFE433','#FF841F','#E03D19','A6001C',
'#FFEAA7','#D9D697','#9FC49F','#718C6A','543122',
'#CFF09E','#A8DBA8','#79BD9A','#3B8686','0B486B',
'#0C2233','#065471','#0A91AB','#FFC045','F2F2F2',
'#BEE8E0','#373C40','#2E2621','#73320B','FF5E00',
'#1B2C35','#A3BFC6','#FF005D','#222A30','293A42',
'#FF8400','#3B4044','#494948','#E6E1D8','F7F2E9',
'#6A482D','#518C86','#F6BF3D','#EF7C27','BF2424',
'#261C2B','#292B39','#226468','#608D80','829D8F',
'#B2AD9A','#110E00','#363226','#A9A695','ECE9D8',
'#1B1B26','#26394D','#286480','#13B3BF','A3FF57',
'#F2C2A7','#F5E5C5','#593D28','#422C21','93DEDB',
'#001028','#033140','#1E5A5B','#7BA78C','EBEDC6',
'#544E6E','#808CB0','#ABD1D9','#D9FFF7','DDF556',
'#323A45','#596677','#758194','#FFFFFF','E74C3C',
'#45291A','#AB926D','#DBD1BC','#4999C3','5FCBEC',
'#6B151D','#2E1615','#A8553A','#DB8F5A','F2C18E',
'#000623','#28475C','#4A6C74','#8BA693','F0E3B1',
'#60807B','#81B37A','#BCCC5F','#FFEE65','E64964',
'#FFFFFA','#A1A194','#5B605F','#464646','FF6600',
'#1E1B17','#577270','#9C9A79','#C7BDA1','580E0C',
'#452F27','#5E504A','#6B6865','#9BBAB2','B0FFED',
'#1B5257','#F7F6C3','#F28159','#CC5850','4F1C2E',
'#FAA51B','#BF511F','#2C445E','#2F6D82','5EE4EB',
'#BF3952','#59364A','#556D73','#D9D1A9','D95F5F',
'#024959','#037E8C','#F2EFDC','#E74C30','363636',
'#221A26','#544759','#A197A6','#F27405','D93D04',
'#C4A44A','#E6D399','#9AB8A9','#7C8A7F','4E4B44',
'#FFFEC8','#B1BF99','#5B604D','#39382B','26181E',
'#4E3C51','#21A68D','#3BBF9A','#F2E8B6','F25749',
'#102144','#1B325E','#254580','#3C63B0','5D8AEA',
'#2A3A48','#3E6372','#B2D4DC','#FAFAFF','FF4B00',
'#FFF1BF','#F20058','#FFAEAC','#000001','7D7A96',
'#FDFFC6','#F2F096','#FF0080','#DE0049','521218',
'#5B0E00','#FBB500','#FBD864','#807D1A','59233C',
'#1E1E1F','#424143','#67666A','#807F83','CBC9CF',
'#3C3658','#3EC8B7','#7CD0B4','#B9D8B1','F7E0AE',
'#FFFFFF','#99B75F','#D5DD98','#EBF4DB','D8D8D8',
'#248A8A','#C9FA58','#F9E555','#FAAC38','F2572A',
'#086B63','#77A490','#E2D8C1','#BFAE95','7C7159',
'#5C4B51','#8CBEB2','#F2EBBF','#A5C88F','EF847B',
'#17162F','#89346D','#C76058','#FFB248','E8C475',
'#6E8F4A','#65D9C5','#F2E7B6','#EDA430','AB3E2C',
'#30394F','#FF434C','#6ACEEB','#EDE8DF','0E6569',
'#8E1B13','#F9E4B3','#849689','#46464A','29232E',
'#686B30','#AB9A52','#E8BA67','#D68F4F','BA512E',
'#E54E45','#DBC390','#F2F2EF','#13A3A5','403833',
'#65BA99','#59A386','#F1DDBB','#D6C4A6','E74C3C',
'#A6FFBC','#4ACFAF','#00A995','#006161','003D4C',
'#33271E','#8B7653','#C8D9A0','#FDEE9D','233331',
'#048789','#503D2E','#D44D27','#E2A72E','EFEBC8',
'#E5FF1E','#A9D943','#75A660','#698070','494D4B',
'#2DEBA2','#91F57F','#EBAA69','#E70049','2B0027',
'#990000','#336699','#DDDDDD','#999999','333333',
'#F13A4B','#3D3C3E','#22BDAF','#F4F4F4','D7D7D7',
'#F53A59','#001D2D','#15A88C','#B7D9C8','F3F5F4',];



buildTexture();

};

Ops.Color.ColorPalettes.prototype = new CABLES.Op();
CABLES.OPS["31d33a1e-9a0a-49f7-8bc8-9e83ab71e23e"]={f:Ops.Color.ColorPalettes,objName:"Ops.Color.ColorPalettes"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.CellularNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.CellularNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={cellularnoise3d_frag:"UNI float z;\nUNI float x;\nUNI float y;\nUNI float scale;\nIN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\n\n{{CGL.BLENDMODES}}\n\nvoid FAST32_hash_3D( \tvec3 gridcell,\n                        out vec4 lowz_hash_0,\n                        out vec4 lowz_hash_1,\n                        out vec4 lowz_hash_2,\n                        out vec4 highz_hash_0,\n                        out vec4 highz_hash_1,\n                        out vec4 highz_hash_2\t)\t\t//\tgenerates 3 random numbers for each of the 8 cell corners\n{\n    //    gridcell is assumed to be an integer coordinate\n\n    //\tTODO: \tthese constants need tweaked to find the best possible noise.\n    //\t\t\tprobably requires some kind of brute force computational searching or something....\n    const vec2 OFFSET = vec2( 50.0, 161.0 );\n    const float DOMAIN = 69.0;\n    const vec3 SOMELARGEFLOATS = vec3( 635.298681, 682.357502, 668.926525 );\n    const vec3 ZINC = vec3( 48.500388, 65.294118, 63.934599 );\n\n    //\ttruncate the domain\n    gridcell.xyz = gridcell.xyz - floor(gridcell.xyz * ( 1.0 / DOMAIN )) * DOMAIN;\n    vec3 gridcell_inc1 = step( gridcell, vec3( DOMAIN - 1.5 ) ) * ( gridcell + 1.0 );\n\n    //\tcalculate the noise\n    vec4 P = vec4( gridcell.xy, gridcell_inc1.xy ) + OFFSET.xyxy;\n    P *= P;\n    P = P.xzxz * P.yyww;\n    vec3 lowz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell.zzz * ZINC.xyz ) );\n    vec3 highz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell_inc1.zzz * ZINC.xyz ) );\n    lowz_hash_0 = fract( P * lowz_mod.xxxx );\n    highz_hash_0 = fract( P * highz_mod.xxxx );\n    lowz_hash_1 = fract( P * lowz_mod.yyyy );\n    highz_hash_1 = fract( P * highz_mod.yyyy );\n    lowz_hash_2 = fract( P * lowz_mod.zzzz );\n    highz_hash_2 = fract( P * highz_mod.zzzz );\n}\n\n\n\n\nvec4 Cellular_weight_samples( vec4 samples )\n{\n    samples = samples * 2.0 - 1.0;\n    //return (1.0 - samples * samples) * sign(samples);\t// square\n    return (samples * samples * samples) - sign(samples);\t// cubic (even more variance)\n}\n\n\n//\n//\tCellular Noise 3D\n//\tBased off Stefan Gustavson's work at http://www.itn.liu.se/~stegu/GLSL-cellular\n//\thttp://briansharpe.files.wordpress.com/2011/12/cellularsample.jpg\n//\n//\tSpeed up by using 2x2x2 search window instead of 3x3x3\n//\tproduces range of 0.0->1.0\n//\nfloat Cellular3D(vec3 P)\n{\n    //\testablish our grid cell and unit position\n    vec3 Pi = floor(P);\n    vec3 Pf = P - Pi;\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1;\n    FAST32_hash_3D( Pi, hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1 );\n    //SGPP_hash_3D( Pi, hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1 );\n\n    //\tgenerate the 8 random points\n#if 1\n    //\trestrict the random point offset to eliminate artifacts\n    //\twe'll improve the variance of the noise by pushing the points to the extremes of the jitter window\n    const float JITTER_WINDOW = 0.166666666;\t// 0.166666666 will guarentee no artifacts. It is the intersection on x of graphs f(x)=( (0.5 + (0.5-x))^2 + 2*((0.5-x)^2) ) and f(x)=( 2 * (( 0.5 + x )^2) + x * x )\n    hash_x0 = Cellular_weight_samples( hash_x0 ) * JITTER_WINDOW + vec4(0.0, 1.0, 0.0, 1.0);\n    hash_y0 = Cellular_weight_samples( hash_y0 ) * JITTER_WINDOW + vec4(0.0, 0.0, 1.0, 1.0);\n    hash_x1 = Cellular_weight_samples( hash_x1 ) * JITTER_WINDOW + vec4(0.0, 1.0, 0.0, 1.0);\n    hash_y1 = Cellular_weight_samples( hash_y1 ) * JITTER_WINDOW + vec4(0.0, 0.0, 1.0, 1.0);\n    hash_z0 = Cellular_weight_samples( hash_z0 ) * JITTER_WINDOW + vec4(0.0, 0.0, 0.0, 0.0);\n    hash_z1 = Cellular_weight_samples( hash_z1 ) * JITTER_WINDOW + vec4(1.0, 1.0, 1.0, 1.0);\n#else\n    //\tnon-weighted jitter window.  jitter window of 0.4 will give results similar to Stefans original implementation\n    //\tnicer looking, faster, but has minor artifacts.  ( discontinuities in signal )\n    const float JITTER_WINDOW = 0.4;\n    hash_x0 = hash_x0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, 1.0-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_y0 = hash_y0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_x1 = hash_x1 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, 1.0-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_y1 = hash_y1 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_z0 = hash_z0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, -JITTER_WINDOW, -JITTER_WINDOW);\n    hash_z1 = hash_z1 * JITTER_WINDOW * 2.0 + vec4(1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n#endif\n\n    //\treturn the closest squared distance\n    vec4 dx1 = Pf.xxxx - hash_x0;\n    vec4 dy1 = Pf.yyyy - hash_y0;\n    vec4 dz1 = Pf.zzzz - hash_z0;\n    vec4 dx2 = Pf.xxxx - hash_x1;\n    vec4 dy2 = Pf.yyyy - hash_y1;\n    vec4 dz2 = Pf.zzzz - hash_z1;\n    vec4 d1 = dx1 * dx1 + dy1 * dy1 + dz1 * dz1;\n    vec4 d2 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2;\n    d1 = min(d1, d2);\n    d1.xy = min(d1.xy, d1.wz);\n    return min(d1.x, d1.y) * ( 9.0 / 12.0 );\t//\tscale return value from 0.0->1.333333 to 0.0->1.0  \t(2/3)^2 * 3  == (12/9) == 1.333333\n}\n\n\nvoid main()\n{\n\n\n    vec2 p=vec2(texCoord.x-0.5,texCoord.y-0.5);\n\n    #ifdef DO_TILEABLE\n        p=abs(texCoord-0.5);\n    #endif\n\n    p=p*scale;\n\n    p=vec2(p.x+0.5-x,p.y+0.5-y);\n\n    float v=Cellular3D(vec3(p.x,p.y,z));\n\n       //blend section\n    vec4 col=vec4(v,v,v,1.0);\n    //original texture\n    vec4 base=texture(tex,texCoord);\n\n\n    outColor=cgl_blend(base,col,amount);\n\n}\n",};
const
    render=op.inTrigger('render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    x=op.inValue("X",0),
    y=op.inValue("Y",0),
    z=op.inValue("Z",0),
    scale=op.inValue("Scale",3),
    trigger=op.outTrigger('trigger'),
    tile=op.inValueBool("Tileable",false);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);


shader.setSource(shader.getDefaultVertexShader(),attachments.cellularnoise3d_frag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    uniZ=new CGL.Uniform(shader,'f','z',z),
    uniX=new CGL.Uniform(shader,'f','x',x),
    uniY=new CGL.Uniform(shader,'f','y',y),
    uniScale=new CGL.Uniform(shader,'f','scale',scale);

tile.onChange=updateTileable;
function updateTileable()
{
    if(tile.get())shader.define("DO_TILEABLE");
        else shader.removeDefine("DO_TILEABLE");
}

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.CellularNoise.prototype = new CABLES.Op();
CABLES.OPS["62fa72eb-a607-4397-8b44-f8fd2a6cbe34"]={f:Ops.Gl.TextureEffects.Noise.CellularNoise,objName:"Ops.Gl.TextureEffects.Noise.CellularNoise"};




// **************************************************************
// 
// Ops.Deprecated.Gl.TextureEffects.VignetteOld
// 
// **************************************************************

Ops.Deprecated.Gl.TextureEffects.VignetteOld = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={vignette_frag:"IN vec2 texCoord;\nuniform sampler2D tex;\nuniform float lensRadius1;\nuniform float lensRadius2;\nuniform float ratio;\nuniform float amount;\n\nvoid main()\n{\n    vec4 col=vec4(1.0,0.0,0.0,1.0);\n    col=texture(tex,texCoord);\n    vec2 tcPos=vec2(texCoord.x,(texCoord.y-0.5)*ratio+0.5);\n    float dist = distance(tcPos, vec2(0.5,0.5))*amount;\n    col.rgb *= smoothstep(lensRadius1, lensRadius2, dist);\n    outColor= col;\n}",};
op.name='Vignette';

var render=op.inTrigger("render");
var trigger=op.outTrigger("trigger");

var amount=op.inValueSlider("Amount",1);
var lensRadius1=op.inValue("lensRadius1",0.8);
var lensRadius2=op.inValue("lensRadius2",0.4);
var ratio=op.inValue("Ratio",1);

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);


shader.setSource(shader.getDefaultVertexShader(),attachments.vignette_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniLensRadius1=new CGL.Uniform(shader,'f','lensRadius1',lensRadius1);
var uniLensRadius2=new CGL.Uniform(shader,'f','lensRadius2',lensRadius2);
var uniRatio=new CGL.Uniform(shader,'f','ratio',ratio);
var uniAmount=new CGL.Uniform(shader,'f','amount',amount);


render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Deprecated.Gl.TextureEffects.VignetteOld.prototype = new CABLES.Op();
CABLES.OPS["b1b03b84-e924-4308-a252-1d348ede07e6"]={f:Ops.Deprecated.Gl.TextureEffects.VignetteOld,objName:"Ops.Deprecated.Gl.TextureEffects.VignetteOld"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Hue
// 
// **************************************************************

Ops.Gl.TextureEffects.Hue = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={hue_frag:"\n#ifdef HAS_TEXTURES\n  IN vec2 texCoord;\n  UNI sampler2D tex;\n#endif\nUNI float hue;\n\nvec3 rgb2hsv(vec3 c)\n{\n    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n\n    float d = q.x - min(q.w, q.y);\n    float e = 1.0e-10;\n    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\n\nvec3 hsv2rgb(vec3 c)\n{\n    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\n    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n   #ifdef HAS_TEXTURES\n       col=texture(tex,texCoord);\n\n       vec3 hsv = rgb2hsv(col.rgb);\n       hsv.x=hsv.x+hue;\n       col.rgb = hsv2rgb(hsv);\n\n   #endif\n   outColor= col;\n}",};
const
    render=op.inTrigger('render'),
    hue=op.inValueSlider("hue",1),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.hue_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const uniformHue=new CGL.Uniform(shader,'f','hue',1.0);

hue.onChange=function(){ uniformHue.setValue(hue.get()); };

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Hue.prototype = new CABLES.Op();
CABLES.OPS["94ef0da0-c920-415c-81b0-fecbd437991d"]={f:Ops.Gl.TextureEffects.Hue,objName:"Ops.Gl.TextureEffects.Hue"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.RgbMultiply
// 
// **************************************************************

Ops.Gl.TextureEffects.RgbMultiply = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={rgbmul_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float r;\nUNI float g;\nUNI float b;\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n   col=texture(tex,texCoord);\n   col.r*=r;\n   col.g*=g;\n   col.b*=b;\n   outColor= col;\n}\n",};
const render=op.inTrigger("render");
const r=op.inValue('r',1);
const g=op.inValue('g',1);
const b=op.inValue('b',1);
const trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.rgbmul_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const uniformR=new CGL.Uniform(shader,'f','r',r);
const uniformG=new CGL.Uniform(shader,'f','g',g);
const uniformB=new CGL.Uniform(shader,'f','b',b);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.RgbMultiply.prototype = new CABLES.Op();
CABLES.OPS["00f30153-f656-4701-9b93-244b033b2eaa"]={f:Ops.Gl.TextureEffects.RgbMultiply,objName:"Ops.Gl.TextureEffects.RgbMultiply"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.SSAO2
// 
// **************************************************************

Ops.Gl.TextureEffects.SSAO2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={ssao_frag:"/*\nSSAO GLSL shader v1.2\nassembled by Martins Upitis (martinsh) (devlog-martinsh.blogspot.com)\noriginal technique is made by Arkano22 (www.gamedev.net/topic/550699-ssao-no-halo-artifacts/)\n\nchangelog:\n1.2 - added fog calculation to mask AO. Minor fixes.\n1.1 - added spiral sampling method from here:\n(http://www.cgafaq.info/wiki/Evenly_distributed_points_on_sphere)\n\n*/\n\nIN vec2 texCoord;\n\nUNI sampler2D texDepth;\nUNI sampler2D tex;\n// const float bgl_RenderedTextureWidth=800.0;\n// const float bgl_RenderedTextureHeight=600.0;\n\n#define PI    3.14159265\n\nUNI float width;\nUNI float height;\n// float width = 800.0; //texture width\n// float height = 600.0; //texture height\n\n// vec2 texCoord = texCoord.st;\n\n//------------------------------------------\n//general stuff\n\n//make sure that these two values are the same for your camera, otherwise distances will be wrong.\n\n// const float znear = 0.01; //Z-near\n// const float zfar = 20.0; //Z-far\nUNI float znear;\nUNI float zfar;\n\n//user variables\n// const int SAMPLES = 16; //ao sample count\n// UNI int SAMPLES;\n\n// const float radius = 3.0; //ao radius\n// const float aoclamp = 0.25; //depth clamp - reduces haloing at screen edges\n\nUNI float radius;\nUNI float aoclamp;\nUNI bool noise ; //use noise instead of pattern for sample dithering//*****\nUNI float noiseamount; //dithering amount//********\n\nconst float diffarea = 0.4; //self-shadowing reduction\nconst float gdisplace = 0.4; //gauss bell center\n\n// const bool mist = false; //use mist?\n// const float miststart = 0.0; //mist start\n// const float mistend = 16.0; //mist end\n\n// const bool onlyAO = false; //use only ambient occlusion pass?\n// const float lumInfluence = 0.7; //how much luminance affects occlusion\nUNI float lumInfluence;\n\n//--------------------------------------------------------\n\nvec2 rand(vec2 coord) //generating noise/pattern texture for dithering\n{\n\n    #ifndef NOISE\n    \treturn vec2(0.0,0.0);\n\t#endif\n\n    #ifdef NOISE\n\t\tfloat noiseX = clamp(fract(sin(dot(coord ,vec2(12.9898,78.233))) * 43758.5453),0.0,1.0)*2.0-1.0;\n\t\tfloat noiseY = clamp(fract(sin(dot(coord ,vec2(12.9898,78.233)*2.0)) * 43758.5453),0.0,1.0)*2.0-1.0;\n    \treturn vec2(noiseX,noiseY)*noiseamount/100.0;\n    #endif\n}\n\n// float doMist()\n// {\n// \tfloat zdepth = texture(texDepth,texCoord.xy).x;\n// \tfloat depth = -zfar * znear / (zdepth * (zfar - znear) - zfar);\n// \treturn clamp((depth-miststart)/mistend,0.0,1.0);\n// }\n\nfloat readDepth(in vec2 coord)\n{\n\tif (texCoord.x<0.0||texCoord.y<0.0) return 1.0;\n\treturn (2.0 * znear) / (zfar + znear - texture(texDepth, coord ).x * (zfar-znear));\n}\n\nfloat compareDepths(in float depth1, in float depth2,inout int far)\n{\n\tfloat garea = 2.0; //gauss bell width\n\tfloat diff = (depth1 - depth2)*100.0; //depth difference (0-100)\n\t//reduce left bell width to avoid self-shadowing\n\tif (diff<gdisplace)\n\t{\n\tgarea = diffarea;\n\t}else{\n\tfar = 1;\n\t}\n\n\tfloat gauss = pow(2.7182,-2.0*(diff-gdisplace)*(diff-gdisplace)/(garea*garea));\n\treturn gauss;\n}\n\nfloat calAO(float depth,float dw, float dh)\n{\n\tfloat dd = (1.0-depth)*radius;\n\n\tfloat temp = 0.0;\n\tfloat temp2 = 0.0;\n\tfloat coordw = texCoord.x + dw*dd;\n\tfloat coordh = texCoord.y + dh*dd;\n\tfloat coordw2 = texCoord.x - dw*dd;\n\tfloat coordh2 = texCoord.y - dh*dd;\n\n\tvec2 coord = vec2(coordw , coordh);\n\tvec2 coord2 = vec2(coordw2, coordh2);\n\n\tint far = 0;\n\ttemp = compareDepths(depth, readDepth(coord),far);\n\t//DEPTH EXTRAPOLATION:\n\tif (far > 0)\n\t{\n\t\ttemp2 = compareDepths(readDepth(coord2),depth,far);\n\t\ttemp += (1.0-temp)*temp2;\n\t}\n\n\treturn temp;\n}\n\nvoid main(void)\n{\n\tvec2 noise = rand(texCoord);\n\tfloat depth = readDepth(texCoord);\n\n\tfloat w = (1.0 / width)/clamp(depth,aoclamp,1.0)+(noise.x*(1.0-noise.x));\n\tfloat h = (1.0 / height)/clamp(depth,aoclamp,1.0)+(noise.y*(1.0-noise.y));\n\n\tfloat pw;\n\tfloat ph;\n\n\tfloat ao;\n\n\tfloat dl = PI*(3.0-sqrt(5.0));\n\tfloat dz = 1.0/float(SAMPLES);\n\tfloat l = 0.0;\n\tfloat z = 1.0 - dz/2.0;\n\n\tfor (int i = 0; i <= SAMPLES; i ++)\n\t{\n\t\tfloat r = sqrt(1.0-z);\n\n\t\tpw = cos(l)*r;\n\t\tph = sin(l)*r;\n\t\tao += calAO(depth,pw*w,ph*h);\n\t\tz = z - dz;\n\t\tl = l + dl;\n\t}\n\n\tao /= float(SAMPLES);\n\tao = 1.0-ao;\n\n// \tif (mist)\n// \t{\n// \tao = mix(ao, 1.0,doMist());\n// \t}\n\n\tvec3 color = texture(tex,texCoord).rgb;\n\n\tvec3 lumcoeff = vec3(0.299,0.587,0.114);\n\tfloat lum = dot(color.rgb, lumcoeff);\n\tvec3 luminance = vec3(lum, lum, lum);\n\n\tvec3 final = vec3(color*mix(vec3(ao),vec3(1.0),luminance*lumInfluence));//mix(color*ao, white, luminance)\n\n// \tif (onlyAO)\n// \t{\n// \tfinal = vec3(mix(vec3(ao),vec3(1.0),luminance*lumInfluence)); //ambient occlusion only\n// \t}\n\n\n\toutColor= vec4(final,1.0);\n\n}",};
const
    render=op.inTrigger("render"),
    trigger=op.outTrigger("trigger"),
    depth=op.inTexture("depth texture"),
    zNear=op.inValue("Frustum Near",0.1),
    zFar=op.inValue("Frustum Far",20),
    samples=op.inValueInt("Samples",4),
    aoRadius=op.inValue("Ao Radius",3),
    aoClamp=op.inValueSlider("Ao Clamp",0.25),
    lumInfluence=op.inValueSlider("Luminance Influence",0.7),
    noise = op.inValueBool("Enable noise",false),
    noiseamount = op.inValueFloat("Noise amount", 0.0008);



const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.ssao_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var textureAlpha=new CGL.Uniform(shader,'t','texDepth',1);

aoRadius.uniform=new CGL.Uniform(shader,'f','radius',aoRadius);
aoClamp.uniform=new CGL.Uniform(shader,'f','aoclamp',aoClamp);
lumInfluence.uniform=new CGL.Uniform(shader,'f','lumInfluence',lumInfluence);
// samples.uniform=new CGL.Uniform(shader,'i','samples',samples);

zNear.uniform=new CGL.Uniform(shader,'f','znear',zNear);
zFar.uniform=new CGL.Uniform(shader,'f','zfar',zFar);


noiseamount.uniform=new CGL.Uniform(shader,'f','noiseamount',noiseamount);

noise.onChange=function()
{
    shader.toggleDefine('NOISE',noise.get());
};

samples.onChange=function()
{
    shader.define('SAMPLES',samples.get());
};

var uniWidth=new CGL.Uniform(shader,'f','width',1024);
var uniHeight=new CGL.Uniform(shader,'f','height',512);

shader.define('SAMPLES',samples.get());
aoClamp.uniform=new CGL.Uniform(shader,'f','aoclamp',aoClamp);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;
    if(!depth.get())return;

    uniWidth.setValue( depth.get().width );
    uniHeight.setValue( depth.get().height );

    cgl.setShader(shader);

    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    if(depth.get() && depth.get().tex)
    {
        cgl.setTexture(1, depth.get().tex );
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, depth.get().tex );
    }

    cgl.currentTextureEffect.finish();

    cgl.setPreviousShader();
    trigger.trigger();
};


};

Ops.Gl.TextureEffects.SSAO2.prototype = new CABLES.Op();
CABLES.OPS["76d2dafc-aaf9-48ca-8b24-ee18492fba80"]={f:Ops.Gl.TextureEffects.SSAO2,objName:"Ops.Gl.TextureEffects.SSAO2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.PixelNoise_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.PixelNoise_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={pixelnoise2_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float numX;\nUNI float numY;\nUNI float addX;\nUNI float addY;\nUNI float addZ;\nUNI float seed2;\nUNI float minIn;\nUNI float maxIn;\n\nfloat random(vec2 co)\n{\n    float r=fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * (5.711+(mod(addZ+5711.210,57111.0))));\n\n    #ifdef LOOP\n        r=abs(r-0.5)*2.0;\n    #endif\n\n    return r;\n}\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec2 seed=vec2(floor( texCoord.x*numX+addX),floor( texCoord.y*numY+addY));\n    float r,g,b;\n\n    #ifndef RGB\n        r=g=b=random( seed + 0.5711 + seed2 );\n    #endif\n\n    #ifdef RGB\n        r=random( seed+0.5711 + seed2);\n        g=random( seed+0.5712 + seed2);\n        b=random( seed+0.5713 + seed2);\n    #endif\n\n    vec4 rnd = clamp( vec4( r,g,b,1.0 ),vec4(minIn), vec4(maxIn) );\n\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,rnd,amount);\n\n}",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    inLoop=op.inValueBool("Loop",false),
    inRGB=op.inValueBool("RGB",false),
    minValue=op.inValue("Minimum value",0),
    maxValue=op.inValue("Maximum value",1),
    numX=op.inValue("Num X",10),
    numY=op.inValue("Num Y",10),
    addX=op.inValue("X",0),
    addY=op.inValue("Y",0),
    addZ=op.inValue("Z",0),
    seed2=op.inValue("Seed",0),
    trigger=op.outTrigger("Next");

op.setPortGroup("Look",[inRGB,inLoop,minValue,maxValue]);
op.setPortGroup("Position",[addX,addY,addZ]);
op.setPortGroup("Scaling",[numX,numY]);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);
shader.setSource(shader.getDefaultVertexShader(),attachments.pixelnoise2_frag);

const
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    timeUniform=new CGL.Uniform(shader,'f','time',1.0),
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    uni_numX=new CGL.Uniform(shader,'f','numX',numX),
    uni_numY=new CGL.Uniform(shader,'f','numY',numY),
    uni_addX=new CGL.Uniform(shader,'f','addX',addX),
    uni_addY=new CGL.Uniform(shader,'f','addY',addY),
    uni_addZ=new CGL.Uniform(shader,'f','addZ',addZ),
    uni_seed=new CGL.Uniform(shader,'f','seed2',seed2),
    uni_minValue=new CGL.Uniform(shader,'f','minIn',minValue),
    uni_maxValue=new CGL.Uniform(shader,'f','maxIn',maxValue);

inLoop.onChange=function()
{
    if(inLoop.get())shader.define("LOOP");
      else shader.removeDefine("LOOP");
};

inRGB.onChange=function()
{
    if(inRGB.get())shader.define("RGB");
      else shader.removeDefine("RGB");
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Noise.PixelNoise_v2.prototype = new CABLES.Op();
CABLES.OPS["8634e0bd-0507-46b5-81fb-7d9c42ada6f8"]={f:Ops.Gl.TextureEffects.Noise.PixelNoise_v2,objName:"Ops.Gl.TextureEffects.Noise.PixelNoise_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.ValueNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.ValueNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={valuenoise3d_frag:"\nUNI float z;\nUNI float x;\nUNI float y;\nUNI float scale;\nUNI float amount;\nIN vec2 texCoord;\nUNI sampler2D tex;\n\n{{CGL.BLENDMODES}}\n\n\n//\n//\tValue Noise 3D\n//\tReturn value range of 0.0->1.0\n//\thttp://briansharpe.files.wordpress.com/2011/11/valuesample1.jpg\n//\n\nfloat Interpolation_C2( float x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }   //  6x^5-15x^4+10x^3\t( Quintic Curve.  As used by Perlin in Improved Noise.  http://mrl.nyu.edu/~perlin/paper445.pdf )\nvec2 Interpolation_C2( vec2 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec3 Interpolation_C2( vec3 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2( vec4 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2_InterpAndDeriv( vec2 x ) { return x.xyxy * x.xyxy * ( x.xyxy * ( x.xyxy * ( x.xyxy * vec2( 6.0, 0.0 ).xxyy + vec2( -15.0, 30.0 ).xxyy ) + vec2( 10.0, -60.0 ).xxyy ) + vec2( 0.0, 30.0 ).xxyy ); }\nvec3 Interpolation_C2_Deriv( vec3 x ) { return x * x * (x * (x * 30.0 - 60.0) + 30.0); }\n\n\nvoid FAST32_hash_3D( vec3 gridcell, out vec4 lowz_hash, out vec4 highz_hash )\t//\tgenerates a random number for each of the 8 cell corners\n{\n    //    gridcell is assumed to be an integer coordinate\n\n    //\tTODO: \tthese constants need tweaked to find the best possible noise.\n    //\t\t\tprobably requires some kind of brute force computational searching or something....\n    const vec2 OFFSET = vec2( 50.0, 161.0 );\n    const float DOMAIN = 69.0;\n    const float SOMELARGEFLOAT = 635.298681;\n    const float ZINC = 48.500388;\n\n    //\ttruncate the domain\n    gridcell.xyz = gridcell.xyz - floor(gridcell.xyz * ( 1.0 / DOMAIN )) * DOMAIN;\n    vec3 gridcell_inc1 = step( gridcell, vec3( DOMAIN - 1.5 ) ) * ( gridcell + 1.0 );\n\n    //\tcalculate the noise\n    vec4 P = vec4( gridcell.xy, gridcell_inc1.xy ) + OFFSET.xyxy;\n    P *= P;\n    P = P.xzxz * P.yyww;\n    highz_hash.xy = vec2( 1.0 / ( SOMELARGEFLOAT + vec2( gridcell.z, gridcell_inc1.z ) * ZINC ) );\n    lowz_hash = fract( P * highz_hash.xxxx );\n    highz_hash = fract( P * highz_hash.yyyy );\n}\n\n\nfloat Value3D( vec3 P )\n{\n    //\testablish our grid cell and unit position\n    vec3 Pi = floor(P);\n    vec3 Pf = P - Pi;\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hash_lowz, hash_highz;\n    FAST32_hash_3D( Pi, hash_lowz, hash_highz );\n    //FAST32_2_hash_3D( Pi, hash_lowz, hash_highz );\n    //BBS_hash_3D( Pi, hash_lowz, hash_highz );\n    //SGPP_hash_3D( Pi, hash_lowz, hash_highz );\n\n    //\tblend the results and return\n    vec3 blend = Interpolation_C2( Pf );\n    vec4 res0 = mix( hash_lowz, hash_highz, blend.z );\n    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );\n    return dot( res0, blend2.zxzx * blend2.wwyy );\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n\n   vec2 p=vec2(texCoord.x-0.5,texCoord.y-0.5);\n   p=p*scale;\n\n   p=vec2(p.x+0.5-x,p.y+0.5-y);\n\n   float v=Value3D(vec3(p.x,p.y,z));\n   vec4 col=vec4(v,v,v,1.0);\n\n    outColor=cgl_blend(base,col,amount);\n\n}\n",};
const
    render=op.inTrigger('render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    scale=op.inValue("Scale",4),
    x=op.inValue("X",0),
    y=op.inValue("Y",0),
    z=op.inValue("Z",0);

var trigger=op.outTrigger('trigger');

op.setPortGroup("Position",[x,y,z]);
op.setPortGroup("Look",[scale]);

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.valuenoise3d_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var uniZ=new CGL.Uniform(shader,'f','z',z);
var uniX=new CGL.Uniform(shader,'f','x',x);
var uniY=new CGL.Uniform(shader,'f','y',y);
var uniScale=new CGL.Uniform(shader,'f','scale',scale);

var amountUniform=new CGL.Uniform(shader,'f','amount',amount);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.ValueNoise.prototype = new CABLES.Op();
CABLES.OPS["3523aaba-d00c-4226-add1-bbfd8bf5fe9f"]={f:Ops.Gl.TextureEffects.Noise.ValueNoise,objName:"Ops.Gl.TextureEffects.Noise.ValueNoise"};




// **************************************************************
// 
// Ops.Trigger.RouteTrigger
// 
// **************************************************************

Ops.Trigger.RouteTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// constants
var NUM_PORTS = 16;

// inputs
var exePort = op.inTriggerButton('Execute');
var switchPort = op.inValueInt('Switch Value');

// outputs
var nextTriggerPort = op.outTrigger('Next Trigger');
var valueOutPort = op.outValue('Switched Value');
var triggerPorts = [];
for(var j=0; j<NUM_PORTS; j++) {
    triggerPorts[j] = op.outTrigger('Trigger ' + j);
}
var defaultTriggerPort = op.outTrigger('Default Trigger');

// functions

/**
 * Performs the switch case
 */
function update() {
    var index = Math.round(switchPort.get());
    if(index >= 0 && index < NUM_PORTS) {
        valueOutPort.set(index);
        triggerPorts[index].trigger();
    } else {
        valueOutPort.set(-1);
        defaultTriggerPort.trigger();
    }
    nextTriggerPort.trigger();
}

// change listeners / trigger events
exePort.onTriggered = update;

};

Ops.Trigger.RouteTrigger.prototype = new CABLES.Op();
CABLES.OPS["44ceb5d8-b040-4722-b189-a6fb8172517d"]={f:Ops.Trigger.RouteTrigger,objName:"Ops.Trigger.RouteTrigger"};




// **************************************************************
// 
// Ops.Deprecated.Json3d.Json3dMesh
// 
// **************************************************************

Ops.Deprecated.Json3d.Json3dMesh = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const cgl=op.patch.cgl;
var scene=new CABLES.Variable();
cgl.frameStore.currentScene=null;

var exe=op.inTrigger("Render");
var filename=op.inFile("file",'3d json');
var meshIndex=op.inValueInt("Mesh Index",0);
var draw=op.inValueBool("Draw",true);
var centerPivot=op.inValueBool("Center Mesh",true);
var inSize=op.inValue("Size",1);
var next=op.outTrigger("trigger");
var geometryOut=op.outObject("Geometry");
var merge=op.inValueBool("Merge",false);
var inNormals=op.inSwitch("Calculate Normals",["no","smooth","flat"],"no");
var outScale=op.outValue("Scaling",1.0);

var geom=null;
var data=null;
var mesh=null;
var meshes=[];
var currentIndex=-1;
var transMatrix=mat4.create();
var bounds={};
var vScale=vec3.fromValues(1,1,1);

op.preRender=render;
exe.onTriggered=render;

filename.onChange=reload;
inNormals.onChange=reload;

centerPivot.onChange=setMeshLater;
meshIndex.onChange=setMeshLater;
merge.onChange=setMeshLater;

inSize.onChange=updateScale;
var needSetMesh=true;

function calcNormals()
{
    if(!geom)
    {
        console.log('calc normals: no geom!');
        return;
    }

    if(inNormals.get()=='smooth')geom.calculateNormals();
    else if(inNormals.get()=='flat')
    {
        geom.unIndex();
        geom.calculateNormals();
    }
}

function render()
{
    if(needSetMesh) setMesh();

    if(draw.get())
    {
        cgl.pushModelMatrix();
        mat4.multiply(cgl.mMatrix,cgl.mMatrix,transMatrix);

        if(mesh) mesh.render(cgl.getShader());

        cgl.popModelMatrix();
        next.trigger();
    }
}

function setMeshLater()
{
    needSetMesh=true;
}


function updateScale()
{
    if(inSize.get()!==0)
    {
        var scale=inSize.get()/bounds.maxAxis;
        vec3.set(vScale,scale,scale,scale);
        outScale.set(scale);
    }
    else
    {
        vec3.set(vScale,1,1,1);
    }

    mat4.identity(transMatrix);
    mat4.scale(transMatrix,transMatrix, vScale);
}

function updateInfo(geom)
{
    if(!CABLES.UI)return;

    var nfo='<div class="panel">';

    if(data)
    {
        nfo += 'Mesh '+(currentIndex+1)+' of '+data.meshes.length+'<br/>';
        nfo += '<br/>';
    }

    if(geom)
    {
        nfo += (geom.verticesIndices||[]).length/3+' faces <br/>';
        nfo += (geom.vertices||[]).length/3+' vertices <br/>';
        nfo += (geom.texCoords||[]).length/2+' texturecoords <br/>';
        nfo += (geom.vertexNormals||[]).length/3+' normals <br/>';
        nfo += (geom.tangents||[]).length/3+' tangents <br/>';
        nfo += (geom.biTangents||[]).length/3+' bitangents <br/>';
    }

    nfo+="</div>";

    op.uiAttr({info:nfo});
}


function setMesh()
{
    if(mesh)
    {
        mesh.dispose();
        mesh=null;
    }
    var index=Math.floor(meshIndex.get());

    if(!data || index!=index || !CABLES.UTILS.isNumeric(index) || index<0 || index>=data.meshes.length)
    {
        op.uiAttr({warning:'mesh not found - index out of range '});
        return;
    }

    currentIndex=index;

    geom=new CGL.Geometry();

    if(merge.get())
    {
        for(var i=0;i<data.meshes.length;i++)
        {
            var jsonGeom=data.meshes[i];
            if(jsonGeom)
            {
                var geomNew=CGL.Geometry.json2geom(jsonGeom);
                geom.merge(geomNew);
            }
        }

        var bnd=geom.getBounds();

        for(var i=0;i<geom.vertices.length;i++)
        {
            geom.vertices[i]/=bnd.maxAxis;
        }
    }
    else
    {
        var jsonGeom=data.meshes[index];

        if(!jsonGeom)
        {
            mesh=null;
            op.uiAttr({warning:'mesh not found'});
            return;
        }

        var i=0;
        geom=CGL.Geometry.json2geom(jsonGeom);
    }

    if(centerPivot.get())geom.center();

    bounds=geom.getBounds();
    updateScale();
    updateInfo(geom);

    if(inNormals.get()!='no')calcNormals();
    geometryOut.set(geom);

    if(mesh)mesh.dispose();

    mesh=new CGL.Mesh(cgl,geom);
    needSetMesh=false;
    meshes[index]=mesh;

    op.uiAttr({'warning':null});
}

function reload()
{
    if(!filename.get())return;
    currentIndex=-1;

    function doLoad()
    {
        CABLES.ajax(
            op.patch.getFilePath(filename.get()),
            function(err,_data,xhr)
            {
                if(err)
                {
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});

                    console.error('ajax error:',err);
                    op.patch.loading.finished(loadingId);
                    return;
                }
                else
                {
                    if(CABLES.UI)op.uiAttr({'error':null});
                }

                try
                {
                    data=JSON.parse(_data);
                }
                catch(ex)
                {
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});
                    op.patch.loading.finished(loadingId);
                    return;
                }

                needSetMesh=true;
                op.patch.loading.finished(loadingId);
                if(CABLES.UI) gui.jobs().finish('loading3d'+loadingId);

            });
        // setMesh();
    }

    var loadingId=op.patch.loading.start('json3dMesh',filename.get());

    if(CABLES.UI) gui.jobs().start({id:'loading3d'+loadingId,title:'loading 3d data'},doLoad);
        else doLoad();
}

};

Ops.Deprecated.Json3d.Json3dMesh.prototype = new CABLES.Op();
CABLES.OPS["29bf91a9-504d-4de7-bba6-bae67ee76c77"]={f:Ops.Deprecated.Json3d.Json3dMesh,objName:"Ops.Deprecated.Json3d.Json3dMesh"};




// **************************************************************
// 
// Ops.Gl.Shader.ShowNormalsMaterial
// 
// **************************************************************

Ops.Gl.Shader.ShowNormalsMaterial = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={normalsmaterial_frag:"IN vec3 normal;\nIN vec3 outTangent;\nIN vec3 outBiTangent;\nIN mat4 mMatrix;\nIN vec2 texCoord;\n\n{{MODULES_HEAD}}\n\nvoid main()\n{\n    #ifdef MULMODEL\n        vec4 attr;\n    #endif\n    #ifndef MULMODEL\n        vec3 attr;\n    #endif\n\n    #ifdef SHOW_NORMALS\n        attr.xyz=normal;\n    #endif\n    #ifdef SHOW_BITANGENTS\n        attr.xyz=outBiTangent;\n    #endif\n    #ifdef SHOW_TANGENTS\n        attr.xyz=outTangent;\n    #endif\n\n    #ifdef MULMODEL\n        attr*=mMatrix;\n        attr.xyz=normalize(vec3(attr.x,attr.y,attr.z));\n    #endif\n\n    vec4 col=vec4(attr.x,attr.y,attr.z,1.0);\n\n    #ifdef ABS\n        col=abs(col);\n    #endif\n\n    {{MODULE_COLOR}}\n\n    outColor=col;\n}",normalsmaterial_vert:"IN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal,attrTangent,attrBiTangent;\nOUT vec2 texCoord;\nOUT vec3 normal;\nOUT vec3 outTangent,outBiTangent;\nOUT mat4 mMatrix;\nUNI mat4 projMatrix;\n// UNI mat4 mvMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\n\n{{MODULES_HEAD}}\n\nvoid main()\n{\n    texCoord=attrTexCoord;\n    vec3 norm=attrVertNormal;\n    vec3 tangent=attrTangent;\n    vec3 bitangent=attrBiTangent;\n\n    vec4 pos=vec4(vPosition,1.0);\n    mMatrix=modelMatrix;\n\n    {{MODULE_VERTEX_POSITION}}\n\n    mat4 mvMatrix=viewMatrix*mMatrix;\n\n    normal=norm;\n    outTangent=tangent;\n    outBiTangent=bitangent;\n\n    gl_Position = projMatrix * mvMatrix * pos;\n}",};
const
    render=op.inTrigger('render'),
    inAttr=op.inSwitch('Attribute',["Normals","Tangents","BiTangents"],"Normals"),
    inAbs=op.inBool("Absolute",false),
    inMulModel=op.inBool("World Space",false),
    trigger=op.outTrigger('trigger'),
    outShader=op.outObject("Shader");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(attachments.normalsmaterial_vert,attachments.normalsmaterial_frag);
outShader.set(shader);
render.onTriggered=doRender;
updateAttr();
inMulModel.onChange=inAbs.onChange=inAttr.onChange=updateAttr;

function updateAttr()
{
    shader.toggleDefine("SHOW_NORMALS",inAttr.get()=="Normals");
    shader.toggleDefine("SHOW_TANGENTS",inAttr.get()=="Tangents");
    shader.toggleDefine("SHOW_BITANGENTS",inAttr.get()=="BiTangents");

    shader.toggleDefine("ABS",inAbs.get());
    shader.toggleDefine("MULMODEL",inMulModel.get());
}

function doRender()
{
    cgl.setShader(shader);
    trigger.trigger();
    cgl.setPreviousShader();
}



};

Ops.Gl.Shader.ShowNormalsMaterial.prototype = new CABLES.Op();
CABLES.OPS["2963fd23-a860-461a-a3cf-394b8261159f"]={f:Ops.Gl.Shader.ShowNormalsMaterial,objName:"Ops.Gl.Shader.ShowNormalsMaterial"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Denoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Denoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={denoise_frag:"UNI sampler2D tex;\nUNI float exponent;\nUNI float strength;\nUNI vec2 texSize;\nIN vec2 texCoord;\n\nvoid main()\n{\n    vec4 center = texture(tex, texCoord);\n    vec4 color = vec4(0.0);\n    float total = 0.0;\n    const float pixels=4.0;\n    for (float x = -pixels; x <= pixels; x += 1.0) {\n        for (float y = -pixels; y <= pixels; y += 1.0) {\n            vec4 smpl = texture(tex, texCoord + vec2(x, y) / texSize);\n            float weight = 1.0 - abs(dot(smpl.rgb - center.rgb, vec3(0.25)));\n            weight = pow(weight, (1.0-exponent)*50.0);\n            color += smpl * weight;\n            total += weight;\n        }\n    }\n    outColor = color / total;\n}\n",};
var render=op.inTrigger('render');
var strength=op.inValueSlider("Exponent",0.6);

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);
var tsize=[128,128];
var srcFrag=attachments.denoise_frag;

shader.setSource(shader.getDefaultVertexShader(),srcFrag );
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var strengthUniform=new CGL.Uniform(shader,'f','exponent',strength);
var texSizeUniform=new CGL.Uniform(shader,'2f','texSize',tsize);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    tsize[0]=cgl.currentTextureEffect.getCurrentSourceTexture().width;
    tsize[1]=cgl.currentTextureEffect.getCurrentSourceTexture().height;
    texSizeUniform.setValue(tsize);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0,cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Denoise.prototype = new CABLES.Op();
CABLES.OPS["0abfea0f-1aa9-47bf-b540-f54f89a60a6c"]={f:Ops.Gl.TextureEffects.Denoise,objName:"Ops.Gl.TextureEffects.Denoise"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Posterize
// 
// **************************************************************

Ops.Gl.TextureEffects.Posterize = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={posterize_frag:"UNI sampler2D tex;\nIN vec2 texCoord;\nUNI float levels;\nUNI float amount;\n\n{{CGL.BLENDMODES}}\n\n\nvoid main(void)\n{\n    vec3 srcPixel = texture(tex, texCoord  ).rgb;\n    vec3 amountPerLevel = vec3(1.0/levels);\n    vec3 numOfLevels = floor(srcPixel/amountPerLevel);\n    vec3 col = numOfLevels * (vec3(1.0) / (vec3(levels) - vec3(1.0)));\n\n\n    vec4 base=texture(tex,texCoord);\n    outColor= cgl_blend(base,vec4(col,1.0),amount);\n}\n\n",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    levels=op.inValue("levels",2),
    trigger=op.outTrigger("Trigger");

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.posterize_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    levelsUniform=new CGL.Uniform(shader,'f','levels',levels),
    uniWidth=new CGL.Uniform(shader,'f','texWidth',128),
    uniHeight=new CGL.Uniform(shader,'f','texHeight',128),
    uniAmount=new CGL.Uniform(shader,'f','amount',amount);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Posterize.prototype = new CABLES.Op();
CABLES.OPS["6828f239-09be-45fd-afab-7962596fd2a4"]={f:Ops.Gl.TextureEffects.Posterize,objName:"Ops.Gl.TextureEffects.Posterize"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Vibrance
// 
// **************************************************************

Ops.Gl.TextureEffects.Vibrance = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={vibrance_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\n\nconst vec4 lumcoeff = vec4(0.299,0.587,0.114, 0.);\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n   col=texture(tex,texCoord);\n\n   float luma = dot(col, lumcoeff);\n   vec4 mask = (col - vec4(luma));\n   mask = clamp(mask, 0.0, 1.0);\n   float lumaMask = dot(lumcoeff, mask);\n   lumaMask = 1.0 - lumaMask;\n   vec4 vibrance = mix(vec4(luma), col, 1.0 + amount * lumaMask);\n   outColor= vibrance;\n}",};
const render=op.inTrigger("Render");
const trigger=op.outTrigger("Trigger");
const amount=op.inValue("amount",2);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.vibrance_frag);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Vibrance.prototype = new CABLES.Op();
CABLES.OPS["9c71c980-e439-4397-9c2b-c2ae085eaed9"]={f:Ops.Gl.TextureEffects.Vibrance,objName:"Ops.Gl.TextureEffects.Vibrance"};




// **************************************************************
// 
// Ops.Exp.Gl.Shader.CustomShader2
// 
// **************************************************************

Ops.Exp.Gl.Shader.CustomShader2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger('render'),
    fragmentShader=op.inStringEditor("Fragment Code"),
    vertexShader=op.inStringEditor("Vertex Code"),
    asMaterial=op.inValueBool("Use As Material",true),
    trigger=op.outTrigger('trigger'),
    outShader=op.outObject("Shader");

const cgl=op.patch.cgl;
var uniformInputs=[];
var uniformTextures=[];
var vectors=[];

fragmentShader.setUiAttribs({editorSyntax:'glsl'});
vertexShader.setUiAttribs({editorSyntax:'glsl'});

var shader=new CGL.Shader(cgl,"shaderMaterial");
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);

op.setPortGroup("Source Code",[fragmentShader,vertexShader]);
op.setPortGroup("Options",[asMaterial]);

fragmentShader.set(CGL.Shader.getDefaultFragmentShader());
vertexShader.set(CGL.Shader.getDefaultVertexShader());
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);

fragmentShader.onChange=vertexShader.onChange=function(){ needsUpdate=true; };

render.onTriggered=doRender;

var needsUpdate=true;
op.onLoadedValueSet=initDataOnLoad;

function initDataOnLoad(data)
{
    updateShader();
    // set uniform values AFTER shader has been compiled and uniforms are extracted and uniform ports are created.
    for(var i=0;i<uniformInputs.length;i++)
        for(var j=0;j<data.portsIn.length;j++)
            if(uniformInputs[i] && uniformInputs[i].name==data.portsIn[j].name)
                uniformInputs[i].set(data.portsIn[j].value);
}


op.init=function()
{
    updateShader();
};

function doRender()
{
    setVectorValues();
    if(needsUpdate)updateShader();
    if(asMaterial.get()) cgl.setShader(shader);
    trigger.trigger();
    if(asMaterial.get()) cgl.setPreviousShader();
}

function bindTextures()
{
    for(var i=0;i<uniformTextures.length;i++)
        if(uniformTextures[i] && uniformTextures[i].get() && uniformTextures[i].get().tex)
            cgl.setTexture(0+i+3, uniformTextures[i].get().tex);
}

function hasUniformInput(name)
{
    var i=0;
    for(i=0;i<uniformInputs.length;i++) if(uniformInputs[i] && uniformInputs[i].name==name)return true;
    for(i=0;i<uniformTextures.length;i++) if(uniformTextures[i] && uniformTextures[i].name==name)return true;
    return false;
}

var tempMat4=mat4.create();
// var lastm4;
// const uniformNameBlacklist = [
//     'modelMatrix',
//     'viewMatrix',
//     'normalMatrix',
//     'mvMatrix',
//     'projMatrix',
//     'inverseViewMatrix',
//     'camPos'
// ];
var countTexture=0;
var foundNames=[];


function parseUniforms(src)
{
    const lblines=src.split("\n");
    var groupUniforms=[];

    for(var k=0;k<lblines.length;k++)
    {
        const lines=lblines[k].split(";");

        for(var i=0;i<lines.length;i++)
        {
            var words=lines[i].split(" ");

            for(var j=0;j<words.length;j++) words[j]=(words[j]+'').trim();

            if(words[0]==="UNI" || words[0]==="uniform")
            {
                var varnames=words[2];
                if(words.length>4)for(var j=3;j<words.length;j++)varnames+=words[j];

                words = words.filter(function(el) { return el!==""; });
                const type=words[1];

                var names=[varnames];
                if(varnames.indexOf(",")>-1) names=varnames.split(",");

                for(var l=0;l<names.length;l++)
                {
                    const uniName=names[l].trim();

                    if(type==="float")
                    {
                        foundNames.push(uniName);
                        if(!hasUniformInput(uniName))
                        {
                            const newInput=op.inFloat(uniName,0);
                            newInput.uniform=new CGL.Uniform(shader,'f',uniName,newInput);
                            uniformInputs.push(newInput);
                            groupUniforms.push(newInput);
                        }
                    }
                    else if(type==="int")
                    {
                        foundNames.push(uniName);
                        if(!hasUniformInput(uniName))
                        {
                            const newInput=op.inInt(uniName,0);
                            newInput.uniform=new CGL.Uniform(shader,'i',uniName,newInput);
                            uniformInputs.push(newInput);
                            groupUniforms.push(newInput);
                        }
                    }
                    // else if(type==="bool")
                    // {
                    //     foundNames.push(uniName);
                    //     if(!hasUniformInput(uniName))
                    //     {
                    //         const newInput=op.inBool(uniName,false);
                    //         newInput.uniform=new CGL.Uniform(shader,'b',uniName,newInput);
                    //         uniformInputs.push(newInput);
                    //         groupUniforms.push(newInput);
                    //     }
                    // }
                    else if(type==="sampler2D")
                    {
                        foundNames.push(uniName);
                        if(!hasUniformInput(uniName))
                        {
                            var newInputTex=op.inObject(uniName);
                            newInputTex.uniform=new CGL.Uniform(shader,'t',uniName,3+uniformTextures.length);
                            uniformTextures.push(newInputTex);
                            groupUniforms.push(newInputTex);
                            countTexture++;
                        }
                    }
                    else if(type==="vec3" || type==="vec2" || type==="vec4")
                    {
                        var num=2;
                        if(type==="vec4")num=4;
                        if(type==="vec3")num=3;
                        foundNames.push(uniName+' X');
                        foundNames.push(uniName+' Y');
                        if(num>2)foundNames.push(uniName+' Z');
                        if(num>3)foundNames.push(uniName+' W');

                        if(!hasUniformInput(uniName+' X'))
                        {
                            var group=[];
                            var vec={
                                "name":uniName,
                                "num":num,
                                "changed":false
                            };
                            vectors.push(vec);
                            initVectorUniform(vec);

                            const newInputX=op.inFloat(uniName+' X',0);
                            newInputX.onChange=function(){vec.changed=true;}
                            uniformInputs.push(newInputX);
                            group.push(newInputX);
                            vec.x=newInputX;

                            const newInputY=op.inFloat(uniName+' Y',0);
                            newInputY.onChange=function(){vec.changed=true;}
                            uniformInputs.push(newInputY);
                            group.push(newInputY);
                            vec.y=newInputY;

                            if(num>2)
                            {
                                const newInputZ=op.inFloat(uniName+' Z',0);
                                newInputZ.onChange=function(){vec.changed=true;}
                                uniformInputs.push(newInputZ);
                                group.push(newInputZ);
                                vec.z=newInputZ;
                            }
                            else if(num>3)
                            {
                                const newInputW=op.inFloat(uniName+' W',0);
                                newInputW.onChange=function(){vec.changed=true;}
                                uniformInputs.push(newInputW);
                                group.push(newInputW);
                                vec.w=newInputW;
                            }

                            op.setPortGroup(uniName,group);
                        }
                    }
                }
            }
        }
    }

    op.setPortGroup("uniforms",groupUniforms);
}

function updateShader()
{
    if(!shader)return;

    shader.bindTextures=bindTextures.bind(this);
    shader.setSource(vertexShader.get(),fragmentShader.get());

    countTexture=0;
    foundNames.length=0;

    parseUniforms(vertexShader.get());
    parseUniforms(fragmentShader.get());

    for(var j=0;j<uniformTextures.length;j++)
        for(var i=0;i<foundNames.length;i++)
            if(uniformTextures[j] && foundNames.indexOf(uniformTextures[j].name)==-1)
            {
                uniformTextures[j].remove();
                uniformTextures[j]=null;
            }


    for(var j=0;j<uniformInputs.length;j++)
        for(var i=0;i<foundNames.length;i++)
            if(uniformInputs[j] && foundNames.indexOf(uniformInputs[j].name)==-1)
            {
                uniformInputs[j].remove();
                uniformInputs[j]=null;
            }

    for(var j=0;j<vectors.length;j++)
    {
        initVectorUniform(vectors[j]);
        vectors[j].changed=true;
    }


    for(i=0;i<uniformInputs.length;i++)
        if(uniformInputs[i] && uniformInputs[i].uniform)uniformInputs[i].uniform.needsUpdate=true;




    shader.compile();


    if(CABLES.UI) gui.patch().showOpParams(op);

    outShader.set(null);
    outShader.set(shader);
    needsUpdate=false;
}

function initVectorUniform(vec)
{
    if(vec.num==2) vec.uni=new CGL.Uniform(shader,'2f',vec.name,[0,0]);
    else if(vec.num==3) vec.uni=new CGL.Uniform(shader,'3f',vec.name,[0,0,0]);
    else if(vec.num==4) vec.uni=new CGL.Uniform(shader,'4f',vec.name,[0,0,0,0]);
}

function setVectorValues()
{
    for(var i=0;i<vectors.length;i++)
    {
        var v=vectors[i];
        if(v.changed)
        {
            if(v.num===2) v.uni.setValue([v.x.get(),v.y.get()]);
            else if(v.num===3) v.uni.setValue([v.x.get(),v.y.get(),v.z.get()]);
            else if(v.num===4) v.uni.setValue([v.x.get(),v.y.get(),v.z.get(),v.w.get()]);
            v.changed=false;
        }
    }
}


};

Ops.Exp.Gl.Shader.CustomShader2.prototype = new CABLES.Op();
CABLES.OPS["a165fc89-a35b-4d39-8930-7345b098bd9d"]={f:Ops.Exp.Gl.Shader.CustomShader2,objName:"Ops.Exp.Gl.Shader.CustomShader2"};




// **************************************************************
// 
// Ops.Gl.Shader.Shader2Texture
// 
// **************************************************************

Ops.Gl.Shader.Shader2Texture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exec=op.inTrigger("Render"),
    inShader=op.inObject("Shader"),
    tfilter=op.inValueSelect("filter",['nearest','linear','mipmap']),
    twrap=op.inValueSelect("wrap",['clamp to edge','repeat','mirrored repeat'],'clamp to edge'),
    inVPSize=op.inValueBool("Use Viewport Size",true),
    inWidth=op.inValueInt("Width",512),
    inHeight=op.inValueInt("Height",512),
    inFloatingPoint=op.inValueBool("Floating Point",false),
    next=op.outTrigger("Next"),
    outTex=op.outTexture("Texture");

const cgl=op.patch.cgl;
var prevViewPort=[0,0,0,0];
var effect=null;

inWidth.onChange=
    inHeight.onChange=
    inFloatingPoint.onChange=
    inVPSize.onChange=
    tfilter.onChange=
    twrap.onChange=initFbLater;

var fb=null;
var tex=null;
var needInit=true;
var mesh=CGL.MESHES.getSimpleRect(cgl,"shader2texture rect");

op.toWorkPortsNeedToBeLinked(inShader);

tfilter.set("nearest");

function initFbLater()
{
    needInit=true;
}

function initFb()
{
    needInit=false;
    if(fb)fb.delete();
    fb=null;

    var w=inWidth.get();
    var h=inHeight.get();

    var filter=CGL.Texture.FILTER_NEAREST;
    if(tfilter.get()=='linear') filter=CGL.Texture.FILTER_LINEAR;
        else if(tfilter.get()=='mipmap') filter=CGL.Texture.FILTER_MIPMAP;

    var selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;
    if(twrap.get()=='repeat') selectedWrap=CGL.Texture.WRAP_REPEAT;
    if(twrap.get()=='mirrored repeat') selectedWrap=CGL.Texture.WRAP_MIRRORED_REPEAT;

    if(inVPSize.get())
    {
        inWidth.setUiAttribs({hidePort:true,greyout:true});
        inHeight.setUiAttribs({hidePort:true,greyout:true});

        w=cgl.getViewPort()[2];
        h=cgl.getViewPort()[3];
        inWidth.set(w);
        inHeight.set(h);
    }
    else
    {
        if(inWidth.uiAttribs.hidePort)
        {
            inWidth.setUiAttribs({hidePort:false,greyout:false});
            inHeight.setUiAttribs({hidePort:false,greyout:false});
        }
    }

    if(cgl.glVersion>=2)
    {
        fb=new CGL.Framebuffer2(cgl,w,h,
        {
            isFloatingPointTexture:inFloatingPoint.get(),
            multisampling:false,
            wrap:selectedWrap,
            filter:filter,
            depth:true,
            multisamplingSamples:0,
            clear:true
        });
    }
    else
    {
        fb=new CGL.Framebuffer(cgl,inWidth.get(),inHeight.get(),
        {
            isFloatingPointTexture:inFloatingPoint.get(),
            filter:filter,
            wrap:selectedWrap
        });
    }
}

exec.onTriggered=function()
{
    var vp=cgl.getViewPort();

    var shader=inShader.get();
    if(!shader)
    {
        outTex.set(null);
        return;
    }
    if(!fb || needInit )initFb();
    if(inVPSize.get() && fb && ( vp[2]!=fb.getTextureColor().width || vp[3]!=fb.getTextureColor().height ) )
    {
        initFb();
    }

    prevViewPort[0]=vp[0];
    prevViewPort[1]=vp[1];
    prevViewPort[2]=vp[2];
    prevViewPort[3]=vp[3];

    fb.renderStart(cgl);

    cgl.pushPMatrix();
    mat4.identity(cgl.pMatrix);

    cgl.pushViewMatrix();
    mat4.identity(cgl.vMatrix);

    cgl.pushModelMatrix();
    mat4.identity(cgl.mMatrix);

    cgl.setShader(inShader.get());
    if(shader.bindTextures) shader.bindTextures();

    mesh.render(inShader.get());

    cgl.popPMatrix();
    cgl.popModelMatrix();
    cgl.popViewMatrix();
    fb.renderEnd(cgl);

    outTex.set(fb.getTextureColor());

    cgl.setPreviousShader();

    cgl.gl.viewport(prevViewPort[0],prevViewPort[1],prevViewPort[2],prevViewPort[3] );

    next.trigger();
};


};

Ops.Gl.Shader.Shader2Texture.prototype = new CABLES.Op();
CABLES.OPS["a3debb76-7d84-4548-9e7b-24891423dcce"]={f:Ops.Gl.Shader.Shader2Texture,objName:"Ops.Gl.Shader.Shader2Texture"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.LayerNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.LayerNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={layernoise_frag:"// @author Jan <LJ> Scheurer - Xe-Development UG\n// @copyright undefined development UG\n\n\n{{MODULES_HEAD}}\n\nUNI int mode;\nUNI vec4 attribs;\nUNI vec3 scroll;\nUNI bool rgba;\nUNI float amount;\nIN vec2 texCoord;\nUNI sampler2D tex;\n\n{{CGL.BLENDMODES}}\n\n#define LINEAR 0\n#define EXPONENTIAL 1\n#define LOGARITHMIC 2\n\nfloat rand (vec3 p) {\n    return fract(sin(dot(p,vec3(12.4085,48.512313,32.6143)))*42754.71415);\n}\n\nconst vec2 O = vec2(0,1);\n\nfloat noise (vec3 p) {\n    vec3 b=floor(p),f=fract(p);\n    return mix(\n        mix(mix(rand(b+O.xxx),rand(b+O.yxx),f.x),mix(rand(b+O.xyx),rand(b+O.yyx),f.x),f.y),\n        mix(mix(rand(b+O.xxy),rand(b+O.yxy),f.x),mix(rand(b+O.xyy),rand(b+O.yyy),f.x),f.y),\n        f.z\n    );\n}\n\nfloat gn(vec3 p){\n    float n = 0., fi;\n    int numLayers = int(attribs.g);\n    for (int i = 1; i < 100; i++) {\n        if (i > numLayers) break;\n        if (mode == LINEAR)\n            fi = float(i),p+=attribs.r;\n        else if (mode == EXPONENTIAL)\n            fi = float(i*i);\n        else if (mode == LOGARITHMIC)\n            fi = log(float(i+1)),p+=attribs.r;\n        n += noise(p*fi) / fi;\n    }\n    return n*attribs.b;\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n\n    vec2 tc=texCoord;\n\t#ifdef DO_TILEABLE\n\t    tc=abs(texCoord-0.5);\n\t#endif\n    vec3 p = vec3(tc * 2. - 1.,0) + scroll;\n    vec4 col;\n    if (rgba) {\n        for(int i = 0; i < 4; i++) {\n            col[i] = gn(p*attribs.r);\n            p += attribs.r;\n        }\n    } else\n        col = vec4(vec3(gn(p*attribs.r)),1);\n\n    outColor=cgl_blend(base,col,amount);\n}",};
const cgl = op.patch.cgl;

// inputs
const inTrigger = op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1);

const inLayerMode = op.inValueSelect("mode",[
    "exponential",
    "logarithmic",
    "linear"
], "exponential");
const inRGBA = op.inValueBool("RGBA");
const inScale = op.inValue("scale",4);
const inNumLayers = op.inValueInt("layers",3);
const inFactor = op.inValue("factor",1);
const inExponent = op.inValue("exponent",1.3);
const inScrollX = op.inValue("scrollX");
const inScrollY = op.inValue("scrollY");
const inScrollZ = op.inValue("scrollZ");

// outputs
const outTrigger = op.outTrigger("trigger");

// locals
const TEX_SLOT=0;
const shader = new CGL.Shader(cgl);
const attribs = [inScale.get(),inNumLayers.get(),inFactor.get(),0];
shader.setSource(shader.getDefaultVertexShader(),attachments.layernoise_frag);
shader.addUniform(
    new CGL.Uniform(shader,"4f","attribs",attribs)
);
const uniMode = new CGL.Uniform(shader, "i", "mode", 1);
shader.addUniform(uniMode);
const uniRGBA = new CGL.Uniform(shader, "b", "rgba", false);
const scroll = [inScrollX.get(),inScrollY.get(),inScrollZ.get()];
const uniScroll = new CGL.Uniform(shader, "3f", "scroll", scroll);
const uniformAmount=new CGL.Uniform(shader,'f','amount',amount);
const textureUniform=new CGL.Uniform(shader,'t','tex',TEX_SLOT);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

var needsUpdate=false;
// events
inTrigger.onTriggered = function () {
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(needsUpdate)
    {
        attribs[0] = inScale.get();
        attribs[1] = inNumLayers.get();

        var layerMode = inLayerMode.get();
        if (layerMode == "linear")
            uniMode.set(0);
        else if (layerMode == "exponential")
            uniMode.set(1);
        else
            uniMode.set(2);

        attribs[2] = inFactor.get();
        attribs[3] = inExponent.get();
        uniRGBA.set(inRGBA.get());
        scroll[0] = inScrollX.get();
        scroll[1] = inScrollY.get();
        scroll[2] = inScrollZ.get();
        uniScroll.set(scroll);
        needsUpdate=false;


    }

    cgl.setTexture(TEX_SLOT, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();
    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();
    outTrigger.trigger();

    // console.log(shader.finalShaderFrag);
};


var tile=op.inValueBool("Tileable",false);
tile.onChange=updateTileable;
function updateTileable()
{
    if(tile.get())shader.define("DO_TILEABLE");
        else shader.removeDefine("DO_TILEABLE");
}


inScale.onChange =
inNumLayers.onChange =
inLayerMode.onChange =
inExponent.onChange =
inFactor.onChange =
inRGBA.onChange =
inScrollX.onChange =
inScrollY.onChange =
inScrollZ.onChange =
function () {
    needsUpdate=true;
};



};

Ops.Gl.TextureEffects.Noise.LayerNoise.prototype = new CABLES.Op();
CABLES.OPS["f04bbc15-04f0-4b84-9825-14eec51e1365"]={f:Ops.Gl.TextureEffects.Noise.LayerNoise,objName:"Ops.Gl.TextureEffects.Noise.LayerNoise"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Plasma
// 
// **************************************************************

Ops.Gl.TextureEffects.Plasma = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={plasma_frag:"#define PI 3.1415926535897932384626433832795\n\nUNI float time;\nUNI float w;\nUNI float h;\nUNI float mul;\nUNI float amount;\nUNI sampler2D tex;\nUNI float offsetX;\nUNI float offsetY;\n\nIN vec2 texCoord;\n\n{{CGL.BLENDMODES}}\n\nvoid main() {\n   vec2 size=vec2(w,h);\n    float v = 0.0;\n    vec2 c = texCoord * size - size/2.0;\n\n    c.x+=offsetX;\n    c.y+=offsetY;\n\n    v += sin((c.x+time));\n    v += sin((c.y+time)/2.0);\n    v += sin((c.x+c.y+time)/2.0);\n    c += size/2.0 * vec2(sin(time/3.0), cos(time/2.0));\n\n    v += sin(sqrt(c.x*c.x+c.y*c.y+1.0)+time);\n    v = v/2.0;\n\n    vec3 newColor = vec3(sin(PI*v*mul/4.0), sin(PI*v*mul), cos(PI*v*mul))*.5 + .5;\n    vec4 base=texture(tex,texCoord);\n\n    #ifndef GREY\n       vec4 col=vec4( _blend(base.rgb,newColor) ,1.0);\n    #endif\n    #ifdef GREY\n    // .endl()+'       vec4 col=vec4( _blend(base.rgb,vec3((newColor.r+newColor.g+newColor.b)/3.0)) ,1.0);'\n           vec4 col=vec4( _blend(base.rgb,vec3(newColor.g)) ,1.0);\n    #endif\n\n    outColor=cgl_blend(base,col,amount);\n\n}",};
const
    render=op.inTrigger('render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    x=op.inValue("Width",20),
    y=op.inValue("Height",20),
    mul=op.inValue("Mul",1),
    offsetX=op.inValue("offset X",0),
    offsetY=op.inValue("offset Y",0),
    time=op.inValue("Time",1),
    greyscale=op.inValueBool("Greyscale",true),
    trigger=op.outTrigger('trigger');


const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.plasma_frag);
shader.define('GREY');

const
    uniX=new CGL.Uniform(shader,'f','w',x),
    uniY=new CGL.Uniform(shader,'f','h',y),
    uniTime=new CGL.Uniform(shader,'f','time',time),
    uniMul=new CGL.Uniform(shader,'f','mul',mul),
    unioffsetX=new CGL.Uniform(shader,'f','offsetX',offsetX),
    unioffsetY=new CGL.Uniform(shader,'f','offsetY',offsetY),
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount);

greyscale.onChange=function()
{
    if(greyscale.get())shader.define('GREY');
        else shader.removeDefine('GREY');
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Plasma.prototype = new CABLES.Op();
CABLES.OPS["6c82c11d-1931-43b1-8e6c-5d20cb1a0d87"]={f:Ops.Gl.TextureEffects.Plasma,objName:"Ops.Gl.TextureEffects.Plasma"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Twirl_v3
// 
// **************************************************************

Ops.Gl.TextureEffects.Twirl_v3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={twirl_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float twistAmount;\nUNI float times;\nUNI float radius;\nUNI float centerX;\nUNI float centerY;\n\n{{CGL.BLENDMODES}}\n\nvoid main()\n{\n    vec2 center=vec2(centerX,centerY);\n    vec2 tc = texCoord;\n    tc -= center;\n    float dist = length(tc);\n    if (dist < radius)\n    {\n        float percent = (radius - dist) / radius;\n        float theta = percent * percent * twistAmount * 8.0;\n        float s = sin(theta);\n        float c = cos(theta);\n        tc = vec2(dot(tc, vec2(c, -s)), dot(tc, vec2(s, c)));\n    }\n    tc += center;\n\n    vec4 col = texture(tex, tc);\n    vec4 base=texture(tex,texCoord);\n    outColor=cgl_blend(base,col,amount);\n}\n",};
const render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    twistAmount=op.inValue("Twist amount",200),
    radius=op.inValue("Radius",0.5),
    centerX=op.inValue("Center X",0.5),
    centerY=op.inValue("Center Y",0.5),
    trigger=op.outTrigger("Next");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.twirl_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    uniTwistAmount=new CGL.Uniform(shader,'f','twistAmount',1),
    uniRadius=new CGL.Uniform(shader,'f','radius',radius),
    unicenterX=new CGL.Uniform(shader,'f','centerX',centerX),
    unicenterY=new CGL.Uniform(shader,'f','centerY',centerY);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    uniTwistAmount.setValue(twistAmount.get()*(1/texture.width));

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Twirl_v3.prototype = new CABLES.Op();
CABLES.OPS["5c128ea4-14df-4248-a02e-b05d2783ed58"]={f:Ops.Gl.TextureEffects.Twirl_v3,objName:"Ops.Gl.TextureEffects.Twirl_v3"};




// **************************************************************
// 
// Ops.Gl.Textures.Text_v2
// 
// **************************************************************

Ops.Gl.Textures.Text_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    text=op.inStringEditor("text",'cables'),
    doRefresh=op.inTriggerButton("Refresh"),
    font=op.inString("font","Arial"),
    maximize=op.inValueBool("Maximize Size"),
    inFontSize=op.inValueFloat("fontSize",30),
    lineDistance=op.inValueFloat("line distance",1),
    texWidth=op.inValueInt("texture width",512),
    texHeight=op.inValueInt("texture height",512),
    align=op.inSwitch("align",['left','center','right'],'center'),
    valign=op.inSwitch("vertical align",['top','center','bottom'],'center'),
    border=op.inValueFloat("border",0),
    cachetexture=op.inValueBool("Reuse Texture",true),
    outRatio=op.outValue("Ratio"),
    textureOut=op.outTexture("texture");

op.setPortGroup('Size',[font,maximize,inFontSize,lineDistance]);
op.setPortGroup('Texture Size',[texWidth,texHeight]);
op.setPortGroup('Alignment',[valign,align]);

textureOut.ignoreValueSerialize=true;

const cgl=op.patch.cgl;
const body = document.getElementsByTagName("body")[0];

doRefresh.onTriggered=refresh;

var fontImage = document.createElement('canvas');
fontImage.id = "texturetext_"+CABLES.generateUUID();
fontImage.style.display = "none";
body.appendChild(fontImage);

const ctx = fontImage.getContext('2d');

align.onChange=
    valign.onChange=
    text.onChange=
    inFontSize.onChange=
    font.onChange=
    border.onChange=
    lineDistance.onChange=
    maximize.onChange=refresh;

texWidth.onChange=
    texHeight.onChange=reSize;

refresh();
reSize();

function reSize()
{
    textureOut.get().setSize(texWidth.get(),texHeight.get());

    ctx.canvas.width=fontImage.width=texWidth.get();
    ctx.canvas.height=fontImage.height=texHeight.get();
    refresh();
}

maximize.onChange =  function ()
{
    if(maximize.get())
    {
        inFontSize.setUiAttribs({greyout:true});
    }
    else
    {
        inFontSize.setUiAttribs({greyout:false});
    }
};

function refresh()
{
    ctx.clearRect(0,0,fontImage.width,fontImage.height);
    ctx.fillStyle = 'white';
    var fontSize=parseFloat(inFontSize.get());
    var fontname=font.get();
    if(fontname.indexOf(" ")>-1)fontname='"'+fontname+'"';
    ctx.font = fontSize+'px '+fontname+'';
    ctx.textAlign = align.get();

    if(border.get()>0)
    {
        ctx.beginPath();
        ctx.lineWidth=""+border.get();
        ctx.strokeStyle="white";
        ctx.rect(
            0,
            0,
            texWidth.get(),
            texHeight.get()
            );
        ctx.stroke();
    }

    var i=0;
    var txt=(text.get()+'').replace(/<br\/>/g, '\n');
    txt=(text.get()+'').replace(/<br>/g, '\n');
    var strings = txt.split("\n");
    var posy=0;

    if(maximize.get())
    {
        // inFontSize.setUiAttribs({hidePort:true,greyout:true});

        fontSize=texWidth.get();
        var count=0;
        var maxWidth=0;
        var maxHeight=0;

        do
        {
            count++;
            if(count>300)break;
            fontSize-=10;
            ctx.font = fontSize+'px "'+font.get()+'"';
            maxWidth=0;
            maxHeight=strings.length*fontSize*1.1;
            for(i=0;i<strings.length;i++)
            {
                maxWidth=Math.max(maxWidth,ctx.measureText(strings[i]).width);
            }
        }
        while(maxWidth>ctx.canvas.width || maxHeight>ctx.canvas.height);
    }
    else
    {
        // inFontSize.setUiAttribs({hidePort:false,greyout:false});
    }


    if(valign.get()=='center')
    {
        var maxy=(strings.length-1.5)*fontSize+parseFloat(lineDistance.get());
        posy=ctx.canvas.height / 2-maxy/2;
    }
    else if(valign.get()=='top') posy=fontSize;
    else if(valign.get()=='bottom')  posy=ctx.canvas.height -(strings.length)*(parseFloat(inFontSize.get())+parseFloat(lineDistance.get()));

    for(i=0;i<strings.length;i++)
    {
        if(align.get()=='center') ctx.fillText(strings[i], ctx.canvas.width / 2, posy);
        if(align.get()=='left') ctx.fillText(strings[i], 0, posy);
        if(align.get()=='right') ctx.fillText(strings[i], ctx.canvas.width, posy);
        posy+=fontSize+parseFloat(lineDistance.get());
    }

    ctx.restore();
    outRatio.set(ctx.canvas.height/ctx.canvas.width);


    if(!cachetexture.get() || !textureOut.get()) textureOut.set(new CGL.Texture.createFromImage( cgl, fontImage, { filter:CGL.Texture.FILTER_MIPMAP } ));

    textureOut.get().initTexture(fontImage,CGL.Texture.FILTER_MIPMAP);
    textureOut.get().unpackAlpha=true;
}



};

Ops.Gl.Textures.Text_v2.prototype = new CABLES.Op();
CABLES.OPS["9fb1baae-db06-481c-8220-6d87d02c4c9e"]={f:Ops.Gl.Textures.Text_v2,objName:"Ops.Gl.Textures.Text_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.FBMNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.FBMNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={fbmnoise_frag:"UNI sampler2D tex;\nUNI float anim;\n\nUNI float scale;\nUNI float repeat;\n\nUNI float scrollX;\nUNI float scrollY;\n\nUNI float amount;\n\nUNI bool layer1;\nUNI bool layer2;\nUNI bool layer3;\nUNI bool layer4;\n\nUNI float aspect;\n\nIN vec2 texCoord;\n\n\n{{CGL.BLENDMODES}}\n\n// csdcsdcds\n// adapted from warp shader by inigo quilez/iq\n// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.\n\n// See here for a tutorial on how to make this: http://www.iquilezles.org/www/articles/warp/warp.htm\n\nconst mat2 m = mat2( 0.80,  0.60, -0.60,  0.80 );\n\nfloat noise( in vec2 x )\n{\n\treturn sin(1.5*x.x)*sin(1.5*x.y);\n}\n\nfloat fbm4( vec2 p )\n{\n    float f = 0.0;\n    f += 0.5000*noise( p ); p = m*p*2.02;\n    f += 0.2500*noise( p ); p = m*p*2.03;\n    f += 0.1250*noise( p ); p = m*p*2.01;\n    f += 0.0625*noise( p );\n    return f/0.9375;\n}\n\nfloat fbm6( vec2 p )\n{\n    float f = 0.0;\n    f += 0.500000*(0.5+0.5*noise( p )); p = m*p*2.02;\n    f += 0.250000*(0.5+0.5*noise( p )); p = m*p*2.03;\n    f += 0.125000*(0.5+0.5*noise( p )); p = m*p*2.01;\n    f += 0.062500*(0.5+0.5*noise( p )); p = m*p*2.04;\n    f += 0.031250*(0.5+0.5*noise( p )); p = m*p*2.01;\n    f += 0.015625*(0.5+0.5*noise( p ));\n    return f/0.96875;\n}\n\nvoid main()\n{\n    // vec4 col=texture(tex,texCoord+2.0*fbm4(texCoord+2.0*fbm6(texCoord+anim)));\n\n    vec2 tc=texCoord;\n\t#ifdef DO_TILEABLE\n\t    tc=abs(texCoord-0.5);\n\t#endif\n\n\n    vec2 p=(tc-0.5)*scale;\n\n\n    p.y/=aspect;\n    vec2 q = vec2( fbm4( p + vec2(0.3+scrollX,0.20+scrollY) ),\n                   fbm4( p + vec2(3.1+scrollX,1.3+scrollY) ) );\n\n    vec2 q2 = vec2( fbm4( p + vec2(2.0+scrollX,1.0+scrollY) ),\n                   fbm4( p + vec2(3.1+scrollX,1.3+scrollY) ) );\n\n    vec2 q3 = vec2( fbm4( p + vec2(9.0+scrollX,4.0+scrollY) ),\n                   fbm4( p + vec2(3.1+scrollX,4.3+scrollY) ) );\n\n\n\n    float v= fbm4( ( p + 4.0*q +anim*0.1)*repeat);\n    float v2= fbm4( (p + 4.0*q2 +anim*0.1)*repeat );\n\n    float v3= fbm6( (p + 4.0*q3 +anim*0.1)*repeat );\n    float v4= fbm6( (p + 4.0*q2 +anim*0.1)*repeat );\n\n\n\n\n    vec4 base=texture(tex,texCoord);\n\n    vec4 finalColor;\n    float colVal=0.0;\n    float numLayers=0.0;\n\n    if(layer1)\n    {\n        colVal+=v;\n        numLayers++;\n    }\n\n    if(layer2)\n    {\n        colVal+=v2;\n        numLayers++;\n    }\n\n    if(layer3)\n    {\n        colVal+=v3;\n        numLayers++;\n    }\n\n    if(layer4)\n    {\n        colVal+=v4;\n        numLayers++;\n    }\n\n    finalColor=vec4( vec3(colVal/numLayers),1.0);\n\n\n    outColor = cgl_blend(base,finalColor,amount);;\n\n}\n",};
const
    render=op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.fbmnoise_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var uniScale=new CGL.Uniform(shader,'f','scale',op.inValue("scale",2));
var uniAnim=new CGL.Uniform(shader,'f','anim',op.inValue("anim",0));
var uniScrollX=new CGL.Uniform(shader,'f','scrollX',op.inValue("scrollX",9));
var uniScrollY=new CGL.Uniform(shader,'f','scrollY',op.inValue("scrollY",0));
var uniRepeat=new CGL.Uniform(shader,'f','repeat',op.inValue("repeat",1));
var uniAspect=new CGL.Uniform(shader,'f','aspect',op.inValue("aspect",1));

var uniLayer1=new CGL.Uniform(shader,'b','layer1',op.inValueBool("Layer 1",true));
var uniLayer2=new CGL.Uniform(shader,'b','layer2',op.inValueBool("Layer 2",true));
var uniLayer3=new CGL.Uniform(shader,'b','layer3',op.inValueBool("Layer 3",true));
var uniLayer4=new CGL.Uniform(shader,'b','layer4',op.inValueBool("Layer 4",true));

var amountUniform=new CGL.Uniform(shader,'f','amount',amount);

var tile=op.inValueBool("Tileable",false);
tile.onChange=updateTileable;
function updateTileable()
{
    if(tile.get())shader.define("DO_TILEABLE");
        else shader.removeDefine("DO_TILEABLE");
}

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    uniAspect.set( cgl.currentTextureEffect.getCurrentSourceTexture().width / cgl.currentTextureEffect.getCurrentSourceTexture().height );

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.FBMNoise.prototype = new CABLES.Op();
CABLES.OPS["7073186c-b776-48c2-a01e-041df88ad88a"]={f:Ops.Gl.TextureEffects.Noise.FBMNoise,objName:"Ops.Gl.TextureEffects.Noise.FBMNoise"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.EdgeDetectionFreiChen
// 
// **************************************************************

Ops.Gl.TextureEffects.EdgeDetectionFreiChen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={edgeFreiChen_frag:"/**\n * @author zz85 / https://github.com/zz85 | https://www.lab4games.net/zz85/blog\n *\n * Edge Detection Shader using Frei-Chen filter\n * Based on http://rastergrid.com/blog/2011/01/frei-chen-edge-detector\n *\n */\n\n\nuniform float texWidth;\nuniform float texHeight;\nuniform float amount;\n\nuniform sampler2D tex;\nIN vec2 texCoord;\n\nmat3 G[9];\n// hard coded matrix values!!!! as suggested in https://github.com/neilmendoza/ofxPostProcessing/blob/master/src/EdgePass.cpp#L45\nconst mat3 g0 = mat3( 0.3535533845424652, 0, -0.3535533845424652, 0.5, 0, -0.5, 0.3535533845424652, 0, -0.3535533845424652 );\nconst mat3 g1 = mat3( 0.3535533845424652, 0.5, 0.3535533845424652, 0, 0, 0, -0.3535533845424652, -0.5, -0.3535533845424652 );\nconst mat3 g2 = mat3( 0, 0.3535533845424652, -0.5, -0.3535533845424652, 0, 0.3535533845424652, 0.5, -0.3535533845424652, 0 );\nconst mat3 g3 = mat3( 0.5, -0.3535533845424652, 0, -0.3535533845424652, 0, 0.3535533845424652, 0, 0.3535533845424652, -0.5 );\nconst mat3 g4 = mat3( 0, -0.5, 0, 0.5, 0, 0.5, 0, -0.5, 0 );\nconst mat3 g5 = mat3( -0.5, 0, 0.5, 0, 0, 0, 0.5, 0, -0.5 );\nconst mat3 g6 = mat3( 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.6666666865348816, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204 );\nconst mat3 g7 = mat3( -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, 0.6666666865348816, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408 );\nconst mat3 g8 = mat3( 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408 );\n\nvoid main(void)\n{\n    vec2 texel = vec2(amount / texWidth,amount / texHeight);\n\n\tG[0] = g0,\n\tG[1] = g1,\n\tG[2] = g2,\n\tG[3] = g3,\n\tG[4] = g4,\n\tG[5] = g5,\n\tG[6] = g6,\n\tG[7] = g7,\n\tG[8] = g8;\n\n\tmat3 I;\n\tfloat cnv[9];\n\tvec3 smpl;\n\n\t/* fetch the 3x3 neighbourhood and use the RGB vector's length as intensity value */\n\tfor (float i=0.0; i<3.0; i++) {\n\t\tfor (float j=0.0; j<3.0; j++) {\n\t\t\tsmpl = texture(tex, texCoord + texel * vec2(i-1.0,j-1.0) ).rgb;\n\t\t\tI[int(i)][int(j)] = length(smpl);\n\t\t}\n\t}\n\n\t/* calculate the convolution values for all the masks */\n\tfor (int i=0; i<9; i++) {\n\t\tfloat dp3 = dot(G[i][0], I[0]) + dot(G[i][1], I[1]) + dot(G[i][2], I[2]);\n\t\tcnv[i] = dp3 * dp3;\n\t}\n\n\tfloat M = (cnv[0] + cnv[1]) + (cnv[2] + cnv[3]);\n\tfloat S = (cnv[4] + cnv[5]) + (cnv[6] + cnv[7]) + (cnv[8] + M);\n\n\toutColor= vec4(vec3(sqrt(M/S)), texture( tex, texCoord ).a )*2.0;\n\n}\n",};

var render=op.inTrigger("Render");
var trigger=op.outTrigger("Trigger");



var amount=op.inValueSlider("amount",1);

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);




shader.setSource(shader.getDefaultVertexShader(),attachments.edgeFreiChen_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);

var uniWidth=new CGL.Uniform(shader,'f','texWidth',128);
var uniHeight=new CGL.Uniform(shader,'f','texHeight',128);


render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.EdgeDetectionFreiChen.prototype = new CABLES.Op();
CABLES.OPS["deb29424-cebd-4003-a88a-1c375f877d86"]={f:Ops.Gl.TextureEffects.EdgeDetectionFreiChen,objName:"Ops.Gl.TextureEffects.EdgeDetectionFreiChen"};




// **************************************************************
// 
// Ops.Gl.Meshes.PointCloudFromArray
// 
// **************************************************************

Ops.Gl.Meshes.PointCloudFromArray = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    arr=op.inArray("Array"),
    numPoints=op.inValueInt("Num Points"),
    outTrigger = op.outTrigger("Trigger out"),
    outGeom=op.outObject("Geometry"),
    pTexCoordRand=op.inValueBool("Scramble Texcoords",true),
    seed=op.inValue("Seed"),
    inCoords=op.inArray("Coordinates"),
    vertCols=op.inArray("Vertex Colors");

const cgl=op.patch.cgl;

inCoords.onChange=updateTexCoordsPorts;
pTexCoordRand.onChange=updateTexCoordsPorts;
seed.onChange=arr.onChange=reset;
numPoints.onChange=updateNumVerts;

op.toWorkPortsNeedToBeLinked(arr,exe);

var hasError=false;
var showingError=false;

exe.onTriggered=doRender;

var mesh=null;
const geom=new CGL.Geometry("pointcloudfromarray");
var texCoords=[];
var needsRebuild=true;

function doRender()
{
    outTrigger.trigger();
    if(CABLES.UI)
    {
        var shader=cgl.getShader();
        if(shader && shader.glPrimitive!=cgl.gl.POINTS)
        {
            if(!hasError)
            {
                op.uiAttr( { 'warning': 'using a Material not made for point rendering. maybe use pointMaterial.' } );
                hasError=true;
            }
            return;
        }
        if(hasError)
        {
            op.uiAttr({'warning':null});
            hasError=false;
        }
    }

    if(needsRebuild || !mesh)rebuild();
    if(mesh) mesh.render(cgl.getShader());
}

function reset()
{
    needsRebuild=true;
}

function updateTexCoordsPorts()
{
    if(inCoords.isLinked())
    {
        seed.setUiAttribs({greyout:true});
        pTexCoordRand.setUiAttribs({greyout:true});
    }
    else
    {
        pTexCoordRand.setUiAttribs({greyout:false});

        if(!pTexCoordRand.get()) seed.setUiAttribs({greyout:true});
           else seed.setUiAttribs({greyout:false});
    }

    needsRebuild=true;
}

function updateNumVerts()
{
    if(mesh)
    {
        mesh.setNumVertices( Math.min(geom.vertices.length/3,numPoints.get()));
        if(numPoints.get()==0)mesh.setNumVertices(geom.vertices.length/3);
    }
}

function rebuild()
{
    var verts=arr.get();

    if(!verts || verts.length==0)
    {
        mesh=null;
        return;
    }

    if(showingError)
    {
        showingError = false;
        op.uiAttr({error:null});
    }

    var divisibleBy3 = verts.length % 3 === 0;

    if(divisibleBy3 === false)
    {
        if(!showingError)
        {
            op.uiAttr({error:"Array length not divisible by 3!"});
            showingError = true;
        }
        return;
    }

    geom.clear();
    var num=verts.length/3;
    num=Math.abs(Math.floor(num));

    // console.log("num",num);
    if(num==0)return;

    if(!texCoords || texCoords.length!=num*2) texCoords=new Float32Array(num*2); //num*2;//=

    var changed=false;
    var rndTc=pTexCoordRand.get();

    Math.randomSeed=seed.get();
    var genCoords=!inCoords.isLinked();
    changed=!inCoords.isLinked();

    for(var i=0;i<num;i++)
    {
        if(geom.vertices[i*3]!=verts[i*3] ||
            geom.vertices[i*3+1]!=verts[i*3+1] ||
            geom.vertices[i*3+2]!=verts[i*3+2])
        {
            if(genCoords)
            if(rndTc)
            {
                texCoords[i*2]=Math.seededRandom();
                texCoords[i*2+1]=Math.seededRandom();
            }
            else
            {
                texCoords[i*2]=i/num;
                texCoords[i*2+1]=i/num;
            }
            changed=true;
        }
    }

    if(vertCols.get())
    {
        if(!showingError && vertCols.get().length!=num*4)
        {
            op.uiAttr({error:"Color array does not have the correct length! (should be "+num*4+")"});
            showingError = true;
            mesh=null;
            return;
        }

        geom.vertexColors=vertCols.get();
    }
    else geom.vertexColors=[];

    if(changed)
    {
        if(!genCoords) texCoords = inCoords.get();

        geom.setPointVertices(verts);
        geom.setTexCoords(texCoords);
        geom.verticesIndices=[];

        if(mesh)mesh.dispose();
        mesh=new CGL.Mesh(cgl,geom,cgl.gl.POINTS);

        mesh.addVertexNumbers=true;
        mesh.setGeom(geom);
        outGeom.set(geom);
    }

    updateNumVerts();
    needsRebuild=false;
}





};

Ops.Gl.Meshes.PointCloudFromArray.prototype = new CABLES.Op();
CABLES.OPS["0a6d9c6f-6459-45ca-88ad-268a1f7304db"]={f:Ops.Gl.Meshes.PointCloudFromArray,objName:"Ops.Gl.Meshes.PointCloudFromArray"};




// **************************************************************
// 
// Ops.Gl.GlPrimitive
// 
// **************************************************************

Ops.Gl.GlPrimitive = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exec=op.inTrigger("Execute");
var next=op.outTrigger("Next");

var prim=op.inValueSelect("Primitive",['LINES','LINE_STRIP','LINE_LOOP','POINTS','TRIANGLES','TRIANGLE_FAN','TRIANGLE_STRIP'],'LINES');
var cgl=op.patch.cgl;

var glPrim=cgl.gl.LINES;

prim.onChange=function()
{
    if(prim.get()=='LINES')glPrim=cgl.gl.LINES;
    if(prim.get()=='LINE_STRIP')glPrim=cgl.gl.LINE_STRIP;
    if(prim.get()=='LINE_LOOP')glPrim=cgl.gl.LINE_LOOP;
    if(prim.get()=='POINTS')glPrim=cgl.gl.POINTS;
    if(prim.get()=='TRIANGLES')glPrim=cgl.gl.TRIANGLES;
    if(prim.get()=='TRIANGLE_FAN')glPrim=cgl.gl.TRIANGLE_FAN;
    if(prim.get()=='TRIANGLE_STRIP')glPrim=cgl.gl.TRIANGLE_STRIP;
};

exec.onTriggered=function()
{
    var shader=cgl.getShader();
    if(!shader)return;
    var oldPrim=shader.glPrimitive;
    shader.glPrimitive=glPrim;///cgl.gl.LINE_STRIP;
    // GL_TRIANGLE_STRIP
    // shader.glPrimitive=cgl.gl.LINE_LOOP;
    // shader.glPrimitive=cgl.gl.LINES;
    // shader.glPrimitive=cgl.gl.POINTS;

    next.trigger();

    shader.glPrimitive=oldPrim;

};

};

Ops.Gl.GlPrimitive.prototype = new CABLES.Op();
CABLES.OPS["ef0bae7e-32c9-4815-9ac3-9439fc1194ee"]={f:Ops.Gl.GlPrimitive,objName:"Ops.Gl.GlPrimitive"};




// **************************************************************
// 
// Ops.Array.RandomNumbersArray3
// 
// **************************************************************

Ops.Array.RandomNumbersArray3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    numValues=op.inValueInt("numValues",100),
    min=op.inValueFloat("Min",-1),
    max=op.inValueFloat("Max",1),
    seed=op.inValueFloat("random seed"),
    closed=op.inValueBool("Last == First"),
    inInteger=op.inValueBool("Integer",false),
    values=op.outArray("values"),
    outTotalPoints = op.outNumber("Total points"),
    outArrayLength = op.outNumber("Array length");

op.setPortGroup("Value Range",[min,max]);
op.setPortGroup("",[seed,closed]);

values.ignoreValueSerialize=true;

closed.onChange=max.onChange=
    min.onChange=
    numValues.onChange=
    seed.onChange=
    values.onLinkChanged=
    inInteger.onChange=init;

var arr=[];
init();

function init()
{
    Math.randomSeed=seed.get();

    var isInteger=inInteger.get();

    var arrLength = arr.length=Math.floor(Math.abs(numValues.get()*3));
    for(var i=0;i<arrLength;i+=3)
    {
        if(!isInteger)
        {
            arr[i+0]=Math.seededRandom() * ( max.get() - min.get() ) + min.get() ;
            arr[i+1]=Math.seededRandom() * ( max.get() - min.get() ) + min.get() ;
            arr[i+2]=Math.seededRandom() * ( max.get() - min.get() ) + min.get() ;
        }
        else
        {
            arr[i+0]=Math.floor(Math.seededRandom() * ( max.get() - min.get() ) + min.get()) ;
            arr[i+1]=Math.floor(Math.seededRandom() * ( max.get() - min.get() ) + min.get()) ;
            arr[i+2]=Math.floor(Math.seededRandom() * ( max.get() - min.get() ) + min.get()) ;
        }
    }

    if(closed.get() && arrLength>3)
    {
        arr[arrLength-3+0]=arr[0];
        arr[arrLength-3+1]=arr[1];
        arr[arrLength-3+2]=arr[2];
    }

    values.set(null);
    values.set(arr);
    outTotalPoints.set(arrLength/3);
    outArrayLength.set(arrLength);
};


};

Ops.Array.RandomNumbersArray3.prototype = new CABLES.Op();
CABLES.OPS["7f981578-542e-417b-b304-8fbe41258772"]={f:Ops.Array.RandomNumbersArray3,objName:"Ops.Array.RandomNumbersArray3"};




// **************************************************************
// 
// Ops.Html.FontFile
// 
// **************************************************************

Ops.Html.FontFile = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    filename=op.inFile("file"),
    fontname=op.inValueString("family"),
    outLoaded=op.outValue("Loaded"),
    loadedTrigger=op.outTrigger("Loaded Trigger");

filename.onChange=function()
    {
        outLoaded.set(false);
        addStyle();
    };

fontname.onChange=addStyle;

var fontFaceObj;

function addStyle()
{
    if(filename.get() && fontname.get())
    {
        if(document.fonts) {
            fontFaceObj = new FontFace(fontname.get(), 'url(' + op.patch.getFilePath(String(filename.get()))+ ')');
            //console.log(fontFaceObj);

            // Add the FontFace to the FontFaceSet
            document.fonts.add(fontFaceObj);

            // Get the current status of the FontFace
            // (should be 'unloaded')
            // console.info('Current status', fontFaceObj.status);

            // Load the FontFace
            fontFaceObj.load();

            // Get the current status of the Fontface
            // (should be 'loading' or 'loaded' if cached)
            // console.info('Current status', fontFaceObj.status);

            // Wait until the font has been loaded, log the current status.
            fontFaceObj.loaded.then((fontFace) => {
                // console.info('Current status', fontFace.status);
                // console.log(fontFace.family, 'loaded successfully.');
                outLoaded.set(true);
                loadedTrigger.trigger();

                // Throw an error if loading wasn't successful
            }, (fontFace) => {
            console.error('Font loading error! Current status', fontFaceObj.status);
            });
        } else { // font loading api not supported
            var fileUrl=op.patch.getFilePath(String(filename.get()));
            var styleStr=''
                .endl()+'@font-face'
                .endl()+'{'
                .endl()+'  font-family: "'+fontname.get()+'";'
                .endl()+'  src: url("'+fileUrl+'") format("truetype");'
                .endl()+'}';

            var style = document.createElement('style');
            style.type = 'text/css';
            style.innerHTML = styleStr;
            document.getElementsByTagName('head')[document.getElementsByTagName('head').length-1].appendChild(style);
            // TODO: Poll if font loaded
        }
    }
}


};

Ops.Html.FontFile.prototype = new CABLES.Op();
CABLES.OPS["0cf90109-cccd-4633-9c77-8aaf53eae15c"]={f:Ops.Html.FontFile,objName:"Ops.Html.FontFile"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.WaveformGradient
// 
// **************************************************************

Ops.Gl.TextureEffects.WaveformGradient = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={waveform_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float uFreq;\nUNI float uOffset;\nUNI float uPow;\nUNI float uRotate;\nUNI float amount;\n\n{{CGL.BLENDMODES}}\n\n#define PI 3.14159265359\n#define TAU (2.0 * PI)\n\nvoid pR(inout vec2 p, float a)\n{\n    float s = sin(a),c=cos(a); p *= mat2(c,s,-s,c);\n}\n\nfloat pModMirror1(inout float p, float size) {\n\tfloat halfsize = size * 0.5;\n\tfloat c = floor((p + halfsize)/size);\n\tp = mod(p + halfsize,size) - halfsize;\n\tp *= mod(c, 2.0) * 2.0 - 1.0;\n\treturn c;\n}\n\nvoid main()\n{\n    vec2 uv = texCoord;\n    float v = 0.0;\n\n    uv -= 0.5;\n    pR(uv,TAU * uRotate);\n    uv += 0.5 + uOffset;\n\n    uv.x *= uFreq;\n\n    #ifdef MODE_SINE\n        uv.x += 0.5;\n        pModMirror1(uv.x,1.0);\n        v = pow(cos(PI * uv.x / 2.0),uPow);\n    #endif\n\n    #ifdef MODE_SAW\n        uv.x = mod(uv.x,1.0);\n        v = pow(min(cos(PI * uv.x /2.0),1.0 - abs(uv.x)),uPow);\n    #endif\n\n    #ifdef MODE_TRI\n        uv.x += 0.5;\n        pModMirror1(uv.x,1.0);\n        uv.x = -abs(uv.x);\n        uv.x = fract(uv.x);\n        v = pow(uv.x,uPow);\n    #endif\n\n    vec4 col = vec4(v,v,v,1.0);\n    vec4 base = texture(tex,texCoord);\n\n    outColor = cgl_blend(base,col,amount);;\n}\n",};
const
    render=op.inTrigger("render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    mode=op.inValueSelect("Mode",['Sine','Sawtooth','Triangle'],'Sine'),
    freq=op.inValue("Frequency",4),
    pow=op.inValue("Pow factor",6),
    offset=op.inValue("Offset",0),
    rotate=op.inValue("Rotate",0),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.waveform_frag );

mode.onChange=updateMode;

const
    textureUniform=new CGL.Uniform(shader,'t','tex',0),
    freqUniform=new CGL.Uniform(shader,'f','uFreq',freq),
    offsetUniform=new CGL.Uniform(shader,'f','uOffset',offset),
    powUniform=new CGL.Uniform(shader,'f','uPow',pow),
    rotateUniform=new CGL.Uniform(shader,'f','uRotate',rotate),

    amountUniform=new CGL.Uniform(shader,'f','amount',amount);

updateMode();

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

function updateMode()
{
    shader.removeDefine("MODE_SAW");
    shader.removeDefine("MODE_SINE");
    shader.removeDefine("MODE_TRI");

    if(mode.get()=='Sine')shader.define("MODE_SINE");
    else if(mode.get()=='Sawtooth')shader.define("MODE_SAW");
    else if(mode.get()=='Triangle')shader.define("MODE_TRI");

}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.WaveformGradient.prototype = new CABLES.Op();
CABLES.OPS["d8d0ab9a-3cd9-4f91-9d9f-953b515c7c7f"]={f:Ops.Gl.TextureEffects.WaveformGradient,objName:"Ops.Gl.TextureEffects.WaveformGradient"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.DepthTextureFocus
// 
// **************************************************************

Ops.Gl.TextureEffects.DepthTextureFocus = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={depth_focus_frag:"IN vec2 texCoord;\nUNI sampler2D image;\nUNI float n;\nUNI float f;\nUNI float focus;\nUNI float width;\n\nvoid main()\n{\n    vec4 col=texture(image,texCoord);\n    float z=col.r;\n    float c=(2.0*n)/(f+n-z*(f-n));\n\n    c=abs( c-focus );\n    c=smoothstep(0.0,width,c);\n\n    #ifndef INVERT\n        c=1.0-c;\n    #endif\n\n    outColor = vec4(c,c,c,1.0);\n}",};
const render=op.inTrigger('render');
const image=op.inTexture("image");
const farPlane=op.inValue("farplane",100);
const nearPlane=op.inValue("nearplane",0.1);
const inInv=op.inValueBool("Invert",false);
const inFocus=op.inValueSlider("Center",0.5);
const inWidth=op.inValueSlider("Width",0.2);
const trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;

const shader=new CGL.Shader(cgl);
const srcFrag=attachments.depth_focus_frag||'';
shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const textureUniform=new CGL.Uniform(shader,'t','image',0);
const uniFarplane=new CGL.Uniform(shader,'f','f',farPlane);
const uniNearplane=new CGL.Uniform(shader,'f','n',nearPlane);
const uniFocus=new CGL.Uniform(shader,'f','focus',inFocus);
const uniwidth=new CGL.Uniform(shader,'f','width',inWidth);

inInv.onChange=function()
{
    if(inInv.get())shader.define("INVERT");
        else shader.removeDefine("INVERT");
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(image.val && image.val.tex)
    {
        cgl.setShader(shader);
        cgl.currentTextureEffect.bind();


        cgl.setTexture(0,image.get().tex);

        cgl.currentTextureEffect.finish();
        cgl.setPreviousShader();
    }

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.DepthTextureFocus.prototype = new CABLES.Op();
CABLES.OPS["d11b89b2-c2e3-4fcb-b4da-632d23b69075"]={f:Ops.Gl.TextureEffects.DepthTextureFocus,objName:"Ops.Gl.TextureEffects.DepthTextureFocus"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Flip
// 
// **************************************************************

Ops.Gl.TextureEffects.Flip = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={flip_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float x;\nUNI float y;\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n   col=texture(tex,vec2(abs(x-texCoord.x),abs(y-texCoord.y)));\n   outColor= col;\n}",};
const render=op.inTrigger("render");
const x=op.inValueBool("X");
const y=op.inValueBool("Y");
const trigger=op.outTrigger("trigger")

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.flip_frag);

const uniTexture=new CGL.Uniform(shader,'t','tex',0);
const uniX=new CGL.Uniform(shader,'f','x',x);
const uniY=new CGL.Uniform(shader,'f','y',y);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Flip.prototype = new CABLES.Op();
CABLES.OPS["ce36ad01-411a-412f-affa-1959aa23f93b"]={f:Ops.Gl.TextureEffects.Flip,objName:"Ops.Gl.TextureEffects.Flip"};




// **************************************************************
// 
// Ops.Gl.Shader.PointMaterial
// 
// **************************************************************

Ops.Gl.Shader.PointMaterial = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={shader_frag:"\n{{MODULES_HEAD}}\n\nIN vec2 texCoord;\n#ifdef HAS_TEXTURES\n\n   #ifdef HAS_TEXTURE_DIFFUSE\n       UNI sampler2D diffTex;\n   #endif\n   #ifdef HAS_TEXTURE_MASK\n       UNI sampler2D texMask;\n   #endif\n#endif\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\n#ifdef VERTEX_COLORS\n    IN vec3 vertexColor;\n#endif\n\nvoid main()\n{\n    {{MODULE_BEGIN_FRAG}}\n\n    vec4 col=vec4(r,g,b,a);\n\n    #ifdef HAS_TEXTURES\n\n        #ifdef HAS_TEXTURE_MASK\n            float mask;\n            #ifdef LOOKUP_TEXTURE\n                mask=texture(texMask,texCoord).r;\n            #endif\n            #ifndef LOOKUP_TEXTURE\n                mask=texture(texMask,vec2(gl_PointCoord.x,(1.0-gl_PointCoord.y))).r;\n            #endif\n\n        #endif\n\n        #ifdef HAS_TEXTURE_DIFFUSE\n\n            #ifdef LOOKUP_TEXTURE\n                col=texture(diffTex,texCoord);\n            #endif\n            #ifndef LOOKUP_TEXTURE\n                col=texture(diffTex,vec2(gl_PointCoord.x,(1.0-gl_PointCoord.y)));\n            #endif\n\n            #ifdef COLORIZE_TEXTURE\n              col.r*=r;\n              col.g*=g;\n              col.b*=b;\n            #endif\n        #endif\n        col.a*=a;\n    #endif\n\n    {{MODULE_COLOR}}\n\n    #ifdef MAKE_ROUND\n        if ((gl_PointCoord.x-0.5)*(gl_PointCoord.x-0.5) + (gl_PointCoord.y-0.5)*(gl_PointCoord.y-0.5) > 0.25) discard; //col.a=0.0;\n    #endif\n\n    #ifdef VERTEX_COLORS\n        col.rgb*=vertexColor;\n    #endif\n\n\n    #ifdef HAS_TEXTURE_MASK\n        col.a=mask;\n    #endif\n\n\n    // #ifdef RANDOMIZE_COLOR\n        // col.rgb*=fract(sin(dot(texCoord.xy ,vec2(12.9898,78.233))) * 43758.5453);\n    // #endif\n\n\n\n    outColor = col;\n}\n",shader_vert:"{{MODULES_HEAD}}\nIN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\n   IN vec3 attrTangent;\n   IN vec3 attrBiTangent;\n\n#ifdef VERTEX_COLORS\n    IN vec3 attrVertColor;\n    OUT vec3 vertexColor;\n#endif\n\nOUT vec3 norm;\n#ifdef HAS_TEXTURES\n    OUT vec2 texCoord;\n#endif\n\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\nUNI float pointSize;\nUNI vec3 camPos;\n\nUNI float canvasWidth;\nUNI float canvasHeight;\nUNI float camDistMul;\n\nUNI float randomSize;\n\nIN float attrVertIndex;\n\n\nfloat rand(float n){return fract(sin(n) * 43758.5453123);}\n\n#define POINTMATERIAL\n\nvoid main()\n{\n    float psMul=sqrt(canvasWidth/canvasHeight)+0.00000000001;\n    float sizeMultiply=1.0;\n\n    vec3 tangent=attrTangent;\n    vec3 bitangent=attrBiTangent;\n\n\n    #ifdef VERTEX_COLORS\n        vertexColor=attrVertColor;\n    #endif\n\n    #ifdef HAS_TEXTURES\n        texCoord=attrTexCoord;\n    #endif\n\n    mat4 mMatrix=modelMatrix;\n\n    vec4 pos = vec4( vPosition, 1. );\n\n    {{MODULE_VERTEX_POSITION}}\n\n    vec4 model=mMatrix * pos;\n\n    psMul+=rand(attrVertIndex)*randomSize;\n\n    psMul*=sizeMultiply;\n\n    #ifndef SCALE_BY_DISTANCE\n        gl_PointSize = pointSize * psMul;\n    #endif\n    #ifdef SCALE_BY_DISTANCE\n        float cameraDist = distance(model.xyz, camPos);\n        gl_PointSize = (pointSize / cameraDist) * psMul;\n    #endif\n\n    gl_Position = projMatrix * viewMatrix * model;\n}\n",};
const cgl=op.patch.cgl;

const
    render=op.inTrigger("render"),
    pointSize=op.inValueFloat("PointSize",3),
    randomSize=op.inValue("Random Size",3),
    makeRound=op.inValueBool("Round",true),
    doScale=op.inValueBool("Scale by Distance",false),
    r = op.inValueSlider("r", Math.random()),
    g = op.inValueSlider("g", Math.random()),
    b = op.inValueSlider("b", Math.random()),
    a = op.inValueSlider("a",1),
    preMultipliedAlpha=op.inValueBool("preMultiplied alpha"),
    vertCols=op.inBool("Vertex Colors",false),
    texture=op.inTexture("texture"),
    textureMask=op.inTexture("Texture Mask"),
    colorizeTexture=op.inValueBool("colorizeTexture",false),
    textureLookup=op.inValueBool("texture Lookup",false),
    trigger=op.outTrigger('trigger'),
    shaderOut=op.outObject("shader");

op.setPortGroup("Texture",[textureLookup,textureMask,texture,colorizeTexture]);
op.setPortGroup("Color",[r,g,b,a,preMultipliedAlpha,vertCols]);
op.setPortGroup("Size",[pointSize,randomSize,makeRound,doScale]);
r.setUiAttribs({ colorPick: true });

const shader=new CGL.Shader(cgl,'PointMaterial');
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.define('MAKE_ROUND');

const
    uniPointSize=new CGL.Uniform(shader,'f','pointSize',pointSize),
    uniRandomSize=new CGL.Uniform(shader,'f','randomSize',randomSize),
    runiform=new CGL.Uniform(shader,'f','r',r),
    guniform=new CGL.Uniform(shader,'f','g',g),
    buniform=new CGL.Uniform(shader,'f','b',b),
    auniform=new CGL.Uniform(shader,'f','a',a),
    uniWidth=new CGL.Uniform(shader,'f','canvasWidth',cgl.canvasWidth),
    uniHeight=new CGL.Uniform(shader,'f','canvasHeight',cgl.canvasHeight);

shaderOut.set(shader);
shader.setSource(attachments.shader_vert,attachments.shader_frag);
shader.glPrimitive=cgl.gl.POINTS;
shader.bindTextures=bindTextures;
shaderOut.ignoreValueSerialize=true;

render.onTriggered=doRender;

var textureUniform=null;
var textureMaskUniform=null;

op.preRender=function()
{
    if(shader)shader.bind();
    doRender();
};

function bindTextures()
{
    if(texture.get()) cgl.setTexture(0,texture.get().tex);
    if(textureMask.get()) cgl.setTexture(1,textureMask.get().tex);
}

function doRender()
{
    uniWidth.setValue(cgl.canvasWidth);
    uniHeight.setValue(cgl.canvasHeight);

    cgl.setShader(shader);
    bindTextures();
    if(preMultipliedAlpha.get())cgl.gl.blendFunc(cgl.gl.ONE, cgl.gl.ONE_MINUS_SRC_ALPHA);

    trigger.trigger();
    if(preMultipliedAlpha.get())cgl.gl.blendFunc(cgl.gl.SRC_ALPHA,cgl.gl.ONE_MINUS_SRC_ALPHA);

    cgl.setPreviousShader();
}

doScale.onChange=function()
{
    shader.toggleDefine('SCALE_BY_DISTANCE',doScale.get());
};

makeRound.onChange=function()
{
    shader.toggleDefine('MAKE_ROUND',makeRound.get());
};

colorizeTexture.onChange=function()
{
    shader.toggleDefine('COLORIZE_TEXTURE',colorizeTexture.get());
};

textureLookup.onChange=function()
{
    shader.toggleDefine('LOOKUP_TEXTURE',textureLookup.get());
};

vertCols.onChange=function()
{
    shader.toggleDefine('VERTEX_COLORS',vertCols.get());
};

texture.onChange=function()
{
    if(texture.get())
    {
        if(textureUniform!==null)return;
        shader.removeUniform('diffTex');
        shader.define('HAS_TEXTURE_DIFFUSE');
        textureUniform=new CGL.Uniform(shader,'t','diffTex',0);
    }
    else
    {
        shader.removeUniform('diffTex');
        shader.removeDefine('HAS_TEXTURE_DIFFUSE');
        textureUniform=null;
    }
};

textureMask.onChange=function()
{
    if(textureMask.get())
    {
        if(textureMaskUniform!==null)return;
        shader.removeUniform('texMask');
        shader.define('HAS_TEXTURE_MASK');
        textureMaskUniform=new CGL.Uniform(shader,'t','texMask',1);
    }
    else
    {
        shader.removeUniform('texMask');
        shader.removeDefine('HAS_TEXTURE_MASK');
        textureMaskUniform=null;
    }
};



};

Ops.Gl.Shader.PointMaterial.prototype = new CABLES.Op();
CABLES.OPS["f86a4a07-00ee-4f68-8839-e02d51d1cd2f"]={f:Ops.Gl.Shader.PointMaterial,objName:"Ops.Gl.Shader.PointMaterial"};




// **************************************************************
// 
// Ops.Json3d.Json3dScene2
// 
// **************************************************************

Ops.Json3d.Json3dScene2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.exe=op.addInPort(new CABLES.Port(op,"exe",CABLES.OP_PORT_TYPE_FUNCTION));
var filename=op.addInPort(new CABLES.Port(op,"file",CABLES.OP_PORT_TYPE_VALUE,{ display:'file',type:'string',filter:'3d json' } ));
var trigger=op.outTrigger('trigger');
var doCreate=op.inTriggerButton("Create Nodes");
var createNonMesh=op.inValueBool("Create Non Mesh Nodes");
var createMaterials=op.inValueBool("Create Materials",false);
var detectClones=op.inValueBool("Detect Clones",true);
var inReplaceMaterials=op.inObject("Mesh Materials");
var outLoading=op.outValueBool("Loading",false);

var cgl=op.patch.cgl;

var scene=new CABLES.Variable();

cgl.frameStore.currentScene=null;

doCreate.onTriggered=createNodes;

var defaultEasing=CABLES.EASING_LINEAR;
var skipFrames=1;
var frameNum=0;
var cloneTransformStore=[];
var data=null;
var prevOp=null;
filename.onChange=reload;
op.exe.onTriggered=render;

var subPatchOpStart=op;
var subPatchId=op.uiAttribs.subPatch;
var subPatchOp=null;

function render()
{
    var oldScene=cgl.frameStore.currentScene;
    cgl.frameStore.currentScene=scene;
    if(cgl.frameStore.currentScene.materials)cgl.frameStore.currentScene.materials.length=0;
    cgl.frameStore.currentScene.replaceMaterials=inReplaceMaterials.get();

    cgl.frameStore.cloneTransforms=cloneTransformStore;

    cgl.pushModelMatrix();
    trigger.trigger();
    cgl.popModelMatrix();

    cgl.frameStore.currentScene=oldScene;
}

var setPortAnimated=function(p, doLerp)
{
    p.setAnimated(true);
    if(doLerp)p.anim.defaultEasing=defaultEasing;
};



function loadMaterials(data,root)
{
    if(data.materials)
    {
        var lastSetMatop=null;
        for(var i in data.materials)
        {
            var jsonMat=data.materials[i];

            var matName='';
            for(var j in jsonMat.properties)
            {
                if(jsonMat.properties[j].key=='?mat.name')
                {
                    matName=jsonMat.properties[j].value;
                }
            }

            for(var j in jsonMat.properties)
            {

                if(createMaterials.get() && jsonMat.properties[j].key && jsonMat.properties[j].value && jsonMat.properties[j].key=='$clr.diffuse')
                {
                    const setMatOp=op.patch.addOp('Ops.Json3d.SetMaterial',{"subPatch":subPatchId});

                    setMatOp.getPort('name').set(matName);
                    setMatOp.name='Set Material '+matName;

                    var matOp=op.patch.addOp('Ops.Gl.Phong.PhongMaterial',{"subPatch":subPatchId});
                    matOp.getPort('diffuse r').set( jsonMat.properties[j].value[0] );
                    matOp.getPort('diffuse g').set( jsonMat.properties[j].value[1] );
                    matOp.getPort('diffuse b').set( jsonMat.properties[j].value[2] );
                    matOp.uiAttribs.title=matOp.name=''+matName;

                    op.patch.link(setMatOp,'material',matOp,'shader');
                    op.patch.link(setMatOp,'exe',matOp,'trigger');

                    if(lastSetMatop) op.patch.link(lastSetMatop,'trigger',matOp,'render');
                        else  op.patch.link(root,'trigger 0',matOp,'render');

                    lastSetMatop=setMatOp;
                    prevOp=matOp;
                }
            }
        }
    }
}



var loadCameras=function(data,seq)
{
    var i=0;
    var camOp=null;

    function getCamera(root,_cam)
    {
        var cam={"cam":_cam};
        for(i in root.children)
        {
            if(root.children[i].name==_cam.name)
            {
                cam.eye=root.children[i];
                cam.transformation=root.children[i].transformation;
                mat4.transpose(cam.transformation,cam.transformation);

                // guess camera target (...)
                for(var j=0;j<root.children.length;j++)
                {
                    if(root.children[j].name == root.children[i].name+'_Target')
                    {
                        console.log("Found cameratarget!");
                        cam.target=root.children[i];
                        root.children.splice(j,1);
                        root.children.splice(i,1);
                        return cam;
                    }
                }
            }
        }
        return cam;
    }


    var camSeq=null;

    if(data.hasOwnProperty('cameras'))
    {
        camSeq=op.patch.addOp('Ops.Trigger.TimedSequence',{"subPatch":subPatchId,"translate":{x:op.uiAttribs.translate.x,y:op.uiAttribs.translate.y+50}});
        op.patch.link(camSeq,'exe',op,'trigger');

        console.log("camera....");

        var camCount=0;
        for(i in data.cameras)
        {
            var cam=getCamera(data.rootnode,data.cameras[i]);

            if(cam)
            {
                if(!cam.target) continue;

                var camOp=op.patch.addOp('Ops.Gl.Matrix.QuaternionCamera',{"subPatch":subPatchId,"translate":{x:op.uiAttribs.translate.x+camCount*200,y:op.uiAttribs.translate.y+100}});
                camOp.uiAttribs.title=camOp.name='cam '+cam.cam.name;

                var an=dataGetAnimation(data,cam.cam.name);
                op.patch.link(camSeq,'trigger '+camCount,camOp,'render');
                op.patch.link(camOp,'trigger',seq,'exe '+camCount);
                camCount++;

                camOp.getPort('fov').set(cam.cam.horizontalfov);
                camOp.getPort('clip near').set(cam.cam.clipplanenear);
                camOp.getPort('clip far' ).set(cam.cam.clipplanefar);

                camOp.getPort('centerX').set(cam.cam.lookat[0]);
                camOp.getPort('centerY').set(cam.cam.lookat[1]);
                camOp.getPort('centerZ').set(cam.cam.lookat[2]);

                camOp.getPort('matrix').set(cam.transformation);

                if(an)
                {
                    if(an.positionkeys)
                    {
                        setPortAnimated(camOp.getPort('EyeX'),false);
                        setPortAnimated(camOp.getPort('EyeY'),false);
                        setPortAnimated(camOp.getPort('EyeZ'),false);

                        frameNum=skipFrames;
                        for(var k in an.positionkeys)
                        {
                            if(frameNum%skipFrames===0)
                            {
                                camOp.getPort('EyeX').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][0] );
                                camOp.getPort('EyeY').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][1] );
                                camOp.getPort('EyeZ').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][2] );
                            }
                            frameNum++;
                        }
                    }

                    if(an.rotationkeys)
                    {
                        setPortAnimated(camOp.getPort('quat x'),false);
                        setPortAnimated(camOp.getPort('quat y'),false);
                        setPortAnimated(camOp.getPort('quat z'),false);
                        setPortAnimated(camOp.getPort('quat w'),false);

                        frameNum=skipFrames;
                        for(var k in an.rotationkeys)
                        {
                            if(frameNum%skipFrames==0)
                            {
                                camOp.getPort('quat x').anim.setValue( an.rotationkeys[k][0], an.rotationkeys[k][1][0] );
                                camOp.getPort('quat y').anim.setValue( an.rotationkeys[k][0], an.rotationkeys[k][1][1] );
                                camOp.getPort('quat z').anim.setValue( an.rotationkeys[k][0], an.rotationkeys[k][1][2] );
                                camOp.getPort('quat w').anim.setValue( an.rotationkeys[k][0], an.rotationkeys[k][1][3] );
                            }
                            frameNum++;
                        }
                    }

                }
                else
                {
                    var camOp=op.patch.addOp('Ops.Gl.Matrix.LookatCamera',{"subPatch":subPatchId,"translate":{x:op.uiAttribs.translate.x+camCount*150,y:op.uiAttribs.translate.y+100}});
                    camOp.uiAttribs.title=camOp.name='cam '+cam.cam.name;
                    // op.patch.link(camOp,'render',self,'trigger');

                    op.patch.link(camSeq,'trigger '+camCount,camOp,'render');
                    op.patch.link(camOp,'trigger',seq,'exe '+camCount);
                    camCount++;

                    camOp.getPort('eyeX').set(900);
                    camOp.getPort('eyeY').set(900);
                    camOp.getPort('eyeZ').set(-240);

                    var an=dataGetAnimation(data,cam.cam.name);
                    if(an)
                    {
                        setPortAnimated(camOp.getPort('eyeX'),false);
                        setPortAnimated(camOp.getPort('eyeY'),false);
                        setPortAnimated(camOp.getPort('eyeZ'),false);

                        frameNum=skipFrames;
                        for(var k in an.positionkeys)
                        {
                            if(frameNum%skipFrames==0)
                            {
                                camOp.getPort('eyeX').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][0] );
                                camOp.getPort('eyeY').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][1] );
                                camOp.getPort('eyeZ').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][2] );
                            }
                            frameNum++;
                        }
                    }

                    var an=dataGetAnimation(data,cam.cam.name+'_Target');
                    if(an)
                    {
                        setPortAnimated(camOp.getPort('centerX'),false);
                        setPortAnimated(camOp.getPort('centerY'),false);
                        setPortAnimated(camOp.getPort('centerZ'),false);

                        frameNum=skipFrames;
                        for(var k in an.positionkeys)
                        {
                            if(frameNum%skipFrames==0)
                            {
                                camOp.getPort('centerX').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][0] );
                                camOp.getPort('centerY').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][1] );
                                camOp.getPort('centerZ').anim.setValue( an.positionkeys[k][0], an.positionkeys[k][1][2] );
                            }
                            frameNum++;
                        }
                    }
                    else
                    {
                        camOp.getPort('centerX').set(cam.target.transformation[12]);
                        camOp.getPort('centerY').set(cam.target.transformation[13]);
                        camOp.getPort('centerZ').set(cam.target.transformation[14]);

                        op.log("target not animated",cam.target.transformation[3]);
                    }
                }
            }
        }
    }

    return null;
};

function dataGetAnimation(data,name)
{
    if(!data.hasOwnProperty('animations')) return false;

    for(var iAnims in data.animations)
    {
        for(var iChannels in data.animations[iAnims].channels)
        {
            if(data.animations[iAnims].channels[iChannels].name==name)
            {
                return data.animations[iAnims].channels[iChannels];
            }
        }
    }
    return false;
}

var maxx=-3;
var row=0;

function hasMeshChildNode(n)
{
    if(createNonMesh.get())return true;
    if(n.meshes && n.meshes.length>0)return true;
    if(n.hasOwnProperty('children'))
    {
        for(var i=0;i<n.children.length;i++)
        {
            if(n.children[i].meshes && n.children[i].meshes.length>0)return true;

            var childMeshes=hasMeshChildNode(n.children[i]);
            if(childMeshes)return true;
        }
    }

    console.log('has no childs',n);

    return false;
}

function addChild(data,x,y,parentOp,parentPort,ch)
{
    if(ch.hasOwnProperty('transformation'))
    {
        maxx=Math.max(x,maxx)+1;
        var prevOp=null;

        if(data.hasOwnProperty('animations'))
        {
            var an=dataGetAnimation(data,ch.name);
            if(an)
            {
                if(an.positionkeys && an.positionkeys.length>0)
                {
                    var anTransOp=op.patch.addOp('Ops.Json3d.TranslateChannel',{"subPatch":subPatchId});
                    anTransOp.uiAttribs.title=anTransOp.name=ch.name+' trans anim';
                    anTransOp.getPort('channel').set( ch.name );
                    op.patch.link(prevOp,'trigger',anTransOp,'render');

                    if(!prevOp)op.patch.link(parentOp,parentPort,anTransOp,'render');
                    prevOp=anTransOp;
                }


                if(an.rotationkeys && an.rotationkeys.length>0)
                {
                    var anRotOp=op.patch.addOp('Ops.Json3d.QuaternionChannel',{"subPatch":subPatchId});
                    anRotOp.uiAttribs.title=anRotOp.name=ch.name+' quat rot anim';
                    anRotOp.getPort('channel').set( ch.name );
                    op.patch.link(prevOp,'trigger',anRotOp,'render');

                    if(!prevOp)op.patch.link(parentOp,parentPort,anRotOp,'render');
                    prevOp=anRotOp;
                }


                if(an.scalingkeys && an.scalingkeys.length>0)
                {
                    var anScaleOp=op.patch.addOp('Ops.Json3d.ScaleChannel',{"subPatch":subPatchId});
                    anScaleOp.uiAttribs.title=anScaleOp.name=ch.name+' scale anim';
                    anScaleOp.getPort('channel').set( ch.name );
                    op.patch.link(prevOp,'trigger',anScaleOp,'render');

                    if(!prevOp)op.patch.link(parentOp,parentPort,anScaleOp,'render');
                    prevOp=anScaleOp;
                }



            }
        }

        var sameMesh=false;

        if(detectClones.get())
        {
            sameMesh=true;

            if(ch.hasOwnProperty('children'))
            {
                // test if children are all same mesh...

                var cloneTransforms=[];
                if(ch.children.length>1 && ch.children[0].meshes && ch.children[0].meshes.length>0)
                {
                    for(i=0;i<ch.children.length;i++)
                    {
                        if(i>0 && ch.children[i].meshes)
                        {
                            if(ch.children[0].meshes && ch.children[i].meshes && ch.children[i].meshes.length==ch.children[0].meshes.length)
                            {
                                if(ch.children[i].meshes[0]==ch.children[0].meshes[0])
                                {

                                } else { sameMesh=false; }
                            } else { sameMesh=false; }
                        }

                        if(sameMesh)
                        {
                            if(!ch.children[i].transposed)
                            {
                                mat4.transpose(ch.children[i].transformation,ch.children[i].transformation);
                                ch.children[i].transposed=true;
                            }
                            cloneTransforms.push(ch.children[i].transformation);
                        }
                    }
                } else { sameMesh=false; }
            } else { sameMesh=false; }
        }

        if(!prevOp )
        {

            // console.log(ch.transformation);
            var eq=mat4.exactEquals(ch.transformation,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);

            if(!eq)
            {
                var transOp=op.patch.addOp('Ops.Gl.Matrix.MatrixMul',{"subPatch":subPatchId});

                if(!ch.transposed)
                {
                    ch.transposed=true;
                    mat4.transpose(ch.transformation,ch.transformation);
                }

                transOp.getPort('matrix').set(ch.transformation);
                prevOp=transOp;

                op.patch.link(parentOp,parentPort,prevOp,'render');
                if(ch.name) transOp.uiAttribs.title=transOp.name=ch.name;

            }
            else
                prevOp=parentOp;

        }


        var i=0;
        if(ch.hasOwnProperty('meshes') || sameMesh )
        {
            var useChildrenMeshes=false;
            var len=0;
            if(ch.meshes)
            {
                len=ch.meshes.length;
            }
            else
            {
                if(ch.children[0].meshes)
                {
                    len=ch.children[0].meshes.length;
                    useChildrenMeshes=true;
                }
            }

            // console.log('useChildrenMeshes ',useChildrenMeshes);

            for(i=0;i<len;i++)
            {
                var index=-1;

                if(!useChildrenMeshes) index=ch.meshes[i];
                    else index=ch.children[0].meshes[0];

                // material
                if(data.meshes[index].hasOwnProperty('materialindex') && data.hasOwnProperty('materials'))
                {
                    var matIndex=data.meshes[index].materialindex;
                    var jsonMat=data.materials[matIndex];

                    if(inReplaceMaterials.get() && inReplaceMaterials.get()[ch.name])
                    {
                        var matOp=op.patch.addOp('Ops.Json3d.SetMaterialShader',{"subPatch":subPatchId});
                        matOp.getPort("Key").set(ch.name);

                        var l=op.patch.link(prevOp,'trigger',matOp,'exe');

                        if(!l)
                        {
                            l=op.patch.link(parentOp,'trigger 15',matOp,'exe');
                        }

                        prevOp=matOp;
                    }
                    else
                    if(createMaterials.get())
                    {
                        var matOp=op.patch.addOp('Ops.Json3d.Material',{"subPatch":subPatchId});
                        op.patch.link(prevOp,'trigger',matOp,'exe');
                        prevOp=matOp;

                        for(var j in jsonMat.properties)
                            if(jsonMat.properties[j].key && jsonMat.properties[j].value && jsonMat.properties[j].key=='?mat.name')
                                matOp.getPort('name').set( jsonMat.properties[j].value );
                    }
                }

                if(!sameMesh)
                {
                    // mesh
                    var meshOp=op.patch.addOp('Ops.Json3d.Mesh',{"subPatch":subPatchId});
                    meshOp.index.val=index;
                    meshOp.uiAttribs.title=meshOp.name=ch.name+'';
                    var l=op.patch.link(prevOp,'trigger',meshOp,'render');

                    if(!l)
                    {
                        var l=op.patch.link(parentOp,'trigger 15',meshOp,'render');
                        console.log('prevOp link',parentOp);
                    }

                }
            }
        }


        if(ch.hasOwnProperty('children'))
        {
            console.log(ch.name+' children are clones: ',sameMesh);

            if(sameMesh)
            {
                var clonedOp=op.patch.addOp('Ops.Json3d.ClonedMesh',{"subPatch":subPatchId});

                clonedOp.getPort('transformations').set(cloneTransforms);

                cloneTransformStore.push(cloneTransforms);
                // console.log(cloneTransformStore.length+' cloneTransformStore !!!');

                op.patch.link(prevOp,'trigger',clonedOp,'render');

                var meshOp=op.patch.addOp('Ops.Json3d.Mesh',{"subPatch":subPatchId});
                meshOp.index.val=ch.children[0].meshes[0];
                meshOp.uiAttribs.title=meshOp.name='clone '+ch.name+' Mesh';
                meshOp.getPort('draw').set(false);

                op.patch.link(prevOp,'trigger',meshOp,'render');
                op.patch.link(clonedOp,'geom',meshOp,'geometry');
            }

            if(!sameMesh)
            {
                y++;
                for(i=0;i<ch.children.length;i++)
                {
                    // console.log('   child...'+i+'/'+ch.children.length);
                    var xx=maxx;
                    if(ch.children.length>1)xx++;

                    if( hasMeshChildNode(ch.children[i]) )
                        addChild(data,xx,y,prevOp,'trigger',ch.children[i]);
                }
            }

        }
    }
}

function reload()
{
    doCreate.setUiAttribs({greyout:true});
    if(!filename.get())return;

    function doLoad()
    {
        CABLES.ajax(
            op.patch.getFilePath(filename.get()),
            function(err,_data,xhr)
            {

                if(err)
                {
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});

                    console.error('ajax error:',err);
                    op.patch.loading.finished(loadingId);
                    return;
                }
                else
                {
                    if(CABLES.UI)op.uiAttr({'error':null});
                }

                try
                {
                    data=JSON.parse(_data);
                    // console.log("parsed data...");
                    // console.log(data);
                }
                catch(ex)
                {
                    outLoading.set(false);
                    op.patch.loading.finished(loadingId);
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});
                    return;
                }


                scene.setValue(data);
                doCreate.setUiAttribs({greyout:false});
                op.patch.loading.finished(loadingId);

                outLoading.set(false);
                if(CABLES.UI) gui.jobs().finish('loading3d'+loadingId);
                doCreate.setUiAttribs({greyout:false});
            });
    }


    outLoading.set(true);
    var loadingId=op.patch.loading.start('json3dScene',filename.get());
    if(CABLES.UI) gui.jobs().start({id:'loading3d'+loadingId,title:'loading 3d data'},doLoad);
        else doLoad();

};

function createNodes()
{

    if(!trigger.isLinked())
    {
        var subPatchOpStartPort='trigger';
        if(!subPatchOp)
        {
            subPatchId=op.uiAttribs.subPatch;
            subPatchOp=op.patch.addOp(CABLES.UI.OPNAME_SUBPATCH,{"subPatch":subPatchId});
            subPatchOp.setTitle("3d scene");
            subPatchId=subPatchOp.getPort("patchId").get();
            op.patch.link(op,'trigger',subPatchOp,'create port');

            var inputs=op.patch.getOpsByObjName("Ops.Ui.PatchInput");

            for(var i=0;i<inputs.length;i++)
            {
                if(inputs[i].uiAttribs.subPatch==subPatchId)
                {
                    subPatchOpStart=inputs[i];
                    subPatchOpStartPort=subPatchOpStart.portsOut[0].name;
                }
            }
        }


        var rootMatrixOp=op.patch.addOp('Ops.Gl.Matrix.MatrixMul',{"subPatch":subPatchId,"translate":{x:op.uiAttribs.translate.x,y:op.uiAttribs.translate.y+75}});
        rootMatrixOp.uiAttribs.title='rootMatrix';

        mat4.transpose(data.rootnode.transformation,data.rootnode.transformation);
        rootMatrixOp.getPort('matrix').set(data.rootnode.transformation);

        // op.patch.link(op,'trigger',rootMatrixOp,'render');
        op.patch.link(subPatchOpStart,subPatchOpStartPort,rootMatrixOp,'render');

        var root=op.patch.addOp('Ops.Sequence',{"subPatch":subPatchId,"translate":{x:op.uiAttribs.translate.x,y:op.uiAttribs.translate.y+150}});
        var camOp=loadCameras(data,root);

        if(camOp) op.patch.link(camOp,'trigger',root,'exe');
            else op.patch.link(rootMatrixOp,'trigger',root,'exe');

        loadMaterials(data,root);

        for(var i=0;i<data.rootnode.children.length;i++)
        {
            if(data.rootnode.children[i])
            {
                var ntrigger=i+2;
                if(ntrigger>9)ntrigger=9;

                if( hasMeshChildNode( data.rootnode.children[i] ))
                    addChild( data,maxx-2,3,root,'trigger '+ntrigger,data.rootnode.children[i] );
            }
        }

        if(CABLES.UI)
        {
            setTimeout(function()
            {
                // gui.patch().setSelectedOpById(op.id);
                // CABLES.CMD.PATCH.tidyChildOps();

                gui.patch().setSelectedOpById(subPatchOpStart.id);
                CABLES.CMD.PATCH.tidyChildOps();

                gui.patch().updateSubPatches();

            },100);
            gui.patch().updateSubPatches();
        }
    }
    else
    {
        if(CABLES.UI)
        {
            CABLES.UI.notifyError("remove child nodes first");

        }
    }
}






};

Ops.Json3d.Json3dScene2.prototype = new CABLES.Op();
CABLES.OPS["44f0aa70-e97d-41cf-9560-369bffa0d21c"]={f:Ops.Json3d.Json3dScene2,objName:"Ops.Json3d.Json3dScene2"};




// **************************************************************
// 
// Ops.Json3d.Mesh
// 
// **************************************************************

Ops.Json3d.Mesh = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
op.index=op.inValueInt("mesh index",0);
const draw=op.inValueBool("draw",true);
const centerPivot=op.inValueBool("center pivot",false);

const next=op.outTrigger("next");
const geometryOut=op.outObject("geometry");

geometryOut.ignoreValueSerialize=true;

const cgl=op.patch.cgl;
var meshesCache={};
var currentIndex=0;

op.index.onChange=reload;
render.onTriggered=doRender;

function doRender()
{
    var idx=op.index.get();
    var mesh=meshesCache[idx];
    if(!mesh) reload();

    if(draw.get())
    {
        if(mesh) mesh.render(cgl.getShader());
    }
    next.trigger();
}

function reload()
{
    if(!cgl.frameStore.currentScene || !cgl.frameStore.currentScene.getValue())return;
    var meshes=cgl.frameStore.currentScene.getValue().meshes;

    var mesh=null;

    const indx=op.index.get();

    if(cgl.frameStore.currentScene && cgl.frameStore.currentScene.getValue() && indx>=0)
    {
        op.uiAttr({warning:''});
        op.uiAttr({info:''});

        var jsonMesh=null;

        currentIndex=indx;

        if(CABLES.UTILS.isNumeric(indx))
        {
            if(indx<0 || indx>=cgl.frameStore.currentScene.getValue().meshes.length)
            {
                op.uiAttr({warning:'mesh not found - index out of range '});
                return;
            }

            jsonMesh=cgl.frameStore.currentScene.getValue().meshes[parseInt(indx,10) ];
        }

        if(!jsonMesh)
        {
            mesh=null;
            op.uiAttr({warning:'mesh not found'});
            return;
        }
        op.uiAttribs.warning='';

        var geom=CGL.Geometry.json2geom(jsonMesh);
        // var geom=new CGL.Geometry();
        // geom.vertices=(jsonMesh.vertices||[]).slice();
        // geom.vertexNormals=jsonMesh.normals||[];
        // geom.tangents=jsonMesh.tangents||[];
        // geom.biTangents=jsonMesh.bitangents||[];


        if(centerPivot.get()) geom.center();

        if(jsonMesh.texturecoords) geom.texCoords = jsonMesh.texturecoords[0];
        //geom.verticesIndices=[];

        //console.log(geom.verticesIndices.length);

        //for(var i=0;i<jsonMesh.faces.length;i++)
        //{
        //    geom.verticesIndices.push(jsonMesh.faces[i][0],jsonMesh.faces[i][1],jsonMesh.faces[i][2]);
        //}
        // geom.verticesIndices=[].concat.apply([], jsonMesh.faces);

        // var nfo='';
        // nfo += (geom.verticesIndices.length/3)+' faces <br/>';
        // nfo += (geom.vertices.length/3)+' vertices <br/>';
        // nfo += geom.texCoords.length+' texturecoords <br/>';
        // nfo += geom.tangents.length+' tangents <br/>';
        // nfo += geom.biTangents.length+' biTangents <br/>';
        // if(geom.vertexNormals) nfo += geom.vertexNormals.length+' normals <br/>';

        // op.uiAttr({"info":nfo});

        // var
            // indices = geom.verticesIndices || [],
            // faces = jsonMesh.faces,
            // face, i
        // ;

        // if(faces)
        //     for(i = 0; i < faces.length; i++) {
        //         face=jsonMesh.faces[i];
        //         Array.prototype.push.apply(indices, face);
        //     }

        var nfo='';
        nfo += (geom.verticesIndices.length/3)+' faces <br/>';
        nfo += (geom.vertices.length/3)+' vertices <br/>';
        nfo += (geom.texCoords?geom.texCoords.length/2:'no')+' texturecoords <br/>';
        nfo += geom.vertexNormals.length/3+' normals <br/>';
        nfo += geom.tangents.length/3+' tangents <br/>';
        nfo += geom.biTangents.length/3+' biTangents <br/>';
        op.uiAttr({"info":nfo});

        geometryOut.set(null);
        geometryOut.set(geom);
        mesh=new CGL.Mesh(cgl,geom);
        meshesCache[indx]=mesh;
    }
}

centerPivot.onChange=function()
{
    // todo: dispose meshes
    meshesCache={};

};


};

Ops.Json3d.Mesh.prototype = new CABLES.Op();
CABLES.OPS["f6fd7e38-171b-4c53-b215-c198de19c20e"]={f:Ops.Json3d.Mesh,objName:"Ops.Json3d.Mesh"};




// **************************************************************
// 
// Ops.Gl.Geometry.TransformGeometry
// 
// **************************************************************

Ops.Gl.Geometry.TransformGeometry = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    geometry=op.inObject("Geometry"),
    transX=op.inValue("Translate X"),
    transY=op.inValue("Translate Y"),
    transZ=op.inValue("Translate Z"),
    scaleX=op.inValueSlider("Scale X",1),
    scaleY=op.inValueSlider("Scale Y",1),
    scaleZ=op.inValueSlider("Scale Z",1),
    rotX=op.inValue("Rotation X"),
    rotY=op.inValue("Rotation Y"),
    rotZ=op.inValue("Rotation Z"),
    outGeom=op.outObject("Result");

transX.onChange=
    transY.onChange=
    transZ.onChange=
    scaleX.onChange=
    scaleY.onChange=
    scaleZ.onChange=
    rotX.onChange=
    rotY.onChange=
    rotZ.onChange=
    geometry.onChange=update;


function update()
{
    var oldGeom=geometry.get();
    var i=0;

    if(oldGeom)
    {
        var geom=oldGeom.copy();
        var rotVec=vec3.create();
        var emptyVec=vec3.create();
        var transVec=vec3.create();
        var centerVec=vec3.create();

        for(i=0;i<geom.vertices.length;i+=3)
        {
            geom.vertices[i+0]*=scaleX.get();
            geom.vertices[i+1]*=scaleY.get();
            geom.vertices[i+2]*=scaleZ.get();

            geom.vertices[i+0]+=transX.get();
            geom.vertices[i+1]+=transY.get();
            geom.vertices[i+2]+=transZ.get();
        }

        for(i=0;i<geom.vertices.length;i+=3)
        {
            vec3.set(rotVec,
                geom.vertices[i+0],
                geom.vertices[i+1],
                geom.vertices[i+2]);

            vec3.rotateX(rotVec,rotVec,transVec,rotX.get()*CGL.DEG2RAD);
            vec3.rotateY(rotVec,rotVec,transVec,rotY.get()*CGL.DEG2RAD);
            vec3.rotateZ(rotVec,rotVec,transVec,rotZ.get()*CGL.DEG2RAD);

            geom.vertices[i+0]=rotVec[0];
            geom.vertices[i+1]=rotVec[1];
            geom.vertices[i+2]=rotVec[2];
        }

        outGeom.set(null);
        outGeom.set(geom);
    }
    else
    {
        outGeom.set(null);
    }
}

};

Ops.Gl.Geometry.TransformGeometry.prototype = new CABLES.Op();
CABLES.OPS["9678fee2-5436-499c-b94d-2603cdbeb380"]={f:Ops.Gl.Geometry.TransformGeometry,objName:"Ops.Gl.Geometry.TransformGeometry"};




// **************************************************************
// 
// Ops.Gl.Matrix.ScaleXYZ
// 
// **************************************************************

Ops.Gl.Matrix.ScaleXYZ = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    scaleX=op.inValueFloat("x",1),
    scaleY=op.inValueFloat("y",1),
    scaleZ=op.inValueFloat("z",1),
    trigger=op.outTrigger("trigger");

const cgl=op.patch.cgl;
const vScale=vec3.create();

var hasChanged=true;

scaleX.onChange=scaleY.onChange=scaleZ.onChange=scaleChanged;

scaleChanged();

render.onTriggered=execrender;

function execrender()
{
    if(hasChanged)
    {
        vec3.set(vScale, scaleX.get(),scaleY.get(),scaleZ.get());
        hasChanged=false;
    }

    cgl.pushModelMatrix();
    mat4.scale(cgl.mMatrix,cgl.mMatrix, vScale);
    trigger.trigger();
    cgl.popModelMatrix();
}

function scaleChanged()
{
    hasChanged=true;
}



};

Ops.Gl.Matrix.ScaleXYZ.prototype = new CABLES.Op();
CABLES.OPS["9ba52457-5f0d-4b20-a97c-4ec4856b8e29"]={f:Ops.Gl.Matrix.ScaleXYZ,objName:"Ops.Gl.Matrix.ScaleXYZ"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.PerlinAreaDeform_v3
// 
// **************************************************************

Ops.Gl.ShaderEffects.PerlinAreaDeform_v3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={perlindeform_vert:"\nUNI bool MOD_smooth;\nUNI float MOD_x,MOD_y,MOD_z;\nUNI float MOD_strength;\nUNI float MOD_size;\nUNI float MOD_scale;\nUNI float MOD_mScale;\nUNI float MOD_scrollx;\nUNI float MOD_scrolly;\nUNI float MOD_scrollz;\nUNI float MOD_fallOff;\n\nvec3 MOD_newTangent,MOD_newBiTangent;\n\n\n\n#ifndef PERLINDEFORM\n#define PERLINDEFORM\nfloat Interpolation_C2( float x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }   //  6x^5-15x^4+10x^3\t( Quintic Curve.  As used by Perlin in Improved Noise.  http://mrl.nyu.edu/~perlin/paper445.pdf )\nvec2 Interpolation_C2( vec2 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec3 Interpolation_C2( vec3 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2( vec4 x ) { return x * x * x * (x * (x * 6.0 - 15.0) + 10.0); }\nvec4 Interpolation_C2_InterpAndDeriv( vec2 x ) { return x.xyxy * x.xyxy * ( x.xyxy * ( x.xyxy * ( x.xyxy * vec2( 6.0, 0.0 ).xxyy + vec2( -15.0, 30.0 ).xxyy ) + vec2( 10.0, -60.0 ).xxyy ) + vec2( 0.0, 30.0 ).xxyy ); }\nvec3 Interpolation_C2_Deriv( vec3 x ) { return x * x * (x * (x * 30.0 - 60.0) + 30.0); }\n\n\nvoid FAST32_hash_3D( \tvec3 gridcell,\n                        out vec4 lowz_hash_0,\n                        out vec4 lowz_hash_1,\n                        out vec4 lowz_hash_2,\n                        out vec4 highz_hash_0,\n                        out vec4 highz_hash_1,\n                        out vec4 highz_hash_2\t)\t\t//\tgenerates 3 random numbers for each of the 8 cell corners\n{\n    //    gridcell is assumed to be an integer coordinate\n\n    //\tTODO: \tthese constants need tweaked to find the best possible noise.\n    //\t\t\tprobably requires some kind of brute force computational searching or something....\n    const vec2 OFFSET = vec2( 50.0, 161.0 );\n    const float DOMAIN = 69.0;\n    const vec3 SOMELARGEFLOATS = vec3( 635.298681, 682.357502, 668.926525 );\n    const vec3 ZINC = vec3( 48.500388, 65.294118, 63.934599 );\n\n    //\ttruncate the domain\n    gridcell.xyz = gridcell.xyz - floor(gridcell.xyz * ( 1.0 / DOMAIN )) * DOMAIN;\n    vec3 gridcell_inc1 = step( gridcell, vec3( DOMAIN - 1.5 ) ) * ( gridcell + 1.0 );\n\n    //\tcalculate the noise\n    vec4 P = vec4( gridcell.xy, gridcell_inc1.xy ) + OFFSET.xyxy;\n    P *= P;\n    P = P.xzxz * P.yyww;\n    vec3 lowz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell.zzz * ZINC.xyz ) );\n    vec3 highz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell_inc1.zzz * ZINC.xyz ) );\n    lowz_hash_0 = fract( P * lowz_mod.xxxx );\n    highz_hash_0 = fract( P * highz_mod.xxxx );\n    lowz_hash_1 = fract( P * lowz_mod.yyyy );\n    highz_hash_1 = fract( P * highz_mod.yyyy );\n    lowz_hash_2 = fract( P * lowz_mod.zzzz );\n    highz_hash_2 = fract( P * highz_mod.zzzz );\n}\n\n//\n//\tPerlin Noise 3D  ( gradient noise )\n//\tReturn value range of -1.0->1.0\n//\thttp://briansharpe.files.wordpress.com/2011/11/perlinsample.jpg\n//\nfloat Perlin3D( vec3 P )\n{\n    //\testablish our grid cell and unit position\n    vec3 Pi = floor(P);\n    vec3 Pf = P - Pi;\n    vec3 Pf_min1 = Pf - 1.0;\n\n#if 1\n    //\n    //\tclassic noise.\n    //\trequires 3 random values per point.  with an efficent hash function will run faster than improved noise\n    //\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hashx0, hashy0, hashz0, hashx1, hashy1, hashz1;\n    FAST32_hash_3D( Pi, hashx0, hashy0, hashz0, hashx1, hashy1, hashz1 );\n    //SGPP_hash_3D( Pi, hashx0, hashy0, hashz0, hashx1, hashy1, hashz1 );\n\n    //\tcalculate the gradients\n    vec4 grad_x0 = hashx0 - 0.49999;\n    vec4 grad_y0 = hashy0 - 0.49999;\n    vec4 grad_z0 = hashz0 - 0.49999;\n    vec4 grad_x1 = hashx1 - 0.49999;\n    vec4 grad_y1 = hashy1 - 0.49999;\n    vec4 grad_z1 = hashz1 - 0.49999;\n    vec4 grad_results_0 = inversesqrt( grad_x0 * grad_x0 + grad_y0 * grad_y0 + grad_z0 * grad_z0 ) * ( vec2( Pf.x, Pf_min1.x ).xyxy * grad_x0 + vec2( Pf.y, Pf_min1.y ).xxyy * grad_y0 + Pf.zzzz * grad_z0 );\n    vec4 grad_results_1 = inversesqrt( grad_x1 * grad_x1 + grad_y1 * grad_y1 + grad_z1 * grad_z1 ) * ( vec2( Pf.x, Pf_min1.x ).xyxy * grad_x1 + vec2( Pf.y, Pf_min1.y ).xxyy * grad_y1 + Pf_min1.zzzz * grad_z1 );\n\n#if 1\n    //\tClassic Perlin Interpolation\n    vec3 blend = Interpolation_C2( Pf );\n    vec4 res0 = mix( grad_results_0, grad_results_1, blend.z );\n    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );\n    float final = dot( res0, blend2.zxzx * blend2.wwyy );\n    final *= 1.1547005383792515290182975610039;\t\t//\t(optionally) scale things to a strict -1.0->1.0 range    *= 1.0/sqrt(0.75)\n    return final;\n#else\n    //\tClassic Perlin Surflet\n    //\thttp://briansharpe.wordpress.com/2012/03/09/modifications-to-classic-perlin-noise/\n    Pf *= Pf;\n    Pf_min1 *= Pf_min1;\n    vec4 vecs_len_sq = vec4( Pf.x, Pf_min1.x, Pf.x, Pf_min1.x ) + vec4( Pf.yy, Pf_min1.yy );\n    float final = dot( Falloff_Xsq_C2( min( vec4( 1.0 ), vecs_len_sq + Pf.zzzz ) ), grad_results_0 ) + dot( Falloff_Xsq_C2( min( vec4( 1.0 ), vecs_len_sq + Pf_min1.zzzz ) ), grad_results_1 );\n    final *= 2.3703703703703703703703703703704;\t\t//\t(optionally) scale things to a strict -1.0->1.0 range    *= 1.0/cube(0.75)\n    return final;\n#endif\n\n#else\n    //\n    //\timproved noise.\n    //\trequires 1 random value per point.  Will run faster than classic noise if a slow hashing function is used\n    //\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hash_lowz, hash_highz;\n    FAST32_hash_3D( Pi, hash_lowz, hash_highz );\n    //BBS_hash_3D( Pi, hash_lowz, hash_highz );\n    //SGPP_hash_3D( Pi, hash_lowz, hash_highz );\n\n    //\n    //\t\"improved\" noise using 8 corner gradients.  Faster than the 12 mid-edge point method.\n    //\tKen mentions using diagonals like this can cause \"clumping\", but we'll live with that.\n    //\t[1,1,1]  [-1,1,1]  [1,-1,1]  [-1,-1,1]\n    //\t[1,1,-1] [-1,1,-1] [1,-1,-1] [-1,-1,-1]\n    //\n    hash_lowz -= 0.5;\n    vec4 grad_results_0_0 = vec2( Pf.x, Pf_min1.x ).xyxy * sign( hash_lowz );\n    hash_lowz = abs( hash_lowz ) - 0.25;\n    vec4 grad_results_0_1 = vec2( Pf.y, Pf_min1.y ).xxyy * sign( hash_lowz );\n    vec4 grad_results_0_2 = Pf.zzzz * sign( abs( hash_lowz ) - 0.125 );\n    vec4 grad_results_0 = grad_results_0_0 + grad_results_0_1 + grad_results_0_2;\n\n    hash_highz -= 0.5;\n    vec4 grad_results_1_0 = vec2( Pf.x, Pf_min1.x ).xyxy * sign( hash_highz );\n    hash_highz = abs( hash_highz ) - 0.25;\n    vec4 grad_results_1_1 = vec2( Pf.y, Pf_min1.y ).xxyy * sign( hash_highz );\n    vec4 grad_results_1_2 = Pf_min1.zzzz * sign( abs( hash_highz ) - 0.125 );\n    vec4 grad_results_1 = grad_results_1_0 + grad_results_1_1 + grad_results_1_2;\n\n    //\tblend the gradients and return\n    vec3 blend = Interpolation_C2( Pf );\n    vec4 res0 = mix( grad_results_0, grad_results_1, blend.z );\n    vec4 blend2 = vec4( blend.xy, vec2( 1.0 - blend.xy ) );\n    return dot( res0, blend2.zxzx * blend2.wwyy ) * (2.0 / 3.0);\t//\t(optionally) mult by (2.0/3.0) to scale to a strict -1.0->1.0 range\n#endif\n}\n\n#endif\n\nvec3 MOD_deform(vec3 pos,vec3 norm)\n{\n    vec3 modelPos=pos;\n    vec3 forcePos=vec3(MOD_x,MOD_y,MOD_z);\n\n    vec3 vecToOrigin=modelPos-forcePos;\n    float dist=abs(length(vecToOrigin));\n    // float distAlpha = (MOD_size - dist) / MOD_size;\n\n    if(dist*MOD_mScale<MOD_size*MOD_mScale)\n    {\n        vec3 ppos=vec3(pos*MOD_scale*MOD_mScale);\n        ppos.x+=MOD_scrollx;\n        ppos.y+=MOD_scrolly;\n        ppos.z+=MOD_scrollz;\n\n        float p=(Perlin3D(ppos))*MOD_strength;\n\n        float dist=distance(vec3(MOD_x,MOD_y,MOD_z),modelPos);\n        float fallOff=1.0-smoothstep(MOD_fallOff*MOD_size,MOD_size,dist);\n\n        vec3 pnorm=norm;//normalize(pos.xyz);\n\n        #ifdef MOD_METH_MULNORM\n            pos.x+=p*pnorm.x*fallOff;\n            pos.y+=p*pnorm.y*fallOff;\n            pos.z+=p*pnorm.z*fallOff;\n        #endif\n\n        #ifdef MOD_METH_ADD_XYZ\n            pos.x+=p*fallOff;\n            pos.y+=p*fallOff;\n            pos.z+=p*fallOff;\n        #endif\n\n        #ifdef MOD_METH_ADD_Z\n            pos.z+=p*fallOff;\n        #endif\n    }\n\n    return pos;\n}\n\n// LOOK AT THIS./....\n//https://github.com/spite/perlin-experiments/blob/master/chrome.html\n\n\nvec3 MOD_calcNormal(vec3 pos,vec3 norm,vec3 tangent,vec3 bitangent)\n{\n    //http://diary.conewars.com/vertex-displacement-shader/\n    vec4 position=vec4(MOD_deform(pos,norm),1.0);\n\n    vec3 positionAndTangent = MOD_deform( pos + tangent * 0.1,norm );\n    vec3 positionAndBitangent = MOD_deform( pos + bitangent * 0.1,norm );\n\n    MOD_newTangent = ( positionAndTangent - position.xyz ); // leaves just 'tangent'\n    MOD_newBiTangent = ( positionAndBitangent - position.xyz ); // leaves just 'bitangent'\n\n    vec3 newNormal = cross( MOD_newTangent.xyz, MOD_newBiTangent.xyz );\n    return normalize(newNormal.xyz);\n\n}\n\n",perlindeform_body_vert:"\n#ifndef MOD_WORLDSPACE\n    pos.xyz=MOD_deform(pos.xyz,norm.xyz);\n\n    #ifdef MOD_CALC_NORMALS\n        norm=MOD_calcNormal(pos.xyz,norm.xyz,tangent,bitangent);\n    #endif\n#endif\n\n#ifdef MOD_WORLDSPACE\n    pos.xyz=MOD_deform( (mMatrix*pos).xyz ,norm.xyz);\n\n    #ifdef MOD_CALC_NORMALS\n        norm=MOD_calcNormal( (mMatrix*pos).xyz,norm.xyz,tangent,bitangent);\n    #endif\n#endif\n\n#ifdef MOD_CALC_NORMALS\n    tangent=MOD_newTangent;\n    bitangent=MOD_newBiTangent;\n#endif",};
const
    render=op.inTrigger("render"),
    next=op.outTrigger("trigger"),
    inScale=op.inValueFloat("Scale",1),
    inSize=op.inValueFloat("Size",1),
    inStrength=op.inValueFloat("Strength",1),
    inCalcNormals=op.inValueBool("Calc Normals",true),
    inFalloff=op.inValueSlider("Falloff",0.5),
    output=op.inValueSelect("Output",['Mul Normal','Add XYZ','Add Z'],'Add XYZ'),
    x=op.inValueFloat("x"),
    y=op.inValueFloat("y"),
    z=op.inValueFloat("z"),
    scrollx=op.inValueFloat("Scroll X"),
    scrolly=op.inValueFloat("Scroll Y"),
    scrollz=op.inValueFloat("Scroll Z");

const cgl=op.patch.cgl;
inCalcNormals.onChange=updateCalcNormals;
var inWorldSpace=op.inValueBool("WorldSpace");
var shader=null;
var moduleVert=null;
output.onChange=updateOutput;
render.onLinkChanged=removeModule;

var mscaleUni=null;
inWorldSpace.onChange=updateWorldspace;

function updateCalcNormals()
{
    if(!shader)return;
    shader.toggleDefine(moduleVert.prefix+"CALC_NORMALS",inCalcNormals.get());
}

function removeModule()
{
    if(shader && moduleVert) shader.removeModule(moduleVert);
    shader=null;
}

function updateOutput()
{
    if(!shader)return;

    shader.toggleDefine(moduleVert.prefix+"METH_ADD_XYZ",output.get()=='Add XYZ');
    shader.toggleDefine(moduleVert.prefix+"METH_ADD_Z",output.get()=='Add Z');
    shader.toggleDefine(moduleVert.prefix+"METH_MULNORM",output.get()=='Mul Normal');
}

function updateWorldspace()
{
    if(!shader)return;
    if(inWorldSpace.get()) shader.define(moduleVert.prefix+"WORLDSPACE");
        else shader.removeDefine(moduleVert.prefix+"WORLDSPACE");
}

function getScaling(mat)
{
    var m31 = mat[8];
    var m32 = mat[9];
    var m33 = mat[10];
    return Math.hypot(m31, m32, m33);
}

render.onTriggered=function()
{
    if(!cgl.getShader())
    {
        next.trigger();
        return;
    }

    var modelScale=getScaling(cgl.mMatrix);
    if(mscaleUni)mscaleUni.setValue(modelScale);

    if(CABLES.UI)
    {
        cgl.pushModelMatrix();

        if(CABLES.UI && (gui.patch().isCurrentOp(op) ||  CABLES.UI.renderHelper))
        {
            cgl.pushModelMatrix();
            mat4.translate(cgl.mMatrix,cgl.mMatrix,[x.get(),y.get(),z.get()]);
            CABLES.GL_MARKER.drawSphere(op,inSize.get());
            cgl.popModelMatrix();
        }

        if(gui.patch().isCurrentOp(op))
            gui.setTransformGizmo(
                {
                    posX:x,
                    posY:y,
                    posZ:z
                });

        cgl.popModelMatrix();
    }

    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();

        moduleVert=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:attachments.perlindeform_vert,
                srcBodyVert:attachments.perlindeform_body_vert
            });

        inSize.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'size',inSize);
        inStrength.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'strength',inStrength);
        inScale.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'scale',inScale);

        scrollx.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'scrollx',scrollx);
        scrolly.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'scrolly',scrolly);
        scrollz.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'scrollz',scrollz);

        x.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'x',x);
        y.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'y',y);
        z.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'z',z);
        inFalloff.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'fallOff',inFalloff);

        mscaleUni=new CGL.Uniform(shader,'f',moduleVert.prefix+'mScale',1);

        updateOutput();
        updateWorldspace();
        updateCalcNormals();
    }

    if(!shader)return;

    next.trigger();
};















};

Ops.Gl.ShaderEffects.PerlinAreaDeform_v3.prototype = new CABLES.Op();
CABLES.OPS["e4432ebd-d67c-46e2-b302-619d4f97daab"]={f:Ops.Gl.ShaderEffects.PerlinAreaDeform_v3,objName:"Ops.Gl.ShaderEffects.PerlinAreaDeform_v3"};




// **************************************************************
// 
// Ops.Gl.Shader.MatCapMaterialNew
// 
// **************************************************************

Ops.Gl.Shader.MatCapMaterialNew = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={matcap_frag:"\n{{MODULES_HEAD}}\n\nIN vec3 norm;\nIN vec2 texCoord;\nUNI sampler2D tex;\nIN vec2 vNorm;\nUNI mat4 viewMatrix;\n\nUNI float repeatX;\nUNI float repeatY;\nUNI float opacity;\n\nUNI float r;\nUNI float g;\nUNI float b;\n\nIN vec3 e;\n\n\n\n#ifdef HAS_DIFFUSE_TEXTURE\n   UNI sampler2D texDiffuse;\n#endif\n\n#ifdef USE_SPECULAR_TEXTURE\n   UNI sampler2D texSpec;\n   UNI sampler2D texSpecMatCap;\n#endif\n\n#ifdef HAS_AO_TEXTURE\n    UNI sampler2D texAo;\n    UNI float aoIntensity;\n#endif\n\n#ifdef HAS_NORMAL_TEXTURE\n   IN vec3 vBiTangent;\n   IN vec3 vTangent;\n\n   UNI sampler2D texNormal;\n   UNI mat4 normalMatrix;\n\n   vec2 vNormt;\n#endif\n\n#ifdef CALC_SSNORMALS\n    // from https://www.enkisoftware.com/devlogpost-20150131-1-Normal_generation_in_the_pixel_shader\n    IN vec3 eye_relative_pos;\n#endif\n\n\nconst float normalScale=0.4;\n\nconst vec2 invAtan = vec2(0.1591, 0.3183);\nvec2 sampleSphericalMap(vec3 direction)\n{\n    vec2 uv = vec2(atan(direction.z, direction.x), asin(direction.y));\n    uv *= invAtan;\n    uv += 0.5;\n    return uv;\n}\n\n\nvoid main()\n{\n    vec2 vnOrig=vNorm;\n    vec2 vn=vNorm;\n\n\n\n    #ifdef HAS_TEXTURES\n        vec2 texCoords=texCoord;\n        {{MODULE_BEGIN_FRAG}}\n    #endif\n\n    #ifdef CALC_SSNORMALS\n    \tvec3 dFdxPos = dFdx( eye_relative_pos );\n    \tvec3 dFdyPos = dFdy( eye_relative_pos );\n    \tvec3 ssn = normalize( cross(dFdxPos,dFdyPos ));\n\n        vec3 rr = reflect( e, ssn );\n        float ssm = 2. * sqrt(\n            pow(rr.x, 2.0)+\n            pow(rr.y, 2.0)+\n            pow(rr.z + 1.0, 2.0)\n        );\n\n\n        vn = (rr.xy / ssm + 0.5);\n\n        vn.t=clamp(vn.t, 0.0, 1.0);\n        vn.s=clamp(vn.s, 0.0, 1.0);\n\n        // float dst = dot(abs(coord-center), vec2(1.0));\n        // float aaf = fwidth(dst);\n        // float alpha = smoothstep(radius - aaf, radius, dst);\n\n    #endif\n\n   #ifdef HAS_NORMAL_TEXTURE\n        vec3 tnorm=texture( texNormal, vec2(texCoord.x*repeatX,texCoord.y*repeatY) ).xyz * 2.0 - 1.0;\n\n        tnorm = normalize(tnorm*normalScale);\n\n        vec3 tangent;\n        vec3 binormal;\n\n        #ifdef CALC_TANGENT\n            vec3 c1 = cross(norm, vec3(0.0, 0.0, 1.0));\n//            vec3 c2 = cross(norm, vec3(0.0, 1.0, 0.0));\n//            if(length(c1)>length(c2)) tangent = c2;\n//                else tangent = c1;\n            tangent = c1;\n            tangent = normalize(tangent);\n            binormal = cross(norm, tangent);\n            binormal = normalize(binormal);\n        #endif\n\n        #ifndef CALC_TANGENT\n            tangent=normalize(vTangent);\n//            tangent.y*=-13.0;\n//            binormal=vBiTangent*norm;\n//            binormal.z*=-1.0;\n//            binormal=normalize(binormal);\n            binormal=normalize( cross( normalize(norm), normalize(vBiTangent) ));\n        // vBinormal = normalize( cross( vNormal, vTangent ) * tangent.w );\n\n        #endif\n\n        tnorm=normalize(tangent*tnorm.x + binormal*tnorm.y + norm*tnorm.z);\n\n        // vec3 n = normalize( mat3(normalMatrix) * (norm+tnorm*normalScale) );\n        vec3 n = normalize( mat3(normalMatrix) * (norm+tnorm*normalScale) );\n\n        vec3 re = reflect( e, n );\n        float m = 2. * sqrt(\n            pow(re.x, 2.0)+\n            pow(re.y, 2.0)+\n            pow(re.z + 1.0, 2.0)\n        );\n\n        vn = (re.xy / m + 0.5);\n\n    #endif\n\n    vn.t=clamp(vn.t, 0.0, 1.0);\n    vn.s=clamp(vn.s, 0.0, 1.0);\n\n\n    vec4 col = texture( tex, vn );\n\n    #ifdef HAS_DIFFUSE_TEXTURE\n        col = col*texture( texDiffuse, vec2(texCoords.x*repeatX,texCoords.y*repeatY));\n    #endif\n\n    col.r*=r;\n    col.g*=g;\n    col.b*=b;\n\n\n    #ifdef HAS_AO_TEXTURE\n        col = col*\n            mix(\n                vec4(1.0,1.0,1.0,1.0),\n                texture( texAo, vec2(texCoords.x*repeatX,texCoords.y*repeatY)),\n                aoIntensity\n                );\n    #endif\n\n    #ifdef USE_SPECULAR_TEXTURE\n        vec4 spec = texture( texSpecMatCap, vn );\n        spec*= texture( texSpec, vec2(texCoords.x*repeatX,texCoords.y*repeatY) );\n        col+=spec;\n    #endif\n\n    col.a*=opacity;\n\n    {{MODULE_COLOR}}\n\n    outColor = col;\n\n}",matcap_vert:"\nIN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\nIN float attrVertIndex;\n   IN vec3 attrTangent;\n   IN vec3 attrBiTangent;\n\n#ifdef HAS_NORMAL_TEXTURE\n\n   OUT vec3 vBiTangent;\n   OUT vec3 vTangent;\n#endif\n\nOUT vec2 texCoord;\nOUT vec3 norm;\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\nOUT vec2 vNorm;\nOUT vec3 e;\n\n#ifndef INSTANCING\n    UNI mat4 normalMatrix;\n#endif\n\n\n{{MODULES_HEAD}}\n\n#ifdef CALC_SSNORMALS\n    // from https://www.enkisoftware.com/devlogpost-20150131-1-Normal_generation_in_the_pixel_shader\n    OUT vec3 eye_relative_pos;\n    UNI vec3 camPos;\n#endif\n\n\n\nvoid main()\n{\n    texCoord=attrTexCoord;\n    norm=attrVertNormal;\n    mat4 mMatrix=modelMatrix;\n    mat4 mvMatrix;\n    vec3 tangent=attrTangent;\n    vec3 bitangent=attrBiTangent;\n\n    #ifdef HAS_NORMAL_TEXTURE\n        vTangent=attrTangent;\n        vBiTangent=attrBiTangent;\n    #endif\n\n    vec4 pos = vec4( vPosition, 1. );\n\n    {{MODULE_VERTEX_POSITION}}\n\n\n    mvMatrix= viewMatrix * mMatrix;\n\n    #ifdef INSTANCING\n        mat4 normalMatrix=mvMatrix;//inverse(transpose(mvMatrix));\n    #endif\n\n\n    mat3 wmMatrix=mat3(mMatrix);\n    // mat3 newNormalMatrix=mat3(\n    //     normalize( wmMatrix*tangent ),\n    //     normalize( wmMatrix*bitangent ),\n    //     normalize( wmMatrix*norm )\n    // );\n\n    e = normalize( vec3( mvMatrix * pos ) );\n    // e = normalize( vec3( mMatrix * pos )-camPos );-camPos\n    vec3 n = normalize( mat3(normalMatrix) * norm );\n\n\n    // mat3 nMatrix = transpose(inverse(mat3(mMatrix)));\n    // vec3 n = normalize( mat3(nMatrix) * norm );\n    // norm=n;\n\n    vec3 r = reflect( e, n );\n\n\n\n\n    float m = 2. * sqrt(\n        pow(r.x, 2.0)+\n        pow(r.y, 2.0)+\n        pow(r.z + 1.0, 2.0)\n    );\n    vNorm = r.xy / m + 0.5;\n\n    #ifdef DO_PROJECT_COORDS_XY\n       texCoord=(projMatrix * mvMatrix*pos).xy*0.1;\n    #endif\n\n    #ifdef DO_PROJECT_COORDS_YZ\n       texCoord=(projMatrix * mvMatrix*pos).yz*0.1;\n    #endif\n\n    #ifdef DO_PROJECT_COORDS_XZ\n        texCoord=(projMatrix * mvMatrix*pos).xz*0.1;\n    #endif\n\n    #ifdef CALC_SSNORMALS\n        eye_relative_pos = (mvMatrix * pos ).xyz - camPos;\n    #endif\n\n\n\n   gl_Position = projMatrix * mvMatrix * pos;\n\n}",};
const render=op.inTrigger("render");
const textureMatcap=op.inTexture('MatCap');
const textureDiffuse=op.inTexture('Diffuse');
const textureNormal=op.inTexture('Normal');
const textureSpec=op.inTexture('Specular');
const textureSpecMatCap=op.inTexture('Specular MatCap');
const textureAo=op.inTexture('AO Texture');
const r=op.inValueSlider('r',1);
const g=op.inValueSlider('g',1);
const b=op.inValueSlider('b',1);
const pOpacity=op.inValueSlider("Opacity",1);
const aoIntensity=op.inValueSlider("AO Intensity",1.0);
const repeatX=op.inValue("Repeat X",1);
const repeatY=op.inValue("Repeat Y",1);
const calcTangents = op.inValueBool("calc normal tangents",true);
const projectCoords=op.inValueSelect('projectCoords',['no','xy','yz','xz'],'no');
const ssNormals=op.inValueBool("Screen Space Normals");
const next=op.outTrigger("trigger");
const shaderOut=op.outObject("Shader");

r.setUiAttribs({colorPick:true});
op.setPortGroup("Texture maps",[textureDiffuse,textureNormal,textureSpec,textureSpecMatCap,textureAo,]);
op.setPortGroup("Color",[r,g,b,pOpacity]);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'MatCapMaterialNew');
var uniOpacity=new CGL.Uniform(shader,'f','opacity',pOpacity);

shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.bindTextures=bindTextures;
shader.setSource(attachments.matcap_vert,attachments.matcap_frag);
shaderOut.set(shader);

var textureMatcapUniform=null;
var textureDiffuseUniform=null;
var textureNormalUniform=null;
var textureSpecUniform=null;
var textureSpecMatCapUniform=null;
var textureAoUniform=null;
var repeatXUniform=new CGL.Uniform(shader,'f','repeatX',repeatX);
var repeatYUniform=new CGL.Uniform(shader,'f','repeatY',repeatY);
var aoIntensityUniform=new CGL.Uniform(shader,'f','aoIntensity',aoIntensity);
b.uniform=new CGL.Uniform(shader,'f','b',b);
g.uniform=new CGL.Uniform(shader,'f','g',g);
r.uniform=new CGL.Uniform(shader,'f','r',r);


calcTangents.onChange=updateDefines;
updateDefines();
updateMatcap();

function updateDefines()
{
    if(calcTangents.get()) shader.define('CALC_TANGENT');
        else shader.removeDefine('CALC_TANGENT');

}

ssNormals.onChange=function()
{
    if(ssNormals.get())
    {
        if(cgl.glVersion<2)
        {
            cgl.gl.getExtension('OES_standard_derivatives');
            shader.enableExtension('GL_OES_standard_derivatives');
        }

        shader.define('CALC_SSNORMALS');
    }
    else shader.removeDefine('CALC_SSNORMALS');
};

projectCoords.onChange=function()
{
    shader.removeDefine('DO_PROJECT_COORDS_XY');
    shader.removeDefine('DO_PROJECT_COORDS_YZ');
    shader.removeDefine('DO_PROJECT_COORDS_XZ');

    if(projectCoords.get()=='xy') shader.define('DO_PROJECT_COORDS_XY');
    else if(projectCoords.get()=='yz') shader.define('DO_PROJECT_COORDS_YZ');
    else if(projectCoords.get()=='xz') shader.define('DO_PROJECT_COORDS_XZ');
};

textureMatcap.onChange=updateMatcap;

function updateMatcap()
{
    if(textureMatcap.get())
    {
        if(textureMatcapUniform!==null)return;
        shader.removeUniform('tex');
        textureMatcapUniform=new CGL.Uniform(shader,'t','tex',0);
    }
    else
    {
        if(!CGL.defaultTextureMap)
        {
            var pixels=new Uint8Array(256*4);
            for(var x=0;x<16;x++)
            {
                for(var y=0;y<16;y++)
                {
                    var c=y*16;
                    c*=Math.min(1,(x+y/3)/8);
                    pixels[(x+y*16)*4+0]=pixels[(x+y*16)*4+1]=pixels[(x+y*16)*4+2]=c;
                    pixels[(x+y*16)*4+3]=255;
                }
            }

            CGL.defaultTextureMap=new CGL.Texture(cgl);
            CGL.defaultTextureMap.initFromData(pixels,16,16);
        }
        textureMatcap.set(CGL.defaultTextureMap);

        shader.removeUniform('tex');
        textureMatcapUniform=new CGL.Uniform(shader,'t','tex',0);
    }
}

textureDiffuse.onChange=function()
{
    if(textureDiffuse.get())
    {
        if(textureDiffuseUniform!==null)return;
        shader.define('HAS_DIFFUSE_TEXTURE');
        shader.removeUniform('texDiffuse');
        textureDiffuseUniform=new CGL.Uniform(shader,'t','texDiffuse',1);
    }
    else
    {
        shader.removeDefine('HAS_DIFFUSE_TEXTURE');
        shader.removeUniform('texDiffuse');
        textureDiffuseUniform=null;
    }
};

textureNormal.onChange=function()
{
    if(textureNormal.get())
    {
        if(textureNormalUniform!==null)return;
        shader.define('HAS_NORMAL_TEXTURE');
        shader.removeUniform('texNormal');
        textureNormalUniform=new CGL.Uniform(shader,'t','texNormal',2);
    }
    else
    {
        shader.removeDefine('HAS_NORMAL_TEXTURE');
        shader.removeUniform('texNormal');
        textureNormalUniform=null;
    }
};

textureAo.onChange=function()
{
    if(textureAo.get())
    {
        if(textureAoUniform!==null)return;
        shader.define('HAS_AO_TEXTURE');
        shader.removeUniform('texAo');
        textureAoUniform=new CGL.Uniform(shader,'t','texAo',5);
    }
    else
    {
        shader.removeDefine('HAS_AO_TEXTURE');
        shader.removeUniform('texAo');
        textureAoUniform=null;
    }
};

textureSpec.onChange=textureSpecMatCap.onChange=function()
{
    if(textureSpec.get() && textureSpecMatCap.get())
    {
        if(textureSpecUniform!==null)return;
        shader.define('USE_SPECULAR_TEXTURE');
        shader.removeUniform('texSpec');
        shader.removeUniform('texSpecMatCap');
        textureSpecUniform=new CGL.Uniform(shader,'t','texSpec',3);
        textureSpecMatCapUniform=new CGL.Uniform(shader,'t','texSpecMatCap',4);
    }
    else
    {
        shader.removeDefine('USE_SPECULAR_TEXTURE');
        shader.removeUniform('texSpec');
        shader.removeUniform('texSpecMatCap');
        textureSpecUniform=null;
        textureSpecMatCapUniform=null;
    }
};

function bindTextures()
{
    if(textureMatcap.get())     cgl.setTexture(0,textureMatcap.get().tex);
    if(textureDiffuse.get())    cgl.setTexture(1,textureDiffuse.get().tex);
    if(textureNormal.get())     cgl.setTexture(2,textureNormal.get().tex);
    if(textureSpec.get())       cgl.setTexture(3,textureSpec.get().tex);
    if(textureSpecMatCap.get()) cgl.setTexture(4,textureSpecMatCap.get().tex);
    if(textureAo.get())         cgl.setTexture(5,textureAo.get().tex);
};

op.onDelete=function()
{
    if(CGL.defaultTextureMap)
    {
        CGL.defaultTextureMap.delete();
        CGL.defaultTextureMap=null;
    }
};

op.preRender=function()
{
    shader.bind();
};

render.onTriggered=function()
{
    shader.bindTextures=bindTextures;
    cgl.setShader(shader);
    next.trigger();
    cgl.setPreviousShader();
};



};

Ops.Gl.Shader.MatCapMaterialNew.prototype = new CABLES.Op();
CABLES.OPS["7857ee9e-6d60-4c30-9bc0-dfdddf2b47ad"]={f:Ops.Gl.Shader.MatCapMaterialNew,objName:"Ops.Gl.Shader.MatCapMaterialNew"};




// **************************************************************
// 
// Ops.Exp.Gl.ShaderEffects.AreaRotate
// 
// **************************************************************

Ops.Exp.Gl.ShaderEffects.AreaRotate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={area_rotate_vert:"\nUNI bool MOD_smooth;\nUNI float MOD_x,MOD_y,MOD_z;\nUNI float MOD_strength;\nUNI float MOD_size;\n\nvec4 MOD_scaler(vec4 pos,mat4 modelMatrix)\n{\n    vec3 forcePos=vec3(MOD_x,MOD_y,MOD_z);\n    vec3 vecToOrigin=(modelMatrix*pos).xyz-forcePos;\n    float dist=abs(length(vecToOrigin));\n    float distAlpha = (MOD_size - dist) ;\n\n    if(MOD_smooth) distAlpha=smoothstep(0.0,MOD_size,distAlpha);\n    \n    // pos.xyz*=(1.0+(distAlpha*MOD_strength));\n\n    mat3 rotation = mat3(\n        vec3( cos(MOD_strength*distAlpha),  sin(MOD_strength*distAlpha),  0.0),\n        vec3(-sin(MOD_strength*distAlpha),  cos(MOD_strength*distAlpha),  0.0),\n        vec3(        0.0,         0.0,  1.0)\n    );\n    pos =vec4(rotation * pos.xyz, 1.0);\n\n\n    return pos;\n}\n",};
const cgl=op.patch.cgl;

op.render=op.inTrigger("render");
op.trigger=op.outTrigger("trigger");

var inSize=op.inValue("Size",1);
var inStrength=op.inValue("Strength",1);
var inSmooth=op.inValueBool("Smooth",true);

var x=op.inValue("x");
var y=op.inValue("y");
var z=op.inValue("z");

var shader=null;

var srcHeadVert=attachments.area_rotate_vert;

var srcBodyVert=''
    .endl()+'pos=MOD_scaler(pos,mMatrix);'
    .endl();

var moduleVert=null;

function removeModule()
{
    if(shader && moduleVert) shader.removeModule(moduleVert);
    shader=null;
}

op.render.onLinkChanged=removeModule;

op.render.onTriggered=function()
{
    if(!cgl.getShader())
    {
        op.trigger.trigger();
        return;
    }

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:x,
                posY:y,
                posZ:z
            });

    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();

        moduleVert=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:srcHeadVert,
                srcBodyVert:srcBodyVert
            });

        inSize.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'size',inSize);
        inStrength.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'strength',inStrength);
        inSmooth.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'smooth',inSmooth);

        x.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'x',x);
        y.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'y',y);
        z.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'z',z);
    }


    if(!shader)return;

    op.trigger.trigger();
};


};

Ops.Exp.Gl.ShaderEffects.AreaRotate.prototype = new CABLES.Op();
CABLES.OPS["8de665f1-0fc5-466c-8819-b73e17560ccf"]={f:Ops.Exp.Gl.ShaderEffects.AreaRotate,objName:"Ops.Exp.Gl.ShaderEffects.AreaRotate"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.ColorArea
// 
// **************************************************************

Ops.Gl.ShaderEffects.ColorArea = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={colorarea_frag:"#ifdef MOD_AREA_SPHERE\n    float MOD_de=distance(vec3(MOD_x,MOD_y,MOD_z),vec3(MOD_areaPos.x*MOD_sizeX,MOD_areaPos.y,MOD_areaPos.z));\n#endif\n\n#ifdef MOD_AREA_AXIS_X\n    float MOD_de=abs(MOD_x-MOD_areaPos.x);\n#endif\n#ifdef MOD_AREA_AXIS_Y\n    float MOD_de=abs(MOD_y-MOD_areaPos.y);\n#endif\n#ifdef MOD_AREA_AXIS_Z\n    float MOD_de=abs(MOD_z-MOD_areaPos.z);\n#endif\n\n#ifdef MOD_AREA_AXIS_X_INFINITE\n    float MOD_de=MOD_x-MOD_areaPos.x;\n#endif\n#ifdef MOD_AREA_AXIS_Y_INFINITE\n    float MOD_de=MOD_y-MOD_areaPos.y;\n#endif\n#ifdef MOD_AREA_AXIS_Z_INFINITE\n    float MOD_de=MOD_z-MOD_areaPos.z;\n#endif\n\nMOD_de=1.0-smoothstep(MOD_falloff*MOD_size,MOD_size,MOD_de);\n\n#ifdef MOD_AREA_INVERT\n    MOD_de=1.0-MOD_de;\n#endif\n\n#ifdef MOD_BLEND_NORMAL\n    col.rgb=mix(col.rgb,vec3(MOD_r,MOD_g,MOD_b), MOD_de*MOD_amount);\n#endif\n\n#ifdef MOD_BLEND_MULTIPLY\n    col.rgb=mix(col.rgb,col.rgb*vec3(MOD_r,MOD_g,MOD_b),MOD_de*MOD_amount);\n#endif\n",colorarea_head_frag:"IN vec4 MOD_areaPos;\nUNI float MOD_size;\nUNI float MOD_amount;\nUNI float MOD_falloff;\n\nUNI float MOD_r;\nUNI float MOD_g;\nUNI float MOD_b;\n\nUNI float MOD_x;\nUNI float MOD_y;\nUNI float MOD_z;\n\nUNI float MOD_sizeX;",};
const cgl=op.patch.cgl;

op.render=op.inTrigger("render");
op.trigger=op.outTrigger("trigger");

const inArea=op.inValueSelect("Area",["Sphere","Axis X","Axis Y","Axis Z","Axis X Infinite","Axis Y Infinite","Axis Z Infinite"],"Sphere");

const inSize=op.inValue("Size",1);
const inAmount=op.inValueSlider("Amount",0.5);

const inFalloff=op.inValueSlider("Falloff",0);
const inInvert=op.inValueBool("Invert");
var inBlend=op.inSwitch("Blend ",["Normal","Multiply"],"Normal");

const r = op.inValueSlider("r", Math.random());
const g = op.inValueSlider("g", Math.random());
const b = op.inValueSlider("b", Math.random());
r.setUiAttribs({ colorPick: true });

const x=op.inValue("x");
const y=op.inValue("y");
const z=op.inValue("z");

const sizeX=op.inValueSlider("Size X",1);

op.setPortGroup("Position",[x,y,z]);
op.setPortGroup("Color",[inBlend,r,g,b]);

const inWorldSpace=op.inValueBool("WorldSpace",true);

var shader=null;

var srcHeadVert=''
    .endl()+'OUT vec4 MOD_areaPos;'
    .endl();

var srcBodyVert=''
    .endl()+'#ifndef MOD_WORLDSPACE'
    .endl()+'   MOD_areaPos=pos;'
    .endl()+'#endif'
    .endl()+'#ifdef MOD_WORLDSPACE'
    .endl()+'   MOD_areaPos=mMatrix*pos;'
    .endl()+'#endif'
    .endl();

var moduleFrag=null;
var moduleVert=null;

op.render.onLinkChanged=removeModule;
inWorldSpace.onChange=updateWorldspace;
inArea.onChange=updateArea;
inInvert.onChange=updateInvert;
inBlend.onChange=updateBlend;

function updateBlend()
{
    if(!shader)return;

    shader.removeDefine(moduleVert.prefix+"BLEND_NORMAL");
    shader.removeDefine(moduleVert.prefix+"BLEND_MULTIPLY");

    if(inBlend.get()=="Normal") shader.define(moduleVert.prefix+"BLEND_NORMAL");
        else shader.define(moduleVert.prefix+"BLEND_MULTIPLY");
}


function updateInvert()
{
    if(!shader)return;
    if(inInvert.get()) shader.define(moduleVert.prefix+"AREA_INVERT");
        else shader.removeDefine(moduleVert.prefix+"AREA_INVERT");
}

function updateArea()
{
    if(!shader)return;

    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_X");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Y");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Z");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_X_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Y_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_AXIS_Z_INFINITE");
    shader.removeDefine(moduleVert.prefix+"AREA_SPHERE");
    if(inArea.get()=="Axis X")shader.define(moduleVert.prefix+"AREA_AXIS_X");
    else if(inArea.get()=="Axis Y")shader.define(moduleVert.prefix+"AREA_AXIS_Y");
    else if(inArea.get()=="Axis Z")shader.define(moduleVert.prefix+"AREA_AXIS_Z");

    else if(inArea.get()=="Axis X Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_X_INFINITE");
    else if(inArea.get()=="Axis Y Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_Y_INFINITE");
    else if(inArea.get()=="Axis Z Infinite")shader.define(moduleVert.prefix+"AREA_AXIS_Z_INFINITE");
    else shader.define(moduleVert.prefix+"AREA_SPHERE");
}

function updateWorldspace()
{
    if(!shader)return;
    if(inWorldSpace.get()) shader.define(moduleVert.prefix+"WORLDSPACE");
        else shader.removeDefine(moduleVert.prefix+"WORLDSPACE");
}

function removeModule()
{
    if(shader && moduleFrag) shader.removeModule(moduleFrag);
    if(shader && moduleVert) shader.removeModule(moduleVert);
    shader=null;
}

op.render.onTriggered=function()
{

    if(CABLES.UI)
    {
        cgl.pushModelMatrix();
        mat4.identity(cgl.mMatrix);
        if(gui.patch().isCurrentOp(op))
            gui.setTransformGizmo(
                {
                    posX:x,
                    posY:y,
                    posZ:z
                });

        if(CABLES.UI.renderHelper ||gui.patch().isCurrentOp(op))
        {
            mat4.translate(cgl.mMatrix,cgl.mMatrix,[x.get(),y.get(),z.get()]);
            CABLES.GL_MARKER.drawSphere(op,inSize.get());
        }
        cgl.popModelMatrix();
    }

    if(!cgl.getShader())
    {
         op.trigger.trigger();
         return;
    }

    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();

        moduleVert=shader.addModule(
            {
                priority:2,
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:srcHeadVert,
                srcBodyVert:srcBodyVert
            });

        moduleFrag=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_COLOR',
                srcHeadFrag:attachments.colorarea_head_frag,
                srcBodyFrag:attachments.colorarea_frag
            },moduleVert);

        inSize.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'size',inSize);
        inAmount.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'amount',inAmount);

        r.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'r',r);
        g.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'g',g);
        b.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'b',b);

        x.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'x',x);
        y.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'y',y);
        z.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'z',z);
        sizeX.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'sizeX',sizeX);

        inFalloff.uniform=new CGL.Uniform(shader,'f',moduleFrag.prefix+'falloff',inFalloff);

        updateWorldspace();
        updateArea();
        updateInvert();
        updateBlend();
    }

    if(!shader)return;
    var texSlot=moduleVert.num+5;

    op.trigger.trigger();
};















};

Ops.Gl.ShaderEffects.ColorArea.prototype = new CABLES.Op();
CABLES.OPS["cac6a739-c2ad-440c-99b2-33e2c459e8b1"]={f:Ops.Gl.ShaderEffects.ColorArea,objName:"Ops.Gl.ShaderEffects.ColorArea"};




// **************************************************************
// 
// Ops.Math.Sine
// 
// **************************************************************

Ops.Math.Sine = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// input
var value = op.inValue('value');

var phase = op.inValue('phase', 0.0);
var mul = op.inValue('frequency', 1.0);
var amplitude = op.inValue('amplitude', 1.0);
var invert = op.inValueBool("asine", false);

// output
var result = op.outValue('result');

var calculate = Math.sin;

phase.onChange =
value.onChange = function()
{
    result.set(
        amplitude.get() * calculate( ( value.get()*mul.get() ) + phase.get() )
    );
};

invert.onChange = function()
{
    if(invert.get()) calculate = Math.asin;
    else calculate = Math.sin;
}


};

Ops.Math.Sine.prototype = new CABLES.Op();
CABLES.OPS["d24da018-9f3d-428b-85c9-6ff14d77548b"]={f:Ops.Math.Sine,objName:"Ops.Math.Sine"};




// **************************************************************
// 
// Ops.Gl.Geometry.DivideGeometry
// 
// **************************************************************

Ops.Gl.Geometry.DivideGeometry = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var geometry=op.inObject("Geometry");
var outGeom=op.outObject("Result");

geometry.onChange=update;


function update()
{
    outGeom.set(null);
    if(geometry.get())
    {
        var geom=geometry.get();
        var newGeom=new CGL.Geometry();

        var newVerts=[];
        var newFaces=[];
        var newNormals=[];
        var newTexCoords=[];

        for(var i=0;i<geom.verticesIndices.length;i+=3)
        {
            newFaces.push( newVerts.length/3 );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+0]*3+0] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+0]*3+1] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+0]*3+2] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+0]*3+0] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+0]*3+1] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+0]*3+2] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+0]*2+0] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+0]*2+1] );

            newFaces.push( newVerts.length/3 );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+1]*3+0] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+1]*3+1] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+1]*3+2] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+1]*3+0] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+1]*3+1] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+1]*3+2] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+1]*2+0] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+1]*2+1] );

            newFaces.push( newVerts.length/3 );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+2]*3+0] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+2]*3+1] );
            newVerts.push( geom.vertices[ geom.verticesIndices[i+2]*3+2] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+2]*3+0] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+2]*3+1] );
            newNormals.push( geom.vertexNormals[ geom.verticesIndices[i+2]*3+2] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+2]*2+0] );
            newTexCoords.push( geom.texCoords[ geom.verticesIndices[i+2]*2+1] );
        }

        newGeom.vertices=newVerts;
        newGeom.vertexNormals=newNormals;
        newGeom.verticesIndices=newFaces;
        newGeom.setTexCoords(newTexCoords);

        outGeom.set(newGeom);
    }
}



};

Ops.Gl.Geometry.DivideGeometry.prototype = new CABLES.Op();
CABLES.OPS["ab0c768e-e684-47ba-b11f-f95d86532df2"]={f:Ops.Gl.Geometry.DivideGeometry,objName:"Ops.Gl.Geometry.DivideGeometry"};




// **************************************************************
// 
// Ops.Gl.TesselateGeometry
// 
// **************************************************************

Ops.Gl.TesselateGeometry = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var inGeom=op.inObject("Geometry");
var inTimes=op.inValueInt("Iterations",1);
var outGeom=op.outObject("Result");
var outVertices=op.outValue("Num Vertices");

inGeom.onChange=update;
inTimes.onChange=update;

function tesselateTC(tc, x1,y1, x2,y2,  x3,y3)
{
    tc.push( x1 );
    tc.push( y1 );

    tc.push( (x1+x2)/2 );
    tc.push( (y1+y2)/2 );

    tc.push( (x1+x3)/2 );
    tc.push( (y1+y3)/2 );

    // --

    tc.push( (x1+x2)/2 );
    tc.push( (y1+y2)/2 );

    tc.push( x2 );
    tc.push( y2 );

    tc.push( (x2+x3)/2 );
    tc.push( (y2+y3)/2 );

    // --

    tc.push( (x2+x3)/2 );
    tc.push( (y2+y3)/2 );

    tc.push( x3 );
    tc.push( y3 );

    tc.push( (x1+x3)/2 );
    tc.push( (y1+y3)/2 );

    // --

    tc.push( (x1+x2)/2 );
    tc.push( (y1+y2)/2 );

    tc.push( (x2+x3)/2 );
    tc.push( (y2+y3)/2 );

    tc.push( (x1+x3)/2 );
    tc.push( (y1+y3)/2 );
}

function tesselate(vertices, x1,y1,z1, x2,y2,z2, x3,y3,z3)
{

    vertices.push( x1 );
    vertices.push( y1 );
    vertices.push( z1 );

    vertices.push( (x1+x2)/2 );
    vertices.push( (y1+y2)/2 );
    vertices.push( (z1+z2)/2 );

    vertices.push( (x1+x3)/2 );
    vertices.push( (y1+y3)/2 );
    vertices.push( (z1+z3)/2 );

    // --

    vertices.push( (x1+x2)/2 );
    vertices.push( (y1+y2)/2 );
    vertices.push( (z1+z2)/2 );

    vertices.push( x2 );
    vertices.push( y2 );
    vertices.push( z2 );

    vertices.push( (x2+x3)/2 );
    vertices.push( (y2+y3)/2 );
    vertices.push( (z2+z3)/2 );

    // --

    vertices.push( (x2+x3)/2 );
    vertices.push( (y2+y3)/2 );
    vertices.push( (z2+z3)/2 );

    vertices.push( x3 );
    vertices.push( y3 );
    vertices.push( z3 );

    vertices.push( (x1+x3)/2 );
    vertices.push( (y1+y3)/2 );
    vertices.push( (z1+z3)/2 );

    // --

    vertices.push( (x1+x2)/2 );
    vertices.push( (y1+y2)/2 );
    vertices.push( (z1+z2)/2 );

    vertices.push( (x2+x3)/2 );
    vertices.push( (y2+y3)/2 );
    vertices.push( (z2+z3)/2 );

    vertices.push( (x1+x3)/2 );
    vertices.push( (y1+y3)/2 );
    vertices.push( (z1+z3)/2 );
}


function tesselateGeom(oldGeom)
{
    var geom=new CGL.Geometry();
    var vertices=[];
    var norms=[];
    var biTangents=[];
    var tangents=[];
    var tc=[];

    var i,j,k;

    if(oldGeom.verticesIndices.length>0)
    {
        for(i=0;i<oldGeom.verticesIndices.length;i+=3)
        {

            for(j=0;j<4;j++)
            for(k=0;k<3;k++)
            {
                norms.push(
                    oldGeom.vertexNormals[oldGeom.verticesIndices[i+k]*3+0],
                    oldGeom.vertexNormals[oldGeom.verticesIndices[i+k]*3+1],
                    oldGeom.vertexNormals[oldGeom.verticesIndices[i+k]*3+2]
                    );

                if(oldGeom.tangents)
                    tangents.push(
                        oldGeom.tangents[oldGeom.verticesIndices[i+k]*3+0],
                        oldGeom.tangents[oldGeom.verticesIndices[i+k]*3+1],
                        oldGeom.tangents[oldGeom.verticesIndices[i+k]*3+2]
                        );

                if(oldGeom.biTangents)
                    biTangents.push(
                        oldGeom.biTangents[oldGeom.verticesIndices[i+k]*3+0],
                        oldGeom.biTangents[oldGeom.verticesIndices[i+k]*3+1],
                        oldGeom.biTangents[oldGeom.verticesIndices[i+k]*3+2]
                        );


            }

            tesselate(vertices,
                oldGeom.vertices[oldGeom.verticesIndices[i+0]*3+0],
                oldGeom.vertices[oldGeom.verticesIndices[i+0]*3+1],
                oldGeom.vertices[oldGeom.verticesIndices[i+0]*3+2],

                oldGeom.vertices[oldGeom.verticesIndices[i+1]*3+0],
                oldGeom.vertices[oldGeom.verticesIndices[i+1]*3+1],
                oldGeom.vertices[oldGeom.verticesIndices[i+1]*3+2],

                oldGeom.vertices[oldGeom.verticesIndices[i+2]*3+0],
                oldGeom.vertices[oldGeom.verticesIndices[i+2]*3+1],
                oldGeom.vertices[oldGeom.verticesIndices[i+2]*3+2]
                );


            tesselateTC(tc,
                oldGeom.texCoords[oldGeom.verticesIndices[i+0]*2+0],
                oldGeom.texCoords[oldGeom.verticesIndices[i+0]*2+1],

                oldGeom.texCoords[oldGeom.verticesIndices[i+1]*2+0],
                oldGeom.texCoords[oldGeom.verticesIndices[i+1]*2+1],

                oldGeom.texCoords[oldGeom.verticesIndices[i+2]*2+0],
                oldGeom.texCoords[oldGeom.verticesIndices[i+2]*2+1]
                );
        }
    }
    else
    {
        if(oldGeom.vertices.length>0)
        {
            for(i=0;i<oldGeom.vertices.length;i+=9)
            {
                for(j=0;j<4;j++)
                {
                    for(k=0;k<9;k++)
                        norms.push(oldGeom.vertexNormals[i+k]);

                    if(oldGeom.tangents)
                        for(k=0;k<9;k++)
                            tangents.push(oldGeom.tangents[i+k]);

                    if(oldGeom.biTangents)
                        for(k=0;k<9;k++)
                            biTangents.push(oldGeom.biTangents[i+k]);

                }

                tesselate(vertices,
                    oldGeom.vertices[i+0],
                    oldGeom.vertices[i+1],
                    oldGeom.vertices[i+2],

                    oldGeom.vertices[i+3],
                    oldGeom.vertices[i+4],
                    oldGeom.vertices[i+5],

                    oldGeom.vertices[i+6],
                    oldGeom.vertices[i+7],
                    oldGeom.vertices[i+8]
                );

                tesselateTC(tc,
                    oldGeom.texCoords[i/9*6+0],
                    oldGeom.texCoords[i/9*6+1],

                    oldGeom.texCoords[i/9*6+2],
                    oldGeom.texCoords[i/9*6+3],

                    oldGeom.texCoords[i/9*6+4],
                    oldGeom.texCoords[i/9*6+5]

                    );

            }
        }
    }

    // console.log('norms',norms);
    geom.vertexNormals=norms;
    geom.setVertices(vertices);
    geom.setTexCoords(tc);
    geom.tangents=tangents;
    geom.biTangents=biTangents;
    return geom;

}

function update()
{
    var geom=inGeom.get();
    if(!geom)return;
        var startTime=CABLES.now();

    for(var i=0;i<inTimes.get();i++)
    {
        geom=tesselateGeom(geom);
    }

    outVertices.set(geom.vertices.length/3);
    console.log('tesselate time',CABLES.now()-startTime);

    outGeom.set(null);
    outGeom.set(geom);

}




};

Ops.Gl.TesselateGeometry.prototype = new CABLES.Op();
CABLES.OPS["eb3f0bd8-211c-4336-a3ad-fa31c50d705d"]={f:Ops.Gl.TesselateGeometry,objName:"Ops.Gl.TesselateGeometry"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.ExplodeDividedMesh
// 
// **************************************************************

Ops.Gl.ShaderEffects.ExplodeDividedMesh = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={explode_divided_mesh_vert:"UNI float MOD_dist;\n\nUNI float MOD_x;\nUNI float MOD_y;\nUNI float MOD_z;\n\nUNI float MOD_posx;\nUNI float MOD_posy;\nUNI float MOD_posz;\nUNI float MOD_size;\n\nUNI float MOD_mulx;\nUNI float MOD_muly;\nUNI float MOD_mulz;\n\nfloat MOD_rand(vec2 co)\n{\n    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\n\nvec4 MOD_deform(vec4 pos,vec3 normal,float index)\n{\n    index=floor(index/3.0);\n\n    vec4 p=abs(pos);\n    p.x+=MOD_x+0.01;\n    p.y+=MOD_y+0.01;\n    p.z+=MOD_z+0.01;\n    \n    vec4 pp=vec4(normal*(MOD_rand(vec2(index)) * MOD_dist-MOD_dist/2.0),1.0) * p;\n    \n    #ifdef ABSOLUTE\n        pp=abs(pp);\n    #endif\n\n    pp.x*=MOD_mulx;\n    pp.y*=MOD_muly;\n    pp.z*=MOD_mulz;\n    \n    \n    float MOD_falloff=0.2;\n    float distMul=distance(vec3(MOD_posx,MOD_posy,MOD_posz),pos.xyz);\n    distMul=1.0-smoothstep(MOD_falloff*MOD_size,MOD_size,distMul);\n\n    \n    \n    pos.xyz += distMul*pp.xyz;\n    \n    return pos;\n}\n",};

var cgl=op.patch.cgl;

op.render=op.inTrigger("render");
op.trigger=op.outTrigger("trigger");

var inDistance=op.inValue("Distance",1);
var inAbsolute=op.inValueBool("Absolute",false);

{
    var x=op.inValue("add x");
    var y=op.inValue("add y");
    var z=op.inValue("add z");

    var mulx=op.inValue("mul x",1);
    var muly=op.inValue("mul y",1);
    var mulz=op.inValue("mul z",1);

    var posx=op.inValue("x");
    var posy=op.inValue("y");
    var posz=op.inValue("z");
}

var inSize=op.inValue("Size",1);

var shader=null;

var srcHeadVert=attachments.explode_divided_mesh_vert;

var srcBodyVert=''
    .endl()+'pos=MOD_deform(pos,attrVertNormal,attrVertIndex);'
    .endl();

var moduleVert=null;

function removeModule()
{
    if(shader && moduleVert) shader.removeModule(moduleVert);
    shader=null;
}

var absoluteChanged=false;

inAbsolute.onChange=function()
{
    absoluteChanged=true;
};

op.render.onLinkChanged=removeModule;

op.render.onTriggered=function()
{
    if(!cgl.getShader())
    {
         op.trigger.trigger();
         return;
    }

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:posx,
                posY:posy,
                posZ:posz
            });

    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();

        moduleVert=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:srcHeadVert,
                srcBodyVert:srcBodyVert
            });

        inDistance.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'dist',inDistance);

        x.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'x',x);
        y.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'y',y);
        z.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'z',z);

        mulx.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'mulx',mulx);
        muly.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'muly',muly);
        mulz.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'mulz',mulz);

        posx.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'posx',posx);
        posy.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'posy',posy);
        posz.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'posz',posz);

        inSize.uniform=new CGL.Uniform(shader,'f',moduleVert.prefix+'size',inSize);
    }

    if(absoluteChanged)
    {
        absoluteChanged=false;
        if(inAbsolute.get()) shader.define("ABSOLUTE");
            else shader.removeDefine("ABSOLUTE");

    }

    if(!shader)return;

    op.trigger.trigger();
};















};

Ops.Gl.ShaderEffects.ExplodeDividedMesh.prototype = new CABLES.Op();
CABLES.OPS["b6d933cf-1ef8-41d6-95c1-593be0b4be90"]={f:Ops.Gl.ShaderEffects.ExplodeDividedMesh,objName:"Ops.Gl.ShaderEffects.ExplodeDividedMesh"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.Twist_v2
// 
// **************************************************************

Ops.Gl.ShaderEffects.Twist_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={twist_vert:"\nfloat MOD_angle_rad = MOD_amount * 3.14159 / 180.0;\n\nfloat MOD_axis=pos.y;\n\n#ifdef MOD_AXIS_Z\n    MOD_axis=pos.z;\n#endif\n\n#ifdef MOD_AXIS_X\n    MOD_axis=pos.x;\n#endif\n\nfloat MOD_ang = (MOD_height*0.5 + MOD_axis)/MOD_height * MOD_angle_rad;\n\npos = MOD_twist(pos, MOD_ang);\n\n\nnorm = normalize(MOD_twist( vec4(norm, 1.0), MOD_ang ).xyz);\n",twist_head_vert:"\n\nUNI float MOD_amount;\nUNI float MOD_height;\nUNI float MOD_offset;\n\nvec4 MOD_twist(vec4 pos, float t)\n{\n\tfloat st = sin(t);\n\tfloat ct = cos(t);\n\tvec4 new_pos;\n\n\tnew_pos.x = pos.x;\n\tnew_pos.y = pos.y;\n\tnew_pos.z = pos.z;\n\tnew_pos.w = pos.w;\n\n    #ifdef MOD_AXIS_Z\n    \tnew_pos.x = pos.y*ct - pos.x*st;\n    \tnew_pos.y = pos.y*st + pos.x*ct;\n    #endif\n\n    #ifdef MOD_AXIS_Y\n    \tnew_pos.x = pos.x*ct - pos.z*st;\n    \tnew_pos.z = pos.x*st + pos.z*ct;\n    #endif\n\n    #ifdef MOD_AXIS_X\n    \tnew_pos.y = pos.y*ct - pos.z*st;\n    \tnew_pos.z = pos.y*st + pos.z*ct;\n    #endif\n\n\n\treturn( new_pos );\n}\n\n",};

var render=op.inTrigger("render");
var trigger=op.outTrigger("Trigger");
var amount=op.inValue("Degree",180);
var height=op.inValue("Height",2);

var axis=op.inValueSelect("Axis",["X","Y","Z"],"Y");


var uniAmount=null;
var uniHeight=null;
var cgl=op.patch.cgl;
var shader=null;
var mod=null;

function removeModule()
{
    if(shader && mod)
    {
        shader.removeModule(mod);
        shader=null;
    }
}

axis.onChange=updateAxis;

function updateAxis()
{
    if(!shader)return;
    shader.removeDefine(mod.prefix+"AXIS_X");
    shader.removeDefine(mod.prefix+"AXIS_Y");
    shader.removeDefine(mod.prefix+"AXIS_Z");
    
    if(axis.get()=="X")shader.define(mod.prefix+"AXIS_X");
    if(axis.get()=="Y")shader.define(mod.prefix+"AXIS_Y");
    if(axis.get()=="Z")shader.define(mod.prefix+"AXIS_Z");
}

render.onLinkChanged=removeModule;
render.onTriggered=function()
{
    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();
        mod=shader.addModule(
            {
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:attachments.twist_head_vert,
                srcBodyVert:attachments.twist_vert
            });

        uniAmount=new CGL.Uniform(shader,'f',mod.prefix+'amount',amount);
        uniHeight=new CGL.Uniform(shader,'f',mod.prefix+'height',height);
        updateAxis();
    }

    if(!shader)return;

    if(CABLES.UI && CABLES.UI.renderHelper)
    {
        CABLES.GL_MARKER.drawCube(op,1,height.get()/2,1);
    }

    trigger.trigger();
};


};

Ops.Gl.ShaderEffects.Twist_v2.prototype = new CABLES.Op();
CABLES.OPS["92aee475-63e8-45cc-902f-2a84154e0a93"]={f:Ops.Gl.ShaderEffects.Twist_v2,objName:"Ops.Gl.ShaderEffects.Twist_v2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Desaturate
// 
// **************************************************************

Ops.Gl.TextureEffects.Desaturate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={desaturate_frag:"\nIN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\n\n#ifdef MASK\n    UNI sampler2D mask;\n#endif\n\nvec3 desaturate(vec3 color, float amount)\n{\n   vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), color));\n   return vec3(mix(color, gray, amount));\n}\n\nvoid main()\n{\n    vec4 col=texture(tex,texCoord);\n\n    float am=amount;\n    #ifdef MASK\n        am*=1.0-texture(mask,texCoord).r;\n        #ifdef INVERTMASK\n        am=1.0-am;\n        #endif\n    #endif\n\n    col.rgb=desaturate(col.rgb,am);\n    outColor= col;\n}",};
const render=op.inTrigger('render');
const trigger=op.outTrigger('trigger');
const amount=op.inValueSlider("amount",1);
const inMask=op.inTexture("Mask");
const invertMask=op.inValueBool("Invert Mask");

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.desaturate_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var masktextureUniform=new CGL.Uniform(shader,'t','mask',1);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);


invertMask.onChange=function()
{
    if(invertMask.get())shader.define("INVERTMASK");
        else shader.removeDefine("INVERTMASK");

};

inMask.onChange=function()
{
    if(inMask.get())shader.define("MASK");
        else shader.removeDefine("MASK");
};

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    if(inMask.get()) cgl.setTexture(1, inMask.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Desaturate.prototype = new CABLES.Op();
CABLES.OPS["340efbd5-be53-4bd5-92ad-8f38d8eeecf1"]={f:Ops.Gl.TextureEffects.Desaturate,objName:"Ops.Gl.TextureEffects.Desaturate"};




// **************************************************************
// 
// Ops.Gl.Matrix.GetViewMatrix
// 
// **************************************************************

Ops.Gl.Matrix.GetViewMatrix = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var render=op.inTrigger('render');
var trigger=op.outTrigger('trigger');

var m=mat4.create();
var matrix=op.addOutPort(new CABLES.Port(op,"matrix",CABLES.OP_PORT_TYPE_ARRAY));

var cgl=op.patch.cgl;

render.onTriggered=function()
{
    mat4.copy(m, cgl.vMatrix);
    matrix.set(null);
    matrix.set(m);
    trigger.trigger();
};

matrix.set( [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1] );


};

Ops.Gl.Matrix.GetViewMatrix.prototype = new CABLES.Op();
CABLES.OPS["a58406ae-79b5-4dab-99fa-0a66c2325aab"]={f:Ops.Gl.Matrix.GetViewMatrix,objName:"Ops.Gl.Matrix.GetViewMatrix"};




// **************************************************************
// 
// Ops.Array.ArrayToString_v3
// 
// **************************************************************

Ops.Array.ArrayToString_v3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inArr=op.inArray("Array"),
    inSeperator=op.inString("Seperator",","),
    inNewLine=op.inValueBool("New Line"),
    outStr=op.outString("Result");

inArr.onChange=
    outStr.onChange=
    inSeperator.onChange=
    inNewLine.onChange=exec;


function exec()
{
    var arr=inArr.get();
    var result='';

    var sep=inSeperator.get();
    if(inNewLine.get())sep+='\n';

    if(arr && arr.join)
    {
        result=arr.join(sep);
    }

    outStr.set(result);
}

};

Ops.Array.ArrayToString_v3.prototype = new CABLES.Op();
CABLES.OPS["7b539bb3-8e86-4367-9e00-a637d3cfd87a"]={f:Ops.Array.ArrayToString_v3,objName:"Ops.Array.ArrayToString_v3"};




// **************************************************************
// 
// Ops.Trigger.TriggerExtender
// 
// **************************************************************

Ops.Trigger.TriggerExtender = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// inputs
var inTriggerPort = op.inTriggerButton('Execute');

// outputs
var outTriggerPort = op.outTrigger('Next');

// trigger listener
inTriggerPort.onTriggered = function() {
    outTriggerPort.trigger();
};

};

Ops.Trigger.TriggerExtender.prototype = new CABLES.Op();
CABLES.OPS["7ef594f3-4907-47b0-a2d3-9854eda1679d"]={f:Ops.Trigger.TriggerExtender,objName:"Ops.Trigger.TriggerExtender"};




// **************************************************************
// 
// Ops.WebAudio.BiquadFilter
// 
// **************************************************************

Ops.WebAudio.BiquadFilter = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
this.name="BiquadFilter";

var audioContext = CABLES.WEBAUDIO.createAudioContext(op);

// default values + min and max
var FREQUENCY_MIN = 10;
var FREQUENCY_MAX = audioContext.sampleRate / 2; // Nyquist frequency.
var TYPE_DEF = "allpass";

var biquadFilter = audioContext.createBiquadFilter();

var audioInPort = CABLES.WEBAUDIO.createAudioInPort(op, "Audio In", biquadFilter);
var audioOutPort = CABLES.WEBAUDIO.createAudioOutPort(op, "Audio Out", biquadFilter);

var type = op.inValueSelect ("type",['allpass','lowpass','highpass','bandpass','lowshelf','highshelf','peaking','notch'],'allpass');

var frequency = op.inFloat("frequency",1000);

var detune = op.inFloatSlider("detune",0);
var q = op.inFloatSlider("q",0);
var gain = op.inFloatSlider("gain",0.5);

var updateType = function(){
    biquadFilter.type = type.get();
};

var updateFrequency = function()
{
    var freq = frequency.get();
    if(freq && freq >= FREQUENCY_MIN && freq <= FREQUENCY_MAX)
    {
        biquadFilter.frequency.setValueAtTime(frequency.get(), window.audioContext.currentTime);
    }
};

var updateDetune = function()
{
    biquadFilter.detune.setValueAtTime(detune.get(), window.audioContext.currentTime);
};

var updateQ = function()
{
    biquadFilter.Q.setValueAtTime(q.get(), window.audioContext.currentTime);
};

var updateGain = function()
{
    biquadFilter.gain.setValueAtTime(gain.get(), window.audioContext.currentTime);
};

type.onChange=updateType;
frequency.onChange=updateFrequency;
detune.onChange=updateDetune;
q.onChange=updateQ;
gain.onChange=updateGain;

updateType();



};

Ops.WebAudio.BiquadFilter.prototype = new CABLES.Op();
CABLES.OPS["3e28f86a-4f74-49a2-a1a6-f8943c00352d"]={f:Ops.WebAudio.BiquadFilter,objName:"Ops.WebAudio.BiquadFilter"};




// **************************************************************
// 
// Ops.WebAudio.AudioAnalyzer
// 
// **************************************************************

Ops.WebAudio.AudioAnalyzer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var audioCtx=CABLES.WEBAUDIO.createAudioContext(op);
const inFftSize = op.inSwitch("FFT size",[64,128,256,512,1024],256);
const analyser = audioCtx.createAnalyser();
analyser.smoothingTimeConstant = 0.3;
analyser.fftSize = 256;

const refresh=op.addInPort(new CABLES.Port(op,"refresh",CABLES.OP_PORT_TYPE_FUNCTION));
const audioIn = CABLES.WEBAUDIO.createAudioInPort(op, "Audio In", analyser);
const anData=op.inValueSelect("Data",["Frequency","Time Domain"],"Frequency");

const next=op.outTrigger("Next");
const audioOutPort = CABLES.WEBAUDIO.createAudioOutPort(op, "Audio Out", analyser);
const avgVolume=op.addOutPort(new CABLES.Port(op, "average volume",CABLES.OP_PORT_TYPE_VALUE));
const fftOut=op.addOutPort(new CABLES.Port(op, "fft",CABLES.OP_PORT_TYPE_ARRAY));

var fftBufferLength = analyser.frequencyBinCount;
var fftDataArray = new Uint8Array(fftBufferLength);
var getFreq=true;
var array=null;

inFftSize.onChange = function()
{
    analyser.fftSize = inFftSize.get();
}

anData.onChange=function() {
    if(anData.get()=="Frequency")getFreq=true;
    if(anData.get()=="Time Domain")getFreq=false;
};

refresh.onTriggered = function()
{
    analyser.minDecibels = -90;
    analyser.maxDecibels = 0;

    if(fftBufferLength != analyser.frequencyBinCount)
    {
        console.log("change!");
        fftBufferLength = analyser.frequencyBinCount;
        fftDataArray = new Uint8Array(fftBufferLength);
    }

    if(!fftDataArray)
    {
        //op.log("[audioanalyzer] fftDataArray is null, returning.");
        return;
    }

    var values = 0;

    for (var i = 0; i < fftDataArray.length; i++) values += fftDataArray[i];

    var average = values / fftDataArray.length;

    avgVolume.set(average/128);
    try
    {
        if(getFreq) analyser.getByteFrequencyData(fftDataArray);
            else analyser.getByteTimeDomainData(fftDataArray);
    }
    catch(e) { op.log(e); }

    fftOut.set(null);
    fftOut.set(fftDataArray);

    next.trigger();
};



};

Ops.WebAudio.AudioAnalyzer.prototype = new CABLES.Op();
CABLES.OPS["22523fae-a623-401d-b952-a57c26de4b4e"]={f:Ops.WebAudio.AudioAnalyzer,objName:"Ops.WebAudio.AudioAnalyzer"};




// **************************************************************
// 
// Ops.Anim.Smooth
// 
// **************************************************************

Ops.Anim.Smooth = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exec=op.inTrigger("Update");
const inMode = op.inBool("Separate inc/dec",false);
const inVal=op.inValue("Value");
const next=op.outTrigger("Next");
const inDivisorUp=op.inValue("Inc factor",4);
const inDivisorDown=op.inValue("Dec factor",4);
const result=op.outValue("Result",0);

var val=0;
var goal=0;
var oldVal=0;
var lastTrigger=0;
op.toWorkPortsNeedToBeLinked(exec);

var divisorUp;
var divisorDown;
var divisor = 4;

var selectIndex = 0;
const MODE_SINGLE = 0;
const MODE_UP_DOWN = 1;

onFilterChange();
getDivisors();

inMode.setUiAttribs({hidePort:true});

inDivisorUp.onChange = inDivisorDown.onChange = getDivisors;
inMode.onChange = onFilterChange;
update();

function onFilterChange()
{
    var selectedMode = inMode.get();
    if(selectedMode === false) selectIndex = MODE_SINGLE;
    else if(selectedMode === true) selectIndex = MODE_UP_DOWN;


    if(selectIndex == MODE_SINGLE)
    {
        inDivisorDown.setUiAttribs({greyout:true});
        inDivisorUp.setUiAttribs({title:"Inc/Dec factor"});

    }
    else if (selectIndex == MODE_UP_DOWN)
    {
        inDivisorDown.setUiAttribs({greyout:false});
        inDivisorUp.setUiAttribs({title:"Inc factor"});
    }

    getDivisors();
    update();
};

function getDivisors()
{
    if(selectIndex == MODE_SINGLE)
    {
        divisorUp=inDivisorUp.get();
        divisorDown=inDivisorUp.get();
    }
    else if (selectIndex == MODE_UP_DOWN)
    {
        divisorUp=inDivisorUp.get();
        divisorDown=inDivisorDown.get();
    }

    if(divisorUp<=0.2 || divisorUp != divisorUp )divisorUp=0.2;
    if(divisorDown<=0.2 || divisorDown != divisorDown )divisorDown=0.2;
};

inVal.onChange=function()
{
    goal=inVal.get();
};

inDivisorUp.onChange=function()
{
    getDivisors();
};

function update()
{
    var tm=1;
    if(CABLES.now()-lastTrigger>500 || lastTrigger===0)val=inVal.get();
    else tm=(CABLES.now()-lastTrigger)/16;
    lastTrigger=CABLES.now();

    if(divisor<=0)divisor=0.0001;

    var diff = goal-val;

    if(diff  >= 0)
        val=val+(diff)/(divisorDown*tm);
    else
        val=val+(diff)/(divisorUp*tm);
    //val=val+(goal-val)/(divisor*tm);

    if(val>0 && val<0.000000001)val=0;
    if(divisor!=divisor)val=0;
    if(val!=val|| val== -Infinity || val==Infinity)val=inVal.get();

    if(oldVal!=val)
    {
        result.set(val);
        oldVal=val;
    }

    next.trigger();
};

exec.onTriggered = function()
{
    update();
};






};

Ops.Anim.Smooth.prototype = new CABLES.Op();
CABLES.OPS["5677b5b5-753a-4fbf-9e91-64c81ec68a2f"]={f:Ops.Anim.Smooth,objName:"Ops.Anim.Smooth"};




// **************************************************************
// 
// Ops.Vars.VarSetNumber
// 
// **************************************************************

Ops.Vars.VarSetNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.varName=op.inValueSelect("Variable");
var val=op.inValueFloat("Value",0);

op.varName.onChange=updateName;
val.onChange=update;
val.changeAlways=true;

op.patch.addEventListener("variablesChanged",updateVarNamesDropdown);

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.getVars();
        varnames.push('+ create new one');
        for(var i in vars) varnames.push(i);
        op.varName.uiAttribs.values=varnames;
    }
}

function updateName()
{
    if(CABLES.UI)
    {
        if(op.varName.get()=='+ create new one')
        {
            CABLES.CMD.PATCH.createVariable(op);
            return;
        }

        op.setTitle('#' + op.varName.get());
    }
    update();
}

function update()
{
    op.patch.setVarValue(op.varName.get(),val.get());
}


};

Ops.Vars.VarSetNumber.prototype = new CABLES.Op();
CABLES.OPS["b0190d08-82f6-45b2-bc0c-b70a3257ea92"]={f:Ops.Vars.VarSetNumber,objName:"Ops.Vars.VarSetNumber"};




// **************************************************************
// 
// Ops.Vars.VarGetNumber
// 
// **************************************************************

Ops.Vars.VarGetNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var val=op.outValue("Value");
op.varName=op.inValueSelect("Variable");

var variable=null;
// op.patch.addVariableListener(init);
op.patch.addEventListener("variablesChanged",init);

init();

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.getVars();

        for(var i in vars) varnames.push(i);

        // varnames.push('+ create new one');
        op.varName.uiAttribs.values=varnames;
    }
}

op.varName.onChange=function()
{
    init();
};

function init()
{
    updateVarNamesDropdown();

    // if(CABLES.UI)
    // {
    //     if(op.varName.get()=='+ create new one')
    //     {
    //         CABLES.CMD.PATCH.createVariable(op);
    //         return;
    //     }
    // }

    if(variable)
    {
        variable.removeListener(onChange);
    }

    variable=op.patch.getVar(op.varName.get());

    if(variable)
    {
        variable.addListener(onChange);
        op.uiAttr({error:null,});
        op.setTitle('#'+op.varName.get());
        onChange(variable.getValue());
        // console.log("var value ",variable.getName(),variable.getValue());
    }
    else
    {
        op.uiAttr({error:"unknown variable! - there is no setVariable with this name"});
        op.setTitle('#invalid');
    }
}


function onChange(v)
{
    updateVarNamesDropdown();
    val.set(v);
}

op.onDelete=function()
{
    if(variable)
        variable.removeListener(onChange);
};


};

Ops.Vars.VarGetNumber.prototype = new CABLES.Op();
CABLES.OPS["1b9c4504-d69a-43c2-b747-8ca795a8950f"]={f:Ops.Vars.VarGetNumber,objName:"Ops.Vars.VarGetNumber"};




// **************************************************************
// 
// Ops.Html.Cursor
// 
// **************************************************************

Ops.Html.Cursor = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    cursorPort = op.inValueSelect("cursor",["auto","crosshair","pointer","hand","move","n-resize","ne-resize","e-resize","se-resize","s-resize","sw-resize","w-resize","nw-resize","text","wait","help", "none"]),
    trigger=op.inTriggerButton("Set Cursor"),
    cgl = op.patch.cgl;

cursorPort.onChange=trigger.onTriggered=update;

function update()
{
    var cursor = cursorPort.get();
    cgl.canvas.style.cursor = cursor;
}



};

Ops.Html.Cursor.prototype = new CABLES.Op();
CABLES.OPS["409f94da-6264-435c-8e73-03e8d2275e04"]={f:Ops.Html.Cursor,objName:"Ops.Html.Cursor"};




// **************************************************************
// 
// Ops.TimeLine.TimeLinePlay
// 
// **************************************************************

Ops.TimeLine.TimeLinePlay = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var play=op.inTriggerButton("Play");

play.onTriggered=function()
{
    op.patch.timer.play();    
};


};

Ops.TimeLine.TimeLinePlay.prototype = new CABLES.Op();
CABLES.OPS["fc75b841-a55f-4474-8746-61218588598d"]={f:Ops.TimeLine.TimeLinePlay,objName:"Ops.TimeLine.TimeLinePlay"};




// **************************************************************
// 
// Ops.TimeLine.TimeLineRewind
// 
// **************************************************************

Ops.TimeLine.TimeLineRewind = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=op.inTriggerButton("exe");

exe.onTriggered=function()
{
    op.patch.timer.setTime(0);
};


};

Ops.TimeLine.TimeLineRewind.prototype = new CABLES.Op();
CABLES.OPS["d3408604-858c-4226-8d4c-1ef669956f35"]={f:Ops.TimeLine.TimeLineRewind,objName:"Ops.TimeLine.TimeLineRewind"};




// **************************************************************
// 
// Ops.Time.DelayedTrigger
// 
// **************************************************************

Ops.Time.DelayedTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    delay=op.inValueFloat("delay",1),
    next=op.outTrigger("next");

var lastTimeout=null;

exe.onTriggered=function()
{
    if(lastTimeout)clearTimeout(lastTimeout);
    lastTimeout=setTimeout(
        function()
        {
            lastTimeout=null;
            next.trigger();
        },
        delay.get()*1000);
};

};

Ops.Time.DelayedTrigger.prototype = new CABLES.Op();
CABLES.OPS["f4ff66b0-8500-46f7-9117-832aea0c2750"]={f:Ops.Time.DelayedTrigger,objName:"Ops.Time.DelayedTrigger"};




// **************************************************************
// 
// Ops.String.SwitchString
// 
// **************************************************************

Ops.String.SwitchString = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    idx=op.inValueInt("Index"),
    result=op.outString("Result");

const valuePorts=[];

idx.onChange=update;

for(var i=0;i<10;i++)
{
    var p=op.inString("String "+i);
    valuePorts.push( p );
    p.onChange=update;
}

function update()
{
    if(idx.get()>=0 && valuePorts[idx.get()])
    {
        result.set( valuePorts[idx.get()].get() );
    }
}

};

Ops.String.SwitchString.prototype = new CABLES.Op();
CABLES.OPS["2a7a0c68-f7c9-4249-b19a-d2de5cb4862c"]={f:Ops.String.SwitchString,objName:"Ops.String.SwitchString"};




// **************************************************************
// 
// Ops.Boolean.TriggerChangedTrue
// 
// **************************************************************

Ops.Boolean.TriggerChangedTrue = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var val=op.inValueBool("Value",false);

var next=op.outTrigger("Next");

var oldVal=0;

val.onChange=function()
{
    var newVal=val.get();
    if(!oldVal && newVal)
    {
        oldVal=true;
        next.trigger();
    }
    else
    {
        oldVal=false;
    }
};

};

Ops.Boolean.TriggerChangedTrue.prototype = new CABLES.Op();
CABLES.OPS["385197e1-8b34-4d1c-897f-d1386d99e3b3"]={f:Ops.Boolean.TriggerChangedTrue,objName:"Ops.Boolean.TriggerChangedTrue"};




// **************************************************************
// 
// Ops.Math.Compare.IfBetweenThen
// 
// **************************************************************

Ops.Math.Compare.IfBetweenThen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=op.inTrigger("exe");

var number=op.inValue("number",0);
var min=op.inValue("min",0);
var max=op.inValue("max",1);

var triggerThen=op.outTrigger('then');
var triggerElse=op.outTrigger('else');
var outBetween=op.outValue("bs between");

exe.onTriggered=function()
{
    if(number.get()>=min.get() && number.get()<max.get())
    {
        outBetween.set(true);
        triggerThen.trigger();
    }
    else
    {
        outBetween.set(false);
        triggerElse.trigger();
    }
};


};

Ops.Math.Compare.IfBetweenThen.prototype = new CABLES.Op();
CABLES.OPS["c80437f0-f0e1-465c-9cea-8a044aa2feaa"]={f:Ops.Math.Compare.IfBetweenThen,objName:"Ops.Math.Compare.IfBetweenThen"};




// **************************************************************
// 
// Ops.Boolean.IfFalseThen
// 
// **************************************************************

Ops.Boolean.IfFalseThen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var exe=op.inTrigger("Exe");

var boolean=op.inValueBool("Boolean",false);

var triggerThen=op.outTrigger("then");
var triggerElse=op.outTrigger("else");

boolean.onChange=execBool;
exe.onTriggered=exec;

function execBool()
{
    if(exe.isLinked())return;
    exec();
}

function exec()
{
    if(!boolean.get()) triggerThen.trigger();
    else triggerElse.trigger();
}



};

Ops.Boolean.IfFalseThen.prototype = new CABLES.Op();
CABLES.OPS["91cf65f1-94ac-423f-a536-af71eed08440"]={f:Ops.Boolean.IfFalseThen,objName:"Ops.Boolean.IfFalseThen"};




// **************************************************************
// 
// Ops.Value.TriggerOnChangeNumber
// 
// **************************************************************

Ops.Value.TriggerOnChangeNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inval=op.inValue("Value"),
    next=op.outTrigger("Next");

inval.onChange=function()
{
    next.trigger();
};

};

Ops.Value.TriggerOnChangeNumber.prototype = new CABLES.Op();
CABLES.OPS["f5c8c433-ce13-49c4-9a33-74e98f110ed0"]={f:Ops.Value.TriggerOnChangeNumber,objName:"Ops.Value.TriggerOnChangeNumber"};




// **************************************************************
// 
// Ops.Math.Compare.BetweenEquals
// 
// **************************************************************

Ops.Math.Compare.BetweenEquals = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    number = op.inValueFloat("Value",2),
    range1 = op.inValueFloat("Range 1",1),
    range2 = op.inValueFloat("Range 2",3),
    result = op.outValue("Result");

number.onChange=range1.onChange=range2.onChange=exec;
exec();

function exec() {
  result.set(
      number.get() >= Math.min( range1.get(), range2.get() ) &&
      number.get() <= Math.max( range1.get(), range2.get() )
  );
}



};

Ops.Math.Compare.BetweenEquals.prototype = new CABLES.Op();
CABLES.OPS["e2d6d6c4-84c7-42d7-a1b2-e9c5d4c5c13e"]={f:Ops.Math.Compare.BetweenEquals,objName:"Ops.Math.Compare.BetweenEquals"};




// **************************************************************
// 
// Ops.Boolean.TriggerChangedFalse
// 
// **************************************************************

Ops.Boolean.TriggerChangedFalse = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var val=op.inValueBool("Value",false);

var next=op.outTrigger("Next");

var oldVal=0;

val.onChange=function()
{
    var newVal=val.get();
    if(oldVal && !newVal)
    {
        oldVal=false;
        next.trigger();
    }
    else
    {
        oldVal=true;
    }
};

};

Ops.Boolean.TriggerChangedFalse.prototype = new CABLES.Op();
CABLES.OPS["6387bcb0-6091-4199-8ab7-f96ad4aa3c7d"]={f:Ops.Boolean.TriggerChangedFalse,objName:"Ops.Boolean.TriggerChangedFalse"};




// **************************************************************
// 
// Ops.Boolean.Or
// 
// **************************************************************

Ops.Boolean.Or = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const bool0=op.inValueBool("bool 1");
const bool1=op.inValueBool("bool 2");
const bool2=op.inValueBool("bool 3");
const bool3=op.inValueBool("bool 4");
const bool4=op.inValueBool("bool 5");
const bool5=op.inValueBool("bool 6");
const bool6=op.inValueBool("bool 7");
const bool7=op.inValueBool("bool 8");

const result=op.outValueBool("result");

bool0.onChange=
    bool1.onChange=
    bool2.onChange=
    bool3.onChange=
    bool4.onChange=
    bool5.onChange=
    bool6.onChange=
    bool7.onChange=exec;

function exec()
{
    result.set( bool0.get() || bool1.get()  || bool2.get() || bool3.get() || bool4.get() || bool5.get() || bool6.get() || bool7.get() );
}



};

Ops.Boolean.Or.prototype = new CABLES.Op();
CABLES.OPS["b3b36238-4592-4e11-afe3-8361c4fd6be5"]={f:Ops.Boolean.Or,objName:"Ops.Boolean.Or"};




// **************************************************************
// 
// Ops.String.ConcatMulti
// 
// **************************************************************

Ops.String.ConcatMulti = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const addSpacesCheckBox = op.inBool("add spaces",false),
        newLinesCheckBox = op.inBool("new lines",false),
        stringPorts = [],
        result = op.outString("concat string");


stringPorts.onChange = addSpacesCheckBox.onChange =
newLinesCheckBox.onChange = update;

addSpacesCheckBox.hidePort(true);
newLinesCheckBox.hidePort(true);

for(var i=0; i<8; i++)
{
    var p=op.inString("string " + i);
    stringPorts.push(p);
    p.onChange = update;
}

function update()
{
    var str = "";
    var nl = "";
    var space = addSpacesCheckBox.get();

    for(var i=0; i<stringPorts.length; i++)

    {
        if(space && stringPorts[i].get())  str += " ";
        if(newLinesCheckBox.get()) nl = '\n';
            str += nl;
            str += stringPorts[i].get();
    }
    result.set(str);
}


};

Ops.String.ConcatMulti.prototype = new CABLES.Op();
CABLES.OPS["21d3dcc6-3c5b-4e94-97dc-ef7720e9e00d"]={f:Ops.String.ConcatMulti,objName:"Ops.String.ConcatMulti"};




// **************************************************************
// 
// Ops.Array.ArrayChunk
// 
// **************************************************************

Ops.Array.ArrayChunk = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// inputs
const inArrayPort = op.inArray("Input Array"),
    beginPort = op.inValueInt("Begin Index", 0),
    sizePort = op.inValueInt("Chunk Size", 1),
    circularPort = op.inValueBool("Circular", false),
    outArrayPort = op.outArray("Output Array"),
    outArrayLength = op.outNumber("Array length");


// functions
function setOutarray() {
    var inArr = inArrayPort.get();
    var begin = beginPort.get();
    var size = sizePort.get();
    var circular = circularPort.get();

    if(begin < 0) {
        begin = 0;
    }
    if(circular && begin >= inArr.length) {
        begin %= inArr.length;
    }

    if(!inArr || size < 1) {
        outArrayPort.set(null);
        return;
    }
    var end = size + begin;
    var chunk = inArr.slice(begin, end);
    // circular mode - if chunk does not contain enough elements, take more from the beginning
    if(circular && chunk.length < size) {
        var remainingArrSize = size - chunk.length;
        var beginArr = inArr.slice(0, remainingArrSize);
        chunk.push.apply(chunk, beginArr);
    }
    outArrayPort.set(null);
    outArrayPort.set(chunk);
    outArrayLength.set(size);
}

// change listeners
inArrayPort.onChange = setOutarray;
beginPort.onChange = setOutarray;
sizePort.onChange = setOutarray;
circularPort.onChange = setOutarray;



};

Ops.Array.ArrayChunk.prototype = new CABLES.Op();
CABLES.OPS["c7ee6c6e-ca88-4c24-b289-78bb922bf5f7"]={f:Ops.Array.ArrayChunk,objName:"Ops.Array.ArrayChunk"};




// **************************************************************
// 
// Ops.Array.ArrayGetNumber
// 
// **************************************************************

Ops.Array.ArrayGetNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var array=op.inArray("array");
var index=op.inValueInt("index");
var value=op.outValue("value");

array.ignoreValueSerialize=true;

index.onChange=update;
array.onChange=update;

function update()
{
    if(array.get()) value.set( array.get()[index.get()]);
}


};

Ops.Array.ArrayGetNumber.prototype = new CABLES.Op();
CABLES.OPS["d1189078-70cf-437d-9a37-b2ebe89acdaf"]={f:Ops.Array.ArrayGetNumber,objName:"Ops.Array.ArrayGetNumber"};




// **************************************************************
// 
// Ops.Anim.StringTypeAnimation_v2
// 
// **************************************************************

Ops.Anim.StringTypeAnimation_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var text=op.inStringEditor("text");
var inRestart=op.inTriggerButton("Restart");
var speed=op.inValue("Speed",500);
var speedVariation=op.inValueSlider("Speed Variation");
const showCursor=op.inBool("Show Cursor",true);

var outText=op.outString("Result");
var outChanged=op.outTrigger("Changed");
var outFinished=op.outTrigger("Finished");

outText.set('  \n  ');
var pos=0;
var updateInterval=0;
var cursorblink=true;
var finished=false;

function setNewTimeout()
{
    clearTimeout(updateInterval);
    var ms=speed.get()*(Math.random()*(speedVariation.get()*2-1));
    if(text.get() && pos>text.get().length)ms=speed.get();
    updateInterval=setTimeout(update,speed.get()+ms);
}

inRestart.onTriggered=function()
{
    finished=false;
    pos=0;
    setNewTimeout();
};

function update()
{
    if(!text.get() || text.get()==='' || text.get()==='0' ||text.get()=='0' )
    {
        outText.set(' ');
        return;
    }

    var t=text.get().substring(0,pos);
    cursorblink=!cursorblink;

    if(pos>text.get().length && cursorblink)
    {
        if(showCursor.get())
        {
            // t+=' ';
            // pos++;
        }

        if(!finished)
        {
            outFinished.trigger();
            finished=true;
        }
    }
    else
    {
        finished=false;
        if(showCursor.get())
        {
            t+='_';
        }
        pos++;
    }

    outText.set( t );
    outChanged.trigger();
    setNewTimeout();
}

text.onChange=function()
{
    finished=false;
    pos=0;
    setNewTimeout();
    outText.set('');
};





};

Ops.Anim.StringTypeAnimation_v2.prototype = new CABLES.Op();
CABLES.OPS["66723fea-7d5f-4509-98fc-8d892a8f8d89"]={f:Ops.Anim.StringTypeAnimation_v2,objName:"Ops.Anim.StringTypeAnimation_v2"};




// **************************************************************
// 
// Ops.String.StringBreak_v2
// 
// **************************************************************

Ops.String.StringBreak_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    str=op.inString("String","a very very long default string"),
    numChars=op.inValueInt("Max Line Chars",10),
    result=op.outValue('Result');

str.onChange=numChars.onChange=update;
update();

function update()
{
    if(!str.get() && str.isLinked)
    {
        result.set('');
        return;
    }

    if(!str.get())return;
    var strings=str.get().split(" ");

    var string='';
    var currentString='';

    for(var i=0;i<strings.length;i++)
    {
        if(currentString.length+strings[i].length<numChars.get())
        {
            currentString+=strings[i];
            currentString+=" ";
        }
        else
        {
            string+=currentString.trim()+'\n';
            currentString=strings[i]+' ';
        }
    }

    result.set( (string+currentString).trim() );

}

};

Ops.String.StringBreak_v2.prototype = new CABLES.Op();
CABLES.OPS["f45945ab-88c7-458d-ab2a-38b39050a984"]={f:Ops.String.StringBreak_v2,objName:"Ops.String.StringBreak_v2"};




// **************************************************************
// 
// Ops.String.String_v2
// 
// **************************************************************

Ops.String.String_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    v=op.inString("value",""),
    result=op.outString("String");

v.onChange=function()
{
    result.set(v.get());
};



};

Ops.String.String_v2.prototype = new CABLES.Op();
CABLES.OPS["d697ff82-74fd-4f31-8f54-295bc64e713d"]={f:Ops.String.String_v2,objName:"Ops.String.String_v2"};




// **************************************************************
// 
// Ops.Trigger.TriggerNumber
// 
// **************************************************************

Ops.Trigger.TriggerNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe0=op.inTriggerButton("0");
const exe1=op.inTriggerButton("1");
const exe2=op.inTriggerButton("2");
const exe3=op.inTriggerButton("3");
const exe4=op.inTriggerButton("4");
const exe5=op.inTriggerButton("5");
const exe6=op.inTriggerButton("6");
const exe7=op.inTriggerButton("7");
const number=op.outValue("number");

exe0.onTriggered=function(){ number.set(0); };
exe1.onTriggered=function(){ number.set(1); };
exe2.onTriggered=function(){ number.set(2); };
exe3.onTriggered=function(){ number.set(3); };
exe4.onTriggered=function(){ number.set(4); };
exe5.onTriggered=function(){ number.set(5); };
exe6.onTriggered=function(){ number.set(6); };
exe7.onTriggered=function(){ number.set(7); };


};

Ops.Trigger.TriggerNumber.prototype = new CABLES.Op();
CABLES.OPS["43ed1123-1312-4383-b843-27b8ec540c09"]={f:Ops.Trigger.TriggerNumber,objName:"Ops.Trigger.TriggerNumber"};




// **************************************************************
// 
// Ops.Trigger.TriggerOnChangeString
// 
// **************************************************************

Ops.Trigger.TriggerOnChangeString = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inval=op.inString("String"),
    next=op.outTrigger("Changed"),
    outStr=op.outString("Result");

inval.onChange=function()
{
    outStr.set(inval.get());
    next.trigger();
};

};

Ops.Trigger.TriggerOnChangeString.prototype = new CABLES.Op();
CABLES.OPS["319d07e0-5cbe-4bc1-89fb-a934fd41b0c4"]={f:Ops.Trigger.TriggerOnChangeString,objName:"Ops.Trigger.TriggerOnChangeString"};




// **************************************************************
// 
// Ops.String.StringOld2New
// 
// **************************************************************

Ops.String.StringOld2New = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inStr=op.inValueString("String"),
    outStr=op.outString("Result");

inStr.onChange=function()
{
    outStr.set(inStr.get());

};

};

Ops.String.StringOld2New.prototype = new CABLES.Op();
CABLES.OPS["77193bdc-9769-41da-95e1-51afcaad0274"]={f:Ops.String.StringOld2New,objName:"Ops.String.StringOld2New"};




// **************************************************************
// 
// Ops.Gl.Meshes.TextMesh_v2
// 
// **************************************************************

Ops.Gl.Meshes.TextMesh_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={textmesh_frag:"UNI sampler2D tex;\nIN vec2 texCoord;\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\nvoid main()\n{\n   vec4 col=texture(tex,texCoord);\n   col.a=col.r;\n   col.r*=r;\n   col.g*=g;\n   col.b*=b;\n   col*=a;\n   if(col.a==0.0)discard;\n\n   outColor=col;\n}",textmesh_vert:"UNI sampler2D tex;\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\nUNI float scale;\nIN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN mat4 instMat;\nIN vec2 attrTexOffsets;\nIN vec2 attrTexSize;\n\nOUT vec2 texCoord;\n\nvoid main()\n{\n   texCoord=(attrTexCoord*(attrTexSize)) + attrTexOffsets;\n   mat4 instModelMat=instMat;\n   instModelMat[3][0]*=scale;\n\n   vec4 vert=vec4( vPosition.x*(attrTexSize.x/attrTexSize.y)*scale,vPosition.y*scale,vPosition.z*scale, 1. );\n\n   mat4 mvMatrix=viewMatrix * modelMatrix * instModelMat;\n\n   #ifndef BILLBOARD\n       gl_Position = projMatrix * mvMatrix * vert;\n   #endif\n}\n",};
const
    render=op.inTrigger("Render"),
    str=op.inString("Text","cables"),
    scale=op.inValueFloat("Scale",1),
    inFont=op.inString("Font","Arial"),
    align=op.inValueSelect("align",['left','center','right'],'center'),
    valign=op.inValueSelect("vertical align",['Top','Middle','Bottom'],'Middle'),
    lineHeight=op.inValueFloat("Line Height",1),
    letterSpace=op.inValueFloat("Letter Spacing"),
    next=op.outTrigger("Next"),
    textureOut=op.outTexture("texture"),
    outLines=op.outNumber("Total Lines",0),
    loaded=op.outValue("Font Available",0);

const cgl=op.patch.cgl;


const filter=CGL.Texture.FILTER_MIPMAP;
const textureSize=1024;
var fontLoaded=false;

align.onChange=
    str.onChange=
    lineHeight.onChange=generateMesh;

var canvasid=null;
CABLES.OpTextureMeshCanvas={};
var valignMode=0;


var geom=null;
var mesh=null;

var createMesh=true;
var createTexture=true;

textureOut.set(null);
inFont.onChange=function()
    {
        createTexture=true;
        createMesh=true;
        checkFont();
    };

function checkFont()
{
    var oldFontLoaded=fontLoaded;
    try
    {
        fontLoaded=document.fonts.check('20px '+inFont.get());
    }
    catch(ex)
    {
        console.log(ex);
    }

    if(!oldFontLoaded && fontLoaded)
    {
        loaded.set(true);
        createTexture=true;
        createMesh=true;
    }

    if(!fontLoaded) setTimeout(checkFont,250);
}


valign.onChange=function()
{
    if(valign.get()=='Middle')valignMode=0;
    else if(valign.get()=='Top')valignMode=1;
    else if(valign.get()=='Bottom')valignMode=2;
};

function getFont()
{
    canvasid=''+inFont.get();
    if(CABLES.OpTextureMeshCanvas.hasOwnProperty(canvasid))
        return CABLES.OpTextureMeshCanvas[canvasid];

    var fontImage = document.createElement('canvas');
    fontImage.dataset.font=inFont.get();
    fontImage.id = "texturetext_"+CABLES.generateUUID();
    fontImage.style.display = "none";
    var body = document.getElementsByTagName("body")[0];
    body.appendChild(fontImage);
    var _ctx= fontImage.getContext('2d');
    CABLES.OpTextureMeshCanvas[canvasid]=
        {
            ctx:_ctx,
            canvas:fontImage,
            chars:{},
            characters:'?',
            fontSize:320
        };
    return CABLES.OpTextureMeshCanvas[canvasid];
}

op.onDelete=function()
{
    if(canvasid && CABLES.OpTextureMeshCanvas[canvasid])
        CABLES.OpTextureMeshCanvas[canvasid].canvas.remove();
};

var shader=new CGL.Shader(cgl,'TextMesh');
shader.setSource(attachments.textmesh_vert,attachments.textmesh_frag);
var uniTex=new CGL.Uniform(shader,'t','tex',0);
var uniScale=new CGL.Uniform(shader,'f','scale',scale);

const
    r = op.inValueSlider("r", 1),
    g = op.inValueSlider("g", 1),
    b = op.inValueSlider("b", 1),
    a = op.inValueSlider("a", 1),
    runiform=new CGL.Uniform(shader,'f','r',r),
    guniform=new CGL.Uniform(shader,'f','g',g),
    buniform=new CGL.Uniform(shader,'f','b',b),
    auniform=new CGL.Uniform(shader,'f','a',a);
r.setUiAttribs({ colorPick: true });

op.setPortGroup('Display',[scale,inFont]);
op.setPortGroup('Alignment',[align,valign]);
op.setPortGroup('Color',[r,g,b,a]);


var height=0;
var vec=vec3.create();
var lastTextureChange=-1;
var disabled=false;

render.onTriggered=function()
{
    var font=getFont();
    if(font.lastChange!=lastTextureChange)
    {
        createMesh=true;
        lastTextureChange=font.lastChange;
    }

    if(createTexture) generateTexture();
    if(createMesh)generateMesh();

    if(mesh && mesh.numInstances>0)
    {
        cgl.pushBlendMode(CGL.BLEND_NORMAL,true);
        cgl.setShader(shader);
        cgl.setTexture(0,textureOut.get().tex);

        if(valignMode===2) vec3.set(vec, 0,height,0);
        else if(valignMode===1) vec3.set(vec, 0,0,0);
        else if(valignMode===0) vec3.set(vec, 0,height/2,0);
        vec[1]-=lineHeight.get();
        cgl.pushModelMatrix();
        mat4.translate(cgl.mMatrix,cgl.mMatrix, vec);
        if(!disabled)mesh.render(cgl.getShader());

        cgl.popModelMatrix();

        cgl.setTexture(0,null);
        cgl.setPreviousShader();
        cgl.popBlendMode();
    }

    next.trigger();
};

letterSpace.onChange=function()
{
    createMesh=true;
};


function generateMesh()
{
    var theString=String(str.get()+'');
    if(!textureOut.get())return;

    var font=getFont();
    if(!font.geom)
    {
        font.geom=new CGL.Geometry("textmesh");

        font.geom.vertices = [
            1.0, 1.0, 0.0,
            0.0, 1.0, 0.0,
            1.0, 0.0, 0.0,
            0.0, 0.0, 0.0
        ];

        font.geom.texCoords = new Float32Array([
            1.0, 1.0,
            0.0, 1.0,
            1.0, 0.0,
            0.0, 0.0
        ]);

        font.geom.verticesIndices = [
            0, 1, 2,
            3, 1, 2
        ];
    }

    if(!mesh)mesh=new CGL.Mesh(cgl,font.geom);

    var strings=(theString).split('\n');
    outLines.set(strings.length);

    var transformations=[];
    var tcOffsets=[];//new Float32Array(str.get().length*2);
    var tcSize=[];//new Float32Array(str.get().length*2);
    var charCounter=0;
    createTexture=false;
    var m=mat4.create();


    for(var s=0;s<strings.length;s++)
    {
        var txt=strings[s];
        var numChars=txt.length;

        var pos=0;
        var offX=0;
        var width=0;

        for(var i=0;i<numChars;i++)
        {
            var chStr=txt.substring(i,i+1);
            var char=font.chars[String(chStr)];
            if(char)
            {
                width+=(char.texCoordWidth/char.texCoordHeight);
                width+=letterSpace.get();
            }
        }
        width-=letterSpace.get();

        height=0;

        if(align.get()=='left') offX=0;
        else if(align.get()=='right') offX=width;
        else if(align.get()=='center') offX=width/2;

        height=(s+1)*lineHeight.get();

        for(var i=0;i<numChars;i++)
        {
            const chStr=txt.substring(i,i+1);
            const char=font.chars[String(chStr)];

            if(!char)
            {
                createTexture=true;
                return;
            }
            else
            {
                tcOffsets.push(char.texCoordX,1-char.texCoordY-char.texCoordHeight);
                tcSize.push(char.texCoordWidth,char.texCoordHeight);

                mat4.identity(m);
                mat4.translate(m,m,[pos-offX,0-s*lineHeight.get(),0]);

                pos+=(char.texCoordWidth/char.texCoordHeight)+letterSpace.get();
                transformations.push(Array.prototype.slice.call(m));

                charCounter++;
            }
        }
    }

    var transMats = [].concat.apply([], transformations);

    disabled=false;
    if(transMats.length==0)disabled=true;

    mesh.numInstances=transMats.length/16;

    if(mesh.numInstances==0)
    {
        disabled=true;
        return;
    }

    mesh.setAttribute('instMat',new Float32Array(transMats),16,{"instanced":true});
    mesh.setAttribute('attrTexOffsets',new Float32Array(tcOffsets),2,{"instanced":true});
    mesh.setAttribute('attrTexSize',new Float32Array(tcSize),2,{"instanced":true});

    createMesh=false;

    if(createTexture) generateTexture();
}

function printChars(fontSize,simulate)
{
    var font=getFont();
    if(!simulate) font.chars={};

    var ctx=font.ctx;

    ctx.font = fontSize+'px '+inFont.get();
    ctx.textAlign = "left";

    var posy=0,i=0;
    var posx=0;
    var lineHeight=fontSize*1.4;
    var result=
        {
            "fits":true
        };

    for(var i=0;i<font.characters.length;i++)
    {
        var chStr=String(font.characters.substring(i,i+1));
        var chWidth=(ctx.measureText(chStr).width);

        if(posx+chWidth>=textureSize)
        {
            posy+=lineHeight+2;
            posx=0;
        }

        if(!simulate)
        {
            font.chars[chStr]=
                {
                    str:chStr,
                    texCoordX:posx/textureSize,
                    texCoordY:posy/textureSize,
                    texCoordWidth:chWidth/textureSize,
                    texCoordHeight:lineHeight/textureSize,
                };

            ctx.fillText(chStr, posx, posy+fontSize);
        }

        posx+=chWidth+12;
    }

    if(posy>textureSize-lineHeight)
    {
        result.fits=false;
    }

    result.spaceLeft=textureSize-posy;

    return result;
}

function generateTexture()
{
    var font=getFont();
    var string=String(str.get());
    if(string==null || string==undefined)string='';
    for(var i=0;i<string.length;i++)
    {
        var ch=string.substring(i,i+1);
        if(font.characters.indexOf(ch)==-1)
        {
            font.characters+=ch;
            createTexture=true;
        }
    }

    var ctx=font.ctx;
    font.canvas.width=font.canvas.height=textureSize;

    if(!font.texture)
        font.texture=CGL.Texture.createFromImage(cgl,font.canvas,
            {
                filter:filter
            });

    font.texture.setSize(textureSize,textureSize);

    ctx.fillStyle = 'transparent';
    ctx.clearRect(0,0,textureSize,textureSize);
    ctx.fillStyle = 'rgba(255,255,255,255)';

    var fontSize=font.fontSize+40;

    var simu=printChars(fontSize,true);
    while(!simu.fits)
    {
        fontSize-=5;
        simu=printChars(fontSize,true);
    }

    printChars(fontSize,false);

    ctx.restore();

    font.texture.initTexture(font.canvas,filter);
    font.texture.unpackAlpha=true;
    textureOut.set(font.texture);

    font.lastChange=CABLES.now();

    createMesh=true;
    createTexture=false;
}


};

Ops.Gl.Meshes.TextMesh_v2.prototype = new CABLES.Op();
CABLES.OPS["2390f6b3-2122-412e-8c8d-5c2f574e8bd1"]={f:Ops.Gl.Meshes.TextMesh_v2,objName:"Ops.Gl.Meshes.TextMesh_v2"};




// **************************************************************
// 
// Ops.TimeLine.TimeLineFrame
// 
// **************************************************************

Ops.TimeLine.TimeLineFrame = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var theTime=op.addOutPort(new CABLES.Port(this,"time"));

op.onAnimFrame=function(time)
{
    theTime.set(Math.round(time*30.0));
};

};

Ops.TimeLine.TimeLineFrame.prototype = new CABLES.Op();
CABLES.OPS["a6c66f1f-2102-4b68-882b-afd25a4da538"]={f:Ops.TimeLine.TimeLineFrame,objName:"Ops.TimeLine.TimeLineFrame"};




// **************************************************************
// 
// Ops.Trigger.Repeat
// 
// **************************************************************

Ops.Trigger.Repeat = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    num=op.inValueInt("num",5),
    trigger=op.outTrigger("trigger"),
    idx=op.addOutPort(new CABLES.Port(op,"index"));

exe.onTriggered=function()
{
    for(var i=Math.round(num.get())-1;i>-1;i--)
    {
        idx.set(i);
        trigger.trigger();
    }
};



};

Ops.Trigger.Repeat.prototype = new CABLES.Op();
CABLES.OPS["0f4d6489-ea7a-436b-b1b3-25a739e150c6"]={f:Ops.Trigger.Repeat,objName:"Ops.Trigger.Repeat"};




// **************************************************************
// 
// Ops.Gl.Matrix.Translate
// 
// **************************************************************

Ops.Gl.Matrix.Translate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const trigger=op.outTrigger("trigger")
const x=op.inValue("x");
const y=op.inValue("y");
const z=op.inValue("z");

const cgl=op.patch.cgl;

var vec=vec3.create();

render.onTriggered=function()
{
    vec3.set(vec, x.get(),y.get(),z.get());
    cgl.pushModelMatrix();
    mat4.translate(cgl.mMatrix,cgl.mMatrix, vec);
    trigger.trigger();
    cgl.popModelMatrix();
};


};

Ops.Gl.Matrix.Translate.prototype = new CABLES.Op();
CABLES.OPS["1f89ba0e-e7eb-46d7-8c66-7814b7c528b9"]={f:Ops.Gl.Matrix.Translate,objName:"Ops.Gl.Matrix.Translate"};




// **************************************************************
// 
// Ops.Array.ShuffleArray3
// 
// **************************************************************

Ops.Array.ShuffleArray3 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inArr=op.inArray("Array3"),
    inSeed=op.inFloat("Seed",5711),
    outArr=op.outArray("Result");

var newArr=[];
var rndArr=[];
inArr.onChange=update;
inSeed.onChange=update;

function fisherYatesShuffle(array)
{
    var i = 0;
    var j = 0;
    var temp = null;

    for (i = array.length - 1; i > 0; i -= 1)
    {
        j = Math.floor(Math.seededRandom() * (i + 1));
        temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}


function update()
{
    const arr = inArr.get();

    if(!arr || arr.length%3!==0) return;
    if(arr.length!=newArr.length) newArr.length = arr.length;

    var i = 0;
    var j = 0;
    var temp = null;
    Math.randomSeed=inSeed.get();

    for (i = 0; i < arr.length; i += 3)
    {
        rndArr[i/3]=i;
    }

    fisherYatesShuffle(rndArr);

    for (i = 0; i < arr.length; i += 3)
    {
        j=rndArr[i/3];

        newArr[i+0] = arr[j+0];
        newArr[i+1] = arr[j+1];
        newArr[i+2] = arr[j+2];
    }

    outArr.set(null);
    outArr.set(newArr);
}



};

Ops.Array.ShuffleArray3.prototype = new CABLES.Op();
CABLES.OPS["5176b7f8-4f01-4639-831e-28a6607711b2"]={f:Ops.Array.ShuffleArray3,objName:"Ops.Array.ShuffleArray3"};




// **************************************************************
// 
// Ops.Array.ArrayMerge_v2
// 
// **************************************************************

Ops.Array.ArrayMerge_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const inArr=op.inArray("Array"),
    inArr2=op.inArray("Array 2"),
    outArr=op.outArray("Result"),
    outArrayLength = op.outNumber("Array length");

var arr=[];

inArr.onChange=inArr2.onChange=function()
{
    var arr1 = inArr.get();
    var arr2 = inArr2.get();

    if(!arr1 || !arr2)
    {
        outArr.set(null);
        outArrayLength.set(0);
        return;
    }

    if(arr1 && arr2)
    {
        arr.length=0;
        arr=arr.concat(inArr.get());
        arr=arr.concat(inArr2.get());
    }
    outArr.set(null);
    outArr.set(arr);
    outArrayLength.set(arr.length);
};

};

Ops.Array.ArrayMerge_v2.prototype = new CABLES.Op();
CABLES.OPS["77eb7794-37e1-4c43-83b0-5dab6ec07e74"]={f:Ops.Array.ArrayMerge_v2,objName:"Ops.Array.ArrayMerge_v2"};




// **************************************************************
// 
// Ops.Deprecated.Gl.TextureEffects.PixelDisplacement
// 
// **************************************************************

Ops.Deprecated.Gl.TextureEffects.PixelDisplacement = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={pixeldisplace_frag:"\n#ifdef HAS_TEXTURES\n    IN vec2 texCoord;\n    UNI sampler2D tex;\n    UNI sampler2D displaceTex;\n#endif\nUNI float amountX;\nUNI float amountY;\n\nvoid main()\n{\n    vec4 col=vec4(1.0,0.0,0.0,1.0);\n    #ifdef HAS_TEXTURES\n        float mulX=1.0;\n        float mulY=1.0;\n        float x=mod(texCoord.x+mulX*(texture(displaceTex,texCoord).g-0.5)*2.0*amountX,1.0);\n        float y=mod(texCoord.y+mulY*(texture(displaceTex,texCoord).g-0.5)*2.0*amountY,1.0);\n\n\n        col=texture(tex,vec2(x,y) );\n//        col.rgb=desaturate(col.rgb,amount);\n   #endif\n   outColor= col;\n}",};
var render=op.inTrigger('render');

var amount=op.addInPort(new CABLES.Port(op,"amountX",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var amountY=op.addInPort(new CABLES.Port(op,"amountY",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));

var displaceTex=op.inTexture("displaceTex");
var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;

var shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.pixeldisplace_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var textureDisplaceUniform=new CGL.Uniform(shader,'t','displaceTex',1);

var amountXUniform=new CGL.Uniform(shader,'f','amountX',amount);
var amountYUniform=new CGL.Uniform(shader,'f','amountY',amountY);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    if(displaceTex.get())
        cgl.setTexture(1, displaceTex.get().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Deprecated.Gl.TextureEffects.PixelDisplacement.prototype = new CABLES.Op();
CABLES.OPS["cd2987b3-b07b-4bcb-935a-1bf038780b2c"]={f:Ops.Deprecated.Gl.TextureEffects.PixelDisplacement,objName:"Ops.Deprecated.Gl.TextureEffects.PixelDisplacement"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.GlitchNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.GlitchNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={glitchnoise_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\n{{CGL.BLENDMODES}}\n\nUNI float amount;\nUNI float time;\nUNI float frequency;\nUNI float strength;\nUNI float blockSizeA;\nUNI float blockSizeB;\nUNI float blockSizeC;\nUNI float blockSizeD;\nUNI float scrollX;\nUNI float scrollY;\n\nfloat rng2(vec2 seed)\n{\n    return fract(sin(dot(seed * floor(time * (frequency * 10.0)), vec2(127.1,311.7))) * 43758.5453123);//43758.5453123\n}\n\nfloat rng(float seed)\n{\n    return rng2(vec2(seed, 1.0));\n}\n\nvoid main( )\n{\n    //add scroll for x and y\n    vec2 scrollXY = vec2(scrollX,scrollY);\n    vec2 blockS = floor((texCoord + scrollXY ) * vec2(blockSizeA,blockSizeB));\n    vec2 blockL = floor((texCoord )  * vec2(blockSizeC,blockSizeD));\n\n    float r = rng2(texCoord);\n    vec3 noise = (vec3(r, 1. - r, r / 2. + 0.5) * 1.0 - 2.0) * 0.08;\n\n    float lineNoise = pow(rng2(blockS), 8.0) * pow(rng2(blockL), 3.0) - pow(rng(7.2341), 17.0) * 2.;\n\n    vec4 col1 = texture(tex, texCoord);\n    vec4 col2 = texture(tex, texCoord + vec2(lineNoise * (0.05 * strength)  * rng(5.0), 1));\n    vec4 col3 = texture(tex, texCoord - vec2(lineNoise * (0.05 * strength) * rng(31.0), 1));\n\n    float glitch = (lineNoise * strength * rng(5.0)) + (lineNoise * strength * rng(31.));\n    float glitch2 = lineNoise * strength * rng(31.);\n\n    //blend section\n    vec4 col=vec4(vec3(glitch),1.0);\n    //original texture\n    vec4 base=texture(tex,texCoord);\n\n    outColor=cgl_blend(base,col,amount);\n\n}",};
const
    render=op.inTrigger("render"),
    amount=op.inValueSlider("Amount",1),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    time=op.inValue('Seed',0.5),
    inFrequency=op.inValue('frequency',1),
    inStrength=op.inValue('strength',8.0),
    inBlockSizeA=op.inValue('Block size small x',24.0),
    inBlockSizeB=op.inValue('Block size small y',9.0),
    inBlockSizeC=op.inValue('Block size large x',8.0),
    inBlockSizeD=op.inValue('Block size large y',4.0),
    inScrollX=op.inValue('Scroll X',0.0),
    inScrollY=op.inValue('Scroll Y',0.0),
    trigger=op.outTrigger('trigger');

const TEX_SLOT=0;
const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);
shader.setSource(shader.getDefaultVertexShader(),attachments.glitchnoise_frag);

const
    textureUniform=new CGL.Uniform(shader,'t','tex',TEX_SLOT),
    uniformAmount=new CGL.Uniform(shader,'f','amount',amount),
    timeUniform=new CGL.Uniform(shader,'f','time',time),
    frequencyUniform=new CGL.Uniform(shader,'f','frequency',inFrequency),
    strengthUniform=new CGL.Uniform(shader,'f','strength',inStrength),
    sizeAUniform=new CGL.Uniform(shader,'f','blockSizeA',inBlockSizeA),
    sizeBUniform=new CGL.Uniform(shader,'f','blockSizeB',inBlockSizeB),
    sizeCUniform=new CGL.Uniform(shader,'f','blockSizeC',inBlockSizeC),
    sizeDUniform=new CGL.Uniform(shader,'f','blockSizeD',inBlockSizeD),
    scrollXUniform=new CGL.Uniform(shader,'f','scrollX',inScrollX),
    scrollYUniform=new CGL.Uniform(shader,'f','scrollY',inScrollY);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(TEX_SLOT, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.Noise.GlitchNoise.prototype = new CABLES.Op();
CABLES.OPS["a55eea17-efb8-4418-bcf9-7fefeecf40e5"]={f:Ops.Gl.TextureEffects.Noise.GlitchNoise,objName:"Ops.Gl.TextureEffects.Noise.GlitchNoise"};




// **************************************************************
// 
// Ops.Gl.Textures.SwitchTextures
// 
// **************************************************************

Ops.Gl.Textures.SwitchTextures = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exec=op.inTrigger("exec");
var num=this.inValueInt("num");
var defaultTransparent=op.inValueBool("Default Texture Transparent",true);
var textureOut=this.outTexture("texture");

var cgl=op.patch.cgl;
var texturePorts=[];
var index=0;
var lastIndex=-1;
var tempTexture=CGL.Texture.getEmptyTexture(cgl);

num.onChange=exec.onTriggered=function(){updateTexture();};


defaultTransparent.onChange=function()
{
    if(defaultTransparent.get()) tempTexture=CGL.Texture.getEmptyTexture(cgl);
        else tempTexture=CGL.Texture.getTempTexture(cgl);

    updateTexture(true);
};

for(var i=0;i<16;i++)
{
    var tex=op.inTexture("texture"+i);
    texturePorts.push(tex);
    tex.onChange=forceUpdateTexture;
}

function forceUpdateTexture()
{
    updateTexture(true);
}

function updateTexture(force)
{
    index=parseInt(num.get(),10);
    if(!force)
    {
        if(index == lastIndex)return;
        if(index != index)return;
    }
    if(
	    isNaN(index) ||
	    index < 0 ||
	    index > texturePorts.length-1
    )
	index = 0;

    if(texturePorts[index].get()) textureOut.set(texturePorts[index].get());
    else textureOut.set(tempTexture);

    lastIndex=index;
}


};

Ops.Gl.Textures.SwitchTextures.prototype = new CABLES.Op();
CABLES.OPS["2748c772-072f-43a9-9a3a-d717760b0e97"]={f:Ops.Gl.Textures.SwitchTextures,objName:"Ops.Gl.Textures.SwitchTextures"};




// **************************************************************
// 
// Ops.Math.RandomNumbers
// 
// **************************************************************

Ops.Math.RandomNumbers = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    index=op.inValueInt("index",0.0),
    seed=op.inValueFloat("random seed"),
    min=op.inValueFloat("Min",0),
    max=op.inValueFloat("Max",1),
    outX=op.outValue("X"),
    outY=op.outValue("Y"),
    outZ=op.outValue("Z"),
    inInteger=op.inValueBool("Integer",false);

var arr=[];
var numValues=100;
seed.set(Math.round(Math.random()*99999));

op.setPortGroup("Value Range",[min,max]);

index.onChange=update;

init();

op.init=inInteger.onChange=
max.onChange=min.onChange=
seed.onChange=inInteger.onChange=function()
{
    init();
    update();
}

function update()
{
    var idx=Math.floor(index.get())||0;
    if(idx*3>=arr.length)
    {
        numValues=idx+100;
        init();
    }

    idx*=3;

    outX.set(arr[idx+0]);
    outY.set(arr[idx+1]);
    outZ.set(arr[idx+2]);
};

function init()
{
    Math.randomSeed=seed.get();
    var isInteger = inInteger.get();
    var inMin = min.get();
    var inMax = max.get();
    arr.length=Math.floor(numValues*3) || 300;

    if(!isInteger)
    {
        for(var i=0;i<arr.length;i+=3)
        {
            arr[i+0]=Math.seededRandom() * ( inMax - inMin ) + inMin ;
            arr[i+1]=Math.seededRandom() * ( inMax - inMin ) + inMin ;
            arr[i+2]=Math.seededRandom() * ( inMax - inMin ) + inMin ;
        }
    }
    else
    {
        for(var i=0;i<arr.length;i+=3)
        {
            arr[i+0]=Math.floor(Math.seededRandom() * (inMax - inMin ) + inMin) ;
            arr[i+1]=Math.floor(Math.seededRandom() * (inMax - inMin ) + inMin) ;
            arr[i+2]=Math.floor(Math.seededRandom() * (inMax - inMin ) + inMin) ;
        }
    }
};


};

Ops.Math.RandomNumbers.prototype = new CABLES.Op();
CABLES.OPS["855880fa-6a85-4ba0-aac8-50440ccae948"]={f:Ops.Math.RandomNumbers,objName:"Ops.Math.RandomNumbers"};




// **************************************************************
// 
// Ops.Trigger.TriggerBetween
// 
// **************************************************************

Ops.Trigger.TriggerBetween = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=op.inTrigger("Exe");

var inIndex=op.inValueInt("Index");
var inNumber1=op.inValueInt("Number 1");
var inNumber2=op.inValueInt("Number 2");

var next=op.outTrigger("next");
var outFract=op.outValue("Fract");


exe.onTriggered=function()
{
    if(
        inIndex.get()>=Math.floor(inNumber1.get()) &&
        inIndex.get()<=inNumber2.get()+1
        )
        {
            var diff=inNumber2.get() - inIndex.get();

            if(inIndex.get()>Math.floor(inNumber2.get()))
            {
                outFract.set( 1.0+(inNumber2.get()-inIndex.get() ));
            }
            else
            if(inIndex.get()<inNumber1.get())
            {
                outFract.set( 1.0-(inNumber1.get()-inIndex.get() ));
            }
            else outFract.set(1);

            next.trigger();

        }

};

};

Ops.Trigger.TriggerBetween.prototype = new CABLES.Op();
CABLES.OPS["dadb4526-f751-4ee3-9acb-1fd41274fe6d"]={f:Ops.Trigger.TriggerBetween,objName:"Ops.Trigger.TriggerBetween"};




// **************************************************************
// 
// Ops.Anim.SimpleAnim
// 
// **************************************************************

Ops.Anim.SimpleAnim = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    reset=op.inTriggerButton("reset"),
    rewind=op.inTriggerButton("rewind"),
    inStart=op.inValueFloat("start",0),
    inEnd=op.inValueFloat("end",1),
    duration=op.inValueFloat("duration",0.5),
    loop=op.inValueBool("loop"),
    waitForReset=op.inValueBool("Wait for Reset",true),
    next=op.outTrigger("Next"),
    result=op.outValue("result"),
    finished=op.outValue("finished"),
    finishedTrigger=op.outTrigger("Finished Trigger");

const anim=new CABLES.Anim();
var resetted=false;
anim.createPort(op,"easing",init);
var currentEasing=-1;
loop.onChange=init;
init();

duration.onChange=init;


function init()
{
    if(anim.keys.length!=3)
    {
        anim.setValue(0,0);
        anim.setValue(1,0);
        anim.setValue(2,0);
    }

    anim.keys[0].time=CABLES.now()/1000.0;
    anim.keys[0].value=inStart.get();
    if(anim.defaultEasing!=currentEasing) anim.keys[0].setEasing(anim.defaultEasing);

    anim.keys[1].time=duration.get()+CABLES.now()/1000.0;
    anim.keys[1].value=inEnd.get();

    if(anim.defaultEasing!=currentEasing) anim.keys[1].setEasing(anim.defaultEasing);

    anim.loop=loop.get();
    if(anim.loop)
    {
        anim.keys[2].time=(2.0*duration.get())+CABLES.now()/1000.0;
        anim.keys[2].value=inStart.get();
        if(anim.defaultEasing!=currentEasing) anim.keys[2].setEasing(anim.defaultEasing);
    }
    else
    {
        anim.keys[2].time=anim.keys[1].time;
        anim.keys[2].value=anim.keys[1].value;
        if(anim.defaultEasing!=currentEasing) anim.keys[2].setEasing(anim.defaultEasing);
    }
    finished.set(false);

    currentEasing=anim.defaultEasing;
}

reset.onTriggered=function()
{
    resetted=true;
    init();
};

rewind.onTriggered=function()
{
    anim.keys[0].time=CABLES.now()/1000.0;
    anim.keys[0].value=inStart.get();

    anim.keys[1].time=CABLES.now()/1000.0;
    anim.keys[1].value=inStart.get();

    anim.keys[2].time=CABLES.now()/1000.0;
    anim.keys[2].value=inStart.get();

    result.set(inStart.get());
};

exe.onTriggered=function()
{
    if(waitForReset.get() && !resetted)
    {
        result.set(inStart.get());
        return;
    }
    var t=CABLES.now()/1000;
    var v=anim.getValue(t);
    result.set(v);
    if(anim.hasEnded(t))
    {
        if(!finished.get()) finishedTrigger.trigger();
        finished.set(true);
    }

    next.trigger();
};



};

Ops.Anim.SimpleAnim.prototype = new CABLES.Op();
CABLES.OPS["5b244b6e-c505-4743-b2cc-8119ef720028"]={f:Ops.Anim.SimpleAnim,objName:"Ops.Anim.SimpleAnim"};




// **************************************************************
// 
// Ops.String.LimitLineBreaks
// 
// **************************************************************

Ops.String.LimitLineBreaks = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inStr=op.inString("String","default"),
    inNum=op.inInt("Num Lines",5),
    inRev=op.inBool("Reverse",false),
    outStr=op.outString("Result","default");

var stringsNew=[];

inStr.onChange=
inNum.onChange=function()
{
    var strings=inStr.get().split('\n');

    if(inRev.get())
    {

        var num=inNum.get();
        if(strings.length>num)
        {
            for(var i=0;i<num;i++)
                stringsNew[num-i]=strings[strings.length-i];

            strings=stringsNew;
        }
    }
    else
    {
        strings.length=Math.min(inNum.get(),strings.length);
    }

    outStr.set(strings.join('\n'));

};

};

Ops.String.LimitLineBreaks.prototype = new CABLES.Op();
CABLES.OPS["3e761540-3648-45f8-ae47-8fad9ff95244"]={f:Ops.String.LimitLineBreaks,objName:"Ops.String.LimitLineBreaks"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Rectangle_v2
// 
// **************************************************************

Ops.Gl.TextureEffects.Rectangle_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={rectangle_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\n\nUNI float width;\nUNI float height;\nUNI float x;\nUNI float y;\n\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\nUNI float amount;\nUNI float rotate;\nUNI float roundness;\n\n#define DEG2RAD 0.785398163397\n\n{{CGL.BLENDMODES}}\n\nmat2 rot(float angle)\n{\n    float s=sin(angle);\n    float c=cos(angle);\n\n    return mat2(c,-s,s,c);\n}\n\n// polynomial smooth min (k = 0.1);\nfloat smin( float a, float b, float k )\n{\n    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );\n    return mix( b, a, h ) - k*h*(1.0-h);\n}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec4 col;\n    vec2 p=texCoord*2.0-1.0;\n    float d=1.0;\n\n    vec2 pp=vec2(p.x-x,p.y-y);\n\n    pp=pp*rot(rotate*DEG2RAD/45.0);\n\n    float roundn=roundness*min(width,height);\n\n    vec2 size=max(vec2(width,height)-roundn,0.0);\n    vec2 absPos=abs(pp)-size;\n\n    d=max(absPos.x,absPos.y);\n    d=min(d,length(max(absPos,0.0))-roundn);\n    d=step(0.0,d);\n\n    // d+=absPos.x+1.0;\n    // d=max(d,0.0);\n    // d=max(d,0.0);\n\n    col = vec4( (1.0-d)*vec3(r,g,b),1.0);\n\n    outColor= cgl_blend(base,col,amount);\n\n\n}\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n",};
const render=op.inTrigger('render'),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    inWidth=op.inValue("Width",0.25),
    inHeight=op.inValue("Height",0.25),
    inPosX=op.inValue("X",0.5),
    inPosY=op.inValue("Y",0.5),
    inRot=op.inValue("Rotate",0),
    inRoundness=op.inValueSlider("roundness",0);

const r = op.inValueSlider("r", Math.random()),
    g = op.inValueSlider("g", Math.random()),
    b = op.inValueSlider("b", Math.random()),
    a = op.inValueSlider("a",1.0);
r.setUiAttribs({ colorPick: true });

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'textureeffect rectangle');
shader.setSource(shader.getDefaultVertexShader(),attachments.rectangle_frag||'');
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var uniHeight=new CGL.Uniform(shader,'f','height',inHeight);
var unWidth=new CGL.Uniform(shader,'f','width',inWidth);
var uniX=new CGL.Uniform(shader,'f','x',inPosX);
var uniY=new CGL.Uniform(shader,'f','y',inPosY);
var uniRot=new CGL.Uniform(shader,'f','rotate',inRot);
var uniRoundness=new CGL.Uniform(shader,'f','roundness',inRoundness);

r.set(1.0);
g.set(1.0);
b.set(1.0);
a.set(1.0);

var uniformR=new CGL.Uniform(shader,'f','r',r);
var uniformG=new CGL.Uniform(shader,'f','g',g);
var uniformB=new CGL.Uniform(shader,'f','b',b);
var uniformA=new CGL.Uniform(shader,'f','a',a);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);
var uniformAmount=new CGL.Uniform(shader,'f','amount',amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Rectangle_v2.prototype = new CABLES.Op();
CABLES.OPS["fbe5f1c6-019b-4fa7-a65a-050a7cd7720e"]={f:Ops.Gl.TextureEffects.Rectangle_v2,objName:"Ops.Gl.TextureEffects.Rectangle_v2"};




// **************************************************************
// 
// Ops.Json.ObjectGetArray_v2
// 
// **************************************************************

Ops.Json.ObjectGetArray_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    data=op.inObject("data"),
    key=op.inString("key"),
    result=op.outArray("result"),
    arrLength=op.outValue("Length");

result.ignoreValueSerialize=true;
data.ignoreValueSerialize=true;

data.onChange=
    key.onChange=update;

function update()
{
    const dat=data.get();
    const k=key.get();
    if(dat && dat.hasOwnProperty(k))
    {
        result.set(dat[k]);
        arrLength.set(result.get().length);
    }
}


};

Ops.Json.ObjectGetArray_v2.prototype = new CABLES.Op();
CABLES.OPS["7c06a818-9c07-493a-8c4f-04eb2c7796f5"]={f:Ops.Json.ObjectGetArray_v2,objName:"Ops.Json.ObjectGetArray_v2"};




// **************************************************************
// 
// Ops.Gl.CanvasSize
// 
// **************************************************************

Ops.Gl.CanvasSize = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};


const
    width=op.outValue("width"),
    height=op.outValue("height"),
    pixelRatio=op.outValue("Pixel Ratio"),
    aspect=op.outValue("Aspect Ratio"),
    landscape=op.outValueBool("Landscape");

var cgl=op.patch.cgl;
cgl.addEventListener("resize",update);
update();

function update()
{
    height.set(cgl.canvasHeight);
    width.set(cgl.canvasWidth);
    pixelRatio.set(window.devicePixelRatio);
    aspect.set(cgl.canvasWidth/cgl.canvasHeight);
    landscape.set(cgl.canvasWidth>cgl.canvasHeight);
}


};

Ops.Gl.CanvasSize.prototype = new CABLES.Op();
CABLES.OPS["94e499e5-b4ee-4861-ab48-6ab5098b2cc3"]={f:Ops.Gl.CanvasSize,objName:"Ops.Gl.CanvasSize"};




// **************************************************************
// 
// Ops.Array.Array3Multiply
// 
// **************************************************************

Ops.Array.Array3Multiply = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var inArr=op.inArray("Array3x");

var mulX=op.inValue("Mul X",1);
var mulY=op.inValue("Mul Y",1);
var mulZ=op.inValue("Mul Z",1);

var outArr=op.outArray("Result");

var arr=[];

mulY.onChange=mulX.onChange=mulZ.onChange=
inArr.onChange=function()
{
    var newArr=inArr.get();
    if(newArr)
    {
        if(arr.length!=newArr.length)arr.length=newArr.length;

        for(var i=0;i<newArr.length;i+=3)
        {
            arr[i+0]=newArr[i+0]*mulX.get();
            arr[i+1]=newArr[i+1]*mulY.get();
            arr[i+2]=newArr[i+2]*mulZ.get();
        }

        outArr.set(null);
        outArr.set(arr);
    }
    else
    {
        outArr.set(null);
    }

};

};

Ops.Array.Array3Multiply.prototype = new CABLES.Op();
CABLES.OPS["a1e4d85f-0955-4ada-819c-c597cec40365"]={f:Ops.Array.Array3Multiply,objName:"Ops.Array.Array3Multiply"};




// **************************************************************
// 
// Ops.Gl.Meshes.Triangle
// 
// **************************************************************

Ops.Gl.Meshes.Triangle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger('render'),
    trigger=op.outTrigger('trigger'),
    sizeW=op.inValueFloat("width",1),
    sizeH=op.inValueFloat("height",1),
    draw=op.inValueBool("Draw",true),
    geom=new CGL.Geometry("triangle"),
    geomOut=op.outObject("geometry");

geomOut.ignoreValueSerialize=true;

op.setPortGroup("Size",[sizeW,sizeH]);

const cgl=op.patch.cgl;
var mesh=null;
sizeW.onChange=create;
sizeH.onChange=create;

create();

render.onTriggered=function()
{
    if(draw.get())mesh.render(cgl.getShader());
    trigger.trigger();
};

function create()
{
    geom.vertices = [
         0.0,           sizeH.get(),  0.0,
        -sizeW.get(),  -sizeH.get(),  0.0,
         sizeW.get(),  -sizeH.get(),  0.0
    ];

    geom.vertexNormals = [
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0
    ];
    geom.tangents = [
        1,0,0,
        1,0,0,
        1,0,0
    ];
    geom.biTangents = [
        0,1,0,
        0,1,0,
        0,1,0
    ];

    geom.texCoords = [
         0.5,  0.0,
         1.0,  1.0,
         0.0,  1.0,
    ];

    geom.verticesIndices = [
        0, 1, 2
    ];

    mesh=new CGL.Mesh(cgl,geom);
    geomOut.set(null);
    geomOut.set(geom);
}



};

Ops.Gl.Meshes.Triangle.prototype = new CABLES.Op();
CABLES.OPS["331bc9dc-d44c-43bd-be18-a2673fba124e"]={f:Ops.Gl.Meshes.Triangle,objName:"Ops.Gl.Meshes.Triangle"};




// **************************************************************
// 
// Ops.Math.Compare.GreaterThan
// 
// **************************************************************

Ops.Math.Compare.GreaterThan = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    result=op.outValue("result"),
    number1=op.inValueFloat("number1"),
    number2=op.inValueFloat("number2");

number1.onChange=number2.onChange=exec;

function exec()
{
    result.set(number1.get()>number2.get());
}



};

Ops.Math.Compare.GreaterThan.prototype = new CABLES.Op();
CABLES.OPS["b250d606-f7f8-44d3-b099-c29efff2608a"]={f:Ops.Math.Compare.GreaterThan,objName:"Ops.Math.Compare.GreaterThan"};




// **************************************************************
// 
// Ops.String.LeftPad
// 
// **************************************************************

Ops.String.LeftPad = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var val=op.inValue("Value",1);
var char=op.inValueString("Char",'0');
var num=op.inValueInt("Num",4);
var out=op.outValue("String");

val.onChange=update;
char.onChange=update;
num.onChange=update;

function update()
{
    var v=val.get();
    var n=num.get();

    var pad='';
    for(var i=0;i<n;i++)pad+=(''+char.get());
    
    var str=v+'';
    str = pad.substring(0, pad.length - str.length) + str;

    out.set(str);
}

};

Ops.String.LeftPad.prototype = new CABLES.Op();
CABLES.OPS["9f4302de-6ae1-4fd0-8be7-c8ed0eca4deb"]={f:Ops.String.LeftPad,objName:"Ops.String.LeftPad"};




// **************************************************************
// 
// Ops.String.StringEquals
// 
// **************************************************************

Ops.String.StringEquals = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    str1=op.inString("String 1"),
    str2=op.inString("String 2"),
    result=op.outValueBool("Result");


str1.onChange=
str2.onChange=
    function()
    {
        result.set(str1.get()==str2.get());
    };

};

Ops.String.StringEquals.prototype = new CABLES.Op();
CABLES.OPS["ef15195a-760b-4ac5-9630-322b0ba7b722"]={f:Ops.String.StringEquals,objName:"Ops.String.StringEquals"};




// **************************************************************
// 
// Ops.Array.ParseArray_v2
// 
// **************************************************************

Ops.Array.ParseArray_v2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var text=op.inStringEditor("text",'1,2,3');
var separator=op.inValueString("separator",",");
var toNumber=op.inValueBool("Numbers",true);
var parsed=op.outTrigger("Parsed");
var arr=op.outArray("array");
var len=op.outValue("length");

text.onChange=parse;
separator.onChange=parse;
toNumber.onChange=parse;

parse();

function parse()
{
    if(!text.get())return;

    var r=text.get().split(separator.get());

    if(r[r.length-1]==="") r.length-=1;

    len.set(r.length);

    if(toNumber.get())
        for(var i=0;i<r.length;i++)
            r[i]=Number(r[i]);

    arr.set(null);
    arr.set(r);
    parsed.trigger();
}


};

Ops.Array.ParseArray_v2.prototype = new CABLES.Op();
CABLES.OPS["c974de41-4ce4-4432-b94d-724741109c71"]={f:Ops.Array.ParseArray_v2,objName:"Ops.Array.ParseArray_v2"};




// **************************************************************
// 
// Ops.String.CharacterRotate
// 
// **************************************************************

Ops.String.CharacterRotate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    inUpdate=op.inTriggerButton("Update"),
    inReset=op.inTriggerButton("Reset"),
    inText=op.inString("Text"),
    inSeed=op.inFloat("Random Seed",0),
    inChars=op.inString("Characters","abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 -_+!"),
    result=op.outString("Result");

var positions=[];
var position=0;
var resultString="";

inSeed.onChange=init;
inText.onChange=init;
inReset.onTriggered=init;

function init()
{
    position++;
    var txt=inText.get();
    var alphab=inChars.get();

    resultString="";

    Math.randomSeed=inSeed.get();

    for(var i=0;i<txt.length;i++)
    {
        if(inSeed.get()==0)
        {
            resultString+=alphab[0];
        }
        else
        {
            resultString+=alphab[Math.floor(Math.seededRandom()*alphab.length)];
        }
    }

    result.set(resultString);
}

inUpdate.onTriggered=function()
{
    var txt=inText.get();
    var alphab=inChars.get();

    if(!resultString) init();
    var newStr="";

    for(var i=0;i<txt.length;i++)
    {
        if(txt[i]!=resultString[i])
        {
            var newindex=alphab.indexOf(resultString[i])+1;

            if(newindex>alphab.length-1)newindex=0;
            newStr+=alphab[newindex];
        }
        else
        {
            newStr+=txt[i];
        }
    }
    resultString=newStr;

    result.set(resultString);


};

};

Ops.String.CharacterRotate.prototype = new CABLES.Op();
CABLES.OPS["9dcc7ad1-c790-4c9d-9f2a-a902bd8d6cc8"]={f:Ops.String.CharacterRotate,objName:"Ops.String.CharacterRotate"};




// **************************************************************
// 
// Ops.Trigger.TriggerLimiter
// 
// **************************************************************

Ops.Trigger.TriggerLimiter = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var inTriggerPort = op.inTrigger("In Trigger");
var timePort = op.inValue("Milliseconds", 300);
var outTriggerPort = op.outTrigger("Out Trigger");
var progress=op.outValue("Progress");

var lastTriggerTime = 0;

// change listeners
inTriggerPort.onTriggered = function()
{
    var now = CABLES.now();
    var prog=(now-lastTriggerTime )/timePort.get();

    if(prog>1.0)prog=1.0;
    if(prog<0.0)prog=0.0;

    // console.log(prog);
    progress.set(prog);

    if(now >=lastTriggerTime + timePort.get())
    {
        lastTriggerTime = now;
        // progress.set(1.0);
        outTriggerPort.trigger();
    }
};

};

Ops.Trigger.TriggerLimiter.prototype = new CABLES.Op();
CABLES.OPS["47641d85-9f81-4287-8aa2-35753b0727e0"]={f:Ops.Trigger.TriggerLimiter,objName:"Ops.Trigger.TriggerLimiter"};




// **************************************************************
// 
// Ops.Math.Compare.GreaterOrEquals
// 
// **************************************************************

Ops.Math.Compare.GreaterOrEquals = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    result=op.outValue("result"),
    number1=op.inValueFloat("number1"),
    number2=op.inValueFloat("number2");

number1.onChange=number2.onChange=exec;

function exec()
{
    result.set(number1.get()>=number2.get());
}



};

Ops.Math.Compare.GreaterOrEquals.prototype = new CABLES.Op();
CABLES.OPS["5f9ce320-1e8d-49cb-9927-337e0b3f4d45"]={f:Ops.Math.Compare.GreaterOrEquals,objName:"Ops.Math.Compare.GreaterOrEquals"};




// **************************************************************
// 
// Ops.Value.SwitchNumber
// 
// **************************************************************

Ops.Value.SwitchNumber = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var idx=op.inValueInt("Index");
var valuePorts=[];
var result=op.outValue("Result");

idx.onChange=update;

for(var i=0;i<10;i++)
{
    var p=op.inValue("Value "+i);
    valuePorts.push( p );
    p.onChange=update;
}

function update()
{
    if(idx.get()>=0 && valuePorts[idx.get()])
    {
        result.set( valuePorts[idx.get()].get() );
    }
}

};

Ops.Value.SwitchNumber.prototype = new CABLES.Op();
CABLES.OPS["fbb89f72-f2e3-4d34-ad01-7d884a1bcdc0"]={f:Ops.Value.SwitchNumber,objName:"Ops.Value.SwitchNumber"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Dither
// 
// **************************************************************

Ops.Gl.TextureEffects.Dither = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={dither_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float strength;\nUNI float amount;\nUNI float width;\nUNI float height;\nUNI float threshold;\n\nfloat lumi( vec4 col ) {\n    return (0.2126*col.r + 0.7152*col.g + 0.0722*col.b);\n}\n\n{{CGL.BLENDMODES}}\n\nfloat adjustFrag( mat4 adjustments,float val, vec2 coord )\n{\n    vec2 coordMod = mod(vec2(coord.x*width,coord.y*height), 4.0);\n    int xMod = int(coordMod.x);\n    int yMod = int(coordMod.y);\n\n    vec4 col;\n    if (xMod == 0) col = adjustments[0];\n        else if (xMod == 1) col = adjustments[1];\n        else if (xMod == 2) col = adjustments[2];\n        else if (xMod == 3) col = adjustments[3];\n\n    float adjustment;\n    if (yMod == 0) adjustment = col.x;\n        else if (yMod == 1) adjustment = col.y;\n        else if (yMod == 2) adjustment = col.z;\n        else if (yMod == 3) adjustment = col.w;\n\n    return val + (val * adjustment);\n}\n\nvoid main()\n{\n    mat4 adjustments = ((mat4(\n        1, 13, 4, 16,\n        9, 5, 12, 8,\n        3, 15, 2, 14,\n        11, 7, 10, 6\n    ) - 8.) *  1.0 / strength);\n\n    vec4 base=texture(tex,texCoord);\n    vec4 color;\n\n    float lum = lumi(base);\n    lum = adjustFrag(adjustments,lum, texCoord.xy);\n\n    if (lum > threshold) color = vec4(1, 1, 1, 1);\n        else color = vec4(0, 0, 0, 1);\n\n    outColor=cgl_blend(base,color,amount);\n}",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    trigger=op.outTrigger("Trigger"),
    strength=op.inValue("strength",2),
    threshold=op.inValueSlider("threshold",0.35);

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),attachments.dither_frag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    strengthUniform=new CGL.Uniform(shader,'f','strength',strength),
    uniWidth=new CGL.Uniform(shader,'f','width',0),
    uniHeight=new CGL.Uniform(shader,'f','height',0),
    unithreshold=new CGL.Uniform(shader,'f','threshold',threshold);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Dither.prototype = new CABLES.Op();
CABLES.OPS["4fb6167d-a9b0-4604-84c4-755b09fd8dd7"]={f:Ops.Gl.TextureEffects.Dither,objName:"Ops.Gl.TextureEffects.Dither"};


