var Shadercats = function(){
  PartBase.call(this);
  this.createCats();
  this.createBg();
  this.catsMove = true;
};

Shadercats.prototype = PartBase.prototype.inheritance();

Shadercats.prototype.animateCats = function(elapsedTime) {
  for(var i=0; i<this.catArray.length; i++) {
    var c = this.catArray[i];
    c.position.y = (Math.sin(elapsedTime)*(c.position.z*0.1+1)+Math.cos(elapsedTime)*(0.1*c.position.x-1));
  }
};



Shadercats.prototype.moveCats = function(elapsedTime) {
  var catRot = TDEMO.SYNC.getObjRotation();
  var catPos = TDEMO.SYNC.getObjPosition();
  this.cats.position.x = catPos.x;
  this.cats.position.y = catPos.y;
  this.cats.position.z = catPos.z;
  
  this.cats.rotation.x = catRot.x;
  this.cats.rotation.y = catRot.y;
  this.cats.rotation.z = catRot.z;
  
};


Shadercats.prototype.circlesOn = function(value) {
  if (value !== 0 && this.circlesCount !== 0) {
    this.circlesCount = 3;
    this.uniforms.circlesOn.value = 3;
  } else {
    this.uniforms.circlesOn.value = value;
    this.circlesCount = value;
  }
};


Shadercats.prototype.animateShader = function(trig, bgControl) {
  //var trig = TDEMO.SYNC.getCircle();
  var trig = 2

  if(this.elapsed == 0) { 
    this.timepoint1 = 0;
    this.timepoint2 = 0;
    this.circleStarted = false;
    this.circleStarted2 = false;
  }  

  

  if (trig === 2 && !this.circleStarted2) {
    //this.circlesOn(2);
    this.circlesOn(2);
    this.timepoint2 = (this.elapsed*0.525) % Math.PI;
    this.circleStarted2 = true;
  }
    

  this.uniforms.circleTime.value = (Math.PI/2+this.elapsed*0.75 - this.timepoint1);
  this.uniforms.circleTime2.value = (Math.PI/2+this.elapsed*0.525 - this.timepoint2);

  this.uniforms.gtime.value = this.elapsed+this.bgtimeskip;
  this.uniforms.time.value = this.elapsed*0.75+this.bgtimeskip;
  this.bguniforms.time.value = this.elapsed;
};

Shadercats.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta, true);

  var hb = TDEMO.SYNC.getHeartBeat();
  if (this.catsMove) this.animateCats(elapsedTime);
  if (hb === 1) this.catsMove = false;
  this.moveCats();
  this.animateShader();  
};


Shadercats.prototype.createCats = function() {
  this.planeMaterial = this.createMaterial();
  this.kissat();
  var startx = -30;
  var starty = 30;
  var startz = -30;
};

Shadercats.prototype.createBg = function() {
  this.bgMaterial = this.createBgMaterial();
  var geometry = new THREE.BoxGeometry(200, 200, 200);
  this.bgbox = new THREE.Mesh(geometry, this.bgMaterial);
  this.bgbox.position.z = -50;
  this.scene.add(this.bgbox);   
}


Shadercats.prototype.kissat = function() {
  var kissat = kissalauma(this.planeMaterial);
  this.cats = kissat["cats"];
  this.catArray = kissat["catArray"];
  this.scene.add(this.cats);
  this.cats.position.set(0,-30,0);
  this.cats.rotation.y = Math.PI / 6; 
};


Shadercats.prototype.createMaterial = function(){
  this.timepoint1 = 0;
  this.timepoint2 = 0;
  this.circleStarted = false;
  this.circleStarted2 = false;
  this.circlesCount = 0;
  this.bgtimeskip = 0;

  this.uniforms = {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(this.width, this.height)},
    gtime : {type : "f", value: 0.0},
    circleTime : {type : "f", value: 0.0},
    circleTime2 : {type : "f", value: 0.0},
    circlesOn : {type : "i", value: 0},
    bgpart : {type: "i", value: 0}
  };

  var material = new THREE.ShaderMaterial({
    uniforms : this.uniforms,
    vertexShader: MSHADERS.mvertex,
    fragmentShader: MSHADERS.circlesFragment,
    side : THREE.DoubleSide
  });
  
  return material; 
}


Shadercats.prototype.createBgMaterial = function(){

  this.bguniforms = {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(this.width, this.height)},
  };

  var material = new THREE.ShaderMaterial({
    uniforms : this.bguniforms,
    vertexShader: MSHADERS.mvertex,
    fragmentShader: MSHADERS.bgFragment,
    side : THREE.DoubleSide
  });
  
  return material; 
}
