//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF_Y		EQU	48
;---
TBL16		EQU	#7F00
;---
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF1A		EQU	#7F00 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
MOVET_ADR	EQU	#DB00
MOVET_ATTR	EQU	#5800
MOVET_SZ	EQU	4*16*BUFF_Y+2


MPG	EQU	#10
P08	EQU	#08
P7F	EQU	#7F
PFD	EQU	#FD

MTBSTP1	EQU	128;128*6
MTBSTP2 EQU	128;-128*4

MDXSTEP	EQU	1
MDYSTEP EQU	2

//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	
	LD	A,#17
	CALL	PAGER
	
	LD	HL,#4000
	LD	DE,#4001
	LD	(HL),#F0
	LD	BC,6143
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR

	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR
;-----------
	LD	HL,#7F00
	LD	B,16
	LD	A,L
INI16	LD	(HL),A
	INC	L
	ADD	A,#10
	DJNZ	INI16
;-----------
	CALL	INIMOVE
;-----------
	CALL	SWAPBUFF
	JP	SWP
;-----------
INIMOVE
	LD	HL,MOVET_ADR
	LD	DE,MOVET_ATTR
	LD	LX,BUFF_Y - 38
	CALL	INIMV0
	LD	LX,38
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000
	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_

;378+378+378=1134
;1536-1134=402

	EI
	HALT
	LD	A,0
BORDER	EQU	$-1
	OUT	(#FE),A
	
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM
	
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	DISTORT
	CALL	SWAPBUFF
	CALL	SWP
	CALL	MOVE_BOTTOM
	RET
//======================================================== FX_PROCEDURES
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	LD	DE,0
SWP_BUFFA_BOTT EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
	LD	DE,0
SWP_BUFFB_BOTT EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	LD	(MOVE_BOTTOM_SP),DE
	RET
;--------------------------
SWAPBUFF
	LD	A,(MDX)
	ADD	A,MDXSTEP
	AND	63
	LD	(MDX),A
	;---------------
	LD	A,(MDY)
	ADD	A,MDYSTEP
	AND	31
	LD	(MDY),A
	;---------------
	LD	HL,MAPTBL
SWAPMAPTBL EQU $-2
	LD	(MAP_MAPTBL),HL
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF1A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB_BOTT),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF2A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB_BOTT),HL
	RET
;--------------------------
MOVE_TOP
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP1),SP
	LD	SP,0
MOVE_TOP_SP	EQU $-2
	LD	DE,MOVE_TOP1
	JP	MOVET_ADR + (BUFF_Y - 38) * 16 * 4  + 2
	
	DISPLAY	"MVTOP ", /A, MOVET_ADR + (BUFF_Y - 38) * 16 * 4 + 2
	
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;--------------------------
MOVE_BOTTOM
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP2),SP
	LD	SP,0
MOVE_BOTTOM_SP	EQU $-2
	LD	DE,MOVE_BOTTOM1
	JP	MOVET_ADR
MOVE_BOTTOM1
	LD	SP,0
SOHRSP2	EQU	$-2
	RET
;--------------------------
MAPPING	LD	BC,#7FFD
	LD	A,MPG
	OUT	(C),A
	EX	AF,AF
	;-----
	LD	A,16-2
	DEC	A
	JP	NZ,$-1
	;-----
	LD	(MAPPING_SOHR_SP),SP
	LD	IY,MAPTBL
MAP_MAPTBL EQU $-2
	LD	SP,IY
	LD	DE,BUFF1A + BUFFSZ - 1
MAP_BUFFA EQU $-2
	LD	BC,BUFF1B + BUFFSZ - 1
MAP_BUFFB EQU $-2
	LD	H,PALETTE / 256
PALADR	EQU $-1
	EXX
	LD	B,P7F
	LD	DE,0	;mapping scroll, rotate
MDX	EQU	$-2
MDY	EQU	$-1
MAPP1	;-----------------------------
	DUP	2
	;---
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*7=791
	;---
	EDUP
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63 /=>854
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---w8
	NOP:NOP
	;----------------------
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 50
	;---
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*7=791 +50 /=> 841
	;---
	EDUP
	;---w4
	NOP
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---w17
	LD A,R:NOP:NOP
	;---
	EDUP
	;---------------------------------
	DUP	2
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*2=226
	;---
	EDUP
	;---
	LD	BC,MTBSTP1 ;10
MTBL_STEP_1 EQU $-2
	ADD	IY,BC	;15
	LD	SP,IY	;10
	LD	B,P7F	;7 /42 
	;---
	DUP	3
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*2=339
	;---
	EDUP
	;---W237
	LD A,16
	DEC A
	JP NZ,$-1
	DEC HL
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---W18
	LD HL,0:NOP:NOP
	;---------------------------------
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*7=791
	;---
	EDUP
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63 /=>854
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---w8
	NOP:NOP
	;----------------------
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 50
	;---
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*7=791 +50 /=> 841
	;---
	EDUP
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---w21
	LD A,R:NOP:NOP:NOP
	;---------------------------------
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*7=791
	;---
	EDUP
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63 /=>854
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---w8
	NOP:NOP
	;----------------------
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 50
	;---
	DUP	6
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 113*6=678 +50 /=> 728
	;---
	EDUP
	;---
	LD	BC,MTBSTP2 ;10
MTBL_STEP_2 EQU $-2
	ADD	IY,BC	;15
	LD	SP,IY	;10
	LD	B,P7F	;7 /42 
	;---w74
	LD A,4
	DEC A
	JP NZ,$-1
	RET NZ
	DEC HL
	;---
	LD	C,PFD	;7
	EX	AF,AF	;4
	XOR	P08	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /34
	;---
	DEC	LX	 ;8
	JP	NZ,MAPP1 ;10 /18
	;----------------------------------
MAPP2	EXX
	LD	(MAP_BUFFA),DE
	LD	(MAP_BUFFB),BC
	LD	(MAP_MAPTBL),IY
	;---------
	LD	SP,0
MAPPING_SOHR_SP	EQU $-2
	RET
//======================================================== FX_INCLUDE_DATA
DISTORT
	LD	A,0
BORDER_NEXT EQU $-1
	LD	(BORDER),A


	LD	A,1
FZA	EQU $-1
	INC	A
	AND	31
	LD	(FZA),A
	JP	NZ,NOSHIFT
	LD	A,2
	LD	(AAA),A
NOSHIFT ;--
	LD	A,0
AAA	EQU	$-1
	SUB	1
	ADC	A,0
	LD	(AAA),A
	;--
	LD	BC,PALETTE + 0
	JR	Z,NOS
	LD	BC,PALETTE7 + 7
	LD	A,(MDY)		;visual stop correction
	ADD	A,MDYSTEP
	AND	31
	LD	(MDY),A
	
NOS	LD	A,B
	LD	(PALADR),A
	LD	A,C
	LD	(BORDER_NEXT),A
	RET


	

	
	
	
	
	

	
//======================================================== FX_TABLES
	DUP	64*4
	DW	#C000
	EDUP
MAPTBL	INCLUDE "bin/map_intor.asm"
MAPTBL_END
	DUP	64*4
	DW	#C000
	EDUP

	ALIGN	256
PALETTE	INCBIN "bin/palette.bin"
PALETTE7 INCBIN "bin/palette7.bin"


	DISPLAY "MOVE_ADR: ", /A, MOVET_ADR
	DISPLAY "MOVE_SZ: ", /A, MOVET_SZ
	DISPLAY "MOVE_END: ", /A, MOVET_ADR + MOVET_SZ
	DISPLAY "MAPTBL: ", /A, MAPTBL
	DISPLAY "MAPTBL_SZ: ", /A, MAPTBL_END - MAPTBL
	DISPLAY "MAPTBL_END: ", /A, MAPTBL_END
	
	
	
	
	


	
	
	
	
	
	
	
	

