//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
ALPHAX_STEP	EQU	#0400
ALPHAY_STEP	EQU	#0300
//======================================================== FX_INIT
EFF_INI_
	LD	A,#10
	CALL	PAGER
	JP	NEXTFRAME
//======================================================== FX_MAINLOOP
EFF_RUN_

	IF SHOW_FRAMES=1
	  LD	A,(FRAMES_QTY)
	  PUSH	AF
	  PUSH	AF
	  XOR	A
	  LD	(FRAMES_QTY),A
	ENDIF

	EI
	HALT
	
	IF SHOW_FRAMES=1
	  POP AF:OUT (#FE),A
	ENDIF

	CALL	MAKE_TBL_U
	CALL	MAKE_TBL_V
	
	IF SHOW_FRAMES=1
	  LD A,7:OUT (#FE),A
	ENDIF

	CALL	OUTPUT
	
	IF SHOW_FRAMES=1
	  POP AF:OUT (#FE),A
	ENDIF

	CALL	NEXTFRAME

	IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
	ENDIF

	RET
	

	
//======================================================== FX_PROCEDURES
NEXTFRAME
	LD	HL,0
ALPHAX	EQU	$-2
	LD	BC,ALPHAX_STEP
	ADD	HL,BC
	LD	(ALPHAX),HL
	LD	A,H
	;-
	LD	H,COS_X/256
	LD	L,A
	LD	A,(HL)
	ADD	A,#C0
	LD	(XY1 + 1),A
	;-
	LD	A,L
	ADD	A,128
	LD	L,A
	LD	A,(HL)
	ADD	A,#C0
	LD	(XY2 + 1),A	
	;-----
	LD	HL,0
ALPHAY	EQU	$-2
	LD	BC,ALPHAY_STEP
	ADD	HL,BC
	LD	(ALPHAY),HL
	LD	A,H
	;--
	LD	H,SIN_Y/256
	LD	L,A
	LD	A,(HL)
	ADD	A,24
	LD	(XY1),A
	;-
	LD	A,L
	ADD	A,128
	LD	L,A
	LD	A,(HL)
	ADD	A,24
	LD	(XY2),A
	;-----
	LD	HL,D_MOV
	INC	(HL)
	INC	(HL)
	LD	HL,D_ROT
	INC	(HL)
	;--
	RET
;-------------------------------
MAKE_TBL_V
	LD	HL,#C000 + 4*256 + 4
XY1	EQU	$-2
	LD	DE,#C000 + 28*256 + 20
XY2	EQU	$-2
	LD	BC,TBL + 1
	JR	MAKE_TBL
;-----
MAKE_TBL_U
	LD	HL,(XY1)
	LD	A,L
	ADD	A,96
	LD	L,A
	;-
	LD	DE,(XY2)
	LD	A,E
	ADD	A,96
	LD	E,A
	LD	BC,TBL
;-----
MAKE_TBL
	LD	HX,24
MT2	;--
	PUSH	HL
	PUSH	DE
MT1	;-----
	DUP	32
	;-----
	LD	A,(DE)
	SUB	(HL)
	INC	D
	INC	H
	RRA
	RRA
	AND	%00111111
	LD	(BC),A
	INC	BC	;4
	INC	BC	;7 /18 = 126
	;--
	EDUP
	;--
	POP	DE
	INC	DE
	POP	HL
	INC	HL
	;--
	DEC	HX
	JP	NZ,MT2
	;--
	RET
;----------------------
OUTPUT
	LD	BC,TBL + 1535
	LD	DE,#5800
	LD	LY,24
	LD	IX,0
D_MOV	EQU	$-1
D_ROT	EQU	$-2
OUT1	;------
	DUP	32
	;------
	LD	A,(BC)
	ADD	A,LX
	OR	#C0
	LD	L,A
	DEC	BC
	;--
	LD	A,(BC)
	ADD	A,HX
	OR	#C0
	LD	H,A
	;--
	LDI
	;------
	EDUP
	;------
	DEC	LY
	JP	NZ,OUT1
	;--
	RET
//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
	ALIGN 256
COS_X	INCBIN "bin/duo_tunnel_cos_x.bin"
SIN_Y	INCBIN "bin/duo_tunnel_sin_y.bin"
TBL

