//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF	EQU	#9D00
COS_A	EQU	#C0
SIN_A	EQU	#C0 + 16
MDX0	EQU	0
MDY0	EQU	0


ROT_STEP	EQU	#0200
MOV_X_STEP	EQU	#0500
MOV_Y_STEP	EQU	#0400

//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	;--
	CALL	MRTCLR
	CALL	NEXT
	;--
	LD	HL,#4000
	LD	BC,256 * 24 + #FF
	LD	A,L
	LD	A,#FF
INI1	LD	(HL),A
	INC	L
	JP	NZ,INI1
	;XOR	C
	INC	H
	DJNZ	INI1
	;--
	LD	HL,#C000
	LD	BC,256 * 24 + #FF
	LD	A,C
	LD	A,#FF
INI2	LD	(HL),A
	INC	L
	JP	NZ,INI2
	;XOR	C
	INC	H
	DJNZ	INI2
	;----
	EI
	HALT
	LD	HL,FX_SWAP_PG
	LD	(IM2CALL),HL
	;---
	RET
//======================================================== FX_MAINLOOP

EFF_RUN_
		IF SHOW_FRAMES=1
		LD	A,(FRAMES_QTY)
		PUSH	AF
		XOR	A
		LD	(FRAMES_QTY),A
		ENDIF
	EI
	HALT
		IF SHOW_FRAMES=1
		POP AF:OUT (#FE),A
		ENDIF
	CALL	MRT
	CALL	MRTOUT
	CALL	MRTCLR
	CALL	NEXT
		IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
		ENDIF
	RET
//======================================================== FX_PROCEDURES
NEXT	
	LD	HL,0
ROTHL	EQU	$-2
	LD	BC,ROT_STEP
	ADD	HL,BC
	LD	(ROTHL),HL
	LD	L,H
	LD	H,TBL_ROT / 256
	LD	A,(HL)
	LD	(ROTA),A
	;---
	LD	HL,0
MOV_X	EQU	$-2
	LD	BC,MOV_X_STEP
	ADD	HL,BC
	LD	(MOV_X),HL
	LD	L,H
	LD	H,TBL_MOV_X / 256
	LD	A,(HL)
	LD	(MDX),A
	;---
	LD	HL,0
MOV_Y	EQU	$-2
	LD	BC,MOV_Y_STEP
	ADD	HL,BC
	LD	(MOV_Y),HL
	LD	L,H
	LD	H,TBL_MOV_Y / 256
	LD	A,(HL)
	LD	(MDY),A
	;---
	RET
;--------------------------------------




MRTOUT
	LD	A,(PAGE)
	OR	#07
	CALL	PAGER	
	;---
	LD	D,PAL_A / 256
	LD	BC,#5800
	EXX
	LD	D,PAL_B / 256
	LD	BC,#D800
	;--
	LD	A,(PAGE)
	AND	#08
	JR	NZ,MRTOUT2
	EXX
	;--
MRTOUT2
	CALL	MRTOUT0
	EXX
	;----
MRTOUT0	LD	LX,24
	LD	L,low BUFF + 6
MRTOUT1	;---
	LD	H,high BUFF
	DUP	31
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	C	;4
	INC	H	;4
	EDUP
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(BC),A	;7
	INC	BC	;6
	INC	L	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT1 ;10
	;--
	RET
;-------------------------------------------
MRTCLR
	LD	(MRTCLR_SOHR_SP),SP
	;---
	LD	A,32
	LD	BC,0
	LD	HL,BUFF+24+6
MRTCLR1	LD	SP,HL
	DUP	12
	PUSH	BC
	EDUP
	INC	H
	DEC	A
	JP	NZ,MRTCLR1
	;---
	LD	SP,0
MRTCLR_SOHR_SP EQU $-2
	RET

;tx = x*cos(a)-y*sin(a);
;ty = x*sin(a)+y*cos(a);
MRT	
	LD	A,(PAGE)
	AND	#18
	CALL	PAGER
	;---
	LD	A,0
ROTA	EQU	$-1
	OR	#C0
	LD	(COS1+1),A
	LD	(COS2+1),A
	LD	(ROTH+1),A
	ADD	A,16
	OR	#C0
	LD	(SIN1+1),A
	LD	(SIN2+1),A
	;---
	LD	DE,BUFF
ROTH	LD	H,0
	EXX
	LD	(MRT_SOHR_SP),SP
	LD	SP,ROMBSMAP
	;LD	DE,ROMBSMAP
	LD	HX,30
MRT2	;----------------
	LD	LX,32
MRT1	;----------------
	;EX	DE,HL
	;LD	C,(HL)
	;INC	L
	;LD	B,(HL)
	;INC	HL	
	;EX	DE,HL
	POP	BC	;10 /10
	; -- координаты C=x B=y
COS1	LD	H,COS_A	;7
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*cos(a)
SIN1	LD	H,SIN_A	;7
	LD	L,B	;4 (hl)=y*sin(a)
	SUB	(HL)	;7 a=y`
	ADD	A,MDX0	;7
MDX	EQU	$-1
	LD	L,A	;4
	LD	H,high TXCOR ;7
	LD	A,(HL)	;7
	LD	L,C	;4
	LD	C,A	;4
	;--
SIN2	LD	H,SIN_A	;7
	LD	A,(HL)	;7 a=(hl)=x*sin(a)
COS2	LD	H,COS_A	;7
	LD	L,B	;4
	ADD	A,(HL)	;7
	ADD	A,MDY0	;7
MDY	EQU	$-1
	OR	#C0	;7
	LD	B,A	;4
	LD	A,(BC)	;7 /54 /=>119
	;--------
	DI
	EXX		;4
	;--------
	OR	A	   ;4
	JP	Z,BLACK ;10 /14
	;--
	LD	L,A	;7
	LD	A,E	;4
	;-
	DUP	6
	LDI		;16*6=96
	EDUP
	;-
	LD	E,A	;4
BLACK	INC	D	;4
	EXX		;4 /122
	EI
	;--------
	DEC	LX	;8
	JP	NZ,MRT1 ;10 /18
	;------------------
	DI
	EXX
	LD	D,high BUFF
	INC	E
	EXX
	EI
	DEC	HX	;8
	JP	NZ,MRT2 ;10 /18
	;------------------
	LD	SP,0
MRT_SOHR_SP EQU $-2
	RET
	
	
FX_SWAP_PG
	LD	A,(PAGE)
	XOR	#08
	LD	(PAGE),A
	RET

//======================================================== FX_INCLUDE_DATA
	ALIGN	2
ROMBSMAP	INCLUDE "bin/rombs_map.asm"
//======================================================== FX_TABLES
	ALIGN	256
TXCOR	INCLUDE "bin/rombs_txcor.asm"
	ALIGN	256
TBL_ROT INCLUDE "bin/tbl_rot.asm"
TBL_MOV_X INCLUDE "bin/tbl_mov_x.asm"
TBL_MOV_Y INCLUDE "bin/tbl_mov_y.asm"

	ALIGN	256
PAL_A
	DB	0
	DB	#01,#41,#41,#41,#41,#05,#45,#47
	DB	#02,#42,#42,#42,#46,#46,#46,#47
	;DB	#03,#43,#43,#43,#46,#46,#43,#47
	DB	#03,#03,#03,#43,#43,#47,#47,#47
	DB	#04,#44,#44,#44,#44,#44,#44,#47
	ALIGN	256
PAL_B
	DB	0
	DB	#00,#00,#01,#05,#45,#45,#47,#47
	DB	#00,#00,#02,#06,#02,#42,#47,#47
	;DB	#00,#00,#03,#43,#03,#43,#47,#47
	DB	#00,#01,#03,#03,#43,#03,#43,#47
	DB	#00,#00,#04,#05,#44,#45,#47,#47