	DEVICE	ZXSPECTRUM128
;====================================================
; Compile constant declaration
;====================================================
LOW_KERNAL_BEGIN EQU	#6200
FILL_PATTERN	EQU	%01010101	;memory clear pattern for control use undefined memory values
;====================================================
CM_PREVIEW	EQU	0	; compile effect for preview on emulator/real
CM_DEMO		EQU	1	; compile KERNAL and FX for DEMO
MT_PENTAGON	EQU	0	; zx-hardware type
MT_ZX128	EQU	1
MT_ZX2A		EQU	2
;====================================================
T_FX_INI	EQU	0
T_FX_RUN	EQU	1
T_ASM		EQU	2
T_IM2DEMO	EQU	3
T_NEXTFAZE	EQU	4
T_DEPACK	EQU	5
T_FX_NOP	EQU	6
T_SET_INT_PROC	EQU	7
T_CLEAR_INT_PROC EQU	8
;====================================================
; Compile parameters setup
;====================================================
	DEFINE	SHOW_BORDER_ALLOCATION	0
	DEFINE	SHOW_FRAMES	1
MACHINE_TYPE	EQU	MT_PENTAGON
COMPILE_MODE	EQU	CM_PREVIEW	;CM_PREVIEW / CM_DEMO, fx10
	DEFINE	EFFECT	09
	;effect number for "preview/effect" compile mode

;====================================================
; Memory Pages Layout
;====================================================
PGSCR5	EQU	#15
PGSCR7	EQU	#17
PGFAST0	EQU	#10
PGFAST1	EQU	#12
	IF MACHINE_TYPE=MT_PENTAGON OR MACHINE_TYPE=MT_ZX128
PGSLOW0	EQU	#11
PGSLOW1	EQU	#13
PGFAST2	EQU	#14
PGFAST3	EQU	#16
	ENDIF
	IF MACHINE_TYPE=MT_ZX2A
PGSLOW0	EQU	#14
PGSLOW1	EQU	#16
PGFAST2	EQU	#11
PGFAST3	EQU	#13
	ENDIF

;====================================================
;	LOW MEMORY KERNAL (LOW_KERNAL)
;====================================================
		;clear
		ORG	LOW_KERNAL_BEGIN
		DS	#C000 - LOW_KERNAL_BEGIN, FILL_PATTERN
		;compile
		ORG	LOW_KERNAL_BEGIN
		JP	MAIN_DEMO
;====================================================
;	KERNAL ROUTINES (JUMP TABLE)
;====================================================
DEPACK_MLZ	JP	DEPACK_MLZ_
DEPACK_APLIB	JP	DEPACK_APLIB_
DEPACK_PL5	JP	DEPACK_PL5_
CLEAR_RGB	JP	CLEAR_RGB_
INTCORR		JP	INTCORR_
MUSIC_ON	JP	MUSIC_ON_

;====================================================
;	VARIABLES
;====================================================
MUSPOS		DW	0	//   
MUSPOS_LOCAL	DW	0	//     
EFF_FAZE	DB	0
FRAMES_QTY	DB	0
;====================================================
;	DEMO STARTUP PROCEDURE
;====================================================
MAIN_DEMO
	LD	(DEMOSP),SP
	//------ kernal initialization
	CALL	CLEAR_RGB_
	//-------
	DI
	LD	SP,VAR_STACK
	CALL	IM2CORR
	CALL	INTCORR_
	CALL	MUSIC_INIT
	//----- main loop procedure
	LD	IY,EFFTABLE
MLOOP	LD	A,(IY)
	INC	IY
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,COMMTBL	;    
	ADD	HL,BC
	LD	E,(HL)
	INC	L
	LD	D,(HL)
	EX	DE,HL
	LD	DE,MLOOP1
	PUSH	DE
	JP	(HL)		; CALL
MLOOP1	JP	MLOOP

;====================================================
; ROUTINES
;====================================================
MUSIC_ON_
	LD	A,MUS_PAGE
	LD	(MPLPAGE),A
	LD	HL,MUS_PLAY
	LD	(MPLADR),HL
	LD	HL,0
	LD	(MUSPOS),HL
	RET
MUSIC_INIT
	LD	A,MUS_PAGE
	CALL	PAGER
	JP	PLAYER	;MUS_INI
MUS_PLAY_FX //---------------
	PUSH	HL,DE,BC,AF	;44
	EXX			;4
	PUSH	HL,DE,BC	;33 /80
	;--
		LD	HL,FRAMES_QTY
		INC	(HL)
	;--
	LD	HL,(MUSPOS_LOCAL) ;16
	INC	HL		  ;6
	LD	(MUSPOS_LOCAL),HL ;16
	LD	HL,(MUSPOS)	;16
	INC	HL		;6
	LD	(MUSPOS),HL	;16 /38*2=76
	;--
	LD	A,MUS_PAGE	;7
MPLPAGE	EQU	$-1
	LD	BC,#7FFD	;10
	OUT	(C),A		;12
	CALL	MRET		;17-- reg on use: bc,bc`,hl`,de`,a /46 +10jp
	;--
MPLADR	EQU	$-2
	;--
	CALL	MRET
IM2CALL	EQU	$-2
	;--
	LD	A,(PAGE)	;13
	LD	BC,#7FFD	;10
	OUT	(C),A		;12 /35
	;--
	POP	BC,DE,HL	;30
	EXX			;4
	POP	AF,BC,DE,HL	;40
	EI			;4
MRET	RET			;10 /88 //335 + player(1206)=1541 +-    
COMM_DEPACK //---------------
	LD	A,(IY)
	INC	IY
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	EX	DE,HL
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY	
	PUSH	IY
	CALL	PAGER
	CALL	DEPACK_MLZ
	POP	IY
	RET
COMM_INI //---------------
	PUSH	IY
	LD	A,#10
	CALL	PAGER
	CALL	EFF_INI	;init
	POP	IY
	RET
COMM_NEXTFAZE
	LD	HL,EFF_FAZE
	INC	(HL)
	JP	COMM_E2
COMM_EXE //---------------
	XOR	A
	LD	(EFF_FAZE),A
	LD	HL,0
	LD	(MUSPOS_LOCAL),HL
COMM_E2	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	PUSH	IY
COMM_E1	PUSH	DE
	CALL	EFF_RUN
	POP	DE
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,DE
	JP	C,COMM_E1
	POP	IY
	LD	A,#10
	CALL	PAGER
	RET
COMM_NOP //---------------
	LD	HL,0
	LD	(MUSPOS_LOCAL),HL
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
COMM_NOP1
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,DE
	JP	C,COMM_NOP1
	RET
COMM_ASM //-------------   
	PUSH	IY
	POP	HL
	JP	(HL)
	//   :
	;	
	;	LD	IY,$+5
	;	RET
;------
COMM_SET_INT_PROC
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	LD	(IM2CALL),DE
	RET
;------
COMM_CLEAR_INT_PROC
	LD	HL,MRET
	LD	(IM2CALL),HL
	RET
;------
DEPACK_APLIB_
	;PUSH	IY
	;CALL	DEPACK_APLIB_CODE
	;POP	IY
	;RET
DEPACK_APLIB_CODE ;INCLUDE "system/unpack/aplib247b.asm"
;------
DEPACK_PL5_
	PUSH	IY
	CALL	DEPACK_PL5_CODE
	POP	IY
	RET
DEPACK_PL5_CODE
	;INCLUDE "system/unpack/unpletter5c1.asm"
	INCLUDE "system/unpack/unpletter5d_fast_v1.asm"
;------
DEPACK_MLZ_
	;PUSH	IY
	;CALL	DEPACK_MLZ_CODE
	;POP	IY
	;RET
DEPACK_MLZ_CODE ;INCLUDE "system/unpack/unmegalz_fast_v2.asm"
;------
MPLAY	JP	PLAYER+3
;------
CLEAR_RGB_
	EI
	HALT
	LD	A,CLEAR_RGB_COLOR
	OUT	(#FE),A
	LD	A,#17
	CALL	PAGER
	LD	HL,#5800
	LD	DE,#5801
	LD	(HL),CLEAR_RGB_COLOR*8+CLEAR_RGB_COLOR
	LD	BC,767
	LDIR
	LD	HL,#D800
	LD	DE,#D801
	LD	(HL),CLEAR_RGB_COLOR*8+CLEAR_RGB_COLOR
	LD	BC,767
	LDIR
	RET
;-----------------------------
COMMTBL //---
	DW	COMM_INI	;0 init fx
	DW	COMM_EXE	;1 execute fx
	DW	COMM_ASM	;2   
	DW	IM2DEMO		;3  
	DW	COMM_NEXTFAZE	;4      
	DW	COMM_DEPACK	;5   
	DW	COMM_NOP	;6 nop
	DW	COMM_SET_INT_PROC ;7
	DW	COMM_CLEAR_INT_PROC ;8
;====================================================
;	CONST
;====================================================
VAR_STACK	EQU	#BFBF
MUS_PAGE	EQU	PGFAST3;
MUS_PAGE2	EQU	#14;
MUS_PAGE3	EQU	#13;
;MUS_INI	EQU	PLAYER
MUS_PLAY	EQU	MPLAY
PAGE		EQU	#5B5C ;23388 - value saved for port #7FFD
CLEAR_RGB_COLOR	EQU	0

;====================================================
;	TIMELINE
;====================================================
EFFTABLE
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE effects/EFFECT/_timeline.asm
	ENDIF
	IF  COMPILE_MODE=CM_DEMO
		INCLUDE timeline.asm
	ENDIF
;-------------
LOW_KERNAL_END	EQU	$
LOW_KERNAL_SIZE	EQU	LOW_KERNAL_END-LOW_KERNAL_BEGIN
;====================================================
; EFFECT CODE SECTION
;====================================================
	ORG	#8000
EFF_BEGIN
//-----------
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE	effects/EFFECT/effect.asm
	ELSE
		INCLUDE	effects/EFFECT/effect.asm
	ENDIF
//-----------
EFF_END
EFF_SIZE	EQU	EFF_END-EFF_BEGIN
;====================================================
; High memory kernal (HIGH_KERNAL)
;====================================================
//       INT_ROUTINES
	ORG	#BF01
PAGER	LD	BC,#7FFD
	LD	(PAGE),A
	OUT	(C),A
	RET
IM2DEMO DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2DEMO_
	LD	(#BEFF),HL
	RET
IM2CORR	DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
	RET	
//----------
IM2DEMO_
	DI	;4
	JP	MUS_PLAY_FX
IM2_MUSFLAG	EQU	$-2
//---  int`   
INTCORR_ LD BC,#6FF
	;  6 ! (   3)
	; 2  - :
	;1- -    IMER   INT,
	;2- -   D.
	DI
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
IM2BACK	XOR	A
	LD	HL,IM2LOOP ;+2t
	EI
IM2LOOP	DEC	A
	JP	(HL)
	;-1t (INT=11t)
IM2CORR_
	POP	HL	;+2t
	LD	E,(HL)	;-1t
	RL	E	;"JP (HL)">128
	RLA
	LD	E,D
	LD	D,A
	SUB	E
	SUB	C	;   D?
	SBC	A,A
	OR	4	;-1t 4=EXIT,#FF=NO EXIT
	DEC	B	; +1   
	AND	B	;  NO EXIT
	JR	NZ,IM2BACK
	;--
	LD	HL,IM2DEMO_	;10
	LD	(#BEFF),HL	;16
	RET			;10 /36
IM1SET	DI
	LD	IY,#5C3A
	LD	A,#3F
	LD	I,A
	IM	1
	RET
MUS_OFF	LD	E,15
	XOR	A
MUS_OFF_LP
	LD	BC,#FFFD
	OUT	(C),E
	LD	B,#BF
	OUT	(C),A
	DEC	E
	JP	NZ,MUS_OFF_LP
	RET
DEMOSP	DW	0

HI_KERNAL_END




;====================================================
;	INFO
;====================================================
	DISPLAY	"--------------------------------"
	DISPLAY	"LOW_KERN BEGIN: ",/A,#6400
	DISPLAY	"LOW_KERN END: ",/A,LOW_KERNAL_END
	DISPLAY	"LOW_KERN SIZE: ",/A,LOW_KERNAL_SIZE
	DISPLAY	"LOW_KERN FREE: ",/A, (#8000-LOW_KERNAL_END)
	DISPLAY	"HI_KERN END: ",/A,HI_KERNAL_END," (#BFBF max)"
	DISPLAY	"--------------------------------"
	DISPLAY	"EFFECT END: ", /A, EFF_END
	DISPLAY	"EFFECT SIZE: ", /A, EFF_SIZE
	DISPLAY	"EFFECT FREE: ", /A, (#BE00 - EFF_END)
	DISPLAY	"--------------------------------"
	DISPLAY	"MUSPOS_LOCAL: ",/A,MUSPOS_LOCAL
	DISPLAY	"--------------------------------"

;====================================================
;	SAVE FX BINARY CODE & TRY TO COMPRESS
;====================================================
	SAVEBIN	"compile/effect.bin", #8000, EFF_SIZE

;====================================================
;	SAVE PREVIEW
;====================================================
	IF COMPILE_MODE=CM_PREVIEW
		DISPLAY	"PREVIEW EFFECT: ", EFFECT
		DISPLAY " "
		;--------------------------
		IF MACHINE_TYPE=MT_PENTAGON
			EMPTYTRD "demo.trd"
			;----------------------------------------- kernal.low + effect + kernal.hi
			SAVETRD "demo.trd", "EFFECT.C", LOW_KERNAL_BEGIN, #C000 - LOW_KERNAL_BEGIN
			;----------------------------------------- page 0
			ORG	#C000
			DS	16384, FILL_PATTERN
			INCLUDE	effects/EFFECT/eff_page0.asm
			IF $-PG0_BEGIN > 0
				SAVETRD "demo.trd", "PAGE0.C", PG0_BEGIN, $-PG0_BEGIN
				SAVEBIN	"compile/pg0.bin", PG0_BEGIN, $-PG0_BEGIN
			ENDIF
			IF $ = PG0_BEGIN
			  DEFINE PG0_END $
			ELSE
			  DEFINE PG0_END $-1
			ENDIF
			DISPLAY "PAGE_0: ", PG0_BEGIN, "..", PG0_END, "  ", /D, PG0_BEGIN, "..", /D, PG0_END, "\tSIZE: ", /A, ($-PG0_BEGIN)
			;----------------------------------------- page 1
			ORG	#C000
			DS	16384, FILL_PATTERN
			INCLUDE	effects/EFFECT/eff_page1.asm
			IF $-PG1_BEGIN > 0
				SAVETRD "demo.trd", "PAGE1.C", PG1_BEGIN, $-PG1_BEGIN
				SAVEBIN	"compile/pg1.bin", PG1_BEGIN, $-PG1_BEGIN
			ENDIF
			IF $ = PG1_BEGIN
			  DEFINE PG1_END $
			ELSE
			  DEFINE PG1_END $-1
			ENDIF
			DISPLAY "PAGE_1: ", PG1_BEGIN, "..", PG1_END, "  ", /D, PG1_BEGIN, "..", /D, PG1_END, "\tSIZE: ", /A, ($-PG1_BEGIN)
			;----------------------------------------- page 7
			ORG	#C000
			DS	16384, FILL_PATTERN
			INCLUDE	effects/EFFECT/eff_page7.asm
			IF $-PG7_BEGIN > 0
				SAVETRD "demo.trd", "PAGE7.C", PG7_BEGIN, $-PG7_BEGIN
				SAVEBIN	"compile/pg7.bin", PG7_BEGIN, $-PG7_BEGIN
			ENDIF
			IF $ = PG7_BEGIN
			  DEFINE PG7_END $
			ELSE
			  DEFINE PG7_END $-1
			ENDIF
			DISPLAY "PAGE_7: ", PG7_BEGIN, "..", PG7_END, "  ", /D, PG7_BEGIN, "..", /D, PG7_END, "\tSIZE: ", /A, ($-PG7_BEGIN)
			;----------------------------------------- page music
			ORG	#C000
			DS	16384, FILL_PATTERN
			ORG	#C000
			INCLUDE	"music/musicpage.asm"
			SAVETRD "demo.trd","MUSIC.C",#C000,$-#C000
			SAVEBIN "compile/music.bin",#C000,$-#C000
			;----------------------------------------- basic
			ORG	#8000
			DS	2048,0
			ORG	#8000
			INCBIN "bin/basic_trdos_prev.bin"
			SAVETRD "demo.trd","PREVIEW.B",#8000,$-#8000
			DISPLAY " "
			DISPLAY	"--------------------------------"
		ENDIF
		;--------------------------
		IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
				ORG	#C000
			INCLUDE	effects/EFFECT/eff_page0.asm
			SAVEBIN "temp/code.C",#6200,#A000
				ORG	#C000
			INCLUDE	effects/EFFECT/eff_page1.asm
			SAVEBIN "temp/page.C",#C000,#4000
				ORG	#C000
			INCLUDE	"music/musicpage.asm"
MUSBINEND
			SAVEBIN "temp/music.C",#C000,MUSBINEND-#C000

			SHELLEXEC "bin2tap.exe temp\code.C temp\code.tap"
			SHELLEXEC "bin2tap.exe temp\page.C temp\page.tap"
			SHELLEXEC "bin2tap.exe temp\music.C temp\music.tap"

			IF MACHINE_TYPE=MT_ZX128
				SHELLEXEC "system\makeprev128.bat"
			ENDIF
			IF MACHINE_TYPE=MT_ZX2A
				SHELLEXEC "system\makeprev2a.bat"
			ENDIF
		ENDIF
		;--------------------------		
	ENDIF

;====================================================
;	SAVE DEMO
;====================================================
	IF COMPILE_MODE=CM_DEMO
		EMPTYTRD "demo.trd"
		;---
		ORG	#C000
		DS	16384,0
		ORG	#C000
		INCBIN "bin/basic_trdos_demo.bin"
		SAVETRD "demo.trd","MARINOWS.B",#C000,$-#C000
		
		SAVETRD "demo.trd", "PG2.C", LOW_KERNAL_BEGIN, #C000 - LOW_KERNAL_BEGIN
		
		ORG	#DB00
		INCLUDE "page07.asm"
		SAVETRD "demo.trd", "PG7.C", #DB00, $-#DB00
		DISPLAY "PAGE_7_END: ", /A, $
		DISPLAY "PAGE_7_FREE: ", /A, #FFFF - $
		
		ORG	#C000
		INCLUDE "page00.asm"
		SAVETRD "demo.trd", "PG0.C", #C000, $-#C000
		DISPLAY "PAGE_0_END: ", /A, $
		DISPLAY "PAGE_0_FREE: ", /A, #FFFF - $
		
		ORG	#C000
		INCLUDE "page01.asm"
		SAVETRD "demo.trd", "PG1.C", #C000, $-#C000
		DISPLAY "PAGE_1_END: ", /A, $
		DISPLAY "PAGE_1_FREE: ", /A, #FFFF - $
		
		ORG	#C000
		INCLUDE "page03.asm"
		SAVETRD "demo.trd", "PG3.C", #C000, $-#C000
		DISPLAY "PAGE_3_END: ", /A, $
		DISPLAY "PAGE_3_FREE: ", /A, #FFFF - $
		
		ORG	#C000
		INCLUDE "page04.asm"
		SAVETRD "demo.trd", "PG4.C", #C000, $-#C000
		DISPLAY "PAGE_4_END: ", /A, $
		DISPLAY "PAGE_4_FREE: ", /A, #FFFF - $

		ORG	#C000
		INCLUDE "page06.asm"
		SAVETRD "demo.trd", "PG6.C", #C000, $-#C000
		DISPLAY "PAGE_6_END: ", /A, $
		DISPLAY "PAGE_6_FREE: ", /A, #FFFF - $
		;-------------- PART 2
		ORG	#C000
		INCBIN "part2\page0.bin"
		SAVETRD "demo.trd", "PG10.C", #C000, $-#C000

		ORG	#C000
		INCBIN "part2\page1.bin"
		SAVETRD "demo.trd", "PG11.C", #C000, $-#C000
		
		ORG	#C000
		INCBIN "part2\page3.bin"
		SAVETRD "demo.trd", "PG13.C", #C000, $-#C000
		
		ORG	#C000
		INCBIN "part2\page4.bin"
		SAVETRD "demo.trd", "PG14.C", #C000, $-#C000
		
		ORG	#C000
		INCBIN "part2\page6.bin"
		SAVETRD "demo.trd", "PG16.C", #C000, $-#C000
		
		ORG	#8000
		INCBIN "part2\main_fix.bin"
		SAVETRD "demo.trd", "PG12.C", #8000, $-#8000
		

	ENDIF
