<?php
$tokenList = array(
	0xA5 => 'RND',
	0xA6 => 'INKEY$',
	0xA7 => 'PI',
	0xA8 => 'FN',
	0xA9 => 'POINT',
	0xAA => 'SCREEN$',
	0xAB => 'ATTR',
	0xAC => 'AT',
	0xAD => 'TAB',
	0xAE => 'VAL$',
	0xAF => 'CODE',
	//---
	0xB0 => 'VAL',
	0xB1 => 'LEN',
	0xB2 => 'SIN',
	0xB3 => 'COS',
	0xB4 => 'TAN',
	0xB5 => 'ASN',
	0xB6 => 'ACS',
	0xB7 => 'ATN',
	0xB8 => 'LN',
	0xB9 => 'EXP',
	0xBA => 'INT',
	0xBB => 'SQR',
	0xBC => 'SGN',
	0xBD => 'ABS',
	0xBE => 'PEEK',
	0xBF => 'IN',
	//---
	0xC0 => 'USR',
	0xC1 => 'STR$',
	0xC2 => 'CHR$',
	0xC3 => 'NOT',
	0xC4 => 'BIN',
	0xC5 => 'OR',
	0xC6 => 'AND',
	0xC7 => '<=',
	0xC8 => '>=',
	0xC9 => '<>',
	0xCA => 'LINE',
	0xCB => 'THEN',
	0xCC => 'TO',
	0xCD => 'STEP',
	0xCE => 'DEF FN',
	0xCF => 'CAT',
	//---
	0xD0 => 'FORMAT',
	0xD1 => 'MOVE',
	0xD2 => 'ERASE',
	0xD3 => 'OPEN #',
	0xD4 => 'CLOSE #',
	0xD5 => 'MERGE',
	0xD6 => 'VERIFY',
	0xD7 => 'BEEP',
	0xD8 => 'CIRCLE',
	0xD9 => 'INK',
	0xDA => 'PAPER',
	0xDB => 'FLASH',
	0xDC => 'BRIGHT',
	0xDD => 'INVERSE',
	0xDE => 'OVER',
	0xDF => 'OUT',
	//---
	0xE0 => 'LPRINT',
	0xE1 => 'LLIST',
	0xE2 => 'STOP',
	0xE3 => 'READ',
	0xE4 => 'DATA',
	0xE5 => 'RESTORE',
	0xE6 => 'NEW',
	0xE7 => 'BORDER',
	0xE8 => 'CONTINUE',
	0xE9 => 'DIM',
	0xEA => 'REM',
	0xEB => 'FOR',
	0xEC => 'GO TO',
	0xED => 'GO SUB',
	0xEE => 'INPUT',
	0xEF => 'LOAD',
	//---
	0xF0 => 'LIST',
	0xF1 => 'LET',
	0xF2 => 'PAUSE',
	0xF3 => 'NEXT',
	0xF4 => 'POKE',
	0xF5 => 'PRINT',
	0xF6 => 'PLOT',
	0xF7 => 'RUN',
	0xF8 => 'SAVE',
	0xF9 => 'RANDOMIZE',
	0xFA => 'IF',
	0xFB => 'CLS',
	0xFC => 'DRAW',
	0xFD => 'CLEAR',
	0xFE => 'RETURN',
	0xFF => 'COPY',
);

$tokenList = array_flip($tokenList);

$inputFilePath = isset($argv[1]) ? $argv[1] : false;
$outputFilePath = isset($argv[2]) ? $argv[2] : false;

if (empty($inputFilePath)) {
    echo 'ERROR: no input file args';
} elseif (!file_exists($inputFilePath)) {
    echo 'ERROR: input file not found';
}
if (empty($outputFilePath)) {
    echo 'ERROR: no output file args';
}





/*
line format:
2b - line num
2b - length of tex
?? - text
1 - code 13 (enter);

*/

$lastLineAdr = 0;
$basicFile = file_get_contents($inputFilePath);
$basicFile = str_replace("\r\n", "\n", $basicFile);
$basicFile = str_replace("\r", "\n", $basicFile);
$basicFile = explode("\n", $basicFile);
$basicBin = array();

foreach ($basicFile as $ln=>$line) {
	$lineBin = array();
	$line = explode(' ', $line);
	foreach ($line as $i=>$text) {
		if ($i != 0) {
			if (isset($tokenList[$text])) {
				$lineBin[] = $tokenList[$text];
			} else {
				for ($i = 0; $i < strlen($text); $i++) {
					$char = substr($text, $i, 1);
					$lineBin[] = ord($char);
				}
			}
		}
	}
	//---
	$lineBin[] = 0x0D;
	$lineSize = sizeof($lineBin);
	$lineNum = (int)$line[0];
	$basicBin[] = floor($lineNum / 256);
	$basicBin[] = $lineNum % 256;
	if ($ln == sizeof($basicFile) - 1) {
		$lastLineAdr = sizeof($basicBin);
	}
	$basicBin[] = $lineSize % 256;
	$basicBin[] = floor($lineSize / 256);
	foreach ($lineBin as $byte) {
		$basicBin[]	= $byte;
	}
	//---
}
$execAdr = sizeof($basicBin) - 1;

$result = '';
foreach ($basicBin as $byte) {
	$result .= chr($byte);
}
file_put_contents($outputFilePath, $result);
