using System;
using System.Collections.Generic;
using SharpDX;

using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc

namespace Framefield.Core.IDeae71db8_2bdb_47d1_9910_014888f1e55b
{
    public class Class_ReplicateOnCurve : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            Count = 1,
            U = 2,
            Spacing = 3,
            Curve = 4,
            SizeOverTime = 5,
            Scale = 6
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var Count = inputs[(int)InputId.Count].Eval(context).Value;
            var U = inputs[(int)InputId.U].Eval(context).Value;
            var Spacing = inputs[(int)InputId.Spacing].Eval(context).Value;
            var Curve = inputs[(int)InputId.Curve].Eval(context).Dynamic;  // Needs to be checked for null!
            var SizeOverTime = inputs[(int)InputId.SizeOverTime].Eval(context).Dynamic;  // Needs to be checked for null!
            var Scale = inputs[(int)InputId.Scale].Eval(context).Value;
            //<<< _params      

            var sizeOverTime = SizeOverTime as Curve.ICurve;

            var _curve = Curve as ICurveProvider;
            if( _curve == null) {            
                Logger.Warn(this, "Can't render because curve is not connected or invalid");
                return context;
            }


            if (SceneInput.Connections.Count == 0)
            {
                return context;
            }

            //const float toRad = (float) Math.PI/180f;

            var prevTransform = context.ObjectTWorld;
            var u = U;
            
            const float D= 0.01f;

            for (var i = 0; i < Count; ++i)
            {
                //Logger.Info("u:" + u);
                var t = new Vector3();
                var progress = i/Count;
                
                var s = (sizeOverTime != null) 
                        ? (float)sizeOverTime.GetSampledValue(progress)
                        : (float)Math.Sin(progress * 3.1415f);
                
                s *= Scale;
                
                var positionAndRadius = _curve.SampleAt(u);
                var positionAndRadius2 = _curve.SampleAt(u+D);

                var position = new Vector3(positionAndRadius.X, positionAndRadius.Y, positionAndRadius.Z);
                var position2 = new Vector3(positionAndRadius2.X, positionAndRadius2.Y, positionAndRadius2.Z);
                Matrix transform = Matrix.Identity;

                var dir = position2 - position;
                if (dir.Length() > 0)
                {
                    dir.Normalize();
                    var helperDir = new Vector3(0, -1, 0);
                    
                    if (Math.Abs(dir.X) < 0.001 && Math.Abs(dir.Z) < 0.001)
                        helperDir = new Vector3(0, 0, 1);
                        
                    var xAxis = Vector3.Cross(dir, helperDir);
                    xAxis.Normalize();
                    
                    var yAxis = Vector3.Cross(xAxis, dir);
                    yAxis.Normalize();
                    
                    var m = Matrix.Identity;
                    m.Row1 = new Vector4(dir, 0);
                    m.Row2 = new Vector4(yAxis, 0);
                    m.Row3 = new Vector4(xAxis, 0);   // 

                    //m.Row1 = new Vector4(xAxis, 0);
                    //m.Row2 = new Vector4(yAxis, 0);
                    //m.Row3 = new Vector4(dir, 0);   // 
                    transform *= m;
                }
                                                                
                //var t2= Matrix.Translation(new Vector3(OffsetX + (float)(rand.NextDouble() -0.5f) * (OffsetRandomX + Scatter),
                //                                       OffsetY + (float)(rand.NextDouble() -0.5f) * (OffsetRandomY + Scatter),
                //                                       OffsetZ + (float)(rand.NextDouble() -0.5f) * (OffsetRandomZ + Scatter)));
                var tPos= Matrix.Translation(position);
                transform *= tPos;
                //transform = tPos * transform;
                //transform *= Matrix.Transformation(new Vector3(), new Quaternion(), new Vector3(1,1,1), new Vector3(), new Quaternion(), t);




                
                var scale = new Vector3(s, s, s);
                var tScale = Matrix.Scaling( scale.X, scale.Y, scale.Z);
                transform= tScale * transform;
                
                //transform *= prevTransform; 
                context.ObjectTWorld = transform * prevTransform;
                SceneInput.Connections[i%SceneInput.Connections.Count].Eval(context);
                context.ObjectTWorld = prevTransform;
                u += Spacing;
            }

            context.ObjectTWorld = prevTransform;
            return context;
        }

        #region helpers

        public float Lerp(float a, float b, float t)
        {
            return a + t*(b - a);
        }

        public float Interpolate(float a, float b, float t)
        {
            float ft = t*3.1415927f;
            float f = (float) (1.0 - Math.Cos(ft))*0.5f;
            return a*(1.0f - f) + b*f;
        }

      

        #endregion

        private int _seed = 0;
        private float _frequency = 1;
        private float _noiseTime;
    }
}

