//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID10667116_71c4_4260_937b_195fe3322d7e
{
    public class Class_UpdateVariableSet : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IVariableAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Subtree = 0,
            Name = 1,
            Value = 2
        }
        //<<< _inputids

        public string VariableName
        {
            get
            {
                return OperatorPartUtilities.GetInputTextValue(OperatorPart.Connections[(int)InputId.Name]);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Subtree = inputs[(int)InputId.Subtree];
            var Name = inputs[(int)InputId.Name].Eval(context).Text;
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            //<<< _params

            var invalidator = new OperatorPart.InvalidateVariableAccessors(Name);
            Subtree.TraverseWithFunctionUseSpecificBehavior(null, invalidator);
     
            context = Subtree.Eval(context);
 
            if (context.Variables.ContainsKey(Name))
            {
                context.Variables[Name] = Value;
            }
            else
                context.Variables.Add(Name, Value);
            
            return context;
        }
    }
}
