//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID316147b8_ca6c_4f8c_8140_835cb58e0c76
{
    public class Class_TypeWriter : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            String = 0,
            PosStart = 1,
            PosEnd = 2,
            LineWrap = 3
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var String = inputs[(int)InputId.String].Eval(context).Text;
            var PosStart = inputs[(int)InputId.PosStart].Eval(context).Value;
            var PosEnd = inputs[(int)InputId.PosEnd].Eval(context).Value;
            var Pos = new Vector2(PosStart, PosEnd);
            var LineWrap = inputs[(int)InputId.LineWrap].Eval(context).Value;
            //<<< _params

            string segment = String.Substring((int)PosStart, Math.Min(Math.Max(0, ((int)PosEnd - (int)PosStart)), String.Length - (int)PosStart));
            string line = string.Empty;
            string result = string.Empty;
            
            foreach (var word in segment.Split(' '))
            {
                line += word + " ";
                if (line.Length > (int) LineWrap)
                {
                    result += line + "\n";
                    line = string.Empty;
                }
            }
            result += line;
            context.Text = result;
            
            return context;
        }
    }
}

