//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID9f5889d0_a596_432b_ab01_97bd864b613e
{
    public class Class_Twirl : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Strength = 2,
            CenterX = 3,
            RadiusX = 4,
            CenterY = 5,
            RadiusY = 6,
            Offset = 7
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Strength = inputs[(int)InputId.Strength].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var RadiusX = inputs[(int)InputId.RadiusX].Eval(context).Value;
            var RadiusY = inputs[(int)InputId.RadiusY].Eval(context).Value;
            var Radius = new Vector2(RadiusX, RadiusY);
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0,0,0,0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Strength").AsScalar().Set(Strength);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Radius").AsVector().Set(new Vector2(RadiusX, RadiusY));
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

