//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID4c67dea7_5eeb_4b8f_b0f5_ed93e061032e
{
    public class Class_TumblingSquares : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            CenterX = 2,
            CenterY = 3,
            Angle = 4,
            Zoom = 5,
            Mode = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Zoom = inputs[(int)InputId.Zoom].Eval(context).Value;
            var Mode = inputs[(int)InputId.Mode].Eval(context).Value;
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Zoom").AsScalar().Set(Zoom);
                    _effect.GetVariableByName("Mode").AsScalar().Set(Mode);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

