//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID7cfc7245_e0ba_4718_831b_490c032fc835
{
    public class Class_SwitchGizmoUI : OperatorPart.Function,
                                Framefield.Core.OperatorPartTraits.ITraverseModifier
    {
        //>>> _inputids
        private enum InputId
        {
            ShowGizmos = 0,
            GizmoGeometry = 1
        }
        //<<< _inputids

        public IEnumerable<OperatorPart> GetRelevantConnections()
        {
            List<OperatorPart> connections = new List<OperatorPart>();
            
            if( _gizmosAreVisible ) {
                var inputs = OperatorPart.Connections[(int)InputId.GizmoGeometry];
                connections = inputs.Connections.ToList();
            }            
            return connections;
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var ShowGizmos = (int) inputs[(int)InputId.ShowGizmos].Eval(context).Value;
            var GizmoGeometry = inputs[(int)InputId.GizmoGeometry];
            //<<< _params

            var mode = (int)ShowGizmos;
            
            float currentSetting;
            context.Variables.TryGetValue("ShowDebugOverlays", out currentSetting);
            if(float.IsNaN( currentSetting) ) {
                currentSetting = 0;
            }            
            
            if( mode == 2 || GizmoGeometry.Connections.Count == 0) {
                _gizmosAreVisible = false;
                return context;
            }
                            
            if( mode == 0 && currentSetting == 0) {
                _gizmosAreVisible = false;
                return context;
            }
            _gizmosAreVisible = true;
            
            foreach(var input in GizmoGeometry.Connections) {
                input.Eval(context);
            }
            return context;
        }
        
        bool _gizmosAreVisible;
    }
}
