//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDbd7ec6ca_7035_46ce_8a4a_4010576eb97e
{
    public class Class_StabilizeFeedback : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Contrast = 2,
            Brightness = 3,
            Hue = 4,
            Saturation = 5,
            SampleRadius = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
                var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
                var Brightness = inputs[(int)InputId.Brightness].Eval(context).Value;
                var Hue = inputs[(int)InputId.Hue].Eval(context).Value;
                var Saturation = inputs[(int)InputId.Saturation].Eval(context).Value;
                var SampleRadius = inputs[(int)InputId.SampleRadius].Eval(context).Value;
                //<<< _params
                
                if (Image == null)
                    return;

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Brightness").AsScalar().Set(Brightness);
                    _effect.GetVariableByName("Hue").AsScalar().Set(Hue);
                    _effect.GetVariableByName("Saturation").AsScalar().Set(Saturation);
                    _effect.GetVariableByName("SampleRadius").AsScalar().Set(SampleRadius);
                //<<< _setup

                var prevBlendState = context.BlendState;
                context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

                Render(context);

                context.BlendState = prevBlendState;

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
